# -*- coding: utf-8 -*-
"""
/***************************************************************************
 AreaRatioDialog
                                 A QGIS plugin
 Dialog to select layers for area ratio
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2020-11-25
        git sha              : $Format:%H$
        copyright            : (C) 2018 by Zoltan Siki
        email                : siki.zoltan@epito.bme.hu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os
import configparser
from PyQt5 import uic
from PyQt5 import QtWidgets
from qgis.PyQt.QtCore import Qt
from qgis.PyQt.QtWidgets import QMessageBox
from qgis.core import QgsMapLayerProxyModel

FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'arearatio_dialog_base.ui'))


class AreaRatioDialog(QtWidgets.QDialog, FORM_CLASS):
    """ dialog to select parcel and building layers """

    def __init__(self, main, parent=None):
        """Constructor."""
        super(AreaRatioDialog, self).__init__(parent)
        self.main = main
        self.setupUi(self)
        self.loadButton.clicked.connect(self.load_config)
        self.saveButton.clicked.connect(self.save_config)

    def showEvent(self, event):
        """ initialize widgets """
        self.parcelLayerComboBox.setFilters(QgsMapLayerProxyModel.PolygonLayer)
        index = self.parcelLayerComboBox.findText(self.main.parcel)
        if index >= 0:
            self.parcelLayerComboBox.setCurrentIndex(index)
        # remove all building layers
        self.buildingsComboBox.clear()
        # fill combo
        for i in range(0, self.parcelLayerComboBox.count()):
            name = self.parcelLayerComboBox.itemText(i)
            self.buildingsComboBox.addItem(name)
        # select building layers from config
        for in_layer in self.main.buildings:
            index = self.buildingsComboBox.findText(in_layer)
            if index >= 0:
                self.buildingsComboBox.setItemCheckState(index, Qt.CheckState.Checked)

    def load_config(self):
        """ select and load new configuration """
        qfd = QtWidgets.QFileDialog()
        filt = self.main.tr("Config files(*.cfg)")
        title = self.main.tr("Select config file to load")
        f, _ = QtWidgets.QFileDialog.getOpenFileName(qfd, title, ".", filt)
        print(f)
        self.main.parcel, self.main.buildings = self.main.config(f)
        print(self.main.parcel)
        print(self.main.buildings)
        self.showEvent(None)

    def save_config(self):
        """ save config to file """
        qfd = QtWidgets.QFileDialog()
        filt = self.main.tr("Config files(*.cfg)")
        title = self.main.tr("Select config file to save")
        f, _ = QtWidgets.QFileDialog.getSaveFileName(qfd, title, ".", filt)
        print('file: ', f)
        print('buildings: ', ','.join(self.buildingsComboBox.checkedItems()))
        if len(f):
            if not f.endswith('.cfg'):
                f = f + '.cfg'
            index = self.parcelLayerComboBox.currentIndex()
            config = configparser.ConfigParser()
            config['layers'] = {}
            config['layers']['parcel'] = self.parcelLayerComboBox.itemText(index)
            config['layers']['buildings'] = ','.join(self.buildingsComboBox.checkedItems())
            try:
                with open(f, 'w') as configfile:
                    config.write(configfile)
            except:
                QMessageBox.warning(None, self.tr("Area ratio"),
                        self.tr("Permission denied: ".format(f)))
