# -*- coding: utf-8 -*-
"""
/***************************************************************************
 Archiwalna Ortofotomapa
                                 A QGIS plugin
 Pozwala na podczytanie w QGIS archiwalnej ortofotomapy na podstawie usług geoportal.gov.pl
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2020-03-25
        copyright            : (C) 2020 by EnviroSolutions Sp. z o.o.
        email                : office@envirosolutions.pl
        git sha              : $Format:%H$
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
 This script initializes the plugin, making it known to QGIS.
"""

from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication, Qt
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction, QToolBar, QApplication, QWidget, QLabel, QDialog, QComboBox
from PyQt5 import uic
from datetime import datetime
from qgis.core import QgsSettings
from .qgis_feed import QgisFeedDialog
# Initialize Qt resources from file resources.py
from .resources import *
from qgis.core import QgsRasterLayer, QgsProject, Qgis
# Import the code for the DockWidget
from .archiwalna_ortofotomapa_dockwidget import ArchiwalnaOrtofotomapaDockWidget
import os.path
from . import PLUGIN_VERSION as plugin_version

"""Wersja wtyczki"""
plugin_version = '1.0.9'
plugin_name = 'Archiwalna Ortofotomapa'

class ArchiwalnaOrtofotomapa:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """

        self.settings = QgsSettings() 

        if Qgis.QGIS_VERSION_INT >= 31000:
            from .qgis_feed import QgisFeed
            self.selected_industry = self.settings.value("selected_industry", None)
            show_dialog = self.settings.value("showDialog", True, type=bool)

            if self.selected_industry is None and show_dialog:
                self.showBranchSelectionDialog()

            select_indust_session = self.settings.value('selected_industry')

            self.feed = QgisFeed(selected_industry=select_indust_session, plugin_name=plugin_name)
            self.feed.initFeed()

        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)

        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'ArchiwalnaOrtofotomapa_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&EnviroSolutions')
        # TODO: We are going to let the user set this up in a future iteration
        self.toolbar = self.iface.mainWindow().findChild(QToolBar, 'EnviroSolutions')
        if not self.toolbar:
            self.toolbar = self.iface.addToolBar(u'EnviroSolutions')
            self.toolbar.setObjectName(u'EnviroSolutions')

        #print "** INITIALIZING ArchiwalnaOrtofotomapa"

        self.pluginIsActive = False
        self.dockwidget = None

        self.canvas = self.iface.mapCanvas()
        self.orto = None

        # --------------------------------------------------------------------------


    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('ArchiwalnaOrtofotomapa', message)
    

    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):

        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            self.toolbar.addAction(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action


    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/archiwalna_ortofotomapa/icons/archiwalna_logo.svg'
        self.add_action(
            icon_path,
            text=self.tr(u'Archiwalna Ortofotomapa'),
            callback=self.run,
            parent=self.iface.mainWindow())


    def onClosePlugin(self):
        """Cleanup necessary items here when plugin dockwidget is closed"""

        # disconnects
        self.dockwidget.closingPlugin.disconnect(self.onClosePlugin)

        # remove this statement if dockwidget is to remain
        # for reuse if plugin is reopened
        # Commented next statement since it causes QGIS crashe
        # when closing the docked window:
        # self.dockwidget = None

        self.pluginIsActive = False


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""

        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&EnviroSolutions'),
                action)
            #self.iface.removeToolBarIcon(action)
            self.toolbar.removeAction(action)
        # remove the toolbar
        del self.toolbar

    #--------------------------------------------------------------------------


    def run(self):
        """Run method that loads and starts the plugin"""

        if not self.pluginIsActive:
            self.pluginIsActive = True
            #print "** STARTING ArchiwalnaOrtofotomapa"
            if self.orto:
                self.orto.willBeDeleted.disconnect()
            # dockwidget may not exist if:
            #    first run of plugin
            #    removed on close (see self.onClosePlugin method)
            if self.dockwidget == None:
                # Create the dockwidget (after translation) and keep reference
                self.dockwidget = ArchiwalnaOrtofotomapaDockWidget()
            # Eventy
            slider = self.dockwidget.timeSlider
            slider.setMinimum(1997)
            currentYear = datetime.now().year
            slider.setMaximum(currentYear)


            self.isSliderPressed = False

            slider.valueChanged.connect(self.slider_changed)
            slider.sliderReleased.connect(self.slider_released)
            slider.sliderPressed.connect(self.slider_pressed)
            slider.sliderMoved.connect(self.slider_moved)

            # connect to provide cleanup on closing of dockwidget
            self.dockwidget.closingPlugin.connect(self.onClosePlugin)

            # informacje o wersji
            self.dockwidget.setWindowTitle('%s %s' % (plugin_name, plugin_version))
            self.dockwidget.lbl_pluginVersion.setText('%s %s' % (plugin_name, plugin_version))

            # show the dockwidget
            # TODO: fix to allow choice of dock location
            self.iface.addDockWidget(Qt.LeftDockWidgetArea, self.dockwidget)
            self.dockwidget.show()

            self.orto = QgsRasterLayer(self.makeDataSourceUri(slider.value()),
                                       "Ortofotomapa Archiwalna %d" % slider.value(),
                                       'wms')
            self.orto.willBeDeleted.connect(self.orto_removal)
            QgsProject.instance().addMapLayer(self.orto)
        else:
            #reopened
            pass

    def showBranchSelectionDialog(self):
        self.qgisfeed_dialog = QgisFeedDialog()

        if self.qgisfeed_dialog.exec_() == QDialog.Accepted:
            self.selected_branch = self.qgisfeed_dialog.comboBox.currentText()
            
            #Zapis w QGIS3.ini
            self.settings.setValue("selected_industry", self.selected_branch)  
            self.settings.setValue("showDialog", False) 

    def orto_removal(self):
        """Funkcja wyłączająca okno z wtyczką przy usunięciu warstwy z ortofotomapą"""

        self.dockwidget.close()
        self.orto = None


    def slider_changed(self):
        """Funkcja kontroluje rok jaki ma być wyświetlany przy przesuwaniu paska"""

        slider = self.dockwidget.sender()
        self.dockwidget.timeLabel.setText(str(slider.value()))
        if not self.isSliderPressed:
            self.changeOrtoLayer(slider)


    def slider_moved(self):
        """Funkcja nic nie robi jeżeli pasek został przesuniętu"""

        pass


    def slider_pressed(self):
        """Funkcja kontroluje parametr odpowiadający za akcje po wciśnięciu slidera"""

        slider = self.dockwidget.sender()
        self.isSliderPressed = True


    def slider_released(self):
        """Funkcja kontroluje parametr odpowiadający za akcje po puszczeniu slidera"""

        slider = self.dockwidget.sender()
        self.isSliderPressed = False
        self.changeOrtoLayer(slider)


    def changeOrtoLayer(self, slider):
        """Funkcja zmienia nazwę warstwy z orto po zmianie roku który ma wyświetlać"""

        uri = self.makeDataSourceUri(slider.value())
        self.orto.dataProvider().setDataSourceUri(uri)
        self.orto.triggerRepaint()
        # self.orto.dataProvider().reloadData() #QGIS 3.12 and above
        self.orto.setName("Ortofotomapa Archiwalna %d" % slider.value())


    def makeDataSourceUri(self, year):
        """Funkcja edytuje warstwę z orto i zmienia rok, z którego jest ono opracowane"""
        
        serviceUrl = "https://mapy.geoportal.gov.pl/wss/service/PZGIK/ORTO/WMS/StandardResolutionTime"
        return "IgnoreGetFeatureInfoUrl=1&IgnoreGetMapUrl=1&contextualWMSLegend=0&crs=EPSG:2180&format=image/jpeg&layers=Raster&styles=&url=" \
               + serviceUrl + \
               "?TIME=" + \
               str(year) + \
               "-01-01T00%3A00%3A00.000%2B01%3A00"
