# -*- coding: utf-8 -*-
"""
/***************************************************************************
 ArchesProjectDialog
                                 A QGIS plugin
 This plugin links QGIS to an Arches project.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2023-09-15
        git sha              : $Format:%H$
        copyright            : (C) 2023 by Knowledge Integration
        email                : samuel.scandrett@k-int.co.uk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os
from functools import partial

from arches_project.core.views.components.login_autocomplete import (
    load_saved_credentials,
)
from arches_project.core.views.components.multiple_graph_nodes import (
    multiple_geometry_node_check,
)
from arches_project.core.views.components.dialog_updates import connection_reset
from arches_project.core.utils.connection_refresh import connection_refresh
from arches_project.core.views.resources import ResourcesView
from arches_project.core.views.connection import ArchesConnectionView
from arches_project.core.views.stylesheets.stylesheets import Stylesheets

from qgis.PyQt import uic
from qgis.PyQt import QtWidgets

from PyQt5.QtCore import QEvent
from PyQt5.QtWidgets import QLineEdit, QCompleter, QGraphicsOpacityEffect

# This loads your .ui file so that PyQt can populate your plugin with the elements from Qt Designer
FORM_CLASS, _ = uic.loadUiType(
    os.path.join(os.path.dirname(__file__), "arches_project_dialog_base.ui")
)


class ArchesProjectDialog(QtWidgets.QDialog, FORM_CLASS):
    def __init__(self, archesproject, parent=None):
        """Constructor."""
        super(ArchesProjectDialog, self).__init__(parent)
        # Set up the user interface from Designer through FORM_CLASS.
        # After self.setupUi() you can access any designer object by doing
        # self.<objectname>, and you can use autoconnect slots - see
        # http://qt-project.org/doc/qt-4.8/designer-using-a-ui-file.html
        # #widgets-and-dialogs-with-auto-connect
        self.setupUi(self)

        self.iface = archesproject.iface
        self.plugin_dir = archesproject.plugin_dir

        self.dlg_resource_confirmation = archesproject.dlg_resource_confirmation

        # hide refresh confirmation msg
        self.refreshConfirmFrame.hide()

        # Set tab index to 0 always
        self.tabWidget.setCurrentIndex(0)
        self.tabWidget.setTabVisible(1, False)

        ## Set "Create resource" to false to begin with and only update once Arches connection made
        self.createResModelSelectCombo.setEnabled(False)
        self.createResButton.setEnabled(False)
        self.createResFeatureLineEdit.setEnabled(False)
        self.createResFeatureLineEdit.setText(
            "0 features selected. Select features from the map."
        )
        self.createResFeatureSelectButton.setEnabled(False)

        ## Set "Edit Resource" to false to begin with
        self.editResOperationFrame.hide()
        self.editResAddGeom.setEnabled(False)
        self.editResReplaceGeom.setEnabled(False)
        self.editResSelectedResAttributeTable.setEnabled(False)
        self.editResFeatureLineEdit.setText(
            "0 features selected. Select features from the map."
        )
        self.editResFeatureSelectButton.setEnabled(False)

        # Check if selected graph has multiple geometry nodes
        self.createResModelSelectCombo.currentIndexChanged.connect(
            partial(multiple_geometry_node_check, dlg=self)
        )
        # Hide multiple geometry node selection by default
        self.createResNodeSelectFrame.hide()

        # load saved credentials to auto completer
        load_saved_credentials(self)

        # Connection to Arches instance
        self.arches_connection = ArchesConnectionView(
            dlg=self, plugin_dir=self.plugin_dir, iface=self.iface
        )
        self.btnConnect.clicked.connect(self.arches_connection.arches_connection_save)
        self.btnLogout.clicked.connect(
            partial(
                connection_reset,
                hard_reset=True,
                dlg=self,
                iface=self.iface,
                manual_logout=True,
            )
        )

        self.btnRefresh.clicked.connect(partial(connection_refresh, dlg=self))

        # click add button - should bring up new dialog for confirmation
        self.resources_object = ResourcesView(
            dlg=self,
            iface=self.iface,
        )
        self.createResButton.clicked.connect(
            partial(
                self.resources_object.create_resource,
                dlg_resource_confirmation=self.dlg_resource_confirmation,
            )
        )

        self.editResSelectResButton.setEnabled(False)
        self.editResSelectResButton.clicked.connect(
            partial(self.resources_object.register_resource)
        )

        self.editResAddGeom.clicked.connect(
            partial(
                self.resources_object.edit_resource,
                replace=False,
                dlg_resource_confirmation=self.dlg_resource_confirmation,
            )
        )
        self.editResReplaceGeom.clicked.connect(
            partial(
                self.resources_object.edit_resource,
                replace=True,
                dlg_resource_confirmation=self.dlg_resource_confirmation,
            )
        )

        # hide loading wheel adjustments
        self.loadingWheel.hide()  # connection wheel label
        self.updateTextFrame.hide()
        self.loginErrorMessageFrame.hide()
        self.loadingWheelVerticalSpacerFrame.hide()

        # Stylesheets
        self.stylesheets = Stylesheets(
            dlg=self,
            dlg_resource_confirmation=self.dlg_resource_confirmation,
            plugin_dir=self.plugin_dir,
        )

        self.useStylesheetCheckbox.stateChanged.connect(
            partial(
                self.stylesheets.stylesheet_changed,
            )
        )

        self.opacity_effect = QGraphicsOpacityEffect(self.refreshConfirmLabel)
        self.refreshConfirmLabel.setGraphicsEffect(self.opacity_effect)
        # set initial log table widths
        self.activityLogTable.setColumnWidth(0, 100)
        self.activityLogTable.setColumnWidth(1, 100)
        self.activityLogTable.horizontalHeader().setStretchLastSection(True)

        # Change mouse to select from map
        self.createResFeatureSelectButton.clicked.connect(
            self.iface.actionSelect().trigger
        )
        self.editResFeatureSelectButton.clicked.connect(
            self.iface.actionSelect().trigger
        )
