from qgis.PyQt.QtGui import QIcon, QCursor, QPixmap, QTransform
from qgis.PyQt.QtCore import QDir, QSize
from PyQt5.QtCore import Qt

import os


class ArchesStylesheet:
    def __init__(self, dlg, dlg_resource_confirmation, plugin_dir):
        self.dlg = dlg
        self.dlg_resource_confirmation = dlg_resource_confirmation
        self.plugin_dir = plugin_dir

    def arches_stylesheet(self):
        try:
            self.dlg.useStylesheetCheckbox.setChecked(True)
            stylesheet_path = os.path.join(
                self.plugin_dir, "stylesheets", "arches_styling.qss"
            )
            with open(stylesheet_path, "r") as f:
                arches_styling = f.read()

            self.dlg.setStyleSheet(arches_styling)
            self.dlg_resource_confirmation.setStyleSheet(arches_styling)

            QDir.addSearchPath("images", os.path.join(self.plugin_dir, "icons"))

            self.dlg.btnConnect.setIcon(
                QIcon(os.path.join(self.plugin_dir, "icons", "ion-log-in.svg"))
            )
            self.dlg.btnConnect.setIconSize(QSize(12, 12))
            self.dlg.btnConnect.setCursor(QCursor(Qt.PointingHandCursor))

            self.dlg.btnLogout.setIcon(
                QIcon(os.path.join(self.plugin_dir, "icons", "ion-arrow-undo.svg"))
            )
            self.dlg.btnLogout.setIconSize(QSize(12, 12))
            self.dlg.btnLogout.setCursor(QCursor(Qt.PointingHandCursor))

            self.dlg.btnRefresh.setIcon(
                QIcon(
                    os.path.join(
                        self.plugin_dir, "icons", "arrows-rotate-solid-full-white.svg"
                    )
                )
            )
            self.dlg.btnRefresh.setIconSize(QSize(12, 12))
            self.dlg.btnRefresh.setCursor(QCursor(Qt.PointingHandCursor))

            self.dlg.createResButton.setIcon(
                QIcon(os.path.join(self.plugin_dir, "icons", "mdi-pencil.svg"))
            )
            self.dlg.createResButton.setIconSize(QSize(12, 12))
            self.dlg.createResButton.setCursor(QCursor(Qt.PointingHandCursor))

            self.dlg.createResFeatureSelectButton.setIcon(
                QIcon(os.path.join(self.plugin_dir, "icons", "fa-arrow-pointer.svg"))
            )
            self.dlg.createResFeatureSelectButton.setIconSize(QSize(12, 12))
            self.dlg.createResFeatureSelectButton.setCursor(
                QCursor(Qt.PointingHandCursor)
            )

            self.dlg.editResFeatureSelectButton.setIcon(
                QIcon(os.path.join(self.plugin_dir, "icons", "fa-arrow-pointer.svg"))
            )
            self.dlg.editResFeatureSelectButton.setIconSize(QSize(12, 12))
            self.dlg.editResFeatureSelectButton.setCursor(
                QCursor(Qt.PointingHandCursor)
            )

            self.dlg.editResSelectResButton.setIcon(
                QIcon(os.path.join(self.plugin_dir, "icons", "fa-pen-to-square.svg"))
            )
            self.dlg.editResSelectResButton.setIconSize(QSize(12, 12))
            self.dlg.editResSelectResButton.setCursor(QCursor(Qt.PointingHandCursor))

            self.dlg.editResAddGeom.setIcon(
                QIcon(os.path.join(self.plugin_dir, "icons", "fa-plus.svg"))
            )
            self.dlg.editResAddGeom.setIconSize(QSize(12, 12))
            self.dlg.editResAddGeom.setCursor(QCursor(Qt.PointingHandCursor))

            self.dlg.editResReplaceGeom.setIcon(
                QIcon(os.path.join(self.plugin_dir, "icons", "mi-replace.svg"))
            )
            self.dlg.editResReplaceGeom.setIconSize(QSize(12, 12))
            self.dlg.editResReplaceGeom.setCursor(QCursor(Qt.PointingHandCursor))

            self.dlg_resource_confirmation.confirmDialogCancel.setIcon(
                QIcon(os.path.join(self.plugin_dir, "icons", "fa-times.svg"))
            )
            self.dlg_resource_confirmation.confirmDialogCancel.setIconSize(
                QSize(12, 12)
            )
            self.dlg_resource_confirmation.confirmDialogCancel.setCursor(
                QCursor(Qt.PointingHandCursor)
            )

            self.dlg_resource_confirmation.confirmDialogConfirm.setIcon(
                QIcon(os.path.join(self.plugin_dir, "icons", "fa-plus.svg"))
            )
            self.dlg_resource_confirmation.confirmDialogConfirm.setIconSize(
                QSize(12, 12)
            )
            self.dlg_resource_confirmation.confirmDialogConfirm.setCursor(
                QCursor(Qt.PointingHandCursor)
            )

            self.dlg.tabWidget.setDocumentMode(True)

            self.dlg.tabWidget.setTabIcon(
                0,
                QIcon(
                    QPixmap(
                        os.path.join(self.plugin_dir, "icons", "mdi-connection.svg")
                    ).transformed(QTransform().rotate(90))
                ),
            )
            self.dlg.tabWidget.setIconSize(QSize(16, 16))
            self.dlg.tabWidget.setTabText(0, "")

            self.dlg.tabWidget.setTabIcon(
                1,
                QIcon(
                    QPixmap(
                        os.path.join(self.plugin_dir, "icons", "ti-home.svg")
                    ).transformed(QTransform().rotate(90))
                ),
            )
            self.dlg.tabWidget.setIconSize(QSize(16, 16))
            self.dlg.tabWidget.setTabText(1, "")

            self.dlg.tabWidget.setTabIcon(
                2,
                QIcon(
                    QPixmap(
                        os.path.join(self.plugin_dir, "icons", "fa-building.svg")
                    ).transformed(QTransform().rotate(90))
                ),
            )
            self.dlg.tabWidget.setIconSize(QSize(16, 16))
            self.dlg.tabWidget.setTabText(2, "")

            self.dlg.tabWidget.setTabIcon(
                3,
                QIcon(
                    QPixmap(
                        os.path.join(self.plugin_dir, "icons", "mdi-pencil.svg")
                    ).transformed(QTransform().rotate(90))
                ),
            )
            self.dlg.tabWidget.setIconSize(QSize(16, 16))
            self.dlg.tabWidget.setTabText(3, "")

            self.dlg.tabWidget.setTabIcon(
                5,
                QIcon(
                    QPixmap(
                        os.path.join(self.plugin_dir, "icons", "fa-cog.svg")
                    ).transformed(QTransform().rotate(90))
                ),
            )
            self.dlg.tabWidget.setIconSize(QSize(16, 16))
            self.dlg.tabWidget.setTabText(5, "")

            self.dlg.tabWidget.setTabIcon(
                4,
                QIcon(
                    QPixmap(
                        os.path.join(self.plugin_dir, "icons", "ti-ticket.svg")
                    ).transformed(QTransform().rotate(90))
                ),
            )
            self.dlg.tabWidget.setIconSize(QSize(16, 16))
            self.dlg.tabWidget.setTabText(4, "")

            self.dlg.userProfileLabel.setFixedSize(80, 80)
            self.dlg.userProfileLabel.setPixmap(
                QPixmap(os.path.join(self.plugin_dir, "icons", "ion-user.svg")).scaled(
                    50, 50, Qt.KeepAspectRatio
                )
            )
            self.dlg.loginSuccessFrame.hide()

        except:
            # Prevent the use of the Arches stylesheet if error occurs
            self.default_stylesheet()
            self.dlg.useStylesheetCheckbox.setEnabled(False)
            self.dlg.useStylesheetCheckbox.setChecked(False)
