from qgis.core import QgsProcessingProvider
from qgis.PyQt.QtGui import QIcon
import os

from .from_polygon_to_points import PolygonToPointsAlgorithm
from .create_polygon_from_csv import CreatePolygonFromTableAlgorithm
from .export_to_csv import ExportToCSVAlgorithm

class ArcGeekTopoProvider(QgsProcessingProvider):

    def __init__(self):
        super().__init__()

    def loadAlgorithms(self):
        self.addAlgorithm(PolygonToPointsAlgorithm())
        self.addAlgorithm(CreatePolygonFromTableAlgorithm())
        self.addAlgorithm(ExportToCSVAlgorithm())

    def id(self):
        return 'arcgeek'

    def name(self):
        return self.tr('ArcGeek Topo')

    def icon(self):
        icon_path = os.path.join(os.path.dirname(__file__), 'icon.png')
        return QIcon(icon_path)

    def longName(self):
        return self.name()
