# ArcGeek Survey - QGIS Plugin

A QGIS plugin for creating and managing georeferenced surveys with mobile data collection capabilities.

## Features

- **Create Custom Surveys**: Build spatial forms with various field types (text, numbers, dates, etc.)
- **Mobile Data Collection**: GPS-enabled web interface for field data collection
- **Database Integration**: Connect to PostgreSQL/PostGIS databases for advanced spatial analysis
- **Real-time Management**: View, edit, and manage survey responses directly in QGIS
- **Multi-platform**: Compatible with Qt5 and Qt6 for current and future QGIS versions

## Quick Start

1. **Install** the plugin from QGIS Plugin Manager
2. **Create Account** at [acolita.com/survey](https://acolita.com/survey)
3. **Login** in the plugin with your credentials
4. **Create Survey** using the form builder
5. **Collect Data** using the generated mobile-friendly URL
6. **Visualize** responses as layers in QGIS

## Requirements

- QGIS 3.4 or higher
- Internet connection for authentication and data sync
- PostgreSQL/PostGIS database (optional, for advanced features)

## Database Support

- **Free Plan**: Shared database for basic surveys
- **Premium Plans**: Connect your own PostgreSQL/PostGIS database
- **Custom Fields**: Unlimited field types and survey complexity

## Documentation

Visit our [documentation](https://acolita.com/survey) for detailed guides and tutorials.

## Support

- **Issues**: [GitHub Issues](https://github.com/franzpc/arcgeek_survey/issues)
- **Email**: support@arcgeek.com
- **Website**: [acolita.com/survey](https://acolita.com/survey)

## Contributing

Contributions are welcome! Please read our contributing guidelines and submit pull requests.

## License

This plugin is released under the GPL v3 license. See LICENSE file for details.

---

**Note**: This plugin is currently in beta. Features and API may change in future versions.