# Contributing to ArcGeek Survey

Thank you for your interest in contributing to ArcGeek Survey!

## Getting Started

1. Fork the repository
2. Create a feature branch (`git checkout -b feature/amazing-feature`)
3. Make your changes
4. Test your changes with QGIS 3.4+ 
5. Commit your changes (`git commit -m 'Add amazing feature'`)
6. Push to the branch (`git push origin feature/amazing-feature`)
7. Open a Pull Request

## Development Setup

1. Clone your fork locally
2. Install QGIS 3.4 or higher
3. Link the plugin folder to your QGIS plugins directory
4. Enable developer tools in QGIS

## Code Standards

- Follow PEP 8 for Python code
- Use meaningful variable names
- Add comments for complex logic
- Test compatibility with both Qt5 and Qt6

## Testing

- Test the plugin with QGIS 3.4, 3.22, and latest version
- Verify functionality with and without internet connection
- Test database connectivity features
- Ensure UI works on different screen sizes

## Reporting Issues

When reporting issues, please include:
- QGIS version
- Operating system
- Plugin version
- Steps to reproduce
- Error messages (if any)

## Questions?

Feel free to open an issue for questions or contact us at support@arcgeek.com