# -*- coding: utf-8 -*-

"""
/***************************************************************************
 Arc3D
                                 A QGIS plugin
 Tool to convert 2D lines to 3D Arcs
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2024-08-17
        copyright            : (C) 2024 by Shai Sussman
        email                : shai.sussman@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'Shai Sussman'
__date__ = '2024-08-17'
__copyright__ = '(C) 2024 by Shai Sussman'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

from qgis.core import QgsProcessingProvider
from .arc_3d_algorithm import Arc3DAlgorithm
from .arc_3d_algorithm_layer_parameters import Arc3DAlgorithmLayerParameter
from qgis.PyQt.QtGui import QIcon

class Arc3DProvider(QgsProcessingProvider):

    def __init__(self):
        """
        Default constructor.
        """
        QgsProcessingProvider.__init__(self)

    def unload(self):
        """
        Unloads the provider. Any tear-down steps required by the provider
        should be implemented here.
        """
        pass

    def loadAlgorithms(self):
        """
        Loads all algorithms belonging to this provider.
        """
        self.addAlgorithm(Arc3DAlgorithm())
        self.addAlgorithm(Arc3DAlgorithmLayerParameter())
        # add additional algorithms here
        # self.addAlgorithm(MyOtherAlgorithm())

    def id(self):
        """
        Returns the unique provider id, used for identifying the provider. This
        string should be a unique, short, character only string, eg "qgis" or
        "gdal". This string should not be localised.
        """
        return '3D Arcs Creation'

    def name(self):
        """
        Returns the provider name, which is used to describe the provider
        within the GUI.

        This string should be short (e.g. "Lastools") and localised.
        """
        return self.tr('3D Arcs Creation')

    
    def icon(self):
        """Return the icon."""
        return QIcon('icon.png')


    def longName(self):
        """
        Returns the a longer version of the provider name, which can include
        extra details such as version numbers. E.g. "Lastools LIDAR tools
        (version 2.2.1)". This string should be localised. The default
        implementation returns the same string as name().
        """
        return self.name()
    
