# -*- coding: utf-8 -*-
"""
/***************************************************************************
 APNCad
                                 A QGIS plugin
 Applicatif destiné à la prise de notes sur tablette numérique lors des opérations de terrain réalisées pendant le
 remaniement cadastral
 Generated by Plugin Builder: https://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2020-02-24
        git sha              : $Format:%H$
        copyright            : (C) 2020 by Marius François-Marchal
        email                : m.francois.marchal@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
import json
import os.path
import subprocess
from pathlib import Path

from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication, QFileInfo, Qt, QVariant
from qgis.PyQt.QtCore import QUrl, QEvent, QPointF
from qgis.PyQt.QtGui import QDesktopServices, QMouseEvent, QKeyEvent
from qgis.PyQt.QtGui import QIcon, QCursor, QPixmap
from qgis.PyQt.QtWidgets import QAction, QToolButton, QMenu, QLineEdit, QPushButton, QToolBar, QWidget
from qgis.PyQt.QtWidgets import QDockWidget, QFileDialog, QApplication
from qgis.core import (
    QgsCoordinateReferenceSystem,
    QgsProject,
    QgsPointXY,
    QgsGeometry,
    QgsFeature,
    Qgis,
    QgsPoint,
    QgsMapLayer,
    QgsCircularString,
    QgsWkbTypes,
    QgsFields,
    QgsField,
    QgsVectorFileWriter,
    QgsLayerTreeLayer,
    QgsPalLayerSettings,
    QgsTextFormat,
    QgsUnitTypes,
    QgsVectorLayerSimpleLabeling,
)
from qgis.gui import QgsMapToolEmitPoint, QgsMapToolPan
from qgis.utils import iface

# Initialize Qt resources from file resources.py
from .resources import *  # /NOSONAR

from .dialogs.build_layer_dialog import BuildLayerDialog
from .dialogs.choisir_debord_dialog import ChoisirDebordDialog
from .dialogs.clavier_num_dialog import ClavierNumDialog
from .dialogs.config_image_dialog import ConfigImageDialog
from .dialogs.config_points_dialog import ConfigPointsDialog
from .dialogs.crs_dialog import CrsDialog
from .dialogs.editer_image_dialog import EditerImageDialog
from .dialogs.editer_info_dialog import EditerInfoDialog
from .dialogs.entrer_attribut_dialog import EntrerAttributDialog
from .dialogs.liste_point_dialog import ListePointDialog
from .dialogs.recherche_parc_dialog import RechercheParcDialog
from .dialogs.select_feat_dialog import SelectFeatDialog
from .point_map_tool import PointMapTool
from .polygon_map_tool import PolygonMapTool
from .polyline_map_tool import PolylineMapTool


class APNCad:
    """QGIS Plugin Implementation."""

    DRIVER_NAME = "ESRI Shapefile"

    # noinspection PyShadowingNames
    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface

        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value("locale/userLocale")[0:2]
        locale_path = os.path.join(self.plugin_dir, "i18n", "APNCad_{}.qm".format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # list of class variables initialized later in the code
        self.menu = None
        self.general_toolbar = None
        self.start_butt = None
        self.right_clic_widget = None
        self.couche_button = None
        self.visu_button = None
        self.translation_button = None
        self.point_toolbar = None
        self.last_point = None
        self.last_point_widget = None
        self.point_button = None
        self.dessin_toolbar = None
        self.cote_button = None
        self.ligne_button = None
        self.mur_button = None
        self.texte_button = None
        self.symbole_toolbar = None
        self.mur_mit_button = None
        self.borne_button = None
        self.pj_button = None
        self.croquis_toolbar = None
        self.last_num_parc = None
        self.last_num_parc_widget = None
        self.num_parc_button = None
        self.fisc_button = None
        self.dim_texte_button = None
        self.enter_toolbar = None
        self.right_clic = None
        self.touche_echap = None
        self.touche_echap_widget = None
        self.boutton_zoom_plus = None
        self.zoom_plus_widget = None
        self.boutton_main = None
        self.main_widget = None
        self.boutton_zoom_moins = None
        self.zoom_moins_widget = None
        self.boutton_tourner_droite = None
        self.tourner_droite_widget = None
        self.boutton_tourner_gauche = None
        self.tourner_gauche_widget = None
        self.dlg_clavier_num = None
        self.debord = None
        self.dlg_debord = None
        self.dlg_attribut = None
        self.dlg_info = None
        self.dlg_image = None
        self.dlg_config_img = None
        self.dlg_config_pt = None
        self.dlg_num_parc = None
        self.dlg_liste = None
        self.dlg_liste_parc = None
        self.dlg_crs = None
        self.dlg_build_layer = None
        self.dlg_camera = None
        self.available_cameras = None
        self.dlg_parc = None
        self.dlg_near = None

        self.layers = None
        self.current_layer = None
        self.camera = None
        self.capture = None
        self.pointmax = None

        # Nom du groupe parent contenant les sous groupes et les couches du plugin
        self.parent_group_name = "Cad_Dessin"

        # Liste des couches pour construction / reconstruction projet (nom, type, groupe)
        self.list_layers = [
            ("debordT", "Point", "Symbole"),
            ("borne", "Point", "Symbole"),
            ("clotureMit", "Point", "Symbole"),
            ("murmitoyen", "Ligne", "Symbole"),
            ("murnonmi", "Ligne", "Symbole"),
            ("borne_retrouvee", "Point", "Symbole"),
            ("biffer", "Ligne", "Symbole"),
            ("MurDroite", "Ligne", "Dessin"),
            ("Point", "Point", "Dessin"),
            ("Texte", "Point", "Dessin"),
            ("TexteOriente", "Ligne", "Dessin"),
            ("MurMilieu", "Ligne", "Dessin"),
            ("coteSURLigne", "Ligne", "Dessin"),
            ("LigneDiscontinue", "Ligne", "Dessin"),
            ("LigneContinue", "Ligne", "Dessin"),
            ("cotesansligne", "Ligne", "Dessin"),
            ("polygone", "Polygone", "Dessin"),
            ("image", "Point", "Autre"),
            ("HaieNonMit", "Ligne", "Symbole"),
            ("Haiemit", "Ligne", "Symbole"),
            ("Fossenonmit", "Ligne", "Symbole"),
            ("FosseMit", "Ligne", "Symbole"),
            ("Cloturenonmit", "Ligne", "Symbole"),
            ("BornePolygo", "Point", "Symbole"),
            ("clou", "Point", "Symbole"),
            ("clouLimite", "Ligne", "Symbole"),
            ("Coterepere", "Ligne", "Dessin"),
            ("CroixGravee", "Point", "Symbole"),
            ("RepereNivel", "Ligne", "Symbole"),
            ("Das", "Point", "Autre"),
            ("puit", "Point", "Symbole"),
            ("PtDetail", "Point", "Symbole"),
            ("trottoir", "Ligne", "Dessin"),
            ("information", "Point", "Autre"),
            ("Numparc", "Point", "CroquisDelim"),
            ("GrandTexte", "Point", "CroquisDelim"),
            ("Fiscalite", "Ligne", "CroquisDelim"),
            ("LimiteCommune", "Ligne", "CroquisDelim"),
            ("LimiteSection", "Ligne", "CroquisDelim"),
            ("LimiteLieuDit", "Ligne", "CroquisDelim"),
            ("FiscaliteTexte", "Point", "CroquisDelim"),
            ("PetitText", "Point", "CroquisDelim"),
            ("jourdelim", "Point", "Delimitation"),
        ]

        self.crs_dict = {
            "RGF93 / CC43": "EPSG:3943",
            "RGF93 / CC44": "EPSG:3944",
            "RGF93 / CC45": "EPSG:3945",
            "RGF93 / CC46": "EPSG:3946",
            "RGF93 / CC47": "EPSG:3947",
            "RGF93 / CC48": "EPSG:3948",
            "RGF93 / CC49": "EPSG:3949",
            "RGF93 / CC50": "EPSG:3950",
        }

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None

        # num et incrementation initiaux Points
        self.num_point = 0
        self.increment = 1

        # num et incrementation initiaux Num Parcelle
        self.num_parc = 1
        self.inc_parc = 1

        # Plus proche feature
        self.closest_feature_id = None

        # Parametres polyligne
        # attribut sur le segment
        self.attribute = True

        # liste contenant coord points pour cote courbe, translation
        self.point_list = []

        # Variable bool copy for translation
        self.copy = True

        # Liste contenant les plus proches objets
        self.layer_data = []

        # Nombre de points pour la polyligne (infini=100)
        self.nb_pts_poly = 100

        # Camera path to save
        self.image_config_filepath = Path(os.environ["TEMP"]) / "apncad" / "image_config.json"
        self.camera_exe_filepath, self.img_edit_exe_filepath, self.captured_image_dirpath = self.read_image_config()

        # Label settings for proprio label
        label_settings = QgsPalLayerSettings()
        text_format = QgsTextFormat()
        text_format.setSize(0.5)  # value
        text_format.setSizeUnit(QgsUnitTypes.RenderMapUnits)
        label_settings.setFormat(text_format)
        label_settings.fieldName = (
            "\"Code\" || '\n' || \"Propriétaires\" || '\n' || "
            "\"Propriétaires (infos détaillées)\" || '\n' || "
            "\"Contenance\" || ' m2'"
        )
        label_settings.isExpression = True
        self.proprio_label = QgsVectorLayerSimpleLabeling(label_settings)

        # Outils
        self.canvas = self.iface.mapCanvas()

        # Outils de dessin
        # Tracer point
        self.point_tool = PointMapTool(self.canvas)
        self.point_tool.snap_clicked.connect(self.display_point)

        # Tracer num parc
        self.num_parc_tool = PointMapTool(self.canvas)
        self.num_parc_tool.snap_clicked.connect(self.display_num_parc)

        # Pan (main)
        self.tool_pan = QgsMapToolPan(self.canvas)

        # modif attribut
        self.edit_attribute_tool = QgsMapToolEmitPoint(self.canvas)
        # noinspection PyUnresolvedReferences
        self.edit_attribute_tool.canvasClicked.connect(self.edit_attribute)

        # delete point
        self.delete_tool = QgsMapToolEmitPoint(self.canvas)
        # noinspection PyUnresolvedReferences
        self.delete_tool.canvasClicked.connect(self.delete_object)

        # tracer debord
        self.debord_tool = PointMapTool(self.canvas)
        self.debord_tool.snap_clicked.connect(self.display_debord)

        # identifier couche
        self.identify_tool = QgsMapToolEmitPoint(self.canvas)
        # noinspection PyUnresolvedReferences
        self.identify_tool.canvasClicked.connect(self.identify_layer)

        # freeze couche
        self.freeze_tool = QgsMapToolEmitPoint(self.canvas)
        # noinspection PyUnresolvedReferences
        self.freeze_tool.canvasClicked.connect(self.freeze_layer)

        # copier et translater feature
        self.copy_tool = QgsMapToolEmitPoint(self.canvas)
        # noinspection PyUnresolvedReferences
        self.copy_tool.canvasClicked.connect(self.translate_copy_feature)

        # declencher action
        self.action_tool = QgsMapToolEmitPoint(self.canvas)
        # noinspection PyUnresolvedReferences
        self.action_tool.canvasClicked.connect(self.trigger_action)

        # tracer arc (3 pts)
        self.arc_tool = PointMapTool(self.canvas)
        self.arc_tool.snap_clicked.connect(self.display_cote_courbe)

        # tracer polyligne
        self.polyligne_tool = PolylineMapTool(self.canvas)
        self.polyligne_tool.polyline_finished.connect(self.display_feature)
        # self.polyligneTool.snapClicked.connect(self.add_point)

        # tracer polygon
        self.polygon_tool = PolygonMapTool(self.canvas)
        self.polygon_tool.polygon_finished.connect(self.display_feature)

        # tracer entite ponctuelle (1 pt)
        self.punctual_tool = PointMapTool(self.canvas)
        self.punctual_tool.snap_clicked.connect(self.display_punctual)

        # variables utilisees dans le code
        self.actions = {}

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate("APNCad", message)

    def add_action(
        self,
        icon_path,
        text,
        callback,
        key_action,
        toolbar=None,
        toolbutton=None,
        menu=None,
        enabled_flag=False,
        status_tip=None,
        whats_this=None,
        parent=None,
    ):
        """Add a toolbar icon to the toolbar, menu or .

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: () -> None

        :param key_action: Key for the action in actions dictionary
        :type key_action: str

        :param toolbar: Toolbar where the action will be added
        :type toolbar: QToolBar

        :param toolbutton: ToolButton where the action will be added
        :type toolbutton: QToolButton

        :param menu: Menu where the action will be added
        :type menu: QMenu

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to actions dictionary.
        :rtype: QAction
        """

        icon = QIcon()
        pixmap = QPixmap(icon_path)
        # Set the desired icon size
        pixmap = pixmap.scaled(64, 64)
        icon.addPixmap(pixmap)

        action = QAction(icon, text, parent)
        # noinspection PyUnresolvedReferences
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if toolbar is not None:
            toolbar.addAction(action)

        if toolbutton is not None:
            toolbutton.menu().addAction(action)

        if menu is not None:
            self.iface.mainWindow().menuBar().insertMenu(self.iface.firstRightStandardMenu().menuAction(), menu)
            menu.addAction(action)

        self.actions[key_action] = action

        return action

    # noinspection PyPep8Naming
    def initGui(self):  # /NOSONAR
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        # Plugin Menu
        self.menu = QMenu(self.iface.mainWindow())
        self.menu.setObjectName("mAPNMenu")
        self.menu.setTitle("Préparation Delim")
        self.iface.mainWindow().menuBar().insertMenu(self.iface.firstRightStandardMenu().menuAction(), self.menu)

        # choix SCR et enregistrer sous
        icon_path = ":/APNCad/icon/icon34.png"
        self.add_action(
            icon_path,
            text=self.tr("Choisir un SCR"),
            callback=self.set_crs,
            menu=self.menu,
            enabled_flag=True,
            key_action="action_choice_scr",
            parent=self.iface.mainWindow(),
        )

        # action generer ou recharger couche pour nouveau projet (menu uniquement)
        icon_path = ":/APNCad/icon/icon33.png"
        self.add_action(
            icon_path,
            text=self.tr("Générer / recharger les couches"),
            callback=self.config_build_layer,
            menu=self.menu,
            enabled_flag=True,
            key_action="action_generate_layer",
            parent=self.iface.mainWindow(),
        )

        ################################################################################################################
        # Toolbar general
        self.general_toolbar = self.iface.addToolBar("APNCad Général")
        self.general_toolbar.setObjectName("mGeneralToolBar")

        # Widget bouton start
        self.start_butt = QPushButton(self.iface.mainWindow())
        self.start_butt.setFixedWidth(80)
        self.start_butt.setFixedHeight(20)
        self.start_butt.setText("START")
        self.right_clic_widget = self.general_toolbar.addWidget(self.start_butt)
        self.right_clic_widget.setToolTip(self.tr("Start"))
        self.start_butt.clicked.connect(self.start_function)

        # Bouton deroulant couche
        self.couche_button = QToolButton()
        self.couche_button.setMenu(QMenu())
        self.couche_button.setPopupMode(QToolButton.ToolButtonPopupMode.MenuButtonPopup)
        self.general_toolbar.addWidget(self.couche_button)

        # Bouton afficher panneau couche
        icon_path = ":/APNCad/icon/icon28.png"
        self.add_action(
            icon_path,
            text=self.tr("Ouvrir/Fermer le panneau Couches"),
            toolbutton=self.couche_button,
            callback=self.panneau_couche,
            key_action="action_display_panel",
            parent=self.iface.mainWindow(),
        )

        self.couche_button.setDefaultAction(self.actions["action_display_panel"])  # action par default du bouton

        # Bouton identifier couche
        icon_path = ":/APNCad/icon/icon29.png"
        self.add_action(
            icon_path,
            text=self.tr("Identifier la couche d'un objet"),
            toolbutton=self.couche_button,
            callback=self.set_identify_layer_tool,
            key_action="action_identify_layer",
            parent=self.iface.mainWindow(),
        )

        # Bouton deroulant visu couche
        self.visu_button = QToolButton()
        self.visu_button.setMenu(QMenu())
        self.visu_button.setPopupMode(QToolButton.ToolButtonPopupMode.MenuButtonPopup)
        self.general_toolbar.addWidget(self.visu_button)

        # Bouton visu couche text CroqRem
        icon_path = ":/APNCad/icon/icon50.png"
        self.add_action(
            icon_path,
            text=self.tr("Afficher/cacher infos propriétaires"),
            toolbutton=self.visu_button,
            callback=self.visu_info_proprio,
            key_action="action_display_proprio",
            parent=self.iface.mainWindow(),
        )

        self.visu_button.setDefaultAction(self.actions["action_display_proprio"])  # action par default du bouton

        # Bouton visu couche ortho
        icon_path = ":/APNCad/icon/icon51.png"
        self.add_action(
            icon_path,
            text=self.tr("Afficher/cacher Ortho"),
            toolbutton=self.visu_button,
            callback=self.visu_ortho,
            key_action="action_display_ortho",
            parent=self.iface.mainWindow(),
        )

        # Bouton visu couche Ancien_Plan
        icon_path = ":/APNCad/icon/icon71.png"
        self.add_action(
            icon_path,
            text=self.tr("Afficher/cacher Ancien_Plan"),
            toolbutton=self.visu_button,
            callback=self.visu_ancien_plan,
            key_action="action_display_ancien_plan",
            parent=self.iface.mainWindow(),
        )

        # Bouton geler couche
        icon_path = ":/APNCad/icon/icon57.png"
        self.add_action(
            icon_path,
            text=self.tr("Geler la couche d'un objet"),
            toolbutton=self.visu_button,
            callback=self.set_freeze_layer_tool,
            key_action="action_freeze",
            parent=self.iface.mainWindow(),
        )

        # Bouton deroulant translation
        self.translation_button = QToolButton()
        self.translation_button.setMenu(QMenu())
        self.translation_button.setPopupMode(QToolButton.ToolButtonPopupMode.MenuButtonPopup)
        self.general_toolbar.addWidget(self.translation_button)

        # Bouton translater feature
        icon_path = ":/APNCad/icon/icon31.png"
        self.add_action(
            icon_path,
            text=self.tr("Déplacer l'entité"),
            toolbutton=self.translation_button,
            callback=self.set_translation_tool,
            key_action="action_move",
            parent=self.iface.mainWindow(),
        )

        self.translation_button.setDefaultAction(self.actions["action_move"])  # action par default du bouton

        # Bouton copier translater feature
        icon_path = ":/APNCad/icon/icon32.png"
        self.add_action(
            icon_path,
            text=self.tr("Copier et déplacer les entités"),
            toolbutton=self.translation_button,
            callback=self.set_copy_tool,
            key_action="action_copy",
            parent=self.iface.mainWindow(),
        )

        # Bouton delete object
        icon_path = ":/APNCad/icon/icon9.png"
        self.add_action(
            icon_path,
            text=self.tr("Supprimer des entités"),
            callback=self.set_delete_tool,
            toolbar=self.general_toolbar,
            key_action="action_delete",
            parent=self.iface.mainWindow(),
        )

        # Bouton edit object attribute
        icon_path = ":/APNCad/icon/icon10.png"
        self.add_action(
            icon_path,
            text=self.tr("Editer l'attribut d'une entité"),
            callback=self.set_edit_tool,
            toolbar=self.general_toolbar,
            key_action="action_edit",
            parent=self.iface.mainWindow(),
        )

        # bouton sauvegarder toutes les couches
        icon_path = ":/APNCad/icon/icon3.png"
        self.add_action(
            icon_path,
            text=self.tr("Sauvegarde les couches en mode édition"),
            callback=self.save_layers,
            toolbar=self.general_toolbar,
            key_action="action_save",
            parent=self.iface.mainWindow(),
        )

        # bouton rechercher parcelle
        icon_path = ":/APNCad/icon/icon43.png"
        self.add_action(
            icon_path,
            text=self.tr("Rechercher une parcelle"),
            callback=self.rechercher_parc,
            toolbar=self.general_toolbar,
            key_action="action_search_parcel",
            parent=self.iface.mainWindow(),
        )

        # bouton action
        icon_path = ":/APNCad/icon/icon59.png"
        self.add_action(
            icon_path,
            text=self.tr("Exécute l'action d'entité"),
            callback=self.set_action_tool,
            toolbar=self.general_toolbar,
            key_action="action_run_action",
            parent=self.iface.mainWindow(),
        )

        ################################################################################################################
        # Toolbar Point
        self.point_toolbar = self.iface.addToolBar("APNCad Point")
        self.point_toolbar.setObjectName("mPointToolBar")

        # Widget toolbar texte dernier point
        self.last_point = QLineEdit(self.iface.mainWindow())
        self.last_point.setFixedWidth(80)
        self.last_point.setReadOnly(True)
        self.last_point_widget = self.point_toolbar.addWidget(self.last_point)
        self.last_point_widget.setToolTip(self.tr("Numéro point"))

        # Bouton deroulant point
        self.point_button = QToolButton()
        self.point_button.setMenu(QMenu())
        self.point_button.setPopupMode(QToolButton.ToolButtonPopupMode.MenuButtonPopup)
        self.point_toolbar.addWidget(self.point_button)

        # Bouton tracer point
        icon_path = ":/APNCad/icon/icon.png"  # nom tel que defini dans le fichier qrc
        self.add_action(
            icon_path,
            text=self.tr("Tracer Point"),
            toolbutton=self.point_button,
            callback=self.set_point_tool,
            key_action="action_draw_point",
            parent=self.iface.mainWindow(),
        )

        self.point_button.setDefaultAction(self.actions["action_draw_point"])  # action par default du bouton

        # Bouton configurer les points
        icon_path = ":/APNCad/icon/icon2.png"
        self.add_action(
            icon_path,
            text=self.tr("Configurer points"),
            toolbutton=self.point_button,
            callback=self.config_point,
            key_action="action_config_point",
            parent=self.iface.mainWindow(),
        )

        # bouton ouvrir table attribut couche Point
        icon_path = ":/APNCad/icon/icon58.png"
        self.add_action(
            icon_path,
            text=self.tr("Ouvrir la table d'attributs de Point"),
            toolbutton=self.point_button,
            callback=self.open_attribute_table,
            key_action="action_open_table_point",
            parent=self.iface.mainWindow(),
        )

        # bouton annuler dernier point
        icon_path = ":/APNCad/icon/icon7.png"
        self.add_action(
            icon_path,
            text=self.tr("Annuler"),
            callback=self.cancel,
            toolbar=self.point_toolbar,
            key_action="action_cancel_point",
            parent=self.iface.mainWindow(),
        )

        ################################################################################################################
        # Toolbar Dessin
        self.dessin_toolbar = self.iface.addToolBar("APNCad Dessin")
        self.dessin_toolbar.setObjectName("mDessinToolBar")

        # Bouton deroulant cote
        self.cote_button = QToolButton()
        self.cote_button.setMenu(QMenu())
        self.cote_button.setPopupMode(QToolButton.ToolButtonPopupMode.MenuButtonPopup)
        self.dessin_toolbar.addWidget(self.cote_button)

        # bouton coteSurLigne
        icon_path = ":/APNCad/icon/icon12.png"
        self.add_action(
            icon_path,
            text=self.tr("Cote sur ligne"),
            toolbutton=self.cote_button,
            callback=lambda: self.set_general_tool("coteSURLigne", self.cote_button, "action_cote_sur_ligne", True, 2),
            key_action="action_cote_sur_ligne",
            parent=self.iface.mainWindow(),
        )

        self.cote_button.setDefaultAction(self.actions["action_cote_sur_ligne"])  # action par default du bouton

        # bouton coteSansLigne
        icon_path = ":/APNCad/icon/icon11.png"
        self.add_action(
            icon_path,
            text=self.tr("Cote sans ligne"),
            toolbutton=self.cote_button,
            callback=lambda: self.set_general_tool(
                "cotesansligne", self.cote_button, "action_cote_sans_ligne", True, 2
            ),
            key_action="action_cote_sans_ligne",
            parent=self.iface.mainWindow(),
        )

        # bouton cote courbe
        icon_path = ":/APNCad/icon/icon13.png"
        self.add_action(
            icon_path,
            text=self.tr("Cote courbe"),
            toolbutton=self.cote_button,
            callback=self.set_cote_courbe_tool,
            key_action="action_cote_courbe",
            parent=self.iface.mainWindow(),
        )

        # bouton cote repere
        icon_path = ":/APNCad/icon/icon47.png"
        self.add_action(
            icon_path,
            text=self.tr("Cote repère"),
            toolbutton=self.cote_button,
            callback=lambda: self.set_general_tool("Coterepere", self.cote_button, "action_cote_repere", True, 3),
            key_action="action_cote_repere",
            parent=self.iface.mainWindow(),
        )

        # Bouton deroulant ligne
        self.ligne_button = QToolButton()
        self.ligne_button.setMenu(QMenu())
        self.ligne_button.setPopupMode(QToolButton.ToolButtonPopupMode.MenuButtonPopup)
        self.dessin_toolbar.addWidget(self.ligne_button)

        # bouton ligne continue
        icon_path = ":/APNCad/icon/icon14.png"
        self.add_action(
            icon_path,
            text=self.tr("Ligne continue"),
            toolbutton=self.ligne_button,
            callback=lambda: self.set_general_tool(
                "LigneContinue", self.ligne_button, "action_ligne_continue", False, 100
            ),
            key_action="action_ligne_continue",
            parent=self.iface.mainWindow(),
        )

        self.ligne_button.setDefaultAction(self.actions["action_ligne_continue"])  # action par default du bouton

        # bouton ligne discontinue
        icon_path = ":/APNCad/icon/icon15.png"
        self.add_action(
            icon_path,
            text=self.tr("Ligne discontinue"),
            toolbutton=self.ligne_button,
            callback=lambda: self.set_general_tool(
                "LigneDiscontinue", self.ligne_button, "action_ligne_discontinue", False, 100
            ),
            key_action="action_ligne_discontinue",
            parent=self.iface.mainWindow(),
        )

        # bouton trottoir
        icon_path = ":/APNCad/icon/icon55.png"
        self.add_action(
            icon_path,
            text=self.tr("Trottoir"),
            toolbutton=self.ligne_button,
            callback=lambda: self.set_general_tool("trottoir", self.ligne_button, "action_trottoir", False, 100),
            key_action="action_trottoir",
            parent=self.iface.mainWindow(),
        )

        # Bouton deroulant mur dessin
        self.mur_button = QToolButton()
        self.mur_button.setMenu(QMenu())
        self.mur_button.setPopupMode(QToolButton.ToolButtonPopupMode.MenuButtonPopup)
        self.dessin_toolbar.addWidget(self.mur_button)

        # bouton Mur Droite
        icon_path = ":/APNCad/icon/icon16.png"
        self.add_action(
            icon_path,
            text=self.tr("Mur à droite"),
            toolbutton=self.mur_button,
            callback=lambda: self.set_general_tool("MurDroite", self.mur_button, "action_mur_droite", True, 100),
            key_action="action_mur_droite",
            parent=self.iface.mainWindow(),
        )

        self.mur_button.setDefaultAction(self.actions["action_mur_droite"])  # action par default du bouton

        # bouton Mur Milieu
        icon_path = ":/APNCad/icon/icon17.png"
        self.add_action(
            icon_path,
            text=self.tr("Mur au milieu"),
            toolbutton=self.mur_button,
            callback=lambda: self.set_general_tool("MurMilieu", self.mur_button, "action_mur_milieu", True, 100),
            key_action="action_mur_milieu",
            parent=self.iface.mainWindow(),
        )

        # Bouton deroulant texte
        self.texte_button = QToolButton()
        self.texte_button.setMenu(QMenu())
        self.texte_button.setPopupMode(QToolButton.ToolButtonPopupMode.MenuButtonPopup)
        self.dessin_toolbar.addWidget(self.texte_button)

        # bouton Texte
        icon_path = ":/APNCad/icon/icon18.png"
        self.add_action(
            icon_path,
            text=self.tr("Texte"),
            toolbutton=self.texte_button,
            callback=lambda: self.set_general_tool("Texte", self.texte_button, "action_texte", True),
            key_action="action_texte",
            parent=self.iface.mainWindow(),
        )

        self.texte_button.setDefaultAction(self.actions["action_texte"])  # action par default du bouton

        # bouton TexteOriente
        icon_path = ":/APNCad/icon/icon19.png"
        self.add_action(
            icon_path,
            text=self.tr("Texte orienté"),
            toolbutton=self.texte_button,
            callback=lambda: self.set_general_tool("TexteOriente", self.texte_button, "action_texte_oriente", True, 2),
            key_action="action_texte_oriente",
            parent=self.iface.mainWindow(),
        )

        ################################################################################################################
        # Toolbar Symbole
        self.symbole_toolbar = self.iface.addToolBar("APNCad Symbole")
        self.symbole_toolbar.setObjectName("mSymboleToolBar")

        # Bouton deroulant mur symbole
        self.mur_mit_button = QToolButton()
        self.mur_mit_button.setMenu(QMenu())
        self.mur_mit_button.setPopupMode(QToolButton.ToolButtonPopupMode.MenuButtonPopup)
        self.symbole_toolbar.addWidget(self.mur_mit_button)

        # bouton mur mitoyen
        icon_path = ":/APNCad/icon/icon23.png"
        self.add_action(
            icon_path,
            text=self.tr("Mur mitoyen"),
            toolbutton=self.mur_mit_button,
            callback=lambda: self.set_general_tool("murmitoyen", self.mur_mit_button, "action_mur_mitoyen", False, 2),
            key_action="action_mur_mitoyen",
            parent=self.iface.mainWindow(),
        )

        self.mur_mit_button.setDefaultAction(self.actions["action_mur_mitoyen"])  # action par default du bouton

        # bouton mur non mitoyen
        icon_path = ":/APNCad/icon/icon24.png"
        self.add_action(
            icon_path,
            text=self.tr("Mur NON mitoyen"),
            toolbutton=self.mur_mit_button,
            callback=lambda: self.set_general_tool("murnonmi", self.mur_mit_button, "action_mur_nonmitoyen", False, 2),
            key_action="action_mur_nonmitoyen",
            parent=self.iface.mainWindow(),
        )

        # bouton cloture mit
        icon_path = ":/APNCad/icon/icon25.png"
        self.add_action(
            icon_path,
            text=self.tr("Clôture mitoyenne"),
            toolbutton=self.mur_mit_button,
            callback=lambda: self.set_general_tool("clotureMit", self.mur_mit_button, "action_cloture_mit"),
            key_action="action_cloture_mit",
            parent=self.iface.mainWindow(),
        )

        # bouton cloture non mit
        icon_path = ":/APNCad/icon/icon35.png"
        self.add_action(
            icon_path,
            text=self.tr("Clôture NON mitoyenne"),
            toolbutton=self.mur_mit_button,
            callback=lambda: self.set_general_tool(
                "Cloturenonmit", self.mur_mit_button, "action_cloture_nonmit", False, 2
            ),
            key_action="action_cloture_nonmit",
            parent=self.iface.mainWindow(),
        )

        # bouton haie mit
        icon_path = ":/APNCad/icon/icon36.png"
        self.add_action(
            icon_path,
            text=self.tr("Haie mitoyenne"),
            toolbutton=self.mur_mit_button,
            callback=lambda: self.set_general_tool("Haiemit", self.mur_mit_button, "action_haie_mit", False, 2),
            key_action="action_haie_mit",
            parent=self.iface.mainWindow(),
        )

        # bouton haie non mit
        icon_path = ":/APNCad/icon/icon37.png"
        self.add_action(
            icon_path,
            text=self.tr("Haie NON mitoyenne"),
            toolbutton=self.mur_mit_button,
            callback=lambda: self.set_general_tool("HaieNonMit", self.mur_mit_button, "action_haie_nonmit", False, 2),
            key_action="action_haie_nonmit",
            parent=self.iface.mainWindow(),
        )

        # bouton fosse mit
        icon_path = ":/APNCad/icon/icon38.png"
        self.add_action(
            icon_path,
            text=self.tr("Fossé mitoyen"),
            toolbutton=self.mur_mit_button,
            callback=lambda: self.set_general_tool("FosseMit", self.mur_mit_button, "action_fosse_mit", False, 2),
            key_action="action_fosse_mit",
            parent=self.iface.mainWindow(),
        )

        # bouton fosse non mit
        icon_path = ":/APNCad/icon/icon39.png"
        self.add_action(
            icon_path,
            text=self.tr("Fossé NON mitoyen"),
            toolbutton=self.mur_mit_button,
            callback=lambda: self.set_general_tool("Fossenonmit", self.mur_mit_button, "action_fosse_nonmit", False, 2),
            key_action="action_fosse_nonmit",
            parent=self.iface.mainWindow(),
        )

        # Bouton deroulant borne
        self.borne_button = QToolButton()
        self.borne_button.setMenu(QMenu())
        self.borne_button.setPopupMode(QToolButton.ToolButtonPopupMode.MenuButtonPopup)
        self.symbole_toolbar.addWidget(self.borne_button)

        # bouton borne
        icon_path = ":/APNCad/icon/icon21.png"
        self.add_action(
            icon_path,
            text=self.tr("Borne"),
            toolbutton=self.borne_button,
            callback=lambda: self.set_general_tool("borne", self.borne_button, "action_borne"),
            key_action="action_borne",
            parent=self.iface.mainWindow(),
        )

        self.borne_button.setDefaultAction(self.actions["action_borne"])  # action par default du bouton

        # bouton borne retrouvee
        icon_path = ":/APNCad/icon/icon22.png"
        self.add_action(
            icon_path,
            text=self.tr("Borne retrouvée"),
            toolbutton=self.borne_button,
            callback=lambda: self.set_general_tool("borne_retrouvee", self.borne_button, "action_borne_retrouvee"),
            key_action="action_borne_retrouvee",
            parent=self.iface.mainWindow(),
        )

        # bouton borne polygone
        icon_path = ":/APNCad/icon/icon40.png"
        self.add_action(
            icon_path,
            text=self.tr("Borne polygone"),
            toolbutton=self.borne_button,
            callback=lambda: self.set_general_tool("BornePolygo", self.borne_button, "action_borne_polygo", True),
            key_action="action_borne_polygo",
            parent=self.iface.mainWindow(),
        )

        # clou
        icon_path = ":/APNCad/icon/icon41.png"
        self.add_action(
            icon_path,
            text=self.tr("Clou"),
            toolbutton=self.borne_button,
            callback=lambda: self.set_general_tool("clou", self.borne_button, "action_clou", True),
            key_action="action_clou",
            parent=self.iface.mainWindow(),
        )

        # clou Limite
        icon_path = ":/APNCad/icon/icon42.png"
        self.add_action(
            icon_path,
            text=self.tr("Clou limite"),
            toolbutton=self.borne_button,
            callback=lambda: self.set_general_tool("clouLimite", self.borne_button, "action_clou_limite", False, 2),
            key_action="action_clou_limite",
            parent=self.iface.mainWindow(),
        )

        # croix gravee
        icon_path = ":/APNCad/icon/icon45.png"
        self.add_action(
            icon_path,
            text=self.tr("Croix gravée"),
            toolbutton=self.borne_button,
            callback=lambda: self.set_general_tool("CroixGravee", self.borne_button, "action_croix_gravee"),
            key_action="action_croix_gravee",
            parent=self.iface.mainWindow(),
        )

        # repere Nivellement
        icon_path = ":/APNCad/icon/icon46.png"
        self.add_action(
            icon_path,
            text=self.tr("Repère de Nivellement"),
            toolbutton=self.borne_button,
            callback=lambda: self.set_general_tool("RepereNivel", self.borne_button, "action_repere_nivel", True, 2),
            key_action="action_repere_nivel",
            parent=self.iface.mainWindow(),
        )

        # bouton puit
        icon_path = ":/APNCad/icon/icon53.png"
        self.add_action(
            icon_path,
            text=self.tr("Puit"),
            toolbutton=self.borne_button,
            callback=lambda: self.set_general_tool("puit", self.borne_button, "action_puit"),
            key_action="action_puit",
            parent=self.iface.mainWindow(),
        )

        # bouton ptDetail
        icon_path = ":/APNCad/icon/icon54.png"
        self.add_action(
            icon_path,
            text=self.tr("Point Détail"),
            toolbutton=self.borne_button,
            callback=lambda: self.set_general_tool("PtDetail", self.borne_button, "action_point_detail", True),
            key_action="action_point_detail",
            parent=self.iface.mainWindow(),
        )

        # Bouton deroulant piece jointe
        self.pj_button = QToolButton()
        self.pj_button.setMenu(QMenu())
        self.pj_button.setPopupMode(QToolButton.ToolButtonPopupMode.MenuButtonPopup)
        self.symbole_toolbar.addWidget(self.pj_button)

        # bouton image
        icon_path = ":/APNCad/icon/icon27.png"
        self.add_action(
            icon_path,
            text=self.tr("Image"),
            toolbutton=self.pj_button,
            callback=lambda: self.set_general_tool("image", self.pj_button, "action_image", True),
            key_action="action_image",
            parent=self.iface.mainWindow(),
        )

        self.pj_button.setDefaultAction(self.actions["action_image"])  # action par default du bouton

        # Bouton configurer image
        icon_path = ":/APNCad/icon/icon72.png"
        self.add_action(
            icon_path,
            text=self.tr("Configurer image"),
            toolbutton=self.pj_button,
            callback=self.config_image,
            key_action="action_config_image",
            parent=self.iface.mainWindow(),
        )

        # bouton Das
        icon_path = ":/APNCad/icon/icon52.png"
        self.add_action(
            icon_path,
            text=self.tr("Das"),
            toolbutton=self.pj_button,
            callback=self.set_das_tool,
            key_action="action_das",
            parent=self.iface.mainWindow(),
        )

        # bouton info
        icon_path = ":/APNCad/icon/icon56.png"
        self.add_action(
            icon_path,
            text=self.tr("Information"),
            toolbutton=self.pj_button,
            callback=self.set_info_tool,
            key_action="action_info",
            parent=self.iface.mainWindow(),
        )

        # bouton Debord de toit
        icon_path = ":/APNCad/icon/icon20.png"
        self.add_action(
            icon_path,
            text=self.tr("Débord de toit"),
            callback=self.set_debord_tool,
            toolbar=self.symbole_toolbar,
            key_action="action_debord_toit",
            parent=self.iface.mainWindow(),
        )

        # bouton biffer
        icon_path = ":/APNCad/icon/icon26.png"
        self.add_action(
            icon_path,
            text=self.tr("Biffer"),
            callback=lambda: self.set_general_tool("biffer", attribute=False, nb_points_polyline=2),
            toolbar=self.symbole_toolbar,
            key_action="action_biffer",
            parent=self.iface.mainWindow(),
        )

        # bouton polygone
        icon_path = ":/APNCad/icon/icon30.png"
        self.add_action(
            icon_path,
            text=self.tr("Polygone"),
            callback=self.set_polygone_tool,
            toolbar=self.symbole_toolbar,
            key_action="action_polygone",
            parent=self.iface.mainWindow(),
        )

        ################################################################################################################
        # Toolbar CroquisDelim
        self.croquis_toolbar = self.iface.addToolBar("APNCad CroquisDelim")
        self.croquis_toolbar.setObjectName("mCroquisToolBar")

        # Widget toolbar lineedit dernier num parcelle
        self.last_num_parc = QLineEdit(self.iface.mainWindow())
        self.last_num_parc.setFixedWidth(80)
        self.last_num_parc.setReadOnly(True)
        self.last_num_parc_widget = self.croquis_toolbar.addWidget(self.last_num_parc)
        self.last_num_parc_widget.setToolTip(self.tr("Numéro parcelle"))

        # Bouton deroulant num parcelle
        self.num_parc_button = QToolButton()
        self.num_parc_button.setMenu(QMenu())
        self.num_parc_button.setPopupMode(QToolButton.ToolButtonPopupMode.MenuButtonPopup)
        self.croquis_toolbar.addWidget(self.num_parc_button)

        # tracer num parc
        icon_path = ":/APNCad/icon/icon60.png"
        self.add_action(
            icon_path,
            text=self.tr("Tracer numéro de parcelle"),
            toolbutton=self.num_parc_button,
            callback=self.set_num_parc_tool,
            key_action="action_tracer_numparc",
            parent=self.iface.mainWindow(),
        )

        self.num_parc_button.setDefaultAction(self.actions["action_tracer_numparc"])  # action par default du bouton

        # configurer num parc
        icon_path = ":/APNCad/icon/icon61.png"
        self.add_action(
            icon_path,
            text=self.tr("Configurer numéros de parcelle"),
            toolbutton=self.num_parc_button,
            callback=self.config_num_parc,
            key_action="action_config_numparc",
            parent=self.iface.mainWindow(),
        )

        # bouton ouvrir table attribut couche Numparc
        icon_path = ":/APNCad/icon/icon62.png"
        self.add_action(
            icon_path,
            text=self.tr("Ouvrir la table d'attributs de Numparc"),
            toolbutton=self.num_parc_button,
            callback=self.open_num_parc_attribute_table,
            key_action="action_open_table_numparc",
            parent=self.iface.mainWindow(),
        )

        # bouton annuler dernier num parc
        icon_path = ":/APNCad/icon/icon63.png"
        self.add_action(
            icon_path,
            text=self.tr("Annuler numéro de parcelle"),
            callback=self.cancel_num_parc,
            toolbar=self.croquis_toolbar,
            key_action="action_cancel_numparc",
            parent=self.iface.mainWindow(),
        )

        # Bouton deroulant fiscalite
        self.fisc_button = QToolButton()
        self.fisc_button.setMenu(QMenu())
        self.fisc_button.setPopupMode(QToolButton.ToolButtonPopupMode.MenuButtonPopup)
        self.croquis_toolbar.addWidget(self.fisc_button)

        # bouton fiscalite
        icon_path = ":/APNCad/icon/icon67.png"
        self.add_action(
            icon_path,
            text=self.tr("Limite de subdivision fiscale"),
            toolbutton=self.fisc_button,
            callback=lambda: self.set_general_tool("Fiscalite", self.fisc_button, "action_fiscalite", False, 100),
            key_action="action_fiscalite",
            parent=self.iface.mainWindow(),
        )

        self.fisc_button.setDefaultAction(self.actions["action_fiscalite"])  # action par default du bouton

        # bouton FiscaliteTexte
        icon_path = ":/APNCad/icon/icon69.png"
        self.add_action(
            icon_path,
            text=self.tr("Texte de subdivision fiscale"),
            toolbutton=self.fisc_button,
            callback=lambda: self.set_general_tool("FiscaliteTexte", self.fisc_button, "action_fiscalite_texte", True),
            key_action="action_fiscalite_texte",
            parent=self.iface.mainWindow(),
        )

        # bouton LimiteCommune
        icon_path = ":/APNCad/icon/icon64.png"
        self.add_action(
            icon_path,
            text=self.tr("Limite de commune"),
            callback=lambda: self.set_general_tool("LimiteCommune", attribute=False, nb_points_polyline=100),
            toolbar=self.croquis_toolbar,
            key_action="action_limite_commune",
            parent=self.iface.mainWindow(),
        )

        # bouton LimiteSection
        icon_path = ":/APNCad/icon/icon65.png"
        self.add_action(
            icon_path,
            text=self.tr("Limite de section"),
            callback=lambda: self.set_general_tool("LimiteSection", attribute=False, nb_points_polyline=100),
            toolbar=self.croquis_toolbar,
            key_action="action_limite_section",
            parent=self.iface.mainWindow(),
        )

        # bouton LimiteLieudit
        icon_path = ":/APNCad/icon/icon66.png"
        self.add_action(
            icon_path,
            text=self.tr("Limite de lieu-dit"),
            callback=lambda: self.set_general_tool("LimiteLieuDit", attribute=False, nb_points_polyline=100),
            toolbar=self.croquis_toolbar,
            key_action="action_limite_lieudit",
            parent=self.iface.mainWindow(),
        )

        # Bouton deroulant petit-grand texte
        self.dim_texte_button = QToolButton()
        self.dim_texte_button.setMenu(QMenu())
        self.dim_texte_button.setPopupMode(QToolButton.ToolButtonPopupMode.MenuButtonPopup)
        self.croquis_toolbar.addWidget(self.dim_texte_button)

        # bouton GrandTexte
        icon_path = ":/APNCad/icon/icon68.png"
        self.add_action(
            icon_path,
            text=self.tr("Tracer un grand texte"),
            toolbutton=self.dim_texte_button,
            callback=lambda: self.set_general_tool("GrandTexte", self.dim_texte_button, "action_grand_texte", True),
            key_action="action_grand_texte",
            parent=self.iface.mainWindow(),
        )

        self.dim_texte_button.setDefaultAction(self.actions["action_grand_texte"])

        # bouton PetitTexte
        icon_path = ":/APNCad/icon/icon70.png"
        self.add_action(
            icon_path,
            text=self.tr("Tracer un petit texte"),
            toolbutton=self.dim_texte_button,
            callback=lambda: self.set_general_tool("PetitText", self.dim_texte_button, "action_petit_texte", True),
            key_action="action_petit_texte",
            parent=self.iface.mainWindow(),
        )

        ################################################################################################################
        # Toolbar entree et zoom
        self.enter_toolbar = self.iface.addToolBar("APNCad Navigation")
        self.enter_toolbar.setObjectName("mNavigationToolBar")

        # Widget toolbar clic droit (stop trace polyligne)
        self.right_clic = QPushButton(self.iface.mainWindow())
        self.right_clic.setFixedWidth(151)
        self.right_clic.setFixedHeight(51)
        enter_icon = QIcon(":/APNCad/icon/icon4.png")
        self.right_clic.setIcon(enter_icon)
        self.right_clic.setText("CLIC DROIT")
        self.right_clic_widget = self.enter_toolbar.addWidget(self.right_clic)
        self.right_clic_widget.setToolTip(self.tr("Clic droit"))
        self.right_clic.clicked.connect(self.clic_droit)

        # Widget toolbar touche echap
        self.touche_echap = QPushButton(self.iface.mainWindow())
        self.touche_echap.setFixedWidth(60)
        self.touche_echap.setFixedHeight(51)
        self.touche_echap.setText("Esc")
        self.touche_echap_widget = self.enter_toolbar.addWidget(self.touche_echap)
        self.touche_echap_widget.setToolTip(self.tr("Touche ECHAP"))
        self.touche_echap.clicked.connect(self.appui_echap)

        # Widget toolbar zoom+
        self.boutton_zoom_plus = QPushButton(self.iface.mainWindow())
        self.boutton_zoom_plus.setFixedWidth(60)
        self.boutton_zoom_plus.setFixedHeight(51)
        zoom_plus_icon = QIcon(":/APNCad/icon/icon5.png")
        self.boutton_zoom_plus.setIcon(zoom_plus_icon)
        self.zoom_plus_widget = self.enter_toolbar.addWidget(self.boutton_zoom_plus)
        self.zoom_plus_widget.setToolTip(self.tr("Zoom +"))
        self.boutton_zoom_plus.clicked.connect(self.zoom_plus)

        # Widget main
        self.boutton_main = QPushButton(self.iface.mainWindow())
        self.boutton_main.setFixedWidth(60)
        self.boutton_main.setFixedHeight(51)
        main_icon = QIcon(":/APNCad/icon/icon8.png")
        self.boutton_main.setIcon(main_icon)
        self.main_widget = self.enter_toolbar.addWidget(self.boutton_main)
        self.main_widget.setToolTip(self.tr("Se déplacer dans la carte"))
        self.boutton_main.clicked.connect(self.outil_main)

        # Widget toolbar zoom-
        self.boutton_zoom_moins = QPushButton(self.iface.mainWindow())
        self.boutton_zoom_moins.setFixedWidth(60)
        self.boutton_zoom_moins.setFixedHeight(51)
        zoom_moins_icon = QIcon(":/APNCad/icon/icon6.png")
        self.boutton_zoom_moins.setIcon(zoom_moins_icon)
        self.zoom_moins_widget = self.enter_toolbar.addWidget(self.boutton_zoom_moins)
        self.zoom_moins_widget.setToolTip(self.tr("Zoom -"))
        self.boutton_zoom_moins.clicked.connect(self.zoom_moins)

        # Widget toolbar tourner droite
        self.boutton_tourner_droite = QPushButton(self.iface.mainWindow())
        self.boutton_tourner_droite.setFixedWidth(30)
        self.boutton_tourner_droite.setFixedHeight(51)
        tourner_droite_icon = QIcon(":/APNCad/icon/icon48.png")
        self.boutton_tourner_droite.setIcon(tourner_droite_icon)
        self.tourner_droite_widget = self.enter_toolbar.addWidget(self.boutton_tourner_droite)
        self.tourner_droite_widget.setToolTip(self.tr("Rotation droite"))
        self.boutton_tourner_droite.clicked.connect(lambda: self.rotate(10))

        # Widget toolbar tourner gauche
        self.boutton_tourner_gauche = QPushButton(self.iface.mainWindow())
        self.boutton_tourner_gauche.setFixedWidth(30)
        self.boutton_tourner_gauche.setFixedHeight(51)
        tourner_gauche_icon = QIcon(":/APNCad/icon/icon49.png")
        self.boutton_tourner_gauche.setIcon(tourner_gauche_icon)
        self.tourner_gauche_widget = self.enter_toolbar.addWidget(self.boutton_tourner_gauche)
        self.tourner_gauche_widget.setToolTip(self.tr("Rotation gauche"))
        self.boutton_tourner_gauche.clicked.connect(lambda: self.rotate(-10))

        ################################################################################################################
        # Dialog configuration

        # clavier num
        self.dlg_clavier_num = ClavierNumDialog()
        self.dlg_clavier_num.setFixedSize(377, 324)
        self.dlg_clavier_num.pushButton_0.clicked.connect(lambda: self.key_value("0"))
        self.dlg_clavier_num.pushButton_1.clicked.connect(lambda: self.key_value("1"))
        self.dlg_clavier_num.pushButton_2.clicked.connect(lambda: self.key_value("2"))
        self.dlg_clavier_num.pushButton_3.clicked.connect(lambda: self.key_value("3"))
        self.dlg_clavier_num.pushButton_4.clicked.connect(lambda: self.key_value("4"))
        self.dlg_clavier_num.pushButton_5.clicked.connect(lambda: self.key_value("5"))
        self.dlg_clavier_num.pushButton_6.clicked.connect(lambda: self.key_value("6"))
        self.dlg_clavier_num.pushButton_7.clicked.connect(lambda: self.key_value("7"))
        self.dlg_clavier_num.pushButton_8.clicked.connect(lambda: self.key_value("8"))
        self.dlg_clavier_num.pushButton_9.clicked.connect(lambda: self.key_value("9"))
        self.dlg_clavier_num.pushButton_coma.clicked.connect(lambda: self.key_value("."))
        self.dlg_clavier_num.pushButton_del.clicked.connect(self.key_del)

        # parametre debordT
        self.debord = "0"
        self.dlg_debord = ChoisirDebordDialog()
        self.dlg_debord.setFixedSize(854, 155)
        self.dlg_debord.pushButton_0.clicked.connect(lambda: self.set_debord("0"))
        self.dlg_debord.pushButton_10.clicked.connect(lambda: self.set_debord("10"))
        self.dlg_debord.pushButton_20.clicked.connect(lambda: self.set_debord("20"))
        self.dlg_debord.pushButton_30.clicked.connect(lambda: self.set_debord("30"))
        self.dlg_debord.pushButton_40.clicked.connect(lambda: self.set_debord("40"))
        self.dlg_debord.pushButton_50.clicked.connect(lambda: self.set_debord("50"))
        self.dlg_debord.pushButton_60.clicked.connect(lambda: self.set_debord("60"))
        self.dlg_debord.pushButton_70.clicked.connect(lambda: self.set_debord("70"))
        self.dlg_debord.pushButton_80.clicked.connect(lambda: self.set_debord("80"))
        self.dlg_debord.pushButton_90.clicked.connect(lambda: self.set_debord("90"))

        self.dlg_debord.pushButton_clavier.clicked.connect(lambda: self.clavier_num(self.dlg_debord.lineedit_debord))

        # Fenetre entrer attribut (cote, modifier)
        self.dlg_attribut = EntrerAttributDialog()
        self.dlg_attribut.pushButton_clavier.clicked.connect(
            lambda: self.clavier_num(self.dlg_attribut.lineedit_attribut)
        )
        # lecture des attributs dans fichier txt
        with open(os.path.join(self.plugin_dir, "attribut_texte.txt")) as file_txt:
            txt = file_txt.read()
        list_attributes = txt.split("\n")
        self.dlg_attribut.comboBox_texte.addItems(list_attributes)
        self.dlg_attribut.comboBox_texte.activated.connect(
            lambda: self.fill_from_combo(self.dlg_attribut.comboBox_texte, self.dlg_attribut.lineedit_attribut)
        )
        self.dlg_attribut.comboBox_field.currentIndexChanged.connect(
            lambda: self.select_attribute_field(self.dlg_attribut.lineedit_attribut, self.dlg_attribut.comboBox_field)
        )

        # Fenetre editer info
        self.dlg_info = EditerInfoDialog()
        self.dlg_info.setFixedSize(425, 276)

        # Fenetre editer image
        self.dlg_image = EditerImageDialog()
        self.dlg_image.pbutton_take_picture.clicked.connect(self.open_camera)
        self.dlg_image.pbutton_auto_fill.clicked.connect(self.fill_last_picture)
        self.dlg_image.pbutton_browse.clicked.connect(
            lambda: self.browse_file(
                self.dlg_image.lineedit_attribut,
                "Image files (*.jpg *.png *.jpeg *.bmp *.gif *.tiff *.webp);;PDF files (*.pdf)",
                self.captured_image_dirpath,
            )
        )
        self.dlg_image.pbutton_edit_img.clicked.connect(self.open_edit_img_app)
        self.dlg_image.pushButton_clavier.clicked.connect(lambda: self.clavier_num(self.dlg_image.lineedit_attribut))
        self.dlg_image.comboBox_field.currentIndexChanged.connect(
            lambda: self.select_attribute_field(self.dlg_image.lineedit_attribut, self.dlg_image.comboBox_field)
        )

        # Fenetre config images
        self.dlg_config_img = ConfigImageDialog()
        self.dlg_config_img.pbutton_browse_cam.clicked.connect(
            lambda: self.browse_file(self.dlg_config_img.lineedit_cam_path, "Executable Files (*.exe);;All Files (*)")
        )
        self.dlg_config_img.checkbox_win_cam.toggled.connect(self.on_checkbox_wincam_toggled)

        self.dlg_config_img.pbutton_browse_img_edit.clicked.connect(
            lambda: self.browse_file(
                self.dlg_config_img.lineedit_img_edit_path, "Executable Files (*.exe);;All Files (*)"
            )
        )
        self.dlg_config_img.checkbox_win_edit_img.toggled.connect(self.on_checkbox_winedit_toggled)

        self.dlg_config_img.pbutton_browse_savedir.clicked.connect(
            lambda: self.browse_folder(self.dlg_config_img.lineedit_savedir)
        )

        # Fenetre parametres point
        self.dlg_config_pt = ConfigPointsDialog()
        self.dlg_config_pt.setFixedSize(477, 141)  # empeche redimensionnement fenetre
        self.dlg_config_pt.pushButton_clavierNum.clicked.connect(
            lambda: self.clavier_num(self.dlg_config_pt.lineedit_numin)
        )
        self.dlg_config_pt.pushButton_clavierInc.clicked.connect(
            lambda: self.clavier_num(self.dlg_config_pt.lineedit_inc)
        )
        self.dlg_config_pt.button_resumeNum.clicked.connect(lambda: self.resume_num("point"))

        # Fenetre parametres num parc
        self.dlg_num_parc = ConfigPointsDialog()
        self.dlg_num_parc.setFixedSize(477, 141)  # empeche redimensionnement fenetre
        self.dlg_num_parc.pushButton_clavierNum.clicked.connect(
            lambda: self.clavier_num(self.dlg_num_parc.lineedit_numin)
        )
        self.dlg_num_parc.pushButton_clavierInc.clicked.connect(
            lambda: self.clavier_num(self.dlg_num_parc.lineedit_inc)
        )
        self.dlg_num_parc.button_resumeNum.clicked.connect(lambda: self.resume_num("parcelle"))

        # Fenetre liste points
        self.dlg_liste = ListePointDialog()
        self.dlg_liste.setFixedSize(322, 352)

        # Fenetre liste points parc
        self.dlg_liste_parc = ListePointDialog()
        self.dlg_liste_parc.setFixedSize(322, 352)

        # Fenetre choix SCR
        self.dlg_crs = CrsDialog()
        self.dlg_crs.setFixedSize(453, 190)
        self.dlg_crs.comboBox_crs.addItems(self.crs_dict.keys())
        self.dlg_crs.lineEdit_path.setReadOnly(True)
        self.dlg_crs.pushButton_saveAs.clicked.connect(self.save_project)

        # Fenetre construction couches
        self.dlg_build_layer = BuildLayerDialog()
        self.dlg_build_layer.setFixedSize(621, 242)
        self.dlg_build_layer.lineEdit_path.setReadOnly(True)
        self.dlg_build_layer.build_layer_button.clicked.connect(self.build_layer)
        self.dlg_build_layer.cancel_build_button.clicked.connect(lambda: self.dlg_build_layer.close())
        self.dlg_build_layer.build_pg_bar.setValue(0)

        # Put the CRS window on the foreground when project saved
        self.iface.actionSaveProjectAs().triggered.connect(self.set_crs_on_top)

        # Fenetre recherche parcelle
        self.dlg_parc = RechercheParcDialog()
        self.dlg_parc.setFixedSize(463, 179)
        self.dlg_parc.pushButton_clavierNum.clicked.connect(lambda: self.clavier_num(self.dlg_parc.LineEdit_parc))

        # Fenetre suppression
        self.dlg_near = SelectFeatDialog()
        self.dlg_near.setFixedSize(546, 409)
        self.dlg_near.pushButton_select.clicked.connect(self.select_feat)

        # will be set False in config_point()
        self.first_start = True

    # remettre la fenetre au premier plan apres enregistrement
    def set_crs_on_top(self):
        if not self.dlg_crs.isHidden():
            self.dlg_crs.activateWindow()
            path_proj = QgsProject.instance().fileName()
            self.dlg_crs.lineEdit_path.setText(path_proj)

    # Choisir SCR
    def set_crs(self):
        self.dlg_crs.show()
        result = self.dlg_crs.exec()
        if result:
            crs = self.crs_dict[str(self.dlg_crs.comboBox_crs.currentText())]
            QgsProject.instance().setCrs(QgsCoordinateReferenceSystem(crs))
            print(crs)
            # si le projet a été enregistré
            if not QgsProject.instance().write():
                self.iface.messageBar().pushMessage(
                    "Le projet n'a pas été enregistré : impossible de créer les couches",
                    level=Qgis.Critical,
                    duration=6,
                )

    # Save project as
    def save_project(self):
        self.iface.actionSaveProjectAs().trigger()

    def get_crs_key(self, crs):
        for kk, vv in self.crs_dict.items():
            if vv == crs:
                return kk
        return None

    def get_layer_building_info(self, path_proj):
        # Counter for added layers
        new_layer_nb = 0
        reloaded_layer_nb = 0

        list_layers_sorted = sorted(self.list_layers, key=lambda s: s[0].lower(), reverse=True)

        for layer_info in list_layers_sorted:
            # If the layer doesn't exist in the project
            if len(QgsProject.instance().mapLayersByName(layer_info[0])) == 0 and (
                not self.layer_exists(layer_info[0], path_proj)
            ):
                new_layer_nb += 1
            else:
                reloaded_layer_nb += 1

        return new_layer_nb, reloaded_layer_nb

    def config_build_layer(self):
        path_proj = QFileInfo(QgsProject.instance().fileName()).absolutePath()
        if path_proj == "":
            self.iface.messageBar().pushMessage(
                "Le projet n'a jamais été sauvegardé. Veuillez sauvegarder le projet avant de générer les couches.",
                level=Qgis.Info,
                duration=5,
            )
            return

        crs = QgsProject.instance().crs().authid()
        crs_key = self.get_crs_key(crs)
        if crs_key is None:
            self.iface.messageBar().pushMessage(
                "Le SCR du projet ne fait pas parti des SCR répertoriés. Veuillez choisir un SCR via le menu "
                "'Préparation Delim'.",
                level=Qgis.Info,
                duration=5,
            )
            return

        new_layer_nb, reloaded_layer_nb = self.get_layer_building_info(path_proj)
        self.dlg_build_layer.nb_generate_label.setText(str(new_layer_nb))
        self.dlg_build_layer.nb_reload_label.setText(str(reloaded_layer_nb))
        self.dlg_build_layer.lineEdit_path.setText(path_proj)
        self.dlg_build_layer.scr_label.setText(crs_key)

        self.dlg_build_layer.build_pg_bar.setValue(0)
        self.dlg_build_layer.cancel_build_button.setEnabled(True)

        self.dlg_build_layer.show()

    # Generer ou recharger les couches d'un projet
    def build_layer(self):
        crs = QgsProject.instance().crs().authid()
        path_proj = QFileInfo(QgsProject.instance().fileName()).absolutePath()

        # Set up groups or find existing ones
        build_external_group = self.dlg_build_layer.build_group_checkbox.isChecked()
        layer_groups = self.setup_groups(build_external_group)

        list_layers_sorted = sorted(self.list_layers, key=lambda s: s[0].lower(), reverse=True)
        self.dlg_build_layer.build_pg_bar.setMinimum(0)
        self.dlg_build_layer.build_pg_bar.setMaximum(len(list_layers_sorted))
        self.dlg_build_layer.cancel_build_button.setEnabled(False)

        for i, layer_info in enumerate(list_layers_sorted):
            # If the layer doesn't exist in the project
            if len(QgsProject.instance().mapLayersByName(layer_info[0])) == 0:
                # If the layer shapefile already exists in project dir meaning the layer has been manually
                # renamed : we do not want to replace it
                if self.layer_exists(layer_info[0], path_proj):
                    self.load_existing_layer(layer_info, path_proj, layer_groups)
                else:
                    self.create_layer(layer_info, crs, path_proj, layer_groups)
            else:
                self.reload_layer_style(layer_info)

            self.dlg_build_layer.build_pg_bar.setValue(i + 1)

        self.dlg_build_layer.close()
        self.start_function()
        self.iface.messageBar().pushMessage("La construction s'est terminée avec succès.", level=Qgis.Info, duration=6)

    # noinspection PyMethodMayBeStatic
    def setup_groups(self, build_external_group):
        root = QgsProject.instance().layerTreeRoot()
        """Find or create groups in the project."""
        cad_dessin = root.findGroup(self.parent_group_name) or root.addGroup(self.parent_group_name)

        if build_external_group:
            root.findGroup("CroqRem") or root.addGroup("CroqRem")
            root.findGroup("Restit") or root.addGroup("Restit")
            root.findGroup("Ancien_Plan") or root.addGroup("Ancien_Plan")
            root.findGroup("Ortho") or root.addGroup("Ortho")

        # Warning : dico keys should fit third element of tuples in list_layers
        groups = {
            "Symbole": cad_dessin.findGroup("Symboles") or cad_dessin.addGroup("Symboles"),
            "Dessin": cad_dessin.findGroup("Dessin") or cad_dessin.addGroup("Dessin"),
            "Autre": cad_dessin.findGroup("Autres") or cad_dessin.addGroup("Autres"),
            "CroquisDelim": cad_dessin.findGroup("CroquisDelim") or cad_dessin.addGroup("CroquisDelim"),
            "Delimitation": cad_dessin.findGroup("Delimitation") or cad_dessin.addGroup("Delimitation"),
        }
        return groups

    # noinspection PyMethodMayBeStatic
    def layer_exists(self, layer_name, path_proj):
        """Check if a layer exists in the project directory."""
        return os.path.exists(os.path.join(path_proj, f"{layer_name}.shp"))

    def create_layer(self, layer_info, crs, path_proj, layer_groups):
        """Create a new layer and assign it to the correct group."""
        fn = os.path.join(path_proj, f"{layer_info[0]}.shp")
        layer_fields = self.define_fields(layer_info)

        writer, feat = self.initialize_layer_writer(layer_info, crs, fn, layer_fields)

        feat.setAttributes([1])
        writer.addFeature(feat)
        layer = self.iface.addVectorLayer(fn, "", "ogr")
        layer.setName(layer_info[0])
        del writer

        # Remove the initial dummy feature
        layer.dataProvider().deleteFeatures([0])

        self.load_and_assign_layer_style(layer, layer_info)
        self.add_layer_to_group(layer_info, layer, layer_groups)

    # noinspection PyMethodMayBeStatic
    def initialize_layer_writer(self, layer_info, crs, fn, layer_fields):
        """Initialize a QgsVectorFileWriter based on the layer type."""
        writer, feat = None, None
        if layer_info[1] == "Point":
            writer = QgsVectorFileWriter(
                fn, "System", layer_fields, QgsWkbTypes.Point, QgsCoordinateReferenceSystem(crs), APNCad.DRIVER_NAME
            )
            feat = QgsFeature()
            feat.setGeometry(QgsGeometry.fromPointXY(QgsPointXY(0, 0)))

        elif layer_info[1] == "Ligne":
            writer = QgsVectorFileWriter(
                fn,
                "System",
                layer_fields,
                QgsWkbTypes.LineString,
                QgsCoordinateReferenceSystem(crs),
                APNCad.DRIVER_NAME,
            )
            feat = QgsFeature()
            feat.setGeometry(QgsGeometry.fromPolyline([QgsPoint(0, 0), QgsPoint(1, 1)]))

        elif layer_info[1] == "Polygone":
            writer = QgsVectorFileWriter(
                fn, "System", layer_fields, QgsWkbTypes.Polygon, QgsCoordinateReferenceSystem(crs), APNCad.DRIVER_NAME
            )
            feat = QgsFeature()
            feat.setGeometry(QgsGeometry.fromPolygonXY([[QgsPointXY(0, 0), QgsPointXY(1, 1), QgsPointXY(2, 2)]]))

        if writer is None:
            self.iface.messageBar().pushMessage(
                f"Impossible de trouver le type de la couche: {layer_info[0]}", level=Qgis.Critical, duration=3
            )
            raise ValueError

        return writer, feat

    # noinspection PyMethodMayBeStatic
    def define_fields(self, layer_info):
        """Define the fields for the layer based on its type."""
        layer_fields = QgsFields()
        if layer_info[0] in ["Point", "Numparc"]:
            layer_fields.append(QgsField("ID", QVariant.Int))
        elif layer_info[0] == "Das":
            layer_fields.append(QgsField("ID", QVariant.String))
            layer_fields.append(QgsField("Fichier", QVariant.String))
        else:
            layer_fields.append(QgsField("ID", QVariant.String))
        return layer_fields

    def load_existing_layer(self, layer_info, path_proj, layer_groups):
        """Load an existing layer and assign it to the correct group."""
        fn = os.path.join(path_proj, f"{layer_info[0]}.shp")
        layer = self.iface.addVectorLayer(fn, "", "ogr")
        layer.setName(layer_info[0])

        self.load_and_assign_layer_style(layer, layer_info)
        self.add_layer_to_group(layer_info, layer, layer_groups)

    def load_and_assign_layer_style(self, layer, layer_info):
        """Load the style for the layer and handle errors."""
        qml_filepath = os.path.join(self.plugin_dir, "styles", f"{layer_info[0]}.qml")
        success = layer.loadNamedStyle(qml_filepath)
        if not success[1]:
            self.iface.messageBar().pushMessage(
                f"Impossible de charger le style de la couche: {layer_info[0]}", level=Qgis.Critical, duration=3
            )

    # noinspection PyMethodMayBeStatic
    def add_layer_to_group(self, layer_info, layer, layer_groups):
        """Assign the created or loaded layer to the appropriate group."""
        root = QgsProject.instance().layerTreeRoot()
        layer_node = root.findLayer(layer.id())
        group = layer_groups.get(layer_info[2], None)

        if not group:
            self.iface.messageBar().pushMessage(
                f"Impossible de trouver le groupe de la couche: {layer_info[0]}", level=Qgis.Critical, duration=3
            )
            raise ValueError

        group.insertChildNode(0, QgsLayerTreeLayer(layer))

        # Remove the layer from its initial parent group
        layer_node.parent().removeChildNode(layer_node)

    def reload_layer_style(self, layer_info):
        """Reload the style of an existing layer."""
        layer = QgsProject.instance().mapLayersByName(layer_info[0])[0]
        self.load_and_assign_layer_style(layer, layer_info)

    # Bouton start
    def start_function(self):

        # dict containing every info about layers (layer instance, type, nb points)
        self.layers = {}
        for layer_info in self.list_layers:
            try:
                self.layers[layer_info[0]] = QgsProject.instance().mapLayersByName(layer_info[0])[0]
            except Exception as e:
                print(e)
                self.iface.messageBar().pushMessage(
                    "La couche {} n'existe pas".format(layer_info[0]), level=Qgis.Critical, duration=3
                )

        self.current_layer = self.iface.activeLayer()

        # initialisation widget texte dernier point
        # construit liste id points
        try:
            list_features = []
            for feature in self.layers["Point"].getFeatures():
                list_features.append(feature.id())

            self.num_point = self.layers["Point"].getFeature(max(list_features)).attributes()[0] + 1
            self.last_point.setText(str(self.num_point))
        except Exception as e:
            print(e)
            # si nouveau projet : aucun point ou si la couche n'existe pas
            self.last_point.setText(str(self.num_point))

        # initialisation widget texte dernier num parc
        # construit liste id num parc
        try:
            list_features = []
            for feature in self.layers["Numparc"].getFeatures():
                list_features.append(feature.id())

            self.num_parc = self.layers["Numparc"].getFeature(max(list_features)).attributes()[0] + 1
            self.last_num_parc.setText(str(self.num_parc))
        except Exception as e:
            print(e)
            # si nouveau projet : aucun point ou si la couche n'existe pas
            self.last_num_parc.setText(str(self.num_parc))

        # activer tous les boutons (sauf annuler pt et numParc)
        for i in self.actions.keys():
            if i != "action_cancel_point" and i != "action_cancel_numparc":
                self.actions[i].setEnabled(True)

        # desactiver bouton start
        self.start_butt.setEnabled(False)

    # Tracer point
    def set_point_tool(self):
        self.current_layer = self.layers["Point"]
        self.iface.setActiveLayer(self.current_layer)
        self.current_layer.startEditing()
        self.canvas.setMapTool(self.point_tool)

    def display_point(self, point, button):
        # Use only the 'point' parameter and ignore 'button'

        self.current_layer.beginEditCommand("Ajout point")

        feat = QgsFeature()
        feat.setGeometry(QgsGeometry.fromPointXY(QgsPointXY(point.x(), point.y())))
        feat.setAttributes([self.num_point])
        self.current_layer.addFeature(feat)

        self.current_layer.endEditCommand()

        # autoriser annulation
        self.actions["action_cancel_point"].setEnabled(True)

        # actualisation num suivant

        self.num_point += self.increment
        self.last_point.setText(str(self.num_point))

        self.refresh_layer(self.current_layer)

    def config_point(self):

        # show the dialog
        self.dlg_config_pt.show()
        # select premiere zone de saisie
        self.dlg_config_pt.lineedit_numin.setFocus()
        # Run the dialog event loop
        result = self.dlg_config_pt.exec()
        # See if OK was pressed
        if result:
            try:
                self.num_point = int(self.dlg_config_pt.lineedit_numin.value())
            except Exception as e:
                print(e)
            try:
                inc = self.increment
                self.increment = int(self.dlg_config_pt.lineedit_inc.value())
                self.num_point -= inc
                self.num_point += self.increment

            except Exception as e:
                print(e)

            self.last_point.setText(str(self.num_point))

        # efface le texte des lineEdit
        self.dlg_config_pt.lineedit_numin.clearValue()
        self.dlg_config_pt.lineedit_inc.clearValue()

    def open_attribute_table(self):
        self.iface.showAttributeTable(self.layers["Point"])

    # remove last point and update num point
    def cancel(self):
        # Loop through all features in the layer and get id
        if not self.layers["Point"].undoStack().isClean():
            self.layers["Point"].undoStack().undo()
            self.refresh_layer(self.layers["Point"])
            self.num_point = self.num_point - self.increment
            self.last_point.setText(str(self.num_point))
            # self.layers['Point'].commitChanges()

        # aucun point dans la couche
        else:
            self.actions["action_cancel_point"].setEnabled(False)

    # Tracer num parc
    def set_num_parc_tool(self):
        self.current_layer = self.layers["Numparc"]
        self.iface.setActiveLayer(self.current_layer)
        self.current_layer.startEditing()
        self.canvas.setMapTool(self.num_parc_tool)

    def display_num_parc(self, point, button):

        self.current_layer.beginEditCommand("Ajout numero parcelle")

        feat = QgsFeature()
        feat.setGeometry(QgsGeometry.fromPointXY(QgsPointXY(point.x(), point.y())))
        feat.setAttributes([self.num_parc])
        self.current_layer.addFeature(feat)

        self.current_layer.endEditCommand()

        # autoriser annulation
        self.actions["action_cancel_numparc"].setEnabled(True)

        # actualisation num suivant

        self.num_parc += self.inc_parc
        self.last_num_parc.setText(str(self.num_parc))

        self.refresh_layer(self.current_layer)

    def config_num_parc(self):
        self.dlg_num_parc.show()
        self.dlg_num_parc.lineedit_numin.setFocus()
        result = self.dlg_num_parc.exec()
        if result:
            try:
                self.num_parc = int(self.dlg_num_parc.lineedit_numin.value())
            except Exception as e:
                print(e)
            try:
                inc = self.inc_parc
                self.inc_parc = int(self.dlg_num_parc.lineedit_inc.value())
                self.num_parc -= inc
                self.num_parc += self.inc_parc

            except Exception as e:
                print(e)
            self.last_num_parc.setText(str(self.num_parc))

        # efface le texte des lineEdit
        self.dlg_num_parc.lineedit_numin.clearValue()
        self.dlg_num_parc.lineedit_inc.clearValue()

    def open_num_parc_attribute_table(self):
        self.iface.showAttributeTable(self.layers["Numparc"])

    # erase last displayed point
    def cancel_num_parc(self):
        # Loop through all features in the layer
        # list_id = [i.id() for i in list(self.layers['Numparc'].getFeatures())]

        if not self.layers["Numparc"].undoStack().isClean():
            self.layers["Numparc"].undoStack().undo()
            self.refresh_layer(self.layers["Numparc"])
            self.num_parc = self.num_parc - self.inc_parc
            self.last_num_parc.setText(str(self.num_parc))
            # self.layers['Numparc'].commitChanges()

        # aucun numParc dans la couche
        else:
            self.actions["action_cancel_numparc"].setEnabled(False)

    def set_general_tool(
        self, layer_name, button_menu=None, default_action=None, attribute=False, nb_points_polyline=0
    ):
        self.current_layer = self.layers[layer_name]
        self.iface.setActiveLayer(self.current_layer)
        self.current_layer.startEditing()
        self.attribute = attribute
        if nb_points_polyline == 0:
            self.canvas.setMapTool(self.punctual_tool)
        else:
            self.canvas.setMapTool(self.polyligne_tool)
            self.polyligne_tool.nb_pts_poly = nb_points_polyline

        if button_menu is not None:
            button_menu.setDefaultAction(self.actions[default_action])

    def display_punctual(self, point, button):

        self.current_layer.beginEditCommand("Ajout entite ponctuelle")

        feat = QgsFeature(self.current_layer.fields())
        feat.setGeometry(QgsGeometry.fromPointXY(QgsPointXY(point.x(), point.y())))
        self.current_layer.addFeature(feat)  # ajout du point sur le dessin, ne permet pas ctrl z
        self.refresh_layer(self.current_layer)

        if self.attribute:
            self.apply_new_attribute(feat)

        self.current_layer.endEditCommand()

    def set_cote_courbe_tool(self):
        self.current_layer = self.layers["coteSURLigne"]
        self.attribute = True
        self.iface.setActiveLayer(self.current_layer)
        self.current_layer.startEditing()
        # self.iface.actionAddFeature().trigger()
        self.canvas.setMapTool(self.arc_tool)
        self.cote_button.setDefaultAction(self.actions["action_cote_courbe"])

    def display_cote_courbe(self, point, button):

        # 1er et 2e point
        if len(self.point_list) < 2:
            pt = QgsPoint(point.x(), point.y())
            self.point_list.append(pt)

        # 3e point
        else:

            self.current_layer.beginEditCommand("Ajout cote courbe")

            # Create a QgsCircularString
            circular_ring = QgsCircularString()
            # Set first point, intermediate point for curvature and end point
            circular_ring.setPoints([self.point_list[0], self.point_list[1], QgsPoint(point.x(), point.y())])

            # Create geometry using the instance of QgsCircularString
            geom_from_curve = QgsGeometry(circular_ring)

            # Create a feature
            fet = QgsFeature(self.current_layer.fields())
            # Assign the geometry
            fet.setGeometry(geom_from_curve)

            self.current_layer.addFeature(fet)
            self.current_layer.endEditCommand()

            self.refresh_layer(self.current_layer)
            self.point_list = []

            self.apply_new_attribute(fet)

    def display_feature(self, feature):
        self.current_layer.beginEditCommand("Ajout entite")
        print(feature)
        print(feature.geometry().type())
        self.current_layer.addFeature(feature)
        self.current_layer.endEditCommand()
        self.refresh_layer(self.current_layer)
        self.apply_new_attribute(feature)

    def apply_new_attribute(self, ft):

        if self.attribute:
            # get last feature
            # other option: feature = list(feature_iterator)[N - 1] to get Nth feature

            # Important car dlg.comboBox_field.addItems genere signal index_changed et appelle ma fonction
            # select_attribute_field qui ne doit etre appelee que pour edit un feat et pas pour creation
            self.closest_feature_id = None

            # Special editing window for some layers (image)
            if self.current_layer == self.layers["image"] or self.current_layer == self.layers["Das"]:
                dlg = self.dlg_image

            # General case for all other layers
            else:
                dlg = self.dlg_attribut

            # fenetre entrer cote

            dlg.show()
            dlg.lineedit_attribut.setFocus()
            dlg.comboBox_field.addItems([field.name() for field in self.current_layer.fields()])

            result = dlg.exec()
            # See if OK was pressed
            if result:
                try:
                    new_value = dlg.lineedit_attribut.value()
                    print(new_value)

                    index = dlg.comboBox_field.currentIndex()
                    self.current_layer.beginEditCommand("Ajout attribut")
                    self.current_layer.changeAttributeValue(ft.id(), index, new_value)
                    self.current_layer.endEditCommand()
                    self.refresh_layer(self.current_layer)

                except Exception as e:
                    print(e)
            else:
                self.current_layer.deleteFeature(ft.id())
                self.refresh_layer(self.current_layer)

            dlg.lineedit_attribut.clearValue()
            # signal must be blocked because clear triggers current index changed signal
            dlg.comboBox_field.blockSignals(True)
            dlg.comboBox_field.clear()
            dlg.comboBox_field.blockSignals(False)

    # valider polyligne
    def clic_droit(self):
        # Local position (center of canvas)
        local_pos = QPointF(self.canvas.rect().center())

        # Global position
        global_pos = QPointF(self.canvas.mapToGlobal(self.canvas.rect().center()))

        mouse_event = QMouseEvent(
            QEvent.Type.MouseButtonRelease,
            local_pos,
            global_pos,
            Qt.MouseButton.RightButton,
            Qt.MouseButton.RightButton,
            Qt.KeyboardModifier.NoModifier,
        )

        self.canvas.mouseReleaseEvent(mouse_event)

    def appui_echap(self):
        self.point_list = []

        key_event = QKeyEvent(QEvent.Type.KeyPress, Qt.Key.Key_Escape, Qt.KeyboardModifier.NoModifier, "")

        QApplication.sendEvent(self.canvas, key_event)

    def zoom_plus(self):
        self.canvas.zoomIn()

    def zoom_moins(self):
        self.canvas.zoomOut()

    def outil_main(self):
        self.canvas.setMapTool(self.tool_pan)

    def rotate(self, degree):
        rotation_actu = self.canvas.rotation()
        rotation_new = rotation_actu + degree
        self.canvas.setRotation(rotation_new)
        self.canvas.refresh()

    # suppression objet
    def set_delete_tool(self):
        self.canvas.setMapTool(self.delete_tool)
        self.canvas.setCursor(QCursor(Qt.CursorShape.PointingHandCursor))

    def delete_object(self, point, button):
        obj = self.find_nearest_features(point, button)

        if obj:
            self.current_layer.startEditing()
            self.current_layer.beginEditCommand("Suppression entite")
            self.current_layer.deleteFeature(self.closest_feature_id)
            self.current_layer.endEditCommand()
            self.current_layer.removeSelection()
            self.refresh_layer(self.current_layer)

    # Modify attributes
    def set_edit_tool(self):
        # self.dlg.reject()   #ferme la fenetre
        self.canvas.setMapTool(self.edit_attribute_tool)
        self.canvas.setCursor(QCursor(Qt.CursorShape.PointingHandCursor))

    def edit_attribute(self, point, button):
        attribute_change_label = "Changement attribut"
        obj = self.find_nearest_features(point, button)

        if not obj:
            return

        self.current_layer.startEditing()

        # Handle special editing for 'information' layer
        if self.current_layer == self.layers["information"]:
            self.edit_special_layer(self.dlg_info, self.current_layer, 0, attribute_change_label)
            self.dlg_info.textEdit.clear()

        # Handle image layer editing
        elif self.current_layer in [self.layers["image"], self.layers["Das"]]:
            self.prepare_image_layer_editing()
            self.process_result(self.dlg_image, attribute_change_label)

        # Handle all other layers
        else:
            self.prepare_default_layer_editing()
            self.process_result(self.dlg_attribut, attribute_change_label)

        self.current_layer.removeSelection()

    def edit_special_layer(self, dialog, layer, field_index, attribute_change_label):
        """Handle the special edit window for specific layers."""
        dialog.show()
        dialog.textEdit.setFocus()

        try:
            old_attr = layer.getFeature(self.closest_feature_id).attributes()[field_index]
            dialog.textEdit.setText(str(old_attr))
        except Exception as e:
            print(e)

        result = dialog.exec()
        if result:
            try:
                new_value = dialog.textEdit.toPlainText()
                layer.beginEditCommand(attribute_change_label)
                layer.changeAttributeValue(self.closest_feature_id, field_index, new_value)
                layer.endEditCommand()
                self.refresh_layer(layer)
            except Exception as e:
                print(e)

    def prepare_image_layer_editing(self):
        """Prepare the image layer editing dialog."""
        self.dlg_image.show()
        self.dlg_image.lineedit_attribut.setFocus()
        self.dlg_image.comboBox_field.addItems([field.name() for field in self.current_layer.fields()])

        try:
            old_attr = self.current_layer.getFeature(self.closest_feature_id).attributes()[0]
            self.dlg_image.lineedit_attribut.setText(str(old_attr))
        except Exception as e:
            print(e)

    def prepare_default_layer_editing(self):
        """Prepare the default layer editing dialog."""
        self.dlg_attribut.show()
        self.dlg_attribut.lineedit_attribut.setFocus()
        self.dlg_attribut.comboBox_field.addItems([field.name() for field in self.current_layer.fields()])

        try:
            old_attr = self.current_layer.getFeature(self.closest_feature_id).attributes()[0]
            if old_attr != "NULL":
                self.dlg_attribut.lineedit_attribut.setText(str(old_attr))
        except Exception as e:
            print(e)

    def process_result(self, dialog, attribute_change_label):
        """Process the result of the dialog and apply changes to the feature."""
        result = dialog.exec()
        if result:
            try:
                new_value = dialog.lineedit_attribut.value()
                index = dialog.comboBox_field.currentIndex()
                field_type = self.current_layer.fields()[index].typeName()

                if field_type in ["Integer64", "Integer"]:
                    new_value = int(new_value)

                self.current_layer.beginEditCommand(attribute_change_label)
                self.current_layer.changeAttributeValue(self.closest_feature_id, index, new_value)
                self.current_layer.endEditCommand()
                self.refresh_layer(self.current_layer)
            except Exception as e:
                print(e)

        dialog.lineedit_attribut.clearValue()
        dialog.comboBox_field.blockSignals(True)
        dialog.comboBox_field.clear()
        dialog.comboBox_field.blockSignals(False)

    def set_action_tool(self):
        self.canvas.setMapTool(self.action_tool)
        self.canvas.setCursor(QCursor(Qt.CursorShape.PointingHandCursor))

    def trigger_action(self, point, button):
        # self.save_layers()

        obj = self.find_nearest_features(point, button)
        if obj:
            action_manager = self.current_layer.actions()
            actions = action_manager.actions()
            if len(actions) > 0:
                action_manager.doActionFeature(actions[0].id(), self.current_layer.getFeature(self.closest_feature_id))
            else:
                self.iface.messageBar().pushMessage(
                    "Cette couche ne possède pas d'action associée", level=Qgis.Info, duration=4
                )
        self.current_layer.removeSelection()

    def set_translation_tool(self):
        self.copy = False
        self.canvas.setMapTool(self.copy_tool)
        # self.save_layers()
        self.translation_button.setDefaultAction(self.actions["action_move"])

    def set_copy_tool(self):
        self.copy = True
        self.canvas.setMapTool(self.copy_tool)
        # self.save_layers()
        self.translation_button.setDefaultAction(self.actions["action_copy"])

    def translate_copy_feature(self, point, button):

        # 1er point
        if len(self.point_list) == 0:

            obj = self.find_nearest_features(point, button)
            if obj:
                if not self.current_layer.isEditable():
                    self.current_layer.startEditing()

                pt = QgsPoint(point.x(), point.y())
                self.point_list.append(pt)
                print(self.current_layer.name())
                # si on veut copier et translater
                if self.copy:
                    self.current_layer.beginEditCommand("Copie entite")
                    ft = self.current_layer.getFeature(self.closest_feature_id)
                    self.current_layer.addFeature(ft)
                    self.current_layer.endEditCommand()

        # 2e point
        else:

            self.current_layer.beginEditCommand("Translate entite")

            dx = point.x() - self.point_list[0].x()
            dy = point.y() - self.point_list[0].y()
            self.current_layer.translateFeature(self.closest_feature_id, dx, dy)

            self.refresh_layer(self.current_layer)
            self.point_list = []
            self.current_layer.removeSelection()
            self.current_layer.endEditCommand()

    def set_debord_tool(self):
        self.current_layer = self.layers["debordT"]
        self.iface.setActiveLayer(self.current_layer)
        self.current_layer.startEditing()
        self.canvas.setMapTool(self.debord_tool)

        self.dlg_debord.show()
        self.dlg_debord.lineedit_debord.setFocus()

        result = self.dlg_debord.exec()
        # See if OK was pressed
        if result:
            try:
                self.debord = self.dlg_debord.lineedit_debord.value()
            except Exception as e:
                print(e)
        self.dlg_debord.lineedit_debord.clearValue()
        self.dlg_clavier_num.lineedit_valeur.clearValue()

    def set_debord(self, debord):
        self.debord = debord
        self.dlg_debord.reject()

    def display_debord(self, point, button):

        self.current_layer.beginEditCommand("Ajout debord")
        feat = QgsFeature(self.current_layer.fields())
        feat.setGeometry(QgsGeometry.fromPointXY(QgsPointXY(point.x(), point.y())))
        feat.setAttributes([self.debord])
        self.current_layer.addFeature(feat)

        self.current_layer.endEditCommand()

        self.refresh_layer(self.current_layer)

    def set_polygone_tool(self):
        self.current_layer = self.layers["polygone"]
        self.iface.setActiveLayer(self.current_layer)
        self.current_layer.startEditing()
        self.attribute = True
        self.canvas.setMapTool(self.polygon_tool)
        # self.iface.actionAddFeature().trigger()

    # Default tool (two fields)
    def set_das_tool(self):
        self.current_layer = self.layers["Das"]
        self.iface.setActiveLayer(self.current_layer)
        self.current_layer.startEditing()
        self.iface.actionAddFeature().trigger()
        self.pj_button.setDefaultAction(self.actions["action_das"])

    # Default tool (bigger text field)
    def set_info_tool(self):
        self.current_layer = self.layers["information"]
        self.iface.setActiveLayer(self.current_layer)
        self.current_layer.startEditing()
        self.iface.actionAddFeature().trigger()
        self.pj_button.setDefaultAction(self.actions["action_info"])

    # noinspection PyMethodMayBeStatic
    def browse_file(self, lineedit, file_filter, root_dir=None):
        rdir = root_dir
        if (not rdir) or (not os.path.exists(rdir)):
            rdir = QFileInfo(QgsProject.instance().fileName()).absolutePath()

        fname = QFileDialog.getOpenFileName(None, "Ouvrir Fichier", rdir, file_filter)
        lineedit.setText(fname[0])

    # noinspection PyMethodMayBeStatic
    def browse_folder(self, lineedit):
        path = QFileDialog.getExistingDirectory(
            None, "Choisir Dossier", QFileInfo(QgsProject.instance().fileName()).absolutePath()
        )
        # if path is selected
        if path:
            lineedit.setText(path)

    def select_attribute_field(self, lineedit, combobox):
        index = combobox.currentIndex()
        if self.closest_feature_id is not None:
            feat = self.current_layer.getFeature(self.closest_feature_id)
            attributes = feat.attributes()
            old_attr = attributes[index]
            lineedit.setText(str(old_attr))

    def get_most_recent_image(self):
        directory = Path(self.captured_image_dirpath)

        if not directory.is_dir():
            raise ValueError(f"{directory} is not a valid directory")

        image_extensions = {".jpg", ".jpeg", ".png", ".bmp", ".gif", ".tiff", ".webp"}

        images = (p for p in directory.iterdir() if p.is_file() and p.suffix.lower() in image_extensions)

        return max(images, key=lambda p: p.stat().st_mtime, default=None)

    def fill_last_picture(self):
        if not self.captured_image_dirpath:
            self.iface.messageBar().pushMessage(
                "Aucun chemin vers le répertoire de sauvegarde des photos n'a été renseigné.",
                level=Qgis.Critical,
                duration=6,
            )
            return
        if not os.path.exists(self.captured_image_dirpath):
            self.iface.messageBar().pushMessage(
                "Le chemin vers le répertoire de sauvegarde des photos renseigné est invalide.",
                level=Qgis.Critical,
                duration=6,
            )
            return

        last_img_filepath = self.get_most_recent_image()
        if not last_img_filepath:
            self.iface.messageBar().pushMessage(
                "Aucune photo n'a été trouvée dans le répertoire de sauvegarde renseigné.",
                level=Qgis.Critical,
                duration=6,
            )
            return
        self.dlg_image.lineedit_attribut.setText(str(last_img_filepath))

    def open_camera(self):
        if not self.camera_exe_filepath:
            self.iface.messageBar().pushMessage(
                "Aucun exécutable vers une application caméra n'a été renseigné.",
                level=Qgis.Critical,
                duration=6,
            )
            return
        if (not os.path.exists(self.camera_exe_filepath)) and self.camera_exe_filepath != "windows":
            self.iface.messageBar().pushMessage(
                "Le chemin de l'exécutable vers une application caméra renseigné est invalide.",
                level=Qgis.Critical,
                duration=6,
            )
            return

        if self.camera_exe_filepath == "windows":
            subprocess.Popen(["start", "microsoft.windows.camera:"], shell=True)
        else:
            subprocess.Popen([Path(self.camera_exe_filepath)])

    def open_edit_img_app(self):
        if not self.img_edit_exe_filepath:
            self.iface.messageBar().pushMessage(
                "Aucun exécutable vers une application d'édition de photos n'a été renseigné",
                level=Qgis.Critical,
                duration=6,
            )
            return

        if (not os.path.exists(self.img_edit_exe_filepath)) and self.img_edit_exe_filepath != "windows":
            self.iface.messageBar().pushMessage(
                "Le chemin de l'exécutable vers une application d'édition de photos renseigné est invalide.",
                level=Qgis.Critical,
                duration=6,
            )
            return

        if not self.dlg_image.lineedit_attribut.text().strip():
            self.iface.messageBar().pushMessage(
                "Aucune image n'a été renseignée dans le champ ci-dessus.",
                level=Qgis.Critical,
                duration=6,
            )
            return

        if not os.path.exists(self.dlg_image.lineedit_attribut.text().strip()):
            self.iface.messageBar().pushMessage(
                "L'image renseignée dans le champ ci-dessus n'existe pas.",
                level=Qgis.Critical,
                duration=6,
            )
            return

        if self.img_edit_exe_filepath == "windows":
            QDesktopServices.openUrl(QUrl.fromLocalFile(self.dlg_image.lineedit_attribut.text().strip()))
        else:
            try:
                subprocess.Popen(
                    [Path(self.img_edit_exe_filepath), Path(self.dlg_image.lineedit_attribut.text().strip())]
                )
            except Exception as e:
                print(e)
                self.iface.messageBar().pushMessage(
                    "Impossible de lancer l'application d'édition choisie.",
                    level=Qgis.Critical,
                    duration=6,
                )

    def fill_lineedit_img_config_dlg(self):
        # Fill line edit if paths are defined
        if self.camera_exe_filepath:
            if self.camera_exe_filepath == "windows":
                self.dlg_config_img.checkbox_win_cam.setChecked(True)
            else:
                self.dlg_config_img.lineedit_cam_path.setText(str(self.camera_exe_filepath))

        if self.img_edit_exe_filepath:
            if self.img_edit_exe_filepath == "windows":
                self.dlg_config_img.checkbox_win_edit_img.setChecked(True)
            else:
                self.dlg_config_img.lineedit_img_edit_path.setText(str(self.img_edit_exe_filepath))

        if self.captured_image_dirpath:
            self.dlg_config_img.lineedit_savedir.setText(str(self.captured_image_dirpath))

    def config_image(self):
        # Fill line edit if paths are defined
        self.fill_lineedit_img_config_dlg()

        # Show the dialog
        self.dlg_config_img.show()
        # Run the dialog event loop
        result = self.dlg_config_img.exec()
        # See if OK was pressed
        if result:
            self.camera_exe_filepath = (
                "windows"
                if self.dlg_config_img.checkbox_win_cam.isChecked()
                else (self.dlg_config_img.lineedit_cam_path.text().strip() or None)
            )

            self.img_edit_exe_filepath = (
                "windows"
                if self.dlg_config_img.checkbox_win_edit_img.isChecked()
                else (self.dlg_config_img.lineedit_img_edit_path.text().strip() or None)
            )

            self.captured_image_dirpath = (
                self.dlg_config_img.lineedit_savedir.text().strip()
                if self.dlg_config_img.lineedit_savedir.text().strip()
                else None
            )
            self.save_image_config()

        # efface le texte des lineEdit
        self.dlg_config_img.lineedit_cam_path.clear()
        self.dlg_config_img.lineedit_savedir.clear()

    def on_checkbox_wincam_toggled(self, checked):
        self.dlg_config_img.lineedit_cam_path.setEnabled(not checked)
        self.dlg_config_img.pbutton_browse_cam.setEnabled(not checked)

    def on_checkbox_winedit_toggled(self, checked):
        self.dlg_config_img.lineedit_img_edit_path.setEnabled(not checked)
        self.dlg_config_img.pbutton_browse_img_edit.setEnabled(not checked)

    def read_image_config(self):
        if self.image_config_filepath.is_file():
            data = json.loads(self.image_config_filepath.read_text(encoding="utf-8"))
            return data.get("camera_exe"), data.get("edit_exe"), data.get("saving_dir")
        return None, None, None

    def save_image_config(self):
        if not self.image_config_filepath.parent.is_dir():
            self.image_config_filepath.parent.mkdir()

        data = {
            "camera_exe": self.camera_exe_filepath,
            "edit_exe": self.img_edit_exe_filepath,
            "saving_dir": self.captured_image_dirpath,
        }
        with open(self.image_config_filepath, "w", encoding="utf-8") as f:
            json.dump(data, f)

    def clavier_num(self, lineedit):
        self.dlg_clavier_num.show()

        result = self.dlg_clavier_num.exec()
        print(lineedit.value())
        # See if OK was pressed
        if result:
            txt = lineedit.value() + self.dlg_clavier_num.lineedit_valeur.value()
            lineedit.setText(txt)
            self.dlg_clavier_num.lineedit_valeur.clearValue()

    def key_value(self, key):
        value = self.dlg_clavier_num.lineedit_valeur.value()
        self.dlg_clavier_num.lineedit_valeur.setText(value + key)

    def key_del(self):
        value = self.dlg_clavier_num.lineedit_valeur.value()
        self.dlg_clavier_num.lineedit_valeur.setText(value[:-1])

    # noinspection PyMethodMayBeStatic
    def fill_from_combo(self, combo, lineedit):
        text = combo.currentText()
        lineedit.setText(text)

    # identify the layer of a selected object
    def set_identify_layer_tool(self):
        self.canvas.setMapTool(self.identify_tool)
        self.canvas.setCursor(QCursor(Qt.CursorShape.WhatsThisCursor))

    def identify_layer(self, point, button):

        # self.save_layers()

        obj = self.find_nearest_features(point, button)

        if obj:
            iface.messageBar().pushMessage(self.current_layer.name(), level=Qgis.Info, duration=5)

    def set_freeze_layer_tool(self):
        self.canvas.setMapTool(self.freeze_tool)
        self.canvas.setCursor(QCursor(Qt.CursorShape.PointingHandCursor))

    def freeze_layer(self, point, button):
        # self.save_layers()
        obj = self.find_nearest_features(point, button)
        if obj:
            QgsProject.instance().layerTreeRoot().findLayer(self.current_layer.id()).setItemVisibilityChecked(False)

    # show/hide layer pannel
    # noinspection PyMethodMayBeStatic
    def panneau_couche(self):
        for widget in iface.mainWindow().findChildren(QDockWidget):
            if widget.objectName() == "Layers":
                if widget.isVisible():
                    widget.hide()  # hide()
                else:
                    widget.show()

    # montrer cacher info proprio
    def visu_info_proprio(self):
        self.visu_button.setDefaultAction(self.actions["action_display_proprio"])
        # Get layer Text in group CroqRem
        root = QgsProject.instance().layerTreeRoot()
        couche = None
        for lay in QgsProject.instance().mapLayersByName("Parcelles"):
            tree_layer = root.findLayer(lay.id())
            if not tree_layer:
                iface.messageBar().pushMessage(
                    "Impossible de démarrer l'outil : la couche 'Parcelles' n'existe pas.",
                    level=Qgis.Critical,
                    duration=5,
                )
                return
            layer_parent = tree_layer.parent()
            if layer_parent and layer_parent.name() == "Cadastre":
                couche = tree_layer.layer()
                break
        if couche is None:
            iface.messageBar().pushMessage(
                "Impossible de démarrer l'outil : le groupe 'Cadastre' n'existe pas ou ne contient pas de couche "
                "'Parcelles'.",
                level=Qgis.Critical,
                duration=5,
            )
            return

        couche.setLabeling(self.proprio_label)
        currently_enabled = couche.labelsEnabled()
        couche.setLabelsEnabled(not currently_enabled)
        couche.triggerRepaint()

    # montrer cacher Ortho
    def visu_ortho(self):
        self.visu_button.setDefaultAction(self.actions["action_display_ortho"])

        # Get layer Text in group Ortho
        root = QgsProject.instance().layerTreeRoot()
        group = root.findGroup("Ortho")

        if group is None:
            iface.messageBar().pushMessage(
                "Impossible de démarrer l'outil : le groupe 'Ortho' est introuvable.", level=Qgis.Critical, duration=5
            )
            return

        is_visible = group.isVisible()
        group.setItemVisibilityChecked(not is_visible)

    def visu_ancien_plan(self):
        self.visu_button.setDefaultAction(self.actions["action_display_ancien_plan"])

        # Get layer Text in group Ortho
        root = QgsProject.instance().layerTreeRoot()
        group = root.findGroup("Ancien_Plan")

        if group is None:
            iface.messageBar().pushMessage(
                "Impossible de démarrer l'outil : le groupe 'Ancien_Plan' est introuvable.",
                level=Qgis.Critical,
                duration=5,
            )

        is_visible = group.isVisible()
        group.setItemVisibilityChecked(not is_visible)

    # Rechercher parcelle
    def rechercher_parc(self):
        layer = self.get_layer_from_group("Polygones", "Ancien_Plan")

        if layer is None:
            # Show message if the layer is not found in the specified group
            iface.messageBar().pushMessage(
                "Impossible de démarrer l'outil : le groupe 'Ancien_Plan' ne contient pas de couche 'Polygones'.",
                level=Qgis.Critical,
                duration=5,
            )
            return

        # Prepare the search UI and set the active layer
        self.iface.setActiveLayer(layer)
        layer.removeSelection()
        self.dlg_parc.show()
        self.dlg_parc.LineEdit_section.setFocus()

        result = self.dlg_parc.exec()
        if result:
            # Format the parcel number
            section = self.dlg_parc.LineEdit_section.value().upper()
            parcelle = self.dlg_parc.LineEdit_parc.value().zfill(4)  # Pad with zeros if necessary
            num_parc = section + parcelle

            # Search for the parcel in the layer
            if not self.find_and_select_parcel(layer, num_parc):
                iface.messageBar().pushMessage(
                    "Aucune parcelle trouvée, vérifier le numéro de section/parcelle", level=Qgis.Critical, duration=5
                )

        # Clear input fields after search
        self.dlg_parc.LineEdit_section.clearValue()
        self.dlg_parc.LineEdit_parc.clearValue()

    # noinspection PyMethodMayBeStatic
    def get_layer_from_group(self, layer_name, group_name):
        """Get a layer by name from a specific group."""
        root = QgsProject.instance().layerTreeRoot()
        for layer in QgsProject.instance().mapLayersByName(layer_name):
            tree_layer = root.findLayer(layer.id())
            if tree_layer.parent().name() == group_name:
                return layer
        return None

    def find_and_select_parcel(self, layer, num_parc):
        """Find and select a parcel by its number in the given layer."""
        parcelle_trouvee = False
        for feature in layer.getFeatures():
            if feature.attributes()[1] == "1PARCELLE":
                parcelle_dict = json.loads(feature.attributes()[2])
                num = parcelle_dict["xdatas"]["IDU"]
                if num[-6:] == num_parc:
                    print("num: ", num)
                    layer.select(feature.id())
                    self.canvas.zoomToSelected()
                    layer.removeSelection()
                    parcelle_trouvee = True
        return parcelle_trouvee

    # Compute the highest point attribute
    def max_point(self):

        features = self.layers["Point"].getFeatures()
        attributs = []

        for feature in features:
            att = feature.attributes()
            attributs.append(int(att[0]))
        try:
            self.pointmax = max(attributs)
        except Exception as e:
            print(e)
            self.pointmax = 0

    def save_layers(self):
        # Stack is cleaned, no undo possible
        self.actions["action_cancel_point"].setEnabled(False)
        self.actions["action_cancel_numparc"].setEnabled(False)

        # sauvegarde toutes les couches en mode edition
        for layer in self.iface.mapCanvas().layers():
            if layer.isEditable():
                # layer.commitChanges()
                layer.commitChanges()
                layer.startEditing()  # on remet la couche en mode edition

    def find_nearest_features(self, point, button):
        # Use only the 'point' parameter and ignore 'button'
        self.layer_data = []
        self.closest_feature_id = None

        # Process each vector layer and collect features within distance
        for layer in self.get_valid_layers():
            for feature_info in self.get_features_near_point(layer, point):
                self.layer_data.append(feature_info)

        if not self.layer_data:
            # Show message if no features are found
            self.iface.messageBar().pushMessage("Aucun objet trouvé", level=Qgis.Info, duration=3)
            return False

        # Sort by distance and show results
        self.layer_data.sort(key=lambda x: x[2])

        if len(self.layer_data) > 1:
            self.populate_table()
            if not self.dlg_near.exec():
                return False
        else:
            self.current_layer, self.closest_feature_id, _ = self.layer_data[0]

        return True

    def belongs_to_plugin_group(self, layer):
        """
        Returns True is layer belongs to theparent group of the plugin layers.
        If the layer is not inside any group (i.e., it's at the root), return False.
        """

        # Get the root of the layer tree
        root = QgsProject.instance().layerTreeRoot()

        # Find the layer node in the tree
        layer_node = root.findLayer(layer.id())
        if not layer_node:
            return False  # Layer not found in the tree

        # Traverse up to the top-level group
        parent = layer_node.parent()
        if parent == root:
            return False  # Layer is directly under root, not in any group

        while parent.parent() != root:
            parent = parent.parent()

        return parent.name() == self.parent_group_name

    def get_valid_layers(self):
        """Return a list of valid vector layers excluding specific group names."""
        valid_layers = []
        for layer in self.canvas.layers():
            if (
                layer.type() == QgsMapLayer.VectorLayer
                and layer.featureCount() > 0
                and self.belongs_to_plugin_group(layer)
            ):
                valid_layers.append(layer)
        return valid_layers

    # noinspection PyMethodMayBeStatic
    def get_features_near_point(self, layer, point):
        """Return a list of features close to a given point within a layer."""
        features_near_point = []
        for feature in layer.getFeatures():
            dist = feature.geometry().distance(QgsGeometry.fromPointXY(QgsPointXY(point.x(), point.y())))
            if 1 > dist > 0:
                features_near_point.append((layer, feature.id(), dist))
        return features_near_point

    def populate_table(self):
        """Populate the closest features table."""
        self.dlg_near.tableWidget_closest.setRowCount(0)
        for i, (layer, layer_id, dist) in enumerate(self.layer_data):
            self.dlg_near.tableWidget_closest.insertRow(i)
            self.set_table_row(i, layer, layer_id, dist)

        self.dlg_near.show()

    def set_table_row(self, row, layer, layer_id, dist):
        """Set table row values for closest feature info."""
        line_id = QLineEdit(str(layer_id))
        line_layer = QLineEdit(layer.name())
        line_attribut = QLineEdit(str(layer.getFeature(layer_id).attributes()[0]))
        line_dist = QLineEdit(str(round(dist, 2)))

        for widget in [line_id, line_layer, line_attribut, line_dist]:
            widget.setReadOnly(True)

        self.dlg_near.tableWidget_closest.setCellWidget(row, 0, line_id)
        self.dlg_near.tableWidget_closest.setCellWidget(row, 1, line_layer)
        self.dlg_near.tableWidget_closest.setCellWidget(row, 2, line_attribut)
        self.dlg_near.tableWidget_closest.setCellWidget(row, 3, line_dist)

    def select_feat(self):

        try:
            ligne = self.dlg_near.tableWidget_closest.selectionModel().selectedRows()[0].row()
            print(ligne)
            print(self.dlg_near.tableWidget_closest.cellWidget(ligne, 0))

            self.closest_feature_id = int(self.dlg_near.tableWidget_closest.cellWidget(ligne, 0).text())
            layer_name = self.dlg_near.tableWidget_closest.cellWidget(ligne, 1).text()
            self.current_layer = QgsProject.instance().mapLayersByName(layer_name)[0]
            # self.currentLayer.select(self.closestFeatureId)

            self.dlg_near.accept()

        except Exception as e:
            print(e)
            self.iface.messageBar().pushMessage("Aucun objet sélectionné", level=Qgis.Warning, duration=4)

    # refresh canvas
    def refresh_layer(self, layer):

        self.canvas.refresh()
        layer.triggerRepaint()

    def afficher_liste_point(self):

        self.dlg_liste.show()

        # remplit liste de points

        list_point = []
        list_features = []
        for feature in self.layers["Point"].getFeatures():
            list_point.append(feature.attributes()[0])
            list_features.append(feature.id())
        list_point.sort(reverse=True)

        self.dlg_liste.listNumPoint.setRowCount(0)
        for i in range(len(list_point)):
            self.dlg_liste.listNumPoint.insertRow(i)
            self.dlg_liste.listNumPoint.setCellWidget(i, 0, QLineEdit(str(list_point[i])))

    def resume_num(self, tool):
        layer = None
        dlg = None
        if tool == "point":
            layer = self.layers["Point"]
            dlg = self.dlg_config_pt
        elif tool == "parcelle":
            layer = self.layers["Numparc"]
            dlg = self.dlg_num_parc

        max_num = layer.maximumValue(0)
        print(type(max_num))
        if isinstance(max_num, int):
            dlg.lineedit_numin.clearValue()
            dlg.lineedit_numin.setText(str(max_num + 1))
        else:
            dlg.lineedit_numin.clearValue()
            dlg.lineedit_numin.setText("0")

    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""

        self.menu.deleteLater()

        self.general_toolbar.clear()
        self.general_toolbar.deleteLater()

        self.point_toolbar.clear()
        self.point_toolbar.deleteLater()

        self.enter_toolbar.clear()
        self.enter_toolbar.deleteLater()

        self.dessin_toolbar.clear()
        self.dessin_toolbar.deleteLater()

        self.symbole_toolbar.clear()
        self.symbole_toolbar.deleteLater()

        self.croquis_toolbar.clear()
        self.croquis_toolbar.deleteLater()

        self.canvas.unsetMapTool(self.edit_attribute_tool)
        self.canvas.unsetMapTool(self.point_tool)
        self.canvas.unsetMapTool(self.delete_tool)
        self.canvas.unsetMapTool(self.arc_tool)
        self.canvas.unsetMapTool(self.debord_tool)
        self.canvas.unsetMapTool(self.identify_tool)
        self.canvas.unsetMapTool(self.copy_tool)
        self.canvas.unsetMapTool(self.freeze_tool)
        self.canvas.unsetMapTool(self.polyligne_tool)
        self.canvas.unsetMapTool(self.punctual_tool)
        self.canvas.unsetMapTool(self.action_tool)
        self.canvas.unsetMapTool(self.num_parc_tool)
