# -*- coding: utf-8 -*-
"""
/***************************************************************************
 ToolBoxDialog
                                 A QGIS plugin
 This plugin is a suite of tools for the ImPact Analysis
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2020-07-27
        git sha              : $Format:%H$
        copyright            : (C) 2020 by Hamed Eftekhar @ ANYWAYS
        email                : hamed@anyways.eu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os
from qgis.PyQt.QtWidgets import QDialog, QFileDialog
from qgis.PyQt import uic
from qgis.PyQt import QtWidgets
from PyQt5.QtGui import *
from qgis.core import QgsProject, QgsMapLayerProxyModel
from .ImPact_toolbox_dialog_base import Ui_APIRequestDialogBase

class ToolBoxDialog(QDialog, Ui_APIRequestDialogBase):

    def __init__(self, parent=None):
        """Constructor."""
        super(ToolBoxDialog, self).__init__(parent)

        #load UI
        self.setupUi(self)
        
        #Retrive the Key & project path (if plugin is launched in a saved Qgis project file and insert them in the coresponding boxed (show them in their boxes)
        key_path=os.path.dirname(os.path.realpath(__file__))+"/API_Key.txt"
        try:
            ExistingKey=open(key_path, "r+").read()
            self.routingTab_KeyHolder.setText(ExistingKey)
        except IOError:
            self.routingTab_KeyHolder.setText("")
            
        dir_path = QgsProject.instance().readPath("./")
        if dir_path == "./" :
            self.routingTab1_outDirTxt.setText("")
            self.routingTab2_outDirTxt.setText("")
        else:
            self.routingTab1_outDirTxt.setText(dir_path)
            self.routingTab2_outDirTxt.setText(dir_path)
        
        #Filter QgsMapLayerComboBoxes to show Points layers only
        self.routingTab1_mLayers.setFilters(QgsMapLayerProxyModel.PointLayer)  
        self.routingTab2_O_mLayers.setFilters(QgsMapLayerProxyModel.PointLayer)
        self.routingTab2_D_mLayers.setFilters(QgsMapLayerProxyModel.PointLayer)
        
		#Show the default color in the color-box
        self.routingTab1_mColorBtn.setColor(QColor("#ffaa00"))
        self.routingTab2_mColorBtn.setColor(QColor("#ffaa00"))
		
        #connect eventhandlers
        self.routingTab1_OutDirBtn.clicked.connect( self.dir1clicked )
        self.routingTab2_OutDirBtn.clicked.connect( self.dir2clicked )
        


    #eventhandlers 
    dir1clicked = lambda self: self.routingTab1_outDirTxt.setText(
         QFileDialog.getExistingDirectory(self, "Select a directory to save routings", "") )
    dir2clicked = lambda self: self.routingTab2_outDirTxt.setText(
         QFileDialog.getExistingDirectory(self, "Select a directory to save routings", "") )
