# -*- coding: utf-8 -*-
"""
/***************************************************************************
 Anomalies2ContoursDialog
                                 A QGIS plugin
 This plugin converts statistical anomalies into contours based on custom parameters.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2025-07-28
        git sha              : $Format:%H$
        copyright            : (C) 2025 by Marhes S. & Hudak V.
        email                : sergemarhes@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os

from qgis.PyQt import uic, QtWidgets
from qgis.core import QgsMapLayerProxyModel

# This loads your .ui file so that PyQt can populate your plugin with the elements from Qt Designer
FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'anomalies2contours_dialog_base.ui'))


class Anomalies2ContoursDialog(QtWidgets.QDialog, FORM_CLASS):
    def __init__(self, parent=None):
        """Constructor."""
        super(Anomalies2ContoursDialog, self).__init__(parent)
        # Set up the user interface from Designer through FORM_CLASS.
        # After self.setupUi() you can access any designer object by doing
        # self.<objectname>, and you can use autoconnect slots - see
        # http://qt-project.org/doc/qt-4.8/designer-using-a-ui-file.html
        # #widgets-and-dialogs-with-auto-connect
        self.setupUi(self)

        # Фільтруємо лише растрові шари
        self.radioButton.clicked.connect(self.on_radioButton)
        self.radioButton_2.clicked.connect(self.on_radioButton_2)
        self.mMapLayerComboBox.currentIndexChanged.connect(self.on_raster_changed)
        self.mMapLayerComboBox.setFilters(QgsMapLayerProxyModel.RasterLayer)
        self.doubleSpinBox.valueChanged.connect(self.on_spinbox_value_changed)

    def on_radioButton(self):
        self.doubleSpinBox.setValue(3)
    def on_radioButton_2(self):
        self.doubleSpinBox.setValue(2)
    
    def on_spinbox_value_changed(self, value):
        if value == 3:
            self.radioButton.setChecked(True)
        elif value == 2:
            self.radioButton_2.setChecked(True)
        else:
            self.radioButton_3.setChecked(True)

    def on_raster_changed(self, index):
        # Очистити список бендів
        self.mRasterBandComboBox.clear()
            
    
        # Отримати вибраний шар
        layer = self.mMapLayerComboBox.currentLayer()
        if not layer:
            return
    
        # Отримати кількість бендів
        raster = layer.dataProvider()
        band_count = raster.bandCount()
    
        # Заповнити mRasterBandComboBox назвами бендів (або просто числами)
        for i in range(1, band_count + 1):
            self.mRasterBandComboBox.addItem(f"Band {i}", i)