import math
import time

import os

import processing
from qgis.core import *
from qgis.utils import *
from qgis.gui import *
from PyQt5.QtGui import *
from PyQt5.QtCore import *
from PyQt5.QtWidgets import *
from PyQt5 import QtWidgets
import sys
import pandas as pd

from .AndalusianPopulation_loader import *
from .AndalusianPopulation_startup1 import *

class InterfazDeCarga(QWidget):
    def __init__(self,parent,geometria):
        super().__init__()
        self.resize(200, 100);
        dlggLayout = QVBoxLayout(self)
        self.spinner=QtWaitingSpinner(self)
        dlggLayout.addWidget(self.spinner)
        self.setLayout(dlggLayout)
        self.spinner.start()
        #ventana_error(titulo="Importación finalizada",mensaje="Proceso de importación finalizado correctamente")
        
    def cerrar(self):
        self.spinner.stop()
        self.close()

class VentanaError(QDialog):
    def __init__(self,parent=None,titulo="ERROR",mensaje="Error!"):
        super().__init__()
        self.ventana_errores = QWidget(self)
        self.setWindowTitle(str(titulo))
        self.setGeometry(500, 400, 300, 150)
        vLayout = QVBoxLayout(self)
        self.ventana_errores.setLayout(vLayout)
        
        texto=QPlainTextEdit (str(mensaje))
        texto.setReadOnly(True)
        texto.setStyleSheet("background-color: transparent;")
        texto.setMaximumHeight(100)
        #texto.setSizePolicy(QSizePolicy.Preferred, QSizePolicy.MinimumExpanding)
        vLayout.addWidget(texto)
        vLayout.addStretch(1)

        
        self.buttonBox = QDialogButtonBox(self)
        self.buttonBox.setOrientation(Qt.Horizontal)
        self.buttonBox.setStandardButtons(QDialogButtonBox.Close|QDialogButtonBox.Ok)
        self.buttonBox.setCenterButtons(False)
        self.buttonBox.accepted.connect(self.aceptar)
        self.buttonBox.rejected.connect(self.cerrar)
        vLayout.addWidget(self.buttonBox, alignment=Qt.AlignRight | Qt.AlignBottom)
        #vLayoutAux.addWidget(self.buttonBox)
        
    def cerrar(self):
        self.close()
    def aceptar(self):
        self.accept()
    

class InterfazMapa(QDialog):
    def __init__(self,parent=None,lista_url_capas250=[],TipoTasa=[]):
        super().__init__(parent)
        self.TipoTasa=TipoTasa
        self.lista_url_capas250=lista_url_capas250
        self.Language=int(self.lista_url_capas250[6])

        aux=["#00ff00","#009000","#ffff00","#ff9000","#ff0000"]
        self.color_lista=[]
        for i in range(len(TipoTasa)):
            self.color_lista.append(aux)
        aux=[0 for i in range(len(aux))]
        self.condicion_lista=[aux for i in range(len(TipoTasa))]
        self.minimo=[0 for i in range(len(TipoTasa))]
        self.maximo=[1 for i in range(len(TipoTasa))]
        self.idCurrentRow=-1

        self.setWindowFlag(Qt.WindowMinimizeButtonHint, True)
        self.setWindowFlag(Qt.WindowMaximizeButtonHint, True)
        self.setWindowTitle('Characterization Andalusian Population')
        self.setGeometry(250, 180, 900, 700)
        self.main_widget = QtWidgets.QWidget(self)
        self.main_widget.setFocus(True)
        
        dlgLayout = QVBoxLayout()
        self.main_widget.setLayout(dlgLayout)    
        
        self.tabwidget = QTabWidget()
        #tabwidget.addTab(inequidadVLayout, "Tab 1")

        nombres_capas=[]
        
        self.inequidadGUI()
        self.configuracionGUI()
        dlgLayout.addWidget(self.tabwidget, 0)
        self.setLayout(dlgLayout)
        self.show()
        
    def inequidadGUI(self):
        inequidadVLayout = QVBoxLayout()
        gb_archivo = QGroupBox(Language("Archivo","File",self.Language))
        verticalLayoutArchivo = QVBoxLayout()
        horzLayout01 = QHBoxLayout()
        #gb_archivo.setAlignment(Qt.AlignHCenter)
        gb_archivo.setStyleSheet('QGroupBox {'
        'border: 2px outset gray;'
        'border-radius: 5px;'
        'margin-top: 0.5em;}'
        'QGroupBox::title {'
        'subcontrol-origin: margin;'
        'left: 10px;'
        'padding: 0 3px;}')
        horzLayout01.addWidget(QLabel(Language('Nombre de la imagen:','Name:',self.Language)))
        self.nombre_fichero=QLineEdit(Language('mapa','map',self.Language))
        horzLayout01.addWidget(self.nombre_fichero)
        verticalLayoutArchivo.addLayout(horzLayout01)
        
        horzLayout02 = QHBoxLayout()
        btn_directorio = QPushButton('...')
        btn_directorio.setDefault(False)
        btn_directorio.setAutoDefault(False)
        horzLayout02.addWidget(QLabel(Language('Directorio de la imagen:','Path:',self.Language)))
        self.data_path=QLineEdit(str(QgsProject.instance().readPath("./")))
        horzLayout02.addWidget(self.data_path)
        horzLayout02.addWidget(btn_directorio)
        btn_directorio.clicked.connect(self.obtener_directorio)
        verticalLayoutArchivo.addLayout(horzLayout02)
        gb_archivo.setLayout(verticalLayoutArchivo)
        
        inequidadVLayout.addWidget(gb_archivo)
        inequidadVLayout.addWidget(QLabel("")) 
        
        gb_valor_referencia = QGroupBox(Language("Parámetros espaciales",'Spatial parameters',self.Language))
        gb_valor_referencia.setStyleSheet('QGroupBox {'
        'border: 2px inset gray;'
        'border-radius: 5px;'
        'margin-top: 0.5em;}'
        'QGroupBox::title {'
        'subcontrol-origin: margin;'
        'left: 10px;'
        'padding: 0 3px;}')
        verticalLayoutValorReferencia = QVBoxLayout()
        self.horzLayout2 = QHBoxLayout()
        self.myCombobox_valor_coordenadas = QComboBox()
        self.myCombobox_valor_coordenadas.addItem(Language('Coordenadas','Coordinates',self.Language))
        self.myCombobox_valor_coordenadas.addItem(Language('Municipio','Town',self.Language))
        self.myCombobox_valor_coordenadas.setMinimumContentsLength(15) 
        self.myCombobox_valor_coordenadas.activated.connect(self.mostrar_tipologia_valor_coordenadas)
        self.horzLayout2.addWidget(self.myCombobox_valor_coordenadas)
        self.xymunicipiolineedit=QLineEdit("")
        
        basepath = os.path.dirname(os.path.realpath(__file__)) + "\\"
        df=pd.read_csv(basepath + "municipios.csv",sep=";",decimal=",",header=0,encoding='latin-1')
        # sorting by first name
        df.sort_values("Municipio", inplace = True)
        
          
        # dropping ALL duplicte values
        df.drop_duplicates(subset ="Municipio",
                             keep = 'first', inplace = True)
        names=df["Municipio"]
        completer = QCompleter(names)
        completer.setCaseSensitivity(QtCore.Qt.CaseInsensitive)
        self.xymunicipiolineedit.setCompleter(completer)
        self.xymunicipiolineedit.setVisible(False)
        self.xymunicipioqlabel=QLabel(Language('Municipio:','Town:',self.Language))
        self.xymunicipioqlabel.setVisible(False)
        self.horzLayout2.addWidget(self.xymunicipioqlabel)
        self.xymunicipiolineedit.textChanged.connect(self.calcula_valor_coordenadas)
        self.horzLayout2.addWidget(self.xymunicipiolineedit)
        
        self.xqlineedit=QLineEdit("294326")
        self.yqlineedit=QLineEdit("4122700")
        self.horzLayout2.addWidget(QLabel('X:'))
        self.horzLayout2.addWidget(self.xqlineedit)
        self.horzLayout2.addStretch(1)
        self.horzLayout2.addWidget(QLabel('Y:'))
        self.horzLayout2.addWidget(self.yqlineedit)
        self.horzLayout2.addStretch(1)
        self.horzLayout2.addWidget(QLabel(Language('Distancia de visualización del mapa(m):','Map viewing distance(m):',self.Language)))
        self.bufferVisionLineedit=QLineEdit("1000")
        self.horzLayout2.addWidget(self.bufferVisionLineedit)
        self.horzLayout2.addStretch(20)
        verticalLayoutValorReferencia.addLayout(self.horzLayout2)

        horzLayout03 = QHBoxLayout()
        horzLayout03.addWidget(QLabel(Language('Comparar respecto a:','Compare with:',self.Language))) 
        self.myCombobox_valor_referencia = QComboBox()
        self.myCombobox_valor_referencia.addItem(Language('Andalucia','Andalusia',self.Language))
        self.myCombobox_valor_referencia.addItem(Language('Provincia','Province',self.Language))
        self.myCombobox_valor_referencia.addItem(Language('Municipio','Town',self.Language))
        self.myCombobox_valor_referencia.addItem('Buffer')
        self.myCombobox_valor_referencia.setMinimumContentsLength(15) 
        self.myCombobox_valor_referencia.activated.connect(self.mostrar_tipologia_valor_referencia)
        horzLayout03.addWidget(self.myCombobox_valor_referencia)
        horzLayout03.addStretch(1) 
        self.valorRererenciaQlabel=QLabel('')
        horzLayout03.addWidget(self.valorRererenciaQlabel)
        self.bufferlineedit= QLineEdit('1000')
        self.bufferlineedit.setVisible(False)
        horzLayout03.addWidget(self.bufferlineedit)
        self.myCombobox_valor_referencia_provincia=QComboBox()
        self.myCombobox_valor_referencia_provincia.addItem('XY')
        self.myCombobox_valor_referencia_provincia.addItem('Almeria')
        self.myCombobox_valor_referencia_provincia.addItem('Cadiz')
        self.myCombobox_valor_referencia_provincia.addItem('Cordoba')
        self.myCombobox_valor_referencia_provincia.addItem('Granada')
        self.myCombobox_valor_referencia_provincia.addItem('Huelva')
        self.myCombobox_valor_referencia_provincia.addItem('Jaen')
        self.myCombobox_valor_referencia_provincia.addItem('Malaga')
        self.myCombobox_valor_referencia_provincia.addItem(Language('Sevilla','Seville',self.Language))
        self.myCombobox_valor_referencia_provincia.setMinimumContentsLength(15) 
        self.myCombobox_valor_referencia_provincia.setVisible(False)
        horzLayout03.addWidget(self.myCombobox_valor_referencia_provincia)
        self.municipiolineedit= QLineEdit('XY')
        

        df=pd.read_csv(basepath + "tabla.csv",sep=";",decimal=",",header=0)
        # sorting by first name
        df.sort_values("municipio", inplace = True)
          
        # dropping ALL duplicte values
        df.drop_duplicates(subset ="municipio",
                             keep = 'first', inplace = True)
        names=df["municipio"]
        completer = QCompleter(names)
        completer.setCaseSensitivity(QtCore.Qt.CaseInsensitive)
        self.municipiolineedit.setCompleter(completer)
        self.municipiolineedit.setVisible(False)
        horzLayout03.addWidget(self.municipiolineedit)
        horzLayout03.addStretch(20) 
        verticalLayoutValorReferencia.addLayout(horzLayout03)

        horzLayoutaux=QHBoxLayout()
        btnCalcular = QPushButton(Language('Aplicar','Apply',self.Language))
        btnCalcular.clicked.connect(self.CalculaParametrosEspaciales)
        horzLayoutaux.addWidget(btnCalcular)
        horzLayoutaux.addStretch(1) 
        verticalLayoutValorReferencia.addLayout(horzLayoutaux)
        
        gb_valor_referencia.setLayout(verticalLayoutValorReferencia)
        
        inequidadVLayout.addWidget(gb_valor_referencia)
        
        inequidadVLayout.addWidget(QLabel("")) 
        titulo_listwidget=QLabel(Language('Tasa 250x250','Rate 250x250',self.Language))
        titulo_listwidget.setFont(QFont('Arial', 12))
        VertTasaLayout = QVBoxLayout()
        VertTasaLayout.addWidget(titulo_listwidget)
        self.listwidget_capas250=QListWidget()
        #self.listwidget_capas250.setSelectionMode (QAbstractItemView.ExtendedSelection) # Hold CTRL to select multiple
        
        incr=0
        for malla250 in self.TipoTasa:
            malla250=malla250[1]
            self.listwidget_capas250.addItem(str(incr+1) + ". "+ malla250)#myQListWidgetItem
            self.listwidget_capas250.item(incr).setFont(QFont('Arial', 14))
            incr+=1
        self.listwidget_capas250.setSpacing(5)
        self.listwidget_capas250.itemClicked.connect(self.calculaSimbologia)
        VertTasaLayout.addWidget(self.listwidget_capas250) 
        HorzListLayout = QHBoxLayout()
        HorzListLayout.addLayout(VertTasaLayout)
        
        self.tituloLlistwidgetSimbologia=QLabel(Language('Simbologia','Symbology',self.Language))
        self.tituloLlistwidgetSimbologia.setFont(QFont('Arial', 12))
        VertSimbologiaLayout = QVBoxLayout()
        VertSimbologiaLayout.addWidget(self.tituloLlistwidgetSimbologia)
        self.listwidget_capas250_simbologia=QListWidget()
        
        self.listwidget_capas250_simbologia.itemDoubleClicked.connect(self.cambiar_color)
        self.listwidget_capas250_simbologia.itemPressed.connect(self.deshabilitarImportacion)
        self.listwidget_capas250_simbologia.setFixedHeight(300)
        #self.listwidget_capas250.setSelectionMode (QAbstractItemView.ExtendedSelection) # Hold CTRL to select multiple
        self.listwidget_capas250_simbologia.setDragDropMode(QAbstractItemView.InternalMove)
        self.listwidget_capas250_simbologia.setAcceptDrops(True)
        VertSimbologiaLayout.addWidget(self.listwidget_capas250_simbologia) 

        sliderLayout = QHBoxLayout()
        sliderLayout.addWidget(QLabel(Language('Opacidad:','Opacity:',self.Language))) 

        self.opacidadSlider = QSlider(Qt.Horizontal)
        self.opacidadSlider.setFocusPolicy(Qt.StrongFocus)
        self.opacidadSlider.setTickPosition(QSlider.TicksBelow)
        self.opacidadSlider.setMinimum(0)
        self.opacidadSlider.setMaximum(100)
        self.opacidadSlider.setTickInterval(10)
        self.opacidadSlider.setSingleStep(10)
        self.opacidadSlider.setValue(50)
        self.opacidadSlider.valueChanged.connect(self.cambioOpacidadSlider)
        sliderLayout.addWidget(self.opacidadSlider)

        self.opacidadLineEdit=QLineEdit("50")
        self.opacidadLineEdit.setMaxLength(3)
        self.opacidadLineEdit.setFixedWidth(40)
        self.opacidadLineEdit.setValidator(QIntValidator())
        self.opacidadLineEdit.textChanged.connect(self.cambioOpacidadLineEdit)
        sliderLayout.addWidget(self.opacidadLineEdit)

        sliderLayout.addWidget(QLabel('%')) 
        VertSimbologiaLayout.addLayout(sliderLayout) 


        btnLayout1 = QHBoxLayout()
        self.btn1_0 = QPushButton(Language('Eliminar','Delete',self.Language))
        self.btn1_0.clicked.connect(self.eliminarItemSimbologia)
        self.btn1_0.setEnabled(False)
        btnLayout1.addWidget(self.btn1_0)
        btnLayout1.addStretch(1)
        self.btn1_1 = QPushButton(Language('Añadir','Add',self.Language))
        self.btn1_1.clicked.connect(self.anadirSimbologia)
        self.btn1_1.setEnabled(False)
        btnLayout1.addWidget(self.btn1_1)
        btnLayout1.addStretch(1)
        self.btn1_2 = QPushButton(Language('Invertir colores','Invert colors',self.Language))
        self.btn1_2.clicked.connect(self.invertirColor)
        self.btn1_2.setEnabled(False)
        btnLayout1.addWidget(self.btn1_2)
        VertSimbologiaLayout.addLayout(btnLayout1)
        
        HorzListLayout.addLayout(VertSimbologiaLayout)
        inequidadVLayout.addLayout(HorzListLayout)
        
        self.checkbox_capa_tasa=QtWidgets.QCheckBox(Language('Mantener la capa de la tasa despues de la exportación','Keep the rate layer after export',self.Language))
        self.checkbox_centro=QtWidgets.QCheckBox(Language('Mantener la capa del punto central despues de la exportación','Keep center point layer after export',self.Language))
        self.checkbox_buffer=QtWidgets.QCheckBox(Language('Mantener la capa buffer despues de la exportación','Keep buffer layer after export',self.Language))
        self.checkbox_capa_cdau=QtWidgets.QCheckBox(Language('Emplear la capa CDAU en vez de la ortofoto','Use the CDAU layer instead of the orthophoto',self.Language))
        inequidadVLayout.addWidget(self.checkbox_capa_tasa) 
        inequidadVLayout.addWidget(self.checkbox_centro) 
        inequidadVLayout.addWidget(self.checkbox_buffer) 
        inequidadVLayout.addWidget(self.checkbox_capa_cdau) 

        inequidadVLayout.addStretch(1)
        btnLayout = QHBoxLayout()
        btn1 = QPushButton(Language('Cerrar','Close',self.Language))
        btn1.clicked.connect(self.cerrar)
        btnLayout.addWidget(btn1)
        btnLayout.addStretch(1)
        self.labelCargando=QLabel(Language('Calculando','Busy',self.Language))
        self.spinner=QtWaitingSpinner(self)
        btnLayout.addWidget(self.spinner)
        self.labelCargando.setVisible(False)
        btnLayout.addWidget(self.labelCargando)
        btnLayout.addStretch(1)
        self.btn1_3 = QPushButton(Language('Aplicar','Apply',self.Language))
        self.btn1_3.clicked.connect(self.aplicarCambios)
        self.btn1_3.setEnabled(True)
        self.btn1_3.setDefault(True)
        self.btn1_3.setAutoDefault(True)
        btnLayout.addWidget(self.btn1_3)
        self.btn1_4 = QPushButton(Language('Exportar','Export',self.Language))
        self.btn1_4.clicked.connect(self.ejecutar_inequidad)
        self.btn1_4.setEnabled(False)
        btnLayout.addWidget(self.btn1_4)
        inequidadVLayout.addLayout(btnLayout)
        
        tab1=QWidget()
        tab1.setLayout(inequidadVLayout)
        self.tabwidget.addTab(tab1, Language('Mapa','Map',self.Language))
    def configuracionGUI(self):
        configuracionVLayout = QVBoxLayout()
        
        formLayout = QFormLayout()
        btnLayout = QHBoxLayout()
        
        self.url_ortofoto=QLineEdit(self.lista_url_capas250[0])
        self.url_cdau=QLineEdit(self.lista_url_capas250[8])
        self.url_municipios=QLineEdit(self.lista_url_capas250[1])
        self.url_gridpob=QLineEdit(self.lista_url_capas250[2])
        self.url_gridcatt=QLineEdit(self.lista_url_capas250[3])
        self.url_gridmort=QLineEdit(self.lista_url_capas250[4])
        self.url_gridcatv=QLineEdit(self.lista_url_capas250[5])
        self.texto_buffer=QLineEdit(self.lista_url_capas250[7])

        self.combobox_language=QComboBox()
        self.combobox_language.addItem('Español')
        self.combobox_language.addItem('English')
        if int(self.lista_url_capas250[6])==0:
            self.lista_url_capas250[6]='1'
        self.combobox_language.setCurrentIndex(int(self.lista_url_capas250[6])-1)
        
        formLayout.addRow(Language('Idioma','Language',self.Language), self.combobox_language)
        formLayout.addRow(Language('Fuente capa ortofoto (WMS)','Source layer orthophoto (WMS)',self.Language), self.url_ortofoto)
        formLayout.addRow(Language('Fuente capa CDAU (WMS)','Source layer CDAU (WMS)',self.Language), self.url_cdau)
        formLayout.addRow(Language('Fuente capa municipios (WFS)','Source layer towns (WFS)',self.Language), self.url_municipios)
        formLayout.addRow(Language('Fuente capa grid de población (WFS)','Source layer population grid (WFS)',self.Language), self.url_gridpob)
        formLayout.addRow(Language('Fuente capa gridcattp de tipologías constructivas (WFS)','Source layer construction typologies grid (WFS)',self.Language), self.url_gridcatt)
        formLayout.addRow(Language('Fuente capa grid de mortalidad (WFS)','Source layer mortality grid (WFS)',self.Language), self.url_gridmort)
        formLayout.addRow(Language('Nombre capa buffer','Buffer layer name',self.Language), self.texto_buffer)
        configuracionVLayout.addLayout(formLayout)
        
        btn1 = QPushButton(Language('Cerrar','Close',self.Language))
        btn1.clicked.connect(self.cerrar)
        btnLayout.addWidget(btn1)
        btnLayout.addStretch(1)
        btn2 = QPushButton(Language('Aplicar','Apply',self.Language))
        btn2.clicked.connect(self.AplicarUrl)
        configuracionVLayout.addStretch(1)
        btnLayout.addWidget(btn2)
        configuracionVLayout.addLayout(btnLayout) 
    
        tab3=QWidget()
        tab3.setLayout(configuracionVLayout)
        self.tabwidget.addTab(tab3, Language('Configuracion','Configuration',self.Language))
    def AplicarUrl(self):
        layer_ortofoto = QgsRasterLayer(self.url_ortofoto.text(), "Capa ortofoto", "WMS")
        layer_cdau = QgsRasterLayer(self.url_cdau.text(), "Capa CDAU", "WMS")
        layer_municipios = QgsVectorLayer(self.url_municipios.text(), "Capa municipios", "WFS")
        layer_pob = QgsVectorLayer(self.url_gridpob.text(), "Capa pob", "WFS")
        layer_catt = QgsVectorLayer(self.url_gridcatt.text(), "Capa catt", "WFS")
        layer_mort = QgsVectorLayer(self.url_gridmort.text(), "Capa mort", "WFS")
        layer_catv = QgsVectorLayer(self.url_gridcatv.text(), "Capa catv", "WFS")

        if not layer_ortofoto.isValid():
            VentanaError(mensaje=Language('La fuente de la capa ortofoto no es válida','Orthophoto layer source invalid',self.Language)).exec()
            return
        elif not layer_cdau.isValid():
            VentanaError(mensaje=Language('La fuente de la capa CDAU no es válida','CDAU layer source invalid',self.Language)).exec()
            return
        elif not layer_municipios.isValid():
            VentanaError(mensaje=Language('La fuente de la capa municipios no es válida','Towns layer source invalid',self.Language)).exec()
            return
        elif not layer_pob.isValid():
            VentanaError(mensaje=Language('La fuente de la capa grid de población no es válida','Population grid layer source invalid',self.Language)).exec()
            return
        elif not layer_catt.isValid():
            VentanaError(mensaje=Language('La fuente de la capa grid gridcattp no es válida','Construction typologies grid layer source invalid',self.Language)).exec()
            return
        elif not layer_mort.isValid():
            VentanaError(mensaje=Language('La fuente de la capa grid de mortalidad no es válida','Mortality grid layer source invalid',self.Language)).exec()
            return
        elif not layer_catv.isValid():
            VentanaError(mensaje=Language('La fuente de la capa grid de viviendas no es válida','Households grid layer source invalid',self.Language)).exec()
            return
        self.lista_url_capas250[0]=self.url_ortofoto.text()
        self.lista_url_capas250[1]=self.url_municipios.text()
        self.lista_url_capas250[2]=self.url_gridpob.text()
        self.lista_url_capas250[3]=self.url_gridcatt.text()
        self.lista_url_capas250[4]=self.url_gridmort.text()
        self.lista_url_capas250[5]=self.url_gridcatv.text()
        self.lista_url_capas250[6]=str(self.combobox_language.currentIndex()+1)
        self.lista_url_capas250[7]=self.texto_buffer.text()
        self.lista_url_capas250[8]=self.url_cdau.text()
        
        aux=ComprobarCambiosGridTXT(self.lista_url_capas250)
        if (aux==1):
            if(VentanaError(titulo=Language('Aplicar cambios','Apply changes',self.Language),
            mensaje=Language("Para aplicar los cambios, QGIS se cerrará y cuando se ejecute de nuevo el Plugin, "
            "se llevará a cabo la instalación de la/s nueva/s capa/s.\n\n¿Desea continuar?",
            "To apply changes, QGIS will be closed,and when the Plugin is executed again, "
            "the installation of the new layer will be carried out.\n\nDo you wish to continue?",self.Language)).exec()):
                ActualizarUrl(self.lista_url_capas250)

                EliminarTablaCSV()
                sys.exit()
            else:#Si el usuario no acepta, se sale sin actualizar la Url en el TXT
                return
        elif aux==2:
            if(VentanaError(titulo=Language('Aplicar cambios','Apply changes',self.combobox_language.currentIndex()+1),
            mensaje=Language("Para aplicar los cambios, QGIS se cerrará.\n\n¿Desea continuar?",
            "To apply changes, QGIS will be closed.\n\nDo you wish to continue?",self.combobox_language.currentIndex()+1)).exec()):
                ActualizarUrl(self.lista_url_capas250)
                sys.exit()
            else:#Si el usuario no acepta, se sale sin actualizar el idioma en el TXT
                return
        ActualizarUrl(self.lista_url_capas250)
    def aplicarCambios(self):
        if self.idCurrentRow==-1:
            VentanaError(mensaje=Language('Seleccione una tasa antes de continuar','Please select a rate',self.Language)).exec()
            return
        self.getSimbologia()
        self.muestraSimbologia()
        self.btn1_4.setEnabled(True)
        self.btn1_4.setDefault(True)
        self.btn1_4.setAutoDefault(True)
    def deshabilitarImportacion(self):
        self.btn1_4.setEnabled(False)
        self.btn1_4.setDefault(False)
        self.btn1_4.setAutoDefault(False)
        self.btn1_3.setDefault(True)
        self.btn1_3.setAutoDefault(True)
    def cerrar(self):
        self.close()
    def ejecutar_inequidad(self): #HACER QUE SE VEA POR DELANTE DEL QDIALOG

        self.seleccionar_capas_criterio(importar=1)
    def invertirColor(self):
        self.color_lista[self.idCurrentRow].reverse()
        self.muestraSimbologia()
        self.deshabilitarImportacion()
    def cambioOpacidadSlider(self):
        self.opacidadLineEdit.setText(str(self.opacidadSlider.value()))
    def cambioOpacidadLineEdit(self):
        if self.opacidadLineEdit.text()!='':
            self.opacidadSlider.setValue(int(self.opacidadLineEdit.text()))
        else:
            self.opacidadLineEdit.setText("0")
    def obtener_directorio(self):
        dialog = QFileDialog()
        self.data_path.setText(dialog.getExistingDirectory(None, Language('Directorio de la imagen','Select path',self.Language),self.data_path.text()))
    def calculaSimbologia(self):
        #Se inicializan las condiciones
        self.idCurrentRow=self.listwidget_capas250.currentRow()
        if self.seleccionar_capas_criterio(importar=0)==0:
            self.idCurrentRow=-1
            return 0
        if self.listwidget_capas250_simbologia.count()==0:
            for id in range(len(self.color_lista[self.idCurrentRow])):
                self.CreaItemSimbologia(id)
        self.muestraSimbologia()
        self.btn1_0.setEnabled(True)
        self.btn1_1.setEnabled(True)
        self.btn1_2.setEnabled(True)
        self.deshabilitarImportacion()
    def CalculaParametrosEspaciales(self):
        if self.idCurrentRow>=0:
            self.calculaSimbologia()

    def muestraSimbologia(self):
        for incr in range(len(self.color_lista[self.idCurrentRow])):
            self.listwidget_capas250_simbologia.item(incr).widgetText.setText(str(self.condicion_lista[self.idCurrentRow][incr]))
            self.listwidget_capas250_simbologia.item(incr).widgetLabel.setStyleSheet(
                "border: 1px solid black;min-width: 20px;min-height: 20px;background-color: " + str(self.color_lista[self.idCurrentRow][incr]))
        self.actualiza_leyenda()
    def CreaItemSimbologia(self,id):
        myQListWidgetItem=clase_colores(id=id,color=self.color_lista[self.idCurrentRow][id],condicion=self.condicion_lista[self.idCurrentRow][id])
        self.listwidget_capas250_simbologia.addItem(myQListWidgetItem)#myQListWidgetItem
        self.listwidget_capas250_simbologia.setItemWidget(myQListWidgetItem, myQListWidgetItem.widget)
        self.listwidget_capas250_simbologia.item(id).widgetText.editingFinished.connect(self.actualiza_leyenda)
    def eliminarItemSimbologia(self):
        id=self.listwidget_capas250_simbologia.currentRow()
        if id>=0:
            self.listwidget_capas250_simbologia.takeItem(id)
            self.color_lista[self.idCurrentRow].pop(id)
            self.condicion_lista[self.idCurrentRow].pop(id)
        if self.listwidget_capas250_simbologia.count():
            self.actualiza_leyenda()
        self.deshabilitarImportacion()
    def actualiza_leyenda(self):
        id=0
        for id in range(self.listwidget_capas250_simbologia.count()-1):
            legend1=self.listwidget_capas250_simbologia.item(id).widgetText.text()
            legend2=self.listwidget_capas250_simbologia.item(id+1).widgetText.text()
            texto=str(legend1) + " - " + str(legend2)
            self.listwidget_capas250_simbologia.item(id).widgetLabelLeyenda.setText(texto)
        #Ultimo valor
        if id>0:
            self.listwidget_capas250_simbologia.item(id+1).widgetLabelLeyenda.setText(str(legend2)+" - "+str(self.maximo[self.idCurrentRow]))
    def calcula_valor_coordenadas(self):
        basepath = os.path.dirname(os.path.realpath(__file__)) + "\\"
        df=pd.read_csv(basepath + "municipios.csv",sep=";",decimal=",",header=0,encoding='latin-1')
        utmxy=df[(df["Municipio"] == self.xymunicipiolineedit.text())]
        if len(utmxy)==1:
            self.xqlineedit.setText(str(utmxy.iat[0,1]))
            self.yqlineedit.setText(str(utmxy.iat[0,2]))
    def muestraCargando(self):
        self.labelCargando.setVisible(True)
        self.spinner.start()
    def ocultaCargando(self):
        self.labelCargando.setVisible(False)
        self.spinner.stop()
    def mostrar_tipologia_valor_coordenadas(self):
        id=self.myCombobox_valor_coordenadas.currentIndex()
        if id==0:
            self.xymunicipiolineedit.setVisible(False)
            self.xymunicipioqlabel.setVisible(False)
        elif id==1:
            self.xymunicipiolineedit.setVisible(True)
            self.xymunicipioqlabel.setVisible(True)
    def mostrar_tipologia_valor_referencia(self):
        id=self.myCombobox_valor_referencia.currentIndex()
        if (id==0):#Andalucia
            self.valorRererenciaQlabel.setText('')
            self.bufferlineedit.setVisible(False)
            self.myCombobox_valor_referencia_provincia.setVisible(False)
            self.municipiolineedit.setVisible(False)
        elif(id==1):#Provincia
            self.valorRererenciaQlabel.setText(Language('Provincia:','Province:',self.Language))
            self.bufferlineedit.setVisible(False)
            self.myCombobox_valor_referencia_provincia.setVisible(True)
            self.municipiolineedit.setVisible(False)
        elif(id==2):#Municipio
            self.valorRererenciaQlabel.setText(Language('Municipio:','Town:',self.Language))
            self.bufferlineedit.setVisible(False)
            self.myCombobox_valor_referencia_provincia.setVisible(False)
            self.municipiolineedit.setVisible(True)
        elif (id==3):#Buffer
            self.valorRererenciaQlabel.setText('Dist. buffer(m):')
            self.bufferlineedit.setVisible(True)
            self.myCombobox_valor_referencia_provincia.setVisible(False)
            self.municipiolineedit.setVisible(False)
    def obtener_minmax(self,tipo=0,lista=[0,100]):
        CifRed=1 #numero de cifras de redondeo
        if(tipo==0):
            self.minimo[self.idCurrentRow]=lista[0]
            self.maximo[self.idCurrentRow]=lista[1]
            minimo=self.minimo[self.idCurrentRow]
            maximo=self.maximo[self.idCurrentRow]
            incr=(maximo-minimo)/5
            if (all(flag==0 for flag in (self.condicion_lista[self.idCurrentRow]))):
                self.condicion_lista[self.idCurrentRow]=[round(float(minimo),CifRed),round(float(minimo+incr),CifRed),round(float(minimo+2*incr),CifRed),
                round(float(minimo+3*incr),CifRed),round(float(minimo+4*incr),CifRed)]
        elif(tipo==1):
            self.minimo[self.idCurrentRow]=str(round(float(lista[0]),CifRed))
            self.maximo[self.idCurrentRow]=str(round(float(lista[5]),CifRed))
            self.condicion_lista[self.idCurrentRow]=[
            str(round(float(lista[0]),CifRed)),
            str(round(float(lista[1]),CifRed)),
            str(round(float(lista[2]),CifRed)),
            str(round(float(lista[3]),CifRed)),
            str(round(float(lista[4]),CifRed))
            ]
    def getSimbologia(self):
        self.color_lista[self.idCurrentRow]=[]
        self.condicion_lista[self.idCurrentRow]=[]
        for id in range(self.listwidget_capas250_simbologia.count()):
            self.color_lista[self.idCurrentRow].append(str(self.listwidget_capas250_simbologia.item(id).widgetLabel.palette().button().color().name()))
            self.condicion_lista[self.idCurrentRow].append(str(self.listwidget_capas250_simbologia.item(id).widgetText.text()))
    def anadirSimbologia(self):
        color="#000000"
        condicion=0
        id=self.listwidget_capas250_simbologia.count()
        self.color_lista[self.idCurrentRow].append(str(color))
        self.condicion_lista[self.idCurrentRow].append(str(condicion))
        self.CreaItemSimbologia(id)
        self.deshabilitarImportacion()
    def cambiar_color(self):
        color_nuevo_inequidad_1=QColorDialog.getColor().name()
        id=self.listwidget_capas250_simbologia.currentRow()
        self.listwidget_capas250_simbologia.item(id).widgetLabel.setStyleSheet("border: 1px solid black;min-width: 20px;min-height: 20px;background-color: " + color_nuevo_inequidad_1)    
        self.deshabilitarImportacion()
    def getcondTasa(self,zLayer):
        condTasa=0
        id=self.myCombobox_valor_referencia.currentIndex()
        if id==0:#Andalucia
            zLayer.setName(Language('Quintiles respecto a Andalucia','Quintiles with respect to Andalusia',self.Language))
            self.tituloLlistwidgetSimbologia.setText(Language('Simbología (Andalucía)','Symbology (Andalusia)',self.Language))
            pass
        elif id==1:#Provincia
            condTasa=self.myCombobox_valor_referencia_provincia.currentText()
            zLayer.setName(Language('Quintiles respecto a la provincia: ','Quintiles with respect to province: ',self.Language) + condTasa)
            self.tituloLlistwidgetSimbologia.setText(Language('Simbología (Provincia: ','Symbology (Province: ',self.Language) + str(condTasa) + ")")
        elif id==2:#Municipio
            condTasa=self.municipiolineedit.text()
            zLayer.setName(Language('Quintiles respecto al municipio: ','Quintiles with respect to town: ',self.Language) + condTasa)
            self.tituloLlistwidgetSimbologia.setText(Language('Simbología (Municipio: ','Symbology (Town: ',self.Language) + str(condTasa) + ")")
        elif id==3:#Buffer 
            condTasa=[]
            for f in zLayer.getFeatures():
                    condTasa.append(float(f['grd_floaid'].replace('.','')))
            zLayer.setName(Language('Quintiles respecto a buffer de ','Quintiles with respect to bufffer of ',self.Language) + str(self.bufferVisionLineedit.text()) + "m ")
            self.tituloLlistwidgetSimbologia.setText(Language('Simbología (Buffer: ','Symbology (Buffer: ',self.Language) + str(self.bufferVisionLineedit.text()) + "m" + ")")
        
        return condTasa
    
    def seleccionar_capas_criterio(self,importar=0):
        if self.CompruebaDirectorioOk()==0:
            return 0
        #Se eliminan todas las capas por precaucion
        tipoVersion=getVersion()
        numDecimales=1
        IdTasa=self.listwidget_capas250.currentRow()
        myTargetField=self.TipoTasa[IdTasa][0]
        NombreLeyenda=self.TipoTasa[IdTasa][1]
        tamano_buffer=float(self.bufferVisionLineedit.text())
        x=float(self.xqlineedit.text())
        y=float(self.yqlineedit.text())
        basepath = os.path.dirname(os.path.realpath(__file__)) + "\\"
        df=pd.read_csv(basepath + "tabla.csv",sep=";",decimal=",",header=0)
        if tipoVersion==1:
            tLayer=QgsVectorLayer("Point", Language('Instalación','Plant',self.Language),"memory")
            vLayer=QgsVectorLayer("Polygon", "buffer", "memory")
            tLayer.setCrs(QgsCoordinateReferenceSystem(25830))
            vLayer.setCrs(QgsCoordinateReferenceSystem(25830))
        else:
            tLayer=QgsVectorLayer("Point?crs=EPSG:25830", Language('Instalación','Plant',self.Language), "memory")
            vLayer=QgsVectorLayer("Polygon?crs=EPSG:25830", "buffer", "memory")
        myField = QgsField( 'id', QVariant.Int )
        vLayer.dataProvider().addAttributes([myField])
        vLayer.updateFields()
        point_centro = QgsGeometry.fromPointXY(QgsPointXY(float(x), float(y)))#yqlineedit.text()
        vpr = tLayer.dataProvider()
        f = QgsFeature()
        f.setGeometry(point_centro)
        vpr.addFeatures([f])
        tLayer.updateExtents()
        tFeats = tLayer.getFeatures()

        for tfeat in tLayer.getFeatures():
            geom = tfeat.geometry()
            buffer = geom.buffer(tamano_buffer, 5)
            feat_vista=tfeat
            tfeat.setGeometry(buffer)
            vLayer.dataProvider().addFeatures([tfeat])


        myTargetField=str(myTargetField)
        NombreLeyenda=str(NombreLeyenda)
        IdRereferencia=self.myCombobox_valor_referencia.currentIndex()
        Layer=AnadirLayerQGIS(url=self.lista_url_capas250[2],nombre="Capa grid de poblacion", tipoCapa="WFS")

        if (IdTasa==0):#Poblacion Total
            if tipoVersion==1:
                #zLayer=QgsVectorLayer(aux, "zLayer", "ogr")
                #QgsProject.instance().mapLayersByName('my layer name')[0]
                #QgsProject.instance().removeMapLayer(zLayer)
                interseccion=processing.run("qgis:extractbylocation", 
                {'INPUT':Layer, 
                'PREDICATE':0,
                'INTERSECT':vLayer,
                'OUTPUT':'TEMPORARY_OUTPUT'})
                
               
                zLayer=interseccion['OUTPUT']
                zLayer.setName(str(NombreLeyenda))
            else:
                interseccion=processing.run("qgis:selectbylocation", 
                {'INPUT':Layer, 
                'PREDICATE':0,
                'INTERSECT':vLayer,
                'METHOD':0})
                zLayer = interseccion.materialize(QgsFeatureRequest().setFilterFids(interseccion.selectedFeatureIds()))
                zLayer.setName(str(NombreLeyenda))
                
            myField = QgsField( myTargetField, QVariant.Double )
            zLayer.dataProvider().addAttributes([myField])
            zLayer.updateFields()
            prov = zLayer.dataProvider()
            numero_tasa=zLayer.fields().indexOf(myTargetField)
            zLayer.startEditing()

            poblacion=[]
            Tasa=[]
            for f in zLayer.getFeatures():
                    poblacion.append(float(f["pob_tot"]))
                    if all(flag > 0 for flag in [poblacion[-1]]):
                        Tasa.append(float(poblacion[-1]))
                    else:
                        Tasa.append(float(-1))
                    
                    zLayer.changeAttributeValue(f.id(), numero_tasa, Tasa[-1])

            zLayer.commitChanges()
            zLayer.updateFields()
            
            condTasa=self.getcondTasa(zLayer)
            if condTasa=="XY":
                condTasa=calcularXY(Tipo=IdRereferencia,tLayer=tLayer,lista_url_capas250=self.lista_url_capas250)
                if IdRereferencia==1:
                    zLayer.setName(Language('Quintiles respecto a la provincia: ','Quintiles with respect to province: ',self.Language) + condTasa)
                    self.tituloLlistwidgetSimbologia.setText(Language('Simbología (Provincia: ','Symbology (Province: ',self.Language)+ str(condTasa) + ")")
                elif IdRereferencia==2:
                    zLayer.setName(Language('Quintiles respecto al municipio: ','Quintiles with respect to town: ',self.Language) + condTasa)
                    self.tituloLlistwidgetSimbologia.setText(Language('Simbología (Municipio: ','Symbology (Town: ',self.Language)+ str(condTasa) + ")")

            #A partir de aqui es donde se modifica para cada Tasa
            Tasa = df[['grd_floaid','municipio','cmun']]
            Tasa[myTargetField]=df['pob_tot']
            Tasa=Tasa[(Tasa[myTargetField] >= 0)]
            Tasa=Tasa.round({myTargetField:numDecimales})

            (minimo,percentil_20,percentil_40,percentil_60,percentil_80,maximo)=calcularValorReferencia(Tipo=IdRereferencia, Tasa=Tasa, condTasa=condTasa)

        elif (IdTasa==1):#Tasa menores 15 años
            if tipoVersion==1:
                interseccion=processing.run("qgis:extractbylocation", 
                {'INPUT':Layer, 
                'PREDICATE':0,
                'INTERSECT':vLayer,
                'OUTPUT':'TEMPORARY_OUTPUT'})
                
                zLayer=interseccion['OUTPUT']
                zLayer.setName(str(NombreLeyenda))
            else:
                interseccion=processing.run("qgis:selectbylocation", 
                {'INPUT':Layer, 
                'PREDICATE':0,
                'INTERSECT':vLayer,
                'METHOD':0})
                zLayer = interseccion.materialize(QgsFeatureRequest().setFilterFids(interseccion.selectedFeatureIds()))
                zLayer.setName(str(NombreLeyenda))
                
            myField = QgsField( myTargetField, QVariant.Double )
            zLayer.dataProvider().addAttributes([myField])
            zLayer.updateFields()
            prov = zLayer.dataProvider()
            numero_tasa=zLayer.fields().indexOf(myTargetField)
            zLayer.startEditing()

            poblacion=[]
            poblacion15=[]
            Tasa=[]
            for f in zLayer.getFeatures():
                    poblacion.append(float(f["pob_tot"]))
                    poblacion15.append(float(f["edad0015"]))
                    if all(flag > 0 for flag in [poblacion[-1],poblacion15[-1]+0.1]):
                        Tasa.append(round(float(100*poblacion15[-1]/poblacion[-1]),numDecimales))
                    else:
                        Tasa.append(float(-1))
                    
                    zLayer.changeAttributeValue(f.id(), numero_tasa, Tasa[-1])

            zLayer.commitChanges()
            zLayer.updateFields()
            
            condTasa=self.getcondTasa(zLayer)
            if condTasa=="XY":
                condTasa=calcularXY(Tipo=IdRereferencia,tLayer=tLayer,lista_url_capas250=self.lista_url_capas250)
                if IdRereferencia==1:
                    zLayer.setName(Language('Quintiles respecto a la provincia: ','Quintiles with respect to province: ',self.Language) + condTasa)
                    self.tituloLlistwidgetSimbologia.setText(Language('Simbología (Provincia: ','Symbology (Province: ',self.Language)+ str(condTasa) + ")")
                elif IdRereferencia==2:
                    zLayer.setName(Language('Quintiles respecto al municipio: ','Quintiles with respect to town: ',self.Language) + condTasa)
                    self.tituloLlistwidgetSimbologia.setText(Language('Simbología (Municipio: ','Symbology (Town: ',self.Language)+ str(condTasa) + ")")

            #A partir de aqui es donde se modifica para cada Tasa
            dfReducido=df[(df['edad0015'] >= 0) & (df['pob_tot'] > 0)]
            Tasa = dfReducido[['grd_floaid','municipio','cmun']]
            Tasa[myTargetField]=100*(dfReducido['edad0015']/dfReducido['pob_tot'])
            Tasa=Tasa[(Tasa[myTargetField] >= 0)]
            Tasa=Tasa.round({myTargetField:numDecimales})
            (minimo,percentil_20,percentil_40,percentil_60,percentil_80,maximo)=calcularValorReferencia(Tipo=IdRereferencia, Tasa=Tasa, condTasa=condTasa)

            
        elif (IdTasa==2):#Tasa mayores 65 años
            if tipoVersion==1:
                interseccion=processing.run("qgis:extractbylocation", 
                {'INPUT':Layer, 
                'PREDICATE':0,
                'INTERSECT':vLayer,
                'OUTPUT':'TEMPORARY_OUTPUT'})
                
                zLayer=interseccion['OUTPUT']
                zLayer.setName(str(NombreLeyenda))
            else:
                interseccion=processing.run("qgis:selectbylocation", 
                {'INPUT':Layer, 
                'PREDICATE':0,
                'INTERSECT':vLayer,
                'METHOD':0})
                zLayer = interseccion.materialize(QgsFeatureRequest().setFilterFids(interseccion.selectedFeatureIds()))
                zLayer.setName(str(NombreLeyenda))
                
            myField = QgsField( myTargetField, QVariant.Double )
            zLayer.dataProvider().addAttributes([myField])
            zLayer.updateFields()
            prov = zLayer.dataProvider()
            numero_tasa=zLayer.fields().indexOf(myTargetField)
            zLayer.startEditing()

            poblacion=[]
            poblacion65=[]
            Tasa=[]
            for f in zLayer.getFeatures():
                    poblacion.append(float(f["pob_tot"]))
                    poblacion65.append(float(f["edad65_"]))
                    if all(flag > 0 for flag in [poblacion[-1],poblacion65[-1]+0.1]):
                        Tasa.append(round(float(100*poblacion65[-1]/poblacion[-1]),numDecimales))
                    else:
                        Tasa.append(float(-1))
                    
                    zLayer.changeAttributeValue(f.id(), numero_tasa, Tasa[-1])

            zLayer.commitChanges()
            zLayer.updateFields()
            
            condTasa=self.getcondTasa(zLayer)
            if condTasa=="XY":
                condTasa=calcularXY(Tipo=IdRereferencia,tLayer=tLayer,lista_url_capas250=self.lista_url_capas250)
                if IdRereferencia==1:
                    zLayer.setName(Language('Quintiles respecto a la provincia: ','Quintiles with respect to province: ',self.Language) + condTasa)
                    self.tituloLlistwidgetSimbologia.setText(Language('Simbología (Provincia: ','Symbology (Province: ',self.Language)+ str(condTasa) + ")")
                elif IdRereferencia==2:
                    zLayer.setName(Language('Quintiles respecto al municipio: ','Quintiles with respect to town: ',self.Language) + condTasa)
                    self.tituloLlistwidgetSimbologia.setText(Language('Simbología (Municipio: ','Symbology (Town: ',self.Language)+ str(condTasa) + ")")

            #A partir de aqui es donde se modifica para cada Tasa
            dfReducido=df[(df['edad65_'] >= 0) & (df['pob_tot'] > 0)]
            Tasa = dfReducido[['grd_floaid','municipio','cmun']]
            Tasa[myTargetField]=100*(dfReducido['edad65_']/dfReducido['pob_tot'])
            Tasa=Tasa[(Tasa[myTargetField] >= 0)]
            Tasa=Tasa.round({myTargetField:numDecimales})

            (minimo,percentil_20,percentil_40,percentil_60,percentil_80,maximo)=calcularValorReferencia(Tipo=IdRereferencia, Tasa=Tasa, condTasa=condTasa)

            
        elif (IdTasa==3):#Poblacion extranejra
            if tipoVersion==1:
                interseccion=processing.run("qgis:extractbylocation", 
                {'INPUT':Layer, 
                'PREDICATE':0,
                'INTERSECT':vLayer,
                'OUTPUT':'TEMPORARY_OUTPUT'})
                
                zLayer=interseccion['OUTPUT']
                zLayer.setName(str(NombreLeyenda))
            else:
                interseccion=processing.run("qgis:selectbylocation", 
                {'INPUT':Layer, 
                'PREDICATE':0,
                'INTERSECT':vLayer,
                'METHOD':0})
                zLayer = interseccion.materialize(QgsFeatureRequest().setFilterFids(interseccion.selectedFeatureIds()))
                zLayer.setName(str(NombreLeyenda))
                
            myField = QgsField( myTargetField, QVariant.Double )
            zLayer.dataProvider().addAttributes([myField])
            zLayer.updateFields()
            prov = zLayer.dataProvider()
            numero_tasa=zLayer.fields().indexOf(myTargetField)
            zLayer.startEditing()

            den=[]
            num=[]
            aux1=[]
            aux2=[]
            Tasa=[]
            for f in zLayer.getFeatures():
                    den.append(float(f['pob_tot']))
                    aux1.append(float(f['esp']))
                    aux2.append(float(f['ue15']))
                    if aux2[-1]>0:
                        num.append(float(den[-1]-aux1[-1]-aux2[-1]))
                    else:
                        num.append(float(den[-1]-aux1[-1]))
                    num.append(float(den[-1]-aux1[-1]-aux2[-1]))
                    if all(flag > 0 for flag in [aux1[-1]+0.1,aux2[-1]+0.1,den[-1],num[-1]+0.1]):
                        Tasa.append(round(float(100*num[-1]/den[-1]),numDecimales))
                    else:
                        Tasa.append(float(-1))
                    
                    zLayer.changeAttributeValue(f.id(), numero_tasa, Tasa[-1])

            zLayer.commitChanges()
            zLayer.updateFields()
            
            condTasa=self.getcondTasa(zLayer)
            if condTasa=="XY":
                condTasa=calcularXY(Tipo=IdRereferencia,tLayer=tLayer,lista_url_capas250=self.lista_url_capas250)
                if IdRereferencia==1:
                    zLayer.setName(Language('Quintiles respecto a la provincia: ','Quintiles with respect to province: ',self.Language) + condTasa)
                    self.tituloLlistwidgetSimbologia.setText(Language('Simbología (Provincia: ','Symbology (Province: ',self.Language)+ str(condTasa) + ")")
                elif IdRereferencia==2:
                    zLayer.setName(Language('Quintiles respecto al municipio: ','Quintiles with respect to town: ',self.Language) + condTasa)
                    self.tituloLlistwidgetSimbologia.setText(Language('Simbología (Municipio: ','Symbology (Town: ',self.Language)+ str(condTasa) + ")")

            #A partir de aqui es donde se modifica para cada Tasa
            dfReducido=df[(df['pob_tot']-df['esp']-df['ue15'] >= 0) & (df['esp'] >= 0) & (df['ue15'] >= 0) & (df['pob_tot'] > 0)]
            Tasa = dfReducido[['grd_floaid','municipio','cmun']]
            Tasa[myTargetField]=100*((dfReducido['pob_tot']-dfReducido['esp']-dfReducido['ue15'])/dfReducido['pob_tot'])
            Tasa=Tasa[(Tasa[myTargetField] >= 0)]
            Tasa=Tasa.round({myTargetField:numDecimales})

            (minimo,percentil_20,percentil_40,percentil_60,percentil_80,maximo)=calcularValorReferencia(Tipo=IdRereferencia, Tasa=Tasa, condTasa=condTasa)

        elif (IdTasa==4):#Poblacion activa
            if tipoVersion==1:
                interseccion=processing.run("qgis:extractbylocation", 
                {'INPUT':Layer, 
                'PREDICATE':0,
                'INTERSECT':vLayer,
                'OUTPUT':'TEMPORARY_OUTPUT'})
                
                zLayer=interseccion['OUTPUT']
                zLayer.setName(str(NombreLeyenda))
            else:
                interseccion=processing.run("qgis:selectbylocation", 
                {'INPUT':Layer, 
                'PREDICATE':0,
                'INTERSECT':vLayer,
                'METHOD':0})
                zLayer = interseccion.materialize(QgsFeatureRequest().setFilterFids(interseccion.selectedFeatureIds()))
                zLayer.setName(str(NombreLeyenda))
                
            myField = QgsField( myTargetField, QVariant.Double )
            zLayer.dataProvider().addAttributes([myField])
            zLayer.updateFields()
            prov = zLayer.dataProvider()
            numero_tasa=zLayer.fields().indexOf(myTargetField)
            zLayer.startEditing()

            den=[]
            num=[]
            aux1=[]
            aux2=[]
            Tasa=[]
            for f in zLayer.getFeatures():
                aux1.append(float(f['edad0015']))
                aux2.append(float(f['edad65_']))
                den.append(float(f['pob_tot']-(aux1[-1]+aux2[-1])))
                num.append(float(f['afil_ss']))
                if all(flag > 0 for flag in [aux1[-1]+0.1,aux2[-1]+0.1,den[-1],num[-1]+0.1]):
                    Tasa.append(round(float(100*num[-1]/den[-1]),numDecimales))
                else:
                    Tasa.append(float(-1))
                
                zLayer.changeAttributeValue(f.id(), numero_tasa, Tasa[-1])

            zLayer.commitChanges()
            zLayer.updateFields()
            
            condTasa=self.getcondTasa(zLayer)
            if condTasa=="XY":
                condTasa=calcularXY(Tipo=IdRereferencia,tLayer=tLayer,lista_url_capas250=self.lista_url_capas250)
                if IdRereferencia==1:
                    zLayer.setName(Language('Quintiles respecto a la provincia: ','Quintiles with respect to province: ',self.Language) + condTasa)
                    self.tituloLlistwidgetSimbologia.setText(Language('Simbología (Provincia: ','Symbology (Province: ',self.Language)+ str(condTasa) + ")")
                elif IdRereferencia==2:
                    zLayer.setName(Language('Quintiles respecto al municipio: ','Quintiles with respect to town: ',self.Language) + condTasa)
                    self.tituloLlistwidgetSimbologia.setText(Language('Simbología (Municipio: ','Symbology (Town: ',self.Language)+ str(condTasa) + ")")

            #A partir de aqui es donde se modifica para cada Tasa
            dfReducido=df[(df['afil_ss'] >= 0) & (df['pob_tot'] > 0) & (df['pob_tot']-(df['edad0015']+df['edad65_'])>0)]
            Tasa = dfReducido[['grd_floaid','municipio','cmun']]
            Tasa[myTargetField]=100*((dfReducido['afil_ss'])/(dfReducido['pob_tot']-(dfReducido['edad0015']+dfReducido['edad65_'])))
            Tasa=Tasa[(Tasa[myTargetField] >= 0)]
            Tasa=Tasa.round({myTargetField:numDecimales})
            Tasa.loc[Tasa[myTargetField] > 100, myTargetField] = 100 #Se satura a 100%

            (minimo,percentil_20,percentil_40,percentil_60,percentil_80,maximo)=calcularValorReferencia(Tipo=IdRereferencia, Tasa=Tasa, condTasa=condTasa)

        elif (IdTasa==5):#Paro registrado
            if tipoVersion==1:
                interseccion=processing.run("qgis:extractbylocation", 
                {'INPUT':Layer, 
                'PREDICATE':0,
                'INTERSECT':vLayer,
                'OUTPUT':'TEMPORARY_OUTPUT'})
                
                zLayer=interseccion['OUTPUT']
                zLayer.setName(str(NombreLeyenda))
            else:
                interseccion=processing.run("qgis:selectbylocation", 
                {'INPUT':Layer, 
                'PREDICATE':0,
                'INTERSECT':vLayer,
                'METHOD':0})
                zLayer = interseccion.materialize(QgsFeatureRequest().setFilterFids(interseccion.selectedFeatureIds()))
                zLayer.setName(str(NombreLeyenda))
                
            myField = QgsField( myTargetField, QVariant.Double )
            zLayer.dataProvider().addAttributes([myField])
            zLayer.updateFields()
            prov = zLayer.dataProvider()
            numero_tasa=zLayer.fields().indexOf(myTargetField)
            zLayer.startEditing()

            den=[]
            num=[]
            aux1=[]
            aux2=[]
            Tasa=[]
            for f in zLayer.getFeatures():
                aux1.append(float(f['edad0015']))
                aux2.append(float(f['edad65_']))
                den.append(float(f['pob_tot']-(aux1[-1]+aux2[-1])))
                num.append(float(f['demp_pr']))
                if all(flag > 0 for flag in [aux1[-1]+0.1,aux2[-1]+0.1,den[-1],num[-1]+0.1]):
                    Tasa.append(round(float(100*num[-1]/den[-1]),numDecimales))
                else:
                    Tasa.append(float(-1))
                
                zLayer.changeAttributeValue(f.id(), numero_tasa, Tasa[-1])

            zLayer.commitChanges()
            zLayer.updateFields()
            
            condTasa=self.getcondTasa(zLayer)
            if condTasa=="XY":
                condTasa=calcularXY(Tipo=IdRereferencia,tLayer=tLayer,lista_url_capas250=self.lista_url_capas250)
                if IdRereferencia==1:
                    zLayer.setName(Language('Quintiles respecto a la provincia: ','Quintiles with respect to province: ',self.Language) + condTasa)
                    self.tituloLlistwidgetSimbologia.setText(Language('Simbología (Provincia: ','Symbology (Province: ',self.Language)+ str(condTasa) + ")")
                elif IdRereferencia==2:
                    zLayer.setName(Language('Quintiles respecto al municipio: ','Quintiles with respect to town: ',self.Language) + condTasa)
                    self.tituloLlistwidgetSimbologia.setText(Language('Simbología (Municipio: ','Symbology (Town: ',self.Language)+ str(condTasa) + ")")

            #A partir de aqui es donde se modifica para cada Tasa
            dfReducido=df[(df['demp_pr'] >= 0) & (df['pob_tot'] > 0) & (df['pob_tot']-(df['edad0015']+df['edad65_'])>0)]
            Tasa = dfReducido[['grd_floaid','municipio','cmun']]
            Tasa[myTargetField]=100*((dfReducido['demp_pr'])/(dfReducido['pob_tot']-(dfReducido['edad0015']+dfReducido['edad65_'])))
            Tasa=Tasa[(Tasa[myTargetField] >= 0)]
            Tasa=Tasa.round({myTargetField:numDecimales})

            (minimo,percentil_20,percentil_40,percentil_60,percentil_80,maximo)=calcularValorReferencia(Tipo=IdRereferencia, Tasa=Tasa, condTasa=condTasa)

        elif (IdTasa==6):#RMEs Total
            Layer2=AnadirLayerQGIS(url=self.lista_url_capas250[4],nombre="Capa grid RMEs", tipoCapa="WFS")
            if tipoVersion==1:
                interseccion=processing.run("qgis:extractbylocation", 
                {'INPUT':Layer, 
                'PREDICATE':0,
                'INTERSECT':vLayer,
                'OUTPUT':'TEMPORARY_OUTPUT'})
                zLayer=interseccion['OUTPUT']
                zLayer.setName(str(NombreLeyenda))
                
                interseccion=processing.run("qgis:extractbylocation", 
                {'INPUT':Layer2, 
                'PREDICATE':0,
                'INTERSECT':vLayer,
                'OUTPUT':'TEMPORARY_OUTPUT'})
                zLayer2=interseccion['OUTPUT']
            else:
                interseccion=processing.run("qgis:selectbylocation", 
                {'INPUT':Layer, 
                'PREDICATE':0,
                'INTERSECT':vLayer,
                'METHOD':0})
                zLayer = interseccion.materialize(QgsFeatureRequest().setFilterFids(interseccion.selectedFeatureIds()))
                zLayer.setName(str(NombreLeyenda))
                
            myField = QgsField( myTargetField, QVariant.Double )
            zLayer.dataProvider().addAttributes([myField])
            zLayer.updateFields()
            prov = zLayer.dataProvider()
            numero_tasa=zLayer.fields().indexOf(myTargetField)
            zLayer.startEditing()

            rme=[]
            Tasa=[]
            i=0
            for f in zLayer.getFeatures():
                for f2 in zLayer2.getFeatures():
                    if f2.geometry().equals(f.geometry()):
                        rme.append(float(f2["RMES_A00"]))
                        if all(flag > 0 for flag in [rme[-1]]):
                            Tasa.append(round(float(rme[-1]),2))
                        else:
                            Tasa.append(float(-1))
                        
                        zLayer.changeAttributeValue(f.id(), numero_tasa, Tasa[-1])

            zLayer.commitChanges()
            zLayer.updateFields()
            
            condTasa=self.getcondTasa(zLayer)
            if condTasa=="XY":
                condTasa=calcularXY(Tipo=IdRereferencia,tLayer=tLayer,lista_url_capas250=self.lista_url_capas250)
                if IdRereferencia==1:
                    zLayer.setName(Language('Quintiles respecto a la provincia: ','Quintiles with respect to province: ',self.Language) + condTasa)
                    self.tituloLlistwidgetSimbologia.setText(Language('Simbología (Provincia: ','Symbology (Province: ',self.Language)+ str(condTasa) + ")")
                elif IdRereferencia==2:
                    zLayer.setName(Language('Quintiles respecto al municipio: ','Quintiles with respect to town: ',self.Language) + condTasa)
                    self.tituloLlistwidgetSimbologia.setText(Language('Simbología (Municipio: ','Symbology (Town: ',self.Language)+ str(condTasa) + ")")

            #A partir de aqui es donde se modifica para cada Tasa
            Tasa = df[['grd_floaid','municipio','cmun']]
            Tasa[myTargetField]=df['RMES_A00']
            Tasa=Tasa[(Tasa[myTargetField] >= 0)]
            Tasa=Tasa.round({myTargetField:numDecimales})

            (minimo,percentil_20,percentil_40,percentil_60,percentil_80,maximo)=calcularValorReferencia(Tipo=IdRereferencia, Tasa=Tasa, condTasa=condTasa)
        elif (IdTasa==7):#RMEs 45-65
            Layer2=AnadirLayerQGIS(url=self.lista_url_capas250[4],nombre="Capa grid RMEs", tipoCapa="WFS")
            if tipoVersion==1:
                interseccion=processing.run("qgis:extractbylocation", 
                {'INPUT':Layer, 
                'PREDICATE':0,
                'INTERSECT':vLayer,
                'OUTPUT':'TEMPORARY_OUTPUT'})
                zLayer=interseccion['OUTPUT']
                zLayer.setName(str(NombreLeyenda))
                
                interseccion=processing.run("qgis:extractbylocation", 
                {'INPUT':Layer2, 
                'PREDICATE':0,
                'INTERSECT':vLayer,
                'OUTPUT':'TEMPORARY_OUTPUT'})
                zLayer2=interseccion['OUTPUT']
            else:
                interseccion=processing.run("qgis:selectbylocation", 
                {'INPUT':Layer, 
                'PREDICATE':0,
                'INTERSECT':vLayer,
                'METHOD':0})
                zLayer = interseccion.materialize(QgsFeatureRequest().setFilterFids(interseccion.selectedFeatureIds()))
                zLayer.setName(str(NombreLeyenda))
                
            myField = QgsField( myTargetField, QVariant.Double )
            zLayer.dataProvider().addAttributes([myField])
            zLayer.updateFields()
            prov = zLayer.dataProvider()
            numero_tasa=zLayer.fields().indexOf(myTargetField)
            zLayer.startEditing()

            rme=[]
            Tasa=[]
            i=0
            for f in zLayer.getFeatures():
                for f2 in zLayer2.getFeatures():
                    if f2.geometry().equals(f.geometry()):
                        rme.append(float(f2["RMES_A45"]))
                        if all(flag > 0 for flag in [rme[-1]]):
                            Tasa.append(round(float(rme[-1]),2))
                        else:
                            Tasa.append(float(-1))
                        
                        zLayer.changeAttributeValue(f.id(), numero_tasa, Tasa[-1])

            zLayer.commitChanges()
            zLayer.updateFields()
            
            condTasa=self.getcondTasa(zLayer)
            if condTasa=="XY":
                condTasa=calcularXY(Tipo=IdRereferencia,tLayer=tLayer,lista_url_capas250=self.lista_url_capas250)
                if IdRereferencia==1:
                    zLayer.setName(Language('Quintiles respecto a la provincia: ','Quintiles with respect to province: ',self.Language) + condTasa)
                    self.tituloLlistwidgetSimbologia.setText(Language('Simbología (Provincia: ','Symbology (Province: ',self.Language)+ str(condTasa) + ")")
                elif IdRereferencia==2:
                    zLayer.setName(Language('Quintiles respecto al municipio: ','Quintiles with respect to town: ',self.Language) + condTasa)
                    self.tituloLlistwidgetSimbologia.setText(Language('Simbología (Municipio: ','Symbology (Town: ',self.Language)+ str(condTasa) + ")")

            #A partir de aqui es donde se modifica para cada Tasa
            Tasa = df[['grd_floaid','municipio','cmun']]
            Tasa[myTargetField]=df['RMES_A45']
            Tasa=Tasa[(Tasa[myTargetField] >= 0)]
            Tasa=Tasa.round({myTargetField:numDecimales})

            (minimo,percentil_20,percentil_40,percentil_60,percentil_80,maximo)=calcularValorReferencia(Tipo=IdRereferencia, Tasa=Tasa, condTasa=condTasa)

        
        elif (IdTasa==8):#RMEs >65
            Layer2=AnadirLayerQGIS(url=self.lista_url_capas250[4],nombre="Capa grid RMEs", tipoCapa="WFS")
            if tipoVersion==1:
                interseccion=processing.run("qgis:extractbylocation", 
                {'INPUT':Layer, 
                'PREDICATE':0,
                'INTERSECT':vLayer,
                'OUTPUT':'TEMPORARY_OUTPUT'})
                zLayer=interseccion['OUTPUT']
                zLayer.setName(str(NombreLeyenda))
                
                interseccion=processing.run("qgis:extractbylocation", 
                {'INPUT':Layer2, 
                'PREDICATE':0,
                'INTERSECT':vLayer,
                'OUTPUT':'TEMPORARY_OUTPUT'})
                zLayer2=interseccion['OUTPUT']
            else:
                interseccion=processing.run("qgis:selectbylocation", 
                {'INPUT':Layer, 
                'PREDICATE':0,
                'INTERSECT':vLayer,
                'METHOD':0})
                zLayer = interseccion.materialize(QgsFeatureRequest().setFilterFids(interseccion.selectedFeatureIds()))
                zLayer.setName(str(NombreLeyenda))
                
            myField = QgsField( myTargetField, QVariant.Double )
            zLayer.dataProvider().addAttributes([myField])
            zLayer.updateFields()
            prov = zLayer.dataProvider()
            numero_tasa=zLayer.fields().indexOf(myTargetField)
            zLayer.startEditing()

            rme=[]
            Tasa=[]
            i=0
            for f in zLayer.getFeatures():
                for f2 in zLayer2.getFeatures():
                    if f2.geometry().equals(f.geometry()):
                        rme.append(float(f2["RMES_A65"]))
                        if all(flag > 0 for flag in [rme[-1]]):
                            Tasa.append(round(float(rme[-1]),2))
                        else:
                            Tasa.append(float(-1))
                        
                        zLayer.changeAttributeValue(f.id(), numero_tasa, Tasa[-1])

            zLayer.commitChanges()
            zLayer.updateFields()
            
            condTasa=self.getcondTasa(zLayer)
            if condTasa=="XY":
                condTasa=calcularXY(Tipo=IdRereferencia,tLayer=tLayer,lista_url_capas250=self.lista_url_capas250)
                if IdRereferencia==1:
                    zLayer.setName(Language('Quintiles respecto a la provincia: ','Quintiles with respect to province: ',self.Language) + condTasa)
                    self.tituloLlistwidgetSimbologia.setText(Language('Simbología (Provincia: ','Symbology (Province: ',self.Language)+ str(condTasa) + ")")
                elif IdRereferencia==2:
                    zLayer.setName(Language('Quintiles respecto al municipio: ','Quintiles with respect to town: ',self.Language) + condTasa)
                    self.tituloLlistwidgetSimbologia.setText(Language('Simbología (Municipio: ','Symbology (Town: ',self.Language)+ str(condTasa) + ")")

            #A partir de aqui es donde se modifica para cada Tasa
            Tasa = df[['grd_floaid','municipio','cmun']]
            Tasa[myTargetField]=df['RMES_A65']
            Tasa=Tasa[(Tasa[myTargetField] >= 0)]
            Tasa=Tasa.round({myTargetField:numDecimales})

            (minimo,percentil_20,percentil_40,percentil_60,percentil_80,maximo)=calcularValorReferencia(Tipo=IdRereferencia, Tasa=Tasa, condTasa=condTasa)
        
        
        elif (IdTasa==9):#Tasa mujeres
            if tipoVersion==1:
                interseccion=processing.run("qgis:extractbylocation", 
                {'INPUT':Layer, 
                'PREDICATE':0,
                'INTERSECT':vLayer,
                'OUTPUT':'TEMPORARY_OUTPUT'})
                
                zLayer=interseccion['OUTPUT']
                zLayer.setName(str(NombreLeyenda))
            else:
                interseccion=processing.run("qgis:selectbylocation", 
                {'INPUT':Layer, 
                'PREDICATE':0,
                'INTERSECT':vLayer,
                'METHOD':0})
                zLayer = interseccion.materialize(QgsFeatureRequest().setFilterFids(interseccion.selectedFeatureIds()))
                zLayer.setName(str(NombreLeyenda))
                
            myField = QgsField( myTargetField, QVariant.Double )
            zLayer.dataProvider().addAttributes([myField])
            zLayer.updateFields()
            prov = zLayer.dataProvider()
            numero_tasa=zLayer.fields().indexOf(myTargetField)
            zLayer.startEditing()

            poblacion=[]
            poblacionm=[]
            Tasa=[]
            for f in zLayer.getFeatures():
                    poblacion.append(float(f["pob_tot"]))
                    poblacionm.append(float(f["pob_m"]))
                    if all(flag > 0 for flag in [poblacion[-1],poblacionm[-1]+0.1]):
                        Tasa.append(round(float(100*poblacionm[-1]/poblacion[-1]),numDecimales))
                    else:
                        Tasa.append(float(-1))
                    
                    zLayer.changeAttributeValue(f.id(), numero_tasa, Tasa[-1])

            zLayer.commitChanges()
            zLayer.updateFields()
            
            condTasa=self.getcondTasa(zLayer)
            if condTasa=="XY":
                condTasa=calcularXY(Tipo=IdRereferencia,tLayer=tLayer,lista_url_capas250=self.lista_url_capas250)
                if IdRereferencia==1:
                    zLayer.setName(Language('Quintiles respecto a la provincia: ','Quintiles with respect to province: ',self.Language) + condTasa)
                    self.tituloLlistwidgetSimbologia.setText(Language('Simbología (Provincia: ','Symbology (Province: ',self.Language)+ str(condTasa) + ")")
                elif IdRereferencia==2:
                    zLayer.setName(Language('Quintiles respecto al municipio: ','Quintiles with respect to town: ',self.Language) + condTasa)
                    self.tituloLlistwidgetSimbologia.setText(Language('Simbología (Municipio: ','Symbology (Town: ',self.Language)+ str(condTasa) + ")")

            #A partir de aqui es donde se modifica para cada Tasa
            dfReducido=df[(df['pob_m'] >= 0) & (df['pob_tot'] > 0)]
            Tasa = dfReducido[['grd_floaid','municipio','cmun']]
            Tasa[myTargetField]=100*(dfReducido['pob_m']/dfReducido['pob_tot'])
            Tasa=Tasa[(Tasa[myTargetField] >= 0)]
            Tasa=Tasa.round({myTargetField:numDecimales})

            (minimo,percentil_20,percentil_40,percentil_60,percentil_80,maximo)=calcularValorReferencia(Tipo=IdRereferencia, Tasa=Tasa, condTasa=condTasa)
        
        elif (IdTasa==10):#% viviendas urbanas
            Layer2=AnadirLayerQGIS(url=self.lista_url_capas250[3],nombre="Capa grid gridcattp", tipoCapa="WFS")
            if tipoVersion==1:
                interseccion=processing.run("qgis:extractbylocation", 
                {'INPUT':Layer, 
                'PREDICATE':0,
                'INTERSECT':vLayer,
                'OUTPUT':'TEMPORARY_OUTPUT'})
                zLayer=interseccion['OUTPUT']
                zLayer.setName(str(NombreLeyenda))
                
                interseccion=processing.run("qgis:extractbylocation", 
                {'INPUT':Layer2, 
                'PREDICATE':0,
                'INTERSECT':vLayer,
                'OUTPUT':'TEMPORARY_OUTPUT'})
                zLayer2=interseccion['OUTPUT']
            else:
                interseccion=processing.run("qgis:selectbylocation", 
                {'INPUT':Layer, 
                'PREDICATE':0,
                'INTERSECT':vLayer,
                'METHOD':0})
                zLayer = interseccion.materialize(QgsFeatureRequest().setFilterFids(interseccion.selectedFeatureIds()))
                zLayer.setName(str(NombreLeyenda))
                
            myField = QgsField( myTargetField, QVariant.Double )
            zLayer.dataProvider().addAttributes([myField])
            zLayer.updateFields()
            prov = zLayer.dataProvider()
            numero_tasa=zLayer.fields().indexOf(myTargetField)
            zLayer.startEditing()

            viviendas=[]
            viviendas2=[]
            Tasa=[]
            i=0
            for f in zLayer.getFeatures():
                for f2 in zLayer2.getFeatures():
                    if f2.geometry().equals(f.geometry()):
                        viviendas.append(float(f2["porc_c011"]))
                        viviendas2.append(float(f2["porc_c012"]))
                        if all(flag >= 0 for flag in [viviendas[-1]+0.1,viviendas2[-1]+0.1]):
                            Tasa.append(round(float(viviendas[-1]+viviendas2[-1]),numDecimales))
                        else:
                            Tasa.append(float(-1))
                        
                        zLayer.changeAttributeValue(f.id(), numero_tasa, Tasa[-1])

            zLayer.commitChanges()
            zLayer.updateFields()
            
            condTasa=self.getcondTasa(zLayer)
            if condTasa=="XY":
                condTasa=calcularXY(Tipo=IdRereferencia,tLayer=tLayer,lista_url_capas250=self.lista_url_capas250)
                if IdRereferencia==1:
                    zLayer.setName(Language('Quintiles respecto a la provincia: ','Quintiles with respect to province: ',self.Language) + condTasa)
                    self.tituloLlistwidgetSimbologia.setText(Language('Simbología (Provincia: ','Symbology (Province: ',self.Language)+ str(condTasa) + ")")
                elif IdRereferencia==2:
                    zLayer.setName(Language('Quintiles respecto al municipio: ','Quintiles with respect to town: ',self.Language) + condTasa)
                    self.tituloLlistwidgetSimbologia.setText(Language('Simbología (Municipio: ','Symbology (Town: ',self.Language)+ str(condTasa) + ")")

            #A partir de aqui es donde se modifica para cada Tasa
            dfReducido=df[(df['porc_c011'] >= 0) & (df['porc_c012'] >= 0)]
            Tasa = dfReducido[['grd_floaid','municipio','cmun']]
            Tasa[myTargetField]=(dfReducido['porc_c011']+dfReducido['porc_c012'])
            Tasa=Tasa[(Tasa[myTargetField] >= 0)]
            Tasa=Tasa.round({myTargetField:numDecimales})

            (minimo,percentil_20,percentil_40,percentil_60,percentil_80,maximo)=calcularValorReferencia(Tipo=IdRereferencia, Tasa=Tasa, condTasa=condTasa)
        
        elif (IdTasa==11):#% industrial
            Layer2=AnadirLayerQGIS(url=self.lista_url_capas250[3],nombre="Capa grid gridcattp", tipoCapa="WFS")
            if tipoVersion==1:
                interseccion=processing.run("qgis:extractbylocation", 
                {'INPUT':Layer, 
                'PREDICATE':0,
                'INTERSECT':vLayer,
                'OUTPUT':'TEMPORARY_OUTPUT'})
                zLayer=interseccion['OUTPUT']
                zLayer.setName(str(NombreLeyenda))
                
                interseccion=processing.run("qgis:extractbylocation", 
                {'INPUT':Layer2, 
                'PREDICATE':0,
                'INTERSECT':vLayer,
                'OUTPUT':'TEMPORARY_OUTPUT'})
                zLayer2=interseccion['OUTPUT']
            else:
                interseccion=processing.run("qgis:selectbylocation", 
                {'INPUT':Layer, 
                'PREDICATE':0,
                'INTERSECT':vLayer,
                'METHOD':0})
                zLayer = interseccion.materialize(QgsFeatureRequest().setFilterFids(interseccion.selectedFeatureIds()))
                zLayer.setName(str(NombreLeyenda))
                
            myField = QgsField( myTargetField, QVariant.Double )
            zLayer.dataProvider().addAttributes([myField])
            zLayer.updateFields()
            prov = zLayer.dataProvider()
            numero_tasa=zLayer.fields().indexOf(myTargetField)
            zLayer.startEditing()

            suelo=[]
            Tasa=[]
            i=0
            for f in zLayer.getFeatures():
                for f2 in zLayer2.getFeatures():
                    if f2.geometry().equals(f.geometry()):
                        suelo.append(float(f2["porc_c02"]))
                        if all(flag >= 0 for flag in [suelo[-1]]):
                            Tasa.append(round(float(suelo[-1]),2))
                        else:
                            Tasa.append(float(-1))
                        
                        zLayer.changeAttributeValue(f.id(), numero_tasa, Tasa[-1])

            zLayer.commitChanges()
            zLayer.updateFields()
            
            condTasa=self.getcondTasa(zLayer)
            if condTasa=="XY":
                condTasa=calcularXY(Tipo=IdRereferencia,tLayer=tLayer,lista_url_capas250=self.lista_url_capas250)
                if IdRereferencia==1:
                    zLayer.setName(Language('Quintiles respecto a la provincia: ','Quintiles with respect to province: ',self.Language) + condTasa)
                    self.tituloLlistwidgetSimbologia.setText(Language('Simbología (Provincia: ','Symbology (Province: ',self.Language)+ str(condTasa) + ")")
                elif IdRereferencia==2:
                    zLayer.setName(Language('Quintiles respecto al municipio: ','Quintiles with respect to town: ',self.Language) + condTasa)
                    self.tituloLlistwidgetSimbologia.setText(Language('Simbología (Municipio: ','Symbology (Town: ',self.Language)+ str(condTasa) + ")")

            #A partir de aqui es donde se modifica para cada Tasa
            Tasa = df[['grd_floaid','municipio','cmun']]
            Tasa[myTargetField]=df['porc_c02']
            Tasa=Tasa[(Tasa[myTargetField] > 0)]
            Tasa=Tasa.round({myTargetField:numDecimales})

            (minimo,percentil_20,percentil_40,percentil_60,percentil_80,maximo)=calcularValorReferencia(Tipo=IdRereferencia, Tasa=Tasa, condTasa=condTasa)
        
        elif (IdTasa==12):#% oficinas
            Layer2=AnadirLayerQGIS(url=self.lista_url_capas250[3],nombre="Capa grid gridcattp", tipoCapa="WFS")
            if tipoVersion==1:
                interseccion=processing.run("qgis:extractbylocation", 
                {'INPUT':Layer, 
                'PREDICATE':0,
                'INTERSECT':vLayer,
                'OUTPUT':'TEMPORARY_OUTPUT'})
                zLayer=interseccion['OUTPUT']
                zLayer.setName(str(NombreLeyenda))
                
                interseccion=processing.run("qgis:extractbylocation", 
                {'INPUT':Layer2, 
                'PREDICATE':0,
                'INTERSECT':vLayer,
                'OUTPUT':'TEMPORARY_OUTPUT'})
                zLayer2=interseccion['OUTPUT']
            else:
                interseccion=processing.run("qgis:selectbylocation", 
                {'INPUT':Layer, 
                'PREDICATE':0,
                'INTERSECT':vLayer,
                'METHOD':0})
                zLayer = interseccion.materialize(QgsFeatureRequest().setFilterFids(interseccion.selectedFeatureIds()))
                zLayer.setName(str(NombreLeyenda))
                
            myField = QgsField( myTargetField, QVariant.Double )
            zLayer.dataProvider().addAttributes([myField])
            zLayer.updateFields()
            prov = zLayer.dataProvider()
            numero_tasa=zLayer.fields().indexOf(myTargetField)
            zLayer.startEditing()

            suelo=[]
            Tasa=[]
            i=0
            for f in zLayer.getFeatures():
                for f2 in zLayer2.getFeatures():
                    if f2.geometry().equals(f.geometry()):
                        suelo.append(float(f2["porc_c03"]))
                        if all(flag >= 0 for flag in [suelo[-1]]):
                            Tasa.append(round(float(suelo[-1]),2))
                        else:
                            Tasa.append(float(-1))
                        
                        zLayer.changeAttributeValue(f.id(), numero_tasa, Tasa[-1])

            zLayer.commitChanges()
            zLayer.updateFields()
            
            condTasa=self.getcondTasa(zLayer)
            if condTasa=="XY":
                condTasa=calcularXY(Tipo=IdRereferencia,tLayer=tLayer,lista_url_capas250=self.lista_url_capas250)
                if IdRereferencia==1:
                    zLayer.setName(Language('Quintiles respecto a la provincia: ','Quintiles with respect to province: ',self.Language) + condTasa)
                    self.tituloLlistwidgetSimbologia.setText(Language('Simbología (Provincia: ','Symbology (Province: ',self.Language)+ str(condTasa) + ")")
                elif IdRereferencia==2:
                    zLayer.setName(Language('Quintiles respecto al municipio: ','Quintiles with respect to town: ',self.Language) + condTasa)
                    self.tituloLlistwidgetSimbologia.setText(Language('Simbología (Municipio: ','Symbology (Town: ',self.Language)+ str(condTasa) + ")")

            #A partir de aqui es donde se modifica para cada Tasa
            Tasa = df[['grd_floaid','municipio','cmun']]
            Tasa[myTargetField]=df['porc_c03']
            Tasa=Tasa[(Tasa[myTargetField] > 0)]
            Tasa=Tasa.round({myTargetField:numDecimales})

            (minimo,percentil_20,percentil_40,percentil_60,percentil_80,maximo)=calcularValorReferencia(Tipo=IdRereferencia, Tasa=Tasa, condTasa=condTasa)

        elif (IdTasa==13):#% comercial
            Layer2=AnadirLayerQGIS(url=self.lista_url_capas250[3],nombre="Capa grid gridcattp", tipoCapa="WFS")
            if tipoVersion==1:
                interseccion=processing.run("qgis:extractbylocation", 
                {'INPUT':Layer, 
                'PREDICATE':0,
                'INTERSECT':vLayer,
                'OUTPUT':'TEMPORARY_OUTPUT'})
                zLayer=interseccion['OUTPUT']
                zLayer.setName(str(NombreLeyenda))
                
                interseccion=processing.run("qgis:extractbylocation", 
                {'INPUT':Layer2, 
                'PREDICATE':0,
                'INTERSECT':vLayer,
                'OUTPUT':'TEMPORARY_OUTPUT'})
                zLayer2=interseccion['OUTPUT']
            else:
                interseccion=processing.run("qgis:selectbylocation", 
                {'INPUT':Layer, 
                'PREDICATE':0,
                'INTERSECT':vLayer,
                'METHOD':0})
                zLayer = interseccion.materialize(QgsFeatureRequest().setFilterFids(interseccion.selectedFeatureIds()))
                zLayer.setName(str(NombreLeyenda))
                
            myField = QgsField( myTargetField, QVariant.Double )
            zLayer.dataProvider().addAttributes([myField])
            zLayer.updateFields()
            prov = zLayer.dataProvider()
            numero_tasa=zLayer.fields().indexOf(myTargetField)
            zLayer.startEditing()

            suelo=[]
            Tasa=[]
            i=0
            for f in zLayer.getFeatures():
                for f2 in zLayer2.getFeatures():
                    if f2.geometry().equals(f.geometry()):
                        suelo.append(float(f2["porc_c04"]))
                        if all(flag >= 0 for flag in [suelo[-1]]):
                            Tasa.append(round(float(suelo[-1]),numDecimales))
                        else:
                            Tasa.append(float(-1))
                        
                        zLayer.changeAttributeValue(f.id(), numero_tasa, Tasa[-1])

            zLayer.commitChanges()
            zLayer.updateFields()
            
            condTasa=self.getcondTasa(zLayer)
            if condTasa=="XY":
                condTasa=calcularXY(Tipo=IdRereferencia,tLayer=tLayer,lista_url_capas250=self.lista_url_capas250)
                if IdRereferencia==1:
                    zLayer.setName(Language('Quintiles respecto a la provincia: ','Quintiles with respect to province: ',self.Language) + condTasa)
                    self.tituloLlistwidgetSimbologia.setText(Language('Simbología (Provincia: ','Symbology (Province: ',self.Language)+ str(condTasa) + ")")
                elif IdRereferencia==2:
                    zLayer.setName(Language('Quintiles respecto al municipio: ','Quintiles with respect to town: ',self.Language) + condTasa)
                    self.tituloLlistwidgetSimbologia.setText(Language('Simbología (Municipio: ','Symbology (Town: ',self.Language)+ str(condTasa) + ")")

            #A partir de aqui es donde se modifica para cada Tasa
            Tasa = df[['grd_floaid','municipio','cmun']]
            Tasa[myTargetField]=df['porc_c04']
            Tasa=Tasa[(Tasa[myTargetField] > 0)]
            Tasa=Tasa.round({myTargetField:numDecimales})

            (minimo,percentil_20,percentil_40,percentil_60,percentil_80,maximo)=calcularValorReferencia(Tipo=IdRereferencia, Tasa=Tasa, condTasa=condTasa)

        elif (IdTasa==14):#% deportivo
            Layer2=AnadirLayerQGIS(url=self.lista_url_capas250[3],nombre="Capa grid gridcattp", tipoCapa="WFS")
            if tipoVersion==1:
                interseccion=processing.run("qgis:extractbylocation", 
                {'INPUT':Layer, 
                'PREDICATE':0,
                'INTERSECT':vLayer,
                'OUTPUT':'TEMPORARY_OUTPUT'})
                zLayer=interseccion['OUTPUT']
                zLayer.setName(str(NombreLeyenda))
                
                interseccion=processing.run("qgis:extractbylocation", 
                {'INPUT':Layer2, 
                'PREDICATE':0,
                'INTERSECT':vLayer,
                'OUTPUT':'TEMPORARY_OUTPUT'})
                zLayer2=interseccion['OUTPUT']
            else:
                interseccion=processing.run("qgis:selectbylocation", 
                {'INPUT':Layer, 
                'PREDICATE':0,
                'INTERSECT':vLayer,
                'METHOD':0})
                zLayer = interseccion.materialize(QgsFeatureRequest().setFilterFids(interseccion.selectedFeatureIds()))
                zLayer.setName(str(NombreLeyenda))
                
            myField = QgsField( myTargetField, QVariant.Double )
            zLayer.dataProvider().addAttributes([myField])
            zLayer.updateFields()
            prov = zLayer.dataProvider()
            numero_tasa=zLayer.fields().indexOf(myTargetField)
            zLayer.startEditing()

            suelo=[]
            Tasa=[]
            i=0
            for f in zLayer.getFeatures():
                for f2 in zLayer2.getFeatures():
                    if f2.geometry().equals(f.geometry()):
                        suelo.append(float(f2["porc_c05"]))
                        if all(flag >= 0 for flag in [suelo[-1]]):
                            Tasa.append(round(float(suelo[-1]),numDecimales))
                        else:
                            Tasa.append(float(-1))
                        
                        zLayer.changeAttributeValue(f.id(), numero_tasa, Tasa[-1])

            zLayer.commitChanges()
            zLayer.updateFields()
            
            condTasa=self.getcondTasa(zLayer)
            if condTasa=="XY":
                condTasa=calcularXY(Tipo=IdRereferencia,tLayer=tLayer,lista_url_capas250=self.lista_url_capas250)
                if IdRereferencia==1:
                    zLayer.setName(Language('Quintiles respecto a la provincia: ','Quintiles with respect to province: ',self.Language) + condTasa)
                    self.tituloLlistwidgetSimbologia.setText(Language('Simbología (Provincia: ','Symbology (Province: ',self.Language)+ str(condTasa) + ")")
                elif IdRereferencia==2:
                    zLayer.setName(Language('Quintiles respecto al municipio: ','Quintiles with respect to town: ',self.Language) + condTasa)
                    self.tituloLlistwidgetSimbologia.setText(Language('Simbología (Municipio: ','Symbology (Town: ',self.Language)+ str(condTasa) + ")")

            #A partir de aqui es donde se modifica para cada Tasa
            Tasa = df[['grd_floaid','municipio','cmun']]
            Tasa[myTargetField]=df['porc_c05']
            Tasa=Tasa[(Tasa[myTargetField] > 0)]
            Tasa=Tasa.round({myTargetField:numDecimales})

            (minimo,percentil_20,percentil_40,percentil_60,percentil_80,maximo)=calcularValorReferencia(Tipo=IdRereferencia, Tasa=Tasa, condTasa=condTasa)

        elif (IdTasa==15):#% sanitario, asistencial y beneficios
            Layer2=AnadirLayerQGIS(url=self.lista_url_capas250[3],nombre="Capa grid gridcattp", tipoCapa="WFS")
            if tipoVersion==1:
                interseccion=processing.run("qgis:extractbylocation", 
                {'INPUT':Layer, 
                'PREDICATE':0,
                'INTERSECT':vLayer,
                'OUTPUT':'TEMPORARY_OUTPUT'})
                zLayer=interseccion['OUTPUT']
                zLayer.setName(str(NombreLeyenda))
                
                interseccion=processing.run("qgis:extractbylocation", 
                {'INPUT':Layer2, 
                'PREDICATE':0,
                'INTERSECT':vLayer,
                'OUTPUT':'TEMPORARY_OUTPUT'})
                zLayer2=interseccion['OUTPUT']
            else:
                interseccion=processing.run("qgis:selectbylocation", 
                {'INPUT':Layer, 
                'PREDICATE':0,
                'INTERSECT':vLayer,
                'METHOD':0})
                zLayer = interseccion.materialize(QgsFeatureRequest().setFilterFids(interseccion.selectedFeatureIds()))
                zLayer.setName(str(NombreLeyenda))
                
            myField = QgsField( myTargetField, QVariant.Double )
            zLayer.dataProvider().addAttributes([myField])
            zLayer.updateFields()
            prov = zLayer.dataProvider()
            numero_tasa=zLayer.fields().indexOf(myTargetField)
            zLayer.startEditing()

            suelo=[]
            Tasa=[]
            i=0
            for f in zLayer.getFeatures():
                for f2 in zLayer2.getFeatures():
                    if f2.geometry().equals(f.geometry()):
                        suelo.append(float(f2["porc_c08"]))
                        if all(flag >= 0 for flag in [suelo[-1]]):
                            Tasa.append(round(float(suelo[-1]),numDecimales))
                        else:
                            Tasa.append(float(-1))
                        
                        zLayer.changeAttributeValue(f.id(), numero_tasa, Tasa[-1])

            zLayer.commitChanges()
            zLayer.updateFields()
            
            condTasa=self.getcondTasa(zLayer)
            if condTasa=="XY":
                condTasa=calcularXY(Tipo=IdRereferencia,tLayer=tLayer,lista_url_capas250=self.lista_url_capas250)
                if IdRereferencia==1:
                    zLayer.setName(Language('Quintiles respecto a la provincia: ','Quintiles with respect to province: ',self.Language) + condTasa)
                    self.tituloLlistwidgetSimbologia.setText(Language('Simbología (Provincia: ','Symbology (Province: ',self.Language)+ str(condTasa) + ")")
                elif IdRereferencia==2:
                    zLayer.setName(Language('Quintiles respecto al municipio: ','Quintiles with respect to town: ',self.Language) + condTasa)
                    self.tituloLlistwidgetSimbologia.setText(Language('Simbología (Municipio: ','Symbology (Town: ',self.Language)+ str(condTasa) + ")")

            #A partir de aqui es donde se modifica para cada Tasa
            Tasa = df[['grd_floaid','municipio','cmun']]
            Tasa[myTargetField]=df['porc_c08']
            Tasa=Tasa[(Tasa[myTargetField] > 0)]
            Tasa=Tasa.round({myTargetField:numDecimales})

            (minimo,percentil_20,percentil_40,percentil_60,percentil_80,maximo)=calcularValorReferencia(Tipo=IdRereferencia, Tasa=Tasa, condTasa=condTasa)

        elif (IdTasa==16):#% cultural
            Layer2=AnadirLayerQGIS(url=self.lista_url_capas250[3],nombre="Capa grid gridcattp", tipoCapa="WFS")
            if tipoVersion==1:
                interseccion=processing.run("qgis:extractbylocation", 
                {'INPUT':Layer, 
                'PREDICATE':0,
                'INTERSECT':vLayer,
                'OUTPUT':'TEMPORARY_OUTPUT'})
                zLayer=interseccion['OUTPUT']
                zLayer.setName(str(NombreLeyenda))
                
                interseccion=processing.run("qgis:extractbylocation", 
                {'INPUT':Layer2, 
                'PREDICATE':0,
                'INTERSECT':vLayer,
                'OUTPUT':'TEMPORARY_OUTPUT'})
                zLayer2=interseccion['OUTPUT']
            else:
                interseccion=processing.run("qgis:selectbylocation", 
                {'INPUT':Layer, 
                'PREDICATE':0,
                'INTERSECT':vLayer,
                'METHOD':0})
                zLayer = interseccion.materialize(QgsFeatureRequest().setFilterFids(interseccion.selectedFeatureIds()))
                zLayer.setName(str(NombreLeyenda))
                
            myField = QgsField( myTargetField, QVariant.Double )
            zLayer.dataProvider().addAttributes([myField])
            zLayer.updateFields()
            prov = zLayer.dataProvider()
            numero_tasa=zLayer.fields().indexOf(myTargetField)
            zLayer.startEditing()

            suelo=[]
            Tasa=[]
            i=0
            for f in zLayer.getFeatures():
                for f2 in zLayer2.getFeatures():
                    if f2.geometry().equals(f.geometry()):
                        suelo.append(float(f2["porc_c09"]))
                        if all(flag >= 0 for flag in [suelo[-1]]):
                            Tasa.append(round(float(suelo[-1]),numDecimales))
                        else:
                            Tasa.append(float(-1))
                        
                        zLayer.changeAttributeValue(f.id(), numero_tasa, Tasa[-1])

            zLayer.commitChanges()
            zLayer.updateFields()
            
            condTasa=self.getcondTasa(zLayer)
            if condTasa=="XY":
                condTasa=calcularXY(Tipo=IdRereferencia,tLayer=tLayer,lista_url_capas250=self.lista_url_capas250)
                if IdRereferencia==1:
                    zLayer.setName(Language('Quintiles respecto a la provincia: ','Quintiles with respect to province: ',self.Language) + condTasa)
                    self.tituloLlistwidgetSimbologia.setText(Language('Simbología (Provincia: ','Symbology (Province: ',self.Language)+ str(condTasa) + ")")
                elif IdRereferencia==2:
                    zLayer.setName(Language('Quintiles respecto al municipio: ','Quintiles with respect to town: ',self.Language) + condTasa)
                    self.tituloLlistwidgetSimbologia.setText(Language('Simbología (Municipio: ','Symbology (Town: ',self.Language)+ str(condTasa) + ")")

            #A partir de aqui es donde se modifica para cada Tasa
            Tasa = df[['grd_floaid','municipio','cmun']]
            Tasa[myTargetField]=df['porc_c09']
            Tasa=Tasa[(Tasa[myTargetField] > 0)]
            Tasa=Tasa.round({myTargetField:numDecimales})

            (minimo,percentil_20,percentil_40,percentil_60,percentil_80,maximo)=calcularValorReferencia(Tipo=IdRereferencia, Tasa=Tasa, condTasa=condTasa)

        #id=listwidget_capas250.currentRow()
        if importar==0:
            self.obtener_minmax(tipo=1,lista=[minimo,percentil_20,percentil_40,percentil_60,percentil_80,maximo])
            if zLayer.featureCount()==0:
                VentanaError(titulo=Language('Información','Information',self.Language),mensaje=Language('No hay población en la zona seleccionada.','Population not found in area selected',self.Language)).exec()
            
        #listwidget_capas250_simbologia.item(IdTasa).actualiza_condicion()
            
        elif (importar==1):
            #print(df2.describe(include='all') )
            if [str(round(minimo,numDecimales)),str(round(percentil_20,numDecimales)),str(round(percentil_40,numDecimales)),
            str(round(percentil_60,numDecimales)),str(round(percentil_80,numDecimales))]!=self.condicion_lista[self.idCurrentRow]\
            or self.listwidget_capas250_simbologia.count()!=5:
                print([str(round(minimo,numDecimales)),str(round(percentil_20,numDecimales)),str(round(percentil_40,numDecimales)),
                str(round(percentil_60,numDecimales)),str(round(percentil_80,numDecimales))])
                print(self.condicion_lista[self.idCurrentRow])
                zLayer.setName("")
            myRangeList = []

            #QgsProject.instance().addMapLayer(zLayer)
            graduated_renderer = QgsGraduatedSymbolRenderer()
            lista_cond=self.condicion_lista[self.idCurrentRow]
            max_cond=self.maximo[self.idCurrentRow]
            lista_col=self.color_lista[self.idCurrentRow]
            id=0
            for id in range(len(self.color_lista[self.idCurrentRow])-1):
                myColour = QColor(str(lista_col[id]))
                mySymbol2 = QgsSymbol.defaultSymbol(zLayer.geometryType())
                mySymbol2.setColor(myColour)
                mySymbol2.setOpacity(self.opacidadSlider.value()/100)
                if tipoVersion==1:
                    graduated_renderer.addClassRange(QgsRendererRange(QgsClassificationRange(str(lista_cond[id])+' - '+str(lista_cond[id+1]), float(lista_cond[id]), float(lista_cond[id+1])), mySymbol2))
                else:
                    myRange2 = QgsRendererRange(float(lista_cond[id]), float(lista_cond[id+1]), mySymbol2,'Group 1')
                    myRangeList.append(myRange2)
                    #graduated_renderer.addClassRange(QgsRendererRange(float(lista_cond[id]), float(lista_cond[id+1])), mySymbol2,'Group 1')

            if id>0:
                myColour = QColor(str(lista_col[id+1]))
                mySymbol2 = QgsSymbol.defaultSymbol(zLayer.geometryType())
                mySymbol2.setColor(myColour)
                mySymbol2.setOpacity(self.opacidadSlider.value()/100)
                if tipoVersion==1:
                    graduated_renderer.addClassRange(QgsRendererRange(QgsClassificationRange(str(lista_cond[id+1])+' - '+str(max_cond), float(lista_cond[id+1]), float(max_cond)), mySymbol2))
                else:
                    myRange2=QgsRendererRange(float(lista_cond[id+1]), float(max_cond), mySymbol2,'Group 1')
                    myRangeList.append(myRange2)
                    graduated_renderer = QgsGraduatedSymbolRenderer('', myRangeList)
            else:
                myColour = QColor(str(lista_col[id]))
                mySymbol2 = QgsSymbol.defaultSymbol(zLayer.geometryType())
                mySymbol2.setColor(myColour)
                mySymbol2.setOpacity(self.opacidadSlider.value()/100)
                if tipoVersion==1:
                    graduated_renderer.addClassRange(QgsRendererRange(QgsClassificationRange(str(lista_cond[id])+' - '+str(max_cond), float(lista_cond[id]), float(max_cond)), mySymbol2))
                else:
                    myRange2=QgsRendererRange(float(lista_cond[id]), float(max_cond), mySymbol2,'Group 1')
                    myRangeList.append(myRange2)
                    graduated_renderer = QgsGraduatedSymbolRenderer('', myRangeList)
                    
            # create renderer object
            graduated_renderer.setClassAttribute(myTargetField)
            zLayer.setRenderer(graduated_renderer)
            zLayer.triggerRepaint()

            #Se añade el label
            if (tamano_buffer<=2000):#Solo si está a menos de 2Km
                layer_settings  = QgsPalLayerSettings()
                text_format = QgsTextFormat()
                text_format.setFont(QFont("Arial", 6))
                buffer_settings = QgsTextBufferSettings()
                buffer_settings.setEnabled(True)
                buffer_settings.setSize(1)
                buffer_settings.setColor(QColor("white"))
                text_format.setBuffer(buffer_settings)
                layer_settings.setFormat(text_format)
                layer_settings.fieldName = myTargetField
                layer_settings.placement = 1
                layer_settings.enabled = True
                layer_settings = QgsVectorLayerSimpleLabeling(layer_settings)
                zLayer.setLabelsEnabled(True)
                zLayer.setLabeling(layer_settings)
                zLayer.triggerRepaint()
            
            self.importar_inequidad(zLayer,vLayer,tLayer,myTargetField,NombreLeyenda)
    def CompruebaDirectorioOk(self):
        if self.data_path.text()=="" or self.data_path.text()=="./":
            VentanaError(mensaje=Language('La carpeta en la que está intentando guardar el mapa no existe.','Path not found',self.Language)).exec()
            return 0
        elif os.path.isdir(self.data_path.text())==False:
            VentanaError(mensaje=Language('La carpeta en la que está intentando guardar el mapa no existe.','Path not found',self.Language)).exec()
            return 0
        return 1
    def importar_inequidad(self,zLayer,vLayer,tLayer,TipoAbreviado,TituloLeyenda):#Capa de Tasa, Capa buffer, Capa punto, nombre archivo, titulo leyenda
        self.muestraCargando()
        tamano_buffer=float(self.bufferVisionLineedit.text())
        borrar_buffer=not(self.checkbox_buffer.isChecked())
        borrar_centro=not(self.checkbox_centro.isChecked())
        borrar_capa_tasa=not(self.checkbox_capa_tasa.isChecked())
        capa_cdau=(self.checkbox_capa_cdau.isChecked())
        vLayer.setName(self.texto_buffer.text()+ " " +str(tamano_buffer) + "m")
        if capa_cdau:
            uLayer=AnadirLayerQGIS(url=self.lista_url_capas250[8],nombre="CDAU", tipoCapa="WMS")
        else:
            uLayer=AnadirLayerQGIS(url=self.lista_url_capas250[0],nombre="Ortofoto", tipoCapa="WMS")
        QgsProject.instance().addMapLayer(uLayer)
        lblLayer=AnadirLayerQGIS(url=self.lista_url_capas250[1],nombre="Capa municipios", tipoCapa="WFS")
        QgsProject.instance().addMapLayer(lblLayer)
        AnadirLayerQGIS(url=vLayer,nombre="aux", tipoCapa="WFS",layer=1)
        QgsProject.instance().addMapLayer(vLayer)
        AnadirLayerQGIS(url=zLayer,nombre="aux", tipoCapa="WFS",layer=1)
        QgsProject.instance().addMapLayer(zLayer)
        AnadirLayerQGIS(url=tLayer,nombre="aux", tipoCapa="WFS",layer=1)
        QgsProject.instance().addMapLayer(tLayer)

        symbol = QgsMarkerSymbol.createSimple({'name': 'circle', 'color': 'red'})
        tLayer.renderer().setSymbol(symbol)
        tLayer.triggerRepaint()
        
        symbol = QgsFillSymbol.createSimple({'name': 'circle', 'width_border' : '0.66', 'style' : 'no'})
        vLayer.renderer().setSymbol(symbol)
        vLayer.triggerRepaint()
        
        wLayername = "buffer_vista"
        wLayer=QgsVectorLayer("Polygon", wLayername, "memory")
        QgsProject.instance().addMapLayer(wLayer)
        myField = QgsField( 'id', QVariant.Double )
        wLayer.dataProvider().addAttributes([myField])
        wLayer.updateFields()
        
        uLayer = QgsProject.instance().mapLayersByName(uLayer.name())[0]
        lblLayer = QgsProject.instance().mapLayersByName(lblLayer.name())[0]
        wLayer.setCrs(uLayer.crs())
        wFeats = wLayer.getFeatures()
        
        if lblLayer.featureCount()>0:
            symbol = QgsFillSymbol.createSimple({'name': 'square', 'width_border' : '0.66', 'style' : 'no'})
            lblLayer.renderer().setSymbol(symbol)
            layer_settings  = QgsPalLayerSettings()
            text_format = QgsTextFormat()
            text_format.setFont(QFont("Arial", 8))
            buffer_settings = QgsTextBufferSettings()
            buffer_settings.setEnabled(True)
            buffer_settings.setSize(1)
            buffer_settings.setColor(QColor("white"))
            text_format.setBuffer(buffer_settings)
            layer_settings.setFormat(text_format)
            layer_settings.fieldName = "nombre"
            layer_settings.placement = 1
            layer_settings.enabled = True
            layer_settings = QgsVectorLayerSimpleLabeling(layer_settings)
            lblLayer.setLabelsEnabled(True)
            lblLayer.setLabeling(layer_settings)
            lblLayer.triggerRepaint()
       
            
        for feat_vista in tLayer.getFeatures():
            geom = feat_vista.geometry()
            dist=float(self.bufferVisionLineedit.text())
            buffer_vista = geom.buffer(dist+0.5*dist, 5)
            feat_vista.setGeometry(buffer_vista)
            wLayer.dataProvider().addFeatures([feat_vista])


        project = QgsProject.instance()
        layout = QgsPrintLayout(project)
        layout.initializeDefaults()
        layout.renderContext().setDpi(150)
        map = QgsLayoutItemMap(layout)
        map.setRect(QRectF(0, 0, 100, 100))
        map.setExtent(wLayer.extent())
        LayersMap=[tLayer,vLayer,lblLayer,zLayer,uLayer]
        layers_name = [tLayer.name(),vLayer.name(),zLayer.name()]
        if tamano_buffer>2000:#se elimina el punto cuando es mayor de 2km
            LayersMap.pop(0)
            layers_name.pop(0)
        map.setLayers(LayersMap)
        map.setBackgroundColor(QColor(255, 255, 255))
        map.attemptResize(QgsLayoutSize(1753,1240, QgsUnitTypes.LayoutPixels))#1753,1240
        layout.addLayoutItem(map)

        legend = QgsLayoutItemLegend(layout)
        legend.setLinkedMap(map)
        legend.setLegendFilterByMapEnabled(True)
        layerTree = QgsLayerTree()
        #layers = [i for i in QgsProject().instance().mapLayers().values() if i.name() in layer_names]
        #for l in layers:
        #    layerTree.addLayer(l)
        for l_name in layers_name:
            layerTree.addLayer(QgsProject.instance().mapLayersByName(l_name)[0])

        legend.model().setRootGroup(layerTree)

        legend.setTitle(str(TituloLeyenda))
        legend.setStyleFont(QgsLegendStyle.Title, QFont("Comic Sans MS", 14)) # 18
        legend.setStyleFont(QgsLegendStyle.SymbolLabel, QFont("Comic Sans MS", 14))
        layout.addLayoutItem(legend)
        legend.attemptMove(QgsLayoutPoint(0, 0, QgsUnitTypes.LayoutPixels)) # 15 10
        legend.setFrameEnabled(True)
        legend.refresh()

        pdf_path = os.path.join(self.data_path.text(), self.nombre_fichero.text() + "_" + str(TipoAbreviado) + '.png')
        exporter = QgsLayoutExporter(layout)
        exporter.exportToImage(pdf_path, QgsLayoutExporter.ImageExportSettings())
        #Borrar documentos
        QgsProject.instance().removeMapLayer(wLayer)
        del wLayer
        if borrar_centro:
            QgsProject.instance().removeMapLayer(tLayer)
            del tLayer
        if borrar_buffer:
            QgsProject.instance().removeMapLayer(vLayer)
            del vLayer
        if borrar_capa_tasa:
            QgsProject.instance().removeMapLayer(zLayer)
            del zLayer
            

        #Se refresca el mapa
        iface.mapCanvas().refresh()
        self.activateWindow()
        self.ocultaCargando()
        


class clase_lista_malla250(QWidget):
    def __init__(self,parent=None,nombre="default_name",colores_invertidos=0):
        super().__init__()
        del(parent)
        #self.id=listwidget_capas250.currentRow()
        #self.nombre=listwidget_capas250.item(1).text()
        self.nombre=nombre
        
        
        self.widgetLabel = QLabel(self.nombre)
        self.widgetLabel.setFont(QFont('Arial', 10))
        widgetLayout = QHBoxLayout()
        widgetLayout.addWidget(self.widgetLabel)
        widgetLayout.addStretch(1)

        widgetLayout.setSizeConstraint(QLayout.SetFixedSize)
        self.setLayout(widgetLayout)
        #self.setSizeHint(self.widget_prueba.sizeHint())
        #self.mostrar_item_capa250()
        

class clase_colores(QListWidgetItem):
    def __init__(self, parent=None, id = 0, color = "#000000", condicion = 0):
        super().__init__()
        del(parent)
        
        self.id = id
        self.widget=QWidget()
        self.widgetLabel = QLabel("")
        self.widgetLabel.setFont(QFont('Arial', 10))
        self.widgetLabel.setStyleSheet("border: 1px solid black;min-width: 20px;min-height: 20px;background-color: " + str(color))
        self.widgetText = QLineEdit(str(condicion))
        self.widgetText.setFont(QFont('Arial', 10))
        
        self.widgetLabelLeyenda = QLabel("0-0")
        self.widgetLabelLeyenda.setFont(QFont('Arial', 10))
        widgetLayout = QHBoxLayout()
        widgetLayout.addWidget(self.widgetLabel)
        widgetLayout.addWidget(self.widgetText)
        widgetLayout.addWidget(self.widgetLabelLeyenda)
        widgetLayout.addStretch(1)

        widgetLayout.setSizeConstraint(QLayout.SetFixedSize)
        self.widget.setLayout(widgetLayout)
        self.setSizeHint(self.widget.sizeHint())
