# -*- coding: utf-8 -*-
"""
/***************************************************************************
 AndalusianPopulation
                                 A QGIS plugin
 This plugin allows easier access to information about the population of Andalusia (region of Spain)
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2021-06-10
        git sha              : $Format:%H$
        copyright            : (C) 2021 by Miguel Sanz
        email                : devmemi@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction

# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .AndalusianPopulation_dialog import AndalusianPopulationDialog
import os.path

from .AndalusianPopulation_startup1 import *
from .AndalusianPopulation_loader import *
from .AndalusianPopulation_InterfazMapa import *
from .AndalusianPopulation_instalacion import *


class AndalusianPopulation:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'AndalusianPopulation_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&Andalusian Population')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('AndalusianPopulation', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/AndalusianPopulation/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'Caracterización población de Andalucía'),
            callback=self.run,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.first_start = True


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&Andalusian Population'),
                action)
            self.iface.removeToolBarIcon(action)


    def run(self):
        #Source layers and Rates [initials,name]
        lista_url_capas250=LeerUrl()
        
        """
        lista_url_capas250=["contextualWMSLegend=0&crs=EPSG:25830&dpiMode=7&featureCount=10&format=image/png&layers=ortofotografia_2016_rgb&styles&url=http://www.ideandalucia.es/wms/ortofoto2016",
        "pagingEnabled='true' preferCoordinatesForWfsT11='false' restrictToRequestBBOX='1' srsname='EPSG:25830' typename='DERA_g13_limites_administrativos:g13_01_TerminoMunicipal' url='http://www.ideandalucia.es/services/DERA_g13_limites_administrativos/wfs' version='auto'",
        "pagingEnabled='true' preferCoordinatesForWfsT11='false' restrictToRequestBBOX='1' srsname='EPSG:25830' typename='grid:gridp_250' url='http://www.juntadeandalucia.es/institutodeestadisticaycartografia/geoserver-ieca/grid/wfs' version='auto'",
        "pagingEnabled='true' preferCoordinatesForWfsT11='false' restrictToRequestBBOX='1' srsname='EPSG:25830' typename='gridcattp:gridcattp_250' url='http://www.juntadeandalucia.es/institutodeestadisticaycartografia/geoserver-ieca/gridcattp/wfs' version='auto'",
        "pagingEnabled='true' preferCoordinatesForWfsT11='false' restrictToRequestBBOX='1' srsname='EPSG:25830' typename='mor:RMES_250_T' url='http://www.juntadeandalucia.es/institutodeestadisticaycartografia/geoserver-ieca/mor/wfs' version='auto'",
        #"pagingEnabled='true' preferCoordinatesForWfsT11='false' restrictToRequestBBOX='1' srsname='EPSG:25830' typename='gridcatv:gridcatv_250' url='http://www.juntadeandalucia.es/institutodeestadisticaycartografia/geoserver-ieca/gridcatv/wfs' version='auto'"
        ]
        """
        TipoTasa=[['pob_tot','Población total'],['Tasa15','Porcentaje población infantil'],['Tasa65','Porcentaje población mayor 65 años'],
        ['pob_ext','Porcentaje población extranjera'],['pob_act','Porcentaje población activa'],['pob_paro','Porcentaje paro registrado'],
        ['mort_total','Mortalidad (poblacion total)'],['mort_45_65','Mortalidad (poblacion 45-65 años)'],
        ['mort_mayor65','Mortalidad (poblacion > 65 años)'],
        #['pob_viv','Nº personas por vivienda'],['porc_45m2','% de viviendas <45m2'],
        #['porc_1960','% de viviendas <1960'],['ant_med','Antigüedad mediana viviendas'],
        ['pob_m','Porcentaje población femenina'],
        ['porc_viv','Porcentaje suelo viviendas urbanas'],['porc_ind','Porcentaje suelo industrial'],
        ['porc_ofi','Porcentaje suelo oficinas'],['porc_com','Porcentaje suelo comercial'],
        ['porc_dep','Porcentaje suelo deportivo'],['porc_san','Porcentaje suelo sanitario, asistencial y beneficios'],
        ['porc_cul','Porcentaje suelo cultural']
        ]
        


        if self.first_start == True:
            self.first_start = False
            basepath = os.path.dirname(os.path.realpath(__file__)) + "\\"
            if not(os.path.isfile(basepath+'tabla.csv')):
                InstalacionWindow = InterfazInstalacion(lista_url_capas250=lista_url_capas250) 
                InstalacionWindow.exec()

                if not(InstalacionWindow.salida):
                    self.first_start = True
                    return
        #self.dlg = interfaz_inequidad_1()
        MapaWindow = InterfazMapa(parent=None,lista_url_capas250=lista_url_capas250,TipoTasa=TipoTasa)
        MapaWindow.exec()

        # show the dialog
        #self.dlg.show()
        # Run the dialog event loop
        #result = self.dlg.exec_()
        # See if OK was pressed
        #if result:
            # Do something useful here - delete the line containing pass and
            # substitute with your code.
            #pass
