# -*- coding: utf-8 -*-
"""
/***************************************************************************
 AmilDialog
                                 A QGIS plugin
 Um assistente para criar mapas interativos no navegador utilizando Leaflet
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2021-12-20
        git sha              : $Format:%H$
        copyright            : (C) 2021 by Givaldo Cesar/Codevasf-1SR
        email                : givaldocesar@live.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os, re, shutil

from qgis import processing
from qgis.core import *
from qgis.gui import QgsColorButton
from qgis.PyQt import uic
from qgis.PyQt.QtWidgets import *
from qgis.PyQt.QtGui import QColor
from qgis.PyQt.QtCore import *
from qgis.PyQt.QtWebKitWidgets import *
from qgis.PyQt.QtWebKit import QWebSettings

from .objects import *
from .pageObjects import *


FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'amil_dialog_base.ui'))


def printf(obj):
    QMessageBox.information(None, 'PRINT', str(obj))


class TextBox(QLineEdit):
    valueChanged = pyqtSignal(str, int)
    
    def __init__(self, row, content=None, parent=None):
        super().__init__(content, parent)
        self.setFrame(False)
        self.row = row
        self.textChanged.connect(lambda text: self.valueChanged.emit(text, self.row))
    
    def currentText(self):
        return self.text()
    
    def setCurrentText(self, text):
        self.setText(text)

class FilterBox(QComboBox):
    valueChanged = pyqtSignal(str, int)
    
    def __init__(self, row, parent=None):
        super().__init__(parent)
        self.row = row
        self.currentTextChanged.connect(lambda text: self.valueChanged.emit(text, self.row))
        

class DoubleBox(QDoubleSpinBox):
    valueUpdated = pyqtSignal(float, str)
    
    def __init__(self, key, parent=None):
        super().__init__(parent)
        self.key = key  
        self.setMinimum(0.0)
        self.setFixedWidth(75)
        self.valueChanged.connect(lambda value: self.valueUpdated.emit(value, self.key))


class OpacityBox(DoubleBox):
    def __init__(self, key, parent=None):
        super().__init__(key, parent)
        self.setRange(0.00, 100.00)
        self.setSingleStep(0.5)
        self.setSuffix(' %')


class ColorButton(QgsColorButton):
    colorUpdated = pyqtSignal(str, str)
    
    def __init__(self, key, color, parent=None):
        super().__init__(parent)
        self.key = key
        self.setColor(color)
        self.setFixedWidth(75)
        self.colorChanged.connect(lambda color: self.colorUpdated.emit(f'{color.red()}, {color.green()}, {color.blue()}, {color.alphaF()}', self.key))
   

class PreviewWindow(QMainWindow):
    def __init__(self, parent=None):
        super().__init__(parent)
        self.setWindowTitle('PREVIEW')
        self.resize(800, 600)
        
        self.page = QWebView(self)
        self.page.setPage(QWebPage())       
        self.page.page().setNetworkAccessManager(QgsNetworkAccessManager.instance())
        self.page.settings().setAttribute(QWebSettings.DeveloperExtrasEnabled, True)
        self.page.settings().setAttribute(QWebSettings.DnsPrefetchEnabled, True)
        self.page.settings().setAttribute(QWebSettings.JavascriptEnabled, True)
        self.page.settings().setAttribute(QWebSettings.JavascriptCanOpenWindows, True)
        self.page.settings().setAttribute(QWebSettings.JavascriptCanAccessClipboard, True)
        
        self.setCentralWidget(self.page)

class AmilDialog(QDialog, FORM_CLASS):    
    def __init__(self, parent=None):
        super(AmilDialog, self).__init__(parent)
        self.setupUi(self)      

        # Get Project Object
        self.project = QgsProject.instance()
        self.project.layersAdded.connect(self.addLayersToList)
        self.project.layersRemoved.connect(self.removeLayersFromList)
        self.project.homePathChanged.connect(self.projectChanged)
        self.projectChanged()
        
        # Button Functions
        self.folderSelectionBTN.clicked.connect(self.folderSelection)
        self.exportBTN.clicked.connect(self.export)
        
        #LayerList Function
        self.layersList.itemClicked.connect(self.updateLayerConfig)
        self.upLayerBTN.clicked.connect(self.upLayer)
        self.downLayerBTN.clicked.connect(self.downLayer)
        
        #Configurer Layer Functions
        self.labelText.textEdited.connect(self.updateLabelLayer)
        
        self.popUpBox.toggled.connect(lambda enabled: self.layers[int(self.orderText.text())].setEnablePopUp(enabled))
        self.popUpAttributes.itemChanged.connect(self.updatePopUp)
        self.upPopUp.clicked.connect(lambda: self.upAttribute(self.popUpAttributes, self.layers[int(self.orderText.text())].popUpAttributes))
        self.downPopUp.clicked.connect(lambda: self.downAttribute(self.popUpAttributes, self.layers[int(self.orderText.text())].popUpAttributes))
        
        self.tableBox.toggled.connect(lambda enabled: self.layers[int(self.orderText.text())].setEnableTable(enabled))
        self.attributesTable.itemChanged.connect(self.updateTable)
        self.upTable.clicked.connect(lambda: self.upAttribute(self.attributesTable, self.layers[int(self.orderText.text())].attributesTable))
        self.downTable.clicked.connect(lambda: self.downAttribute(self.attributesTable, self.layers[int(self.orderText.text())].attributesTable))
        
        #Symbology Table Functions
        self.symbolsTable.horizontalHeader().setStretchLastSection(True)
        self.symbolsTable.itemChanged.connect(self.updateLabelSymbology)
        
        # Baselayers CheckBoxes
        self.googleHybrid.stateChanged.connect(lambda state: self.stateBaseLayerChanged(state, self.googleHybrid.text()))
        self.googleSatellite.stateChanged.connect(lambda state: self.stateBaseLayerChanged(state, self.googleSatellite.text()))
        self.googleStreet.stateChanged.connect(lambda state: self.stateBaseLayerChanged(state, self.googleStreet.text()))
        
        #Preview Area
        self.previewWindow = PreviewWindow()
       
    def getLayer(self, ident):
        for layer in self.layers:
            if layer.id == ident:
                return layer
        
        return None
    
    def addLayersToList(self, layers):
        if type(layers) == dict:
            layers = list(layers.values())
            
        count = len(self.layers)    
        for layer in layers:
            if type(layer) == QgsVectorLayer and not self.getLayer(layer.id()):
                item = QListWidgetItem(layer.name())
                item.setCheckState(Qt.Checked)
                self.layersList.addItem(item)
                
                geometry = QgsWkbTypes.geometryDisplayString(layer.geometryType())
                if geometry == 'Point': 
                    self.layers.append(PointLayer(layer, count))
                elif geometry == 'Line':
                    self.layers.append(LineLayer(layer, count))
                elif geometry == 'Polygon':
                    self.layers.append(PolygonLayer(layer, count))

                self.layers[-1].rendererChanged.connect(self.symbologyChanged)
                count += 1
    
    def removeLayersFromList(self, layersID):
        for layerID in layersID:
            layer = self.getLayer(layerID)
            if layer:
                row = layer.order
                self.layers.remove(layer)
                self.layersList.takeItem(row)
        
        if self.layers:
            self.layersList.setCurrentRow(0)
    
    def upLayer(self):
        row = self.layersList.currentRow()
        if row > 0:
            self.layers[row].order -= 1
            self.layers[row - 1].order += 1
            
            aux = self.layers[row]
            self.layers[row] = self.layers[row - 1]
            self.layers[row - 1] = aux
            
            self.layersList.item(row).setText(self.layers[row].layerName)
            if self.layers[row].enabled:
                self.layersList.item(row).setCheckState(Qt.Checked)
            else:
                self.layersList.item(row).setCheckState(Qt.Unchecked)
                
            self.layersList.item(row - 1).setText(self.layers[row - 1].layerName)
            if self.layers[row - 1].enabled:
                self.layersList.item(row - 1).setCheckState(Qt.Checked)
            else:
                self.layersList.item(row - 1).setCheckState(Qt.Unchecked)
                
            self.layersList.setCurrentRow(row - 1)
            self.updateLayerConfig(self.layersList.item(row - 1))
    
    def downLayer(self):
        row = self.layersList.currentRow()
        if row < self.layersList.count() - 1:
            self.layers[row].order += 1
            self.layers[row + 1].order -= 1
            
            aux = self.layers[row]
            self.layers[row] = self.layers[row + 1]
            self.layers[row + 1] = aux
            
            self.layersList.item(row).setText(self.layers[row].layerName)
            if self.layers[row].enabled:
                self.layersList.item(row).setCheckState(Qt.Checked)
            else:
                self.layersList.item(row).setCheckState(Qt.Unchecked)
                
            self.layersList.item(row + 1).setText(self.layers[row + 1].layerName)
            if self.layers[row + 1].enabled:
                self.layersList.item(row + 1).setCheckState(Qt.Checked)
            else:
                self.layersList.item(row + 1).setCheckState(Qt.Unchecked)
                
            self.layersList.setCurrentRow(row + 1)
            self.updateLayerConfig(self.layersList.item(row + 1))
    
    def updateLabelLayer(self, label):
        layer = self.layers[int(self.orderText.text())]
        if label:
            layer.label = label
            if layer.type == SINGLE:
                layer.symbology['symbol']['label'] = label
        else:
            layer.label = self.project.mapLayer(self.idText.text()).name()
            if layer.type == SINGLE:
                layer.symbology['symbol']['label'] = self.project.mapLayer(self.idText.text()).name()
    
    def updateLayerConfig(self, listItem):
        if listItem.checkState() == Qt.Unchecked:
            self.layers[self.layersList.row(listItem)].enabled = False
        else:
            self.layers[self.layersList.row(listItem)].enabled = True   
        
        if listItem.isSelected():
            self.layerConfigBox.setEnabled(self.layers[self.layersList.row(listItem)].enabled)
            self.updateLayerAttributesAndLabels(listItem)
            self.updateLayerSymbology(listItem)
    
    def updateLayerAttributesAndLabels(self, listItem):
        layer = self.layers[self.layersList.row(listItem)]
        
        self.orderText.setText(str(layer.order))
        self.idText.setText(layer.id)
        self.labelText.setText(layer.label)
        
        self.popUpBox.setChecked(layer.enablePopUp)
        self.tableBox.setChecked(layer.enableTable)
        
        self.popUpAttributes.blockSignals(True)
        self.popUpAttributes.clearContents()
        self.popUpAttributes.setRowCount(len(layer.popUpAttributes))
        
        count = 0
        for attribute in layer.popUpAttributes:
            item = QTableWidgetItem(attribute.name)
            item.setFlags(item.flags() ^ Qt.ItemIsEditable)
            
            labelItem = TextBox(count, attribute.label)
            labelItem.valueChanged.connect(lambda text, row: self.updateAttribute(layer.getPopUpAttribute, self.popUpAttributes, text, row))
            
            if attribute.enabled:
                item.setCheckState(Qt.Checked)
            else:
                item.setCheckState(Qt.Unchecked)
                labelItem.setEnabled(False)
                       
            self.popUpAttributes.setItem(count, 0, item)
            self.popUpAttributes.setCellWidget(count, 1, labelItem)
            count += 1
        self.popUpAttributes.blockSignals(False)    
        
        self.attributesTable.blockSignals(True)
        self.attributesTable.clearContents()
        self.attributesTable.setRowCount(len(layer.attributesTable))
        
        count = 0
        for attribute in layer.attributesTable:
            item = QTableWidgetItem(attribute.name)
            item.setFlags(item.flags() ^ Qt.ItemIsEditable)
            
            filterWidget = FilterBox(count)
            filterWidget.addItems(['Sim', 'Não'])
            filterWidget.valueChanged.connect(lambda text, row: self.updateAttributeFilter(text, row))
            
            labelItem = TextBox(count, attribute.label)
            labelItem.valueChanged.connect(lambda text, row: self.updateAttribute(layer.getAttribute, self.attributesTable, text, row))
            
            if attribute.enabled:
                item.setCheckState(Qt.Checked)
            else:
                item.setCheckState(Qt.Unchecked)
                filterWidget.setEnabled(False)
                labelItem.setEnabled(False)
                
            filterWidget.blockSignals(True)
            if attribute.filter:
                filterWidget.setCurrentText('Sim')
            else:
                filterWidget.setCurrentText('Não')
            filterWidget.blockSignals(False)
                       
            self.attributesTable.setItem(count, 0, item)
            self.attributesTable.setCellWidget(count, 1, filterWidget)
            self.attributesTable.setCellWidget(count, 2, labelItem)
            count += 1
        self.attributesTable.blockSignals(False)
    
    def updatePopUp(self, item):
        layer = self.layers[int(self.orderText.text())]
        attribute = layer.getPopUpAttribute(self.popUpAttributes.item(item.row(), 0).text())
        
        # Attribute is disabled/enabled
        if item.column() == 0:
            labelItem = self.popUpAttributes.cellWidget(item.row(), 1)
            labelItem.setEnabled(not labelItem.isEnabled())
            attribute.enabled = not attribute.enabled
        else:
            printf(item)
            if item.text():
                attribute.label = item.text()
            else:
                attribute.label = attribute.name
                item.setText(attribute.name)
    
    def updateTable(self, item):
        layer = self.layers[int(self.orderText.text())]
        attribute = layer.getAttribute(self.attributesTable.item(item.row(), 0).text())
        
        # Attribute is disabled/enabled
        if item.column() == 0:
            filterItem = self.attributesTable.cellWidget(item.row(), 1)
            filterItem.setEnabled(not filterItem.isEnabled())
            
            labelItem = self.attributesTable.cellWidget(item.row(), 2)
            labelItem.setEnabled(not labelItem.isEnabled())
            
            attribute.enabled = not attribute.enabled
    
    def updateAttribute(self, getAttribute, table, text, row):
        layer = self.layers[int(self.orderText.text())]
        attribute = getAttribute(table.item(row, 0).text())
        
        if text:
            attribute.label = text
        else:
            attribute.label = attribute.name
            
    def updateAttributeFilter(self, text, row):        
        layer = self.layers[int(self.orderText.text())]
        attribute = layer.getAttribute(self.attributesTable.item(row, 0).text())
        
        if text == 'Sim':
            attribute.filter = True
        else:
            attribute.filter = False
    
    @staticmethod
    def upAttribute(table, attributes):
        table.blockSignals(True)
        
        row = table.currentRow()
        
        if row > 0:
            aux = attributes[row]
            attributes[row] = attributes[row - 1]
            attributes[row - 1] = aux
        
            for i in range(table.columnCount()):
                rowItem = table.item(row, i)
                if rowItem:
                    aboveItem = table.item(row - 1, i)
                    
                    aux = rowItem.text()
                    rowItem.setText(aboveItem.text())
                    table.item(row - 1, i).setText(aux)
                    
                    # DAR UM JEITO DE ALTERAR O DISPONIBILIDADE DO ROTULO, ADD EDITLINE????
                else:
                    rowItem = table.cellWidget(row, i)
                    aboveItem = table.cellWidget(row - 1, i)
                    
                    aux = rowItem.currentText()
                    rowItem.setCurrentText(aboveItem.currentText())
                    aboveItem.setCurrentText(aux)
                    
                    rowItem.setEnabled(attributes[row].enabled)
                    aboveItem.setEnabled(attributes[row - 1].enabled)
            
            table.selectRow(row-1)
            table.setFocus()
        table.blockSignals(False)
                       
    @staticmethod
    def downAttribute(table, attributes):
        table.blockSignals(True)
        
        row = table.currentRow()
        if row < table.rowCount() - 1:
            aux = attributes[row]
            attributes[row] = attributes[row + 1]
            attributes[row + 1] = aux
            
            
            for i in range(table.columnCount()):
                rowItem = table.item(row, i)
                if rowItem:
                    belowItem = table.item(row + 1, i)
                    
                    aux = rowItem.text()
                    rowItem.setText(belowItem.text())
                    table.item(row + 1, i).setText(aux)
                else:
                    rowItem = table.cellWidget(row, i)
                    belowItem = table.cellWidget(row + 1, i)
                    
                    aux = rowItem.currentText()
                    rowItem.setCurrentText(belowItem.currentText())
                    belowItem.setCurrentText(aux)
                    
                    rowItem.setEnabled(attributes[row].enabled)
                    belowItem.setEnabled(attributes[row + 1].enabled)
            
            table.selectRow(row + 1)
            table.setFocus()
        table.blockSignals(False)
    
    @staticmethod
    def getColor(stringColor):
        channels = stringColor.split(',')
        return QColor(int(channels[0]), int(channels[1]), int(channels[2]), int(float(channels[3]) * 255))
    
    def updateLayerSymbology(self, listItem):
        layer = self.layers[self.layersList.row(listItem)]
        
        self.geometryText.setText(layer.geometry)
        self.typeText.setText(layer.type)
        
        self.symbolsTable.blockSignals(True)
        self.symbolsTable.clear()
        
        if layer.geometry == POINT:
            self.symbolsTable.setColumnCount(7)
            self.symbolsTable.hideColumn(0)
            self.symbolsTable.setHorizontalHeaderLabels(['key', 'Opacidade', 'Tamanho', 'Larg. do Traço', 'Cor do Traço', 'Preenchimento', 'Rótulo'])
            for i in range(self.symbolsTable.columnCount()):
                self.symbolsTable.setColumnWidth(i, 75)
            
            self.symbolsTable.setRowCount(len(layer.symbology))
            
            count = 0
            for key, symbol in layer.symbology.items():
                self.symbolsTable.setItem(count, 0, QTableWidgetItem(key))

                opacityBox = OpacityBox(key)
                opacityBox.setValue(symbol['opacity'] * 100)
                opacityBox.valueUpdated.connect(lambda value, key: self.updateSymbologyValue(key, 'opacity', value))
                self.symbolsTable.setCellWidget(count, 1, opacityBox)
                
                sizeBox = DoubleBox(key)
                sizeBox.setValue(symbol['radius'])
                sizeBox.valueUpdated.connect(lambda value, key: self.updateSymbologyValue(key, 'radius', value))
                self.symbolsTable.setCellWidget(count, 2, sizeBox)
                
                weightBox = DoubleBox(key)
                weightBox.setValue(symbol['weight'])
                weightBox.valueUpdated.connect(lambda value, key: self.updateSymbologyValue(key, 'weight', value))
                self.symbolsTable.setCellWidget(count, 3, weightBox)
                
                lineColor = ColorButton(key, self.getColor(symbol['color']))
                lineColor.colorUpdated.connect(lambda value, key: self.updateSymbologyValue(key, 'color', value))
                self.symbolsTable.setCellWidget(count, 4, lineColor)
                
                fillColor = ColorButton(key, self.getColor(symbol['fillColor']))
                fillColor.colorUpdated.connect(lambda value, key: self.updateSymbologyValue(key, 'fillColor', value))
                self.symbolsTable.setCellWidget(count, 5, fillColor)
                
                self.symbolsTable.setItem(count, 6, QTableWidgetItem(symbol['label']))
                
                count += 1
            
        elif layer.geometry == LINE:
            self.symbolsTable.setColumnCount(5)
            self.symbolsTable.hideColumn(0)
            self.symbolsTable.setHorizontalHeaderLabels(['key', 'Opacidade', 'Larg. do Traço', 'Cor do Traço', 'Rótulo'])
            for i in range(self.symbolsTable.columnCount()):
                self.symbolsTable.setColumnWidth(i, 75)
            self.symbolsTable.setRowCount(len(layer.symbology))
            
            count = 0
            for key, symbol in layer.symbology.items():
                self.symbolsTable.setItem(count, 0, QTableWidgetItem(key))
                
                opacityBox = OpacityBox(key)
                opacityBox.setValue(symbol['opacity'] * 100)
                opacityBox.valueUpdated.connect(lambda value, key: self.updateSymbologyValue(key, 'opacity', value))
                self.symbolsTable.setCellWidget(count, 1, opacityBox)
                
                weightBox = DoubleBox(key)
                weightBox.setValue(symbol['weight'])
                weightBox.valueUpdated.connect(lambda value, key: self.updateSymbologyValue(key, 'weight', value))
                self.symbolsTable.setCellWidget(count, 2, weightBox)
                
                lineColor = ColorButton(key, self.getColor(symbol['color']))
                lineColor.colorUpdated.connect(lambda value, key: self.updateSymbologyValue(key, 'color', value))
                self.symbolsTable.setCellWidget(count, 3, lineColor)
                
                self.symbolsTable.setItem(count, 4, QTableWidgetItem(symbol['label']))
                
                count += 1
        
        elif layer.geometry == POLYGON:
            self.symbolsTable.setColumnCount(6)
            self.symbolsTable.hideColumn(0)
            self.symbolsTable.setHorizontalHeaderLabels(['key', 'Opacidade', 'Larg. do Traço', 'Cor do Traço', 'Preenchimento', 'Rótulo'])
            for i in range(self.symbolsTable.columnCount()):
                self.symbolsTable.setColumnWidth(i, 75)
            self.symbolsTable.setRowCount(len(layer.symbology))
            
            count = 0
            for key, symbol in layer.symbology.items():
                self.symbolsTable.setItem(count, 0, QTableWidgetItem(key))
                
                opacityBox = OpacityBox(key)
                opacityBox.setValue(symbol['opacity'] * 100)
                opacityBox.valueUpdated.connect(lambda value, key: self.updateSymbologyValue(key, 'opacity', value))
                self.symbolsTable.setCellWidget(count, 1, opacityBox)
                
                weightBox = DoubleBox(key)
                weightBox.setValue(symbol['weight'])
                weightBox.valueUpdated.connect(lambda value, key: self.updateSymbologyValue(key, 'weight', value))
                self.symbolsTable.setCellWidget(count, 2, weightBox)
                
                lineColor = ColorButton(key, self.getColor(symbol['color']))
                lineColor.colorUpdated.connect(lambda value, key: self.updateSymbologyValue(key, 'color', value))
                self.symbolsTable.setCellWidget(count, 3, lineColor)
                
                fillColor = ColorButton(key, self.getColor(symbol['fillColor']))
                fillColor.colorUpdated.connect(lambda value, key: self.updateSymbologyValue(key, 'fillColor', value))
                self.symbolsTable.setCellWidget(count, 4, fillColor)
                
                self.symbolsTable.setItem(count, 5, QTableWidgetItem(symbol['label']))
                
                count += 1
          
        self.symbolsTable.blockSignals(False)
    
    def updateSymbologyValue(self, key, field, value):
        layer = self.layers[int(self.orderText.text())]       
        if field == 'opacity':
            value /= 100
        
        layer.symbology[key][field] = value
        
    def updateLabelSymbology(self, item):
        layer = self.layers[int(self.orderText.text())]
        key = self.symbolsTable.item(item.row(), 0).text()
        
        if item.text():
            layer.symbology[key]['label'] = item.text()
        else:
            layer.symbology[key]['label'] = '-------'
            item.setText('-------')
    
    def clearInfo(self):
        self.layers = []
        
        self.layersList.clear()
        
        self.orderText.clear()
        self.idText.clear()
        self.labelText.clear()
        self.popUpAttributes.setRowCount(0)
        self.popUpAttributes.clearContents()
        self.attributesTable.setRowCount(0)
        self.attributesTable.clearContents()
        
        self.geometryText.clear()
        self.typeText.clear()
        self.symbolsTable.setRowCount(0)
        self.symbolsTable.setColumnCount(0)
        self.symbolsTable.clear()
        
        self.title.clear()
    
    def projectChanged(self):  
        self.clearInfo()
        
        self.addLayersToList(self.project.mapLayers())
        if self.layersList.count() > 0:
            self.layersList.setCurrentRow(0)
            self.layersList.setFocus()
            self.updateLayerConfig(self.layersList.item(0))
            
        self.folderDirectory.setText(self.project.homePath())
        self.title.setText(self.project.fileInfo().baseName())
               
    def symbologyChanged(self, layer):
        layer.setSymbology(self.project.mapLayer(layer.id))
        
        if layer.order == int(self.orderText.text()):
            self.updateLayerSymbology(self.layersList.item(layer.order))
      
    def stateBaseLayerChanged(self, state, text):
        idx = self.standardBase.findText(text, Qt.MatchExactly)
        if state == Qt.Checked and idx == -1:
            self.standardBase.addItem(text)
        else:
            self.standardBase.removeItem(idx)
    
    def folderSelection(self):
        filesDir = QFileDialog.getExistingDirectory(self, 'Escolha o diretório', '')
        if filesDir:
            self.folderDirectory.setText(filesDir)

    def cleanName(self, name):
        name = name =  re.sub('[^a-zA-Z0-9 \n\.]', '_', name).replace(' ', '_').replace('.', '_')
        
        # SAME NAME LAYERS ARE RENAMED
        count = 1
        while name in self.layersNames:
            name = name + f'_{count}'
            count += 1
        
        self.layersNames.append(name)
        return name
    
    @staticmethod
    def defineCRS(vectorLayer):
        pass
    
    def createLayerData(self, layerName, layerID):
        qgisLayer = self.project.mapLayer(layerID)
        
        if not qgisLayer.sourceCrs().description():
            self.defineCRS(qgisLayer)
            
        # REPROJECT TO WGS84
        if (qgisLayer.sourceCrs().description() != 'WGS 84'):
            parameters = {'INPUT': qgisLayer, 'TARGET_CRS': 'EPSG:4326', 'OUTPUT': f'memory:{qgisLayer}_Reprojected'}
            qgisLayer = processing.run('native:reprojectlayer', parameters)['OUTPUT']
        
        layerExported = 'var ' + layerName + '_data = ' + QgsJsonExporter().exportFeatures(qgisLayer.getFeatures()).replace("null", "''")  
        fileData = open(os.path.join(self.folderDirectory.text(), self.title.text(), 'data', layerName + '.js'), 'w')
        fileData.writelines(layerExported)
        fileData.close()
          
    def export(self):
        if self.folderDirectory.text():
            page = WebPage(self.title.text())
            mapJS = Map()
            attributesTableJS = AttributesTable()
            
            self.layersNames = []
            
            page.head.code += '\n\t\t<!-- Caminhos paras os dados das camadas -->\n'
            
            # ADD BASE LAYERS TO MAP
            baseLayers = {GOOGLE_STREET: self.googleStreet.isChecked(),
                          GOOGLE_SATELLITE: self.googleSatellite.isChecked(),
                          GOOGLE_HYBRID: self.googleHybrid.isChecked()}
            mapJS.addBaseLayers(baseLayers, self.standardBase.currentText())

            # CREATE LAYERSDATA DIRECTORY
            os.makedirs(os.path.join(self.folderDirectory.text(), self.title.text(), 'data'), exist_ok=True)
            
            # ADD PROJECT LAYERS TO MAP
            for layer in self.layers:
                if layer.enabled:
                    name = self.cleanName(layer.layerName)
                    
                    # CREATE LAYER DATA
                    self.createLayerData(name, layer.id)
                    
                    # ADD LAYER TO PAGE
                    page.head.addLayerDataPath(name)
                    
                    if layer.enableTable:
                        page.body.addLayerTableButton(name, layer.label)
                        page.body.addLayerTableArea(name)
                        
                        if layer.enableTable:
                            attributesTableJS.addAttributesTable(name, layer)
                    
                    # ADD LAYER TO MAP
                    mapJS.addLayerMap(name, layer)
                
            # ADD LEGEND TO MAP
            if self.legendBox.isChecked():
                mapJS.createLegendMap(self.legendPosition.currentText())
            
            if self.controlLayersBox.isChecked():
                mapJS.createLayersControl(self.controlPosition.currentText())
            
            # CREATE DIRECTORIES E EXPORT FILES
            leafletPath = os.path.join(QgsApplication.instance().qgisSettingsDirPath(), 'python', 'plugins', 'amil', 'leaflet')
            scriptsPath = os.path.join(QgsApplication.instance().qgisSettingsDirPath(), 'python', 'plugins', 'amil', 'javascript')
            
            shutil.copytree(leafletPath, os.path.join(self.folderDirectory.text(), self.title.text(), 'leaflet'), copy_function=shutil.copy2, dirs_exist_ok=True)
            shutil.copytree(scriptsPath, os.path.join(self.folderDirectory.text(), self.title.text(), 'javascript'), copy_function=shutil.copy2, dirs_exist_ok=True)
            
            htmlPath = os.path.join(self.folderDirectory.text(), self.title.text(), 'index.html')
            htmlFile = open(htmlPath, 'w')
            htmlFile.write(page.html())
            self.previewWindow.page.settings().clearMemoryCaches()
            self.previewWindow.page.load(QUrl.fromLocalFile(htmlPath))
            
            if self.showPreview.isChecked():               
                self.previewWindow.setFocus(Qt.ActiveWindowFocusReason)
                self.previewWindow.activateWindow()
                self.previewWindow.show()
            else:
                QMessageBox.information(self.previewWindow, 'Informação', f'Os arquivos foram exportados para:\n>>> {self.folderDirectory.text()}')
                    
            mapFile = open(os.path.join(self.folderDirectory.text(), self.title.text(), 'javascript', 'map.js'), 'w')
            mapFile.write(mapJS.code(self.showHideItem.isChecked()))
            
            attributesFile = open(os.path.join(self.folderDirectory.text(), self.title.text(), 'javascript', 'attributes.js'), 'w')
            attributesFile.write(attributesTableJS.code())
        else:
            QMessageBox.information(self, 'Informação', f'Selecione um local para salvar o webmap.')
        
 
 
 
 
 
 
 
 
 
 
 
 
 
 