# -*- coding: utf-8 -*-

"""
/***************************************************************************
 AMERTA
                                 A QGIS plugin
 Analisis Multi-kriteria Embung dan Rencana Tata Air
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2025-09-18
        copyright            : (C) 2025 by Badan Riset dan Inovasi Nasional
        email                : sitaranisafitri@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'Sitarani Safitri, Orbita Roswintiarti, Okta Fajar Saputra, Galdita Aruba Chulafak, Gatot Nugroho, Wismu Sunarmodo, Kusumaning Ayu Dyah Sukowati, Hana Listi Fitriana'
__date__ = '2025-09-18'
__copyright__ = '(C) 2025 by Badan Riset dan Inovasi Nasional'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

import math
from contextlib import contextmanager
from qgis.PyQt.QtCore import QCoreApplication, QVariant
from qgis.core import (
    QgsProcessing, QgsProcessingAlgorithm, QgsProcessingException,
    QgsProcessingParameterVectorLayer, QgsProcessingParameterEnum,
    QgsProcessingParameterNumber, QgsProcessingParameterBoolean,
    QgsProcessingParameterVectorDestination,
    QgsCoordinateReferenceSystem, QgsField, QgsVectorLayer, QgsProcessingUtils
)
import processing
import os
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtCore import QUrl

@contextmanager
def edit(layer):
    layer.startEditing()
    try:
        yield
    except Exception:
        layer.rollBack()
        raise
    else:
        layer.commitChanges()


class GridPLAlgorithm(QgsProcessingAlgorithm):
    AOI         = 'AOI'
    PL_POLY     = 'PL_POLY'
    GRID_SIZE   = 'GRID_SIZE'
    CUSTOM_M    = 'CUSTOM_M'
    BUILD_INDEX = 'BUILD_INDEX'
    OUTPUT      = 'OUTPUT'

    GRID_CHOICES = ['30″ (≈ 925 m)', '5″ (≈ 150 m)', 'Custom (meter)']

    def tr(self, s): return QCoreApplication.translate('Processing', s)
    def name(self): return 'a_grid_pl_majority_score_fast'
    def displayName(self): return self.tr('Grid Land Cover/Land Use')
    def groupId(self): return 'C. MCDA Factors for Retention Ponds'
    def group(self): return self.tr('C. MCDA Factors for Retention Ponds')
    def icon(self):
        return QIcon(os.path.join(os.path.dirname(__file__), 'preanalysis.png'))

    def shortHelpString(self):
        return self.tr("""\
🇮🇩 ID  Modul ini membuat grid dan menetapkan kelas Penutup Lahan (PL) dominan per sel, lalu memberi skor S_PL.
Cocok untuk tahap pra-MCDA analisis potensi lokasi embung.

Alur kerja:
1) Siapkan Land Cover/Land Use yang sudah distandarisasi pada modul Land Cover Class Standardization (PL).
2) Siapkan data spasial Area of Interest (AOI), contoh batas administrasi atau batas wilayah sungai.
3) Tentukan resolusi grid dari dropdown atau custom dalam satuan meter (30″/5″/Custom).
4) Memasukkan PL ke dalam grid sesuai AOI.
5) Mengisi skor S_PL berdasarkan kategori PL.

Keluaran:
• Grid Land Cover/Land Use berisi kolom: id, PL, S_PL.

──────────────

🌍 EN  This module creates a grid, assigns the dominant Land Cover/Land Use (PL) per cell, then computes S_PL scores.
Designed for the pre-MCDA stage in small reservoir siting.

Workflow:
1) Prepare standardized Land Cover/Land Use using the Land Cover Class Standardization (PL) module.
2) Prepare AOI spatial data (e.g., administrative boundary or river basin boundary).
3) Choose grid resolution from the dropdown or use a custom value in meters (30″/5″/Custom).
4) Populate PL into the grid constrained by the AOI.
5) Assign S_PL scores based on PL categories.

Output:
• Grid Land Cover/Land Use with fields: id, PL, S_PL.""")

    def createInstance(self): return GridPLAlgorithm()

    # ---------------- Helpers ----------------
    def _as_layer(self, ref, context):
        try:
            if hasattr(ref, 'extent'): return ref
            lyr = QgsProcessingUtils.mapLayerFromString(ref, context)
            if lyr is not None: return lyr
            lyr = QgsVectorLayer(ref, 'layer', 'ogr')
            if lyr is not None and lyr.isValid(): return lyr
        except Exception:
            pass
        raise QgsProcessingException(self.tr('Failed to load layer: {}').format(ref))

    def _mk_spatial_index(self, vlayer, context, feedback):
        try:
            processing.run('native:createspatialindex', {'INPUT': vlayer},
                           context=context, feedback=feedback, is_child_algorithm=True)
        except Exception:
            pass
        return vlayer

    def _fix_geoms(self, vlayer, context, feedback):
        try:
            return processing.run('native:fixgeometries',
                                  {'INPUT': vlayer, 'OUTPUT': 'TEMPORARY_OUTPUT'},
                                  context=context, feedback=feedback, is_child_algorithm=True)['OUTPUT']
        except Exception:
            return vlayer

    def _dissolve_all(self, vlayer, context, feedback):
        try:
            return processing.run('native:dissolve',
                                  {'INPUT': vlayer, 'FIELD': [], 'SEPARATE_DISJOINT': False,
                                   'OUTPUT': 'TEMPORARY_OUTPUT'},
                                  context=context, feedback=feedback, is_child_algorithm=True)['OUTPUT']
        except Exception:
            return vlayer

    def _to_wgs84(self, layer, context, feedback):
        res = processing.run('native:reprojectlayer',
                             {'INPUT': layer, 'TARGET_CRS': QgsCoordinateReferenceSystem('EPSG:4326'),
                              'OPERATION': '', 'OUTPUT': 'TEMPORARY_OUTPUT'},
                             context=context, feedback=feedback, is_child_algorithm=True)
        return res['OUTPUT']

    def _deg_spacing_from_option(self, option_idx, custom_m, aoi_wgs_layer_obj):
        if option_idx == 0: return 30.0 / 3600.0, 30.0 / 3600.0
        if option_idx == 1: return 5.0 / 3600.0, 5.0 / 3600.0
        c = aoi_wgs_layer_obj.extent().center()
        deg_lat = float(custom_m) / 111320.0
        coslat = max(1e-6, math.cos(math.radians(c.y())))
        deg_lon = float(custom_m) / (111320.0 * coslat)
        return deg_lon, deg_lat

    def _assign_stable_id_global(self, vlayer, dx_deg, dy_deg, lon0=-180.0, lat0=-90.0, numeric=True):
        prov = vlayer.dataProvider()
        if vlayer.fields().indexOf('id') == -1:
            prov.addAttributes([QgsField('id', QVariant.Int if numeric else QVariant.String)])
            vlayer.updateFields()
        idx_id = vlayer.fields().indexOf('id')
        arcsec_x = int(round(dx_deg * 3600.0 + 1e-9))
        with edit(vlayer):
            for ft in vlayer.getFeatures():
                c = ft.geometry().centroid().asPoint()
                ix = int((c.x() - lon0) // dx_deg)
                iy = int((c.y() - lat0) // dy_deg)
                gid = int(iy) * 1_000_000 + int(ix) if numeric else f"G{arcsec_x}s_{iy:06d}_{ix:06d}"
                vlayer.changeAttributeValue(ft.id(), idx_id, gid)
        return vlayer

    # ---------------- Params ----------------
    def initAlgorithm(self, config=None):
        self.addParameter(QgsProcessingParameterVectorLayer(
            self.PL_POLY, self.tr('Land Cover/Land Use (must contain a "PL" field)'),
            types=[QgsProcessing.TypeVectorPolygon]
        ))
        self.addParameter(QgsProcessingParameterVectorLayer(
            self.AOI, self.tr('Area of Interest (AOI)'),
            types=[QgsProcessing.TypeVectorPolygon]
        ))
        self.addParameter(QgsProcessingParameterEnum(
            self.GRID_SIZE, self.tr('Grid Resolution'), self.GRID_CHOICES, defaultValue=0
        ))
        self.addParameter(QgsProcessingParameterNumber(
            self.CUSTOM_M, self.tr('Grid Resolution (meter) for "Custom (meter)"'),
            type=QgsProcessingParameterNumber.Double, defaultValue=1.0, minValue=0.0
        ))
        self.addParameter(QgsProcessingParameterBoolean(
            self.BUILD_INDEX, self.tr('Create spatial index on output'), defaultValue=True
        ))
        self.addParameter(QgsProcessingParameterVectorDestination(
            self.OUTPUT, self.tr('Grid Land Cover/Land Use')
        ))

    # ---------------- Core ----------------
    def processAlgorithm(self, parameters, context, feedback):
        pl_vec   = self.parameterAsVectorLayer(parameters, self.PL_POLY, context)
        aoi_vec  = self.parameterAsVectorLayer(parameters, self.AOI, context)
        grid_idx = int(self.parameterAsEnum(parameters, self.GRID_SIZE, context))
        custom_m = float(self.parameterAsDouble(parameters, self.CUSTOM_M, context))
        make_idx = bool(self.parameterAsBoolean(parameters, self.BUILD_INDEX, context))
        out_path = self.parameterAsOutputLayer(parameters, self.OUTPUT, context)

        if pl_vec is None:  raise QgsProcessingException(self.tr('The LCLU layer is invalid.'))
        if aoi_vec is None: raise QgsProcessingException(self.tr('The AOI layer is invalid.'))
        if pl_vec.fields().indexOf('PL') == -1:
            raise QgsProcessingException(self.tr('The LCLU layer does not contain a "PL" field.'))

        # AOI → WGS84 → fix → dissolve → index
        aoi_wgs = self._to_wgs84(aoi_vec, context, feedback)
        aoi_wgs = self._fix_geoms(aoi_wgs, context, feedback)
        aoi_wgs = self._dissolve_all(aoi_wgs, context, feedback)
        aoi_wgs = self._as_layer(aoi_wgs, context)
        self._mk_spatial_index(aoi_wgs, context, feedback)

        # PL → WGS84 → fix → index
        pl_wgs = self._to_wgs84(pl_vec, context, feedback)
        pl_wgs = self._fix_geoms(pl_wgs, context, feedback)
        pl_wgs = self._as_layer(pl_wgs, context)
        self._mk_spatial_index(pl_wgs, context, feedback)

        # Resolusi grid (deg)
        xdeg, ydeg = self._deg_spacing_from_option(grid_idx, custom_m, aoi_wgs)
        feedback.pushInfo(self.tr(f'Grid resolution (deg): dX={xdeg}, dY={ydeg}'))

        # Buat grid → subset ke AOI → beri id stabil → index
        e = aoi_wgs.extent()
        aoi_extent_wkt = f'{e.xMinimum()},{e.xMaximum()},{e.yMinimum()},{e.yMaximum()} [EPSG:4326]'
        grid = processing.run('native:creategrid',
            {'TYPE': 2, 'EXTENT': aoi_extent_wkt,
             'HSPACING': xdeg, 'VSPACING': ydeg,
             'HOVERLAY': 0.0, 'VOVERLAY': 0.0,
             'CRS': QgsCoordinateReferenceSystem('EPSG:4326'),
             'OUTPUT': 'TEMPORARY_OUTPUT'},
            context=context, feedback=feedback, is_child_algorithm=True)['OUTPUT']
        self._mk_spatial_index(grid, context, feedback)

        grid_aoi = processing.run('qgis:extractbylocation',
            {'INPUT': grid, 'PREDICATE': [0], 'INTERSECT': aoi_wgs, 'OUTPUT': 'TEMPORARY_OUTPUT'},
            context=context, feedback=feedback, is_child_algorithm=True)['OUTPUT']

        grid_aoi_layer = self._as_layer(grid_aoi, context)
        grid_aoi_layer = self._assign_stable_id_global(grid_aoi_layer, dx_deg=xdeg, dy_deg=ydeg,
                                                       lon0=-180.0, lat0=-90.0, numeric=True)
        self._mk_spatial_index(grid_aoi_layer, context, feedback)
        grid_aoi = processing.run('native:savefeatures',
            {'INPUT': grid_aoi_layer, 'OUTPUT': 'TEMPORARY_OUTPUT'},
            context=context, feedback=feedback, is_child_algorithm=True)['OUTPUT']

        # Intersect grid × PL
        inters = processing.run('native:intersection',
            {'INPUT': grid_aoi, 'OVERLAY': pl_wgs,
             'INPUT_FIELDS': [], 'OVERLAY_FIELDS': ['PL'],
             'OVERLAY_FIELDS_PREFIX': '',
             'OUTPUT': 'TEMPORARY_OUTPUT'},
            context=context, feedback=feedback, is_child_algorithm=True)['OUTPUT']

        # Dissolve by [id, PL]
        diss = processing.run('native:dissolve',
            {'INPUT': inters, 'FIELD': ['id', 'PL'], 'SEPARATE_DISJOINT': False,
             'OUTPUT': 'TEMPORARY_OUTPUT'},
            context=context, feedback=feedback, is_child_algorithm=True)['OUTPUT']

        # LM2 = area(transform(...)) → m²
        add_lm2 = processing.run('native:fieldcalculator',
            {'INPUT': diss, 'FIELD_NAME': 'LM2', 'FIELD_TYPE': 0,  # Float
             'FIELD_LENGTH': 20, 'FIELD_PRECISION': 3,
             'NEW_FIELD': True,
             'FORMULA': "area(transform($geometry,'EPSG:4326','EPSG:3857'))",
             'OUTPUT': 'TEMPORARY_OUTPUT'},
            context=context, feedback=feedback, is_child_algorithm=True)['OUTPUT']

        # === Ambil MAX(LM2) per id → qgis:statisticsbycategories ===
        stats = processing.run(
            'qgis:statisticsbycategories',
            {
                'INPUT': add_lm2,
                'CATEGORIES_FIELD_NAME': ['id'],
                'VALUES_FIELD_NAME': 'LM2',
                'OUTPUT': 'TEMPORARY_OUTPUT'
            },
            context=context, feedback=feedback, is_child_algorithm=True
        )['OUTPUT']

        # Deteksi nama kolom "max LM2"
        stats_layer = self._as_layer(stats, context)
        max_col = None
        for f in stats_layer.fields():
            n = f.name().lower()
            if ('max' in n or 'maximum' in n) and ('lm2' in n):
                max_col = f.name(); break
        if not max_col:
            for f in stats_layer.fields():
                if f.name().lower() == 'max' or f.name().lower() == 'maximum':
                    max_col = f.name(); break
        if not max_col:
            raise QgsProcessingException(self.tr('Could not find the maximum LM2 column in the statistics output.'))

        # Join MAX ke add_lm2
        joined = processing.run('native:joinattributestable',
            {'INPUT': add_lm2, 'FIELD': 'id',
             'INPUT_2': stats_layer, 'FIELD_2': 'id',
             'FIELDS_TO_COPY': [max_col],
             'METHOD': 1, 'DISCARD_NONMATCHING': True,
             'PREFIX': '_stat_', 'OUTPUT': 'TEMPORARY_OUTPUT'},
            context=context, feedback=feedback, is_child_algorithm=True)['OUTPUT']

        # Winners = bagian PL terluas per id
        expr = f"\"LM2\" = \"_stat_{max_col}\""
        winners = processing.run('native:extractbyexpression',
            {'INPUT': joined, 'EXPRESSION': expr, 'OUTPUT': 'TEMPORARY_OUTPUT'},
            context=context, feedback=feedback, is_child_algorithm=True)['OUTPUT']

        # Ambil hanya [id, PL] dari winners (tetap bawa geometri)
        dominant_clean = processing.run('native:retainfields',
            {'INPUT': winners, 'FIELDS': ['id', 'PL'],
             'OUTPUT': 'TEMPORARY_OUTPUT'},
            context=context, feedback=feedback, is_child_algorithm=True)['OUTPUT']

        # Join PL dominan ke grid (by id)
        grid_with_pl = processing.run('native:joinattributestable',
            {'INPUT': grid_aoi, 'FIELD': 'id',
             'INPUT_2': dominant_clean, 'FIELD_2': 'id',
             'FIELDS_TO_COPY': ['PL'],
             'METHOD': 1, 'DISCARD_NONMATCHING': False,
             'PREFIX': '', 'OUTPUT': 'TEMPORARY_OUTPUT'},
            context=context, feedback=feedback, is_child_algorithm=True)['OUTPUT']

        # === ISI NULL PADA PL DENGAN POLA "JOIN BY NEAREST" (tanpa menambah jumlah fitur) ===
        has_val = processing.run('native:extractbyexpression', {
            'INPUT': grid_with_pl, 'EXPRESSION': '"PL" IS NOT NULL', 'OUTPUT': 'TEMPORARY_OUTPUT'
        }, context=context, feedback=feedback, is_child_algorithm=True)['OUTPUT']
        no_val = processing.run('native:extractbyexpression', {
            'INPUT': grid_with_pl, 'EXPRESSION': '"PL" IS NULL', 'OUTPUT': 'TEMPORARY_OUTPUT'
        }, context=context, feedback=feedback, is_child_algorithm=True)['OUTPUT']

        merged_fill = grid_with_pl
        if self._as_layer(no_val, context).featureCount() > 0 and self._as_layer(has_val, context).featureCount() > 0:
            # (A) nearest dari grid yang sudah punya PL
            nn1 = processing.run('native:joinbynearest', {
                'INPUT': no_val,
                'INPUT_2': has_val,
                'FIELDS_TO_COPY': ['PL'],
                'DISCARD_NONMATCHING': False,
                'PREFIX': 'nn_',
                'NEIGHBORS': 5,
                'MAX_DISTANCE': 0.0,
                'OUTPUT': 'TEMPORARY_OUTPUT'
            }, context=context, feedback=feedback, is_child_algorithm=True)['OUTPUT']

            # min(distance) per id
            dist_min1 = processing.run('qgis:statisticsbycategories', {
                'INPUT': nn1, 'CATEGORIES_FIELD_NAME': ['id'], 'VALUES_FIELD_NAME': 'distance',
                'STATISTICS': [3], 'OUTPUT': 'TEMPORARY_OUTPUT'  # 3 = Min
            }, context=context, feedback=feedback, is_child_algorithm=True)['OUTPUT']
            nn1_join = processing.run('native:joinattributestable', {
                'INPUT': nn1, 'FIELD': 'id', 'INPUT_2': dist_min1, 'FIELD_2': 'id',
                'FIELDS_TO_COPY': ['min'], 'METHOD': 1, 'DISCARD_NONMATCHING': True,
                'PREFIX': '', 'OUTPUT': 'TEMPORARY_OUTPUT'
            }, context=context, feedback=feedback, is_child_algorithm=True)['OUTPUT']
            nn1_min = processing.run('native:extractbyexpression', {
                'INPUT': nn1_join, 'EXPRESSION': '"distance" = "min"', 'OUTPUT': 'TEMPORARY_OUTPUT'
            }, context=context, feedback=feedback, is_child_algorithm=True)['OUTPUT']

            # tie-break: pilih baris dengan $id terkecil per id
            pickid1 = processing.run('native:aggregate', {
                'INPUT': nn1_min, 'GROUP_BY': 'id',
                'AGGREGATES': [
                    {'aggregate': 'min', 'delimiter': ',', 'input': 'id',  'length': 20, 'name': 'id',          'precision': 0, 'type': 4},
                    {'aggregate': 'min', 'delimiter': ',', 'input': '$id','length': 20, 'name': 'pick_rowid', 'precision': 0, 'type': 4}
                ],
                'OUTPUT': 'TEMPORARY_OUTPUT'
            }, context=context, feedback=feedback, is_child_algorithm=True)['OUTPUT']
            nn1_min2 = processing.run('native:joinattributestable', {
                'INPUT': nn1_min, 'FIELD': 'id', 'INPUT_2': pickid1, 'FIELD_2': 'id',
                'FIELDS_TO_COPY': ['pick_rowid'], 'METHOD': 1, 'DISCARD_NONMATCHING': True,
                'PREFIX': '', 'OUTPUT': 'TEMPORARY_OUTPUT'
            }, context=context, feedback=feedback, is_child_algorithm=True)['OUTPUT']
            nn1_final = processing.run('native:extractbyexpression', {
                'INPUT': nn1_min2, 'EXPRESSION': '$id = "pick_rowid"', 'OUTPUT': 'TEMPORARY_OUTPUT'
            }, context=context, feedback=feedback, is_child_algorithm=True)['OUTPUT']

            # isi PL → coalesce(PL, nn_PL)
            no_val_filled = processing.run('native:joinattributestable', {
                'INPUT': no_val, 'FIELD': 'id', 'INPUT_2': nn1_final, 'FIELD_2': 'id',
                'FIELDS_TO_COPY': ['nn_PL'], 'METHOD': 1, 'DISCARD_NONMATCHING': False,
                'PREFIX': '', 'OUTPUT': 'TEMPORARY_OUTPUT'
            }, context=context, feedback=feedback, is_child_algorithm=True)['OUTPUT']
            no_val_filled = processing.run('qgis:fieldcalculator', {
                'INPUT': no_val_filled, 'FIELD_NAME': 'PL', 'FIELD_TYPE': 2, 'FIELD_LENGTH': 100, 'FIELD_PRECISION': 0,
                'NEW_FIELD': False, 'FORMULA': 'coalesce("PL","nn_PL")', 'OUTPUT': 'TEMPORARY_OUTPUT'
            }, context=context, feedback=feedback, is_child_algorithm=True)['OUTPUT']

            non_null_after_A = processing.run('native:extractbyexpression', {
                'INPUT': grid_with_pl, 'EXPRESSION': '"PL" IS NOT NULL', 'OUTPUT': 'TEMPORARY_OUTPUT'
            }, context=context, feedback=feedback, is_child_algorithm=True)['OUTPUT']
            merged_A = processing.run('native:mergevectorlayers', {
                'LAYERS': [non_null_after_A, no_val_filled], 'CRS': None, 'OUTPUT': 'TEMPORARY_OUTPUT'
            }, context=context, feedback=feedback, is_child_algorithm=True)['OUTPUT']

            # (B) fallback: bila masih ada NULL, pakai winners (poligon) terdekat
            remain_null = processing.run('native:extractbyexpression', {
                'INPUT': merged_A, 'EXPRESSION': '"PL" IS NULL', 'OUTPUT': 'TEMPORARY_OUTPUT'
            }, context=context, feedback=feedback, is_child_algorithm=True)['OUTPUT']
            if self._as_layer(remain_null, context).featureCount() > 0:
                nn2 = processing.run('native:joinbynearest', {
                    'INPUT': remain_null, 'INPUT_2': dominant_clean,
                    'FIELDS_TO_COPY': ['PL'], 'DISCARD_NONMATCHING': False,
                    'PREFIX': 'nn_', 'NEIGHBORS': 5, 'MAX_DISTANCE': 0.0,
                    'OUTPUT': 'TEMPORARY_OUTPUT'
                }, context=context, feedback=feedback, is_child_algorithm=True)['OUTPUT']
                dist_min2 = processing.run('qgis:statisticsbycategories', {
                    'INPUT': nn2, 'CATEGORIES_FIELD_NAME': ['id'], 'VALUES_FIELD_NAME': 'distance',
                    'STATISTICS': [3], 'OUTPUT': 'TEMPORARY_OUTPUT'
                }, context=context, feedback=feedback, is_child_algorithm=True)['OUTPUT']
                nn2_join = processing.run('native:joinattributestable', {
                    'INPUT': nn2, 'FIELD': 'id', 'INPUT_2': dist_min2, 'FIELD_2': 'id',
                    'FIELDS_TO_COPY': ['min'], 'METHOD': 1, 'DISCARD_NONMATCHING': True,
                    'PREFIX': '', 'OUTPUT': 'TEMPORARY_OUTPUT'
                }, context=context, feedback=feedback, is_child_algorithm=True)['OUTPUT']
                nn2_min = processing.run('native:extractbyexpression', {
                    'INPUT': nn2_join, 'EXPRESSION': '"distance" = "min"', 'OUTPUT': 'TEMPORARY_OUTPUT'
                }, context=context, feedback=feedback, is_child_algorithm=True)['OUTPUT']
                pickid2 = processing.run('native:aggregate', {
                    'INPUT': nn2_min, 'GROUP_BY': 'id',
                    'AGGREGATES': [
                        {'aggregate': 'min', 'delimiter': ',', 'input': 'id',  'length': 20, 'name': 'id',          'precision': 0, 'type': 4},
                        {'aggregate': 'min', 'delimiter': ',', 'input': '$id','length': 20, 'name': 'pick_rowid', 'precision': 0, 'type': 4}
                    ],
                    'OUTPUT': 'TEMPORARY_OUTPUT'
                }, context=context, feedback=feedback, is_child_algorithm=True)['OUTPUT']
                nn2_min2 = processing.run('native:joinattributestable', {
                    'INPUT': nn2_min, 'FIELD': 'id', 'INPUT_2': pickid2, 'FIELD_2': 'id',
                    'FIELDS_TO_COPY': ['pick_rowid'], 'METHOD': 1, 'DISCARD_NONMATCHING': True,
                    'PREFIX': '', 'OUTPUT': 'TEMPORARY_OUTPUT'
                }, context=context, feedback=feedback, is_child_algorithm=True)['OUTPUT']
                nn2_final = processing.run('native:extractbyexpression', {
                    'INPUT': nn2_min2, 'EXPRESSION': '$id = "pick_rowid"', 'OUTPUT': 'TEMPORARY_OUTPUT'
                }, context=context, feedback=feedback, is_child_algorithm=True)['OUTPUT']

                non_null_after_B = processing.run('native:extractbyexpression', {
                    'INPUT': merged_A, 'EXPRESSION': '"PL" IS NOT NULL', 'OUTPUT': 'TEMPORARY_OUTPUT'
                }, context=context, feedback=feedback, is_child_algorithm=True)['OUTPUT']
                filled_B = processing.run('native:joinattributestable', {
                    'INPUT': remain_null, 'FIELD': 'id', 'INPUT_2': nn2_final, 'FIELD_2': 'id',
                    'FIELDS_TO_COPY': ['nn_PL'], 'METHOD': 1, 'DISCARD_NONMATCHING': False,
                    'PREFIX': '', 'OUTPUT': 'TEMPORARY_OUTPUT'
                }, context=context, feedback=feedback, is_child_algorithm=True)['OUTPUT']
                filled_B = processing.run('qgis:fieldcalculator', {
                    'INPUT': filled_B, 'FIELD_NAME': 'PL', 'FIELD_TYPE': 2, 'FIELD_LENGTH': 100, 'FIELD_PRECISION': 0,
                    'NEW_FIELD': False, 'FORMULA': 'coalesce("PL","nn_PL")', 'OUTPUT': 'TEMPORARY_OUTPUT'
                }, context=context, feedback=feedback, is_child_algorithm=True)['OUTPUT']

                merged_fill = processing.run('native:mergevectorlayers', {
                    'LAYERS': [non_null_after_B, filled_B], 'CRS': None, 'OUTPUT': 'TEMPORARY_OUTPUT'
                }, context=context, feedback=feedback, is_child_algorithm=True)['OUTPUT']
            else:
                merged_fill = merged_A

        # Skor S_PL (setelah PL terisi)
        score_case = """
CASE
  WHEN "PL" IN ('Badan air') THEN 1
  WHEN "PL" IN ('Tambak') THEN 1
  WHEN "PL" IN ('Lahan terbangun') THEN 2
  WHEN "PL" IN ('Padang rumput/savanna') THEN 3
  WHEN "PL" IN ('Pertanian lahan kering') THEN 3
  WHEN "PL" IN ('Hutan') THEN 4
  WHEN "PL" IN ('Kawasan lindung/konservasi') THEN 4
  WHEN "PL" IN ('Perkebunan') THEN 4
  WHEN "PL" IN ('Pertanian lahan basah (sawah)') THEN 5
  ELSE NULL
END
""".strip()

        with_score = processing.run('native:fieldcalculator',
            {'INPUT': merged_fill, 'FIELD_NAME': 'S_PL', 'FIELD_TYPE': 1,  # Integer
             'FIELD_LENGTH': 10, 'FIELD_PRECISION': 0,
             'NEW_FIELD': True,
             'FORMULA': score_case,
             'OUTPUT': 'TEMPORARY_OUTPUT'},
            context=context, feedback=feedback, is_child_algorithm=True)['OUTPUT']

        # Keep only id, PL, S_PL
        final_layer = processing.run('native:retainfields',
            {'INPUT': with_score, 'FIELDS': ['id', 'PL', 'S_PL'],
             'OUTPUT': out_path},
            context=context, feedback=feedback, is_child_algorithm=True)['OUTPUT']

        if make_idx:
            self._mk_spatial_index(final_layer, context, feedback)

        return {self.OUTPUT: final_layer}
