# -*- coding: utf-8 -*-

"""
/***************************************************************************
 AMERTA
                                 A QGIS plugin
 Analisis Multi-kriteria Embung dan Rencana Tata Air
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2025-09-18
        copyright            : (C) 2025 by Badan Riset dan Inovasi Nasional
        email                : sitaranisafitri@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'Sitarani Safitri, Orbita Roswintiarti, Okta Fajar Saputra, Galdita Aruba Chulafak, Gatot Nugroho, Wismu Sunarmodo, Kusumaning Ayu Dyah Sukowati, Hana Listi Fitriana'
__date__ = '2025-09-18'
__copyright__ = '(C) 2025 by Badan Riset dan Inovasi Nasional'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

from qgis.core import QgsProcessingProvider
import os
import inspect
from qgis.PyQt.QtGui import QIcon

# RainPCA
from .rainpca_algs.chirpsmean_algorithm import ChirpsMeanAlgorithm
from .rainpca_algs.chirpsannual_algorithm import ChirpsAnnualSumAlgorithm
from .rainpca_algs.chirpspca_algorithm import ChirpsPCAAlgorithm

# Preprocessing
from .preprocess_algs.standarisasipl_algorithm import StandardLCClass
from .preprocess_algs.standarisasijt_algorithm import StandardSoilClass

# MCDA Factors for Retention Ponds
from .preanalysis_algs.griddingtwi_algorithm import GridTwiAlgorithm
from .preanalysis_algs.griddingch_algorithm import GridRainAlgorithm
from .preanalysis_algs.griddingpl_algorithm import GridPLAlgorithm
from .preanalysis_algs.griddingjt_algorithm import GridJTAlgorithm

# MCDA Retention Ponds
from .analysis_algs.amerta_algorithm import AMERTA_MCDAGridAlgorithm


class AMERTAProvider(QgsProcessingProvider):

    def __init__(self):
        """
        Default constructor.
        """
        QgsProcessingProvider.__init__(self)

    def unload(self):
        """
        Unloads the provider. Any tear-down steps required by the provider
        should be implemented here.
        """
        pass

    def loadAlgorithms(self):
        """
        Loads all algorithms belonging to this provider.
        """
        # RainPCA
        self.addAlgorithm(ChirpsMeanAlgorithm())
        self.addAlgorithm(ChirpsAnnualSumAlgorithm())
        self.addAlgorithm(ChirpsPCAAlgorithm())
        
        # Preprocessing
        self.addAlgorithm(StandardLCClass())
        self.addAlgorithm(StandardSoilClass())
        
        # MCDA Factors for Small Reservoirs
        self.addAlgorithm(GridTwiAlgorithm())
        self.addAlgorithm(GridRainAlgorithm())
        self.addAlgorithm(GridPLAlgorithm())
        self.addAlgorithm(GridJTAlgorithm())
        
        # MCDA Retention Ponds
        self.addAlgorithm(AMERTA_MCDAGridAlgorithm())
        # add additional algorithms here
        # self.addAlgorithm(MyOtherAlgorithm())

    def id(self):
        """
        Returns the unique provider id, used for identifying the provider. This
        string should be a unique, short, character only string, eg "qgis" or
        "gdal". This string should not be localised.
        """
        return 'amerta_provider'

    def name(self):
        """
        Returns the provider name, which is used to describe the provider
        within the GUI.

        This string should be short (e.g. "Lastools") and localised.
        """
        return self.tr('AMERTA')

    def icon(self):
        icon_path = os.path.join(os.path.dirname(__file__), 'icon.png')
        print(f"[AMERTAProvider] Loading icon from: {icon_path}")  # Debug print
        if os.path.exists(icon_path):
            return QIcon(icon_path)
        else:
            print("[AMERTAProvider] Icon not found!")
            return super().icon()

    def longName(self):
        """
        Returns the a longer version of the provider name, which can include
        extra details such as version numbers. E.g. "Lastools LIDAR tools
        (version 2.2.1)". This string should be localised. The default
        implementation returns the same string as name().
        """
        return self.name()
