# -*- coding: utf-8 -*-
"""
/***************************************************************************
 AMaps
                                 A QGIS plugin
 Connector for the Azure Maps REST API
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2019-05-16
        git sha              : $Format:%H$
        copyright            : (C) 2019 by Riccardo Klinger
        email                : riccardo.klinger@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from PyQt5.QtCore import QSettings, QTranslator, qVersion, QCoreApplication
from PyQt5.QtGui import QIcon
from PyQt5.QtWidgets import QAction, QListWidgetItem

# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .amaps_dialog import AMapsDialog
import os.path
import json
#import Qgs modules
from qgis.core import QgsApplication
#import processing
from amaps.amapsProvider import amapsProvider


class AMaps:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        self.provider = amapsProvider()
        #self.getCredentials = self.getCredentials()
        self.dlg = AMapsDialog()
        #self.getCredentials = self.getCredentials()
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'AMaps_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)

            if qVersion() > '4.3.3':
                QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&AMaps')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('AMaps', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToWebMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""
        QgsApplication.processingRegistry().addProvider(self.provider)
        icon_path = ':/plugins/amaps/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'Manage your Azure Maps API Credentials'),
            callback=self.run,
            parent=self.iface.mainWindow())
        self.loadCredFunction()


        #QListWidgetItem("Hazel", self.dlg.keylist)
        self.dlg.getCreds.clicked.connect(self.getCredFunction)
        self.dlg.saveCreds.clicked.connect(self.saveCredFunction)
        self.dlg.removeCreds.clicked.connect(self.removeCredFunction)
        #self.dlg.loadCreds.clicked.connect(self.loadCredFunction)
        # will be set False in run()
        #self.first_start = True


    def unload(self):
        QgsApplication.processingRegistry().removeProvider(self.provider)
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginWebMenu(
                self.tr(u'&AMaps'),
                action)
            self.iface.removeToolBarIcon(action)
    def loadCredFunction(self):
        import json, os
        self.dlg.keylist.clear()
        scriptDirectory = os.path.dirname(os.path.realpath(__file__))
        #self.dlg.credentialInteraction.setText("")
        #try:
            #scriptDirectory = os.path.dirname(os.path.realpath(__file__))
        try:
            with open(scriptDirectory + os.sep + 'creds' + os.sep + 'credentials.json') as f:
                try:
                    data = json.load(f)
                    for entry in data["subscriptions"]:
                        #print(entry["key"])
                        #self.dlg.keylist.addItem(QListWidgetItem(entry["key"] + " | " + entry["tier"]))
                        self.dlg.keylist.addItem(str(entry["note"] + " | " + entry["key"] + " | " + entry["tier"]))
                        print("added")
                except:
                    print("something went wrong in loading")
        except:
            print("no file found, creating one")
            with open(scriptDirectory + os.sep + 'creds' + os.sep + 'credentials.json', 'w') as outfile:
                #add new entry:
                items = []
                stringJSON = {"subscriptions": items}
                json.dump(stringJSON, outfile)
            #self.dlg.credentialInteraction.setText("no credits found in. Check for file" + scriptDirectory + os.sep + 'creds' + os.sep + 'credentials.json')
            #self.dlg.geocodeButton.setEnabled(False)

        #items.append({"key": self.dlg.sub_key.text(), "tier":  self.dlg.tier.currentText()})

    def saveCredFunction(self):
        import json
        fileLocation = os.path.dirname(os.path.realpath(__file__))+ os.sep + "creds"
        #get old entries from listwidget:
        items = []
        items.append({"note": self.dlg.sub_note.text(), "key": self.dlg.sub_key.text(), "tier":  self.dlg.tier.currentText()})
        for i in range(self.dlg.keylist.count()):
            items.append({"note":str(self.dlg.keylist.item(i).text()).split(" | ")[0],"key":str(self.dlg.keylist.item(i).text()).split(" | ")[1], "tier":str(self.dlg.keylist.item(i).text()).split(" | ")[2]})
        with open(fileLocation + os.sep + 'credentials.json', 'w') as outfile:
            #add new entry:
            stringJSON = {"subscriptions": items}
            json.dump(stringJSON, outfile)
        self.loadCredFunction()
        #remove entries after saving from input fields:
        self.dlg.sub_note.setText("")
        self.dlg.sub_key.setText("")
        self.dlg.tier.setCurrentIndex(0)
    def removeCredFunction(self):

        fileLocation = os.path.dirname(os.path.realpath(__file__))+ os.sep + "creds"
        items = []
        for i in range(self.dlg.keylist.count()):
            if self.dlg.keylist.item(i).text() != self.dlg.keylist.currentItem().text():
                items.append({"note": str(self.dlg.keylist.item(i).text()).split(" | ")[0], "key":str(self.dlg.keylist.item(i).text()).split(" | ")[1], "tier":str(self.dlg.keylist.item(i).text()).split(" | ")[2]})
            with open(fileLocation + os.sep + 'credentials.json', 'w') as outfile:
                stringJSON = {"subscriptions": items}
                json.dump(stringJSON, outfile)
        self.loadCredFunction()
    def getCredFunction(self):
        import webbrowser
        webbrowser.open('https://azure.microsoft.com/en-us/free/')
        #self.keyString = items
        #self.appCode = self.dlg.AppCode.text()

    def run(self):
        """Run method that performs all the real work"""

        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started
        #if self.first_start == True:
        #    self.first_start = False
        #    self.dlg = AMapsDialog()

        # show the dialog
        self.loadCredFunction()
        self.dlg.show()
        # Run the dialog event loop
        result = self.dlg.exec_()
        # See if OK was pressed
        if result:
            # Do something useful here - delete the line containing pass and
            # substitute with your code.
            pass
