# -*- coding: utf-8 -*-
"""
/***************************************************************************
 AMapExtension
                                 AMap Plugin
 This plugin utilizes the AMap (GaoDe Map) online service to provide navigation, POI queries, and district search.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2025-09-03
        copyright            : (C) 2025 by phoenix-gis
        email                : phoenixgis@sina.com
        website              : phoenix-gis.cn
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication, Qt
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction, QMenu, QToolButton

import os.path

from .main.action_handler_factory import ActionHandlerFactory
from .main.global_helper import GlobalHelper

# Initialize Qt resources from file resources_rc.py
# Extend to load root directory.
import sys
sys.path.append(os.path.dirname(__file__))
from .resources_rc import *

class AMapExtension:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface

        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)

        # initialize locale
        locale = QSettings().value('locale/userLocale')
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'AMapExtension_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        # TODO: We are going to let the user set this up in a future iteration
        self.toolbar = self.iface.addToolBar(GlobalHelper.tr(u'AMapExtension'))
        self.toolbar.setObjectName(u'AMapExtension')
        self.toolbar.setToolTip(GlobalHelper.tr(u'AMapExtension'))

        #print "** INITIALIZING AMapExtension"

        self.pluginIsActive = False
        self.dockwidget = None

        self.basemap_handler = ActionHandlerFactory.create_basemap_handler(self.iface)
        self.options_handler = ActionHandlerFactory.create_options_handler(self.iface)
        self.search_handler = ActionHandlerFactory.create_search_handler(self.iface)
        self.navigation_handler = ActionHandlerFactory.create_navigation_handler(self.iface)

    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        parent_menu=None,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        check_access_key=False,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            if parent_menu is None:
                self.toolbar.addAction(action)
            else:
                parent_menu.addAction(action)

        if add_to_menu:
            if parent_menu is None:
                self.iface.addPluginToMenu(
                    GlobalHelper.tr(u"AMap Extension"),
                    action)
            else:
                parent_menu.addAction(action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""
        self.init_gui_menu()
        self.init_gui_toolbar()

    def init_gui_menu(self):
        icon_path = ':/plugins/amap_extension/image/addlayer.png'
        self.add_action(
            icon_path,
            text=GlobalHelper.tr(u'Add Layer'),
            callback=lambda: self.basemap_handler.handle_action(GlobalHelper.tr("Select Layer")),
            add_to_toolbar=False,
            add_to_menu=True,
            parent=self.iface.mainWindow())

        icon_path = ':/plugins/amap_extension/image/searchpoi.png'
        self.add_action(
            icon_path,
            text=GlobalHelper.tr(u'Search'),
            callback=lambda: self.search_handler.handle_action(""),
            add_to_toolbar=False,
            add_to_menu=True,
            parent=self.iface.mainWindow())

        icon_path = ':/plugins/amap_extension/image/navigate.png'
        self.add_action(
            icon_path,
            text=GlobalHelper.tr(u'Navigate'),
            callback=lambda: self.navigation_handler.handle_action(""),
            add_to_toolbar=False,
            add_to_menu=True,
            parent=self.iface.mainWindow())

        # icon_path = ':/plugins/amap_extension/icon.png'
        # self.add_action(
        #     icon_path,
        #     text=GlobalHelper.tr(u'Convert Coordinate'),
        #     callback=self.handle_convert_coordinate,
        #     add_to_toolbar=False,
        #     add_to_menu=True,
        #     parent=self.iface.mainWindow())

        icon_path = ':/plugins/amap_extension/image/options.png'
        self.add_action(
            icon_path,
            text=GlobalHelper.tr(u'Options'),
            callback=lambda: self.options_handler.handle_action(params=None),
            add_to_toolbar=False,
            add_to_menu=True,
            parent=self.iface.mainWindow())

    def init_gui_toolbar(self):

        add_layer_menu = QMenu(GlobalHelper.tr(u"Add Layer"))

        self.add_action(
            "",
            text=GlobalHelper.tr(u'Satellite Layer'),
            callback=lambda: self.basemap_handler.handle_action(GlobalHelper.tr("Satellite Layer")),
            add_to_toolbar=True,
            add_to_menu=False,
            parent_menu=add_layer_menu,
            parent=self.iface.mainWindow())
        self.add_action(
            "",
            text=GlobalHelper.tr(u'Satellite Label Layer'),
            callback=lambda: self.basemap_handler.handle_action(GlobalHelper.tr("Satellite Label Layer")),
            add_to_toolbar=True,
            add_to_menu=False,
            parent_menu=add_layer_menu,
            parent=self.iface.mainWindow())
        self.add_action(
            "",
            text=GlobalHelper.tr(u'Vector Layer'),
            callback=lambda: self.basemap_handler.handle_action(GlobalHelper.tr("Vector Layer")),
            add_to_toolbar=True,
            add_to_menu=False,
            parent_menu=add_layer_menu,
            parent=self.iface.mainWindow())

        icon_path = ':/plugins/amap_extension/image/addlayer.png'
        add_layer_toolbutton = QToolButton()
        add_layer_toolbutton.setToolButtonStyle(Qt.ToolButtonIconOnly)
        add_layer_toolbutton.setToolTip(GlobalHelper.tr('Add Layer'))
        add_layer_toolbutton.setPopupMode(QToolButton.MenuButtonPopup)
        add_layer_toolbutton.setText(GlobalHelper.tr('Add Layer'))
        add_layer_toolbutton.setIcon(QIcon(icon_path))

        add_layer_toolbutton.setMenu(add_layer_menu)
        self.toolbar.addWidget(add_layer_toolbutton)

        icon_path = ':/plugins/amap_extension/image/searchpoi.png'
        self.add_action(
            icon_path,
            text=GlobalHelper.tr(u'Search'),
            callback=lambda: self.search_handler.handle_action(""),
            add_to_toolbar=True,
            add_to_menu=False,
            parent=self.iface.mainWindow())

        icon_path = ':/plugins/amap_extension/image/navigate.png'
        self.add_action(
            icon_path,
            text=GlobalHelper.tr(u'Navigate'),
            callback=lambda: self.navigation_handler.handle_action(""),
            add_to_toolbar=True,
            add_to_menu=False,
            parent=self.iface.mainWindow())

        # icon_path = ':/plugins/amap_extension/icon.png'
        # self.add_action(
        #     icon_path,
        #     text=GlobalHelper.tr(u'Convert Coordinate'),
        #     callback=self.handle_convert_coordinate,
        #     add_to_toolbar=True,
        #     add_to_menu=False,
        #     parent=self.iface.mainWindow())

        icon_path = ':/plugins/amap_extension/image/options.png'
        self.add_action(
            icon_path,
            text=GlobalHelper.tr(u'Options'),
            callback=lambda: self.options_handler.handle_action(params=None),
            add_to_toolbar=True,
            add_to_menu=False,
            parent=self.iface.mainWindow())


    def onClosePlugin(self):
        """Cleanup necessary items here when plugin dockwidget is closed"""

        #print "** CLOSING AMapExtension"

        # disconnects
        self.dockwidget.closingPlugin.disconnect(self.onClosePlugin)

        # remove this statement if dockwidget is to remain
        # for reuse if plugin is reopened
        # Commented next statement since it causes QGIS crashe
        # when closing the docked window:
        # self.dockwidget = None

        self.pluginIsActive = False


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                GlobalHelper.tr(u'AMap Extension'),
                action)
            self.iface.removeToolBarIcon(action)
        # remove the toolbar
        del self.toolbar

        self.basemap_handler.unload()
        self.options_handler.unload()
        self.search_handler.unload()
        self.navigation_handler.unload()

    def handle_navigate(self):
        pass

    def handle_convert_coordinate(self):
        pass

