# -*- coding: utf-8 -*-
"""
/***************************************************************************
 LidarDownloader
                                 A QGIS plugin
 This plugin providess access to lidar data.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2021-12-19
        git sha              : $Format:%H$
        copyright            : (C) 2021 by Matjaž Mori
        email                : matjaz.mori@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.PyQt.QtCore import *
from qgis.PyQt.QtGui import *
from qgis.PyQt.QtWidgets import QAction, QMenu
from PyQt5.QtGui import *
from PyQt5.QtCore import *
from qgis.core import (QgsLayerDefinition)
from .countries import *

import os.path
from pathlib import Path


class LidarDownloader:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)

        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'LidarDownloader_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&ALS Downloader')
        self.LD_Menu = QMenu(self.menu)


        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('LidarDownloader', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=False,
        status_tip=None,
        whats_this=None,
        parent=None):
   
        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToWebMenu(
                self.menu,
                action)

        self.actions.append(action)
        
        return action

    def initGui(self):
        """
        icon_path = str(Path(self.plugin_dir)/'icons/flag_it.png')
        self.add_action(
            icon_path,
            text=self.tr(u'Italy - Campania'),
            callback=self.it_campania_lidar_download,
            parent=self.iface.mainWindow())
        """
        icon_path = str(Path(self.plugin_dir)/'icons/flag_nl.png')
        self.add_action(
            icon_path,
            text=self.tr(u'Netherlands'),
            callback=self.nl_lidar_download,
            parent=self.iface.mainWindow())

        icon_path = str(Path(self.plugin_dir)/'icons/flag_si.png')
        self.add_action(
            icon_path,
            text=self.tr(u'Slovenia'),
            callback=self.si_lidar_download,
            parent=self.iface.mainWindow())

      

    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginWebMenu(
                self.tr(u'&ALS Downloader'),
                action)
     


    def it_campania_lidar_download(self):
        """Run method that performs all the real work"""
        """
        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started
        if self.first_start == True:
            self.first_start = False
            #self.dlg = LidarDownloaderDialog()

        # show the dialog
        #self.dlg.show()
        # Run the dialog event loop
        #result = self.dlg.exec_()
        # See if OK was pressed
        if result:
            # Do something useful here - delete the line containing pass and
            # substitute with your code.
            pass
        """
    def nl_load_AHN3(self): 
        self.w.close()
        self.iface.messageBar().pushMessage(self.tr("Loading fishnet layer"), duration=5) 
        src = Path(os.path.dirname(__file__))/'fishnets\\Nl_kaartbladen AHN3.qlr'
        vlayer = QgsLayerDefinition().loadLayerDefinitionLayers(str(src))
        QgsProject.instance().addMapLayers(vlayer)

    def nl_load_AHN4(self): 
        self.w.close()
        self.iface.messageBar().pushMessage(self.tr("Loading fishnet layer"), duration=5) 
        src = Path(os.path.dirname(__file__))/'fishnets\\Nl_kaartbladen AHN4.qlr'
        vlayer = QgsLayerDefinition().loadLayerDefinitionLayers(str(src))
        QgsProject.instance().addMapLayers(vlayer)

    def nl_lidar_download(self):
        w = nl_dialog(self)
        w.show()


    def si_load_fishnet(self): 
        self.w.close()
        self.iface.messageBar().pushMessage(self.tr("Loading fishnet layer"), duration=5) 
        src = Path(os.path.dirname(__file__))/'fishnets\SI_LIDAR FISHNET D96.gpkg'
        try:
            tmp = tempfile.mkdtemp()
            dest = Path(tmp)/'SI_LIDAR FISHNET D96.gpkg'
            shutil.copyfile(str(src), str(dest))
            src = str(dest)
        except:
            pass 
        layer = str(src)
        vlayer = QgsVectorLayer(layer, "SI_LIDAR FISHNET D96", "ogr")
        vlayer.setReadOnly()
        QgsProject.instance().addMapLayer(vlayer)

    def si_lidar_download(self):
        w = si_dialog(self)
        w.show()
    

        

        
