# -*- coding: utf-8 -*-

"""
/***************************************************************************
 ALKIS_Objektarten
                                 A QGIS plugin
 Das Plugin hilft bei Aufbereitung von ALKIS Daten 
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2023-06-15
        copyright            : (C) 2023 by Sajjad Tabatabaei
        email                : sajjadtabatabaei05@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'Sajjad Tabatabaei'
__date__ = '2023-06-15'
__copyright__ = '(C) 2023 by Sajjad Tabatabaei'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'
from qgis.core import QgsProcessing
from qgis.core import QgsProcessingAlgorithm
from qgis.core import QgsProcessingMultiStepFeedback
from qgis.core import QgsProcessingParameterVectorLayer
from qgis.core import QgsProcessingParameterFeatureSink
from qgis.core import QgsProcessingParameterNumber
from qgis.core import QgsProcessingParameterDefinition
from qgis.core import QgsProcessingParameterField
import processing
from qgis.PyQt.QtCore import QCoreApplication
from qgis.core import (QgsProcessing,
                       QgsFeatureSink,
                       QgsProcessingAlgorithm,
                       QgsProcessingParameterFeatureSource,
                       QgsProcessingParameterFeatureSink)













class ALKIS_GebaeudeAlgorithm(QgsProcessingAlgorithm):

    def initAlgorithm(self, config=None):
        self.addParameter(QgsProcessingParameterFeatureSink('Gebaeude', 'Gebaeude', type=QgsProcessing.TypeVectorAnyGeometry, createByDefault=True, defaultValue=None))
        self.addParameter(QgsProcessingParameterVectorLayer('GebaeudeBauwerk', 'GebaeudeBauwerk', types=[QgsProcessing.TypeVectorPolygon], defaultValue=None))

    def processAlgorithm(self, parameters, context, model_feedback):
        # Use a multi-step feedback, so that individual child algorithm progress reports are adjusted for the
        # overall progress through the model
        feedback = QgsProcessingMultiStepFeedback(2, model_feedback)
        results = {}
        outputs = {}

        # Feldrechner
        alg_params = {
            'FIELD_LENGTH': 10,
            'FIELD_NAME': 'Fläche',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 1,
            'FORMULA': ' $area ',
            'INPUT': parameters['GebaeudeBauwerk'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Feldrechner'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(1)
        if feedback.isCanceled():
            return {}

        # Nach Ausdruck extrahieren
        # redundante Gebäude entfernen
        alg_params = {
            'EXPRESSION': '\"gebnutzbez\" != \'Bauteil\'',
            'INPUT': outputs['Feldrechner']['OUTPUT'],
            'OUTPUT': parameters['Gebaeude']
        }
        outputs['NachAusdruckExtrahieren'] = processing.run('native:extractbyexpression', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        results['Gebaeude'] = outputs['NachAusdruckExtrahieren']['OUTPUT']
        return results

    def name(self):
        return 'Redundante Gebäude eliminieren'
    def displayName(self):
        return 'Redundante Gebäude eliminieren'
    def group(self):
        return 'Gebäude'
    def groupId(self):
        return 'Gebäude'
    def createInstance(self):
        return ALKIS_GebaeudeAlgorithm()

    
class oberirdischeGebaeudeAlgorithm(QgsProcessingAlgorithm):



    def initAlgorithm(self, config=None):
        self.addParameter(QgsProcessingParameterVectorLayer('gebaeudebauwerke', 'GebaeudeBauwerke', types=[QgsProcessing.TypeVectorPolygon], defaultValue=None))
        self.addParameter(QgsProcessingParameterFeatureSink('GebaeudebauwerkeOberirdisch', 'GebaeudeBauwerke (oberirdisch)', type=QgsProcessing.TypeVectorAnyGeometry, createByDefault=False, defaultValue=None))
        self.addParameter(QgsProcessingParameterFeatureSink('GebaeudebauwerkeUnterirdisch', 'GebaeudeBauwerke (unterirdisch)', type=QgsProcessing.TypeVectorAnyGeometry, createByDefault=True, defaultValue='TEMPORARY_OUTPUT'))

    def processAlgorithm(self, parameters, context, model_feedback):
        # Use a multi-step feedback, so that individual child algorithm progress reports are adjusted for the
        # overall progress through the model
        feedback = QgsProcessingMultiStepFeedback(1, model_feedback)
        results = {}
        outputs = {}

        # Nach Attribut extrahieren
        alg_params = {
            'FIELD': 'rellage',
            'INPUT': parameters['gebaeudebauwerke'],
            'OPERATOR': 0,
            'VALUE': 'Unter der Erdoberfläche',
            'FAIL_OUTPUT': parameters['GebaeudebauwerkeOberirdisch'],
            'OUTPUT': parameters['GebaeudebauwerkeUnterirdisch']
        }
        outputs['NachAttributExtrahieren'] = processing.run('native:extractbyattribute', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        results['GebaeudebauwerkeOberirdisch'] = outputs['NachAttributExtrahieren']['FAIL_OUTPUT']
        results['GebaeudebauwerkeUnterirdisch'] = outputs['NachAttributExtrahieren']['OUTPUT']
        return results


    def name(self):
        return 'Gebäude auf der Erdoberfläche'
    def displayName(self):
        return 'Gebäude auf der Erdoberfläche'
    def group(self):
        return 'Gebäude'
    def groupId(self):
        return 'Gebäude'
    def createInstance(self):
        return oberirdischeGebaeudeAlgorithm()

class DachueberstandAlgorithm(QgsProcessingAlgorithm):

    def initAlgorithm(self, config=None):
        self.addParameter(QgsProcessingParameterVectorLayer('gebaeude', 'Gebaeude', types=[QgsProcessing.TypeVectorPolygon], defaultValue=None))
        param = QgsProcessingParameterNumber('dachberstand_in_m', 'Dachüberstand (in m)', type=QgsProcessingParameterNumber.Integer, minValue=0, maxValue=10, defaultValue=0.5)
        param.setFlags(param.flags() | QgsProcessingParameterDefinition.FlagAdvanced)
        self.addParameter(param)
        self.addParameter(QgsProcessingParameterFeatureSink('GebaeudeMitDachberstand', 'Gebaeude mit Dachüberstand', type=QgsProcessing.TypeVectorAnyGeometry, createByDefault=True, supportsAppend=True, defaultValue=None))

    def processAlgorithm(self, parameters, context, model_feedback):
        # Use a multi-step feedback, so that individual child algorithm progress reports are adjusted for the
        # overall progress through the model
        feedback = QgsProcessingMultiStepFeedback(2, model_feedback)
        results = {}
        outputs = {}

        # Puffer
        alg_params = {
            'DISSOLVE': False,
            'DISTANCE': parameters['dachberstand_in_m'],
            'END_CAP_STYLE': 1,
            'INPUT': parameters['gebaeude'],
            'JOIN_STYLE': 1,
            'MITER_LIMIT': 2,
            'SEGMENTS': 5,
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Puffer'] = processing.run('native:buffer', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(1)
        if feedback.isCanceled():
            return {}

        # Feldrechner
        alg_params = {
            'FIELD_LENGTH': 10,
            'FIELD_NAME': 'FlächeDach',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 1,
            'FORMULA': '$area',
            'INPUT': outputs['Puffer']['OUTPUT'],
            'OUTPUT': parameters['GebaeudeMitDachberstand']
        }
        outputs['Feldrechner'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        results['GebaeudeMitDachberstand'] = outputs['Feldrechner']['OUTPUT']
        return results


    def name(self):
        return 'Dachüberstand berechnen'
    def displayName(self):
        return 'Dachüberstand berechnen'
    def group(self):
        return 'Gebäude'
    def groupId(self):
        return 'Gebäude'
    def createInstance(self):
        return DachueberstandAlgorithm()
    

class ALKIS_ObjektartenAlgorithm(QgsProcessingAlgorithm):

    def initAlgorithm(self, config=None):
        self.addParameter(QgsProcessingParameterVectorLayer('Nutzung', 'Nutzung', types=[QgsProcessing.TypeVectorPolygon], defaultValue=None))
        self.addParameter(QgsProcessingParameterFeatureSink('NutzungObjgruppe', 'Nutzung OBJGRUPPE', type=QgsProcessing.TypeVectorAnyGeometry, createByDefault=True, supportsAppend=True, defaultValue=None))
        self.addParameter(QgsProcessingParameterField('Felder', 'Feld auswählen', type=QgsProcessingParameterField.Any, parentLayerParameterName='Nutzung', allowMultiple=False, defaultValue='nutzart'))

    def processAlgorithm(self, parameters, context, model_feedback):
        # Use a multi-step feedback, so that individual child algorithm progress reports are adjusted for the
        # overall progress through the model
        feedback = QgsProcessingMultiStepFeedback(1, model_feedback)
        results = {}
        outputs = {}

        # Feldrechner
        alg_params = {
            'FIELD_LENGTH': 50,
            'FIELD_NAME': 'OBJGRUPPE',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 2,
            'FORMULA': 'CASE\n\tWHEN  \"nutzart\" =  \'Bahnverkehr\' or  \"nutzart\" = \'Flugverkehr\' or \"nutzart\" =  \'Platz\' or \"nutzart\" =  \'Schiffsverkehr\'  or \"nutzart\" =  \'Straßenverkehr\'  or \"nutzart\" =  \'Weg\' THEN \'Verkehr\'\n\tWHEN \"nutzart\" =  \'Gehölz\'  or \"nutzart\" =  \'Landwirtschaft\' or \"nutzart\" =  \'Unland/Vegetationslose Fläche\' or \"nutzart\" =  \'Wald\' or \"nutzart\" =  \'Heide\'  THEN \'Vegetation\'\n\tWHEN \"nutzart\" =  \'Fließgewässer\'  or \"nutzart\" = \'Hafenbecken\' or \"nutzart\" =  \'Stehendes Gewässer\' or \"nutzart\" =  \'Sumpf\'  THEN \'Gewaesser\'\n\tWHEN \"nutzart\" =  \'Fläche besonderer funktionaler Prägung\' or \"nutzart\" =  \'Fläche gemischter Nutzung\' or \"nutzart\" = \'Friedhof\' or \"nutzart\" =  \'Halde\' or \"nutzart\" =  \'Industrie- und Gewerbefläche\' or \"nutzart\" =  \'Sport-, Freizeit- und Erholungsfläche\' or \"nutzart\" =  \'Wohnbaufläche\' or \"nutzart\" =  \'Tagebau, Grube, Steinbruch\'  THEN \'Siedlung\'\n\tELSE \'\'\nEND ',
            'INPUT': parameters['Nutzung'],
            'OUTPUT': parameters['NutzungObjgruppe']
        }
        outputs['Feldrechner'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        results['NutzungObjgruppe'] = outputs['Feldrechner']['OUTPUT']
        return results

    def name(self):
        return 'Objektartengruppen erstellen'
    def displayName(self):
        return 'Objektartengruppen erstellen'
    def group(self):
        return 'Nutzung'
    def groupId(self):
        return 'Nutzung'
    def createInstance(self):
        return ALKIS_ObjektartenAlgorithm()
