# -*- coding: utf-8 -*-

"""
/***************************************************************************
 ALKIS_Objektarten
                                 A QGIS plugin
 Das Plugin hilft bei Aufbereitung von ALKIS Daten 
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2023-06-15
        copyright            : (C) 2023 by Sajjad Tabatabaei
        email                : sajjadtabatabaei05@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'Sajjad Tabatabaei'
__date__ = '2023-06-15'
__copyright__ = '(C) 2023 by Sajjad Tabatabaei'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

from qgis.core import QgsProcessingProvider
from .ALKIS_modul_algorithm import (ALKIS_ObjektartenAlgorithm,ALKIS_GebaeudeAlgorithm, oberirdischeGebaeudeAlgorithm, DachueberstandAlgorithm)
import os
import sys
pluginPath = os.path.dirname(__file__)
sys.path.append(os.path.join(pluginPath, "main"))
sys.path.append(os.path.join(pluginPath, "sub"))
from qgis.PyQt.QtGui import QIcon

class ALKIS_ObjektartenProvider(QgsProcessingProvider):

    def __init__(self):
        """
        Default constructor.
        """
        QgsProcessingProvider.__init__(self)

    def unload(self):
        """
        Unloads the provider. Any tear-down steps required by the provider
        should be implemented here.
        """
        pass

    def loadAlgorithms(self):
        self.addAlgorithm(ALKIS_ObjektartenAlgorithm())
        self.addAlgorithm(ALKIS_GebaeudeAlgorithm())
        self.addAlgorithm(oberirdischeGebaeudeAlgorithm())
        self.addAlgorithm(DachueberstandAlgorithm())


        # add additional algorithms here
        # self.addAlgorithm(MyOtherAlgorithm())

    def id(self):
        """
        Returns the unique provider id, used for identifying the provider. This
        string should be a unique, short, character only string, eg "qgis" or
        "gdal". This string should not be localised.
        """
        return 'ALKIS_provider'

    def name(self):
        """
        Returns the provider name, which is used to describe the provider
        within the GUI.

        This string should be short (e.g. "Lastools") and localised.
        """
        return self.tr('ALKIS Plugin')

    def icon(self):
        """
        Should return a QIcon which is used for your provider inside
        the Processing toolbox.
        """
        return QIcon(os.path.join(pluginPath, "icons", "icon.png"))

    def longName(self):
        """
        Returns the a longer version of the provider name, which can include
        extra details such as version numbers. E.g. "Lastools LIDAR tools
        (version 2.2.1)". This string should be localised. The default
        implementation returns the same string as name().
        """
        return self.name()
