# Advanced Map Downloader

A QGIS plugin for downloading georeferenced maps with multiple coordinate input types, canvas drawing tools, and various export formats.

**Part of MAS Raster Processing tools.**

## How to Use

### Quick Start
1. **Open the plugin**: Click the icon in **MAS Raster Processing** toolbar, or go to **Raster** → **MAS Raster Processing** → **Advanced Map Downloader**

2. **Select coordinate input type** from the dropdown:
   - **Lat-Long with Pixels** (default)
   - **XYZ Tile**
   - **Square Grid**
   - **WKT**, **WKB**, or **GeoJSON**

3. **Enter coordinates** using one of these methods:
   - Type coordinates manually in the input fields
   - Click **"Draw from Canvas"**: 
     - For Lat-Long/Square Grid: Click on map to capture center point
     - For other modes: Draw a rectangle on the map
   - Click **"Use Canvas Extent"**: Captures current map view

4. **Set resolution**: Adjust GSD (Ground Sampling Distance) in meters/pixel

5. **Select layer**: Choose the layer to download from the dropdown

6. **Choose export format**:
   - GeoTIFF (.tif) - **Default, recommended**
   - PNG + World File (.png + .pgw)
   - JPEG + World File (.jpg + .jgw)
   - BMP + World File (.bmp + .bpw)

7. **Set output path**: Click "Browse..." to select where to save

8. **Click OK** to download!

### Tips
- The **blue rubber band** on the canvas shows the download area preview
- Enable **"Load exported image as layer"** to automatically add the result to QGIS
- The rubber band is automatically cleared when you close the dialog or complete download

## Features

### Coordinate Input Types
| Type                 | Description                     | "Draw from Canvas" Behavior |
| -------------------- | ------------------------------- | --------------------------- |
| Lat-Long with Pixels | Center point + dimensions + GSD | Click to capture point      |
| XYZ Tile             | Web mapping tile (Z, X, Y)      | Draw rectangle              |
| Square Grid          | Center + size (m/km/miles/nm)   | Click to capture point      |
| WKT                  | Well-Known Text geometry        | Draw rectangle              |
| WKB                  | Well-Known Binary (hex)         | Draw rectangle              |
| GeoJSON              | JSON geometry                   | Draw rectangle              |

### Export Formats
All formats are **georeferenced**:
- **GeoTIFF (.tif)** - Full geospatial metadata via GDAL
- **PNG + World File** - .png with .pgw
- **JPEG + World File** - .jpg with .jgw
- **BMP + World File** - .bmp with .bpw

## Installation

1. Copy the `advanced_map_downloader` folder to your QGIS plugins directory:
   - **Windows**: `%APPDATA%\QGIS\QGIS3\profiles\default\python\plugins\`
   - **Linux**: `~/.local/share/QGIS/QGIS3/profiles/default/python/plugins/`
   - **macOS**: `~/Library/Application Support/QGIS/QGIS3/profiles/default/python/plugins/`

2. Enable the plugin:
   - Go to **Plugins** → **Manage and Install Plugins**
   - Find **Advanced Map Downloader** and enable it

## Author

**Mirjan Ali Sha**  
📧 Email: mastools.help@gmail.com  
🔗 Repository: https://github.com/Mirjan-Ali-Sha/advanced_map_downloader

## License

MIT License - see LICENSE file for details.
