# -*- coding: utf-8 -*-
"""
/***************************************************************************
 OS_search_for_addresses
                                 A QGIS plugin
 Search for addresses if you have an OS API Key
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2021-02-04
        git sha              : $Format:%H$
        copyright            : (C) 2021 by Paul Withington
        email                : pwithy@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction
from qgis.PyQt import QtWidgets
import urllib
import urllib.request
import json
from qgis.utils import iface
from qgis.core import *
from math import log, tan, radians, cos, pi, floor, degrees, atan, sinh
from qgis.core import QgsCoordinateReferenceSystem
from qgis.core import QgsSettings
from qgis.gui import QgsVertexMarker

# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .addresssearch_dialog import OS_search_for_addressesDialog
import os.path



class OS_search_for_addresses:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'OS_search_for_addresses_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&OS search for addresses')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('OS_search_for_addresses', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/addresssearch/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'OS address search'),
            callback=self.run,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.first_start = True


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&OS search for addresses'),
                action)
            self.iface.removeToolBarIcon(action)

    def getadd(self):
       if self.dlg.APIKEY.text() == '':
        self.iface.messageBar().pushMessage(
         "Please enter OS API key",
         level=Qgis.Success, duration=7)
       elif self.dlg.APIKEY.text() != '':
        self.dlg.comboBoxadd.clear()
        query = str(self.dlg.sadd.text()+', '+self.dlg.spostcode.text())
        enquery = urllib.parse.quote(query)
        apikey = self.dlg.APIKEY.text()
        PlaceURL = 'https://api.os.uk/search/places/v1/find?dataset=DPA&key='+apikey+'&output_srs=EPSG%3A4326&minmatch=0.6&query='+enquery
        json_response = urllib.request.urlopen(PlaceURL)
        rawresponse = json_response.read().decode('utf-8')
        jload = json.loads(rawresponse.replace("\'",''))
        global addtable
        addtable= {"UPRN": [],"ADDRESS": [],"LNG": [],"LAT": []}
        addtable['UPRN'] = [results['DPA']['UPRN'] for results in jload['results']]
        addtable['ADDRESS'] = [results['DPA']['ADDRESS'] for results in jload['results']]
        addtable['LNG'] = [results['DPA']['LNG'] for results in jload['results']]
        addtable['LAT'] = [results['DPA']['LAT'] for results in jload['results']]
        self.dlg.comboBoxadd.addItems(addtable['ADDRESS'])

    def serpostcode(self):
      if self.dlg.APIKEY.text() == '':
       self.iface.messageBar().pushMessage(
        "Please enter OS API key",
        level=Qgis.Success, duration=7)
      elif self.dlg.APIKEY.text() != '':
       if len(self.dlg.spostcode.text()) <= 2:
        self.iface.messageBar().pushMessage(
         "Enter more of the postcode",
         level=Qgis.Success, duration=7)
       elif len(self.dlg.spostcode.text()) >= 3:
        self.dlg.comboBoxadd.clear()
        query = str(self.dlg.spostcode.text())
        enquery = urllib.parse.quote(query)
        apikey = self.dlg.APIKEY.text()
        PlaceURL = 'https://api.os.uk/search/places/v1/postcode?postcode='+enquery+'&key='+apikey+'&output_srs=EPSG%3A4326'
        json_response = urllib.request.urlopen(PlaceURL)
        rawresponse = json_response.read().decode('utf-8')
        jload = json.loads(rawresponse.replace("\'",''))
        global addtable
        addtable= {"UPRN": [],"ADDRESS": [],"LNG": [],"LAT": []}
        addtable['UPRN'] = [results['DPA']['UPRN'] for results in jload['results']]
        addtable['ADDRESS'] = [results['DPA']['ADDRESS'] for results in jload['results']]
        addtable['LNG'] = [results['DPA']['LNG'] for results in jload['results']]
        addtable['LAT'] = [results['DPA']['LAT'] for results in jload['results']]
        self.dlg.comboBoxadd.addItems(addtable['ADDRESS'])
        


    def where(self):
       if self.dlg.APIKEY.text() == '':
        self.iface.messageBar().pushMessage(
         "Please enter OS API key",
         level=Qgis.Success, duration=7)
       elif self.dlg.APIKEY.text() != '':
        canvas = iface.mapCanvas()
        crsSrc = QgsCoordinateReferenceSystem("EPSG:4326")
        crsDest = QgsCoordinateReferenceSystem(iface.mapCanvas().mapSettings().destinationCrs().authid())
        transformContext = QgsProject.instance().transformContext()
        xform = QgsCoordinateTransform(crsSrc, crsDest, transformContext)
        min = xform.transform(QgsPointXY(addtable['LNG'][self.dlg.comboBoxadd.currentIndex()],addtable['LAT'][self.dlg.comboBoxadd.currentIndex()]))
        x, y  = min
        #print(x)
        #y = addtable['LAT'][self.dlg.comboBoxadd.currentIndex()]
        #print(y)
        scale = 300
        rect = QgsRectangle(float(x) - scale, float(y) - scale, float(x) + scale, float(y) + scale)
        vertex_items = [ i for i in canvas.scene().items() if issubclass(type(i), QgsVertexMarker)]
        for ver in vertex_items:
            if ver in canvas.scene().items():
             canvas.scene().removeItem(ver)
        canvas.setExtent(rect)
        marker = QgsVertexMarker(canvas)
        marker.setIconSize(15)
        marker.setPenWidth(2)
        marker.setCenter(QgsPointXY(int(x), int(y)))
        canvas.refresh()

    def clearm(self):
        canvas = iface.mapCanvas()
        vertex_items = [ i for i in canvas.scene().items() if issubclass(type(i), QgsVertexMarker)]
        for ver in vertex_items:
            if ver in canvas.scene().items():
             canvas.scene().removeItem(ver)
        canvas.refresh()

    def getalladd(self):
       if self.dlg.APIKEY.text() == '':
        self.iface.messageBar().pushMessage(
         "Please enter OS API key",
         level=Qgis.Success, duration=7)
       elif self.dlg.APIKEY.text() != '':
        apikey = self.dlg.APIKEY.text()
        crsSrc = QgsCoordinateReferenceSystem(iface.mapCanvas().mapSettings().destinationCrs().authid())
        crsDest = QgsCoordinateReferenceSystem("EPSG:4326")
        transformContext = QgsProject.instance().transformContext()
        xform = QgsCoordinateTransform(crsSrc, crsDest, transformContext)
        min = xform.transform(QgsPointXY(iface.mapCanvas().extent().xMinimum(),iface.mapCanvas().extent().yMinimum()))
        max = xform.transform(QgsPointXY(iface.mapCanvas().extent().xMaximum(),iface.mapCanvas().extent().yMaximum()))
        mix, miy = min
        mx, may = max
        box=str(miy)+','+str(mix)+','+str(may)+','+str(mx)
        PlaceURL = 'https://api.os.uk/search/places/v1/bbox?key='+apikey+'&bbox='+box+'&dataset=DPA&offset=0&output_srs=EPSG:4326&srs=EPSG:4326'
        json_response = urllib.request.urlopen(PlaceURL)
        rawresponse = json_response.read().decode('utf-8')
        jload = json.loads(rawresponse.replace("\'",''))
        gej = {"type": "FeatureCollection","features": []}
        for r in jload['results']:
         item = {"type": "Feature","properties": [],"geometry": {"type": "Point", "coordinates": []}}
         item['properties'] = r['DPA']
         item['geometry']['coordinates'] = ([r['DPA']['LNG'], r['DPA']['LAT']])
         gej['features'].append(item)
        
        for feature in gej['features']:
         del feature['properties']['BLPU_STATE_CODE']
        
        ercorrect = str(gej).replace("'",'"')
        vlayer = QgsVectorLayer(ercorrect, "oslayer", "ogr")
        QgsProject.instance().addMapLayer(vlayer)

    def storekey(self):
        s = QgsSettings()
        s.setValue("addresssearch/apikey", self.dlg.APIKEY.text())


    def readkey(self):
        s = QgsSettings()
        loadkey = s.value("addresssearch/apikey", "default text")
        self.dlg.APIKEY.setText(loadkey)


    def run(self):
        """Run method that performs all the real work"""

        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started
        if self.first_start == True:
            self.first_start = False
            self.dlg = OS_search_for_addressesDialog()
            self.dlg.pushButtongetadd.clicked.connect(self.getadd)
            self.dlg.zoomad.clicked.connect(self.where)
            self.dlg.clearm.clicked.connect(self.clearm)
            self.dlg.getalladd.clicked.connect(self.getalladd)
            self.dlg.savekey.clicked.connect(self.storekey)
            self.dlg.loadkey.clicked.connect(self.readkey)
            self.dlg.serpostcode.clicked.connect(self.serpostcode)


        # show the dialog
        self.dlg.show()
        # Run the dialog event loop
        result = self.dlg.exec_()
        # See if OK was pressed
        if result:
            # Do something useful here - delete the line containing pass and
            # substitute with your code.
            pass
