# -*- coding: utf-8 -*-
"""
/***************************************************************************
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2022-11-28
        git sha              : $Format:%H$
        copyright            : (C) 2023 by Thomas Knäuper
        email                : thomas.knaeuper@stud.hs-bochum.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
# import librarys
import os
import sqlite3
import pandas as pd
import numpy as np

from PyQt5.QtWidgets import QApplication, QFileDialog, QLineEdit, QLabel, QProgressBar, QWidget, QPushButton, QAction, QCheckBox, QDockWidget, QHeaderView, QMenu, QMessageBox, QToolButton, QTableWidget, QTableWidgetItem, QAbstractItemView, QTabWidget
from PyQt5.QtCore import Qt, QSettings, QTranslator, QCoreApplication, QVariant, pyqtSignal, QFile, QUrl, QFileInfo
from PyQt5.QtGui import QIcon, QFont, QDesktopServices, QPalette, QColor
from qgis.core import QgsCoordinateReferenceSystem, QgsCoordinateTransform, QgsProject, QgsPointXY, QgsVectorLayer, QgsField, QgsMarkerSymbol, QgsGeometry, QgsFeature, QgsPalLayerSettings, QgsVectorLayerSimpleLabeling, QgsSvgMarkerSymbolLayer, QgsTextBufferSettings, QgsTextFormat, QgsPalLayerSettings

# Initialize Qt resources from file resources.py
from .resources import *

# Import the code for the DockWidget
from .address_search_dockwidget import Address_searchDockWidget
import os.path

class Address_search:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface

        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        self.datadir = self.plugin_dir + "/data"
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'Address_search_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&Adresssuche')
        self.toolbar = self.iface.addToolBar(u'Address_search')
        self.toolbar.setObjectName(u'Address_search')

        self.pluginIsActive = False
        self.dockwidget = None
        self.layerid = ''
        self.layer = None

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('Address_search', message)

    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            self.toolbar.addAction(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/address_search/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'Adresssuche'),
            callback=self.run,
            parent=self.iface.mainWindow())

        if self.dockwidget is None:
            self.dockwidget=Address_searchDockWidget()

        # button click events
        self.dockwidget.btn_selectData.clicked.connect(self.selectFile)
        self.dockwidget.btn_zoom.clicked.connect(self.zoomTo)
        self.dockwidget.adrWidget.doubleClicked.connect(self.zoomTo)
        self.dockwidget.btn_search.clicked.connect(lambda: self.searchAddress())

        # other events
        self.dockwidget.txt_search.textChanged.connect(lambda: self.searchAddress('LIMIT 15'))
        self.dockwidget.txt_search.returnPressed.connect(lambda: self.searchAddress())
        self.dockwidget.cb_tmpLayer.stateChanged.connect(self.cb_Checked)

        #columns in tableWidget
        self.columnName(0,"ID")
        self.columnName(1,"Adresse")
        self.dockwidget.adrWidget.setColumnHidden(0, True)

    def onClosePlugin(self):
        """Cleanup necessary items here when plugin dockwidget is closed"""

        # disconnects
        self.dockwidget.closingPlugin.disconnect(self.onClosePlugin)

        self.pluginIsActive = False

    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""

        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&Adresssuche'),
                action)
            self.iface.removeToolBarIcon(action)
        # remove the toolbar
        del self.toolbar

    # link to webpage
    def link(self, linkStr):

        QDesktopServices.openUrl(QUrl(linkStr))

    #proof if db exists
    def dbExists(self):

        # Loop through data directory
        for file in os.listdir(self.datadir):
            if file == "Adressen.db":
                self.dockwidget.lbl_isLoaded.setText("Daten wurden eingeladen!")
                self.dockwidget.lbl_isLoaded.setFont(QFont("MS Shell Dlg 2", 11.5, QFont.Bold))
                self.dockwidget.tabWidget.setTabEnabled(1, True)
                self.dockwidget.tabWidget.setCurrentIndex(1)
                break
            else:
                self.dockwidget.tabWidget.setTabEnabled(1, False)
                self.dockwidget.lbl_isLoaded.setText("Bitte laden Sie zunächst\r\neinen Datensatz ein!")
                self.dockwidget.lbl_isLoaded.setAlignment(QtCore.Qt.AlignCenter)
                self.dockwidget.lbl_isLoaded.setFont(QFont("MS Shell Dlg 2", 9.5))
            
        # text to textlabel
        self.dockwidget.lbl_Info.linkActivated.connect(self.link)
        self.dockwidget.lbl_Info.setText('<p>Die auszuwählenden Daten müssen im<br>Hauskoordinaten Datenformat vorliegen.<br />Weitere Informationen dazu finden Sie <a href="https://www.adv-online.de/AdV-Produkte/Standards-und-Produktblaetter/ZSHH/"><span style=" font-size:9.5pt; text-decoration: underline; color:#0000ff;">hier</span></a>. </p>')

        self.dockwidget.lbl_Info.setFont(QFont("MS Shell Dlg 2", 9.5))

    # check state of comboboxes
    def cb_Checked(self):

        cbTmp = self.dockwidget.cb_tmpLayer.isChecked()

        # second cbbox can only checked, if the first is checked
        if  cbTmp == True:
            cb_nLayer = True
        elif cbTmp == False:
            cb_nLayer = False

        self.dockwidget.cb_newLayer.setEnabled(cb_nLayer)

        return cbTmp
    
    # select file with address points
    def selectFile(self):

        src_path = QFileDialog.getOpenFileName(self.dockwidget, "Datei auswählen", "", "Textdateien (*.csv *.txt)")

        if src_path == ('', ''):
            return

        filename = QFileInfo(src_path[0]).baseName()
        filename = filename + ".csv"

        filename = self.datadir + "/" + filename
        cpy_file = QtCore.QFile.copy(src_path[0], filename)

        # message box with yes and no buttons to avoid overwriting files
        if cpy_file == False:
            msg_frem = QMessageBox.question(None, 'Daten einladen', 'Eine gleichnamige Datei existiert bereits, möchten Sie diese durch die aktuelle ersetzen?', QMessageBox.Yes | QMessageBox.No)
            if msg_frem == QMessageBox.Yes:
                os.remove(filename)
                QtCore.QFile.copy(src_path[0], filename)
            elif msg_frem == QMessageBox.No:
                QMessageBox.information(None, "Daten einladen", "Der Vorgang wurde abgebrochen!")
                return            

        # first col of file
        col_header = "NBA;OI;QUA;LAN;RBZ;KRS;GMD;OTT;SSS;HNR;ADZ;RW;NW;STN;PLZ;ONM;ZON;POT;\n"

        # exception handling, if the header does not exists
        try:
            src = open(filename, 'r')
            if src.readline().startswith("N;DE",0) == True:
                line = src.readlines()
                line.insert(0,col_header)
                src.close()
                src = open(filename, 'w')
                src.writelines(line)
                src.close()

        except UnicodeDecodeError:
            src = open(filename, 'r', encoding='iso-8859-1')
        
        self.csvToDatabase(filename)
        self.dbExists()

        QMessageBox.information(None, "Daten eingeladen", "Die Daten wurden erfolgreich eingeladen!")

    def csvToDatabase(self, filename):

        # exception handling for encoding
        try:
            data = pd.read_csv (filename ,delimiter=';', header=0, encoding='utf-8')
        except UnicodeDecodeError:
            data = pd.read_csv (filename ,delimiter=';', header=0, encoding='iso-8859-1')#iso-8859-1

        #keep only this columns
        data = data[['HNR','ADZ','RW','NW','STN','PLZ','ONM','ZON','POT']]

        #fill all NaN values with '' to avoid errors
        data.fillna('', inplace=True)

        #replace commas with point (german and american number delimter)
        data = data.replace({'RW' : {',' : '.'}, 'NW' : {',' : '.'}}, regex=True)

        #address column with all relevant data
        data['ADR'] = data['STN'].map(str) + ' ' + data['HNR'].map(str)  + data['ADZ'].map(str) +', ' + data['PLZ'].map(str) + ' ' + data['ONM'].map(str)

        #new column to sort the streetnames
        data['sortSTN'] = data['STN']
  
        #needed to sort the streetnames in correct order, otherwise the umlaute were listed at the end
        data = data.replace({'sortSTN' : {'Ä' : 'Ae', 'Ö' : 'Oe', 'Ü' : 'Ue','ä' : 'ae', 'ö' : 'oe', 'ü' : 'ue', 'ß' : 'ss'}}, regex=True)
        data = data.sort_values(by=['sortSTN', 'HNR', 'ADZ'])
        #data = data.sort_values(by='sortSTN')
        data['searchCol'] = data['ADR']
        data = data.replace({'searchCol' : {'Ä' : 'Ae', 'Ö' : 'Oe', 'Ü' : 'Ue','ä' : 'ae', 'ö' : 'oe', 'ü' : 'ue', 'ß' : 'ss'}}, regex=True)

        #reset index to get new order as index
        data = data.reset_index(drop=True)
        data['ID'] = np.arange(len(data))

        #drop sort column
        data.pop('sortSTN')

        #give numeric data the correct format
        data['RW'] = pd.to_numeric(data['RW'])
        data['NW'] = pd.to_numeric(data['NW'])

        # execute the sql statement with sqlite
        con = sqlite3.connect(self.datadir + "/Adressen.db")
        cur = con.cursor()
        cur.execute("DROP TABLE IF EXISTS adressen")
        cur.execute("CREATE TABLE IF NOT EXISTS adressen(HNR, ADZ, RW, NW, STN, PLZ, ONM, ZON, POT, ADR, ID)")
        
        # overwrite db file
        data.to_sql('adressen', con, if_exists='replace', index=True)
         
        # cursor close
        cur.close()
        # disconnect
        con.close()

    def searchAddress(self, limit = ' '):

        # input text from textfield
        inpTxt = self.dockwidget.txt_search.text()
        to_replace = {'Ä' : 'Ae', 'Ö' : 'Oe', 'Ü' : 'Ue', 'ä' : 'ae', 'ö' : 'oe', 'ü' : 'ue', 'ß' : 'ss'}

        # replace umlaute
        for char in to_replace.keys():
            inpTxt = inpTxt.replace(char, to_replace[char])

        # split text at spaces in "substrings", result is a list
        splitString = inpTxt.split()
        # declare searchString
        searchString = ""

        # compose sql statement
        # any part separated by space will be part of the sql statetment
        i = 0
        if len(splitString) != 0:
            searchString = "WHERE "
        while i < len(splitString):
            searchString = searchString + "searchCol like '%" + splitString[i] + "%'"
            i = i + 1
            if not i == len(splitString):
                searchString = searchString + " and "

        # checkbox "über aktuelle Ausdehnung suchen"
        cbExtent = self.dockwidget.cb_curExtent.isChecked()

        if cbExtent == True:
            crsSrc = QgsCoordinateReferenceSystem(QgsProject.instance().crs())  #crs of source data
            crsPrj = QgsCoordinateReferenceSystem(4647)
            cordTrans = QgsCoordinateTransform(crsSrc, crsPrj, QgsProject.instance())
            e = self.iface.mapCanvas().extent()

            minPoint = QgsPointXY(e.xMinimum(), e.yMinimum())
            maxPoint = QgsPointXY(e.xMaximum(), e.yMaximum())

            minPoint = cordTrans.transform(minPoint)
            maxPoint = cordTrans.transform(maxPoint)

            xMinimum = str(minPoint.x())
            yMinimum = str(minPoint.y())
            xMaximum = str(maxPoint.x())
            yMaximum = str(maxPoint.y())

            # different possibilities of the string 
            if searchString != "":
                searchString = searchString + " and"
            elif searchString == "":
                searchString = searchString + " WHERE"

            searchString = searchString + " RW >" + xMinimum + " and RW <" + xMaximum + " and NW >" + yMinimum + " and NW <" + yMaximum + " "

        # reset tablewidget
        self.dockwidget.adrWidget.setRowCount(0)

        con = sqlite3.connect(self.datadir + "/Adressen.db")
        cur = con.cursor()

        # execute sql statement
        cur.execute("SELECT ID, ADR, searchCol FROM adressen %s %s" % (searchString, limit))

        records = cur.fetchall()

        # record count
        n = len(records)

        # no matches
        if n == 0: #and lim == 1
            QMessageBox.information(None, "Adressen suchen", "Unter dem eingegebenen Suchbegriff konnte kein übereinstimmender Datensatz gefunden werden!")
            self.dockwidget.txt_search.setText("")
            return
        # progressbar set maximum
        self.dockwidget.progBar.setMaximum(n)
        
        # add records to tablewidget
        for row in records:
            i = records.index(row)
            id = row[0]
            adr = str(row[1])

            item_id = QTableWidgetItem(id)
            item_id.setData(Qt.EditRole, id)
            item_adr = QTableWidgetItem(adr)
            self.dockwidget.adrWidget.insertRow(i)
            self.dockwidget.adrWidget.setItem(i, 0, item_id)
            self.dockwidget.adrWidget.setItem(i, 1, item_adr)
            self.dockwidget.progBar.setValue(i+1)

        self.dockwidget.adrWidget.resizeColumnsToContents()

        cur.close()
        con.close()
        self.dockwidget.progBar.setValue(0)

    def columnName(self, position,name):

        # add columns in tablewidget
        self.dockwidget.adrWidget.insertColumn(position)
        colName = QTableWidgetItem(name)
        self.dockwidget.adrWidget.setHorizontalHeaderItem(position,colName)

    def zoomTo(self):
       
        # get selected row
        rowId = self.dockwidget.adrWidget.currentRow()
        id = int(self.dockwidget.adrWidget.item(rowId, 0).text())
        adr = self.dockwidget.adrWidget.item(rowId, 1).text()

        con = sqlite3.connect(self.datadir + "/Adressen.db")
        cur = con.cursor()
        cur.execute("SELECT %s FROM adressen WHERE ID = %s" % ("RW", id))
        x = cur.fetchone()[0]

        cur.execute("SELECT %s FROM adressen WHERE ID = %s" % ("NW", id))
        y = cur.fetchone()[0]

        centerPoint = QgsPointXY(x, y)

        # convert coordinates
        crsSrc = QgsCoordinateReferenceSystem(4647)  #crs of source data
        crsPrj = QgsCoordinateReferenceSystem(QgsProject.instance().crs())
        cordTrans = QgsCoordinateTransform(crsSrc, crsPrj, QgsProject.instance())

        # forward transformation: src -> dest
        centerPoint = cordTrans.transform(centerPoint)
        self.iface.mapCanvas().setCenter(centerPoint)
        
        # scale
        scale_value = 2500
        self.iface.mapCanvas().zoomScale(scale_value)
        self.iface.mapCanvas().refresh()

        if self.cb_Checked() == True:
            self.save_point(centerPoint, adr)

    # save point to file, point is in project's crs
    def save_point(self, point, address):
        #create, add the point layer
        layName = address
        
        # proof checkbox to create a new or combinded layer
        if self.dockwidget.cb_newLayer.isChecked() == False:
            self.createLayer(address)

        # combinded layer checked
        elif self.dockwidget.cb_newLayer.isChecked() == True:

            if not QgsProject.instance().mapLayersByName("gesuchte Adresspunkte"):
                layName = "gesuchte Adresspunkte"
                self.createLayer(layName)
            elif QgsProject.instance().mapLayersByName("gesuchte Adresspunkte"):
                layers = QgsProject.instance().mapLayersByName("gesuchte Adresspunkte")
                self.layer = layers[0]

        #labeling layer

        layer_settings  = QgsPalLayerSettings()
        text_format = QgsTextFormat()

        # set halo
        buffer_settings = QgsTextBufferSettings()
        buffer_settings.setEnabled(True)
        buffer_settings.setSize(0.8)
        buffer_settings.setColor(QColor("white"))

        text_format.setBuffer(buffer_settings)
        layer_settings.setFormat(text_format)

        layer_settings.enabled = True
        layer_settings.fieldName = "Adresse"
        layer_settings = QgsVectorLayerSimpleLabeling(layer_settings)

        self.layer.setLabeling(layer_settings)
        self.layer.setLabelsEnabled(True)
        self.layer.triggerRepaint()
         
        #add a feature and information in the atribut table
        fields = self.layer.fields()
        feature = QgsFeature(fields)
        feature.setGeometry(QgsGeometry.fromPointXY(QgsPointXY(point)))
        feature['Adresse'] = address

        #execute the added feature
        self.layer.startEditing()
        self.layer.addFeatures([feature])
        self.layer.commitChanges()

    def createLayer(self, layName):

        #create layer
        crs = self.iface.mapCanvas().mapSettings().destinationCrs()
        self.layer = QgsVectorLayer("Point?crs=" + crs.authid() + "&field=Adresse:text", layName, "memory") #"memory" can not be changed!
        self.provider = self.layer.dataProvider()

        # add fields
        self.provider.addAttributes([QgsField("Adresse", QVariant.String)])
        #create normal symbol
        #symbol = QgsMarkerSymbol.createSimple({'name': 'square', 'color': 'red'})

        #create custom svg symbol
        symbol = QgsSvgMarkerSymbolLayer(self.plugin_dir + "/location-pin.svg")
        symbol.setSize(6)
        self.layer.renderer().symbol().changeSymbolLayer(0, symbol)

        # show the change
        self.layer.triggerRepaint()

        #add layer
        QgsProject.instance().addMapLayer(self.layer)

        #store layer id
        self.layerid = self.layer.id()

    def run(self):
        """Run method that loads and starts the plugin"""
        self.dbExists()

        if not self.pluginIsActive:
            self.pluginIsActive = True

            if self.dockwidget == None:
                # Create the dockwidget (after translation) and keep reference
                self.dockwidget = Address_searchDockWidget()

            # connect to provide cleanup on closing of dockwidget
            self.dockwidget.closingPlugin.connect(self.onClosePlugin)

            # show the dockwidget
            self.iface.addDockWidget(Qt.LeftDockWidgetArea, self.dockwidget)
            self.dockwidget.show()
