# coding: utf-8

"""
    CartoVista REST API

    No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)  # noqa: E501

    OpenAPI spec version: 2.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from add_to_cartovista.swagger_client.api_client import ApiClient


class ViewApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def view_create_view_by_expression(self, body, layer_id, tenant_url_code, **kwargs):  # noqa: E501
        """Creates a view based on an expression.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.view_create_view_by_expression(body, layer_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CreateViewByExpressionParameters body: The parameters to create the view. (required)
        :param str layer_id: The layer system identifier. (required)
        :param str tenant_url_code: (required)
        :return: View
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.view_create_view_by_expression_with_http_info(body, layer_id, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.view_create_view_by_expression_with_http_info(body, layer_id, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def view_create_view_by_expression_with_http_info(self, body, layer_id, tenant_url_code, **kwargs):  # noqa: E501
        """Creates a view based on an expression.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.view_create_view_by_expression_with_http_info(body, layer_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CreateViewByExpressionParameters body: The parameters to create the view. (required)
        :param str layer_id: The layer system identifier. (required)
        :param str tenant_url_code: (required)
        :return: View
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'layer_id', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method view_create_view_by_expression" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `view_create_view_by_expression`")  # noqa: E501
        # verify the required parameter 'layer_id' is set
        if ('layer_id' not in params or
                params['layer_id'] is None):
            raise ValueError("Missing the required parameter `layer_id` when calling `view_create_view_by_expression`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `view_create_view_by_expression`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'layer_id' in params:
            path_params['layerId'] = params['layer_id']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/Layer/{layerId}/views/createByExpression', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='View',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def view_create_views_from_column(self, body, layer_id, tenant_url_code, **kwargs):  # noqa: E501
        """Creates views based on a layer column id. This will generate one view for each unique value of the selected column.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.view_create_views_from_column(body, layer_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str body: The column system identifier. (required)
        :param str layer_id: The layer system identifier. (required)
        :param str tenant_url_code: (required)
        :return: list[View]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.view_create_views_from_column_with_http_info(body, layer_id, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.view_create_views_from_column_with_http_info(body, layer_id, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def view_create_views_from_column_with_http_info(self, body, layer_id, tenant_url_code, **kwargs):  # noqa: E501
        """Creates views based on a layer column id. This will generate one view for each unique value of the selected column.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.view_create_views_from_column_with_http_info(body, layer_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str body: The column system identifier. (required)
        :param str layer_id: The layer system identifier. (required)
        :param str tenant_url_code: (required)
        :return: list[View]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'layer_id', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method view_create_views_from_column" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `view_create_views_from_column`")  # noqa: E501
        # verify the required parameter 'layer_id' is set
        if ('layer_id' not in params or
                params['layer_id'] is None):
            raise ValueError("Missing the required parameter `layer_id` when calling `view_create_views_from_column`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `view_create_views_from_column`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'layer_id' in params:
            path_params['layerId'] = params['layer_id']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/Layer/{layerId}/views/createByColumn', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[View]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def view_delete_views(self, layer_id, tenant_url_code, **kwargs):  # noqa: E501
        """Deletes all the views associated with the layer.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.view_delete_views(layer_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str layer_id: The layer system identifier. (required)
        :param str tenant_url_code: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.view_delete_views_with_http_info(layer_id, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.view_delete_views_with_http_info(layer_id, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def view_delete_views_with_http_info(self, layer_id, tenant_url_code, **kwargs):  # noqa: E501
        """Deletes all the views associated with the layer.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.view_delete_views_with_http_info(layer_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str layer_id: The layer system identifier. (required)
        :param str tenant_url_code: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['layer_id', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method view_delete_views" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'layer_id' is set
        if ('layer_id' not in params or
                params['layer_id'] is None):
            raise ValueError("Missing the required parameter `layer_id` when calling `view_delete_views`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `view_delete_views`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'layer_id' in params:
            path_params['layerId'] = params['layer_id']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/Layer/{layerId}/views', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def view_get_view(self, view_id, tenant_url_code, **kwargs):  # noqa: E501
        """Gets a specific view by id.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.view_get_view(view_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str view_id: The view system identifier. (required)
        :param str tenant_url_code: (required)
        :return: View
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.view_get_view_with_http_info(view_id, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.view_get_view_with_http_info(view_id, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def view_get_view_with_http_info(self, view_id, tenant_url_code, **kwargs):  # noqa: E501
        """Gets a specific view by id.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.view_get_view_with_http_info(view_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str view_id: The view system identifier. (required)
        :param str tenant_url_code: (required)
        :return: View
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['view_id', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method view_get_view" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'view_id' is set
        if ('view_id' not in params or
                params['view_id'] is None):
            raise ValueError("Missing the required parameter `view_id` when calling `view_get_view`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `view_get_view`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'view_id' in params:
            path_params['viewId'] = params['view_id']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/Layer/views/{viewId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='View',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def view_get_views(self, layer_id, tenant_url_code, **kwargs):  # noqa: E501
        """Gets the list of views associated with a layer.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.view_get_views(layer_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str layer_id: The layer system identifier. (required)
        :param str tenant_url_code: (required)
        :return: list[View]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.view_get_views_with_http_info(layer_id, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.view_get_views_with_http_info(layer_id, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def view_get_views_with_http_info(self, layer_id, tenant_url_code, **kwargs):  # noqa: E501
        """Gets the list of views associated with a layer.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.view_get_views_with_http_info(layer_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str layer_id: The layer system identifier. (required)
        :param str tenant_url_code: (required)
        :return: list[View]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['layer_id', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method view_get_views" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'layer_id' is set
        if ('layer_id' not in params or
                params['layer_id'] is None):
            raise ValueError("Missing the required parameter `layer_id` when calling `view_get_views`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `view_get_views`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'layer_id' in params:
            path_params['layerId'] = params['layer_id']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/Layer/{layerId}/views', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[View]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def view_update_view(self, body, layer_id, view_id, tenant_url_code, **kwargs):  # noqa: E501
        """Updates the view parameters.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.view_update_view(body, layer_id, view_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UpdateViewParameter body: The parameters to update. (required)
        :param str layer_id: The layer system identifier. (required)
        :param str view_id: The view system identifier. (required)
        :param str tenant_url_code: (required)
        :return: View
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.view_update_view_with_http_info(body, layer_id, view_id, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.view_update_view_with_http_info(body, layer_id, view_id, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def view_update_view_with_http_info(self, body, layer_id, view_id, tenant_url_code, **kwargs):  # noqa: E501
        """Updates the view parameters.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.view_update_view_with_http_info(body, layer_id, view_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UpdateViewParameter body: The parameters to update. (required)
        :param str layer_id: The layer system identifier. (required)
        :param str view_id: The view system identifier. (required)
        :param str tenant_url_code: (required)
        :return: View
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'layer_id', 'view_id', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method view_update_view" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `view_update_view`")  # noqa: E501
        # verify the required parameter 'layer_id' is set
        if ('layer_id' not in params or
                params['layer_id'] is None):
            raise ValueError("Missing the required parameter `layer_id` when calling `view_update_view`")  # noqa: E501
        # verify the required parameter 'view_id' is set
        if ('view_id' not in params or
                params['view_id'] is None):
            raise ValueError("Missing the required parameter `view_id` when calling `view_update_view`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `view_update_view`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'layer_id' in params:
            path_params['layerId'] = params['layer_id']  # noqa: E501
        if 'view_id' in params:
            path_params['viewId'] = params['view_id']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/Layer/{layerId}/views/{viewId}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='View',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def view_update_view_permissions(self, body, layer_id, view_id, tenant_url_code, **kwargs):  # noqa: E501
        """Updates the view permissions. Note: This needs to list all the permissions on the view as the missing permissions will be deleted.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.view_update_view_permissions(body, layer_id, view_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[ViewReadPermission] body: The list of permissions to assign to the view. (required)
        :param str layer_id: The layer system identifier. (required)
        :param str view_id: The view system identifier. (required)
        :param str tenant_url_code: (required)
        :return: View
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.view_update_view_permissions_with_http_info(body, layer_id, view_id, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.view_update_view_permissions_with_http_info(body, layer_id, view_id, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def view_update_view_permissions_with_http_info(self, body, layer_id, view_id, tenant_url_code, **kwargs):  # noqa: E501
        """Updates the view permissions. Note: This needs to list all the permissions on the view as the missing permissions will be deleted.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.view_update_view_permissions_with_http_info(body, layer_id, view_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[ViewReadPermission] body: The list of permissions to assign to the view. (required)
        :param str layer_id: The layer system identifier. (required)
        :param str view_id: The view system identifier. (required)
        :param str tenant_url_code: (required)
        :return: View
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'layer_id', 'view_id', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method view_update_view_permissions" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `view_update_view_permissions`")  # noqa: E501
        # verify the required parameter 'layer_id' is set
        if ('layer_id' not in params or
                params['layer_id'] is None):
            raise ValueError("Missing the required parameter `layer_id` when calling `view_update_view_permissions`")  # noqa: E501
        # verify the required parameter 'view_id' is set
        if ('view_id' not in params or
                params['view_id'] is None):
            raise ValueError("Missing the required parameter `view_id` when calling `view_update_view_permissions`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `view_update_view_permissions`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'layer_id' in params:
            path_params['layerId'] = params['layer_id']  # noqa: E501
        if 'view_id' in params:
            path_params['viewId'] = params['view_id']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/Layer/{layerId}/views/{viewId}/permissions', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='View',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
