# coding: utf-8

"""
    CartoVista REST API

    No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)  # noqa: E501

    OpenAPI spec version: 2.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from add_to_cartovista.swagger_client.api_client import ApiClient


class MapApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def map_add_layers_to_map(self, body, map_id, tenant_url_code, **kwargs):  # noqa: E501
        """Add layers to a dynamic map. The operation adds new layers only, the existing layers are not removed.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.map_add_layers_to_map(body, map_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AddMapLayersParameter body: (required)
        :param str map_id: (required)
        :param str tenant_url_code: (required)
        :return: MapLayersResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.map_add_layers_to_map_with_http_info(body, map_id, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.map_add_layers_to_map_with_http_info(body, map_id, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def map_add_layers_to_map_with_http_info(self, body, map_id, tenant_url_code, **kwargs):  # noqa: E501
        """Add layers to a dynamic map. The operation adds new layers only, the existing layers are not removed.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.map_add_layers_to_map_with_http_info(body, map_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AddMapLayersParameter body: (required)
        :param str map_id: (required)
        :param str tenant_url_code: (required)
        :return: MapLayersResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'map_id', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method map_add_layers_to_map" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `map_add_layers_to_map`")  # noqa: E501
        # verify the required parameter 'map_id' is set
        if ('map_id' not in params or
                params['map_id'] is None):
            raise ValueError("Missing the required parameter `map_id` when calling `map_add_layers_to_map`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `map_add_layers_to_map`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'map_id' in params:
            path_params['mapId'] = params['map_id']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/maps/{mapId}/layers', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MapLayersResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def map_clone_map(self, map_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Clones the map.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.map_clone_map(map_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str map_identifier: (required)
        :param str tenant_url_code: (required)
        :return: Map
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.map_clone_map_with_http_info(map_identifier, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.map_clone_map_with_http_info(map_identifier, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def map_clone_map_with_http_info(self, map_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Clones the map.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.map_clone_map_with_http_info(map_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str map_identifier: (required)
        :param str tenant_url_code: (required)
        :return: Map
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['map_identifier', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method map_clone_map" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'map_identifier' is set
        if ('map_identifier' not in params or
                params['map_identifier'] is None):
            raise ValueError("Missing the required parameter `map_identifier` when calling `map_clone_map`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `map_clone_map`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'map_identifier' in params:
            path_params['mapIdentifier'] = params['map_identifier']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/maps/{mapIdentifier}/clone', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Map',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def map_create_map(self, body, tenant_url_code, **kwargs):  # noqa: E501
        """Create a map based on the provided parameters.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.map_create_map(body, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param MapCreateParameter body: Parameters used to create the map. (required)
        :param str tenant_url_code: (required)
        :return: Map
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.map_create_map_with_http_info(body, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.map_create_map_with_http_info(body, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def map_create_map_with_http_info(self, body, tenant_url_code, **kwargs):  # noqa: E501
        """Create a map based on the provided parameters.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.map_create_map_with_http_info(body, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param MapCreateParameter body: Parameters used to create the map. (required)
        :param str tenant_url_code: (required)
        :return: Map
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method map_create_map" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `map_create_map`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `map_create_map`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/maps', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Map',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def map_create_map_plugin(self, body, map_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Creates map plugin. Only usable by superadministrators.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.map_create_map_plugin(body, map_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CreateMapPlugin body: (required)
        :param str map_identifier: (required)
        :param str tenant_url_code: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.map_create_map_plugin_with_http_info(body, map_identifier, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.map_create_map_plugin_with_http_info(body, map_identifier, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def map_create_map_plugin_with_http_info(self, body, map_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Creates map plugin. Only usable by superadministrators.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.map_create_map_plugin_with_http_info(body, map_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CreateMapPlugin body: (required)
        :param str map_identifier: (required)
        :param str tenant_url_code: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'map_identifier', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method map_create_map_plugin" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `map_create_map_plugin`")  # noqa: E501
        # verify the required parameter 'map_identifier' is set
        if ('map_identifier' not in params or
                params['map_identifier'] is None):
            raise ValueError("Missing the required parameter `map_identifier` when calling `map_create_map_plugin`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `map_create_map_plugin`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'map_identifier' in params:
            path_params['mapIdentifier'] = params['map_identifier']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/maps/{mapIdentifier}/plugin', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def map_create_slide(self, body, map_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Creates a new slide.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.map_create_slide(body, map_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SlideCreateUpdate body: (required)
        :param str map_identifier: (required)
        :param str tenant_url_code: (required)
        :return: Slide
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.map_create_slide_with_http_info(body, map_identifier, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.map_create_slide_with_http_info(body, map_identifier, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def map_create_slide_with_http_info(self, body, map_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Creates a new slide.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.map_create_slide_with_http_info(body, map_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SlideCreateUpdate body: (required)
        :param str map_identifier: (required)
        :param str tenant_url_code: (required)
        :return: Slide
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'map_identifier', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method map_create_slide" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `map_create_slide`")  # noqa: E501
        # verify the required parameter 'map_identifier' is set
        if ('map_identifier' not in params or
                params['map_identifier'] is None):
            raise ValueError("Missing the required parameter `map_identifier` when calling `map_create_slide`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `map_create_slide`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'map_identifier' in params:
            path_params['mapIdentifier'] = params['map_identifier']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/maps/{mapIdentifier}/slides', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Slide',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def map_delete_map(self, map_id, tenant_url_code, **kwargs):  # noqa: E501
        """Deletes a map.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.map_delete_map(map_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str map_id: Map id or a friendly identifier. (required)
        :param str tenant_url_code: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.map_delete_map_with_http_info(map_id, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.map_delete_map_with_http_info(map_id, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def map_delete_map_with_http_info(self, map_id, tenant_url_code, **kwargs):  # noqa: E501
        """Deletes a map.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.map_delete_map_with_http_info(map_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str map_id: Map id or a friendly identifier. (required)
        :param str tenant_url_code: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['map_id', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method map_delete_map" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'map_id' is set
        if ('map_id' not in params or
                params['map_id'] is None):
            raise ValueError("Missing the required parameter `map_id` when calling `map_delete_map`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `map_delete_map`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'map_id' in params:
            path_params['mapId'] = params['map_id']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/maps/{mapId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def map_delete_map_grid_layer(self, map_identifier, grid_layer_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Removes the grid layer from the map.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.map_delete_map_grid_layer(map_identifier, grid_layer_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str map_identifier: (required)
        :param str grid_layer_identifier: (required)
        :param str tenant_url_code: (required)
        :return: MapLayersResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.map_delete_map_grid_layer_with_http_info(map_identifier, grid_layer_identifier, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.map_delete_map_grid_layer_with_http_info(map_identifier, grid_layer_identifier, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def map_delete_map_grid_layer_with_http_info(self, map_identifier, grid_layer_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Removes the grid layer from the map.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.map_delete_map_grid_layer_with_http_info(map_identifier, grid_layer_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str map_identifier: (required)
        :param str grid_layer_identifier: (required)
        :param str tenant_url_code: (required)
        :return: MapLayersResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['map_identifier', 'grid_layer_identifier', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method map_delete_map_grid_layer" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'map_identifier' is set
        if ('map_identifier' not in params or
                params['map_identifier'] is None):
            raise ValueError("Missing the required parameter `map_identifier` when calling `map_delete_map_grid_layer`")  # noqa: E501
        # verify the required parameter 'grid_layer_identifier' is set
        if ('grid_layer_identifier' not in params or
                params['grid_layer_identifier'] is None):
            raise ValueError("Missing the required parameter `grid_layer_identifier` when calling `map_delete_map_grid_layer`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `map_delete_map_grid_layer`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'map_identifier' in params:
            path_params['mapIdentifier'] = params['map_identifier']  # noqa: E501
        if 'grid_layer_identifier' in params:
            path_params['gridLayerIdentifier'] = params['grid_layer_identifier']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/maps/{mapIdentifier}/grid/{gridLayerIdentifier}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MapLayersResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def map_delete_map_layer(self, map_identifier, layer_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Removes the layer from the map.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.map_delete_map_layer(map_identifier, layer_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str map_identifier: (required)
        :param str layer_identifier: (required)
        :param str tenant_url_code: (required)
        :return: MapLayersResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.map_delete_map_layer_with_http_info(map_identifier, layer_identifier, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.map_delete_map_layer_with_http_info(map_identifier, layer_identifier, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def map_delete_map_layer_with_http_info(self, map_identifier, layer_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Removes the layer from the map.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.map_delete_map_layer_with_http_info(map_identifier, layer_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str map_identifier: (required)
        :param str layer_identifier: (required)
        :param str tenant_url_code: (required)
        :return: MapLayersResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['map_identifier', 'layer_identifier', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method map_delete_map_layer" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'map_identifier' is set
        if ('map_identifier' not in params or
                params['map_identifier'] is None):
            raise ValueError("Missing the required parameter `map_identifier` when calling `map_delete_map_layer`")  # noqa: E501
        # verify the required parameter 'layer_identifier' is set
        if ('layer_identifier' not in params or
                params['layer_identifier'] is None):
            raise ValueError("Missing the required parameter `layer_identifier` when calling `map_delete_map_layer`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `map_delete_map_layer`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'map_identifier' in params:
            path_params['mapIdentifier'] = params['map_identifier']  # noqa: E501
        if 'layer_identifier' in params:
            path_params['layerIdentifier'] = params['layer_identifier']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/maps/{mapIdentifier}/layers/{layerIdentifier}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MapLayersResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def map_delete_map_plugin(self, map_identifier, plugin_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Delete a map plugin. Only usable by superadministrators.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.map_delete_map_plugin(map_identifier, plugin_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str map_identifier: (required)
        :param str plugin_identifier: (required)
        :param str tenant_url_code: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.map_delete_map_plugin_with_http_info(map_identifier, plugin_identifier, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.map_delete_map_plugin_with_http_info(map_identifier, plugin_identifier, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def map_delete_map_plugin_with_http_info(self, map_identifier, plugin_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Delete a map plugin. Only usable by superadministrators.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.map_delete_map_plugin_with_http_info(map_identifier, plugin_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str map_identifier: (required)
        :param str plugin_identifier: (required)
        :param str tenant_url_code: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['map_identifier', 'plugin_identifier', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method map_delete_map_plugin" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'map_identifier' is set
        if ('map_identifier' not in params or
                params['map_identifier'] is None):
            raise ValueError("Missing the required parameter `map_identifier` when calling `map_delete_map_plugin`")  # noqa: E501
        # verify the required parameter 'plugin_identifier' is set
        if ('plugin_identifier' not in params or
                params['plugin_identifier'] is None):
            raise ValueError("Missing the required parameter `plugin_identifier` when calling `map_delete_map_plugin`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `map_delete_map_plugin`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'map_identifier' in params:
            path_params['mapIdentifier'] = params['map_identifier']  # noqa: E501
        if 'plugin_identifier' in params:
            path_params['pluginIdentifier'] = params['plugin_identifier']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/maps/{mapIdentifier}/plugin/{pluginIdentifier}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def map_delete_map_wms_layer(self, map_identifier, wms_layer_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Removes the WMS layer from the map.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.map_delete_map_wms_layer(map_identifier, wms_layer_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str map_identifier: (required)
        :param str wms_layer_identifier: (required)
        :param str tenant_url_code: (required)
        :return: MapLayersResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.map_delete_map_wms_layer_with_http_info(map_identifier, wms_layer_identifier, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.map_delete_map_wms_layer_with_http_info(map_identifier, wms_layer_identifier, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def map_delete_map_wms_layer_with_http_info(self, map_identifier, wms_layer_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Removes the WMS layer from the map.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.map_delete_map_wms_layer_with_http_info(map_identifier, wms_layer_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str map_identifier: (required)
        :param str wms_layer_identifier: (required)
        :param str tenant_url_code: (required)
        :return: MapLayersResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['map_identifier', 'wms_layer_identifier', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method map_delete_map_wms_layer" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'map_identifier' is set
        if ('map_identifier' not in params or
                params['map_identifier'] is None):
            raise ValueError("Missing the required parameter `map_identifier` when calling `map_delete_map_wms_layer`")  # noqa: E501
        # verify the required parameter 'wms_layer_identifier' is set
        if ('wms_layer_identifier' not in params or
                params['wms_layer_identifier'] is None):
            raise ValueError("Missing the required parameter `wms_layer_identifier` when calling `map_delete_map_wms_layer`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `map_delete_map_wms_layer`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'map_identifier' in params:
            path_params['mapIdentifier'] = params['map_identifier']  # noqa: E501
        if 'wms_layer_identifier' in params:
            path_params['wmsLayerIdentifier'] = params['wms_layer_identifier']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/maps/{mapIdentifier}/wms/{wmsLayerIdentifier}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MapLayersResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def map_delete_map_wmts_layer(self, map_identifier, wmts_layer_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Removes the WMTS layer from the map.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.map_delete_map_wmts_layer(map_identifier, wmts_layer_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str map_identifier: (required)
        :param str wmts_layer_identifier: (required)
        :param str tenant_url_code: (required)
        :return: MapLayersResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.map_delete_map_wmts_layer_with_http_info(map_identifier, wmts_layer_identifier, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.map_delete_map_wmts_layer_with_http_info(map_identifier, wmts_layer_identifier, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def map_delete_map_wmts_layer_with_http_info(self, map_identifier, wmts_layer_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Removes the WMTS layer from the map.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.map_delete_map_wmts_layer_with_http_info(map_identifier, wmts_layer_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str map_identifier: (required)
        :param str wmts_layer_identifier: (required)
        :param str tenant_url_code: (required)
        :return: MapLayersResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['map_identifier', 'wmts_layer_identifier', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method map_delete_map_wmts_layer" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'map_identifier' is set
        if ('map_identifier' not in params or
                params['map_identifier'] is None):
            raise ValueError("Missing the required parameter `map_identifier` when calling `map_delete_map_wmts_layer`")  # noqa: E501
        # verify the required parameter 'wmts_layer_identifier' is set
        if ('wmts_layer_identifier' not in params or
                params['wmts_layer_identifier'] is None):
            raise ValueError("Missing the required parameter `wmts_layer_identifier` when calling `map_delete_map_wmts_layer`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `map_delete_map_wmts_layer`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'map_identifier' in params:
            path_params['mapIdentifier'] = params['map_identifier']  # noqa: E501
        if 'wmts_layer_identifier' in params:
            path_params['wmtsLayerIdentifier'] = params['wmts_layer_identifier']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/maps/{mapIdentifier}/wmts/{wmtsLayerIdentifier}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MapLayersResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def map_export_map_data_by_extent(self, body, tenant_url_code, **kwargs):  # noqa: E501
        """Exports some or all the map's layers data within an extent in Excel format. The file can be downloaded with `DownloadFile/download`.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.map_export_map_data_by_extent(body, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param LayersExportByExtentParameter body: (required)
        :param str tenant_url_code: (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.map_export_map_data_by_extent_with_http_info(body, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.map_export_map_data_by_extent_with_http_info(body, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def map_export_map_data_by_extent_with_http_info(self, body, tenant_url_code, **kwargs):  # noqa: E501
        """Exports some or all the map's layers data within an extent in Excel format. The file can be downloaded with `DownloadFile/download`.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.map_export_map_data_by_extent_with_http_info(body, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param LayersExportByExtentParameter body: (required)
        :param str tenant_url_code: (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method map_export_map_data_by_extent" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `map_export_map_data_by_extent`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `map_export_map_data_by_extent`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/maps/export-data-extent', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def map_export_map_data_by_selection(self, body, tenant_url_code, **kwargs):  # noqa: E501
        """Exports the map's selection in Excel format. The file can be downloaded with `DownloadFile/download`.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.map_export_map_data_by_selection(body, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param LayersExportBySelectionParameter body: (required)
        :param str tenant_url_code: (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.map_export_map_data_by_selection_with_http_info(body, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.map_export_map_data_by_selection_with_http_info(body, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def map_export_map_data_by_selection_with_http_info(self, body, tenant_url_code, **kwargs):  # noqa: E501
        """Exports the map's selection in Excel format. The file can be downloaded with `DownloadFile/download`.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.map_export_map_data_by_selection_with_http_info(body, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param LayersExportBySelectionParameter body: (required)
        :param str tenant_url_code: (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method map_export_map_data_by_selection" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `map_export_map_data_by_selection`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `map_export_map_data_by_selection`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/maps/export-data-selection', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def map_export_map_elements(self, selected_language, tenant_url_code, **kwargs):  # noqa: E501
        """Exports an Excel sheet of all the maps. The file can be downloaded with `DownloadFile/download`. The language is used to localized the sheet's name and columns.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.map_export_map_elements(selected_language, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str selected_language: (required)
        :param str tenant_url_code: (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.map_export_map_elements_with_http_info(selected_language, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.map_export_map_elements_with_http_info(selected_language, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def map_export_map_elements_with_http_info(self, selected_language, tenant_url_code, **kwargs):  # noqa: E501
        """Exports an Excel sheet of all the maps. The file can be downloaded with `DownloadFile/download`. The language is used to localized the sheet's name and columns.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.map_export_map_elements_with_http_info(selected_language, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str selected_language: (required)
        :param str tenant_url_code: (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['selected_language', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method map_export_map_elements" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'selected_language' is set
        if ('selected_language' not in params or
                params['selected_language'] is None):
            raise ValueError("Missing the required parameter `selected_language` when calling `map_export_map_elements`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `map_export_map_elements`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []
        if 'selected_language' in params:
            query_params.append(('selectedLanguage', params['selected_language']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/maps/ExportMapElements', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def map_get_data_tables_by_map(self, map_id, tenant_url_code, **kwargs):  # noqa: E501
        """Gets the tables used by this map.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.map_get_data_tables_by_map(map_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str map_id: (required)
        :param str tenant_url_code: (required)
        :return: list[DataTable]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.map_get_data_tables_by_map_with_http_info(map_id, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.map_get_data_tables_by_map_with_http_info(map_id, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def map_get_data_tables_by_map_with_http_info(self, map_id, tenant_url_code, **kwargs):  # noqa: E501
        """Gets the tables used by this map.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.map_get_data_tables_by_map_with_http_info(map_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str map_id: (required)
        :param str tenant_url_code: (required)
        :return: list[DataTable]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['map_id', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method map_get_data_tables_by_map" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'map_id' is set
        if ('map_id' not in params or
                params['map_id'] is None):
            raise ValueError("Missing the required parameter `map_id` when calling `map_get_data_tables_by_map`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `map_get_data_tables_by_map`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'map_id' in params:
            path_params['mapId'] = params['map_id']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/maps/{mapId}/dataTables', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[DataTable]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def map_get_grid_layers_by_map(self, map_id, tenant_url_code, **kwargs):  # noqa: E501
        """Gets the list of grid layers used in a map.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.map_get_grid_layers_by_map(map_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str map_id: Map id or a friendly identifier. (required)
        :param str tenant_url_code: (required)
        :return: list[GridLayer]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.map_get_grid_layers_by_map_with_http_info(map_id, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.map_get_grid_layers_by_map_with_http_info(map_id, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def map_get_grid_layers_by_map_with_http_info(self, map_id, tenant_url_code, **kwargs):  # noqa: E501
        """Gets the list of grid layers used in a map.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.map_get_grid_layers_by_map_with_http_info(map_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str map_id: Map id or a friendly identifier. (required)
        :param str tenant_url_code: (required)
        :return: list[GridLayer]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['map_id', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method map_get_grid_layers_by_map" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'map_id' is set
        if ('map_id' not in params or
                params['map_id'] is None):
            raise ValueError("Missing the required parameter `map_id` when calling `map_get_grid_layers_by_map`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `map_get_grid_layers_by_map`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'map_id' in params:
            path_params['mapId'] = params['map_id']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/maps/{mapId}/gridLayers', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[GridLayer]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def map_get_keywords(self, tenant_url_code, **kwargs):  # noqa: E501
        """Gets the map's keywords.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.map_get_keywords(tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str tenant_url_code: (required)
        :return: list[KeywordDTO]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.map_get_keywords_with_http_info(tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.map_get_keywords_with_http_info(tenant_url_code, **kwargs)  # noqa: E501
            return data

    def map_get_keywords_with_http_info(self, tenant_url_code, **kwargs):  # noqa: E501
        """Gets the map's keywords.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.map_get_keywords_with_http_info(tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str tenant_url_code: (required)
        :return: list[KeywordDTO]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method map_get_keywords" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `map_get_keywords`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/maps/keywords', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[KeywordDTO]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def map_get_layers_by_map(self, map_id, tenant_url_code, **kwargs):  # noqa: E501
        """Gets the list of Layers used in a map.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.map_get_layers_by_map(map_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str map_id: Map id or a friendly identifier. (required)
        :param str tenant_url_code: (required)
        :return: list[Layer]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.map_get_layers_by_map_with_http_info(map_id, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.map_get_layers_by_map_with_http_info(map_id, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def map_get_layers_by_map_with_http_info(self, map_id, tenant_url_code, **kwargs):  # noqa: E501
        """Gets the list of Layers used in a map.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.map_get_layers_by_map_with_http_info(map_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str map_id: Map id or a friendly identifier. (required)
        :param str tenant_url_code: (required)
        :return: list[Layer]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['map_id', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method map_get_layers_by_map" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'map_id' is set
        if ('map_id' not in params or
                params['map_id'] is None):
            raise ValueError("Missing the required parameter `map_id` when calling `map_get_layers_by_map`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `map_get_layers_by_map`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'map_id' in params:
            path_params['mapId'] = params['map_id']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/maps/{mapId}/layers', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Layer]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def map_get_map(self, map_id, tenant_url_code, **kwargs):  # noqa: E501
        """Get a map based on the map id or a friendly identifier.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.map_get_map(map_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str map_id: Map id or a friendly identifier. (required)
        :param str tenant_url_code: (required)
        :return: Map
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.map_get_map_with_http_info(map_id, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.map_get_map_with_http_info(map_id, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def map_get_map_with_http_info(self, map_id, tenant_url_code, **kwargs):  # noqa: E501
        """Get a map based on the map id or a friendly identifier.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.map_get_map_with_http_info(map_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str map_id: Map id or a friendly identifier. (required)
        :param str tenant_url_code: (required)
        :return: Map
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['map_id', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method map_get_map" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'map_id' is set
        if ('map_id' not in params or
                params['map_id'] is None):
            raise ValueError("Missing the required parameter `map_id` when calling `map_get_map`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `map_get_map`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'map_id' in params:
            path_params['mapId'] = params['map_id']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/maps/{mapId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Map',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def map_get_map_advanced_settings(self, map_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Gets the map's advanced settings.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.map_get_map_advanced_settings(map_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str map_identifier: (required)
        :param str tenant_url_code: (required)
        :return: MapAdvancedSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.map_get_map_advanced_settings_with_http_info(map_identifier, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.map_get_map_advanced_settings_with_http_info(map_identifier, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def map_get_map_advanced_settings_with_http_info(self, map_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Gets the map's advanced settings.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.map_get_map_advanced_settings_with_http_info(map_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str map_identifier: (required)
        :param str tenant_url_code: (required)
        :return: MapAdvancedSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['map_identifier', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method map_get_map_advanced_settings" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'map_identifier' is set
        if ('map_identifier' not in params or
                params['map_identifier'] is None):
            raise ValueError("Missing the required parameter `map_identifier` when calling `map_get_map_advanced_settings`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `map_get_map_advanced_settings`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'map_identifier' in params:
            path_params['mapIdentifier'] = params['map_identifier']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/maps/{mapIdentifier}/advancedSettings', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MapAdvancedSettings',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def map_get_map_for_viewer(self, map_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Gets all the data required to open a map.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.map_get_map_for_viewer(map_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str map_identifier: (required)
        :param str tenant_url_code: (required)
        :return: MapWithViewerInformation
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.map_get_map_for_viewer_with_http_info(map_identifier, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.map_get_map_for_viewer_with_http_info(map_identifier, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def map_get_map_for_viewer_with_http_info(self, map_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Gets all the data required to open a map.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.map_get_map_for_viewer_with_http_info(map_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str map_identifier: (required)
        :param str tenant_url_code: (required)
        :return: MapWithViewerInformation
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['map_identifier', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method map_get_map_for_viewer" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'map_identifier' is set
        if ('map_identifier' not in params or
                params['map_identifier'] is None):
            raise ValueError("Missing the required parameter `map_identifier` when calling `map_get_map_for_viewer`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `map_get_map_for_viewer`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'map_identifier' in params:
            path_params['mapIdentifier'] = params['map_identifier']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/maps/{mapIdentifier}/viewer', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MapWithViewerInformation',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def map_get_map_toolbar(self, map_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Gets the map's toolbar settings.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.map_get_map_toolbar(map_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str map_identifier: (required)
        :param str tenant_url_code: (required)
        :return: MapToolbar
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.map_get_map_toolbar_with_http_info(map_identifier, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.map_get_map_toolbar_with_http_info(map_identifier, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def map_get_map_toolbar_with_http_info(self, map_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Gets the map's toolbar settings.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.map_get_map_toolbar_with_http_info(map_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str map_identifier: (required)
        :param str tenant_url_code: (required)
        :return: MapToolbar
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['map_identifier', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method map_get_map_toolbar" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'map_identifier' is set
        if ('map_identifier' not in params or
                params['map_identifier'] is None):
            raise ValueError("Missing the required parameter `map_identifier` when calling `map_get_map_toolbar`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `map_get_map_toolbar`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'map_identifier' in params:
            path_params['mapIdentifier'] = params['map_identifier']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/maps/{mapIdentifier}/toolbar', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MapToolbar',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def map_get_map_with_details(self, map_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Gets the map, its tables and its layers.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.map_get_map_with_details(map_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str map_identifier: (required)
        :param str tenant_url_code: (required)
        :return: MapWithDetails
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.map_get_map_with_details_with_http_info(map_identifier, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.map_get_map_with_details_with_http_info(map_identifier, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def map_get_map_with_details_with_http_info(self, map_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Gets the map, its tables and its layers.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.map_get_map_with_details_with_http_info(map_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str map_identifier: (required)
        :param str tenant_url_code: (required)
        :return: MapWithDetails
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['map_identifier', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method map_get_map_with_details" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'map_identifier' is set
        if ('map_identifier' not in params or
                params['map_identifier'] is None):
            raise ValueError("Missing the required parameter `map_identifier` when calling `map_get_map_with_details`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `map_get_map_with_details`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'map_identifier' in params:
            path_params['mapIdentifier'] = params['map_identifier']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/maps/{mapIdentifier}/details', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MapWithDetails',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def map_get_maps(self, tenant_url_code, **kwargs):  # noqa: E501
        """Get all maps the requesting user has access to.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.map_get_maps(tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str tenant_url_code: (required)
        :return: list[Map]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.map_get_maps_with_http_info(tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.map_get_maps_with_http_info(tenant_url_code, **kwargs)  # noqa: E501
            return data

    def map_get_maps_with_http_info(self, tenant_url_code, **kwargs):  # noqa: E501
        """Get all maps the requesting user has access to.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.map_get_maps_with_http_info(tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str tenant_url_code: (required)
        :return: list[Map]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method map_get_maps" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `map_get_maps`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/maps/maps', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Map]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def map_get_maps_content(self, body, tenant_url_code, **kwargs):  # noqa: E501
        """Gets all the maps and folders the user has access to in a specific folder. If the folder id is omitted, the root folder is used.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.map_get_maps_content(body, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param GetMapsContentParam body: (required)
        :param str tenant_url_code: (required)
        :return: MapElements
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.map_get_maps_content_with_http_info(body, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.map_get_maps_content_with_http_info(body, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def map_get_maps_content_with_http_info(self, body, tenant_url_code, **kwargs):  # noqa: E501
        """Gets all the maps and folders the user has access to in a specific folder. If the folder id is omitted, the root folder is used.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.map_get_maps_content_with_http_info(body, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param GetMapsContentParam body: (required)
        :param str tenant_url_code: (required)
        :return: MapElements
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method map_get_maps_content" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `map_get_maps_content`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `map_get_maps_content`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/maps/elements', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MapElements',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def map_get_slide_items(self, map_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Gets the map's slides.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.map_get_slide_items(map_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str map_identifier: (required)
        :param str tenant_url_code: (required)
        :return: SlideItems
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.map_get_slide_items_with_http_info(map_identifier, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.map_get_slide_items_with_http_info(map_identifier, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def map_get_slide_items_with_http_info(self, map_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Gets the map's slides.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.map_get_slide_items_with_http_info(map_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str map_identifier: (required)
        :param str tenant_url_code: (required)
        :return: SlideItems
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['map_identifier', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method map_get_slide_items" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'map_identifier' is set
        if ('map_identifier' not in params or
                params['map_identifier'] is None):
            raise ValueError("Missing the required parameter `map_identifier` when calling `map_get_slide_items`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `map_get_slide_items`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'map_identifier' in params:
            path_params['mapIdentifier'] = params['map_identifier']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/maps/{mapIdentifier}/slideItems', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SlideItems',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def map_get_slides(self, map_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Gets the map's slides.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.map_get_slides(map_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str map_identifier: (required)
        :param str tenant_url_code: (required)
        :return: list[Slide]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.map_get_slides_with_http_info(map_identifier, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.map_get_slides_with_http_info(map_identifier, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def map_get_slides_with_http_info(self, map_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Gets the map's slides.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.map_get_slides_with_http_info(map_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str map_identifier: (required)
        :param str tenant_url_code: (required)
        :return: list[Slide]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['map_identifier', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method map_get_slides" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'map_identifier' is set
        if ('map_identifier' not in params or
                params['map_identifier'] is None):
            raise ValueError("Missing the required parameter `map_identifier` when calling `map_get_slides`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `map_get_slides`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'map_identifier' in params:
            path_params['mapIdentifier'] = params['map_identifier']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/maps/{mapIdentifier}/slides', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Slide]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def map_move_map_layer(self, body, map_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Reorders the map's layers.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.map_move_map_layer(body, map_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param MoveMapLayerParameter body: (required)
        :param str map_identifier: (required)
        :param str tenant_url_code: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.map_move_map_layer_with_http_info(body, map_identifier, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.map_move_map_layer_with_http_info(body, map_identifier, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def map_move_map_layer_with_http_info(self, body, map_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Reorders the map's layers.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.map_move_map_layer_with_http_info(body, map_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param MoveMapLayerParameter body: (required)
        :param str map_identifier: (required)
        :param str tenant_url_code: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'map_identifier', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method map_move_map_layer" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `map_move_map_layer`")  # noqa: E501
        # verify the required parameter 'map_identifier' is set
        if ('map_identifier' not in params or
                params['map_identifier'] is None):
            raise ValueError("Missing the required parameter `map_identifier` when calling `map_move_map_layer`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `map_move_map_layer`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'map_identifier' in params:
            path_params['mapIdentifier'] = params['map_identifier']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/maps/{mapIdentifier}/layer-order', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def map_run_map_action(self, body, map_action_id, map_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Runs a map action.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.map_run_map_action(body, map_action_id, map_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param dict(str, str) body: (required)
        :param str map_action_id: (required)
        :param str map_identifier: (required)
        :param str tenant_url_code: (required)
        :return: MapActionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.map_run_map_action_with_http_info(body, map_action_id, map_identifier, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.map_run_map_action_with_http_info(body, map_action_id, map_identifier, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def map_run_map_action_with_http_info(self, body, map_action_id, map_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Runs a map action.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.map_run_map_action_with_http_info(body, map_action_id, map_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param dict(str, str) body: (required)
        :param str map_action_id: (required)
        :param str map_identifier: (required)
        :param str tenant_url_code: (required)
        :return: MapActionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'map_action_id', 'map_identifier', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method map_run_map_action" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `map_run_map_action`")  # noqa: E501
        # verify the required parameter 'map_action_id' is set
        if ('map_action_id' not in params or
                params['map_action_id'] is None):
            raise ValueError("Missing the required parameter `map_action_id` when calling `map_run_map_action`")  # noqa: E501
        # verify the required parameter 'map_identifier' is set
        if ('map_identifier' not in params or
                params['map_identifier'] is None):
            raise ValueError("Missing the required parameter `map_identifier` when calling `map_run_map_action`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `map_run_map_action`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'map_identifier' in params:
            path_params['mapIdentifier'] = params['map_identifier']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []
        if 'map_action_id' in params:
            query_params.append(('mapActionId', params['map_action_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/maps/{mapIdentifier}/action', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MapActionResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def map_save_default_map_print_layout(self, body, tenant_url_code, **kwargs):  # noqa: E501
        """Updates the default print layout.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.map_save_default_map_print_layout(body, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CreatePrintLayoutParameter body: (required)
        :param str tenant_url_code: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.map_save_default_map_print_layout_with_http_info(body, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.map_save_default_map_print_layout_with_http_info(body, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def map_save_default_map_print_layout_with_http_info(self, body, tenant_url_code, **kwargs):  # noqa: E501
        """Updates the default print layout.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.map_save_default_map_print_layout_with_http_info(body, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CreatePrintLayoutParameter body: (required)
        :param str tenant_url_code: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method map_save_default_map_print_layout" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `map_save_default_map_print_layout`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `map_save_default_map_print_layout`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/maps/save-default-layout', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def map_save_map_print_layout(self, body, map_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Updates the map's print layout.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.map_save_map_print_layout(body, map_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CreatePrintLayoutParameter body: (required)
        :param str map_identifier: (required)
        :param str tenant_url_code: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.map_save_map_print_layout_with_http_info(body, map_identifier, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.map_save_map_print_layout_with_http_info(body, map_identifier, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def map_save_map_print_layout_with_http_info(self, body, map_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Updates the map's print layout.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.map_save_map_print_layout_with_http_info(body, map_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CreatePrintLayoutParameter body: (required)
        :param str map_identifier: (required)
        :param str tenant_url_code: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'map_identifier', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method map_save_map_print_layout" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `map_save_map_print_layout`")  # noqa: E501
        # verify the required parameter 'map_identifier' is set
        if ('map_identifier' not in params or
                params['map_identifier'] is None):
            raise ValueError("Missing the required parameter `map_identifier` when calling `map_save_map_print_layout`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `map_save_map_print_layout`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'map_identifier' in params:
            path_params['mapIdentifier'] = params['map_identifier']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/maps/{mapIdentifier}/save-layout', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def map_search_map(self, body, map_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Searches for a match in the searchable columns of the map's layers and geocoded addresses.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.map_search_map(body, map_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SearchMapParameter body: (required)
        :param str map_identifier: (required)
        :param str tenant_url_code: (required)
        :return: MapSearchResults
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.map_search_map_with_http_info(body, map_identifier, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.map_search_map_with_http_info(body, map_identifier, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def map_search_map_with_http_info(self, body, map_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Searches for a match in the searchable columns of the map's layers and geocoded addresses.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.map_search_map_with_http_info(body, map_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SearchMapParameter body: (required)
        :param str map_identifier: (required)
        :param str tenant_url_code: (required)
        :return: MapSearchResults
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'map_identifier', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method map_search_map" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `map_search_map`")  # noqa: E501
        # verify the required parameter 'map_identifier' is set
        if ('map_identifier' not in params or
                params['map_identifier'] is None):
            raise ValueError("Missing the required parameter `map_identifier` when calling `map_search_map`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `map_search_map`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'map_identifier' in params:
            path_params['mapIdentifier'] = params['map_identifier']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/maps/{mapIdentifier}/search', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MapSearchResults',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def map_search_map_layer(self, body, map_identifier, layer_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Searches for a match in the searchable columns of the map's layers.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.map_search_map_layer(body, map_identifier, layer_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SearchMapLayerParameter body: (required)
        :param str map_identifier: (required)
        :param str layer_identifier: (required)
        :param str tenant_url_code: (required)
        :return: LayerSearchResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.map_search_map_layer_with_http_info(body, map_identifier, layer_identifier, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.map_search_map_layer_with_http_info(body, map_identifier, layer_identifier, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def map_search_map_layer_with_http_info(self, body, map_identifier, layer_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Searches for a match in the searchable columns of the map's layers.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.map_search_map_layer_with_http_info(body, map_identifier, layer_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SearchMapLayerParameter body: (required)
        :param str map_identifier: (required)
        :param str layer_identifier: (required)
        :param str tenant_url_code: (required)
        :return: LayerSearchResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'map_identifier', 'layer_identifier', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method map_search_map_layer" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `map_search_map_layer`")  # noqa: E501
        # verify the required parameter 'map_identifier' is set
        if ('map_identifier' not in params or
                params['map_identifier'] is None):
            raise ValueError("Missing the required parameter `map_identifier` when calling `map_search_map_layer`")  # noqa: E501
        # verify the required parameter 'layer_identifier' is set
        if ('layer_identifier' not in params or
                params['layer_identifier'] is None):
            raise ValueError("Missing the required parameter `layer_identifier` when calling `map_search_map_layer`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `map_search_map_layer`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'map_identifier' in params:
            path_params['mapIdentifier'] = params['map_identifier']  # noqa: E501
        if 'layer_identifier' in params:
            path_params['layerIdentifier'] = params['layer_identifier']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/maps/{mapIdentifier}/layer/{layerIdentifier}/search', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='LayerSearchResult',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def map_share_map(self, body, map_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Shares the map with internal users.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.map_share_map(body, map_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ShareMapParameter body: (required)
        :param str map_identifier: (required)
        :param str tenant_url_code: (required)
        :return: Map
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.map_share_map_with_http_info(body, map_identifier, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.map_share_map_with_http_info(body, map_identifier, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def map_share_map_with_http_info(self, body, map_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Shares the map with internal users.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.map_share_map_with_http_info(body, map_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ShareMapParameter body: (required)
        :param str map_identifier: (required)
        :param str tenant_url_code: (required)
        :return: Map
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'map_identifier', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method map_share_map" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `map_share_map`")  # noqa: E501
        # verify the required parameter 'map_identifier' is set
        if ('map_identifier' not in params or
                params['map_identifier'] is None):
            raise ValueError("Missing the required parameter `map_identifier` when calling `map_share_map`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `map_share_map`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'map_identifier' in params:
            path_params['mapIdentifier'] = params['map_identifier']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/maps/{mapIdentifier}/share', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Map',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def map_share_map_external(self, body, map_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Shares the map with external users. The map is set to public.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.map_share_map_external(body, map_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ShareMapExternalParameter body: (required)
        :param str map_identifier: (required)
        :param str tenant_url_code: (required)
        :return: Map
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.map_share_map_external_with_http_info(body, map_identifier, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.map_share_map_external_with_http_info(body, map_identifier, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def map_share_map_external_with_http_info(self, body, map_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Shares the map with external users. The map is set to public.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.map_share_map_external_with_http_info(body, map_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ShareMapExternalParameter body: (required)
        :param str map_identifier: (required)
        :param str tenant_url_code: (required)
        :return: Map
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'map_identifier', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method map_share_map_external" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `map_share_map_external`")  # noqa: E501
        # verify the required parameter 'map_identifier' is set
        if ('map_identifier' not in params or
                params['map_identifier'] is None):
            raise ValueError("Missing the required parameter `map_identifier` when calling `map_share_map_external`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `map_share_map_external`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'map_identifier' in params:
            path_params['mapIdentifier'] = params['map_identifier']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/maps/{mapIdentifier}/share-external', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Map',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def map_transfer_maps(self, body, tenant_url_code, **kwargs):  # noqa: E501
        """Clones maps from other organizations. Only usable by superadministrators.  # noqa: E501

        `tenantUrlCode` is the destination organization.  The map ids can come from any organization other than the destination organization.  Owner id can be any user from the destination organization (optional).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.map_transfer_maps(body, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TransferMapsParameter body: (required)
        :param str tenant_url_code: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.map_transfer_maps_with_http_info(body, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.map_transfer_maps_with_http_info(body, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def map_transfer_maps_with_http_info(self, body, tenant_url_code, **kwargs):  # noqa: E501
        """Clones maps from other organizations. Only usable by superadministrators.  # noqa: E501

        `tenantUrlCode` is the destination organization.  The map ids can come from any organization other than the destination organization.  Owner id can be any user from the destination organization (optional).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.map_transfer_maps_with_http_info(body, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TransferMapsParameter body: (required)
        :param str tenant_url_code: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method map_transfer_maps" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `map_transfer_maps`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `map_transfer_maps`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/maps/transfer', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def map_update_map(self, body, map_id, tenant_url_code, **kwargs):  # noqa: E501
        """Updates a map properties based on the given parameters.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.map_update_map(body, map_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param MapUpdateParameter body: Parameters used to update the map. (required)
        :param str map_id: Map id or a friendly identifier. (required)
        :param str tenant_url_code: (required)
        :return: Map
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.map_update_map_with_http_info(body, map_id, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.map_update_map_with_http_info(body, map_id, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def map_update_map_with_http_info(self, body, map_id, tenant_url_code, **kwargs):  # noqa: E501
        """Updates a map properties based on the given parameters.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.map_update_map_with_http_info(body, map_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param MapUpdateParameter body: Parameters used to update the map. (required)
        :param str map_id: Map id or a friendly identifier. (required)
        :param str tenant_url_code: (required)
        :return: Map
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'map_id', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method map_update_map" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `map_update_map`")  # noqa: E501
        # verify the required parameter 'map_id' is set
        if ('map_id' not in params or
                params['map_id'] is None):
            raise ValueError("Missing the required parameter `map_id` when calling `map_update_map`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `map_update_map`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'map_id' in params:
            path_params['mapId'] = params['map_id']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/maps/{mapId}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Map',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def map_update_map_advanced_settings(self, body, map_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Updates the map's advanced settings.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.map_update_map_advanced_settings(body, map_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param MapAdvancedSettings body: (required)
        :param str map_identifier: (required)
        :param str tenant_url_code: (required)
        :return: MapAdvancedSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.map_update_map_advanced_settings_with_http_info(body, map_identifier, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.map_update_map_advanced_settings_with_http_info(body, map_identifier, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def map_update_map_advanced_settings_with_http_info(self, body, map_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Updates the map's advanced settings.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.map_update_map_advanced_settings_with_http_info(body, map_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param MapAdvancedSettings body: (required)
        :param str map_identifier: (required)
        :param str tenant_url_code: (required)
        :return: MapAdvancedSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'map_identifier', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method map_update_map_advanced_settings" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `map_update_map_advanced_settings`")  # noqa: E501
        # verify the required parameter 'map_identifier' is set
        if ('map_identifier' not in params or
                params['map_identifier'] is None):
            raise ValueError("Missing the required parameter `map_identifier` when calling `map_update_map_advanced_settings`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `map_update_map_advanced_settings`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'map_identifier' in params:
            path_params['mapIdentifier'] = params['map_identifier']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/maps/{mapIdentifier}/advancedSettings', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MapAdvancedSettings',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def map_update_map_identifier(self, body, map_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Updates the map identifier. Only usable by superadministrators.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.map_update_map_identifier(body, map_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str body: (required)
        :param str map_identifier: (required)
        :param str tenant_url_code: (required)
        :return: Map
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.map_update_map_identifier_with_http_info(body, map_identifier, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.map_update_map_identifier_with_http_info(body, map_identifier, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def map_update_map_identifier_with_http_info(self, body, map_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Updates the map identifier. Only usable by superadministrators.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.map_update_map_identifier_with_http_info(body, map_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str body: (required)
        :param str map_identifier: (required)
        :param str tenant_url_code: (required)
        :return: Map
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'map_identifier', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method map_update_map_identifier" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `map_update_map_identifier`")  # noqa: E501
        # verify the required parameter 'map_identifier' is set
        if ('map_identifier' not in params or
                params['map_identifier'] is None):
            raise ValueError("Missing the required parameter `map_identifier` when calling `map_update_map_identifier`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `map_update_map_identifier`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'map_identifier' in params:
            path_params['mapIdentifier'] = params['map_identifier']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/maps/{mapIdentifier}/identifier', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Map',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def map_update_map_layers(self, body, map_id, tenant_url_code, **kwargs):  # noqa: E501
        """Updates a dynamic map's layers. The map will lose the associations with previous layers that are not included in the list.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.map_update_map_layers(body, map_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[MapLayerParameter] body: (required)
        :param str map_id: (required)
        :param str tenant_url_code: (required)
        :return: MapLayersResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.map_update_map_layers_with_http_info(body, map_id, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.map_update_map_layers_with_http_info(body, map_id, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def map_update_map_layers_with_http_info(self, body, map_id, tenant_url_code, **kwargs):  # noqa: E501
        """Updates a dynamic map's layers. The map will lose the associations with previous layers that are not included in the list.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.map_update_map_layers_with_http_info(body, map_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[MapLayerParameter] body: (required)
        :param str map_id: (required)
        :param str tenant_url_code: (required)
        :return: MapLayersResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'map_id', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method map_update_map_layers" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `map_update_map_layers`")  # noqa: E501
        # verify the required parameter 'map_id' is set
        if ('map_id' not in params or
                params['map_id'] is None):
            raise ValueError("Missing the required parameter `map_id` when calling `map_update_map_layers`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `map_update_map_layers`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'map_id' in params:
            path_params['mapId'] = params['map_id']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/maps/{mapId}/layers', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MapLayersResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def map_update_map_toolbar(self, body, map_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Updates the map's toolbar settings.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.map_update_map_toolbar(body, map_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param MapToolbar body: (required)
        :param str map_identifier: (required)
        :param str tenant_url_code: (required)
        :return: MapToolbar
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.map_update_map_toolbar_with_http_info(body, map_identifier, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.map_update_map_toolbar_with_http_info(body, map_identifier, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def map_update_map_toolbar_with_http_info(self, body, map_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Updates the map's toolbar settings.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.map_update_map_toolbar_with_http_info(body, map_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param MapToolbar body: (required)
        :param str map_identifier: (required)
        :param str tenant_url_code: (required)
        :return: MapToolbar
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'map_identifier', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method map_update_map_toolbar" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `map_update_map_toolbar`")  # noqa: E501
        # verify the required parameter 'map_identifier' is set
        if ('map_identifier' not in params or
                params['map_identifier'] is None):
            raise ValueError("Missing the required parameter `map_identifier` when calling `map_update_map_toolbar`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `map_update_map_toolbar`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'map_identifier' in params:
            path_params['mapIdentifier'] = params['map_identifier']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/maps/{mapIdentifier}/toolbar', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MapToolbar',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def map_update_thumbnail(self, map_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Updates the map thumbnail.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.map_update_thumbnail(map_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str map_identifier: (required)
        :param str tenant_url_code: (required)
        :param str file:
        :return: Map
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.map_update_thumbnail_with_http_info(map_identifier, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.map_update_thumbnail_with_http_info(map_identifier, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def map_update_thumbnail_with_http_info(self, map_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Updates the map thumbnail.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.map_update_thumbnail_with_http_info(map_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str map_identifier: (required)
        :param str tenant_url_code: (required)
        :param str file:
        :return: Map
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['map_identifier', 'tenant_url_code', 'file']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method map_update_thumbnail" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'map_identifier' is set
        if ('map_identifier' not in params or
                params['map_identifier'] is None):
            raise ValueError("Missing the required parameter `map_identifier` when calling `map_update_thumbnail`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `map_update_thumbnail`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'map_identifier' in params:
            path_params['mapIdentifier'] = params['map_identifier']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'file' in params:
            local_var_files['file'] = params['file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/maps/{mapIdentifier}/thumbnail', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Map',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
