# coding: utf-8

"""
    CartoVista REST API

    No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)  # noqa: E501

    OpenAPI spec version: 2.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from add_to_cartovista.swagger_client.api_client import ApiClient


class LocationApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def location_geocode(self, address, options, tenant_url_code, **kwargs):  # noqa: E501
        """Gets a list of locations matching the address. The address can be in `lat,long` format.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.location_geocode(address, options, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str address: (required)
        :param str options: (required)
        :param str tenant_url_code: (required)
        :return: list[GeocodedLocation]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.location_geocode_with_http_info(address, options, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.location_geocode_with_http_info(address, options, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def location_geocode_with_http_info(self, address, options, tenant_url_code, **kwargs):  # noqa: E501
        """Gets a list of locations matching the address. The address can be in `lat,long` format.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.location_geocode_with_http_info(address, options, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str address: (required)
        :param str options: (required)
        :param str tenant_url_code: (required)
        :return: list[GeocodedLocation]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['address', 'options', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method location_geocode" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'address' is set
        if ('address' not in params or
                params['address'] is None):
            raise ValueError("Missing the required parameter `address` when calling `location_geocode`")  # noqa: E501
        # verify the required parameter 'options' is set
        if ('options' not in params or
                params['options'] is None):
            raise ValueError("Missing the required parameter `options` when calling `location_geocode`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `location_geocode`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'address' in params:
            path_params['address'] = params['address']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []
        if 'options' in params:
            query_params.append(('Options', params['options']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/Location/geocode/{address}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[GeocodedLocation]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def location_get_directions(self, body, tenant_url_code, **kwargs):  # noqa: E501
        """Gets a list of itineraries (geometry and steps) between two points.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.location_get_directions(body, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DirectionParams body: (required)
        :param str tenant_url_code: (required)
        :return: list[RouteSummary]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.location_get_directions_with_http_info(body, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.location_get_directions_with_http_info(body, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def location_get_directions_with_http_info(self, body, tenant_url_code, **kwargs):  # noqa: E501
        """Gets a list of itineraries (geometry and steps) between two points.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.location_get_directions_with_http_info(body, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DirectionParams body: (required)
        :param str tenant_url_code: (required)
        :return: list[RouteSummary]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method location_get_directions" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `location_get_directions`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `location_get_directions`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/Location/route/directions', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[RouteSummary]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def location_get_route_summary(self, origin_latitude, origin_longitude, destination_latitude, destination_longitude, mode, departure, traffic, viewer_readable_coordinates, tenant_url_code, **kwargs):  # noqa: E501
        """Gets an itinerary (geometry and steps) between two points.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.location_get_route_summary(origin_latitude, origin_longitude, destination_latitude, destination_longitude, mode, departure, traffic, viewer_readable_coordinates, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param float origin_latitude: (required)
        :param float origin_longitude: (required)
        :param float destination_latitude: (required)
        :param float destination_longitude: (required)
        :param str mode: (required)
        :param str departure: (required)
        :param bool traffic: (required)
        :param bool viewer_readable_coordinates: (required)
        :param str tenant_url_code: (required)
        :return: RouteSummary
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.location_get_route_summary_with_http_info(origin_latitude, origin_longitude, destination_latitude, destination_longitude, mode, departure, traffic, viewer_readable_coordinates, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.location_get_route_summary_with_http_info(origin_latitude, origin_longitude, destination_latitude, destination_longitude, mode, departure, traffic, viewer_readable_coordinates, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def location_get_route_summary_with_http_info(self, origin_latitude, origin_longitude, destination_latitude, destination_longitude, mode, departure, traffic, viewer_readable_coordinates, tenant_url_code, **kwargs):  # noqa: E501
        """Gets an itinerary (geometry and steps) between two points.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.location_get_route_summary_with_http_info(origin_latitude, origin_longitude, destination_latitude, destination_longitude, mode, departure, traffic, viewer_readable_coordinates, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param float origin_latitude: (required)
        :param float origin_longitude: (required)
        :param float destination_latitude: (required)
        :param float destination_longitude: (required)
        :param str mode: (required)
        :param str departure: (required)
        :param bool traffic: (required)
        :param bool viewer_readable_coordinates: (required)
        :param str tenant_url_code: (required)
        :return: RouteSummary
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['origin_latitude', 'origin_longitude', 'destination_latitude', 'destination_longitude', 'mode', 'departure', 'traffic', 'viewer_readable_coordinates', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method location_get_route_summary" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'origin_latitude' is set
        if ('origin_latitude' not in params or
                params['origin_latitude'] is None):
            raise ValueError("Missing the required parameter `origin_latitude` when calling `location_get_route_summary`")  # noqa: E501
        # verify the required parameter 'origin_longitude' is set
        if ('origin_longitude' not in params or
                params['origin_longitude'] is None):
            raise ValueError("Missing the required parameter `origin_longitude` when calling `location_get_route_summary`")  # noqa: E501
        # verify the required parameter 'destination_latitude' is set
        if ('destination_latitude' not in params or
                params['destination_latitude'] is None):
            raise ValueError("Missing the required parameter `destination_latitude` when calling `location_get_route_summary`")  # noqa: E501
        # verify the required parameter 'destination_longitude' is set
        if ('destination_longitude' not in params or
                params['destination_longitude'] is None):
            raise ValueError("Missing the required parameter `destination_longitude` when calling `location_get_route_summary`")  # noqa: E501
        # verify the required parameter 'mode' is set
        if ('mode' not in params or
                params['mode'] is None):
            raise ValueError("Missing the required parameter `mode` when calling `location_get_route_summary`")  # noqa: E501
        # verify the required parameter 'departure' is set
        if ('departure' not in params or
                params['departure'] is None):
            raise ValueError("Missing the required parameter `departure` when calling `location_get_route_summary`")  # noqa: E501
        # verify the required parameter 'traffic' is set
        if ('traffic' not in params or
                params['traffic'] is None):
            raise ValueError("Missing the required parameter `traffic` when calling `location_get_route_summary`")  # noqa: E501
        # verify the required parameter 'viewer_readable_coordinates' is set
        if ('viewer_readable_coordinates' not in params or
                params['viewer_readable_coordinates'] is None):
            raise ValueError("Missing the required parameter `viewer_readable_coordinates` when calling `location_get_route_summary`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `location_get_route_summary`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []
        if 'origin_latitude' in params:
            query_params.append(('OriginLatitude', params['origin_latitude']))  # noqa: E501
        if 'origin_longitude' in params:
            query_params.append(('OriginLongitude', params['origin_longitude']))  # noqa: E501
        if 'destination_latitude' in params:
            query_params.append(('DestinationLatitude', params['destination_latitude']))  # noqa: E501
        if 'destination_longitude' in params:
            query_params.append(('DestinationLongitude', params['destination_longitude']))  # noqa: E501
        if 'mode' in params:
            query_params.append(('Mode', params['mode']))  # noqa: E501
        if 'departure' in params:
            query_params.append(('Departure', params['departure']))  # noqa: E501
        if 'traffic' in params:
            query_params.append(('Traffic', params['traffic']))  # noqa: E501
        if 'viewer_readable_coordinates' in params:
            query_params.append(('ViewerReadableCoordinates', params['viewer_readable_coordinates']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/Location/route/summary', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RouteSummary',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def location_get_route_summary_with_stops(self, body, tenant_url_code, **kwargs):  # noqa: E501
        """Gets an itinerary (geometry and steps) between two points with additional stops.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.location_get_route_summary_with_stops(body, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RouteWithStopsParams body: (required)
        :param str tenant_url_code: (required)
        :return: RouteSummary
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.location_get_route_summary_with_stops_with_http_info(body, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.location_get_route_summary_with_stops_with_http_info(body, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def location_get_route_summary_with_stops_with_http_info(self, body, tenant_url_code, **kwargs):  # noqa: E501
        """Gets an itinerary (geometry and steps) between two points with additional stops.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.location_get_route_summary_with_stops_with_http_info(body, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RouteWithStopsParams body: (required)
        :param str tenant_url_code: (required)
        :return: RouteSummary
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method location_get_route_summary_with_stops" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `location_get_route_summary_with_stops`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `location_get_route_summary_with_stops`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/Location/route/summary/stops', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RouteSummary',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def location_isochrone(self, body, tenant_url_code, **kwargs):  # noqa: E501
        """Generates a travel time isochrone.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.location_isochrone(body, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param IsochroneParams body: (required)
        :param str tenant_url_code: (required)
        :return: Isochrone
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.location_isochrone_with_http_info(body, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.location_isochrone_with_http_info(body, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def location_isochrone_with_http_info(self, body, tenant_url_code, **kwargs):  # noqa: E501
        """Generates a travel time isochrone.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.location_isochrone_with_http_info(body, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param IsochroneParams body: (required)
        :param str tenant_url_code: (required)
        :return: Isochrone
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method location_isochrone" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `location_isochrone`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `location_isochrone`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/Location/isochrone', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Isochrone',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def location_reverse_geocode(self, body, tenant_url_code, **kwargs):  # noqa: E501
        """Gets a list of locations from a pair coordinates.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.location_reverse_geocode(body, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ReverseGeocodeParams body: (required)
        :param str tenant_url_code: (required)
        :return: list[GeocodedLocation]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.location_reverse_geocode_with_http_info(body, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.location_reverse_geocode_with_http_info(body, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def location_reverse_geocode_with_http_info(self, body, tenant_url_code, **kwargs):  # noqa: E501
        """Gets a list of locations from a pair coordinates.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.location_reverse_geocode_with_http_info(body, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ReverseGeocodeParams body: (required)
        :param str tenant_url_code: (required)
        :return: list[GeocodedLocation]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method location_reverse_geocode" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `location_reverse_geocode`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `location_reverse_geocode`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/Location/reversegeocode', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[GeocodedLocation]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
