# coding: utf-8

"""
    CartoVista REST API

    No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)  # noqa: E501

    OpenAPI spec version: 2.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from add_to_cartovista.swagger_client.api_client import ApiClient


class GridLayerApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def grid_layer_add_grid_source(self, body, grid_layer_id, tenant_url_code, **kwargs):  # noqa: E501
        """Add a grid source to an existing grid layer.  Use /Portal/upload and /Portal/upload/.../definition APIs to upload a geotiff file and get it's definition prior to use this API.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.grid_layer_add_grid_source(body, grid_layer_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FlatFileGridLayerDefinitionDTO body: The grid layer definition to use for the new grid source. (required)
        :param str grid_layer_id: The grid layer system identifier. (required)
        :param str tenant_url_code: (required)
        :return: GridSource
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.grid_layer_add_grid_source_with_http_info(body, grid_layer_id, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.grid_layer_add_grid_source_with_http_info(body, grid_layer_id, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def grid_layer_add_grid_source_with_http_info(self, body, grid_layer_id, tenant_url_code, **kwargs):  # noqa: E501
        """Add a grid source to an existing grid layer.  Use /Portal/upload and /Portal/upload/.../definition APIs to upload a geotiff file and get it's definition prior to use this API.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.grid_layer_add_grid_source_with_http_info(body, grid_layer_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FlatFileGridLayerDefinitionDTO body: The grid layer definition to use for the new grid source. (required)
        :param str grid_layer_id: The grid layer system identifier. (required)
        :param str tenant_url_code: (required)
        :return: GridSource
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'grid_layer_id', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method grid_layer_add_grid_source" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `grid_layer_add_grid_source`")  # noqa: E501
        # verify the required parameter 'grid_layer_id' is set
        if ('grid_layer_id' not in params or
                params['grid_layer_id'] is None):
            raise ValueError("Missing the required parameter `grid_layer_id` when calling `grid_layer_add_grid_source`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `grid_layer_add_grid_source`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'grid_layer_id' in params:
            path_params['gridLayerId'] = params['grid_layer_id']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/GridLayer/{gridLayerId}/GridSources', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GridSource',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def grid_layer_add_grid_sources(self, grid_layer_id, tenant_url_code, **kwargs):  # noqa: E501
        """Add all the bands from a tif file to an existing grid layer as distinct grid sources. If the grid layer is an RGB layer and the file has the required bands, a single RGB grid source will be added instead.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.grid_layer_add_grid_sources(grid_layer_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str grid_layer_id: The grid layer system identifier. (required)
        :param str tenant_url_code: (required)
        :param str file:
        :return: list[GridSource]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.grid_layer_add_grid_sources_with_http_info(grid_layer_id, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.grid_layer_add_grid_sources_with_http_info(grid_layer_id, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def grid_layer_add_grid_sources_with_http_info(self, grid_layer_id, tenant_url_code, **kwargs):  # noqa: E501
        """Add all the bands from a tif file to an existing grid layer as distinct grid sources. If the grid layer is an RGB layer and the file has the required bands, a single RGB grid source will be added instead.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.grid_layer_add_grid_sources_with_http_info(grid_layer_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str grid_layer_id: The grid layer system identifier. (required)
        :param str tenant_url_code: (required)
        :param str file:
        :return: list[GridSource]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['grid_layer_id', 'tenant_url_code', 'file']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method grid_layer_add_grid_sources" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'grid_layer_id' is set
        if ('grid_layer_id' not in params or
                params['grid_layer_id'] is None):
            raise ValueError("Missing the required parameter `grid_layer_id` when calling `grid_layer_add_grid_sources`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `grid_layer_add_grid_sources`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'grid_layer_id' in params:
            path_params['gridLayerId'] = params['grid_layer_id']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'file' in params:
            local_var_files['file'] = params['file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/GridLayer/{gridLayerId}/GridSources/all', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[GridSource]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def grid_layer_create_grid_layer(self, body, tenant_url_code, **kwargs):  # noqa: E501
        """Create a grid layer with the specified parameters.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.grid_layer_create_grid_layer(body, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param GridLayerCreateParameters body: The parameters used to create the grid layer. (required)
        :param str tenant_url_code: (required)
        :return: GridLayer
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.grid_layer_create_grid_layer_with_http_info(body, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.grid_layer_create_grid_layer_with_http_info(body, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def grid_layer_create_grid_layer_with_http_info(self, body, tenant_url_code, **kwargs):  # noqa: E501
        """Create a grid layer with the specified parameters.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.grid_layer_create_grid_layer_with_http_info(body, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param GridLayerCreateParameters body: The parameters used to create the grid layer. (required)
        :param str tenant_url_code: (required)
        :return: GridLayer
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method grid_layer_create_grid_layer" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `grid_layer_create_grid_layer`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `grid_layer_create_grid_layer`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/GridLayer', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GridLayer',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def grid_layer_delete_grid_layer(self, grid_layer_id, tenant_url_code, **kwargs):  # noqa: E501
        """Delete an existing grid layer.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.grid_layer_delete_grid_layer(grid_layer_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str grid_layer_id: The grid layer system identifier. (required)
        :param str tenant_url_code: (required)
        :return: DeleteGridLayerResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.grid_layer_delete_grid_layer_with_http_info(grid_layer_id, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.grid_layer_delete_grid_layer_with_http_info(grid_layer_id, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def grid_layer_delete_grid_layer_with_http_info(self, grid_layer_id, tenant_url_code, **kwargs):  # noqa: E501
        """Delete an existing grid layer.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.grid_layer_delete_grid_layer_with_http_info(grid_layer_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str grid_layer_id: The grid layer system identifier. (required)
        :param str tenant_url_code: (required)
        :return: DeleteGridLayerResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['grid_layer_id', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method grid_layer_delete_grid_layer" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'grid_layer_id' is set
        if ('grid_layer_id' not in params or
                params['grid_layer_id'] is None):
            raise ValueError("Missing the required parameter `grid_layer_id` when calling `grid_layer_delete_grid_layer`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `grid_layer_delete_grid_layer`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'grid_layer_id' in params:
            path_params['gridLayerId'] = params['grid_layer_id']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/GridLayer/{gridLayerId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DeleteGridLayerResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def grid_layer_delete_grid_source(self, body, grid_layer_id, grid_source_id, tenant_url_code, **kwargs):  # noqa: E501
        """Delete an existing grid source.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.grid_layer_delete_grid_source(body, grid_layer_id, grid_source_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DeleteGridSourceParameter body: Additional parameters (required)
        :param str grid_layer_id: The grid layer system identifier. (required)
        :param str grid_source_id: The grid source system identifier. (required)
        :param str tenant_url_code: (required)
        :return: DeleteGridSourceResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.grid_layer_delete_grid_source_with_http_info(body, grid_layer_id, grid_source_id, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.grid_layer_delete_grid_source_with_http_info(body, grid_layer_id, grid_source_id, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def grid_layer_delete_grid_source_with_http_info(self, body, grid_layer_id, grid_source_id, tenant_url_code, **kwargs):  # noqa: E501
        """Delete an existing grid source.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.grid_layer_delete_grid_source_with_http_info(body, grid_layer_id, grid_source_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DeleteGridSourceParameter body: Additional parameters (required)
        :param str grid_layer_id: The grid layer system identifier. (required)
        :param str grid_source_id: The grid source system identifier. (required)
        :param str tenant_url_code: (required)
        :return: DeleteGridSourceResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'grid_layer_id', 'grid_source_id', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method grid_layer_delete_grid_source" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `grid_layer_delete_grid_source`")  # noqa: E501
        # verify the required parameter 'grid_layer_id' is set
        if ('grid_layer_id' not in params or
                params['grid_layer_id'] is None):
            raise ValueError("Missing the required parameter `grid_layer_id` when calling `grid_layer_delete_grid_source`")  # noqa: E501
        # verify the required parameter 'grid_source_id' is set
        if ('grid_source_id' not in params or
                params['grid_source_id'] is None):
            raise ValueError("Missing the required parameter `grid_source_id` when calling `grid_layer_delete_grid_source`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `grid_layer_delete_grid_source`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'grid_layer_id' in params:
            path_params['gridLayerId'] = params['grid_layer_id']  # noqa: E501
        if 'grid_source_id' in params:
            path_params['gridSourceId'] = params['grid_source_id']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/GridLayer/{gridLayerId}/GridSources/{gridSourceId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DeleteGridSourceResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def grid_layer_export_grid_source_subset(self, body, grid_layer_id, grid_source_id, tenant_url_code, **kwargs):  # noqa: E501
        """Exports a subset of the grid source. The file can be downloaded with `DownloadFile/download`.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.grid_layer_export_grid_source_subset(body, grid_layer_id, grid_source_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str body: (required)
        :param str grid_layer_id: (required)
        :param str grid_source_id: (required)
        :param str tenant_url_code: (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.grid_layer_export_grid_source_subset_with_http_info(body, grid_layer_id, grid_source_id, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.grid_layer_export_grid_source_subset_with_http_info(body, grid_layer_id, grid_source_id, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def grid_layer_export_grid_source_subset_with_http_info(self, body, grid_layer_id, grid_source_id, tenant_url_code, **kwargs):  # noqa: E501
        """Exports a subset of the grid source. The file can be downloaded with `DownloadFile/download`.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.grid_layer_export_grid_source_subset_with_http_info(body, grid_layer_id, grid_source_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str body: (required)
        :param str grid_layer_id: (required)
        :param str grid_source_id: (required)
        :param str tenant_url_code: (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'grid_layer_id', 'grid_source_id', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method grid_layer_export_grid_source_subset" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `grid_layer_export_grid_source_subset`")  # noqa: E501
        # verify the required parameter 'grid_layer_id' is set
        if ('grid_layer_id' not in params or
                params['grid_layer_id'] is None):
            raise ValueError("Missing the required parameter `grid_layer_id` when calling `grid_layer_export_grid_source_subset`")  # noqa: E501
        # verify the required parameter 'grid_source_id' is set
        if ('grid_source_id' not in params or
                params['grid_source_id'] is None):
            raise ValueError("Missing the required parameter `grid_source_id` when calling `grid_layer_export_grid_source_subset`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `grid_layer_export_grid_source_subset`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'grid_layer_id' in params:
            path_params['gridLayerId'] = params['grid_layer_id']  # noqa: E501
        if 'grid_source_id' in params:
            path_params['gridSourceId'] = params['grid_source_id']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/GridLayer/{gridLayerId}/GridSources/{gridSourceId}/subset', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def grid_layer_get_first_grid_source_extents(self, body, tenant_url_code, **kwargs):  # noqa: E501
        """Gets the extents of the first grid source of each layer.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.grid_layer_get_first_grid_source_extents(body, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[str] body: (required)
        :param str tenant_url_code: (required)
        :return: list[ExtentDTO]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.grid_layer_get_first_grid_source_extents_with_http_info(body, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.grid_layer_get_first_grid_source_extents_with_http_info(body, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def grid_layer_get_first_grid_source_extents_with_http_info(self, body, tenant_url_code, **kwargs):  # noqa: E501
        """Gets the extents of the first grid source of each layer.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.grid_layer_get_first_grid_source_extents_with_http_info(body, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[str] body: (required)
        :param str tenant_url_code: (required)
        :return: list[ExtentDTO]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method grid_layer_get_first_grid_source_extents" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `grid_layer_get_first_grid_source_extents`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `grid_layer_get_first_grid_source_extents`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/GridLayer/firstGridSourceExtents', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[ExtentDTO]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def grid_layer_get_grid_layer_by_id(self, grid_layer_id, tenant_url_code, **kwargs):  # noqa: E501
        """Get a grid layer by identifier.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.grid_layer_get_grid_layer_by_id(grid_layer_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str grid_layer_id: The grid layer system identifier. (required)
        :param str tenant_url_code: (required)
        :return: GridLayer
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.grid_layer_get_grid_layer_by_id_with_http_info(grid_layer_id, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.grid_layer_get_grid_layer_by_id_with_http_info(grid_layer_id, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def grid_layer_get_grid_layer_by_id_with_http_info(self, grid_layer_id, tenant_url_code, **kwargs):  # noqa: E501
        """Get a grid layer by identifier.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.grid_layer_get_grid_layer_by_id_with_http_info(grid_layer_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str grid_layer_id: The grid layer system identifier. (required)
        :param str tenant_url_code: (required)
        :return: GridLayer
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['grid_layer_id', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method grid_layer_get_grid_layer_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'grid_layer_id' is set
        if ('grid_layer_id' not in params or
                params['grid_layer_id'] is None):
            raise ValueError("Missing the required parameter `grid_layer_id` when calling `grid_layer_get_grid_layer_by_id`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `grid_layer_get_grid_layer_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'grid_layer_id' in params:
            path_params['gridLayerId'] = params['grid_layer_id']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/GridLayer/{gridLayerId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GridLayer',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def grid_layer_get_grid_layer_details(self, grid_layer_id, tenant_url_code, **kwargs):  # noqa: E501
        """Gets the grid layer, its grid sources, related maps and settings.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.grid_layer_get_grid_layer_details(grid_layer_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str grid_layer_id: (required)
        :param str tenant_url_code: (required)
        :return: GridLayerWithDetails
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.grid_layer_get_grid_layer_details_with_http_info(grid_layer_id, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.grid_layer_get_grid_layer_details_with_http_info(grid_layer_id, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def grid_layer_get_grid_layer_details_with_http_info(self, grid_layer_id, tenant_url_code, **kwargs):  # noqa: E501
        """Gets the grid layer, its grid sources, related maps and settings.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.grid_layer_get_grid_layer_details_with_http_info(grid_layer_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str grid_layer_id: (required)
        :param str tenant_url_code: (required)
        :return: GridLayerWithDetails
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['grid_layer_id', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method grid_layer_get_grid_layer_details" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'grid_layer_id' is set
        if ('grid_layer_id' not in params or
                params['grid_layer_id'] is None):
            raise ValueError("Missing the required parameter `grid_layer_id` when calling `grid_layer_get_grid_layer_details`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `grid_layer_get_grid_layer_details`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'grid_layer_id' in params:
            path_params['gridLayerId'] = params['grid_layer_id']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/GridLayer/{gridLayerId}/details', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GridLayerWithDetails',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def grid_layer_get_grid_layers(self, tenant_url_code, **kwargs):  # noqa: E501
        """Get the list of all grid layers.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.grid_layer_get_grid_layers(tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str tenant_url_code: (required)
        :return: list[GridLayer]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.grid_layer_get_grid_layers_with_http_info(tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.grid_layer_get_grid_layers_with_http_info(tenant_url_code, **kwargs)  # noqa: E501
            return data

    def grid_layer_get_grid_layers_with_http_info(self, tenant_url_code, **kwargs):  # noqa: E501
        """Get the list of all grid layers.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.grid_layer_get_grid_layers_with_http_info(tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str tenant_url_code: (required)
        :return: list[GridLayer]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method grid_layer_get_grid_layers" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `grid_layer_get_grid_layers`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/GridLayers', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[GridLayer]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def grid_layer_get_grid_source(self, grid_layer_id, grid_source_id, tenant_url_code, **kwargs):  # noqa: E501
        """Get a grid source by identifier.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.grid_layer_get_grid_source(grid_layer_id, grid_source_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str grid_layer_id: The grid layer system identifier. (required)
        :param str grid_source_id: The grid source system identifier. (required)
        :param str tenant_url_code: (required)
        :return: GridSource
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.grid_layer_get_grid_source_with_http_info(grid_layer_id, grid_source_id, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.grid_layer_get_grid_source_with_http_info(grid_layer_id, grid_source_id, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def grid_layer_get_grid_source_with_http_info(self, grid_layer_id, grid_source_id, tenant_url_code, **kwargs):  # noqa: E501
        """Get a grid source by identifier.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.grid_layer_get_grid_source_with_http_info(grid_layer_id, grid_source_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str grid_layer_id: The grid layer system identifier. (required)
        :param str grid_source_id: The grid source system identifier. (required)
        :param str tenant_url_code: (required)
        :return: GridSource
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['grid_layer_id', 'grid_source_id', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method grid_layer_get_grid_source" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'grid_layer_id' is set
        if ('grid_layer_id' not in params or
                params['grid_layer_id'] is None):
            raise ValueError("Missing the required parameter `grid_layer_id` when calling `grid_layer_get_grid_source`")  # noqa: E501
        # verify the required parameter 'grid_source_id' is set
        if ('grid_source_id' not in params or
                params['grid_source_id'] is None):
            raise ValueError("Missing the required parameter `grid_source_id` when calling `grid_layer_get_grid_source`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `grid_layer_get_grid_source`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'grid_layer_id' in params:
            path_params['gridLayerId'] = params['grid_layer_id']  # noqa: E501
        if 'grid_source_id' in params:
            path_params['gridSourceId'] = params['grid_source_id']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/GridLayer/{gridLayerId}/GridSources/{gridSourceId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GridSource',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def grid_layer_get_grid_sources_for_grid_layer(self, grid_layer_id, tenant_url_code, **kwargs):  # noqa: E501
        """Get all the grid sources associated with the grid layer.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.grid_layer_get_grid_sources_for_grid_layer(grid_layer_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str grid_layer_id: The grid layer system identifier. (required)
        :param str tenant_url_code: (required)
        :return: list[GridSource]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.grid_layer_get_grid_sources_for_grid_layer_with_http_info(grid_layer_id, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.grid_layer_get_grid_sources_for_grid_layer_with_http_info(grid_layer_id, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def grid_layer_get_grid_sources_for_grid_layer_with_http_info(self, grid_layer_id, tenant_url_code, **kwargs):  # noqa: E501
        """Get all the grid sources associated with the grid layer.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.grid_layer_get_grid_sources_for_grid_layer_with_http_info(grid_layer_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str grid_layer_id: The grid layer system identifier. (required)
        :param str tenant_url_code: (required)
        :return: list[GridSource]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['grid_layer_id', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method grid_layer_get_grid_sources_for_grid_layer" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'grid_layer_id' is set
        if ('grid_layer_id' not in params or
                params['grid_layer_id'] is None):
            raise ValueError("Missing the required parameter `grid_layer_id` when calling `grid_layer_get_grid_sources_for_grid_layer`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `grid_layer_get_grid_sources_for_grid_layer`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'grid_layer_id' in params:
            path_params['gridLayerId'] = params['grid_layer_id']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/GridLayer/{gridLayerId}/GridSources', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[GridSource]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def grid_layer_get_maps_by_grid_layer(self, grid_layer_id, tenant_url_code, **kwargs):  # noqa: E501
        """Gets all the maps that use the grid layer.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.grid_layer_get_maps_by_grid_layer(grid_layer_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str grid_layer_id: (required)
        :param str tenant_url_code: (required)
        :return: list[Map]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.grid_layer_get_maps_by_grid_layer_with_http_info(grid_layer_id, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.grid_layer_get_maps_by_grid_layer_with_http_info(grid_layer_id, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def grid_layer_get_maps_by_grid_layer_with_http_info(self, grid_layer_id, tenant_url_code, **kwargs):  # noqa: E501
        """Gets all the maps that use the grid layer.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.grid_layer_get_maps_by_grid_layer_with_http_info(grid_layer_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str grid_layer_id: (required)
        :param str tenant_url_code: (required)
        :return: list[Map]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['grid_layer_id', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method grid_layer_get_maps_by_grid_layer" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'grid_layer_id' is set
        if ('grid_layer_id' not in params or
                params['grid_layer_id'] is None):
            raise ValueError("Missing the required parameter `grid_layer_id` when calling `grid_layer_get_maps_by_grid_layer`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `grid_layer_get_maps_by_grid_layer`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'grid_layer_id' in params:
            path_params['gridLayerId'] = params['grid_layer_id']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/GridLayer/{gridLayerId}/maps', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Map]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def grid_layer_update_grid_layer(self, body, grid_layer_id, tenant_url_code, **kwargs):  # noqa: E501
        """Update the properties of an existing grid layer.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.grid_layer_update_grid_layer(body, grid_layer_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param GridLayerUpdateParameters body: The parameters to update. (required)
        :param str grid_layer_id: The grid layer system identifier. (required)
        :param str tenant_url_code: (required)
        :return: GridLayer
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.grid_layer_update_grid_layer_with_http_info(body, grid_layer_id, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.grid_layer_update_grid_layer_with_http_info(body, grid_layer_id, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def grid_layer_update_grid_layer_with_http_info(self, body, grid_layer_id, tenant_url_code, **kwargs):  # noqa: E501
        """Update the properties of an existing grid layer.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.grid_layer_update_grid_layer_with_http_info(body, grid_layer_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param GridLayerUpdateParameters body: The parameters to update. (required)
        :param str grid_layer_id: The grid layer system identifier. (required)
        :param str tenant_url_code: (required)
        :return: GridLayer
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'grid_layer_id', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method grid_layer_update_grid_layer" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `grid_layer_update_grid_layer`")  # noqa: E501
        # verify the required parameter 'grid_layer_id' is set
        if ('grid_layer_id' not in params or
                params['grid_layer_id'] is None):
            raise ValueError("Missing the required parameter `grid_layer_id` when calling `grid_layer_update_grid_layer`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `grid_layer_update_grid_layer`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'grid_layer_id' in params:
            path_params['gridLayerId'] = params['grid_layer_id']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/GridLayer/{gridLayerId}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GridLayer',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def grid_layer_update_grid_layer_permissions(self, body, identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Updates the grid layer's permissions.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.grid_layer_update_grid_layer_permissions(body, identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ApplyGenericPermissionsParameter body: (required)
        :param str identifier: (required)
        :param str tenant_url_code: (required)
        :return: list[PermissionPairComplexDTO]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.grid_layer_update_grid_layer_permissions_with_http_info(body, identifier, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.grid_layer_update_grid_layer_permissions_with_http_info(body, identifier, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def grid_layer_update_grid_layer_permissions_with_http_info(self, body, identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Updates the grid layer's permissions.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.grid_layer_update_grid_layer_permissions_with_http_info(body, identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ApplyGenericPermissionsParameter body: (required)
        :param str identifier: (required)
        :param str tenant_url_code: (required)
        :return: list[PermissionPairComplexDTO]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'identifier', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method grid_layer_update_grid_layer_permissions" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `grid_layer_update_grid_layer_permissions`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `grid_layer_update_grid_layer_permissions`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `grid_layer_update_grid_layer_permissions`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/GridLayer/{identifier}/permissions', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[PermissionPairComplexDTO]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def grid_layer_update_grid_source(self, body, grid_layer_id, grid_source_id, tenant_url_code, **kwargs):  # noqa: E501
        """Update the properties of an existing grid source.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.grid_layer_update_grid_source(body, grid_layer_id, grid_source_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param GridSourceUpdateParameters body: The parameters to update. (required)
        :param str grid_layer_id: The grid layer system identifier. (required)
        :param str grid_source_id: The grid source system identifier. (required)
        :param str tenant_url_code: (required)
        :return: GridSource
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.grid_layer_update_grid_source_with_http_info(body, grid_layer_id, grid_source_id, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.grid_layer_update_grid_source_with_http_info(body, grid_layer_id, grid_source_id, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def grid_layer_update_grid_source_with_http_info(self, body, grid_layer_id, grid_source_id, tenant_url_code, **kwargs):  # noqa: E501
        """Update the properties of an existing grid source.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.grid_layer_update_grid_source_with_http_info(body, grid_layer_id, grid_source_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param GridSourceUpdateParameters body: The parameters to update. (required)
        :param str grid_layer_id: The grid layer system identifier. (required)
        :param str grid_source_id: The grid source system identifier. (required)
        :param str tenant_url_code: (required)
        :return: GridSource
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'grid_layer_id', 'grid_source_id', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method grid_layer_update_grid_source" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `grid_layer_update_grid_source`")  # noqa: E501
        # verify the required parameter 'grid_layer_id' is set
        if ('grid_layer_id' not in params or
                params['grid_layer_id'] is None):
            raise ValueError("Missing the required parameter `grid_layer_id` when calling `grid_layer_update_grid_source`")  # noqa: E501
        # verify the required parameter 'grid_source_id' is set
        if ('grid_source_id' not in params or
                params['grid_source_id'] is None):
            raise ValueError("Missing the required parameter `grid_source_id` when calling `grid_layer_update_grid_source`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `grid_layer_update_grid_source`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'grid_layer_id' in params:
            path_params['gridLayerId'] = params['grid_layer_id']  # noqa: E501
        if 'grid_source_id' in params:
            path_params['gridSourceId'] = params['grid_source_id']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/GridLayer/{gridLayerId}/GridSources/{gridSourceId}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GridSource',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def grid_layer_update_grid_source_geotiff(self, body, grid_layer_id, grid_source_id, tenant_url_code, **kwargs):  # noqa: E501
        """Update the geoTIFF of an existing grid source.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.grid_layer_update_grid_source_geotiff(body, grid_layer_id, grid_source_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FlatFileGridLayerDefinitionDTO body: The grid layer definition to update. (required)
        :param str grid_layer_id: The grid layer system identifier. (required)
        :param str grid_source_id: The grid source system identifier. (required)
        :param str tenant_url_code: (required)
        :return: GridSource
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.grid_layer_update_grid_source_geotiff_with_http_info(body, grid_layer_id, grid_source_id, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.grid_layer_update_grid_source_geotiff_with_http_info(body, grid_layer_id, grid_source_id, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def grid_layer_update_grid_source_geotiff_with_http_info(self, body, grid_layer_id, grid_source_id, tenant_url_code, **kwargs):  # noqa: E501
        """Update the geoTIFF of an existing grid source.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.grid_layer_update_grid_source_geotiff_with_http_info(body, grid_layer_id, grid_source_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FlatFileGridLayerDefinitionDTO body: The grid layer definition to update. (required)
        :param str grid_layer_id: The grid layer system identifier. (required)
        :param str grid_source_id: The grid source system identifier. (required)
        :param str tenant_url_code: (required)
        :return: GridSource
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'grid_layer_id', 'grid_source_id', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method grid_layer_update_grid_source_geotiff" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `grid_layer_update_grid_source_geotiff`")  # noqa: E501
        # verify the required parameter 'grid_layer_id' is set
        if ('grid_layer_id' not in params or
                params['grid_layer_id'] is None):
            raise ValueError("Missing the required parameter `grid_layer_id` when calling `grid_layer_update_grid_source_geotiff`")  # noqa: E501
        # verify the required parameter 'grid_source_id' is set
        if ('grid_source_id' not in params or
                params['grid_source_id'] is None):
            raise ValueError("Missing the required parameter `grid_source_id` when calling `grid_layer_update_grid_source_geotiff`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `grid_layer_update_grid_source_geotiff`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'grid_layer_id' in params:
            path_params['gridLayerId'] = params['grid_layer_id']  # noqa: E501
        if 'grid_source_id' in params:
            path_params['gridSourceId'] = params['grid_source_id']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/GridLayer/{gridLayerId}/GridSources/{gridSourceId}/updateGeotiff', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GridSource',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
