# -*- coding: utf-8 -*
"""
/***************************************************************************
 CartoVistaPlugin
                                 A QGIS plugin
 Create a collaborative CartoVista (cartovista.com) map from QGIS
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2024-05-20
        copyright            : (C) 2024 by CartoVista
        email                : info@cartovista.com
        git sha              : $Format:%H$
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
 This script initializes the plugin, making it known to QGIS.
"""
import sys
import os
# noinspection PyPep8Naming
def classFactory(iface):  # pylint: disable=invalid-name
    
    """
    Load CartoVistaPlugin class from file CartoVistaPlugin.
    :param iface: A QGIS interface instance.
    :type iface: QgsInterface
    """

    try:
        #path = os.path.dirname(__file__)
        #sys.path.append(path)
        from .plugin import CartoVistaPlugin
        return CartoVistaPlugin(iface)

    except Exception as e:
        import traceback
        msg = f"Failed to load CartoVista plugin: {e}"
        print(msg, file=sys.stderr)
        traceback.print_exc()
        # DO NOT return None — raise ImportError so QGIS skips the plugin
        raise ImportError(msg)
    

