# coding: utf-8

"""
    CartoVista REST API

    No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)  # noqa: E501

    OpenAPI spec version: 2.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from add_to_cartovista.swagger_client.api_client import ApiClient


class FeatureApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def feature_create_features_from_geo_json(self, body, layer_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Creates a feature using the provided geometry in GeoJSON format.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.feature_create_features_from_geo_json(body, layer_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[FeatureGeoJSONCreateParameter] body: (required)
        :param str layer_identifier: The layer to query (required)
        :param str tenant_url_code: (required)
        :return: ApiInsertReport
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.feature_create_features_from_geo_json_with_http_info(body, layer_identifier, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.feature_create_features_from_geo_json_with_http_info(body, layer_identifier, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def feature_create_features_from_geo_json_with_http_info(self, body, layer_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Creates a feature using the provided geometry in GeoJSON format.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.feature_create_features_from_geo_json_with_http_info(body, layer_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[FeatureGeoJSONCreateParameter] body: (required)
        :param str layer_identifier: The layer to query (required)
        :param str tenant_url_code: (required)
        :return: ApiInsertReport
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'layer_identifier', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method feature_create_features_from_geo_json" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `feature_create_features_from_geo_json`")  # noqa: E501
        # verify the required parameter 'layer_identifier' is set
        if ('layer_identifier' not in params or
                params['layer_identifier'] is None):
            raise ValueError("Missing the required parameter `layer_identifier` when calling `feature_create_features_from_geo_json`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `feature_create_features_from_geo_json`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'layer_identifier' in params:
            path_params['layerIdentifier'] = params['layer_identifier']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/Layer/{layerIdentifier}/Features/createFromGeoJSON', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiInsertReport',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def feature_create_features_from_long_lat(self, body, layer_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Creates features from the provided latutude and longitude coordinates. The layer must be a point layer. Use \"proj4\": \"+proj=longlat +ellps=WGS84 +datum=WGS84 +no_defs\".  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.feature_create_features_from_long_lat(body, layer_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[FeatureLongLatCreateParameter] body: (required)
        :param str layer_identifier: The layer to query (required)
        :param str tenant_url_code: (required)
        :return: ApiInsertReport
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.feature_create_features_from_long_lat_with_http_info(body, layer_identifier, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.feature_create_features_from_long_lat_with_http_info(body, layer_identifier, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def feature_create_features_from_long_lat_with_http_info(self, body, layer_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Creates features from the provided latutude and longitude coordinates. The layer must be a point layer. Use \"proj4\": \"+proj=longlat +ellps=WGS84 +datum=WGS84 +no_defs\".  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.feature_create_features_from_long_lat_with_http_info(body, layer_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[FeatureLongLatCreateParameter] body: (required)
        :param str layer_identifier: The layer to query (required)
        :param str tenant_url_code: (required)
        :return: ApiInsertReport
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'layer_identifier', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method feature_create_features_from_long_lat" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `feature_create_features_from_long_lat`")  # noqa: E501
        # verify the required parameter 'layer_identifier' is set
        if ('layer_identifier' not in params or
                params['layer_identifier'] is None):
            raise ValueError("Missing the required parameter `layer_identifier` when calling `feature_create_features_from_long_lat`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `feature_create_features_from_long_lat`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'layer_identifier' in params:
            path_params['layerIdentifier'] = params['layer_identifier']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/Layer/{layerIdentifier}/Features/createFromLongLat', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiInsertReport',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def feature_create_features_from_wkt(self, body, layer_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Creates a feature using the provided geometry in WKT format.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.feature_create_features_from_wkt(body, layer_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[FeatureWKTCreateParameter] body: (required)
        :param str layer_identifier: The layer to query (required)
        :param str tenant_url_code: (required)
        :return: ApiInsertReport
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.feature_create_features_from_wkt_with_http_info(body, layer_identifier, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.feature_create_features_from_wkt_with_http_info(body, layer_identifier, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def feature_create_features_from_wkt_with_http_info(self, body, layer_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Creates a feature using the provided geometry in WKT format.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.feature_create_features_from_wkt_with_http_info(body, layer_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[FeatureWKTCreateParameter] body: (required)
        :param str layer_identifier: The layer to query (required)
        :param str tenant_url_code: (required)
        :return: ApiInsertReport
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'layer_identifier', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method feature_create_features_from_wkt" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `feature_create_features_from_wkt`")  # noqa: E501
        # verify the required parameter 'layer_identifier' is set
        if ('layer_identifier' not in params or
                params['layer_identifier'] is None):
            raise ValueError("Missing the required parameter `layer_identifier` when calling `feature_create_features_from_wkt`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `feature_create_features_from_wkt`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'layer_identifier' in params:
            path_params['layerIdentifier'] = params['layer_identifier']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/Layer/{layerIdentifier}/Features/createFromWKT', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiInsertReport',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def feature_create_update_features_from_geo_json(self, body, layer_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Creates a feature or updates it if it already exists with the input geometry in GeoJSON format.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.feature_create_update_features_from_geo_json(body, layer_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[FeatureGeoJSONCreateParameter] body: (required)
        :param str layer_identifier: The layer to query (required)
        :param str tenant_url_code: (required)
        :return: ApiInsertReport
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.feature_create_update_features_from_geo_json_with_http_info(body, layer_identifier, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.feature_create_update_features_from_geo_json_with_http_info(body, layer_identifier, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def feature_create_update_features_from_geo_json_with_http_info(self, body, layer_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Creates a feature or updates it if it already exists with the input geometry in GeoJSON format.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.feature_create_update_features_from_geo_json_with_http_info(body, layer_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[FeatureGeoJSONCreateParameter] body: (required)
        :param str layer_identifier: The layer to query (required)
        :param str tenant_url_code: (required)
        :return: ApiInsertReport
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'layer_identifier', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method feature_create_update_features_from_geo_json" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `feature_create_update_features_from_geo_json`")  # noqa: E501
        # verify the required parameter 'layer_identifier' is set
        if ('layer_identifier' not in params or
                params['layer_identifier'] is None):
            raise ValueError("Missing the required parameter `layer_identifier` when calling `feature_create_update_features_from_geo_json`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `feature_create_update_features_from_geo_json`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'layer_identifier' in params:
            path_params['layerIdentifier'] = params['layer_identifier']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/Layer/{layerIdentifier}/Features/createUpdateFromGeoJSON', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiInsertReport',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def feature_create_update_features_from_long_lat(self, body, layer_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Creates features or update them if they already exist with provided latutude and longitude coordinates. The layer must be a point layer. Use \"proj4\": \"+proj=longlat +ellps=WGS84 +datum=WGS84 +no_defs\".  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.feature_create_update_features_from_long_lat(body, layer_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[FeatureLongLatCreateParameter] body: (required)
        :param str layer_identifier: The layer to query (required)
        :param str tenant_url_code: (required)
        :return: ApiInsertReport
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.feature_create_update_features_from_long_lat_with_http_info(body, layer_identifier, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.feature_create_update_features_from_long_lat_with_http_info(body, layer_identifier, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def feature_create_update_features_from_long_lat_with_http_info(self, body, layer_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Creates features or update them if they already exist with provided latutude and longitude coordinates. The layer must be a point layer. Use \"proj4\": \"+proj=longlat +ellps=WGS84 +datum=WGS84 +no_defs\".  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.feature_create_update_features_from_long_lat_with_http_info(body, layer_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[FeatureLongLatCreateParameter] body: (required)
        :param str layer_identifier: The layer to query (required)
        :param str tenant_url_code: (required)
        :return: ApiInsertReport
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'layer_identifier', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method feature_create_update_features_from_long_lat" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `feature_create_update_features_from_long_lat`")  # noqa: E501
        # verify the required parameter 'layer_identifier' is set
        if ('layer_identifier' not in params or
                params['layer_identifier'] is None):
            raise ValueError("Missing the required parameter `layer_identifier` when calling `feature_create_update_features_from_long_lat`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `feature_create_update_features_from_long_lat`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'layer_identifier' in params:
            path_params['layerIdentifier'] = params['layer_identifier']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/Layer/{layerIdentifier}/Features/createUpdateFromLongLat', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiInsertReport',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def feature_create_update_features_from_wkt(self, body, layer_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Creates a feature or updates it if it already exists with the input geometry in WKT format.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.feature_create_update_features_from_wkt(body, layer_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[FeatureWKTCreateParameter] body: (required)
        :param str layer_identifier: The layer to query (required)
        :param str tenant_url_code: (required)
        :return: ApiCreateUpdateReport
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.feature_create_update_features_from_wkt_with_http_info(body, layer_identifier, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.feature_create_update_features_from_wkt_with_http_info(body, layer_identifier, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def feature_create_update_features_from_wkt_with_http_info(self, body, layer_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Creates a feature or updates it if it already exists with the input geometry in WKT format.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.feature_create_update_features_from_wkt_with_http_info(body, layer_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[FeatureWKTCreateParameter] body: (required)
        :param str layer_identifier: The layer to query (required)
        :param str tenant_url_code: (required)
        :return: ApiCreateUpdateReport
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'layer_identifier', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method feature_create_update_features_from_wkt" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `feature_create_update_features_from_wkt`")  # noqa: E501
        # verify the required parameter 'layer_identifier' is set
        if ('layer_identifier' not in params or
                params['layer_identifier'] is None):
            raise ValueError("Missing the required parameter `layer_identifier` when calling `feature_create_update_features_from_wkt`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `feature_create_update_features_from_wkt`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'layer_identifier' in params:
            path_params['layerIdentifier'] = params['layer_identifier']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/Layer/{layerIdentifier}/Features/createUpdateFromWKT', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiCreateUpdateReport',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def feature_delete_feature(self, layer_identifier, feature_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Deletes a specific feature.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.feature_delete_feature(layer_identifier, feature_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str layer_identifier: The layer to query (required)
        :param str feature_identifier: The feature to query (required)
        :param str tenant_url_code: (required)
        :return: ApiDeleteReport
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.feature_delete_feature_with_http_info(layer_identifier, feature_identifier, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.feature_delete_feature_with_http_info(layer_identifier, feature_identifier, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def feature_delete_feature_with_http_info(self, layer_identifier, feature_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Deletes a specific feature.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.feature_delete_feature_with_http_info(layer_identifier, feature_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str layer_identifier: The layer to query (required)
        :param str feature_identifier: The feature to query (required)
        :param str tenant_url_code: (required)
        :return: ApiDeleteReport
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['layer_identifier', 'feature_identifier', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method feature_delete_feature" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'layer_identifier' is set
        if ('layer_identifier' not in params or
                params['layer_identifier'] is None):
            raise ValueError("Missing the required parameter `layer_identifier` when calling `feature_delete_feature`")  # noqa: E501
        # verify the required parameter 'feature_identifier' is set
        if ('feature_identifier' not in params or
                params['feature_identifier'] is None):
            raise ValueError("Missing the required parameter `feature_identifier` when calling `feature_delete_feature`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `feature_delete_feature`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'layer_identifier' in params:
            path_params['layerIdentifier'] = params['layer_identifier']  # noqa: E501
        if 'feature_identifier' in params:
            path_params['featureIdentifier'] = params['feature_identifier']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/Layer/{layerIdentifier}/Feature/{featureIdentifier}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiDeleteReport',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def feature_delete_features(self, body, layer_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Deletes a set of features. Invalid identifiers are ignored.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.feature_delete_features(body, layer_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[str] body: The features to query (required)
        :param str layer_identifier: The layer to query (required)
        :param str tenant_url_code: (required)
        :return: ApiDeleteReport
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.feature_delete_features_with_http_info(body, layer_identifier, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.feature_delete_features_with_http_info(body, layer_identifier, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def feature_delete_features_with_http_info(self, body, layer_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Deletes a set of features. Invalid identifiers are ignored.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.feature_delete_features_with_http_info(body, layer_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[str] body: The features to query (required)
        :param str layer_identifier: The layer to query (required)
        :param str tenant_url_code: (required)
        :return: ApiDeleteReport
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'layer_identifier', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method feature_delete_features" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `feature_delete_features`")  # noqa: E501
        # verify the required parameter 'layer_identifier' is set
        if ('layer_identifier' not in params or
                params['layer_identifier'] is None):
            raise ValueError("Missing the required parameter `layer_identifier` when calling `feature_delete_features`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `feature_delete_features`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'layer_identifier' in params:
            path_params['layerIdentifier'] = params['layer_identifier']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/Layer/{layerIdentifier}/Features', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiDeleteReport',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def feature_delete_features_by_values(self, body, layer_identifier, column_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Deletes all the features where the column values are included in the list of values.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.feature_delete_features_by_values(body, layer_identifier, column_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[str] body: (required)
        :param str layer_identifier: The layer to query (required)
        :param str column_identifier: The column to query (required)
        :param str tenant_url_code: (required)
        :return: ApiDeleteReport
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.feature_delete_features_by_values_with_http_info(body, layer_identifier, column_identifier, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.feature_delete_features_by_values_with_http_info(body, layer_identifier, column_identifier, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def feature_delete_features_by_values_with_http_info(self, body, layer_identifier, column_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Deletes all the features where the column values are included in the list of values.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.feature_delete_features_by_values_with_http_info(body, layer_identifier, column_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[str] body: (required)
        :param str layer_identifier: The layer to query (required)
        :param str column_identifier: The column to query (required)
        :param str tenant_url_code: (required)
        :return: ApiDeleteReport
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'layer_identifier', 'column_identifier', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method feature_delete_features_by_values" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `feature_delete_features_by_values`")  # noqa: E501
        # verify the required parameter 'layer_identifier' is set
        if ('layer_identifier' not in params or
                params['layer_identifier'] is None):
            raise ValueError("Missing the required parameter `layer_identifier` when calling `feature_delete_features_by_values`")  # noqa: E501
        # verify the required parameter 'column_identifier' is set
        if ('column_identifier' not in params or
                params['column_identifier'] is None):
            raise ValueError("Missing the required parameter `column_identifier` when calling `feature_delete_features_by_values`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `feature_delete_features_by_values`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'layer_identifier' in params:
            path_params['layerIdentifier'] = params['layer_identifier']  # noqa: E501
        if 'column_identifier' in params:
            path_params['columnIdentifier'] = params['column_identifier']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/Layer/{layerIdentifier}/Features/column/{columnIdentifier}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiDeleteReport',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def feature_get_editable_feature_data(self, layer_identifier, feature_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Gets a feature's data including the editable joined tables.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.feature_get_editable_feature_data(layer_identifier, feature_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str layer_identifier: The layer to query (required)
        :param str feature_identifier: The feature to query (required)
        :param str tenant_url_code: (required)
        :return: EditableDataRow
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.feature_get_editable_feature_data_with_http_info(layer_identifier, feature_identifier, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.feature_get_editable_feature_data_with_http_info(layer_identifier, feature_identifier, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def feature_get_editable_feature_data_with_http_info(self, layer_identifier, feature_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Gets a feature's data including the editable joined tables.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.feature_get_editable_feature_data_with_http_info(layer_identifier, feature_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str layer_identifier: The layer to query (required)
        :param str feature_identifier: The feature to query (required)
        :param str tenant_url_code: (required)
        :return: EditableDataRow
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['layer_identifier', 'feature_identifier', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method feature_get_editable_feature_data" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'layer_identifier' is set
        if ('layer_identifier' not in params or
                params['layer_identifier'] is None):
            raise ValueError("Missing the required parameter `layer_identifier` when calling `feature_get_editable_feature_data`")  # noqa: E501
        # verify the required parameter 'feature_identifier' is set
        if ('feature_identifier' not in params or
                params['feature_identifier'] is None):
            raise ValueError("Missing the required parameter `feature_identifier` when calling `feature_get_editable_feature_data`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `feature_get_editable_feature_data`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'layer_identifier' in params:
            path_params['layerIdentifier'] = params['layer_identifier']  # noqa: E501
        if 'feature_identifier' in params:
            path_params['featureIdentifier'] = params['feature_identifier']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/Layer/{layerIdentifier}/Feature/{featureIdentifier}/editable-data', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EditableDataRow',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def feature_get_feature_data(self, layer_identifier, feature_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Gets a feature's data.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.feature_get_feature_data(layer_identifier, feature_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str layer_identifier: The layer to query (required)
        :param str feature_identifier: The feature to query (required)
        :param str tenant_url_code: (required)
        :return: DataRow
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.feature_get_feature_data_with_http_info(layer_identifier, feature_identifier, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.feature_get_feature_data_with_http_info(layer_identifier, feature_identifier, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def feature_get_feature_data_with_http_info(self, layer_identifier, feature_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Gets a feature's data.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.feature_get_feature_data_with_http_info(layer_identifier, feature_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str layer_identifier: The layer to query (required)
        :param str feature_identifier: The feature to query (required)
        :param str tenant_url_code: (required)
        :return: DataRow
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['layer_identifier', 'feature_identifier', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method feature_get_feature_data" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'layer_identifier' is set
        if ('layer_identifier' not in params or
                params['layer_identifier'] is None):
            raise ValueError("Missing the required parameter `layer_identifier` when calling `feature_get_feature_data`")  # noqa: E501
        # verify the required parameter 'feature_identifier' is set
        if ('feature_identifier' not in params or
                params['feature_identifier'] is None):
            raise ValueError("Missing the required parameter `feature_identifier` when calling `feature_get_feature_data`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `feature_get_feature_data`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'layer_identifier' in params:
            path_params['layerIdentifier'] = params['layer_identifier']  # noqa: E501
        if 'feature_identifier' in params:
            path_params['featureIdentifier'] = params['feature_identifier']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/Layer/{layerIdentifier}/Feature/{featureIdentifier}/data', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DataRow',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def feature_get_feature_in_geo_json(self, layer_identifier, feature_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Gets a specific feature with its geometry in GeoJSON format.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.feature_get_feature_in_geo_json(layer_identifier, feature_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str layer_identifier: The layer to query (required)
        :param str feature_identifier: The feature to query (required)
        :param str tenant_url_code: (required)
        :return: FeatureGeoJSON
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.feature_get_feature_in_geo_json_with_http_info(layer_identifier, feature_identifier, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.feature_get_feature_in_geo_json_with_http_info(layer_identifier, feature_identifier, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def feature_get_feature_in_geo_json_with_http_info(self, layer_identifier, feature_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Gets a specific feature with its geometry in GeoJSON format.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.feature_get_feature_in_geo_json_with_http_info(layer_identifier, feature_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str layer_identifier: The layer to query (required)
        :param str feature_identifier: The feature to query (required)
        :param str tenant_url_code: (required)
        :return: FeatureGeoJSON
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['layer_identifier', 'feature_identifier', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method feature_get_feature_in_geo_json" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'layer_identifier' is set
        if ('layer_identifier' not in params or
                params['layer_identifier'] is None):
            raise ValueError("Missing the required parameter `layer_identifier` when calling `feature_get_feature_in_geo_json`")  # noqa: E501
        # verify the required parameter 'feature_identifier' is set
        if ('feature_identifier' not in params or
                params['feature_identifier'] is None):
            raise ValueError("Missing the required parameter `feature_identifier` when calling `feature_get_feature_in_geo_json`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `feature_get_feature_in_geo_json`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'layer_identifier' in params:
            path_params['layerIdentifier'] = params['layer_identifier']  # noqa: E501
        if 'feature_identifier' in params:
            path_params['featureIdentifier'] = params['feature_identifier']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/Layer/{layerIdentifier}/Feature/{featureIdentifier}/GeoJSON', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='FeatureGeoJSON',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def feature_get_feature_in_long_lat(self, layer_identifier, feature_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Gets a specific feature with its coordinates. The layer must be a point layer.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.feature_get_feature_in_long_lat(layer_identifier, feature_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str layer_identifier: The layer to query (required)
        :param str feature_identifier: The feature to query (required)
        :param str tenant_url_code: (required)
        :return: FeatureLongLat
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.feature_get_feature_in_long_lat_with_http_info(layer_identifier, feature_identifier, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.feature_get_feature_in_long_lat_with_http_info(layer_identifier, feature_identifier, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def feature_get_feature_in_long_lat_with_http_info(self, layer_identifier, feature_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Gets a specific feature with its coordinates. The layer must be a point layer.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.feature_get_feature_in_long_lat_with_http_info(layer_identifier, feature_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str layer_identifier: The layer to query (required)
        :param str feature_identifier: The feature to query (required)
        :param str tenant_url_code: (required)
        :return: FeatureLongLat
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['layer_identifier', 'feature_identifier', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method feature_get_feature_in_long_lat" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'layer_identifier' is set
        if ('layer_identifier' not in params or
                params['layer_identifier'] is None):
            raise ValueError("Missing the required parameter `layer_identifier` when calling `feature_get_feature_in_long_lat`")  # noqa: E501
        # verify the required parameter 'feature_identifier' is set
        if ('feature_identifier' not in params or
                params['feature_identifier'] is None):
            raise ValueError("Missing the required parameter `feature_identifier` when calling `feature_get_feature_in_long_lat`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `feature_get_feature_in_long_lat`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'layer_identifier' in params:
            path_params['layerIdentifier'] = params['layer_identifier']  # noqa: E501
        if 'feature_identifier' in params:
            path_params['featureIdentifier'] = params['feature_identifier']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/Layer/{layerIdentifier}/Feature/{featureIdentifier}/LongLat', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='FeatureLongLat',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def feature_get_feature_in_wkt(self, layer_identifier, feature_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Gets a specific feature with its geometry in WKT format.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.feature_get_feature_in_wkt(layer_identifier, feature_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str layer_identifier: The layer to query (required)
        :param str feature_identifier: The feature to query (required)
        :param str tenant_url_code: (required)
        :return: FeatureWKT
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.feature_get_feature_in_wkt_with_http_info(layer_identifier, feature_identifier, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.feature_get_feature_in_wkt_with_http_info(layer_identifier, feature_identifier, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def feature_get_feature_in_wkt_with_http_info(self, layer_identifier, feature_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Gets a specific feature with its geometry in WKT format.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.feature_get_feature_in_wkt_with_http_info(layer_identifier, feature_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str layer_identifier: The layer to query (required)
        :param str feature_identifier: The feature to query (required)
        :param str tenant_url_code: (required)
        :return: FeatureWKT
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['layer_identifier', 'feature_identifier', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method feature_get_feature_in_wkt" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'layer_identifier' is set
        if ('layer_identifier' not in params or
                params['layer_identifier'] is None):
            raise ValueError("Missing the required parameter `layer_identifier` when calling `feature_get_feature_in_wkt`")  # noqa: E501
        # verify the required parameter 'feature_identifier' is set
        if ('feature_identifier' not in params or
                params['feature_identifier'] is None):
            raise ValueError("Missing the required parameter `feature_identifier` when calling `feature_get_feature_in_wkt`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `feature_get_feature_in_wkt`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'layer_identifier' in params:
            path_params['layerIdentifier'] = params['layer_identifier']  # noqa: E501
        if 'feature_identifier' in params:
            path_params['featureIdentifier'] = params['feature_identifier']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/Layer/{layerIdentifier}/Feature/{featureIdentifier}/WKT', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='FeatureWKT',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def feature_get_features(self, body, layer_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Gets the rows in the layer.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.feature_get_features(body, layer_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FeaturesGetParameters body: (required)
        :param str layer_identifier: The layer to query (required)
        :param str tenant_url_code: (required)
        :return: list[DataRow]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.feature_get_features_with_http_info(body, layer_identifier, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.feature_get_features_with_http_info(body, layer_identifier, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def feature_get_features_with_http_info(self, body, layer_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Gets the rows in the layer.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.feature_get_features_with_http_info(body, layer_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FeaturesGetParameters body: (required)
        :param str layer_identifier: The layer to query (required)
        :param str tenant_url_code: (required)
        :return: list[DataRow]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'layer_identifier', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method feature_get_features" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `feature_get_features`")  # noqa: E501
        # verify the required parameter 'layer_identifier' is set
        if ('layer_identifier' not in params or
                params['layer_identifier'] is None):
            raise ValueError("Missing the required parameter `layer_identifier` when calling `feature_get_features`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `feature_get_features`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'layer_identifier' in params:
            path_params['layerIdentifier'] = params['layer_identifier']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/Layer/{layerIdentifier}/Features', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[DataRow]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def feature_get_features_at_location_in_geo_json(self, layer_identifier, latitude, longitude, tenant_url_code, **kwargs):  # noqa: E501
        """Return all the features with all their associated data intersecting the specified coordinates.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.feature_get_features_at_location_in_geo_json(layer_identifier, latitude, longitude, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str layer_identifier: The layer to query (required)
        :param float latitude: The latitude of the coordinate to query (required)
        :param float longitude: The longitudew of the coordinate to query (required)
        :param str tenant_url_code: (required)
        :return: list[FeatureGeoJSON]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.feature_get_features_at_location_in_geo_json_with_http_info(layer_identifier, latitude, longitude, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.feature_get_features_at_location_in_geo_json_with_http_info(layer_identifier, latitude, longitude, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def feature_get_features_at_location_in_geo_json_with_http_info(self, layer_identifier, latitude, longitude, tenant_url_code, **kwargs):  # noqa: E501
        """Return all the features with all their associated data intersecting the specified coordinates.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.feature_get_features_at_location_in_geo_json_with_http_info(layer_identifier, latitude, longitude, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str layer_identifier: The layer to query (required)
        :param float latitude: The latitude of the coordinate to query (required)
        :param float longitude: The longitudew of the coordinate to query (required)
        :param str tenant_url_code: (required)
        :return: list[FeatureGeoJSON]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['layer_identifier', 'latitude', 'longitude', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method feature_get_features_at_location_in_geo_json" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'layer_identifier' is set
        if ('layer_identifier' not in params or
                params['layer_identifier'] is None):
            raise ValueError("Missing the required parameter `layer_identifier` when calling `feature_get_features_at_location_in_geo_json`")  # noqa: E501
        # verify the required parameter 'latitude' is set
        if ('latitude' not in params or
                params['latitude'] is None):
            raise ValueError("Missing the required parameter `latitude` when calling `feature_get_features_at_location_in_geo_json`")  # noqa: E501
        # verify the required parameter 'longitude' is set
        if ('longitude' not in params or
                params['longitude'] is None):
            raise ValueError("Missing the required parameter `longitude` when calling `feature_get_features_at_location_in_geo_json`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `feature_get_features_at_location_in_geo_json`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'layer_identifier' in params:
            path_params['layerIdentifier'] = params['layer_identifier']  # noqa: E501
        if 'latitude' in params:
            path_params['latitude'] = params['latitude']  # noqa: E501
        if 'longitude' in params:
            path_params['longitude'] = params['longitude']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/Layer/{layerIdentifier}/{latitude}/{longitude}/GeoJSON', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[FeatureGeoJSON]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def feature_get_features_at_location_in_long_lat(self, layer_identifier, latitude, longitude, tenant_url_code, **kwargs):  # noqa: E501
        """Return all the features with all their associated data intersecting the specified coordinates. Important: this api call will only work if the queried layer has points. For any other geometry type, use the GeoJSON or WKT call instead.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.feature_get_features_at_location_in_long_lat(layer_identifier, latitude, longitude, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str layer_identifier: The layer to query (required)
        :param float latitude: The latitude of the coordinate to query (required)
        :param float longitude: The longitudew of the coordinate to query (required)
        :param str tenant_url_code: (required)
        :return: list[FeatureLongLat]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.feature_get_features_at_location_in_long_lat_with_http_info(layer_identifier, latitude, longitude, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.feature_get_features_at_location_in_long_lat_with_http_info(layer_identifier, latitude, longitude, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def feature_get_features_at_location_in_long_lat_with_http_info(self, layer_identifier, latitude, longitude, tenant_url_code, **kwargs):  # noqa: E501
        """Return all the features with all their associated data intersecting the specified coordinates. Important: this api call will only work if the queried layer has points. For any other geometry type, use the GeoJSON or WKT call instead.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.feature_get_features_at_location_in_long_lat_with_http_info(layer_identifier, latitude, longitude, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str layer_identifier: The layer to query (required)
        :param float latitude: The latitude of the coordinate to query (required)
        :param float longitude: The longitudew of the coordinate to query (required)
        :param str tenant_url_code: (required)
        :return: list[FeatureLongLat]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['layer_identifier', 'latitude', 'longitude', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method feature_get_features_at_location_in_long_lat" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'layer_identifier' is set
        if ('layer_identifier' not in params or
                params['layer_identifier'] is None):
            raise ValueError("Missing the required parameter `layer_identifier` when calling `feature_get_features_at_location_in_long_lat`")  # noqa: E501
        # verify the required parameter 'latitude' is set
        if ('latitude' not in params or
                params['latitude'] is None):
            raise ValueError("Missing the required parameter `latitude` when calling `feature_get_features_at_location_in_long_lat`")  # noqa: E501
        # verify the required parameter 'longitude' is set
        if ('longitude' not in params or
                params['longitude'] is None):
            raise ValueError("Missing the required parameter `longitude` when calling `feature_get_features_at_location_in_long_lat`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `feature_get_features_at_location_in_long_lat`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'layer_identifier' in params:
            path_params['layerIdentifier'] = params['layer_identifier']  # noqa: E501
        if 'latitude' in params:
            path_params['latitude'] = params['latitude']  # noqa: E501
        if 'longitude' in params:
            path_params['longitude'] = params['longitude']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/Layer/{layerIdentifier}/{latitude}/{longitude}/LongLat', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[FeatureLongLat]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def feature_get_features_at_location_in_wkt(self, layer_identifier, latitude, longitude, tenant_url_code, **kwargs):  # noqa: E501
        """Return all the features with all their associated data intersecting the specified coordinates.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.feature_get_features_at_location_in_wkt(layer_identifier, latitude, longitude, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str layer_identifier: The layer to query (required)
        :param float latitude: The latitude of the coordinate to query (required)
        :param float longitude: The longitudew of the coordinate to query (required)
        :param str tenant_url_code: (required)
        :return: list[FeatureWKT]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.feature_get_features_at_location_in_wkt_with_http_info(layer_identifier, latitude, longitude, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.feature_get_features_at_location_in_wkt_with_http_info(layer_identifier, latitude, longitude, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def feature_get_features_at_location_in_wkt_with_http_info(self, layer_identifier, latitude, longitude, tenant_url_code, **kwargs):  # noqa: E501
        """Return all the features with all their associated data intersecting the specified coordinates.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.feature_get_features_at_location_in_wkt_with_http_info(layer_identifier, latitude, longitude, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str layer_identifier: The layer to query (required)
        :param float latitude: The latitude of the coordinate to query (required)
        :param float longitude: The longitudew of the coordinate to query (required)
        :param str tenant_url_code: (required)
        :return: list[FeatureWKT]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['layer_identifier', 'latitude', 'longitude', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method feature_get_features_at_location_in_wkt" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'layer_identifier' is set
        if ('layer_identifier' not in params or
                params['layer_identifier'] is None):
            raise ValueError("Missing the required parameter `layer_identifier` when calling `feature_get_features_at_location_in_wkt`")  # noqa: E501
        # verify the required parameter 'latitude' is set
        if ('latitude' not in params or
                params['latitude'] is None):
            raise ValueError("Missing the required parameter `latitude` when calling `feature_get_features_at_location_in_wkt`")  # noqa: E501
        # verify the required parameter 'longitude' is set
        if ('longitude' not in params or
                params['longitude'] is None):
            raise ValueError("Missing the required parameter `longitude` when calling `feature_get_features_at_location_in_wkt`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `feature_get_features_at_location_in_wkt`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'layer_identifier' in params:
            path_params['layerIdentifier'] = params['layer_identifier']  # noqa: E501
        if 'latitude' in params:
            path_params['latitude'] = params['latitude']  # noqa: E501
        if 'longitude' in params:
            path_params['longitude'] = params['longitude']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/Layer/{layerIdentifier}/{latitude}/{longitude}/WKT', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[FeatureWKT]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def feature_get_features_in_geo_json(self, body, layer_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Gets the layer's features with the geometries in GeoJSON format.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.feature_get_features_in_geo_json(body, layer_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FeaturesGetParameters body: (required)
        :param str layer_identifier: The layer to query (required)
        :param str tenant_url_code: (required)
        :return: list[FeatureGeoJSON]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.feature_get_features_in_geo_json_with_http_info(body, layer_identifier, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.feature_get_features_in_geo_json_with_http_info(body, layer_identifier, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def feature_get_features_in_geo_json_with_http_info(self, body, layer_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Gets the layer's features with the geometries in GeoJSON format.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.feature_get_features_in_geo_json_with_http_info(body, layer_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FeaturesGetParameters body: (required)
        :param str layer_identifier: The layer to query (required)
        :param str tenant_url_code: (required)
        :return: list[FeatureGeoJSON]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'layer_identifier', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method feature_get_features_in_geo_json" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `feature_get_features_in_geo_json`")  # noqa: E501
        # verify the required parameter 'layer_identifier' is set
        if ('layer_identifier' not in params or
                params['layer_identifier'] is None):
            raise ValueError("Missing the required parameter `layer_identifier` when calling `feature_get_features_in_geo_json`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `feature_get_features_in_geo_json`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'layer_identifier' in params:
            path_params['layerIdentifier'] = params['layer_identifier']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/Layer/{layerIdentifier}/Features/GeoJSON', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[FeatureGeoJSON]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def feature_get_features_in_long_lat(self, body, layer_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Retrives the layer's features with their coordinates. The layer must be a point layer.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.feature_get_features_in_long_lat(body, layer_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FeaturesGetParameters body: (required)
        :param str layer_identifier: The layer to query (required)
        :param str tenant_url_code: (required)
        :return: list[FeatureLongLat]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.feature_get_features_in_long_lat_with_http_info(body, layer_identifier, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.feature_get_features_in_long_lat_with_http_info(body, layer_identifier, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def feature_get_features_in_long_lat_with_http_info(self, body, layer_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Retrives the layer's features with their coordinates. The layer must be a point layer.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.feature_get_features_in_long_lat_with_http_info(body, layer_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FeaturesGetParameters body: (required)
        :param str layer_identifier: The layer to query (required)
        :param str tenant_url_code: (required)
        :return: list[FeatureLongLat]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'layer_identifier', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method feature_get_features_in_long_lat" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `feature_get_features_in_long_lat`")  # noqa: E501
        # verify the required parameter 'layer_identifier' is set
        if ('layer_identifier' not in params or
                params['layer_identifier'] is None):
            raise ValueError("Missing the required parameter `layer_identifier` when calling `feature_get_features_in_long_lat`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `feature_get_features_in_long_lat`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'layer_identifier' in params:
            path_params['layerIdentifier'] = params['layer_identifier']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/Layer/{layerIdentifier}/Features/LongLat', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[FeatureLongLat]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def feature_get_features_in_wkt(self, body, layer_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Gets the layer's features with the geometries in WKT format.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.feature_get_features_in_wkt(body, layer_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FeaturesGetParameters body: (required)
        :param str layer_identifier: The layer to query (required)
        :param str tenant_url_code: (required)
        :return: list[FeatureWKT]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.feature_get_features_in_wkt_with_http_info(body, layer_identifier, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.feature_get_features_in_wkt_with_http_info(body, layer_identifier, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def feature_get_features_in_wkt_with_http_info(self, body, layer_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Gets the layer's features with the geometries in WKT format.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.feature_get_features_in_wkt_with_http_info(body, layer_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FeaturesGetParameters body: (required)
        :param str layer_identifier: The layer to query (required)
        :param str tenant_url_code: (required)
        :return: list[FeatureWKT]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'layer_identifier', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method feature_get_features_in_wkt" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `feature_get_features_in_wkt`")  # noqa: E501
        # verify the required parameter 'layer_identifier' is set
        if ('layer_identifier' not in params or
                params['layer_identifier'] is None):
            raise ValueError("Missing the required parameter `layer_identifier` when calling `feature_get_features_in_wkt`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `feature_get_features_in_wkt`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'layer_identifier' in params:
            path_params['layerIdentifier'] = params['layer_identifier']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/Layer/{layerIdentifier}/Features/WKT', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[FeatureWKT]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def feature_update_from_geo_json(self, body, layer_identifier, feature_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Updates a feature's geometry from a GeoJSON.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.feature_update_from_geo_json(body, layer_identifier, feature_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FeatureGeoJSONUpdateParameter body: (required)
        :param str layer_identifier: The layer to query (required)
        :param str feature_identifier: The feature to query (required)
        :param str tenant_url_code: (required)
        :return: FeatureGeoJSON
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.feature_update_from_geo_json_with_http_info(body, layer_identifier, feature_identifier, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.feature_update_from_geo_json_with_http_info(body, layer_identifier, feature_identifier, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def feature_update_from_geo_json_with_http_info(self, body, layer_identifier, feature_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Updates a feature's geometry from a GeoJSON.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.feature_update_from_geo_json_with_http_info(body, layer_identifier, feature_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FeatureGeoJSONUpdateParameter body: (required)
        :param str layer_identifier: The layer to query (required)
        :param str feature_identifier: The feature to query (required)
        :param str tenant_url_code: (required)
        :return: FeatureGeoJSON
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'layer_identifier', 'feature_identifier', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method feature_update_from_geo_json" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `feature_update_from_geo_json`")  # noqa: E501
        # verify the required parameter 'layer_identifier' is set
        if ('layer_identifier' not in params or
                params['layer_identifier'] is None):
            raise ValueError("Missing the required parameter `layer_identifier` when calling `feature_update_from_geo_json`")  # noqa: E501
        # verify the required parameter 'feature_identifier' is set
        if ('feature_identifier' not in params or
                params['feature_identifier'] is None):
            raise ValueError("Missing the required parameter `feature_identifier` when calling `feature_update_from_geo_json`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `feature_update_from_geo_json`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'layer_identifier' in params:
            path_params['layerIdentifier'] = params['layer_identifier']  # noqa: E501
        if 'feature_identifier' in params:
            path_params['featureIdentifier'] = params['feature_identifier']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/Layer/{layerIdentifier}/Feature/{featureIdentifier}/updateFromGeoJSON', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='FeatureGeoJSON',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def feature_update_from_long_lat(self, body, layer_identifier, feature_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Updates a feature's geometry with coordinates. The layer must a point layer. Use \"proj4\": \"+proj=longlat +ellps=WGS84 +datum=WGS84 +no_defs\".  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.feature_update_from_long_lat(body, layer_identifier, feature_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FeatureLongLatUpdateParameter body: (required)
        :param str layer_identifier: The layer to query (required)
        :param str feature_identifier: The feature to query (required)
        :param str tenant_url_code: (required)
        :return: FeatureLongLat
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.feature_update_from_long_lat_with_http_info(body, layer_identifier, feature_identifier, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.feature_update_from_long_lat_with_http_info(body, layer_identifier, feature_identifier, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def feature_update_from_long_lat_with_http_info(self, body, layer_identifier, feature_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Updates a feature's geometry with coordinates. The layer must a point layer. Use \"proj4\": \"+proj=longlat +ellps=WGS84 +datum=WGS84 +no_defs\".  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.feature_update_from_long_lat_with_http_info(body, layer_identifier, feature_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FeatureLongLatUpdateParameter body: (required)
        :param str layer_identifier: The layer to query (required)
        :param str feature_identifier: The feature to query (required)
        :param str tenant_url_code: (required)
        :return: FeatureLongLat
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'layer_identifier', 'feature_identifier', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method feature_update_from_long_lat" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `feature_update_from_long_lat`")  # noqa: E501
        # verify the required parameter 'layer_identifier' is set
        if ('layer_identifier' not in params or
                params['layer_identifier'] is None):
            raise ValueError("Missing the required parameter `layer_identifier` when calling `feature_update_from_long_lat`")  # noqa: E501
        # verify the required parameter 'feature_identifier' is set
        if ('feature_identifier' not in params or
                params['feature_identifier'] is None):
            raise ValueError("Missing the required parameter `feature_identifier` when calling `feature_update_from_long_lat`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `feature_update_from_long_lat`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'layer_identifier' in params:
            path_params['layerIdentifier'] = params['layer_identifier']  # noqa: E501
        if 'feature_identifier' in params:
            path_params['featureIdentifier'] = params['feature_identifier']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/Layer/{layerIdentifier}/Feature/{featureIdentifier}/updateFromLongLat', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='FeatureLongLat',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def feature_update_geometry_from_wkt(self, body, layer_identifier, feature_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Updates a feature's geometry from a WKT.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.feature_update_geometry_from_wkt(body, layer_identifier, feature_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FeatureWKTUpdateParameter body: (required)
        :param str layer_identifier: The layer to query (required)
        :param str feature_identifier: The feature to query (required)
        :param str tenant_url_code: (required)
        :return: FeatureWKT
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.feature_update_geometry_from_wkt_with_http_info(body, layer_identifier, feature_identifier, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.feature_update_geometry_from_wkt_with_http_info(body, layer_identifier, feature_identifier, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def feature_update_geometry_from_wkt_with_http_info(self, body, layer_identifier, feature_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Updates a feature's geometry from a WKT.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.feature_update_geometry_from_wkt_with_http_info(body, layer_identifier, feature_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FeatureWKTUpdateParameter body: (required)
        :param str layer_identifier: The layer to query (required)
        :param str feature_identifier: The feature to query (required)
        :param str tenant_url_code: (required)
        :return: FeatureWKT
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'layer_identifier', 'feature_identifier', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method feature_update_geometry_from_wkt" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `feature_update_geometry_from_wkt`")  # noqa: E501
        # verify the required parameter 'layer_identifier' is set
        if ('layer_identifier' not in params or
                params['layer_identifier'] is None):
            raise ValueError("Missing the required parameter `layer_identifier` when calling `feature_update_geometry_from_wkt`")  # noqa: E501
        # verify the required parameter 'feature_identifier' is set
        if ('feature_identifier' not in params or
                params['feature_identifier'] is None):
            raise ValueError("Missing the required parameter `feature_identifier` when calling `feature_update_geometry_from_wkt`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `feature_update_geometry_from_wkt`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'layer_identifier' in params:
            path_params['layerIdentifier'] = params['layer_identifier']  # noqa: E501
        if 'feature_identifier' in params:
            path_params['featureIdentifier'] = params['feature_identifier']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/Layer/{layerIdentifier}/Feature/{featureIdentifier}/updateGeometryFromWKT', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='FeatureWKT',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def feature_update_many_values(self, body, layer_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Updates a feature's data. A subset of the columns can be used.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.feature_update_many_values(body, layer_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DataRowUpdateManyParameter body: (required)
        :param str layer_identifier: The layer to query (required)
        :param str tenant_url_code: (required)
        :return: list[FeatureDataRow]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.feature_update_many_values_with_http_info(body, layer_identifier, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.feature_update_many_values_with_http_info(body, layer_identifier, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def feature_update_many_values_with_http_info(self, body, layer_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Updates a feature's data. A subset of the columns can be used.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.feature_update_many_values_with_http_info(body, layer_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DataRowUpdateManyParameter body: (required)
        :param str layer_identifier: The layer to query (required)
        :param str tenant_url_code: (required)
        :return: list[FeatureDataRow]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'layer_identifier', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method feature_update_many_values" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `feature_update_many_values`")  # noqa: E501
        # verify the required parameter 'layer_identifier' is set
        if ('layer_identifier' not in params or
                params['layer_identifier'] is None):
            raise ValueError("Missing the required parameter `layer_identifier` when calling `feature_update_many_values`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `feature_update_many_values`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'layer_identifier' in params:
            path_params['layerIdentifier'] = params['layer_identifier']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/Layer/{layerIdentifier}/Feature/updateManyValues', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[FeatureDataRow]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def feature_update_values(self, body, layer_identifier, feature_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Updates a feature's data. A subset of the columns can be used.  # noqa: E501

        This request needs the layer identifier or id that is retrieved from the get request `/{tenantUrlCode}/api/v2/Layers`.              It also needs the featureIdentifier that is retrieved from both: * the get request `/{tenantUrlCode}/api/v2/Layer/{layerIdentifier}/dataTable` and * the post request `/{tenantUrlCode}/api/v2/DataTable/{dataTableIdentifier}/DataRows`  For example, the URL `/tenantName/api/v2/Layer/layerId/Feature/267/updateValues` with these parameters will update the feature 267 and replace the fields present in the array dataColumnsIdentifiers. ```json {  \"dataColumnsIdentifiers\": [\"ID\",\"Type\", \"Ville\"],  \"values\": [\"C0090test2\", \"Test\", \"VilleTest\"] } ```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.feature_update_values(body, layer_identifier, feature_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FeatureDataUpdateParameter body: (required)
        :param str layer_identifier: The layer to query (required)
        :param str feature_identifier: The feature to query (required)
        :param str tenant_url_code: (required)
        :return: FeatureDataRow
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.feature_update_values_with_http_info(body, layer_identifier, feature_identifier, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.feature_update_values_with_http_info(body, layer_identifier, feature_identifier, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def feature_update_values_with_http_info(self, body, layer_identifier, feature_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Updates a feature's data. A subset of the columns can be used.  # noqa: E501

        This request needs the layer identifier or id that is retrieved from the get request `/{tenantUrlCode}/api/v2/Layers`.              It also needs the featureIdentifier that is retrieved from both: * the get request `/{tenantUrlCode}/api/v2/Layer/{layerIdentifier}/dataTable` and * the post request `/{tenantUrlCode}/api/v2/DataTable/{dataTableIdentifier}/DataRows`  For example, the URL `/tenantName/api/v2/Layer/layerId/Feature/267/updateValues` with these parameters will update the feature 267 and replace the fields present in the array dataColumnsIdentifiers. ```json {  \"dataColumnsIdentifiers\": [\"ID\",\"Type\", \"Ville\"],  \"values\": [\"C0090test2\", \"Test\", \"VilleTest\"] } ```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.feature_update_values_with_http_info(body, layer_identifier, feature_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FeatureDataUpdateParameter body: (required)
        :param str layer_identifier: The layer to query (required)
        :param str feature_identifier: The feature to query (required)
        :param str tenant_url_code: (required)
        :return: FeatureDataRow
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'layer_identifier', 'feature_identifier', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method feature_update_values" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `feature_update_values`")  # noqa: E501
        # verify the required parameter 'layer_identifier' is set
        if ('layer_identifier' not in params or
                params['layer_identifier'] is None):
            raise ValueError("Missing the required parameter `layer_identifier` when calling `feature_update_values`")  # noqa: E501
        # verify the required parameter 'feature_identifier' is set
        if ('feature_identifier' not in params or
                params['feature_identifier'] is None):
            raise ValueError("Missing the required parameter `feature_identifier` when calling `feature_update_values`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `feature_update_values`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'layer_identifier' in params:
            path_params['layerIdentifier'] = params['layer_identifier']  # noqa: E501
        if 'feature_identifier' in params:
            path_params['featureIdentifier'] = params['feature_identifier']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/Layer/{layerIdentifier}/Feature/{featureIdentifier}/updateValues', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='FeatureDataRow',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def feature_update_values_and_joins(self, body, layer_identifier, feature_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """feature_update_values_and_joins  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.feature_update_values_and_joins(body, layer_identifier, feature_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CompleteFeatureDataUpdateParameter body: (required)
        :param str layer_identifier: (required)
        :param str feature_identifier: (required)
        :param str tenant_url_code: (required)
        :return: FeatureDataRow
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.feature_update_values_and_joins_with_http_info(body, layer_identifier, feature_identifier, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.feature_update_values_and_joins_with_http_info(body, layer_identifier, feature_identifier, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def feature_update_values_and_joins_with_http_info(self, body, layer_identifier, feature_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """feature_update_values_and_joins  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.feature_update_values_and_joins_with_http_info(body, layer_identifier, feature_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CompleteFeatureDataUpdateParameter body: (required)
        :param str layer_identifier: (required)
        :param str feature_identifier: (required)
        :param str tenant_url_code: (required)
        :return: FeatureDataRow
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'layer_identifier', 'feature_identifier', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method feature_update_values_and_joins" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `feature_update_values_and_joins`")  # noqa: E501
        # verify the required parameter 'layer_identifier' is set
        if ('layer_identifier' not in params or
                params['layer_identifier'] is None):
            raise ValueError("Missing the required parameter `layer_identifier` when calling `feature_update_values_and_joins`")  # noqa: E501
        # verify the required parameter 'feature_identifier' is set
        if ('feature_identifier' not in params or
                params['feature_identifier'] is None):
            raise ValueError("Missing the required parameter `feature_identifier` when calling `feature_update_values_and_joins`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `feature_update_values_and_joins`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'layer_identifier' in params:
            path_params['layerIdentifier'] = params['layer_identifier']  # noqa: E501
        if 'feature_identifier' in params:
            path_params['featureIdentifier'] = params['feature_identifier']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/Layer/{layerIdentifier}/Feature/{featureIdentifier}/updateValuesAndJoins', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='FeatureDataRow',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
