# coding: utf-8

"""
    CartoVista REST API

    No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)  # noqa: E501

    OpenAPI spec version: 2.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from add_to_cartovista.swagger_client.api_client import ApiClient


class ApiKeyApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def api_key_create_access_key(self, body, user_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Generates an access key for a specific user.  # noqa: E501

        This request requires the identifier of the user to which the API key will be linked.   * The identifier can be retrieved with the GET request `/{tenantUrlCode}/api/v2/users`, which returns all users in the tenant. The relevant field is `securityIdentifier`.    The request also requires a list of IP addresses to be whitelisted for the API key.    Optional notes can be added to describe the purpose of the API key.    For example, the request `/tenantName/api/v2/User/00000000-0000-0000-0000-000000000001/ApiKey` with the following body:   ```json {  \"ipWhitelisting\": [   \"X.X.X.X\"  ],  \"notes\": \"Example API\" } ``` will create an API key for the user 00000000-0000-0000-0000-000000000001, valid only for requests originating from the IP address X.X.X.X.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_key_create_access_key(body, user_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CreateApiKeyParameter body: (required)
        :param str user_identifier: (required)
        :param str tenant_url_code: (required)
        :return: AccessKeyDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_key_create_access_key_with_http_info(body, user_identifier, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.api_key_create_access_key_with_http_info(body, user_identifier, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def api_key_create_access_key_with_http_info(self, body, user_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Generates an access key for a specific user.  # noqa: E501

        This request requires the identifier of the user to which the API key will be linked.   * The identifier can be retrieved with the GET request `/{tenantUrlCode}/api/v2/users`, which returns all users in the tenant. The relevant field is `securityIdentifier`.    The request also requires a list of IP addresses to be whitelisted for the API key.    Optional notes can be added to describe the purpose of the API key.    For example, the request `/tenantName/api/v2/User/00000000-0000-0000-0000-000000000001/ApiKey` with the following body:   ```json {  \"ipWhitelisting\": [   \"X.X.X.X\"  ],  \"notes\": \"Example API\" } ``` will create an API key for the user 00000000-0000-0000-0000-000000000001, valid only for requests originating from the IP address X.X.X.X.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_key_create_access_key_with_http_info(body, user_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CreateApiKeyParameter body: (required)
        :param str user_identifier: (required)
        :param str tenant_url_code: (required)
        :return: AccessKeyDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'user_identifier', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_key_create_access_key" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `api_key_create_access_key`")  # noqa: E501
        # verify the required parameter 'user_identifier' is set
        if ('user_identifier' not in params or
                params['user_identifier'] is None):
            raise ValueError("Missing the required parameter `user_identifier` when calling `api_key_create_access_key`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `api_key_create_access_key`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'user_identifier' in params:
            path_params['UserIdentifier'] = params['user_identifier']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/User/{UserIdentifier}/ApiKey', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AccessKeyDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def api_key_delete_api_key(self, id, tenant_url_code, **kwargs):  # noqa: E501
        """Deletes an API key.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_key_delete_api_key(id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: (required)
        :param str tenant_url_code: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_key_delete_api_key_with_http_info(id, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.api_key_delete_api_key_with_http_info(id, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def api_key_delete_api_key_with_http_info(self, id, tenant_url_code, **kwargs):  # noqa: E501
        """Deletes an API key.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_key_delete_api_key_with_http_info(id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: (required)
        :param str tenant_url_code: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_key_delete_api_key" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `api_key_delete_api_key`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `api_key_delete_api_key`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/ApiKey/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def api_key_generate_secret_key(self, id, tenant_url_code, **kwargs):  # noqa: E501
        """Generates a secret key for additional security on the access key.  # noqa: E501

        Once a secret key is generated for an API key, it cannot be removed.   If an API key has both an IP whitelist and a secret key, requests must satisfy both conditions.   To use only the secret key, the IP whitelist can be cleared by sending a request to `/{tenantUrlCode}/api/v2/ApiKey` with `\"ipWhitelisting\": []` in the body.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_key_generate_secret_key(id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: (required)
        :param str tenant_url_code: (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_key_generate_secret_key_with_http_info(id, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.api_key_generate_secret_key_with_http_info(id, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def api_key_generate_secret_key_with_http_info(self, id, tenant_url_code, **kwargs):  # noqa: E501
        """Generates a secret key for additional security on the access key.  # noqa: E501

        Once a secret key is generated for an API key, it cannot be removed.   If an API key has both an IP whitelist and a secret key, requests must satisfy both conditions.   To use only the secret key, the IP whitelist can be cleared by sending a request to `/{tenantUrlCode}/api/v2/ApiKey` with `\"ipWhitelisting\": []` in the body.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_key_generate_secret_key_with_http_info(id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: (required)
        :param str tenant_url_code: (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_key_generate_secret_key" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `api_key_generate_secret_key`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `api_key_generate_secret_key`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/ApiKey/{id}/generateSecret', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def api_key_get_access_keys(self, user_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Gets all the access keys created for a specific user.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_key_get_access_keys(user_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_identifier: (required)
        :param str tenant_url_code: (required)
        :return: list[AccessKeyDTO]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_key_get_access_keys_with_http_info(user_identifier, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.api_key_get_access_keys_with_http_info(user_identifier, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def api_key_get_access_keys_with_http_info(self, user_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Gets all the access keys created for a specific user.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_key_get_access_keys_with_http_info(user_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_identifier: (required)
        :param str tenant_url_code: (required)
        :return: list[AccessKeyDTO]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['user_identifier', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_key_get_access_keys" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'user_identifier' is set
        if ('user_identifier' not in params or
                params['user_identifier'] is None):
            raise ValueError("Missing the required parameter `user_identifier` when calling `api_key_get_access_keys`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `api_key_get_access_keys`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'user_identifier' in params:
            path_params['UserIdentifier'] = params['user_identifier']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/User/{UserIdentifier}/ApiKey', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[AccessKeyDTO]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def api_key_update_access_key(self, body, tenant_url_code, **kwargs):  # noqa: E501
        """Updates the access key.  # noqa: E501

        Updating an access key requires its identifier as well as the properties to be modified. These are provided in the request body. The available fields are:    - **accessKey** (required): The identifier of the access key to update.     The identifier can be retrieved from `/{tenantUrlCode}/api/v2/User/{UserIdentifier}/ApiKey`, where `{UserIdentifier}` corresponds to the user that owns the access key.     If the user identifier is not known, it can be obtained from `/{tenantUrlCode}/api/v2/users`. The `securityIdentifier` field represents the user identifier.    - **enabled** (required): A boolean (`true` or `false`) indicating whether the access key is active.    - **ipWhitelisted** (required): A list of IP addresses from which requests can be made using the access key. An empty list removes all IPs from the access key.    - **notes** (required): A free-text field to describe the purpose or usage of the access key.    For example, the request `tenantName/api/v2/ApiKey` with the body:   ```json {   \"accessKey\": \"00000000-0000-0000-0000-000000000001\",   \"enabled\": false,   \"ipWhitelisted\": [],   \"notes\": \"\" } ``` will disable the access key 00000000-0000-0000-0000-000000000001 as well as removing the notes and all whitelisted IP addresses from it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_key_update_access_key(body, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UpdateAccessKeyDTO body: (required)
        :param str tenant_url_code: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_key_update_access_key_with_http_info(body, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.api_key_update_access_key_with_http_info(body, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def api_key_update_access_key_with_http_info(self, body, tenant_url_code, **kwargs):  # noqa: E501
        """Updates the access key.  # noqa: E501

        Updating an access key requires its identifier as well as the properties to be modified. These are provided in the request body. The available fields are:    - **accessKey** (required): The identifier of the access key to update.     The identifier can be retrieved from `/{tenantUrlCode}/api/v2/User/{UserIdentifier}/ApiKey`, where `{UserIdentifier}` corresponds to the user that owns the access key.     If the user identifier is not known, it can be obtained from `/{tenantUrlCode}/api/v2/users`. The `securityIdentifier` field represents the user identifier.    - **enabled** (required): A boolean (`true` or `false`) indicating whether the access key is active.    - **ipWhitelisted** (required): A list of IP addresses from which requests can be made using the access key. An empty list removes all IPs from the access key.    - **notes** (required): A free-text field to describe the purpose or usage of the access key.    For example, the request `tenantName/api/v2/ApiKey` with the body:   ```json {   \"accessKey\": \"00000000-0000-0000-0000-000000000001\",   \"enabled\": false,   \"ipWhitelisted\": [],   \"notes\": \"\" } ``` will disable the access key 00000000-0000-0000-0000-000000000001 as well as removing the notes and all whitelisted IP addresses from it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_key_update_access_key_with_http_info(body, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UpdateAccessKeyDTO body: (required)
        :param str tenant_url_code: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_key_update_access_key" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `api_key_update_access_key`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `api_key_update_access_key`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/ApiKey', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
