# coding: utf-8

"""
    CartoVista REST API

    No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)  # noqa: E501

    OpenAPI spec version: 2.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from add_to_cartovista.swagger_client.api_client import ApiClient


class WmtsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def wmts_create_wmts_layer(self, body, tenant_url_code, **kwargs):  # noqa: E501
        """Creates a new WMTS layer.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.wmts_create_wmts_layer(body, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CreateWmtsLayer body: (required)
        :param str tenant_url_code: (required)
        :return: WmtsLayer
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.wmts_create_wmts_layer_with_http_info(body, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.wmts_create_wmts_layer_with_http_info(body, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def wmts_create_wmts_layer_with_http_info(self, body, tenant_url_code, **kwargs):  # noqa: E501
        """Creates a new WMTS layer.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.wmts_create_wmts_layer_with_http_info(body, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CreateWmtsLayer body: (required)
        :param str tenant_url_code: (required)
        :return: WmtsLayer
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method wmts_create_wmts_layer" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `wmts_create_wmts_layer`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `wmts_create_wmts_layer`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/wmts', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='WmtsLayer',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def wmts_delete_wmts_layer(self, identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Deletes the WMTS layer.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.wmts_delete_wmts_layer(identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str identifier: (required)
        :param str tenant_url_code: (required)
        :return: DeleteWmtsLayerResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.wmts_delete_wmts_layer_with_http_info(identifier, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.wmts_delete_wmts_layer_with_http_info(identifier, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def wmts_delete_wmts_layer_with_http_info(self, identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Deletes the WMTS layer.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.wmts_delete_wmts_layer_with_http_info(identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str identifier: (required)
        :param str tenant_url_code: (required)
        :return: DeleteWmtsLayerResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method wmts_delete_wmts_layer" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `wmts_delete_wmts_layer`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `wmts_delete_wmts_layer`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/wmts/{identifier}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DeleteWmtsLayerResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def wmts_get_wmts_layer(self, identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Gets a specific WMTs layer.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.wmts_get_wmts_layer(identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str identifier: (required)
        :param str tenant_url_code: (required)
        :return: WmtsLayer
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.wmts_get_wmts_layer_with_http_info(identifier, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.wmts_get_wmts_layer_with_http_info(identifier, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def wmts_get_wmts_layer_with_http_info(self, identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Gets a specific WMTs layer.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.wmts_get_wmts_layer_with_http_info(identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str identifier: (required)
        :param str tenant_url_code: (required)
        :return: WmtsLayer
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method wmts_get_wmts_layer" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `wmts_get_wmts_layer`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `wmts_get_wmts_layer`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/wmts/{identifier}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='WmtsLayer',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def wmts_get_wmts_layer_details(self, identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Gets the WMTS layer and its related maps.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.wmts_get_wmts_layer_details(identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str identifier: (required)
        :param str tenant_url_code: (required)
        :return: WmtsLayerWithDetails
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.wmts_get_wmts_layer_details_with_http_info(identifier, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.wmts_get_wmts_layer_details_with_http_info(identifier, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def wmts_get_wmts_layer_details_with_http_info(self, identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Gets the WMTS layer and its related maps.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.wmts_get_wmts_layer_details_with_http_info(identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str identifier: (required)
        :param str tenant_url_code: (required)
        :return: WmtsLayerWithDetails
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method wmts_get_wmts_layer_details" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `wmts_get_wmts_layer_details`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `wmts_get_wmts_layer_details`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/wmts/{identifier}/details', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='WmtsLayerWithDetails',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def wmts_get_wmts_layers(self, tenant_url_code, **kwargs):  # noqa: E501
        """Gets all the WMTS layers the user has access to.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.wmts_get_wmts_layers(tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str tenant_url_code: (required)
        :return: list[WmtsLayer]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.wmts_get_wmts_layers_with_http_info(tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.wmts_get_wmts_layers_with_http_info(tenant_url_code, **kwargs)  # noqa: E501
            return data

    def wmts_get_wmts_layers_with_http_info(self, tenant_url_code, **kwargs):  # noqa: E501
        """Gets all the WMTS layers the user has access to.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.wmts_get_wmts_layers_with_http_info(tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str tenant_url_code: (required)
        :return: list[WmtsLayer]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method wmts_get_wmts_layers" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `wmts_get_wmts_layers`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/wmts', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[WmtsLayer]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def wmts_update_wmts_layer(self, body, identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Updates the WMTS layer's properties.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.wmts_update_wmts_layer(body, identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UpdateWmtsLayerParameter body: (required)
        :param str identifier: (required)
        :param str tenant_url_code: (required)
        :return: WmtsLayer
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.wmts_update_wmts_layer_with_http_info(body, identifier, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.wmts_update_wmts_layer_with_http_info(body, identifier, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def wmts_update_wmts_layer_with_http_info(self, body, identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Updates the WMTS layer's properties.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.wmts_update_wmts_layer_with_http_info(body, identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UpdateWmtsLayerParameter body: (required)
        :param str identifier: (required)
        :param str tenant_url_code: (required)
        :return: WmtsLayer
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'identifier', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method wmts_update_wmts_layer" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `wmts_update_wmts_layer`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `wmts_update_wmts_layer`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `wmts_update_wmts_layer`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/wmts/{identifier}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='WmtsLayer',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def wmts_update_wmts_layer_permissions(self, body, identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Updates the WMTS layer's permissions.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.wmts_update_wmts_layer_permissions(body, identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ApplyGenericPermissionsParameter body: (required)
        :param str identifier: (required)
        :param str tenant_url_code: (required)
        :return: list[PermissionPairComplexDTO]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.wmts_update_wmts_layer_permissions_with_http_info(body, identifier, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.wmts_update_wmts_layer_permissions_with_http_info(body, identifier, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def wmts_update_wmts_layer_permissions_with_http_info(self, body, identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Updates the WMTS layer's permissions.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.wmts_update_wmts_layer_permissions_with_http_info(body, identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ApplyGenericPermissionsParameter body: (required)
        :param str identifier: (required)
        :param str tenant_url_code: (required)
        :return: list[PermissionPairComplexDTO]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'identifier', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method wmts_update_wmts_layer_permissions" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `wmts_update_wmts_layer_permissions`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `wmts_update_wmts_layer_permissions`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `wmts_update_wmts_layer_permissions`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/wmts/{identifier}/permissions', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[PermissionPairComplexDTO]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
