# coding: utf-8

"""
    CartoVista REST API

    No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)  # noqa: E501

    OpenAPI spec version: 2.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from add_to_cartovista.swagger_client.api_client import ApiClient


class SlideApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def slide_create_slide_folder(self, body, tenant_url_code, **kwargs):  # noqa: E501
        """Creates a slide folder.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.slide_create_slide_folder(body, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SlideFolderCreateParam body: (required)
        :param str tenant_url_code: (required)
        :return: SlideFolder
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.slide_create_slide_folder_with_http_info(body, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.slide_create_slide_folder_with_http_info(body, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def slide_create_slide_folder_with_http_info(self, body, tenant_url_code, **kwargs):  # noqa: E501
        """Creates a slide folder.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.slide_create_slide_folder_with_http_info(body, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SlideFolderCreateParam body: (required)
        :param str tenant_url_code: (required)
        :return: SlideFolder
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method slide_create_slide_folder" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `slide_create_slide_folder`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `slide_create_slide_folder`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/slide-folder', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SlideFolder',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def slide_delete_slide(self, slide_id, tenant_url_code, **kwargs):  # noqa: E501
        """Deletes the slide.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.slide_delete_slide(slide_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str slide_id: (required)
        :param str tenant_url_code: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.slide_delete_slide_with_http_info(slide_id, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.slide_delete_slide_with_http_info(slide_id, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def slide_delete_slide_with_http_info(self, slide_id, tenant_url_code, **kwargs):  # noqa: E501
        """Deletes the slide.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.slide_delete_slide_with_http_info(slide_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str slide_id: (required)
        :param str tenant_url_code: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['slide_id', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method slide_delete_slide" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'slide_id' is set
        if ('slide_id' not in params or
                params['slide_id'] is None):
            raise ValueError("Missing the required parameter `slide_id` when calling `slide_delete_slide`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `slide_delete_slide`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'slide_id' in params:
            path_params['slideId'] = params['slide_id']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/slides/{slideId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def slide_delete_slide_analysis(self, slide_id, analysis_id, tenant_url_code, **kwargs):  # noqa: E501
        """Deletes the analysis from the slide.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.slide_delete_slide_analysis(slide_id, analysis_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str slide_id: (required)
        :param str analysis_id: (required)
        :param str tenant_url_code: (required)
        :return: Slide
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.slide_delete_slide_analysis_with_http_info(slide_id, analysis_id, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.slide_delete_slide_analysis_with_http_info(slide_id, analysis_id, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def slide_delete_slide_analysis_with_http_info(self, slide_id, analysis_id, tenant_url_code, **kwargs):  # noqa: E501
        """Deletes the analysis from the slide.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.slide_delete_slide_analysis_with_http_info(slide_id, analysis_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str slide_id: (required)
        :param str analysis_id: (required)
        :param str tenant_url_code: (required)
        :return: Slide
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['slide_id', 'analysis_id', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method slide_delete_slide_analysis" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'slide_id' is set
        if ('slide_id' not in params or
                params['slide_id'] is None):
            raise ValueError("Missing the required parameter `slide_id` when calling `slide_delete_slide_analysis`")  # noqa: E501
        # verify the required parameter 'analysis_id' is set
        if ('analysis_id' not in params or
                params['analysis_id'] is None):
            raise ValueError("Missing the required parameter `analysis_id` when calling `slide_delete_slide_analysis`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `slide_delete_slide_analysis`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'slide_id' in params:
            path_params['slideId'] = params['slide_id']  # noqa: E501
        if 'analysis_id' in params:
            path_params['analysisId'] = params['analysis_id']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/slides/{slideId}/analysis/{analysisId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Slide',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def slide_delete_slide_folder(self, slide_folder_id, tenant_url_code, **kwargs):  # noqa: E501
        """Deletes the slide folder.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.slide_delete_slide_folder(slide_folder_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str slide_folder_id: (required)
        :param str tenant_url_code: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.slide_delete_slide_folder_with_http_info(slide_folder_id, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.slide_delete_slide_folder_with_http_info(slide_folder_id, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def slide_delete_slide_folder_with_http_info(self, slide_folder_id, tenant_url_code, **kwargs):  # noqa: E501
        """Deletes the slide folder.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.slide_delete_slide_folder_with_http_info(slide_folder_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str slide_folder_id: (required)
        :param str tenant_url_code: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['slide_folder_id', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method slide_delete_slide_folder" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'slide_folder_id' is set
        if ('slide_folder_id' not in params or
                params['slide_folder_id'] is None):
            raise ValueError("Missing the required parameter `slide_folder_id` when calling `slide_delete_slide_folder`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `slide_delete_slide_folder`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'slide_folder_id' in params:
            path_params['slideFolderId'] = params['slide_folder_id']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/slide-folder/{slideFolderId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def slide_get_slide(self, slide_id, tenant_url_code, **kwargs):  # noqa: E501
        """Gets a specific slide.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.slide_get_slide(slide_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str slide_id: (required)
        :param str tenant_url_code: (required)
        :return: Slide
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.slide_get_slide_with_http_info(slide_id, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.slide_get_slide_with_http_info(slide_id, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def slide_get_slide_with_http_info(self, slide_id, tenant_url_code, **kwargs):  # noqa: E501
        """Gets a specific slide.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.slide_get_slide_with_http_info(slide_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str slide_id: (required)
        :param str tenant_url_code: (required)
        :return: Slide
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['slide_id', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method slide_get_slide" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'slide_id' is set
        if ('slide_id' not in params or
                params['slide_id'] is None):
            raise ValueError("Missing the required parameter `slide_id` when calling `slide_get_slide`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `slide_get_slide`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'slide_id' in params:
            path_params['slideId'] = params['slide_id']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/slides/{slideId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Slide',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def slide_get_slide_folder(self, folder_id, tenant_url_code, **kwargs):  # noqa: E501
        """Gets a specific folder.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.slide_get_slide_folder(folder_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str folder_id: (required)
        :param str tenant_url_code: (required)
        :return: SlideFolder
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.slide_get_slide_folder_with_http_info(folder_id, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.slide_get_slide_folder_with_http_info(folder_id, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def slide_get_slide_folder_with_http_info(self, folder_id, tenant_url_code, **kwargs):  # noqa: E501
        """Gets a specific folder.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.slide_get_slide_folder_with_http_info(folder_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str folder_id: (required)
        :param str tenant_url_code: (required)
        :return: SlideFolder
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['folder_id', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method slide_get_slide_folder" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'folder_id' is set
        if ('folder_id' not in params or
                params['folder_id'] is None):
            raise ValueError("Missing the required parameter `folder_id` when calling `slide_get_slide_folder`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `slide_get_slide_folder`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'folder_id' in params:
            path_params['folderId'] = params['folder_id']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/slide-folder/{folderId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SlideFolder',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def slide_move_slide_item(self, item_id, is_item_folder, new_parent_folder, preceding_item_id, tenant_url_code, **kwargs):  # noqa: E501
        """Moves a slide item to a specified parent folder and position.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.slide_move_slide_item(item_id, is_item_folder, new_parent_folder, preceding_item_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str item_id: (required)
        :param bool is_item_folder: (required)
        :param str new_parent_folder: (required)
        :param str preceding_item_id: (required)
        :param str tenant_url_code: (required)
        :return: MoveSlideItemResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.slide_move_slide_item_with_http_info(item_id, is_item_folder, new_parent_folder, preceding_item_id, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.slide_move_slide_item_with_http_info(item_id, is_item_folder, new_parent_folder, preceding_item_id, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def slide_move_slide_item_with_http_info(self, item_id, is_item_folder, new_parent_folder, preceding_item_id, tenant_url_code, **kwargs):  # noqa: E501
        """Moves a slide item to a specified parent folder and position.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.slide_move_slide_item_with_http_info(item_id, is_item_folder, new_parent_folder, preceding_item_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str item_id: (required)
        :param bool is_item_folder: (required)
        :param str new_parent_folder: (required)
        :param str preceding_item_id: (required)
        :param str tenant_url_code: (required)
        :return: MoveSlideItemResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['item_id', 'is_item_folder', 'new_parent_folder', 'preceding_item_id', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method slide_move_slide_item" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'item_id' is set
        if ('item_id' not in params or
                params['item_id'] is None):
            raise ValueError("Missing the required parameter `item_id` when calling `slide_move_slide_item`")  # noqa: E501
        # verify the required parameter 'is_item_folder' is set
        if ('is_item_folder' not in params or
                params['is_item_folder'] is None):
            raise ValueError("Missing the required parameter `is_item_folder` when calling `slide_move_slide_item`")  # noqa: E501
        # verify the required parameter 'new_parent_folder' is set
        if ('new_parent_folder' not in params or
                params['new_parent_folder'] is None):
            raise ValueError("Missing the required parameter `new_parent_folder` when calling `slide_move_slide_item`")  # noqa: E501
        # verify the required parameter 'preceding_item_id' is set
        if ('preceding_item_id' not in params or
                params['preceding_item_id'] is None):
            raise ValueError("Missing the required parameter `preceding_item_id` when calling `slide_move_slide_item`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `slide_move_slide_item`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'item_id' in params:
            path_params['itemId'] = params['item_id']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []
        if 'is_item_folder' in params:
            query_params.append(('isItemFolder', params['is_item_folder']))  # noqa: E501
        if 'new_parent_folder' in params:
            query_params.append(('newParentFolder', params['new_parent_folder']))  # noqa: E501
        if 'preceding_item_id' in params:
            query_params.append(('precedingItemId', params['preceding_item_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/slides/{itemId}/move', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MoveSlideItemResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def slide_update_default_slide_thumbnail(self, body, map_id, tenant_url_code, **kwargs):  # noqa: E501
        """Updates the map's default slide's thumbnail.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.slide_update_default_slide_thumbnail(body, map_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str body: (required)
        :param str map_id: (required)
        :param str tenant_url_code: (required)
        :return: DefaultSlideThumbnailUpdateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.slide_update_default_slide_thumbnail_with_http_info(body, map_id, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.slide_update_default_slide_thumbnail_with_http_info(body, map_id, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def slide_update_default_slide_thumbnail_with_http_info(self, body, map_id, tenant_url_code, **kwargs):  # noqa: E501
        """Updates the map's default slide's thumbnail.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.slide_update_default_slide_thumbnail_with_http_info(body, map_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str body: (required)
        :param str map_id: (required)
        :param str tenant_url_code: (required)
        :return: DefaultSlideThumbnailUpdateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'map_id', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method slide_update_default_slide_thumbnail" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `slide_update_default_slide_thumbnail`")  # noqa: E501
        # verify the required parameter 'map_id' is set
        if ('map_id' not in params or
                params['map_id'] is None):
            raise ValueError("Missing the required parameter `map_id` when calling `slide_update_default_slide_thumbnail`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `slide_update_default_slide_thumbnail`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'map_id' in params:
            path_params['mapId'] = params['map_id']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/maps/{mapId}/default-slide-thumbnail', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DefaultSlideThumbnailUpdateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def slide_update_slide(self, body, slide_id, tenant_url_code, **kwargs):  # noqa: E501
        """Updates the slide.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.slide_update_slide(body, slide_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SlideCreateUpdate body: (required)
        :param str slide_id: (required)
        :param str tenant_url_code: (required)
        :return: Slide
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.slide_update_slide_with_http_info(body, slide_id, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.slide_update_slide_with_http_info(body, slide_id, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def slide_update_slide_with_http_info(self, body, slide_id, tenant_url_code, **kwargs):  # noqa: E501
        """Updates the slide.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.slide_update_slide_with_http_info(body, slide_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SlideCreateUpdate body: (required)
        :param str slide_id: (required)
        :param str tenant_url_code: (required)
        :return: Slide
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'slide_id', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method slide_update_slide" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `slide_update_slide`")  # noqa: E501
        # verify the required parameter 'slide_id' is set
        if ('slide_id' not in params or
                params['slide_id'] is None):
            raise ValueError("Missing the required parameter `slide_id` when calling `slide_update_slide`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `slide_update_slide`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'slide_id' in params:
            path_params['slideId'] = params['slide_id']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/slides/{slideId}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Slide',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def slide_update_slide_extent_from_layers(self, body, slide_id, tenant_url_code, **kwargs):  # noqa: E501
        """Updates the slide's extent by combining the layers' extents.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.slide_update_slide_extent_from_layers(body, slide_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[str] body: (required)
        :param str slide_id: (required)
        :param str tenant_url_code: (required)
        :return: Slide
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.slide_update_slide_extent_from_layers_with_http_info(body, slide_id, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.slide_update_slide_extent_from_layers_with_http_info(body, slide_id, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def slide_update_slide_extent_from_layers_with_http_info(self, body, slide_id, tenant_url_code, **kwargs):  # noqa: E501
        """Updates the slide's extent by combining the layers' extents.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.slide_update_slide_extent_from_layers_with_http_info(body, slide_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[str] body: (required)
        :param str slide_id: (required)
        :param str tenant_url_code: (required)
        :return: Slide
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'slide_id', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method slide_update_slide_extent_from_layers" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `slide_update_slide_extent_from_layers`")  # noqa: E501
        # verify the required parameter 'slide_id' is set
        if ('slide_id' not in params or
                params['slide_id'] is None):
            raise ValueError("Missing the required parameter `slide_id` when calling `slide_update_slide_extent_from_layers`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `slide_update_slide_extent_from_layers`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'slide_id' in params:
            path_params['slideId'] = params['slide_id']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/slides/{slideId}/extent-from-layers', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Slide',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def slide_update_slide_folder(self, body, slide_folder_id, tenant_url_code, **kwargs):  # noqa: E501
        """Updates the slide folder.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.slide_update_slide_folder(body, slide_folder_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SlideFolderUpdateParam body: (required)
        :param str slide_folder_id: (required)
        :param str tenant_url_code: (required)
        :return: SlideFolder
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.slide_update_slide_folder_with_http_info(body, slide_folder_id, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.slide_update_slide_folder_with_http_info(body, slide_folder_id, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def slide_update_slide_folder_with_http_info(self, body, slide_folder_id, tenant_url_code, **kwargs):  # noqa: E501
        """Updates the slide folder.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.slide_update_slide_folder_with_http_info(body, slide_folder_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SlideFolderUpdateParam body: (required)
        :param str slide_folder_id: (required)
        :param str tenant_url_code: (required)
        :return: SlideFolder
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'slide_folder_id', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method slide_update_slide_folder" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `slide_update_slide_folder`")  # noqa: E501
        # verify the required parameter 'slide_folder_id' is set
        if ('slide_folder_id' not in params or
                params['slide_folder_id'] is None):
            raise ValueError("Missing the required parameter `slide_folder_id` when calling `slide_update_slide_folder`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `slide_update_slide_folder`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'slide_folder_id' in params:
            path_params['slideFolderId'] = params['slide_folder_id']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/slide-folder/{slideFolderId}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SlideFolder',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def slide_update_slide_theme_set(self, body, slide_id, tenant_url_code, **kwargs):  # noqa: E501
        """Updates the slide's theme set.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.slide_update_slide_theme_set(body, slide_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str body: (required)
        :param str slide_id: (required)
        :param str tenant_url_code: (required)
        :return: Slide
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.slide_update_slide_theme_set_with_http_info(body, slide_id, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.slide_update_slide_theme_set_with_http_info(body, slide_id, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def slide_update_slide_theme_set_with_http_info(self, body, slide_id, tenant_url_code, **kwargs):  # noqa: E501
        """Updates the slide's theme set.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.slide_update_slide_theme_set_with_http_info(body, slide_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str body: (required)
        :param str slide_id: (required)
        :param str tenant_url_code: (required)
        :return: Slide
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'slide_id', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method slide_update_slide_theme_set" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `slide_update_slide_theme_set`")  # noqa: E501
        # verify the required parameter 'slide_id' is set
        if ('slide_id' not in params or
                params['slide_id'] is None):
            raise ValueError("Missing the required parameter `slide_id` when calling `slide_update_slide_theme_set`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `slide_update_slide_theme_set`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'slide_id' in params:
            path_params['slideId'] = params['slide_id']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/slides/{slideId}/themeset', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Slide',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
