# coding: utf-8

"""
    CartoVista REST API

    No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)  # noqa: E501

    OpenAPI spec version: 2.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from add_to_cartovista.swagger_client.api_client import ApiClient


class LayerSettingsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def layer_settings_get_default_layer_settings(self, layer_id, tenant_url_code, **kwargs):  # noqa: E501
        """Gets the default settings for the layer.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.layer_settings_get_default_layer_settings(layer_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str layer_id: (required)
        :param str tenant_url_code: (required)
        :return: LayerSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.layer_settings_get_default_layer_settings_with_http_info(layer_id, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.layer_settings_get_default_layer_settings_with_http_info(layer_id, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def layer_settings_get_default_layer_settings_with_http_info(self, layer_id, tenant_url_code, **kwargs):  # noqa: E501
        """Gets the default settings for the layer.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.layer_settings_get_default_layer_settings_with_http_info(layer_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str layer_id: (required)
        :param str tenant_url_code: (required)
        :return: LayerSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['layer_id', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method layer_settings_get_default_layer_settings" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'layer_id' is set
        if ('layer_id' not in params or
                params['layer_id'] is None):
            raise ValueError("Missing the required parameter `layer_id` when calling `layer_settings_get_default_layer_settings`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `layer_settings_get_default_layer_settings`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'layer_id' in params:
            path_params['layerId'] = params['layer_id']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/layerSettings/{layerId}/default', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='LayerSettings',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def layer_settings_get_layer_settings(self, layer_settings_id, tenant_url_code, **kwargs):  # noqa: E501
        """Gets a specific layer settings.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.layer_settings_get_layer_settings(layer_settings_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str layer_settings_id: (required)
        :param str tenant_url_code: (required)
        :return: LayerSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.layer_settings_get_layer_settings_with_http_info(layer_settings_id, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.layer_settings_get_layer_settings_with_http_info(layer_settings_id, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def layer_settings_get_layer_settings_with_http_info(self, layer_settings_id, tenant_url_code, **kwargs):  # noqa: E501
        """Gets a specific layer settings.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.layer_settings_get_layer_settings_with_http_info(layer_settings_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str layer_settings_id: (required)
        :param str tenant_url_code: (required)
        :return: LayerSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['layer_settings_id', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method layer_settings_get_layer_settings" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'layer_settings_id' is set
        if ('layer_settings_id' not in params or
                params['layer_settings_id'] is None):
            raise ValueError("Missing the required parameter `layer_settings_id` when calling `layer_settings_get_layer_settings`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `layer_settings_get_layer_settings`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'layer_settings_id' in params:
            path_params['layerSettingsId'] = params['layer_settings_id']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/layerSettings/{layerSettingsId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='LayerSettings',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def layer_settings_get_map_layer_settings(self, map_id, layer_id, tenant_url_code, **kwargs):  # noqa: E501
        """Gets the layer settings for a specific map.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.layer_settings_get_map_layer_settings(map_id, layer_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str map_id: (required)
        :param str layer_id: (required)
        :param str tenant_url_code: (required)
        :return: LayerSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.layer_settings_get_map_layer_settings_with_http_info(map_id, layer_id, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.layer_settings_get_map_layer_settings_with_http_info(map_id, layer_id, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def layer_settings_get_map_layer_settings_with_http_info(self, map_id, layer_id, tenant_url_code, **kwargs):  # noqa: E501
        """Gets the layer settings for a specific map.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.layer_settings_get_map_layer_settings_with_http_info(map_id, layer_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str map_id: (required)
        :param str layer_id: (required)
        :param str tenant_url_code: (required)
        :return: LayerSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['map_id', 'layer_id', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method layer_settings_get_map_layer_settings" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'map_id' is set
        if ('map_id' not in params or
                params['map_id'] is None):
            raise ValueError("Missing the required parameter `map_id` when calling `layer_settings_get_map_layer_settings`")  # noqa: E501
        # verify the required parameter 'layer_id' is set
        if ('layer_id' not in params or
                params['layer_id'] is None):
            raise ValueError("Missing the required parameter `layer_id` when calling `layer_settings_get_map_layer_settings`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `layer_settings_get_map_layer_settings`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'map_id' in params:
            path_params['mapId'] = params['map_id']  # noqa: E501
        if 'layer_id' in params:
            path_params['layerId'] = params['layer_id']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/layerSettings/{layerId}/map/{mapId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='LayerSettings',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def layer_settings_update_alias(self, body, layer_settings_id, tenant_url_code, **kwargs):  # noqa: E501
        """Updates the layer settings' alias.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.layer_settings_update_alias(body, layer_settings_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UpdateAliasParameter2 body: (required)
        :param str layer_settings_id: (required)
        :param str tenant_url_code: (required)
        :return: LayerSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.layer_settings_update_alias_with_http_info(body, layer_settings_id, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.layer_settings_update_alias_with_http_info(body, layer_settings_id, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def layer_settings_update_alias_with_http_info(self, body, layer_settings_id, tenant_url_code, **kwargs):  # noqa: E501
        """Updates the layer settings' alias.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.layer_settings_update_alias_with_http_info(body, layer_settings_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UpdateAliasParameter2 body: (required)
        :param str layer_settings_id: (required)
        :param str tenant_url_code: (required)
        :return: LayerSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'layer_settings_id', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method layer_settings_update_alias" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `layer_settings_update_alias`")  # noqa: E501
        # verify the required parameter 'layer_settings_id' is set
        if ('layer_settings_id' not in params or
                params['layer_settings_id'] is None):
            raise ValueError("Missing the required parameter `layer_settings_id` when calling `layer_settings_update_alias`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `layer_settings_update_alias`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'layer_settings_id' in params:
            path_params['layerSettingsId'] = params['layer_settings_id']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/layerSettings/{layerSettingsId}/alias', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='LayerSettings',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def layer_settings_update_common_settings(self, body, layer_settings_id, tenant_url_code, **kwargs):  # noqa: E501
        """Allows the update of all of the layer's non-geometry style settings in one call  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.layer_settings_update_common_settings(body, layer_settings_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param LayerCommonSettingsUpdateParameter body: (required)
        :param str layer_settings_id: (required)
        :param str tenant_url_code: (required)
        :return: LayerSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.layer_settings_update_common_settings_with_http_info(body, layer_settings_id, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.layer_settings_update_common_settings_with_http_info(body, layer_settings_id, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def layer_settings_update_common_settings_with_http_info(self, body, layer_settings_id, tenant_url_code, **kwargs):  # noqa: E501
        """Allows the update of all of the layer's non-geometry style settings in one call  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.layer_settings_update_common_settings_with_http_info(body, layer_settings_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param LayerCommonSettingsUpdateParameter body: (required)
        :param str layer_settings_id: (required)
        :param str tenant_url_code: (required)
        :return: LayerSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'layer_settings_id', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method layer_settings_update_common_settings" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `layer_settings_update_common_settings`")  # noqa: E501
        # verify the required parameter 'layer_settings_id' is set
        if ('layer_settings_id' not in params or
                params['layer_settings_id'] is None):
            raise ValueError("Missing the required parameter `layer_settings_id` when calling `layer_settings_update_common_settings`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `layer_settings_update_common_settings`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'layer_settings_id' in params:
            path_params['layerSettingsId'] = params['layer_settings_id']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/layerSettings/{layerSettingsId}/common-settings', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='LayerSettings',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def layer_settings_update_effect(self, body, layer_settings_id, tenant_url_code, **kwargs):  # noqa: E501
        """Updates the layer settings' effects.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.layer_settings_update_effect(body, layer_settings_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param LayerSettingsEffects body: (required)
        :param str layer_settings_id: (required)
        :param str tenant_url_code: (required)
        :return: LayerSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.layer_settings_update_effect_with_http_info(body, layer_settings_id, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.layer_settings_update_effect_with_http_info(body, layer_settings_id, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def layer_settings_update_effect_with_http_info(self, body, layer_settings_id, tenant_url_code, **kwargs):  # noqa: E501
        """Updates the layer settings' effects.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.layer_settings_update_effect_with_http_info(body, layer_settings_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param LayerSettingsEffects body: (required)
        :param str layer_settings_id: (required)
        :param str tenant_url_code: (required)
        :return: LayerSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'layer_settings_id', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method layer_settings_update_effect" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `layer_settings_update_effect`")  # noqa: E501
        # verify the required parameter 'layer_settings_id' is set
        if ('layer_settings_id' not in params or
                params['layer_settings_id'] is None):
            raise ValueError("Missing the required parameter `layer_settings_id` when calling `layer_settings_update_effect`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `layer_settings_update_effect`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'layer_settings_id' in params:
            path_params['layerSettingsId'] = params['layer_settings_id']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/layerSettings/{layerSettingsId}/effects', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='LayerSettings',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def layer_settings_update_general(self, body, layer_settings_id, tenant_url_code, **kwargs):  # noqa: E501
        """Updates the layer settings' general settings.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.layer_settings_update_general(body, layer_settings_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param LayerSettingsGeneral body: (required)
        :param str layer_settings_id: (required)
        :param str tenant_url_code: (required)
        :return: LayerSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.layer_settings_update_general_with_http_info(body, layer_settings_id, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.layer_settings_update_general_with_http_info(body, layer_settings_id, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def layer_settings_update_general_with_http_info(self, body, layer_settings_id, tenant_url_code, **kwargs):  # noqa: E501
        """Updates the layer settings' general settings.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.layer_settings_update_general_with_http_info(body, layer_settings_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param LayerSettingsGeneral body: (required)
        :param str layer_settings_id: (required)
        :param str tenant_url_code: (required)
        :return: LayerSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'layer_settings_id', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method layer_settings_update_general" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `layer_settings_update_general`")  # noqa: E501
        # verify the required parameter 'layer_settings_id' is set
        if ('layer_settings_id' not in params or
                params['layer_settings_id'] is None):
            raise ValueError("Missing the required parameter `layer_settings_id` when calling `layer_settings_update_general`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `layer_settings_update_general`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'layer_settings_id' in params:
            path_params['layerSettingsId'] = params['layer_settings_id']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/layerSettings/{layerSettingsId}/general', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='LayerSettings',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def layer_settings_update_geometry_style(self, body, layer_settings_id, tenant_url_code, **kwargs):  # noqa: E501
        """Updates the layer settings' geometry style. The style object must match the layer's geometry type.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.layer_settings_update_geometry_style(body, layer_settings_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param object body: (required)
        :param str layer_settings_id: (required)
        :param str tenant_url_code: (required)
        :return: LayerSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.layer_settings_update_geometry_style_with_http_info(body, layer_settings_id, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.layer_settings_update_geometry_style_with_http_info(body, layer_settings_id, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def layer_settings_update_geometry_style_with_http_info(self, body, layer_settings_id, tenant_url_code, **kwargs):  # noqa: E501
        """Updates the layer settings' geometry style. The style object must match the layer's geometry type.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.layer_settings_update_geometry_style_with_http_info(body, layer_settings_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param object body: (required)
        :param str layer_settings_id: (required)
        :param str tenant_url_code: (required)
        :return: LayerSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'layer_settings_id', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method layer_settings_update_geometry_style" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `layer_settings_update_geometry_style`")  # noqa: E501
        # verify the required parameter 'layer_settings_id' is set
        if ('layer_settings_id' not in params or
                params['layer_settings_id'] is None):
            raise ValueError("Missing the required parameter `layer_settings_id` when calling `layer_settings_update_geometry_style`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `layer_settings_update_geometry_style`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'layer_settings_id' in params:
            path_params['layerSettingsId'] = params['layer_settings_id']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/layerSettings/{layerSettingsId}/geometryStyle', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='LayerSettings',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def layer_settings_update_interactivity(self, body, layer_settings_id, tenant_url_code, **kwargs):  # noqa: E501
        """Updates the layer settings' interactivity settings.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.layer_settings_update_interactivity(body, layer_settings_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param LayerSettingsInteractivity body: (required)
        :param str layer_settings_id: (required)
        :param str tenant_url_code: (required)
        :return: LayerSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.layer_settings_update_interactivity_with_http_info(body, layer_settings_id, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.layer_settings_update_interactivity_with_http_info(body, layer_settings_id, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def layer_settings_update_interactivity_with_http_info(self, body, layer_settings_id, tenant_url_code, **kwargs):  # noqa: E501
        """Updates the layer settings' interactivity settings.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.layer_settings_update_interactivity_with_http_info(body, layer_settings_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param LayerSettingsInteractivity body: (required)
        :param str layer_settings_id: (required)
        :param str tenant_url_code: (required)
        :return: LayerSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'layer_settings_id', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method layer_settings_update_interactivity" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `layer_settings_update_interactivity`")  # noqa: E501
        # verify the required parameter 'layer_settings_id' is set
        if ('layer_settings_id' not in params or
                params['layer_settings_id'] is None):
            raise ValueError("Missing the required parameter `layer_settings_id` when calling `layer_settings_update_interactivity`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `layer_settings_update_interactivity`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'layer_settings_id' in params:
            path_params['layerSettingsId'] = params['layer_settings_id']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/layerSettings/{layerSettingsId}/interactivity', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='LayerSettings',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def layer_settings_update_label(self, body, layer_settings_id, tenant_url_code, **kwargs):  # noqa: E501
        """Updates the layer settings' label settings.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.layer_settings_update_label(body, layer_settings_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param LayerSettingsLabel body: (required)
        :param str layer_settings_id: (required)
        :param str tenant_url_code: (required)
        :return: LayerSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.layer_settings_update_label_with_http_info(body, layer_settings_id, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.layer_settings_update_label_with_http_info(body, layer_settings_id, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def layer_settings_update_label_with_http_info(self, body, layer_settings_id, tenant_url_code, **kwargs):  # noqa: E501
        """Updates the layer settings' label settings.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.layer_settings_update_label_with_http_info(body, layer_settings_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param LayerSettingsLabel body: (required)
        :param str layer_settings_id: (required)
        :param str tenant_url_code: (required)
        :return: LayerSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'layer_settings_id', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method layer_settings_update_label" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `layer_settings_update_label`")  # noqa: E501
        # verify the required parameter 'layer_settings_id' is set
        if ('layer_settings_id' not in params or
                params['layer_settings_id'] is None):
            raise ValueError("Missing the required parameter `layer_settings_id` when calling `layer_settings_update_label`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `layer_settings_update_label`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'layer_settings_id' in params:
            path_params['layerSettingsId'] = params['layer_settings_id']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/layerSettings/{layerSettingsId}/label', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='LayerSettings',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def layer_settings_update_legend(self, body, layer_settings_id, tenant_url_code, **kwargs):  # noqa: E501
        """Updates the layer settings' legend settings.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.layer_settings_update_legend(body, layer_settings_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param LayerSettingsLegend body: (required)
        :param str layer_settings_id: (required)
        :param str tenant_url_code: (required)
        :return: LayerSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.layer_settings_update_legend_with_http_info(body, layer_settings_id, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.layer_settings_update_legend_with_http_info(body, layer_settings_id, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def layer_settings_update_legend_with_http_info(self, body, layer_settings_id, tenant_url_code, **kwargs):  # noqa: E501
        """Updates the layer settings' legend settings.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.layer_settings_update_legend_with_http_info(body, layer_settings_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param LayerSettingsLegend body: (required)
        :param str layer_settings_id: (required)
        :param str tenant_url_code: (required)
        :return: LayerSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'layer_settings_id', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method layer_settings_update_legend" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `layer_settings_update_legend`")  # noqa: E501
        # verify the required parameter 'layer_settings_id' is set
        if ('layer_settings_id' not in params or
                params['layer_settings_id'] is None):
            raise ValueError("Missing the required parameter `layer_settings_id` when calling `layer_settings_update_legend`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `layer_settings_update_legend`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'layer_settings_id' in params:
            path_params['layerSettingsId'] = params['layer_settings_id']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/layerSettings/{layerSettingsId}/legend', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='LayerSettings',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def layer_settings_update_point_geometry_style(self, body, layer_settings_id, tenant_url_code, **kwargs):  # noqa: E501
        """Updates the layer settings' geometry style. The style object must match the layer's geometry type.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.layer_settings_update_point_geometry_style(body, layer_settings_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param LayerSettingsPoint body: (required)
        :param str layer_settings_id: (required)
        :param str tenant_url_code: (required)
        :return: LayerSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.layer_settings_update_point_geometry_style_with_http_info(body, layer_settings_id, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.layer_settings_update_point_geometry_style_with_http_info(body, layer_settings_id, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def layer_settings_update_point_geometry_style_with_http_info(self, body, layer_settings_id, tenant_url_code, **kwargs):  # noqa: E501
        """Updates the layer settings' geometry style. The style object must match the layer's geometry type.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.layer_settings_update_point_geometry_style_with_http_info(body, layer_settings_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param LayerSettingsPoint body: (required)
        :param str layer_settings_id: (required)
        :param str tenant_url_code: (required)
        :return: LayerSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'layer_settings_id', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method layer_settings_update_point_geometry_style" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `layer_settings_update_point_geometry_style`")  # noqa: E501
        # verify the required parameter 'layer_settings_id' is set
        if ('layer_settings_id' not in params or
                params['layer_settings_id'] is None):
            raise ValueError("Missing the required parameter `layer_settings_id` when calling `layer_settings_update_point_geometry_style`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `layer_settings_update_point_geometry_style`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'layer_settings_id' in params:
            path_params['layerSettingsId'] = params['layer_settings_id']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/layerSettings/{layerSettingsId}/pointGeometryStyle', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='LayerSettings',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def layer_settings_update_polygon_geometry_style(self, body, layer_settings_id, tenant_url_code, **kwargs):  # noqa: E501
        """Updates the layer settings' geometry style. The style object must match the layer's geometry type.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.layer_settings_update_polygon_geometry_style(body, layer_settings_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param LayerSettingsPolygon body: (required)
        :param str layer_settings_id: (required)
        :param str tenant_url_code: (required)
        :return: LayerSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.layer_settings_update_polygon_geometry_style_with_http_info(body, layer_settings_id, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.layer_settings_update_polygon_geometry_style_with_http_info(body, layer_settings_id, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def layer_settings_update_polygon_geometry_style_with_http_info(self, body, layer_settings_id, tenant_url_code, **kwargs):  # noqa: E501
        """Updates the layer settings' geometry style. The style object must match the layer's geometry type.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.layer_settings_update_polygon_geometry_style_with_http_info(body, layer_settings_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param LayerSettingsPolygon body: (required)
        :param str layer_settings_id: (required)
        :param str tenant_url_code: (required)
        :return: LayerSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'layer_settings_id', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method layer_settings_update_polygon_geometry_style" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `layer_settings_update_polygon_geometry_style`")  # noqa: E501
        # verify the required parameter 'layer_settings_id' is set
        if ('layer_settings_id' not in params or
                params['layer_settings_id'] is None):
            raise ValueError("Missing the required parameter `layer_settings_id` when calling `layer_settings_update_polygon_geometry_style`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `layer_settings_update_polygon_geometry_style`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'layer_settings_id' in params:
            path_params['layerSettingsId'] = params['layer_settings_id']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/layerSettings/{layerSettingsId}/polygonGeometryStyle', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='LayerSettings',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def layer_settings_update_polyline_geometry_style(self, body, layer_settings_id, tenant_url_code, **kwargs):  # noqa: E501
        """Updates the layer settings' geometry style. The style object must match the layer's geometry type.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.layer_settings_update_polyline_geometry_style(body, layer_settings_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param LayerSettingsPolyline body: (required)
        :param str layer_settings_id: (required)
        :param str tenant_url_code: (required)
        :return: LayerSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.layer_settings_update_polyline_geometry_style_with_http_info(body, layer_settings_id, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.layer_settings_update_polyline_geometry_style_with_http_info(body, layer_settings_id, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def layer_settings_update_polyline_geometry_style_with_http_info(self, body, layer_settings_id, tenant_url_code, **kwargs):  # noqa: E501
        """Updates the layer settings' geometry style. The style object must match the layer's geometry type.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.layer_settings_update_polyline_geometry_style_with_http_info(body, layer_settings_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param LayerSettingsPolyline body: (required)
        :param str layer_settings_id: (required)
        :param str tenant_url_code: (required)
        :return: LayerSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'layer_settings_id', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method layer_settings_update_polyline_geometry_style" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `layer_settings_update_polyline_geometry_style`")  # noqa: E501
        # verify the required parameter 'layer_settings_id' is set
        if ('layer_settings_id' not in params or
                params['layer_settings_id'] is None):
            raise ValueError("Missing the required parameter `layer_settings_id` when calling `layer_settings_update_polyline_geometry_style`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `layer_settings_update_polyline_geometry_style`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'layer_settings_id' in params:
            path_params['layerSettingsId'] = params['layer_settings_id']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/layerSettings/{layerSettingsId}/polylineGeometryStyle', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='LayerSettings',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def layer_settings_update_rendering(self, body, layer_settings_id, tenant_url_code, **kwargs):  # noqa: E501
        """Updates the layer settings' rendering settings.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.layer_settings_update_rendering(body, layer_settings_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param LayerSettingsRendering body: (required)
        :param str layer_settings_id: (required)
        :param str tenant_url_code: (required)
        :return: LayerSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.layer_settings_update_rendering_with_http_info(body, layer_settings_id, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.layer_settings_update_rendering_with_http_info(body, layer_settings_id, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def layer_settings_update_rendering_with_http_info(self, body, layer_settings_id, tenant_url_code, **kwargs):  # noqa: E501
        """Updates the layer settings' rendering settings.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.layer_settings_update_rendering_with_http_info(body, layer_settings_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param LayerSettingsRendering body: (required)
        :param str layer_settings_id: (required)
        :param str tenant_url_code: (required)
        :return: LayerSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'layer_settings_id', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method layer_settings_update_rendering" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `layer_settings_update_rendering`")  # noqa: E501
        # verify the required parameter 'layer_settings_id' is set
        if ('layer_settings_id' not in params or
                params['layer_settings_id'] is None):
            raise ValueError("Missing the required parameter `layer_settings_id` when calling `layer_settings_update_rendering`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `layer_settings_update_rendering`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'layer_settings_id' in params:
            path_params['layerSettingsId'] = params['layer_settings_id']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/layerSettings/{layerSettingsId}/rendering', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='LayerSettings',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def layer_settings_update_visibility_ranges(self, body, layer_settings_id, tenant_url_code, **kwargs):  # noqa: E501
        """Updates the layer settings' visibility ranges.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.layer_settings_update_visibility_ranges(body, layer_settings_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param LayerSettingsVisibilityRanges body: (required)
        :param str layer_settings_id: (required)
        :param str tenant_url_code: (required)
        :return: LayerSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.layer_settings_update_visibility_ranges_with_http_info(body, layer_settings_id, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.layer_settings_update_visibility_ranges_with_http_info(body, layer_settings_id, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def layer_settings_update_visibility_ranges_with_http_info(self, body, layer_settings_id, tenant_url_code, **kwargs):  # noqa: E501
        """Updates the layer settings' visibility ranges.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.layer_settings_update_visibility_ranges_with_http_info(body, layer_settings_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param LayerSettingsVisibilityRanges body: (required)
        :param str layer_settings_id: (required)
        :param str tenant_url_code: (required)
        :return: LayerSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'layer_settings_id', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method layer_settings_update_visibility_ranges" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `layer_settings_update_visibility_ranges`")  # noqa: E501
        # verify the required parameter 'layer_settings_id' is set
        if ('layer_settings_id' not in params or
                params['layer_settings_id'] is None):
            raise ValueError("Missing the required parameter `layer_settings_id` when calling `layer_settings_update_visibility_ranges`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `layer_settings_update_visibility_ranges`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'layer_settings_id' in params:
            path_params['layerSettingsId'] = params['layer_settings_id']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/layerSettings/{layerSettingsId}/visibility-ranges', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='LayerSettings',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
