# coding: utf-8

"""
    CartoVista REST API

    No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)  # noqa: E501

    OpenAPI spec version: 2.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from add_to_cartovista.swagger_client.api_client import ApiClient


class LayerApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def layer_append_to_layer(self, layer_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Appends the content of a file at the end of the layer. The file format must match the layer.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.layer_append_to_layer(layer_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str layer_identifier: (required)
        :param str tenant_url_code: (required)
        :param str file:
        :return: Layer
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.layer_append_to_layer_with_http_info(layer_identifier, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.layer_append_to_layer_with_http_info(layer_identifier, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def layer_append_to_layer_with_http_info(self, layer_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Appends the content of a file at the end of the layer. The file format must match the layer.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.layer_append_to_layer_with_http_info(layer_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str layer_identifier: (required)
        :param str tenant_url_code: (required)
        :param str file:
        :return: Layer
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['layer_identifier', 'tenant_url_code', 'file']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method layer_append_to_layer" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'layer_identifier' is set
        if ('layer_identifier' not in params or
                params['layer_identifier'] is None):
            raise ValueError("Missing the required parameter `layer_identifier` when calling `layer_append_to_layer`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `layer_append_to_layer`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'layer_identifier' in params:
            path_params['layerIdentifier'] = params['layer_identifier']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'file' in params:
            local_var_files['file'] = params['file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/Layer/{layerIdentifier}/append', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Layer',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def layer_cancel_cluster_task(self, layer_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Cancels the cluster generation for that layer.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.layer_cancel_cluster_task(layer_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str layer_identifier: (required)
        :param str tenant_url_code: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.layer_cancel_cluster_task_with_http_info(layer_identifier, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.layer_cancel_cluster_task_with_http_info(layer_identifier, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def layer_cancel_cluster_task_with_http_info(self, layer_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Cancels the cluster generation for that layer.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.layer_cancel_cluster_task_with_http_info(layer_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str layer_identifier: (required)
        :param str tenant_url_code: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['layer_identifier', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method layer_cancel_cluster_task" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'layer_identifier' is set
        if ('layer_identifier' not in params or
                params['layer_identifier'] is None):
            raise ValueError("Missing the required parameter `layer_identifier` when calling `layer_cancel_cluster_task`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `layer_cancel_cluster_task`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'layer_identifier' in params:
            path_params['layerIdentifier'] = params['layer_identifier']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/Layer/{layerIdentifier}/cancelCluster', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def layer_create_layer(self, body, tenant_url_code, **kwargs):  # noqa: E501
        """Creates a new empty layer.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.layer_create_layer(body, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param LayerCreateParameter body: (required)
        :param str tenant_url_code: (required)
        :return: Layer
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.layer_create_layer_with_http_info(body, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.layer_create_layer_with_http_info(body, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def layer_create_layer_with_http_info(self, body, tenant_url_code, **kwargs):  # noqa: E501
        """Creates a new empty layer.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.layer_create_layer_with_http_info(body, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param LayerCreateParameter body: (required)
        :param str tenant_url_code: (required)
        :return: Layer
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method layer_create_layer" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `layer_create_layer`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `layer_create_layer`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/createLayer', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Layer',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def layer_create_layer_from_service(self, body, tenant_url_code, **kwargs):  # noqa: E501
        """Creates a layer from an external service (ArcGIS, GeoJSON).  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.layer_create_layer_from_service(body, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CreateLayerFromServiceParameter body: (required)
        :param str tenant_url_code: (required)
        :return: Layer
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.layer_create_layer_from_service_with_http_info(body, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.layer_create_layer_from_service_with_http_info(body, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def layer_create_layer_from_service_with_http_info(self, body, tenant_url_code, **kwargs):  # noqa: E501
        """Creates a layer from an external service (ArcGIS, GeoJSON).  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.layer_create_layer_from_service_with_http_info(body, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CreateLayerFromServiceParameter body: (required)
        :param str tenant_url_code: (required)
        :return: Layer
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method layer_create_layer_from_service" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `layer_create_layer_from_service`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `layer_create_layer_from_service`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/Layer/createFromService', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Layer',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def layer_create_layer_from_zip(self, tenant_url_code, **kwargs):  # noqa: E501
        """Creates a layer from a ZIP file.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.layer_create_layer_from_zip(tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str tenant_url_code: (required)
        :param str file:
        :return: Layer
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.layer_create_layer_from_zip_with_http_info(tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.layer_create_layer_from_zip_with_http_info(tenant_url_code, **kwargs)  # noqa: E501
            return data

    def layer_create_layer_from_zip_with_http_info(self, tenant_url_code, **kwargs):  # noqa: E501
        """Creates a layer from a ZIP file.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.layer_create_layer_from_zip_with_http_info(tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str tenant_url_code: (required)
        :param str file:
        :return: Layer
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['tenant_url_code', 'file']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method layer_create_layer_from_zip" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `layer_create_layer_from_zip`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'file' in params:
            local_var_files['file'] = params['file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/Layer/createFromZip', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Layer',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def layer_de_optimize_layer(self, layer_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Disables the ClickHouse optimization for this layer.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.layer_de_optimize_layer(layer_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str layer_identifier: (required)
        :param str tenant_url_code: (required)
        :return: Layer
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.layer_de_optimize_layer_with_http_info(layer_identifier, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.layer_de_optimize_layer_with_http_info(layer_identifier, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def layer_de_optimize_layer_with_http_info(self, layer_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Disables the ClickHouse optimization for this layer.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.layer_de_optimize_layer_with_http_info(layer_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str layer_identifier: (required)
        :param str tenant_url_code: (required)
        :return: Layer
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['layer_identifier', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method layer_de_optimize_layer" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'layer_identifier' is set
        if ('layer_identifier' not in params or
                params['layer_identifier'] is None):
            raise ValueError("Missing the required parameter `layer_identifier` when calling `layer_de_optimize_layer`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `layer_de_optimize_layer`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'layer_identifier' in params:
            path_params['layerIdentifier'] = params['layer_identifier']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/Layer/{layerIdentifier}/deoptimize', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Layer',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def layer_delete_clusters(self, layer_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Deletes the generated clusters for that layer.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.layer_delete_clusters(layer_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str layer_identifier: (required)
        :param str tenant_url_code: (required)
        :return: Layer
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.layer_delete_clusters_with_http_info(layer_identifier, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.layer_delete_clusters_with_http_info(layer_identifier, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def layer_delete_clusters_with_http_info(self, layer_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Deletes the generated clusters for that layer.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.layer_delete_clusters_with_http_info(layer_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str layer_identifier: (required)
        :param str tenant_url_code: (required)
        :return: Layer
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['layer_identifier', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method layer_delete_clusters" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'layer_identifier' is set
        if ('layer_identifier' not in params or
                params['layer_identifier'] is None):
            raise ValueError("Missing the required parameter `layer_identifier` when calling `layer_delete_clusters`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `layer_delete_clusters`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'layer_identifier' in params:
            path_params['layerIdentifier'] = params['layer_identifier']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/Layer/{layerIdentifier}/cluster', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Layer',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def layer_delete_layer_by_id(self, layer_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Deletes the layer.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.layer_delete_layer_by_id(layer_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str layer_identifier: (required)
        :param str tenant_url_code: (required)
        :return: DeleteLayerResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.layer_delete_layer_by_id_with_http_info(layer_identifier, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.layer_delete_layer_by_id_with_http_info(layer_identifier, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def layer_delete_layer_by_id_with_http_info(self, layer_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Deletes the layer.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.layer_delete_layer_by_id_with_http_info(layer_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str layer_identifier: (required)
        :param str tenant_url_code: (required)
        :return: DeleteLayerResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['layer_identifier', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method layer_delete_layer_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'layer_identifier' is set
        if ('layer_identifier' not in params or
                params['layer_identifier'] is None):
            raise ValueError("Missing the required parameter `layer_identifier` when calling `layer_delete_layer_by_id`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `layer_delete_layer_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'layer_identifier' in params:
            path_params['layerIdentifier'] = params['layer_identifier']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/Layer/{layerIdentifier}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DeleteLayerResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def layer_duplicate_layer(self, body, layer_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Duplicates the layer and its data.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.layer_duplicate_layer(body, layer_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DuplicateLayerParameter body: (required)
        :param str layer_identifier: (required)
        :param str tenant_url_code: (required)
        :return: Layer
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.layer_duplicate_layer_with_http_info(body, layer_identifier, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.layer_duplicate_layer_with_http_info(body, layer_identifier, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def layer_duplicate_layer_with_http_info(self, body, layer_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Duplicates the layer and its data.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.layer_duplicate_layer_with_http_info(body, layer_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DuplicateLayerParameter body: (required)
        :param str layer_identifier: (required)
        :param str tenant_url_code: (required)
        :return: Layer
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'layer_identifier', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method layer_duplicate_layer" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `layer_duplicate_layer`")  # noqa: E501
        # verify the required parameter 'layer_identifier' is set
        if ('layer_identifier' not in params or
                params['layer_identifier'] is None):
            raise ValueError("Missing the required parameter `layer_identifier` when calling `layer_duplicate_layer`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `layer_duplicate_layer`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'layer_identifier' in params:
            path_params['layerIdentifier'] = params['layer_identifier']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/Layer/{layerIdentifier}/duplicate', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Layer',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def layer_generate_clusters(self, layer_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Generates clusters for the layer. The layer must be a point layer.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.layer_generate_clusters(layer_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str layer_identifier: (required)
        :param str tenant_url_code: (required)
        :return: Layer
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.layer_generate_clusters_with_http_info(layer_identifier, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.layer_generate_clusters_with_http_info(layer_identifier, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def layer_generate_clusters_with_http_info(self, layer_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Generates clusters for the layer. The layer must be a point layer.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.layer_generate_clusters_with_http_info(layer_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str layer_identifier: (required)
        :param str tenant_url_code: (required)
        :return: Layer
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['layer_identifier', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method layer_generate_clusters" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'layer_identifier' is set
        if ('layer_identifier' not in params or
                params['layer_identifier'] is None):
            raise ValueError("Missing the required parameter `layer_identifier` when calling `layer_generate_clusters`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `layer_generate_clusters`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'layer_identifier' in params:
            path_params['layerIdentifier'] = params['layer_identifier']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/Layer/{layerIdentifier}/cluster', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Layer',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def layer_generate_layer_icon(self, layer_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Regenerates the layer's icon.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.layer_generate_layer_icon(layer_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str layer_identifier: (required)
        :param str tenant_url_code: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.layer_generate_layer_icon_with_http_info(layer_identifier, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.layer_generate_layer_icon_with_http_info(layer_identifier, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def layer_generate_layer_icon_with_http_info(self, layer_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Regenerates the layer's icon.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.layer_generate_layer_icon_with_http_info(layer_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str layer_identifier: (required)
        :param str tenant_url_code: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['layer_identifier', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method layer_generate_layer_icon" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'layer_identifier' is set
        if ('layer_identifier' not in params or
                params['layer_identifier'] is None):
            raise ValueError("Missing the required parameter `layer_identifier` when calling `layer_generate_layer_icon`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `layer_generate_layer_icon`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'layer_identifier' in params:
            path_params['layerIdentifier'] = params['layer_identifier']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/Layer/{layerIdentifier}/icon', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def layer_generate_layer_thumbnail(self, layer_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Regenerates the layer's thumbnail.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.layer_generate_layer_thumbnail(layer_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str layer_identifier: (required)
        :param str tenant_url_code: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.layer_generate_layer_thumbnail_with_http_info(layer_identifier, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.layer_generate_layer_thumbnail_with_http_info(layer_identifier, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def layer_generate_layer_thumbnail_with_http_info(self, layer_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Regenerates the layer's thumbnail.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.layer_generate_layer_thumbnail_with_http_info(layer_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str layer_identifier: (required)
        :param str tenant_url_code: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['layer_identifier', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method layer_generate_layer_thumbnail" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'layer_identifier' is set
        if ('layer_identifier' not in params or
                params['layer_identifier'] is None):
            raise ValueError("Missing the required parameter `layer_identifier` when calling `layer_generate_layer_thumbnail`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `layer_generate_layer_thumbnail`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'layer_identifier' in params:
            path_params['layerIdentifier'] = params['layer_identifier']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/Layer/{layerIdentifier}/thumbnail', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def layer_get_data_table_by_layer_identifier(self, layer_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Get DataTable of layer by layer identifier.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.layer_get_data_table_by_layer_identifier(layer_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str layer_identifier: (required)
        :param str tenant_url_code: (required)
        :return: DataTable
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.layer_get_data_table_by_layer_identifier_with_http_info(layer_identifier, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.layer_get_data_table_by_layer_identifier_with_http_info(layer_identifier, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def layer_get_data_table_by_layer_identifier_with_http_info(self, layer_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Get DataTable of layer by layer identifier.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.layer_get_data_table_by_layer_identifier_with_http_info(layer_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str layer_identifier: (required)
        :param str tenant_url_code: (required)
        :return: DataTable
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['layer_identifier', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method layer_get_data_table_by_layer_identifier" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'layer_identifier' is set
        if ('layer_identifier' not in params or
                params['layer_identifier'] is None):
            raise ValueError("Missing the required parameter `layer_identifier` when calling `layer_get_data_table_by_layer_identifier`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `layer_get_data_table_by_layer_identifier`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'layer_identifier' in params:
            path_params['layerIdentifier'] = params['layer_identifier']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/Layer/{layerIdentifier}/dataTable', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DataTable',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def layer_get_data_tables_by_layer_identifier(self, layer_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Get DataTables linked to layer by layer identifier.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.layer_get_data_tables_by_layer_identifier(layer_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str layer_identifier: (required)
        :param str tenant_url_code: (required)
        :return: list[LayerDataTable]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.layer_get_data_tables_by_layer_identifier_with_http_info(layer_identifier, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.layer_get_data_tables_by_layer_identifier_with_http_info(layer_identifier, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def layer_get_data_tables_by_layer_identifier_with_http_info(self, layer_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Get DataTables linked to layer by layer identifier.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.layer_get_data_tables_by_layer_identifier_with_http_info(layer_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str layer_identifier: (required)
        :param str tenant_url_code: (required)
        :return: list[LayerDataTable]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['layer_identifier', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method layer_get_data_tables_by_layer_identifier" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'layer_identifier' is set
        if ('layer_identifier' not in params or
                params['layer_identifier'] is None):
            raise ValueError("Missing the required parameter `layer_identifier` when calling `layer_get_data_tables_by_layer_identifier`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `layer_get_data_tables_by_layer_identifier`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'layer_identifier' in params:
            path_params['layerIdentifier'] = params['layer_identifier']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/Layer/{layerIdentifier}/dataTables', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[LayerDataTable]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def layer_get_data_tables_by_layer_identifiers(self, body, tenant_url_code, **kwargs):  # noqa: E501
        """Gets the list of DataTables which are linked to any of the layers whose identifiers passed in argument.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.layer_get_data_tables_by_layer_identifiers(body, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[str] body: (required)
        :param str tenant_url_code: (required)
        :return: list[LayerDataTable]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.layer_get_data_tables_by_layer_identifiers_with_http_info(body, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.layer_get_data_tables_by_layer_identifiers_with_http_info(body, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def layer_get_data_tables_by_layer_identifiers_with_http_info(self, body, tenant_url_code, **kwargs):  # noqa: E501
        """Gets the list of DataTables which are linked to any of the layers whose identifiers passed in argument.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.layer_get_data_tables_by_layer_identifiers_with_http_info(body, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[str] body: (required)
        :param str tenant_url_code: (required)
        :return: list[LayerDataTable]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method layer_get_data_tables_by_layer_identifiers" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `layer_get_data_tables_by_layer_identifiers`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `layer_get_data_tables_by_layer_identifiers`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/Layer/allDataTablesByLayers', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[LayerDataTable]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def layer_get_feature_ids_for_selection_stacks(self, body, layer_id, tenant_url_code, **kwargs):  # noqa: E501
        """layer_get_feature_ids_for_selection_stacks  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.layer_get_feature_ids_for_selection_stacks(body, layer_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param GetFeatureIdsByStackParameters body: (required)
        :param str layer_id: (required)
        :param str tenant_url_code: (required)
        :return: list[list[str]]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.layer_get_feature_ids_for_selection_stacks_with_http_info(body, layer_id, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.layer_get_feature_ids_for_selection_stacks_with_http_info(body, layer_id, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def layer_get_feature_ids_for_selection_stacks_with_http_info(self, body, layer_id, tenant_url_code, **kwargs):  # noqa: E501
        """layer_get_feature_ids_for_selection_stacks  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.layer_get_feature_ids_for_selection_stacks_with_http_info(body, layer_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param GetFeatureIdsByStackParameters body: (required)
        :param str layer_id: (required)
        :param str tenant_url_code: (required)
        :return: list[list[str]]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'layer_id', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method layer_get_feature_ids_for_selection_stacks" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `layer_get_feature_ids_for_selection_stacks`")  # noqa: E501
        # verify the required parameter 'layer_id' is set
        if ('layer_id' not in params or
                params['layer_id'] is None):
            raise ValueError("Missing the required parameter `layer_id` when calling `layer_get_feature_ids_for_selection_stacks`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `layer_get_feature_ids_for_selection_stacks`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'layer_id' in params:
            path_params['layerId'] = params['layer_id']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/Layer/{layerId}/selection-by-stack', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[list[str]]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def layer_get_file_description(self, layer_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Stores a temporary file for an upcoming data insert or update and returns a description of the file's content.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.layer_get_file_description(layer_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str layer_identifier: (required)
        :param str tenant_url_code: (required)
        :param str file:
        :return: FileDescription
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.layer_get_file_description_with_http_info(layer_identifier, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.layer_get_file_description_with_http_info(layer_identifier, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def layer_get_file_description_with_http_info(self, layer_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Stores a temporary file for an upcoming data insert or update and returns a description of the file's content.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.layer_get_file_description_with_http_info(layer_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str layer_identifier: (required)
        :param str tenant_url_code: (required)
        :param str file:
        :return: FileDescription
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['layer_identifier', 'tenant_url_code', 'file']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method layer_get_file_description" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'layer_identifier' is set
        if ('layer_identifier' not in params or
                params['layer_identifier'] is None):
            raise ValueError("Missing the required parameter `layer_identifier` when calling `layer_get_file_description`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `layer_get_file_description`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'layer_identifier' in params:
            path_params['layerIdentifier'] = params['layer_identifier']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'file' in params:
            local_var_files['file'] = params['file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/Layer/{layerIdentifier}/getFileDescription', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='FileDescription',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def layer_get_layer_by_id(self, layer_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Retrives a specific layer.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.layer_get_layer_by_id(layer_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str layer_identifier: (required)
        :param str tenant_url_code: (required)
        :return: Layer
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.layer_get_layer_by_id_with_http_info(layer_identifier, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.layer_get_layer_by_id_with_http_info(layer_identifier, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def layer_get_layer_by_id_with_http_info(self, layer_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Retrives a specific layer.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.layer_get_layer_by_id_with_http_info(layer_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str layer_identifier: (required)
        :param str tenant_url_code: (required)
        :return: Layer
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['layer_identifier', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method layer_get_layer_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'layer_identifier' is set
        if ('layer_identifier' not in params or
                params['layer_identifier'] is None):
            raise ValueError("Missing the required parameter `layer_identifier` when calling `layer_get_layer_by_id`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `layer_get_layer_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'layer_identifier' in params:
            path_params['layerIdentifier'] = params['layer_identifier']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/Layer/{layerIdentifier}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Layer',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def layer_get_layer_details(self, layer_id, tenant_url_code, **kwargs):  # noqa: E501
        """Gets the layer, its related maps, tables, columns and settings.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.layer_get_layer_details(layer_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str layer_id: (required)
        :param str tenant_url_code: (required)
        :return: LayerWithDetails
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.layer_get_layer_details_with_http_info(layer_id, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.layer_get_layer_details_with_http_info(layer_id, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def layer_get_layer_details_with_http_info(self, layer_id, tenant_url_code, **kwargs):  # noqa: E501
        """Gets the layer, its related maps, tables, columns and settings.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.layer_get_layer_details_with_http_info(layer_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str layer_id: (required)
        :param str tenant_url_code: (required)
        :return: LayerWithDetails
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['layer_id', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method layer_get_layer_details" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'layer_id' is set
        if ('layer_id' not in params or
                params['layer_id'] is None):
            raise ValueError("Missing the required parameter `layer_id` when calling `layer_get_layer_details`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `layer_get_layer_details`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'layer_id' in params:
            path_params['layerId'] = params['layer_id']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/Layer/{layerId}/details', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='LayerWithDetails',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def layer_get_layers(self, tenant_url_code, **kwargs):  # noqa: E501
        """Gets all the layers.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.layer_get_layers(tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str tenant_url_code: (required)
        :return: list[Layer]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.layer_get_layers_with_http_info(tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.layer_get_layers_with_http_info(tenant_url_code, **kwargs)  # noqa: E501
            return data

    def layer_get_layers_with_http_info(self, tenant_url_code, **kwargs):  # noqa: E501
        """Gets all the layers.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.layer_get_layers_with_http_info(tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str tenant_url_code: (required)
        :return: list[Layer]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method layer_get_layers" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `layer_get_layers`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/Layers', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Layer]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def layer_get_layers_extents(self, body, tenant_url_code, **kwargs):  # noqa: E501
        """Gets the layers' extents.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.layer_get_layers_extents(body, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[str] body: (required)
        :param str tenant_url_code: (required)
        :return: list[ExtentDTO]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.layer_get_layers_extents_with_http_info(body, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.layer_get_layers_extents_with_http_info(body, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def layer_get_layers_extents_with_http_info(self, body, tenant_url_code, **kwargs):  # noqa: E501
        """Gets the layers' extents.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.layer_get_layers_extents_with_http_info(body, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[str] body: (required)
        :param str tenant_url_code: (required)
        :return: list[ExtentDTO]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method layer_get_layers_extents" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `layer_get_layers_extents`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `layer_get_layers_extents`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/Layer/extents', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[ExtentDTO]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def layer_get_many_spatial_statistics_by_feature(self, body, layer_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Computes the area and/or length of a layer's features using any number of filters and spatial filters.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.layer_get_many_spatial_statistics_by_feature(body, layer_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param GetManySpatialStatisticsByFeatureParameter body: The json object that holds the information for spatial statistics reporting. (required)
        :param str layer_identifier: The layer identifier. (required)
        :param str tenant_url_code: (required)
        :return: list[LayerSpatialStatistics]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.layer_get_many_spatial_statistics_by_feature_with_http_info(body, layer_identifier, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.layer_get_many_spatial_statistics_by_feature_with_http_info(body, layer_identifier, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def layer_get_many_spatial_statistics_by_feature_with_http_info(self, body, layer_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Computes the area and/or length of a layer's features using any number of filters and spatial filters.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.layer_get_many_spatial_statistics_by_feature_with_http_info(body, layer_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param GetManySpatialStatisticsByFeatureParameter body: The json object that holds the information for spatial statistics reporting. (required)
        :param str layer_identifier: The layer identifier. (required)
        :param str tenant_url_code: (required)
        :return: list[LayerSpatialStatistics]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'layer_identifier', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method layer_get_many_spatial_statistics_by_feature" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `layer_get_many_spatial_statistics_by_feature`")  # noqa: E501
        # verify the required parameter 'layer_identifier' is set
        if ('layer_identifier' not in params or
                params['layer_identifier'] is None):
            raise ValueError("Missing the required parameter `layer_identifier` when calling `layer_get_many_spatial_statistics_by_feature`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `layer_get_many_spatial_statistics_by_feature`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'layer_identifier' in params:
            path_params['layerIdentifier'] = params['layer_identifier']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/Layer/{layerIdentifier}/manySpatialStatisticsByFeature', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[LayerSpatialStatistics]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def layer_get_many_spatial_statistics_by_wkt(self, body, layer_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Computes the area and/or length of a layer's features using any number of filters and spatial filters.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.layer_get_many_spatial_statistics_by_wkt(body, layer_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param GetManySpatialStatisticsByWKTParameter body: The json object that holds the information for spatial statistics reporting. (required)
        :param str layer_identifier: The layer identifier. (required)
        :param str tenant_url_code: (required)
        :return: list[LayerSpatialStatistics]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.layer_get_many_spatial_statistics_by_wkt_with_http_info(body, layer_identifier, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.layer_get_many_spatial_statistics_by_wkt_with_http_info(body, layer_identifier, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def layer_get_many_spatial_statistics_by_wkt_with_http_info(self, body, layer_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Computes the area and/or length of a layer's features using any number of filters and spatial filters.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.layer_get_many_spatial_statistics_by_wkt_with_http_info(body, layer_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param GetManySpatialStatisticsByWKTParameter body: The json object that holds the information for spatial statistics reporting. (required)
        :param str layer_identifier: The layer identifier. (required)
        :param str tenant_url_code: (required)
        :return: list[LayerSpatialStatistics]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'layer_identifier', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method layer_get_many_spatial_statistics_by_wkt" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `layer_get_many_spatial_statistics_by_wkt`")  # noqa: E501
        # verify the required parameter 'layer_identifier' is set
        if ('layer_identifier' not in params or
                params['layer_identifier'] is None):
            raise ValueError("Missing the required parameter `layer_identifier` when calling `layer_get_many_spatial_statistics_by_wkt`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `layer_get_many_spatial_statistics_by_wkt`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'layer_identifier' in params:
            path_params['layerIdentifier'] = params['layer_identifier']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/Layer/{layerIdentifier}/manySpatialStatisticsByWKT', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[LayerSpatialStatistics]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def layer_get_maps_by_layer_identifier(self, layer_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Get Maps by layer friendly or system identifier.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.layer_get_maps_by_layer_identifier(layer_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str layer_identifier: (required)
        :param str tenant_url_code: (required)
        :return: list[Map]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.layer_get_maps_by_layer_identifier_with_http_info(layer_identifier, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.layer_get_maps_by_layer_identifier_with_http_info(layer_identifier, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def layer_get_maps_by_layer_identifier_with_http_info(self, layer_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Get Maps by layer friendly or system identifier.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.layer_get_maps_by_layer_identifier_with_http_info(layer_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str layer_identifier: (required)
        :param str tenant_url_code: (required)
        :return: list[Map]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['layer_identifier', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method layer_get_maps_by_layer_identifier" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'layer_identifier' is set
        if ('layer_identifier' not in params or
                params['layer_identifier'] is None):
            raise ValueError("Missing the required parameter `layer_identifier` when calling `layer_get_maps_by_layer_identifier`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `layer_get_maps_by_layer_identifier`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'layer_identifier' in params:
            path_params['layerIdentifier'] = params['layer_identifier']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/Layer/{layerIdentifier}/maps', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Map]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def layer_get_spatial_statistics_by_feature(self, body, layer_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Computes the area and/or length of a layer's features. The features can be filtered by value and/or by geometry.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.layer_get_spatial_statistics_by_feature(body, layer_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param GetSpatialStatisticsByFeatureParameter body: The json object that holds the information for spatial statistics reporting. (required)
        :param str layer_identifier: The layer identifier. (required)
        :param str tenant_url_code: (required)
        :return: LayerSpatialStatistics
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.layer_get_spatial_statistics_by_feature_with_http_info(body, layer_identifier, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.layer_get_spatial_statistics_by_feature_with_http_info(body, layer_identifier, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def layer_get_spatial_statistics_by_feature_with_http_info(self, body, layer_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Computes the area and/or length of a layer's features. The features can be filtered by value and/or by geometry.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.layer_get_spatial_statistics_by_feature_with_http_info(body, layer_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param GetSpatialStatisticsByFeatureParameter body: The json object that holds the information for spatial statistics reporting. (required)
        :param str layer_identifier: The layer identifier. (required)
        :param str tenant_url_code: (required)
        :return: LayerSpatialStatistics
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'layer_identifier', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method layer_get_spatial_statistics_by_feature" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `layer_get_spatial_statistics_by_feature`")  # noqa: E501
        # verify the required parameter 'layer_identifier' is set
        if ('layer_identifier' not in params or
                params['layer_identifier'] is None):
            raise ValueError("Missing the required parameter `layer_identifier` when calling `layer_get_spatial_statistics_by_feature`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `layer_get_spatial_statistics_by_feature`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'layer_identifier' in params:
            path_params['layerIdentifier'] = params['layer_identifier']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/Layer/{layerIdentifier}/spatialStatisticsByFeature', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='LayerSpatialStatistics',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def layer_get_spatial_statistics_by_wkt(self, body, layer_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Computes the area and/or length of a layer's features. The features can be filtered by value and/or by geometry.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.layer_get_spatial_statistics_by_wkt(body, layer_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param GetSpatialStatisticsByWKTParameter body: The json object that holds the information for spatial statistics reporting. (required)
        :param str layer_identifier: The layer identifier. (required)
        :param str tenant_url_code: (required)
        :return: LayerSpatialStatistics
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.layer_get_spatial_statistics_by_wkt_with_http_info(body, layer_identifier, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.layer_get_spatial_statistics_by_wkt_with_http_info(body, layer_identifier, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def layer_get_spatial_statistics_by_wkt_with_http_info(self, body, layer_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Computes the area and/or length of a layer's features. The features can be filtered by value and/or by geometry.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.layer_get_spatial_statistics_by_wkt_with_http_info(body, layer_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param GetSpatialStatisticsByWKTParameter body: The json object that holds the information for spatial statistics reporting. (required)
        :param str layer_identifier: The layer identifier. (required)
        :param str tenant_url_code: (required)
        :return: LayerSpatialStatistics
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'layer_identifier', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method layer_get_spatial_statistics_by_wkt" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `layer_get_spatial_statistics_by_wkt`")  # noqa: E501
        # verify the required parameter 'layer_identifier' is set
        if ('layer_identifier' not in params or
                params['layer_identifier'] is None):
            raise ValueError("Missing the required parameter `layer_identifier` when calling `layer_get_spatial_statistics_by_wkt`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `layer_get_spatial_statistics_by_wkt`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'layer_identifier' in params:
            path_params['layerIdentifier'] = params['layer_identifier']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/Layer/{layerIdentifier}/spatialStatisticsByWKT', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='LayerSpatialStatistics',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def layer_get_transformation_settings(self, layer_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Gets the ids of the columns used to georeference the layer. Will return null if the layer was not created from georeferencing a data table.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.layer_get_transformation_settings(layer_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str layer_identifier: (required)
        :param str tenant_url_code: (required)
        :return: InlineResponse200
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.layer_get_transformation_settings_with_http_info(layer_identifier, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.layer_get_transformation_settings_with_http_info(layer_identifier, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def layer_get_transformation_settings_with_http_info(self, layer_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Gets the ids of the columns used to georeference the layer. Will return null if the layer was not created from georeferencing a data table.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.layer_get_transformation_settings_with_http_info(layer_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str layer_identifier: (required)
        :param str tenant_url_code: (required)
        :return: InlineResponse200
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['layer_identifier', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method layer_get_transformation_settings" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'layer_identifier' is set
        if ('layer_identifier' not in params or
                params['layer_identifier'] is None):
            raise ValueError("Missing the required parameter `layer_identifier` when calling `layer_get_transformation_settings`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `layer_get_transformation_settings`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'layer_identifier' in params:
            path_params['layerIdentifier'] = params['layer_identifier']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/Layer/{layerIdentifier}/transformationSettings', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse200',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def layer_optimize_layer(self, layer_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Optimizes the table queries with ClickHouse. The layer must be tiled.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.layer_optimize_layer(layer_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str layer_identifier: (required)
        :param str tenant_url_code: (required)
        :return: Layer
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.layer_optimize_layer_with_http_info(layer_identifier, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.layer_optimize_layer_with_http_info(layer_identifier, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def layer_optimize_layer_with_http_info(self, layer_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Optimizes the table queries with ClickHouse. The layer must be tiled.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.layer_optimize_layer_with_http_info(layer_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str layer_identifier: (required)
        :param str tenant_url_code: (required)
        :return: Layer
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['layer_identifier', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method layer_optimize_layer" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'layer_identifier' is set
        if ('layer_identifier' not in params or
                params['layer_identifier'] is None):
            raise ValueError("Missing the required parameter `layer_identifier` when calling `layer_optimize_layer`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `layer_optimize_layer`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'layer_identifier' in params:
            path_params['layerIdentifier'] = params['layer_identifier']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/Layer/{layerIdentifier}/optimize', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Layer',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def layer_regenerate_tile_cache(self, layer_id, tenant_url_code, **kwargs):  # noqa: E501
        """Regenerates the tile cache for the layer.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.layer_regenerate_tile_cache(layer_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str layer_id: (required)
        :param str tenant_url_code: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.layer_regenerate_tile_cache_with_http_info(layer_id, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.layer_regenerate_tile_cache_with_http_info(layer_id, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def layer_regenerate_tile_cache_with_http_info(self, layer_id, tenant_url_code, **kwargs):  # noqa: E501
        """Regenerates the tile cache for the layer.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.layer_regenerate_tile_cache_with_http_info(layer_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str layer_id: (required)
        :param str tenant_url_code: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['layer_id', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method layer_regenerate_tile_cache" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'layer_id' is set
        if ('layer_id' not in params or
                params['layer_id'] is None):
            raise ValueError("Missing the required parameter `layer_id` when calling `layer_regenerate_tile_cache`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `layer_regenerate_tile_cache`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'layer_id' in params:
            path_params['layerId'] = params['layer_id']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/Layer/{layerId}/regenerateTileCache', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def layer_set_data_column_unique_id(self, layer_identifier, data_column_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Sets the layer's unique identifier column. The column becomes the primary way to identify its rows.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.layer_set_data_column_unique_id(layer_identifier, data_column_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str layer_identifier: (required)
        :param str data_column_identifier: (required)
        :param str tenant_url_code: (required)
        :return: Layer
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.layer_set_data_column_unique_id_with_http_info(layer_identifier, data_column_identifier, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.layer_set_data_column_unique_id_with_http_info(layer_identifier, data_column_identifier, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def layer_set_data_column_unique_id_with_http_info(self, layer_identifier, data_column_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Sets the layer's unique identifier column. The column becomes the primary way to identify its rows.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.layer_set_data_column_unique_id_with_http_info(layer_identifier, data_column_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str layer_identifier: (required)
        :param str data_column_identifier: (required)
        :param str tenant_url_code: (required)
        :return: Layer
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['layer_identifier', 'data_column_identifier', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method layer_set_data_column_unique_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'layer_identifier' is set
        if ('layer_identifier' not in params or
                params['layer_identifier'] is None):
            raise ValueError("Missing the required parameter `layer_identifier` when calling `layer_set_data_column_unique_id`")  # noqa: E501
        # verify the required parameter 'data_column_identifier' is set
        if ('data_column_identifier' not in params or
                params['data_column_identifier'] is None):
            raise ValueError("Missing the required parameter `data_column_identifier` when calling `layer_set_data_column_unique_id`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `layer_set_data_column_unique_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'layer_identifier' in params:
            path_params['layerIdentifier'] = params['layer_identifier']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []
        if 'data_column_identifier' in params:
            query_params.append(('dataColumnIdentifier', params['data_column_identifier']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/Layer/{layerIdentifier}/setDataColumnUniqueId', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Layer',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def layer_set_unique_identifier(self, layer_identifier, new_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Sets the layer's unique identifier.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.layer_set_unique_identifier(layer_identifier, new_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str layer_identifier: (required)
        :param str new_identifier: (required)
        :param str tenant_url_code: (required)
        :return: Layer
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.layer_set_unique_identifier_with_http_info(layer_identifier, new_identifier, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.layer_set_unique_identifier_with_http_info(layer_identifier, new_identifier, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def layer_set_unique_identifier_with_http_info(self, layer_identifier, new_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Sets the layer's unique identifier.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.layer_set_unique_identifier_with_http_info(layer_identifier, new_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str layer_identifier: (required)
        :param str new_identifier: (required)
        :param str tenant_url_code: (required)
        :return: Layer
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['layer_identifier', 'new_identifier', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method layer_set_unique_identifier" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'layer_identifier' is set
        if ('layer_identifier' not in params or
                params['layer_identifier'] is None):
            raise ValueError("Missing the required parameter `layer_identifier` when calling `layer_set_unique_identifier`")  # noqa: E501
        # verify the required parameter 'new_identifier' is set
        if ('new_identifier' not in params or
                params['new_identifier'] is None):
            raise ValueError("Missing the required parameter `new_identifier` when calling `layer_set_unique_identifier`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `layer_set_unique_identifier`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'layer_identifier' in params:
            path_params['layerIdentifier'] = params['layer_identifier']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []
        if 'new_identifier' in params:
            query_params.append(('newIdentifier', params['new_identifier']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/Layer/{layerIdentifier}/setUniqueIdentifier', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Layer',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def layer_synchronize_layer(self, layer_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Synchronizes the layer with its external service. The layer must be linked to an external data provider.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.layer_synchronize_layer(layer_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str layer_identifier: (required)
        :param str tenant_url_code: (required)
        :return: Layer
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.layer_synchronize_layer_with_http_info(layer_identifier, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.layer_synchronize_layer_with_http_info(layer_identifier, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def layer_synchronize_layer_with_http_info(self, layer_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Synchronizes the layer with its external service. The layer must be linked to an external data provider.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.layer_synchronize_layer_with_http_info(layer_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str layer_identifier: (required)
        :param str tenant_url_code: (required)
        :return: Layer
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['layer_identifier', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method layer_synchronize_layer" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'layer_identifier' is set
        if ('layer_identifier' not in params or
                params['layer_identifier'] is None):
            raise ValueError("Missing the required parameter `layer_identifier` when calling `layer_synchronize_layer`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `layer_synchronize_layer`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'layer_identifier' in params:
            path_params['layerIdentifier'] = params['layer_identifier']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/Layer/{layerIdentifier}/synchronize', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Layer',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def layer_update_from_zip(self, layer_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Updates a layer from a ZIP. The ZIP content's format must match the layer.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.layer_update_from_zip(layer_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str layer_identifier: (required)
        :param str tenant_url_code: (required)
        :param str file:
        :return: Layer
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.layer_update_from_zip_with_http_info(layer_identifier, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.layer_update_from_zip_with_http_info(layer_identifier, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def layer_update_from_zip_with_http_info(self, layer_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Updates a layer from a ZIP. The ZIP content's format must match the layer.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.layer_update_from_zip_with_http_info(layer_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str layer_identifier: (required)
        :param str tenant_url_code: (required)
        :param str file:
        :return: Layer
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['layer_identifier', 'tenant_url_code', 'file']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method layer_update_from_zip" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'layer_identifier' is set
        if ('layer_identifier' not in params or
                params['layer_identifier'] is None):
            raise ValueError("Missing the required parameter `layer_identifier` when calling `layer_update_from_zip`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `layer_update_from_zip`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'layer_identifier' in params:
            path_params['layerIdentifier'] = params['layer_identifier']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'file' in params:
            local_var_files['file'] = params['file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/Layer/{layerIdentifier}/updateFromZip', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Layer',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def layer_update_layer(self, body, layer_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Updates the layer's properties.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.layer_update_layer(body, layer_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param LayerUpdateParameter body: (required)
        :param str layer_identifier: (required)
        :param str tenant_url_code: (required)
        :return: Layer
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.layer_update_layer_with_http_info(body, layer_identifier, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.layer_update_layer_with_http_info(body, layer_identifier, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def layer_update_layer_with_http_info(self, body, layer_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Updates the layer's properties.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.layer_update_layer_with_http_info(body, layer_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param LayerUpdateParameter body: (required)
        :param str layer_identifier: (required)
        :param str tenant_url_code: (required)
        :return: Layer
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'layer_identifier', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method layer_update_layer" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `layer_update_layer`")  # noqa: E501
        # verify the required parameter 'layer_identifier' is set
        if ('layer_identifier' not in params or
                params['layer_identifier'] is None):
            raise ValueError("Missing the required parameter `layer_identifier` when calling `layer_update_layer`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `layer_update_layer`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'layer_identifier' in params:
            path_params['layerIdentifier'] = params['layer_identifier']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/Layer/{layerIdentifier}/update', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Layer',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def layer_update_layer_external_service_url(self, body, layer_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Update a layer's external data provider url. The url isn't validated. Use synchronize API to import data to CartoVista server after changing the URL.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.layer_update_layer_external_service_url(body, layer_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UpdateServiceUrl body: (required)
        :param str layer_identifier: (required)
        :param str tenant_url_code: (required)
        :return: Layer
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.layer_update_layer_external_service_url_with_http_info(body, layer_identifier, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.layer_update_layer_external_service_url_with_http_info(body, layer_identifier, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def layer_update_layer_external_service_url_with_http_info(self, body, layer_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Update a layer's external data provider url. The url isn't validated. Use synchronize API to import data to CartoVista server after changing the URL.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.layer_update_layer_external_service_url_with_http_info(body, layer_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UpdateServiceUrl body: (required)
        :param str layer_identifier: (required)
        :param str tenant_url_code: (required)
        :return: Layer
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'layer_identifier', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method layer_update_layer_external_service_url" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `layer_update_layer_external_service_url`")  # noqa: E501
        # verify the required parameter 'layer_identifier' is set
        if ('layer_identifier' not in params or
                params['layer_identifier'] is None):
            raise ValueError("Missing the required parameter `layer_identifier` when calling `layer_update_layer_external_service_url`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `layer_update_layer_external_service_url`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'layer_identifier' in params:
            path_params['layerIdentifier'] = params['layer_identifier']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/Layer/{layerIdentifier}/update-layer-external-service-url', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Layer',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def layer_update_layer_from_file_description(self, body, layer_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Updates a layer with a file uploaded using `Layer/{layerIdentifier}/getFileDescription`.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.layer_update_layer_from_file_description(body, layer_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UpdateLayerFromFileParameter body: (required)
        :param str layer_identifier: (required)
        :param str tenant_url_code: (required)
        :return: Layer
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.layer_update_layer_from_file_description_with_http_info(body, layer_identifier, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.layer_update_layer_from_file_description_with_http_info(body, layer_identifier, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def layer_update_layer_from_file_description_with_http_info(self, body, layer_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Updates a layer with a file uploaded using `Layer/{layerIdentifier}/getFileDescription`.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.layer_update_layer_from_file_description_with_http_info(body, layer_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UpdateLayerFromFileParameter body: (required)
        :param str layer_identifier: (required)
        :param str tenant_url_code: (required)
        :return: Layer
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'layer_identifier', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method layer_update_layer_from_file_description" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `layer_update_layer_from_file_description`")  # noqa: E501
        # verify the required parameter 'layer_identifier' is set
        if ('layer_identifier' not in params or
                params['layer_identifier'] is None):
            raise ValueError("Missing the required parameter `layer_identifier` when calling `layer_update_layer_from_file_description`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `layer_update_layer_from_file_description`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'layer_identifier' in params:
            path_params['layerIdentifier'] = params['layer_identifier']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/Layer/{layerIdentifier}/updateFromFileDescription', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Layer',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
