# coding: utf-8

"""
    CartoVista REST API

    No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)  # noqa: E501

    OpenAPI spec version: 2.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from add_to_cartovista.swagger_client.api_client import ApiClient


class DataTableApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def data_table_append_data_to_data_table(self, data_table_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Appends the content of a file at the end of the table. The file format must match the table.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.data_table_append_data_to_data_table(data_table_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str data_table_identifier: (required)
        :param str tenant_url_code: (required)
        :param str file:
        :return: DataTable
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.data_table_append_data_to_data_table_with_http_info(data_table_identifier, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.data_table_append_data_to_data_table_with_http_info(data_table_identifier, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def data_table_append_data_to_data_table_with_http_info(self, data_table_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Appends the content of a file at the end of the table. The file format must match the table.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.data_table_append_data_to_data_table_with_http_info(data_table_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str data_table_identifier: (required)
        :param str tenant_url_code: (required)
        :param str file:
        :return: DataTable
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['data_table_identifier', 'tenant_url_code', 'file']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method data_table_append_data_to_data_table" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'data_table_identifier' is set
        if ('data_table_identifier' not in params or
                params['data_table_identifier'] is None):
            raise ValueError("Missing the required parameter `data_table_identifier` when calling `data_table_append_data_to_data_table`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `data_table_append_data_to_data_table`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'data_table_identifier' in params:
            path_params['dataTableIdentifier'] = params['data_table_identifier']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'file' in params:
            local_var_files['file'] = params['file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/DataTable/{dataTableIdentifier}/append', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DataTable',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def data_table_create_data_table(self, body, tenant_url_code, **kwargs):  # noqa: E501
        """Creates a new empty table.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.data_table_create_data_table(body, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DataTableCreateParameter body: (required)
        :param str tenant_url_code: (required)
        :return: DataTable
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.data_table_create_data_table_with_http_info(body, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.data_table_create_data_table_with_http_info(body, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def data_table_create_data_table_with_http_info(self, body, tenant_url_code, **kwargs):  # noqa: E501
        """Creates a new empty table.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.data_table_create_data_table_with_http_info(body, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DataTableCreateParameter body: (required)
        :param str tenant_url_code: (required)
        :return: DataTable
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method data_table_create_data_table" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `data_table_create_data_table`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `data_table_create_data_table`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/createDataTable', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DataTable',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def data_table_create_from_csv(self, tenant_url_code, **kwargs):  # noqa: E501
        """Creates a table from a CSV file.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.data_table_create_from_csv(tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str tenant_url_code: (required)
        :param str file:
        :return: DataTable
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.data_table_create_from_csv_with_http_info(tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.data_table_create_from_csv_with_http_info(tenant_url_code, **kwargs)  # noqa: E501
            return data

    def data_table_create_from_csv_with_http_info(self, tenant_url_code, **kwargs):  # noqa: E501
        """Creates a table from a CSV file.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.data_table_create_from_csv_with_http_info(tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str tenant_url_code: (required)
        :param str file:
        :return: DataTable
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['tenant_url_code', 'file']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method data_table_create_from_csv" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `data_table_create_from_csv`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'file' in params:
            local_var_files['file'] = params['file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/DataTable/createFromCSV', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DataTable',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def data_table_create_from_excel(self, tenant_url_code, **kwargs):  # noqa: E501
        """Creates a new table from an Excel file. If the files has multiple sheets, only the first one is used.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.data_table_create_from_excel(tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str tenant_url_code: (required)
        :param str file:
        :return: DataTable
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.data_table_create_from_excel_with_http_info(tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.data_table_create_from_excel_with_http_info(tenant_url_code, **kwargs)  # noqa: E501
            return data

    def data_table_create_from_excel_with_http_info(self, tenant_url_code, **kwargs):  # noqa: E501
        """Creates a new table from an Excel file. If the files has multiple sheets, only the first one is used.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.data_table_create_from_excel_with_http_info(tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str tenant_url_code: (required)
        :param str file:
        :return: DataTable
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['tenant_url_code', 'file']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method data_table_create_from_excel" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `data_table_create_from_excel`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'file' in params:
            local_var_files['file'] = params['file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/DataTable/createFromExcel', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DataTable',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def data_table_create_from_excel2(self, sheet_name, tenant_url_code, **kwargs):  # noqa: E501
        """Creates a new table from an Excel file using a specific sheet.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.data_table_create_from_excel2(sheet_name, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str sheet_name: (required)
        :param str tenant_url_code: (required)
        :param str file:
        :return: DataTable
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.data_table_create_from_excel2_with_http_info(sheet_name, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.data_table_create_from_excel2_with_http_info(sheet_name, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def data_table_create_from_excel2_with_http_info(self, sheet_name, tenant_url_code, **kwargs):  # noqa: E501
        """Creates a new table from an Excel file using a specific sheet.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.data_table_create_from_excel2_with_http_info(sheet_name, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str sheet_name: (required)
        :param str tenant_url_code: (required)
        :param str file:
        :return: DataTable
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sheet_name', 'tenant_url_code', 'file']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method data_table_create_from_excel2" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params or
                params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `data_table_create_from_excel2`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `data_table_create_from_excel2`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'file' in params:
            local_var_files['file'] = params['file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/DataTable/createFromExcel/{sheetName}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DataTable',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def data_table_de_optimize_data_table(self, data_table_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Disable the ClickHouse optimization for this table.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.data_table_de_optimize_data_table(data_table_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str data_table_identifier: (required)
        :param str tenant_url_code: (required)
        :return: DataTable
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.data_table_de_optimize_data_table_with_http_info(data_table_identifier, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.data_table_de_optimize_data_table_with_http_info(data_table_identifier, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def data_table_de_optimize_data_table_with_http_info(self, data_table_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Disable the ClickHouse optimization for this table.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.data_table_de_optimize_data_table_with_http_info(data_table_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str data_table_identifier: (required)
        :param str tenant_url_code: (required)
        :return: DataTable
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['data_table_identifier', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method data_table_de_optimize_data_table" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'data_table_identifier' is set
        if ('data_table_identifier' not in params or
                params['data_table_identifier'] is None):
            raise ValueError("Missing the required parameter `data_table_identifier` when calling `data_table_de_optimize_data_table`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `data_table_de_optimize_data_table`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'data_table_identifier' in params:
            path_params['dataTableIdentifier'] = params['data_table_identifier']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/DataTable/{dataTableIdentifier}/deoptimize', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DataTable',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def data_table_delete_data_table(self, data_table_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Deletes the table.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.data_table_delete_data_table(data_table_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str data_table_identifier: (required)
        :param str tenant_url_code: (required)
        :return: DeleteDataTableResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.data_table_delete_data_table_with_http_info(data_table_identifier, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.data_table_delete_data_table_with_http_info(data_table_identifier, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def data_table_delete_data_table_with_http_info(self, data_table_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Deletes the table.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.data_table_delete_data_table_with_http_info(data_table_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str data_table_identifier: (required)
        :param str tenant_url_code: (required)
        :return: DeleteDataTableResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['data_table_identifier', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method data_table_delete_data_table" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'data_table_identifier' is set
        if ('data_table_identifier' not in params or
                params['data_table_identifier'] is None):
            raise ValueError("Missing the required parameter `data_table_identifier` when calling `data_table_delete_data_table`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `data_table_delete_data_table`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'data_table_identifier' in params:
            path_params['dataTableIdentifier'] = params['data_table_identifier']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/DataTable/{dataTableIdentifier}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DeleteDataTableResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def data_table_delete_join(self, body, join_id, tenant_url_code, **kwargs):  # noqa: E501
        """Deletes a join between a table and a layer.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.data_table_delete_join(body, join_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DeleteJoinParameter body: (required)
        :param str join_id: (required)
        :param str tenant_url_code: (required)
        :return: DeleteJoinResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.data_table_delete_join_with_http_info(body, join_id, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.data_table_delete_join_with_http_info(body, join_id, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def data_table_delete_join_with_http_info(self, body, join_id, tenant_url_code, **kwargs):  # noqa: E501
        """Deletes a join between a table and a layer.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.data_table_delete_join_with_http_info(body, join_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DeleteJoinParameter body: (required)
        :param str join_id: (required)
        :param str tenant_url_code: (required)
        :return: DeleteJoinResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'join_id', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method data_table_delete_join" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `data_table_delete_join`")  # noqa: E501
        # verify the required parameter 'join_id' is set
        if ('join_id' not in params or
                params['join_id'] is None):
            raise ValueError("Missing the required parameter `join_id` when calling `data_table_delete_join`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `data_table_delete_join`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'join_id' in params:
            path_params['joinId'] = params['join_id']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/join/{joinId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DeleteJoinResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def data_table_geocode_data_table(self, body, data_table_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Converts a table to a point by building addresses using the list of columns.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.data_table_geocode_data_table(body, data_table_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param GeocodeDataTableParameter body: (required)
        :param str data_table_identifier: (required)
        :param str tenant_url_code: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.data_table_geocode_data_table_with_http_info(body, data_table_identifier, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.data_table_geocode_data_table_with_http_info(body, data_table_identifier, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def data_table_geocode_data_table_with_http_info(self, body, data_table_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Converts a table to a point by building addresses using the list of columns.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.data_table_geocode_data_table_with_http_info(body, data_table_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param GeocodeDataTableParameter body: (required)
        :param str data_table_identifier: (required)
        :param str tenant_url_code: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'data_table_identifier', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method data_table_geocode_data_table" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `data_table_geocode_data_table`")  # noqa: E501
        # verify the required parameter 'data_table_identifier' is set
        if ('data_table_identifier' not in params or
                params['data_table_identifier'] is None):
            raise ValueError("Missing the required parameter `data_table_identifier` when calling `data_table_geocode_data_table`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `data_table_geocode_data_table`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'data_table_identifier' in params:
            path_params['dataTableIdentifier'] = params['data_table_identifier']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/DataTable/{dataTableIdentifier}/geocode', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def data_table_georeference_data_table(self, body, data_table_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Converts a table to a point layer using two of its columns as latitude and longitude.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.data_table_georeference_data_table(body, data_table_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param GeoreferenceDataTableParameter body: (required)
        :param str data_table_identifier: (required)
        :param str tenant_url_code: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.data_table_georeference_data_table_with_http_info(body, data_table_identifier, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.data_table_georeference_data_table_with_http_info(body, data_table_identifier, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def data_table_georeference_data_table_with_http_info(self, body, data_table_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Converts a table to a point layer using two of its columns as latitude and longitude.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.data_table_georeference_data_table_with_http_info(body, data_table_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param GeoreferenceDataTableParameter body: (required)
        :param str data_table_identifier: (required)
        :param str tenant_url_code: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'data_table_identifier', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method data_table_georeference_data_table" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `data_table_georeference_data_table`")  # noqa: E501
        # verify the required parameter 'data_table_identifier' is set
        if ('data_table_identifier' not in params or
                params['data_table_identifier'] is None):
            raise ValueError("Missing the required parameter `data_table_identifier` when calling `data_table_georeference_data_table`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `data_table_georeference_data_table`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'data_table_identifier' in params:
            path_params['dataTableIdentifier'] = params['data_table_identifier']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/DataTable/{dataTableIdentifier}/georeference', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def data_table_get_data_table_by_identifier(self, data_table_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Gets a specifc table.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.data_table_get_data_table_by_identifier(data_table_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str data_table_identifier: (required)
        :param str tenant_url_code: (required)
        :return: DataTable
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.data_table_get_data_table_by_identifier_with_http_info(data_table_identifier, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.data_table_get_data_table_by_identifier_with_http_info(data_table_identifier, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def data_table_get_data_table_by_identifier_with_http_info(self, data_table_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Gets a specifc table.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.data_table_get_data_table_by_identifier_with_http_info(data_table_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str data_table_identifier: (required)
        :param str tenant_url_code: (required)
        :return: DataTable
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['data_table_identifier', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method data_table_get_data_table_by_identifier" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'data_table_identifier' is set
        if ('data_table_identifier' not in params or
                params['data_table_identifier'] is None):
            raise ValueError("Missing the required parameter `data_table_identifier` when calling `data_table_get_data_table_by_identifier`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `data_table_get_data_table_by_identifier`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'data_table_identifier' in params:
            path_params['dataTableIdentifier'] = params['data_table_identifier']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/DataTable/{dataTableIdentifier}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DataTable',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def data_table_get_data_table_details(self, data_table_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Gets the table, its related maps, tables, columns and settings.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.data_table_get_data_table_details(data_table_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str data_table_identifier: (required)
        :param str tenant_url_code: (required)
        :return: DataTableWithDetails
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.data_table_get_data_table_details_with_http_info(data_table_identifier, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.data_table_get_data_table_details_with_http_info(data_table_identifier, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def data_table_get_data_table_details_with_http_info(self, data_table_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Gets the table, its related maps, tables, columns and settings.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.data_table_get_data_table_details_with_http_info(data_table_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str data_table_identifier: (required)
        :param str tenant_url_code: (required)
        :return: DataTableWithDetails
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['data_table_identifier', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method data_table_get_data_table_details" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'data_table_identifier' is set
        if ('data_table_identifier' not in params or
                params['data_table_identifier'] is None):
            raise ValueError("Missing the required parameter `data_table_identifier` when calling `data_table_get_data_table_details`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `data_table_get_data_table_details`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'data_table_identifier' in params:
            path_params['dataTableIdentifier'] = params['data_table_identifier']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/DataTables/{dataTableIdentifier}/details', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DataTableWithDetails',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def data_table_get_data_tables(self, tenant_url_code, **kwargs):  # noqa: E501
        """Gets all the tables the user has access to.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.data_table_get_data_tables(tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str tenant_url_code: (required)
        :return: list[DataTable]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.data_table_get_data_tables_with_http_info(tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.data_table_get_data_tables_with_http_info(tenant_url_code, **kwargs)  # noqa: E501
            return data

    def data_table_get_data_tables_with_http_info(self, tenant_url_code, **kwargs):  # noqa: E501
        """Gets all the tables the user has access to.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.data_table_get_data_tables_with_http_info(tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str tenant_url_code: (required)
        :return: list[DataTable]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method data_table_get_data_tables" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `data_table_get_data_tables`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/DataTables', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[DataTable]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def data_table_get_expected_join_count(self, body, data_table_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Gets the number of links between a table and a layer. The result can be for a 1-to-1 or 1-to-n join.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.data_table_get_expected_join_count(body, data_table_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DataTableJoinParameter body: (required)
        :param str data_table_identifier: (required)
        :param str tenant_url_code: (required)
        :return: JoinCount
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.data_table_get_expected_join_count_with_http_info(body, data_table_identifier, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.data_table_get_expected_join_count_with_http_info(body, data_table_identifier, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def data_table_get_expected_join_count_with_http_info(self, body, data_table_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Gets the number of links between a table and a layer. The result can be for a 1-to-1 or 1-to-n join.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.data_table_get_expected_join_count_with_http_info(body, data_table_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DataTableJoinParameter body: (required)
        :param str data_table_identifier: (required)
        :param str tenant_url_code: (required)
        :return: JoinCount
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'data_table_identifier', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method data_table_get_expected_join_count" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `data_table_get_expected_join_count`")  # noqa: E501
        # verify the required parameter 'data_table_identifier' is set
        if ('data_table_identifier' not in params or
                params['data_table_identifier'] is None):
            raise ValueError("Missing the required parameter `data_table_identifier` when calling `data_table_get_expected_join_count`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `data_table_get_expected_join_count`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'data_table_identifier' in params:
            path_params['dataTableIdentifier'] = params['data_table_identifier']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/DataTable/{dataTableIdentifier}/getExpectedJoinCount', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='JoinCount',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def data_table_get_file_description(self, data_table_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Stores a temporary file for an upcoming data insert or update and returns a description of the file's content.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.data_table_get_file_description(data_table_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str data_table_identifier: (required)
        :param str tenant_url_code: (required)
        :param str file:
        :return: FileDescription
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.data_table_get_file_description_with_http_info(data_table_identifier, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.data_table_get_file_description_with_http_info(data_table_identifier, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def data_table_get_file_description_with_http_info(self, data_table_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Stores a temporary file for an upcoming data insert or update and returns a description of the file's content.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.data_table_get_file_description_with_http_info(data_table_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str data_table_identifier: (required)
        :param str tenant_url_code: (required)
        :param str file:
        :return: FileDescription
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['data_table_identifier', 'tenant_url_code', 'file']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method data_table_get_file_description" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'data_table_identifier' is set
        if ('data_table_identifier' not in params or
                params['data_table_identifier'] is None):
            raise ValueError("Missing the required parameter `data_table_identifier` when calling `data_table_get_file_description`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `data_table_get_file_description`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'data_table_identifier' in params:
            path_params['dataTableIdentifier'] = params['data_table_identifier']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'file' in params:
            local_var_files['file'] = params['file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/DataTable/{dataTableIdentifier}/getFileDescription', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='FileDescription',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def data_table_get_layers_by_data_table_identifier(self, data_table_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Gets all the layers associated to the table (joins or parent layer, if any).  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.data_table_get_layers_by_data_table_identifier(data_table_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str data_table_identifier: (required)
        :param str tenant_url_code: (required)
        :return: list[Layer]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.data_table_get_layers_by_data_table_identifier_with_http_info(data_table_identifier, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.data_table_get_layers_by_data_table_identifier_with_http_info(data_table_identifier, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def data_table_get_layers_by_data_table_identifier_with_http_info(self, data_table_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Gets all the layers associated to the table (joins or parent layer, if any).  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.data_table_get_layers_by_data_table_identifier_with_http_info(data_table_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str data_table_identifier: (required)
        :param str tenant_url_code: (required)
        :return: list[Layer]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['data_table_identifier', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method data_table_get_layers_by_data_table_identifier" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'data_table_identifier' is set
        if ('data_table_identifier' not in params or
                params['data_table_identifier'] is None):
            raise ValueError("Missing the required parameter `data_table_identifier` when calling `data_table_get_layers_by_data_table_identifier`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `data_table_get_layers_by_data_table_identifier`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'data_table_identifier' in params:
            path_params['dataTableIdentifier'] = params['data_table_identifier']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/DataTable/{dataTableIdentifier}/layers', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Layer]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def data_table_get_maps_by_data_table_identifier(self, data_table_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Gets all the maps that use the table.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.data_table_get_maps_by_data_table_identifier(data_table_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str data_table_identifier: (required)
        :param str tenant_url_code: (required)
        :return: list[Map]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.data_table_get_maps_by_data_table_identifier_with_http_info(data_table_identifier, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.data_table_get_maps_by_data_table_identifier_with_http_info(data_table_identifier, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def data_table_get_maps_by_data_table_identifier_with_http_info(self, data_table_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Gets all the maps that use the table.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.data_table_get_maps_by_data_table_identifier_with_http_info(data_table_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str data_table_identifier: (required)
        :param str tenant_url_code: (required)
        :return: list[Map]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['data_table_identifier', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method data_table_get_maps_by_data_table_identifier" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'data_table_identifier' is set
        if ('data_table_identifier' not in params or
                params['data_table_identifier'] is None):
            raise ValueError("Missing the required parameter `data_table_identifier` when calling `data_table_get_maps_by_data_table_identifier`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `data_table_get_maps_by_data_table_identifier`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'data_table_identifier' in params:
            path_params['dataTableIdentifier'] = params['data_table_identifier']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/DataTable/{dataTableIdentifier}/maps', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Map]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def data_table_get_time_range_by_data_table_identifier(self, data_table_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Gets the table's time range. The time series column must be set.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.data_table_get_time_range_by_data_table_identifier(data_table_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str data_table_identifier: (required)
        :param str tenant_url_code: (required)
        :return: TimeRangeDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.data_table_get_time_range_by_data_table_identifier_with_http_info(data_table_identifier, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.data_table_get_time_range_by_data_table_identifier_with_http_info(data_table_identifier, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def data_table_get_time_range_by_data_table_identifier_with_http_info(self, data_table_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Gets the table's time range. The time series column must be set.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.data_table_get_time_range_by_data_table_identifier_with_http_info(data_table_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str data_table_identifier: (required)
        :param str tenant_url_code: (required)
        :return: TimeRangeDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['data_table_identifier', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method data_table_get_time_range_by_data_table_identifier" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'data_table_identifier' is set
        if ('data_table_identifier' not in params or
                params['data_table_identifier'] is None):
            raise ValueError("Missing the required parameter `data_table_identifier` when calling `data_table_get_time_range_by_data_table_identifier`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `data_table_get_time_range_by_data_table_identifier`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'data_table_identifier' in params:
            path_params['dataTableIdentifier'] = params['data_table_identifier']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/DataTable/{dataTableIdentifier}/timeRange', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TimeRangeDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def data_table_get_time_series_data(self, body, data_table_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Returns an aggregation of the table's data using the time series column.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.data_table_get_time_series_data(body, data_table_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TimeSeriesOneFeatureDataParameter body: (required)
        :param str data_table_identifier: (required)
        :param str tenant_url_code: (required)
        :return: TimeSeriesData
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.data_table_get_time_series_data_with_http_info(body, data_table_identifier, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.data_table_get_time_series_data_with_http_info(body, data_table_identifier, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def data_table_get_time_series_data_with_http_info(self, body, data_table_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Returns an aggregation of the table's data using the time series column.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.data_table_get_time_series_data_with_http_info(body, data_table_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TimeSeriesOneFeatureDataParameter body: (required)
        :param str data_table_identifier: (required)
        :param str tenant_url_code: (required)
        :return: TimeSeriesData
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'data_table_identifier', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method data_table_get_time_series_data" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `data_table_get_time_series_data`")  # noqa: E501
        # verify the required parameter 'data_table_identifier' is set
        if ('data_table_identifier' not in params or
                params['data_table_identifier'] is None):
            raise ValueError("Missing the required parameter `data_table_identifier` when calling `data_table_get_time_series_data`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `data_table_get_time_series_data`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'data_table_identifier' in params:
            path_params['dataTableIdentifier'] = params['data_table_identifier']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/DataTable/{dataTableIdentifier}/timeSeriesData', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TimeSeriesData',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def data_table_get_time_series_data_many_features(self, body, data_table_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Returns an aggregation of the table's data using the time series column.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.data_table_get_time_series_data_many_features(body, data_table_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TimeSeriesManyFeaturesDataParameter body: (required)
        :param str data_table_identifier: (required)
        :param str tenant_url_code: (required)
        :return: list[TimeSeriesData]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.data_table_get_time_series_data_many_features_with_http_info(body, data_table_identifier, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.data_table_get_time_series_data_many_features_with_http_info(body, data_table_identifier, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def data_table_get_time_series_data_many_features_with_http_info(self, body, data_table_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Returns an aggregation of the table's data using the time series column.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.data_table_get_time_series_data_many_features_with_http_info(body, data_table_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TimeSeriesManyFeaturesDataParameter body: (required)
        :param str data_table_identifier: (required)
        :param str tenant_url_code: (required)
        :return: list[TimeSeriesData]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'data_table_identifier', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method data_table_get_time_series_data_many_features" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `data_table_get_time_series_data_many_features`")  # noqa: E501
        # verify the required parameter 'data_table_identifier' is set
        if ('data_table_identifier' not in params or
                params['data_table_identifier'] is None):
            raise ValueError("Missing the required parameter `data_table_identifier` when calling `data_table_get_time_series_data_many_features`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `data_table_get_time_series_data_many_features`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'data_table_identifier' in params:
            path_params['dataTableIdentifier'] = params['data_table_identifier']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/DataTable/{dataTableIdentifier}/timeSeriesDataManyFeatures', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[TimeSeriesData]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def data_table_get_time_series_dates(self, data_table_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Returns a list of all the dates in the time series table.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.data_table_get_time_series_dates(data_table_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str data_table_identifier: (required)
        :param str tenant_url_code: (required)
        :return: list[datetime]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.data_table_get_time_series_dates_with_http_info(data_table_identifier, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.data_table_get_time_series_dates_with_http_info(data_table_identifier, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def data_table_get_time_series_dates_with_http_info(self, data_table_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Returns a list of all the dates in the time series table.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.data_table_get_time_series_dates_with_http_info(data_table_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str data_table_identifier: (required)
        :param str tenant_url_code: (required)
        :return: list[datetime]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['data_table_identifier', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method data_table_get_time_series_dates" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'data_table_identifier' is set
        if ('data_table_identifier' not in params or
                params['data_table_identifier'] is None):
            raise ValueError("Missing the required parameter `data_table_identifier` when calling `data_table_get_time_series_dates`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `data_table_get_time_series_dates`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'data_table_identifier' in params:
            path_params['dataTableIdentifier'] = params['data_table_identifier']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/DataTable/{dataTableIdentifier}/timeSeriesDates', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[datetime]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def data_table_join_data_table(self, body, data_table_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Joins a table to a layer. The number of valid links must be greater than 0.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.data_table_join_data_table(body, data_table_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DataTableJoinParameter body: (required)
        :param str data_table_identifier: (required)
        :param str tenant_url_code: (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.data_table_join_data_table_with_http_info(body, data_table_identifier, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.data_table_join_data_table_with_http_info(body, data_table_identifier, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def data_table_join_data_table_with_http_info(self, body, data_table_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Joins a table to a layer. The number of valid links must be greater than 0.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.data_table_join_data_table_with_http_info(body, data_table_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DataTableJoinParameter body: (required)
        :param str data_table_identifier: (required)
        :param str tenant_url_code: (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'data_table_identifier', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method data_table_join_data_table" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `data_table_join_data_table`")  # noqa: E501
        # verify the required parameter 'data_table_identifier' is set
        if ('data_table_identifier' not in params or
                params['data_table_identifier'] is None):
            raise ValueError("Missing the required parameter `data_table_identifier` when calling `data_table_join_data_table`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `data_table_join_data_table`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'data_table_identifier' in params:
            path_params['dataTableIdentifier'] = params['data_table_identifier']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/DataTable/{dataTableIdentifier}/join', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def data_table_optimize_data_table(self, data_table_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Optimizes the table queries with ClickHouse. If the table belongs to a layer, the layer must be tiled.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.data_table_optimize_data_table(data_table_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str data_table_identifier: (required)
        :param str tenant_url_code: (required)
        :return: DataTable
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.data_table_optimize_data_table_with_http_info(data_table_identifier, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.data_table_optimize_data_table_with_http_info(data_table_identifier, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def data_table_optimize_data_table_with_http_info(self, data_table_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Optimizes the table queries with ClickHouse. If the table belongs to a layer, the layer must be tiled.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.data_table_optimize_data_table_with_http_info(data_table_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str data_table_identifier: (required)
        :param str tenant_url_code: (required)
        :return: DataTable
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['data_table_identifier', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method data_table_optimize_data_table" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'data_table_identifier' is set
        if ('data_table_identifier' not in params or
                params['data_table_identifier'] is None):
            raise ValueError("Missing the required parameter `data_table_identifier` when calling `data_table_optimize_data_table`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `data_table_optimize_data_table`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'data_table_identifier' in params:
            path_params['dataTableIdentifier'] = params['data_table_identifier']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/DataTable/{dataTableIdentifier}/optimize', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DataTable',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def data_table_set_data_column_unique_id(self, data_table_identifier, data_column_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Sets the table's unique identifier column. The column becomes the primary way to identify its rows.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.data_table_set_data_column_unique_id(data_table_identifier, data_column_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str data_table_identifier: (required)
        :param str data_column_identifier: (required)
        :param str tenant_url_code: (required)
        :return: DataTable
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.data_table_set_data_column_unique_id_with_http_info(data_table_identifier, data_column_identifier, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.data_table_set_data_column_unique_id_with_http_info(data_table_identifier, data_column_identifier, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def data_table_set_data_column_unique_id_with_http_info(self, data_table_identifier, data_column_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Sets the table's unique identifier column. The column becomes the primary way to identify its rows.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.data_table_set_data_column_unique_id_with_http_info(data_table_identifier, data_column_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str data_table_identifier: (required)
        :param str data_column_identifier: (required)
        :param str tenant_url_code: (required)
        :return: DataTable
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['data_table_identifier', 'data_column_identifier', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method data_table_set_data_column_unique_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'data_table_identifier' is set
        if ('data_table_identifier' not in params or
                params['data_table_identifier'] is None):
            raise ValueError("Missing the required parameter `data_table_identifier` when calling `data_table_set_data_column_unique_id`")  # noqa: E501
        # verify the required parameter 'data_column_identifier' is set
        if ('data_column_identifier' not in params or
                params['data_column_identifier'] is None):
            raise ValueError("Missing the required parameter `data_column_identifier` when calling `data_table_set_data_column_unique_id`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `data_table_set_data_column_unique_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'data_table_identifier' in params:
            path_params['dataTableIdentifier'] = params['data_table_identifier']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []
        if 'data_column_identifier' in params:
            query_params.append(('dataColumnIdentifier', params['data_column_identifier']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/DataTable/{dataTableIdentifier}/setDataColumnUniqueId', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DataTable',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def data_table_set_time_series_column(self, data_table_identifier, data_column_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Sets the time series column for a table. The column is required for time analyses in maps.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.data_table_set_time_series_column(data_table_identifier, data_column_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str data_table_identifier: (required)
        :param str data_column_identifier: (required)
        :param str tenant_url_code: (required)
        :return: DataTable
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.data_table_set_time_series_column_with_http_info(data_table_identifier, data_column_identifier, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.data_table_set_time_series_column_with_http_info(data_table_identifier, data_column_identifier, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def data_table_set_time_series_column_with_http_info(self, data_table_identifier, data_column_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Sets the time series column for a table. The column is required for time analyses in maps.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.data_table_set_time_series_column_with_http_info(data_table_identifier, data_column_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str data_table_identifier: (required)
        :param str data_column_identifier: (required)
        :param str tenant_url_code: (required)
        :return: DataTable
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['data_table_identifier', 'data_column_identifier', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method data_table_set_time_series_column" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'data_table_identifier' is set
        if ('data_table_identifier' not in params or
                params['data_table_identifier'] is None):
            raise ValueError("Missing the required parameter `data_table_identifier` when calling `data_table_set_time_series_column`")  # noqa: E501
        # verify the required parameter 'data_column_identifier' is set
        if ('data_column_identifier' not in params or
                params['data_column_identifier'] is None):
            raise ValueError("Missing the required parameter `data_column_identifier` when calling `data_table_set_time_series_column`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `data_table_set_time_series_column`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'data_table_identifier' in params:
            path_params['dataTableIdentifier'] = params['data_table_identifier']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []
        if 'data_column_identifier' in params:
            query_params.append(('dataColumnIdentifier', params['data_column_identifier']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/DataTable/{dataTableIdentifier}/time-series-column', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DataTable',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def data_table_set_unique_identifier(self, data_table_identifier, new_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Sets the table's identifier.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.data_table_set_unique_identifier(data_table_identifier, new_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str data_table_identifier: (required)
        :param str new_identifier: (required)
        :param str tenant_url_code: (required)
        :return: DataTable
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.data_table_set_unique_identifier_with_http_info(data_table_identifier, new_identifier, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.data_table_set_unique_identifier_with_http_info(data_table_identifier, new_identifier, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def data_table_set_unique_identifier_with_http_info(self, data_table_identifier, new_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Sets the table's identifier.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.data_table_set_unique_identifier_with_http_info(data_table_identifier, new_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str data_table_identifier: (required)
        :param str new_identifier: (required)
        :param str tenant_url_code: (required)
        :return: DataTable
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['data_table_identifier', 'new_identifier', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method data_table_set_unique_identifier" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'data_table_identifier' is set
        if ('data_table_identifier' not in params or
                params['data_table_identifier'] is None):
            raise ValueError("Missing the required parameter `data_table_identifier` when calling `data_table_set_unique_identifier`")  # noqa: E501
        # verify the required parameter 'new_identifier' is set
        if ('new_identifier' not in params or
                params['new_identifier'] is None):
            raise ValueError("Missing the required parameter `new_identifier` when calling `data_table_set_unique_identifier`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `data_table_set_unique_identifier`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'data_table_identifier' in params:
            path_params['dataTableIdentifier'] = params['data_table_identifier']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []
        if 'new_identifier' in params:
            query_params.append(('newIdentifier', params['new_identifier']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/DataTable/{dataTableIdentifier}/setUniqueIdentifier', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DataTable',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def data_table_update_data_table(self, body, data_table_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Updates the table's properties.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.data_table_update_data_table(body, data_table_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DataTableUpdateParameter body: (required)
        :param str data_table_identifier: (required)
        :param str tenant_url_code: (required)
        :return: DataTable
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.data_table_update_data_table_with_http_info(body, data_table_identifier, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.data_table_update_data_table_with_http_info(body, data_table_identifier, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def data_table_update_data_table_with_http_info(self, body, data_table_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Updates the table's properties.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.data_table_update_data_table_with_http_info(body, data_table_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DataTableUpdateParameter body: (required)
        :param str data_table_identifier: (required)
        :param str tenant_url_code: (required)
        :return: DataTable
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'data_table_identifier', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method data_table_update_data_table" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `data_table_update_data_table`")  # noqa: E501
        # verify the required parameter 'data_table_identifier' is set
        if ('data_table_identifier' not in params or
                params['data_table_identifier'] is None):
            raise ValueError("Missing the required parameter `data_table_identifier` when calling `data_table_update_data_table`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `data_table_update_data_table`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'data_table_identifier' in params:
            path_params['dataTableIdentifier'] = params['data_table_identifier']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/DataTable/{dataTableIdentifier}/update', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DataTable',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def data_table_update_data_table_from_file(self, data_table_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Updates a table's data with a file. The file's format must match the table.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.data_table_update_data_table_from_file(data_table_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str data_table_identifier: (required)
        :param str tenant_url_code: (required)
        :param str file:
        :return: DataTable
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.data_table_update_data_table_from_file_with_http_info(data_table_identifier, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.data_table_update_data_table_from_file_with_http_info(data_table_identifier, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def data_table_update_data_table_from_file_with_http_info(self, data_table_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Updates a table's data with a file. The file's format must match the table.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.data_table_update_data_table_from_file_with_http_info(data_table_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str data_table_identifier: (required)
        :param str tenant_url_code: (required)
        :param str file:
        :return: DataTable
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['data_table_identifier', 'tenant_url_code', 'file']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method data_table_update_data_table_from_file" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'data_table_identifier' is set
        if ('data_table_identifier' not in params or
                params['data_table_identifier'] is None):
            raise ValueError("Missing the required parameter `data_table_identifier` when calling `data_table_update_data_table_from_file`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `data_table_update_data_table_from_file`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'data_table_identifier' in params:
            path_params['dataTableIdentifier'] = params['data_table_identifier']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'file' in params:
            local_var_files['file'] = params['file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/DataTable/{dataTableIdentifier}/updateFromFile', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DataTable',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def data_table_update_data_table_from_file_description(self, body, data_table_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Updates a table with a file uploaded using `DataTable/{dataTableIdentifier}/getFileDescription`.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.data_table_update_data_table_from_file_description(body, data_table_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UpdateTableFromFileParameter body: (required)
        :param str data_table_identifier: (required)
        :param str tenant_url_code: (required)
        :return: DataTable
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.data_table_update_data_table_from_file_description_with_http_info(body, data_table_identifier, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.data_table_update_data_table_from_file_description_with_http_info(body, data_table_identifier, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def data_table_update_data_table_from_file_description_with_http_info(self, body, data_table_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Updates a table with a file uploaded using `DataTable/{dataTableIdentifier}/getFileDescription`.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.data_table_update_data_table_from_file_description_with_http_info(body, data_table_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UpdateTableFromFileParameter body: (required)
        :param str data_table_identifier: (required)
        :param str tenant_url_code: (required)
        :return: DataTable
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'data_table_identifier', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method data_table_update_data_table_from_file_description" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `data_table_update_data_table_from_file_description`")  # noqa: E501
        # verify the required parameter 'data_table_identifier' is set
        if ('data_table_identifier' not in params or
                params['data_table_identifier'] is None):
            raise ValueError("Missing the required parameter `data_table_identifier` when calling `data_table_update_data_table_from_file_description`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `data_table_update_data_table_from_file_description`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'data_table_identifier' in params:
            path_params['dataTableIdentifier'] = params['data_table_identifier']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/DataTable/{dataTableIdentifier}/updateFromFileDescription', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DataTable',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
