# coding: utf-8

"""
    CartoVista REST API

    No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)  # noqa: E501

    OpenAPI spec version: 2.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from add_to_cartovista.swagger_client.api_client import ApiClient


class CompositeVariableScoringApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def composite_variable_scoring_can_create_analysis(self, map_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Whether or not a user can create analysis on a map  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.composite_variable_scoring_can_create_analysis(map_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str map_identifier: (required)
        :param str tenant_url_code: (required)
        :return: bool
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.composite_variable_scoring_can_create_analysis_with_http_info(map_identifier, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.composite_variable_scoring_can_create_analysis_with_http_info(map_identifier, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def composite_variable_scoring_can_create_analysis_with_http_info(self, map_identifier, tenant_url_code, **kwargs):  # noqa: E501
        """Whether or not a user can create analysis on a map  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.composite_variable_scoring_can_create_analysis_with_http_info(map_identifier, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str map_identifier: (required)
        :param str tenant_url_code: (required)
        :return: bool
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['map_identifier', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method composite_variable_scoring_can_create_analysis" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'map_identifier' is set
        if ('map_identifier' not in params or
                params['map_identifier'] is None):
            raise ValueError("Missing the required parameter `map_identifier` when calling `composite_variable_scoring_can_create_analysis`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `composite_variable_scoring_can_create_analysis`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'map_identifier' in params:
            path_params['mapIdentifier'] = params['map_identifier']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/score-analysis/{mapIdentifier}/canCreateAnalysis', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='bool',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def composite_variable_scoring_create_composite_scoring_analysis(self, map_id, layer_id, analysis_name, tenant_url_code, **kwargs):  # noqa: E501
        """Creates a scoring analysis for a map and a layer.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.composite_variable_scoring_create_composite_scoring_analysis(map_id, layer_id, analysis_name, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str map_id: (required)
        :param str layer_id: (required)
        :param str analysis_name: (required)
        :param str tenant_url_code: (required)
        :return: Analysis
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.composite_variable_scoring_create_composite_scoring_analysis_with_http_info(map_id, layer_id, analysis_name, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.composite_variable_scoring_create_composite_scoring_analysis_with_http_info(map_id, layer_id, analysis_name, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def composite_variable_scoring_create_composite_scoring_analysis_with_http_info(self, map_id, layer_id, analysis_name, tenant_url_code, **kwargs):  # noqa: E501
        """Creates a scoring analysis for a map and a layer.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.composite_variable_scoring_create_composite_scoring_analysis_with_http_info(map_id, layer_id, analysis_name, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str map_id: (required)
        :param str layer_id: (required)
        :param str analysis_name: (required)
        :param str tenant_url_code: (required)
        :return: Analysis
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['map_id', 'layer_id', 'analysis_name', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method composite_variable_scoring_create_composite_scoring_analysis" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'map_id' is set
        if ('map_id' not in params or
                params['map_id'] is None):
            raise ValueError("Missing the required parameter `map_id` when calling `composite_variable_scoring_create_composite_scoring_analysis`")  # noqa: E501
        # verify the required parameter 'layer_id' is set
        if ('layer_id' not in params or
                params['layer_id'] is None):
            raise ValueError("Missing the required parameter `layer_id` when calling `composite_variable_scoring_create_composite_scoring_analysis`")  # noqa: E501
        # verify the required parameter 'analysis_name' is set
        if ('analysis_name' not in params or
                params['analysis_name'] is None):
            raise ValueError("Missing the required parameter `analysis_name` when calling `composite_variable_scoring_create_composite_scoring_analysis`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `composite_variable_scoring_create_composite_scoring_analysis`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'map_id' in params:
            path_params['mapId'] = params['map_id']  # noqa: E501
        if 'layer_id' in params:
            path_params['layerId'] = params['layer_id']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []
        if 'analysis_name' in params:
            query_params.append(('analysisName', params['analysis_name']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/score-analysis/{mapId}/layer/{layerId}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Analysis',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def composite_variable_scoring_create_variable(self, body, analysis_id, tenant_url_code, **kwargs):  # noqa: E501
        """Creates a variable for a given analysis. The scores are recomputed.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.composite_variable_scoring_create_variable(body, analysis_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CreateCompositeVariableDTO body: (required)
        :param str analysis_id: (required)
        :param str tenant_url_code: (required)
        :return: VariableWithUpdatedWeightsDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.composite_variable_scoring_create_variable_with_http_info(body, analysis_id, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.composite_variable_scoring_create_variable_with_http_info(body, analysis_id, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def composite_variable_scoring_create_variable_with_http_info(self, body, analysis_id, tenant_url_code, **kwargs):  # noqa: E501
        """Creates a variable for a given analysis. The scores are recomputed.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.composite_variable_scoring_create_variable_with_http_info(body, analysis_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CreateCompositeVariableDTO body: (required)
        :param str analysis_id: (required)
        :param str tenant_url_code: (required)
        :return: VariableWithUpdatedWeightsDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'analysis_id', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method composite_variable_scoring_create_variable" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `composite_variable_scoring_create_variable`")  # noqa: E501
        # verify the required parameter 'analysis_id' is set
        if ('analysis_id' not in params or
                params['analysis_id'] is None):
            raise ValueError("Missing the required parameter `analysis_id` when calling `composite_variable_scoring_create_variable`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `composite_variable_scoring_create_variable`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'analysis_id' in params:
            path_params['analysisId'] = params['analysis_id']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/score-analysis/{analysisId}/variables', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='VariableWithUpdatedWeightsDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def composite_variable_scoring_delete_analysis(self, analysis_id, tenant_url_code, **kwargs):  # noqa: E501
        """Deletes an analysis. The scores are recomputed  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.composite_variable_scoring_delete_analysis(analysis_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str analysis_id: (required)
        :param str tenant_url_code: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.composite_variable_scoring_delete_analysis_with_http_info(analysis_id, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.composite_variable_scoring_delete_analysis_with_http_info(analysis_id, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def composite_variable_scoring_delete_analysis_with_http_info(self, analysis_id, tenant_url_code, **kwargs):  # noqa: E501
        """Deletes an analysis. The scores are recomputed  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.composite_variable_scoring_delete_analysis_with_http_info(analysis_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str analysis_id: (required)
        :param str tenant_url_code: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['analysis_id', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method composite_variable_scoring_delete_analysis" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'analysis_id' is set
        if ('analysis_id' not in params or
                params['analysis_id'] is None):
            raise ValueError("Missing the required parameter `analysis_id` when calling `composite_variable_scoring_delete_analysis`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `composite_variable_scoring_delete_analysis`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'analysis_id' in params:
            path_params['analysisId'] = params['analysis_id']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/score-analysis/{analysisId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def composite_variable_scoring_delete_variable(self, analysis_id, variable_id, tenant_url_code, **kwargs):  # noqa: E501
        """Deletes a variable. The scores are recomputed  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.composite_variable_scoring_delete_variable(analysis_id, variable_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str analysis_id: (required)
        :param str variable_id: (required)
        :param str tenant_url_code: (required)
        :return: VariableWithUpdatedWeightsDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.composite_variable_scoring_delete_variable_with_http_info(analysis_id, variable_id, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.composite_variable_scoring_delete_variable_with_http_info(analysis_id, variable_id, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def composite_variable_scoring_delete_variable_with_http_info(self, analysis_id, variable_id, tenant_url_code, **kwargs):  # noqa: E501
        """Deletes a variable. The scores are recomputed  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.composite_variable_scoring_delete_variable_with_http_info(analysis_id, variable_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str analysis_id: (required)
        :param str variable_id: (required)
        :param str tenant_url_code: (required)
        :return: VariableWithUpdatedWeightsDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['analysis_id', 'variable_id', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method composite_variable_scoring_delete_variable" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'analysis_id' is set
        if ('analysis_id' not in params or
                params['analysis_id'] is None):
            raise ValueError("Missing the required parameter `analysis_id` when calling `composite_variable_scoring_delete_variable`")  # noqa: E501
        # verify the required parameter 'variable_id' is set
        if ('variable_id' not in params or
                params['variable_id'] is None):
            raise ValueError("Missing the required parameter `variable_id` when calling `composite_variable_scoring_delete_variable`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `composite_variable_scoring_delete_variable`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'analysis_id' in params:
            path_params['analysisId'] = params['analysis_id']  # noqa: E501
        if 'variable_id' in params:
            path_params['variableId'] = params['variable_id']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/score-analysis/{analysisId}/variables/{variableId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='VariableWithUpdatedWeightsDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def composite_variable_scoring_get_all_composite_scoring_analysis(self, map_id, tenant_url_code, **kwargs):  # noqa: E501
        """Gets all the analyses associated to a map.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.composite_variable_scoring_get_all_composite_scoring_analysis(map_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str map_id: (required)
        :param str tenant_url_code: (required)
        :return: list[Analysis]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.composite_variable_scoring_get_all_composite_scoring_analysis_with_http_info(map_id, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.composite_variable_scoring_get_all_composite_scoring_analysis_with_http_info(map_id, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def composite_variable_scoring_get_all_composite_scoring_analysis_with_http_info(self, map_id, tenant_url_code, **kwargs):  # noqa: E501
        """Gets all the analyses associated to a map.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.composite_variable_scoring_get_all_composite_scoring_analysis_with_http_info(map_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str map_id: (required)
        :param str tenant_url_code: (required)
        :return: list[Analysis]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['map_id', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method composite_variable_scoring_get_all_composite_scoring_analysis" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'map_id' is set
        if ('map_id' not in params or
                params['map_id'] is None):
            raise ValueError("Missing the required parameter `map_id` when calling `composite_variable_scoring_get_all_composite_scoring_analysis`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `composite_variable_scoring_get_all_composite_scoring_analysis`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'map_id' in params:
            path_params['mapId'] = params['map_id']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/score-analysis/{mapId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Analysis]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def composite_variable_scoring_get_composite_scoring_analysis_data_table(self, analysis_id, tenant_url_code, **kwargs):  # noqa: E501
        """Gets a summary of the score column and how it is joined to the existing data.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.composite_variable_scoring_get_composite_scoring_analysis_data_table(analysis_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str analysis_id: (required)
        :param str tenant_url_code: (required)
        :return: AnalysisDataTableDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.composite_variable_scoring_get_composite_scoring_analysis_data_table_with_http_info(analysis_id, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.composite_variable_scoring_get_composite_scoring_analysis_data_table_with_http_info(analysis_id, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def composite_variable_scoring_get_composite_scoring_analysis_data_table_with_http_info(self, analysis_id, tenant_url_code, **kwargs):  # noqa: E501
        """Gets a summary of the score column and how it is joined to the existing data.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.composite_variable_scoring_get_composite_scoring_analysis_data_table_with_http_info(analysis_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str analysis_id: (required)
        :param str tenant_url_code: (required)
        :return: AnalysisDataTableDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['analysis_id', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method composite_variable_scoring_get_composite_scoring_analysis_data_table" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'analysis_id' is set
        if ('analysis_id' not in params or
                params['analysis_id'] is None):
            raise ValueError("Missing the required parameter `analysis_id` when calling `composite_variable_scoring_get_composite_scoring_analysis_data_table`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `composite_variable_scoring_get_composite_scoring_analysis_data_table`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'analysis_id' in params:
            path_params['analysisId'] = params['analysis_id']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/score-analysis/{analysisId}/datatable', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AnalysisDataTableDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def composite_variable_scoring_get_variable(self, analysis_id, variable_id, tenant_url_code, **kwargs):  # noqa: E501
        """Gets a specific variable.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.composite_variable_scoring_get_variable(analysis_id, variable_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str analysis_id: (required)
        :param str variable_id: (required)
        :param str tenant_url_code: (required)
        :return: VariableDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.composite_variable_scoring_get_variable_with_http_info(analysis_id, variable_id, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.composite_variable_scoring_get_variable_with_http_info(analysis_id, variable_id, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def composite_variable_scoring_get_variable_with_http_info(self, analysis_id, variable_id, tenant_url_code, **kwargs):  # noqa: E501
        """Gets a specific variable.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.composite_variable_scoring_get_variable_with_http_info(analysis_id, variable_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str analysis_id: (required)
        :param str variable_id: (required)
        :param str tenant_url_code: (required)
        :return: VariableDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['analysis_id', 'variable_id', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method composite_variable_scoring_get_variable" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'analysis_id' is set
        if ('analysis_id' not in params or
                params['analysis_id'] is None):
            raise ValueError("Missing the required parameter `analysis_id` when calling `composite_variable_scoring_get_variable`")  # noqa: E501
        # verify the required parameter 'variable_id' is set
        if ('variable_id' not in params or
                params['variable_id'] is None):
            raise ValueError("Missing the required parameter `variable_id` when calling `composite_variable_scoring_get_variable`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `composite_variable_scoring_get_variable`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'analysis_id' in params:
            path_params['analysisId'] = params['analysis_id']  # noqa: E501
        if 'variable_id' in params:
            path_params['variableId'] = params['variable_id']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/score-analysis/{analysisId}/variables/{variableId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='VariableDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def composite_variable_scoring_get_variables(self, analysis_id, tenant_url_code, **kwargs):  # noqa: E501
        """Gets the variables for a specific analysis.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.composite_variable_scoring_get_variables(analysis_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str analysis_id: (required)
        :param str tenant_url_code: (required)
        :return: list[VariableDTO]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.composite_variable_scoring_get_variables_with_http_info(analysis_id, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.composite_variable_scoring_get_variables_with_http_info(analysis_id, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def composite_variable_scoring_get_variables_with_http_info(self, analysis_id, tenant_url_code, **kwargs):  # noqa: E501
        """Gets the variables for a specific analysis.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.composite_variable_scoring_get_variables_with_http_info(analysis_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str analysis_id: (required)
        :param str tenant_url_code: (required)
        :return: list[VariableDTO]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['analysis_id', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method composite_variable_scoring_get_variables" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'analysis_id' is set
        if ('analysis_id' not in params or
                params['analysis_id'] is None):
            raise ValueError("Missing the required parameter `analysis_id` when calling `composite_variable_scoring_get_variables`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `composite_variable_scoring_get_variables`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'analysis_id' in params:
            path_params['analysisId'] = params['analysis_id']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/score-analysis/{analysisId}/variables', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[VariableDTO]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def composite_variable_scoring_update_analysis_properties(self, body, analysis_id, tenant_url_code, **kwargs):  # noqa: E501
        """Updates a variable. The scores are recomputed.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.composite_variable_scoring_update_analysis_properties(body, analysis_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UpdateVariableDTO body: (required)
        :param str analysis_id: (required)
        :param str tenant_url_code: (required)
        :return: AnalysisDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.composite_variable_scoring_update_analysis_properties_with_http_info(body, analysis_id, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.composite_variable_scoring_update_analysis_properties_with_http_info(body, analysis_id, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def composite_variable_scoring_update_analysis_properties_with_http_info(self, body, analysis_id, tenant_url_code, **kwargs):  # noqa: E501
        """Updates a variable. The scores are recomputed.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.composite_variable_scoring_update_analysis_properties_with_http_info(body, analysis_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UpdateVariableDTO body: (required)
        :param str analysis_id: (required)
        :param str tenant_url_code: (required)
        :return: AnalysisDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'analysis_id', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method composite_variable_scoring_update_analysis_properties" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `composite_variable_scoring_update_analysis_properties`")  # noqa: E501
        # verify the required parameter 'analysis_id' is set
        if ('analysis_id' not in params or
                params['analysis_id'] is None):
            raise ValueError("Missing the required parameter `analysis_id` when calling `composite_variable_scoring_update_analysis_properties`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `composite_variable_scoring_update_analysis_properties`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'analysis_id' in params:
            path_params['analysisId'] = params['analysis_id']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/score-analysis/{analysisId}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AnalysisDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def composite_variable_scoring_update_variable(self, body, variable_id, tenant_url_code, **kwargs):  # noqa: E501
        """Updates a variable. The scores are recomputed.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.composite_variable_scoring_update_variable(body, variable_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UpdateVariableDTO body: (required)
        :param str variable_id: (required)
        :param str tenant_url_code: (required)
        :return: VariableWithUpdatedWeightsDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.composite_variable_scoring_update_variable_with_http_info(body, variable_id, tenant_url_code, **kwargs)  # noqa: E501
        else:
            (data) = self.composite_variable_scoring_update_variable_with_http_info(body, variable_id, tenant_url_code, **kwargs)  # noqa: E501
            return data

    def composite_variable_scoring_update_variable_with_http_info(self, body, variable_id, tenant_url_code, **kwargs):  # noqa: E501
        """Updates a variable. The scores are recomputed.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.composite_variable_scoring_update_variable_with_http_info(body, variable_id, tenant_url_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UpdateVariableDTO body: (required)
        :param str variable_id: (required)
        :param str tenant_url_code: (required)
        :return: VariableWithUpdatedWeightsDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'variable_id', 'tenant_url_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method composite_variable_scoring_update_variable" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `composite_variable_scoring_update_variable`")  # noqa: E501
        # verify the required parameter 'variable_id' is set
        if ('variable_id' not in params or
                params['variable_id'] is None):
            raise ValueError("Missing the required parameter `variable_id` when calling `composite_variable_scoring_update_variable`")  # noqa: E501
        # verify the required parameter 'tenant_url_code' is set
        if ('tenant_url_code' not in params or
                params['tenant_url_code'] is None):
            raise ValueError("Missing the required parameter `tenant_url_code` when calling `composite_variable_scoring_update_variable`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'variable_id' in params:
            path_params['variableId'] = params['variable_id']  # noqa: E501
        if 'tenant_url_code' in params:
            path_params['tenantUrlCode'] = params['tenant_url_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey', 'bearer', 'secretKey']  # noqa: E501

        return self.api_client.call_api(
            '/{tenantUrlCode}/api/v2/score-analysis/{variableId}/variables', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='VariableWithUpdatedWeightsDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
