# -*- coding: utf-8 -*-
"""
/***************************************************************************
 ActiveFire
                                 A QGIS plugin
 Active Fire Data within 24 hours (MODIS)
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2020-01-28
        git sha              : $Format:%H$
        copyright            : (C) 2020 by The Map Workshop
        email                : themapworkshop@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction

# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .active_fire_dialog import ActiveFireDialog
import os.path
#os.system('pip install bs4')
import requests

from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction, QFileDialog
from PyQt5.QtWidgets import QAction, QFileDialog
from qgis import *
from qgis.PyQt.QtGui import QColor
from PyQt5.QtWidgets import QApplication, QWidget, QMessageBox
from PyQt5.QtWidgets import *
from qgis.core import *
# Initialize Qt resources from file resources.py
from .resources import *
import os.path
import sys


class ActiveFire:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'ActiveFire_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&Active FIre')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('ActiveFire', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/active_fire/firicon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'Display Active Fire'),
            callback=self.run,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.first_start = True


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&Active FIre'),
                action)
            self.iface.removeToolBarIcon(action)

    def MODIS(self):
        import requests
        from qgis.core import QgsApplication
        openmodis = 'https://firms.modaps.eosdis.nasa.gov/data/active_fire/modis-c6.1/shapes/zips/MODIS_C6_1_Global_24h.zip'  # Link to MODIS download
        r = requests.get(openmodis, allow_redirects=True)
        pluginpath = QgsApplication.qgisSettingsDirPath() + r'\python\plugins\active_fire'
        open(pluginpath + r'\MODIS24.zip', 'wb').write(r.content)
        self.iface.addVectorLayer(pluginpath + r'\MODIS24.zip', 'MODIS 24H', 'ogr')
        a = self.iface.activeLayer()
        ren = a.renderer()
        sym = QgsMarkerSymbol.createSimple(
            {'name': 'square', 'color': '#a9041a', 'size': '0.8', 'outline_width': '0', 'outline_color': '#a9041a'})
        ren.setSymbol(sym)
        a.triggerRepaint()  # Refresh Layer
        self.iface.layerTreeView().refreshLayerSymbology(a.id())
        a.setName(a.name().replace(a.name(), 'MODIS C6 1km'))
        self.dlg.lineEdit.setText(str(a.featureCount()))

        # import os
        # os.remove('/Users/pawel/Downloads/MODIS24.zip')

    def VIIRS_SNPP(self):
        from qgis.core import QgsApplication
        import requests
        openvirs = 'https://firms.modaps.eosdis.nasa.gov/data/active_fire/suomi-npp-viirs-c2/shapes/zips/SUOMI_VIIRS_C2_Global_24h.zip'  # link to VIIRS download
        r = requests.get(openvirs, allow_redirects=True)
        pluginpath = QgsApplication.qgisSettingsDirPath() + r'\python\plugins\active_fire'
        open(pluginpath + r'\VIIRS_SNPP24.zip', 'wb').write(r.content)
        self.iface.addVectorLayer(pluginpath + r'\VIIRS_SNPP24.zip', 'VIIRS S-NPP 24H', 'ogr')
        a = self.iface.activeLayer()
        ren = a.renderer()
        sym = QgsMarkerSymbol.createSimple(
            {'name': 'square', 'color': '#860415', 'size': '0.8', 'outline_width': '0', 'outline_color': '#860415'})
        ren.setSymbol(sym)
        a.triggerRepaint()  # Refresh Layer
        self.iface.layerTreeView().refreshLayerSymbology(a.id())
        a.setName(a.name().replace(a.name(), 'VIIRS 375m/S_NPP'))
        self.dlg.lineEdit_2.setText(str(a.featureCount()))


    def VIIRS_NOAA(self):
        from qgis.core import QgsApplication
        import requests
        openvirs = 'https://firms.modaps.eosdis.nasa.gov/data/active_fire/noaa-20-viirs-c2/shapes/zips/J1_VIIRS_C2_Global_24h.zip'  # link to VIIRS download
        r = requests.get(openvirs, allow_redirects=True)
        pluginpath = QgsApplication.qgisSettingsDirPath() + r'\python\plugins\active_fire'
        open(pluginpath + r'\VIIRS_NOAA24.zip', 'wb').write(r.content)
        self.iface.addVectorLayer(pluginpath + r'\VIIRS_NOAA24.zip', 'VIIRS NOAA 24H', 'ogr')
        a = self.iface.activeLayer()
        ren = a.renderer()
        sym = QgsMarkerSymbol.createSimple(
            {'name': 'square', 'color': '#860415', 'size': '0.8', 'outline_width': '0', 'outline_color': '#860415'})
        ren.setSymbol(sym)
        a.triggerRepaint()  # Refresh Layer
        self.iface.layerTreeView().refreshLayerSymbology(a.id())
        a.setName(a.name().replace(a.name(), 'VIIRS 375m/NOAA-20'))
        self.dlg.lineEdit_3.setText(str(a.featureCount()))    

    def MODIS1(self):
        from qgis.core import QgsProject
        if not QgsProject.instance().mapLayersByName('MODIS C6 1km'):
            self.MODIS()

    def VIIRS_SNPP1(self):
        from qgis.core import QgsProject
        if not QgsProject.instance().mapLayersByName('VIIRS 375m/S-NPP'):
            self.VIIRS_SNPP()

    def VIIRS_NOAA1(self):
        from qgis.core import QgsProject
        if not QgsProject.instance().mapLayersByName('VIIRS 375m/NOAA-20'):
            self.VIIRS_NOAA()        

    def run(self):
        """Run method that performs all the real work"""

        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started
        if self.first_start == True:
            self.first_start = False
            self.dlg = ActiveFireDialog()
            self.dlg.pushButton.clicked.connect(self.MODIS1)
            self.dlg.pushButton_2.clicked.connect(self.VIIRS_SNPP1)
            self.dlg.pushButton_4.clicked.connect(self.VIIRS_NOAA1)

        # show the dialog
        self.dlg.show()
        # Run the dialog event loop
        result = self.dlg.exec_()
        # See if OK was pressed
        if result:
            # Do something useful here - delete the line containing pass and
            # substitute with your code.
            self.dlg.lineEdit.clear()
            self.dlg.lineEdit_2.clear()
            self.dlg.lineEdit_3.clear()
            pass
