﻿# -*- coding: utf-8 -*-
"""
/***************************************************************************
 ZoomToBelgium
 A button to zoom to any of the Belgian administrative boundaries in QGIS.
                              -------------------
        begin                : 2017-09-19
        copyright            : (C) 2017 by Michel Stuyts
        email                : info@stuyts.xyz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
try:
    from qgis.PyQt.QtCore import *
except ImportError:
    from PyQt4.QtCore import *
try:
    from qgis.PyQt.QtGui import *
    from qgis.PyQt.QtWidgets import QAction
except ImportError:
    from PyQt4.QtGui import *
try:
    from .resources import *
except ImportError:
    from .resources3 import *
from .ZoomToBelgium_dialog import ZoomToBelgiumDialog
import os.path,unicodedata
from collections import OrderedDict
from qgis.core import *

class ZoomToBelgium:
    def tr(self, message):
        return QCoreApplication.translate('ZoomToBelgium', message)

    def __init__(self, iface):
        self.dlg = ZoomToBelgiumDialog()
        global contour_name
        global contour_xmax
        global contour_xmin
        global contour_ymax
        global contour_ymin
        
        """
        ID's:
            * 1-899: names of municipalities in original language
            * 900-999 names of provinces in original language
            * 1000-1899: names of municipalities in translated language
            * 1900-1999: names of provinces in translated language
            * 2000-2999: names of districts
            * 3000-3999: communities and regions
			* negative: Belgium (country)



        """
        contour_name=OrderedDict()
        contour_name[518]=u"Aalst"
        contour_name[458]=u"Aalter (tot 2018)"
        contour_name[594]=u"Aalter (vanaf 2019)"
        contour_name[1097]=u"Aarlen"
        contour_name[446]=u"Aarschot"
        contour_name[286]=u"Aartselaar"
        contour_name[1279]=u"Aat"
        contour_name[330]=u"Affligem"
        contour_name[34]=u"Aiseau-Presles"
        contour_name[484]=u"Alken"
        contour_name[1518]=u"Alost"
        contour_name[550]=u"Alveringem"
        contour_name[237]=u"Amay"
        contour_name[268]=u"Amblève"
        contour_name[1268]=u"Amel"
        contour_name[202]=u"Andenne"
        contour_name[127]=u"Anderlecht"
        contour_name[152]=u"Anderlues"
        contour_name[179]=u"Anhée"
        contour_name[172]=u"Ans"
        contour_name[52]=u"Anthisnes"
        contour_name[255]=u"Antoing"
        contour_name[2000]=u"Antwerpen (district)"
        contour_name[476]=u"Antwerpen (stad)"
        contour_name[900]=u"Antwerpen (provincie)"
        contour_name[1476]=u"Anvers (ville)"
        contour_name[1900]=u"Anvers (province)"
        contour_name[500]=u"Anzegem"
        contour_name[300]=u"Ardooie"
        contour_name[559]=u"Arendonk"
        contour_name[97]=u"Arlon"
        contour_name[566]=u"As"
        contour_name[475]=u"Asse"
        contour_name[405]=u"Assenede"
        contour_name[147]=u"Assesse"
        contour_name[279]=u"Ath"
        contour_name[50]=u"Attert"
        contour_name[141]=u"Aubange"
        contour_name[270]=u"Aubel"
        contour_name[1425]=u"Audenarde"
        contour_name[37]=u"Auderghem"
        contour_name[522]=u"Avelgem"
        contour_name[154]=u"Awans"
        contour_name[201]=u"Aywaille"
        contour_name[577]=u"Baarle-Hertog"
        contour_name[247]=u"Baelen"
        contour_name[1577]=u"Baerle-Duc"
        contour_name[485]=u"Balen"
        contour_name[169]=u"Bassenge"
        contour_name[1265]=u"Bastenaken"
        contour_name[265]=u"Bastogne"
        contour_name[26]=u"Beaumont"
        contour_name[224]=u"Beauraing"
        contour_name[96]=u"Beauvechain"
        contour_name[414]=u"Beernem"
        contour_name[507]=u"Beerse"
        contour_name[396]=u"Beersel"
        contour_name[528]=u"Begijnendijk"
        contour_name[341]=u"Bekkevoort"
        contour_name[-1]=u"België"
        contour_name[-2]=u"Belgique"
        contour_name[3028]=u"Belgique de l'Est (communauté)"
        contour_name[-3]=u"Belgien"
        contour_name[-4]=u"Belgium"
        contour_name[137]=u"Belœil"
        contour_name[2001]=u"Berchem (district)"
        contour_name[105]=u"Berchem-Sainte-Agathe"
        contour_name[2002]=u"Berendrecht-Zandvliet-Lillo (district)"
        contour_name[1264]=u"Bergen"
        contour_name[561]=u"Beringen"
        contour_name[386]=u"Berlaar"
        contour_name[543]=u"Berlare"
        contour_name[233]=u"Berloz"
        contour_name[119]=u"Bernissart"
        contour_name[579]=u"Bertem"
        contour_name[228]=u"Bertogne"
        contour_name[259]=u"Bertrix"
        contour_name[1096]=u"Bevekom"
        contour_name[504]=u"Bever"
        contour_name[565]=u"Beveren"
        contour_name[104]=u"Beyne-Heusay"
        contour_name[470]=u"Bierbeek"
        contour_name[1504]=u"Biévène"
        contour_name[139]=u"Bièvre"
        contour_name[392]=u"Bilzen"
        contour_name[281]=u"Binche"
        contour_name[1169]=u"Bitsingen"
        contour_name[497]=u"Blankenberge"
        contour_name[67]=u"Blégny"
        contour_name[574]=u"Bocholt"
        contour_name[372]=u"Boechout"
        contour_name[304]=u"Bonheiden"
        contour_name[416]=u"Boom"
        contour_name[582]=u"Boortmeerbeek"
        contour_name[2003]=u"Borgerhout"
        contour_name[447]=u"Borgloon"
        contour_name[1191]=u"Borgworm"
        contour_name[527]=u"Bornem"
        contour_name[373]=u"Borsbeek"
        contour_name[261]=u"Bouillon"
        contour_name[1495]=u"Bourg-Léopold"
        contour_name[62]=u"Boussu"
        contour_name[498]=u"Boutersem"
        contour_name[1903]=u"Brabant flamand"
        contour_name[906]=u"Brabant wallon"
        contour_name[84]=u"Braine-l'Alleud"
        contour_name[112]=u"Braine-le-Château"
        contour_name[41]=u"Braine-le-Comte"
        contour_name[223]=u"Braives"
        contour_name[531]=u"Brakel"
        contour_name[564]=u"Brasschaat"
        contour_name[459]=u"Brecht"
        contour_name[393]=u"Bredene"
        contour_name[346]=u"Bree"
        contour_name[213]=u"Brugelette"
        contour_name[1420]=u"Bruges"
        contour_name[420]=u"Brugge"
        contour_name[88]=u"Brunehaut"
        contour_name[1038]=u"Brussel (stad)"
        contour_name[3000]=u"Brussels Hoofdstedelijk Gewest"
        contour_name[3003]=u"Brussels-Capital Region"
        contour_name[38]=u"Bruxelles (ville)"
        contour_name[3002]=u"Bruxelles-Capitale (région)"
        contour_name[329]=u"Buggenhout"
        contour_name[244]=u"Bullange"
        contour_name[1244]=u"Büllingen"
        contour_name[94]=u"Burdinne"
        contour_name[46]=u"Burg-Reuland"
        contour_name[253]=u"Butgenbach"
        contour_name[1253]=u"Bütgenbach"
        contour_name[194]=u"Celles"
        contour_name[167]=u"Cerfontaine"
        contour_name[140]=u"Chapelle-lez-Herlaimont"
        contour_name[205]=u"Charleroi"
        contour_name[29]=u"Chastre"
        contour_name[219]=u"Châtelet"
        contour_name[39]=u"Chaudfontaine"
        contour_name[117]=u"Chaumont-Gistoux"
        contour_name[245]=u"Chièvres"
        contour_name[171]=u"Chimay"
        contour_name[187]=u"Chiny"
        contour_name[258]=u"Ciney"
        contour_name[212]=u"Clavier"
        contour_name[153]=u"Colfontaine"
        contour_name[142]=u"Comblain-au-Pont"
        contour_name[7]=u"Comines-Warneton"
        contour_name[3016]=u"Communauté flamande"
        contour_name[3021]=u"Communauté française de Belgique"
        contour_name[3027]=u"Communauté germanophone"
        contour_name[130]=u"Courcelles"
        contour_name[1419]=u"Courtrai"
        contour_name[236]=u"Court-Saint-Étienne"
        contour_name[178]=u"Couvin"
        contour_name[3]=u"Crisnée"
        contour_name[78]=u"Dalhem"
        contour_name[310]=u"Damme"
        contour_name[19]=u"Daverdisse"
        contour_name[536]=u"Deerlijk"
        contour_name[399]=u"DeHaan"
        contour_name[568]=u"Deinze (tot 2018)"
        contour_name[595]=u"Deinze (vanaf 2019)"
        contour_name[491]=u"Denderleeuw"
        contour_name[473]=u"Dendermonde"
        contour_name[370]=u"Dentergem"
        contour_name[584]=u"DePanne"
        contour_name[576]=u"DePinte"
        contour_name[532]=u"Dessel"
        contour_name[508]=u"Destelbergen"
        contour_name[2004]=u"Deurne (district)"
        contour_name[3029]=u"Deutschsprachige Gemeinschaft Belgiens"
        contour_name[398]=u"Diepenbeek"
        contour_name[423]=u"Diest"
        contour_name[466]=u"Diksmuide"
        contour_name[375]=u"Dilbeek"
        contour_name[461]=u"Dilsen-Stokkem"
        contour_name[115]=u"Dinant"
        contour_name[101]=u"Dison"
        contour_name[1466]=u"Dixmude"
        contour_name[240]=u"Doische"
        contour_name[4]=u"Donceel"
        contour_name[1068]=u"Doornik"
        contour_name[76]=u"Dour"
        contour_name[364]=u"Drogenbos"
        contour_name[415]=u"Duffel"
        contour_name[3025]=u"Duitstalige Gemeenschap"
        contour_name[121]=u"Durbuy"
        contour_name[3032]=u"Eastern Belgium (community)"
        contour_name[189]=u"Écaussinnes"
        contour_name[514]=u"Edegem"
        contour_name[1200]=u"Edingen"
        contour_name[450]=u"Eeklo"
        contour_name[155]=u"Éghezée"
        contour_name[1084]=u"Eigenbrakel"
        contour_name[2005]=u"Ekeren"
        contour_name[166]=u"Ellezelles"
        contour_name[1023]=u"Elsene"
        contour_name[1166]=u"Elzele"
        contour_name[200]=u"Enghien"
        contour_name[185]=u"Engis"
        contour_name[175]=u"Érezée"
        contour_name[378]=u"Erpe-Mere"
        contour_name[103]=u"Erquelinnes"
        contour_name[251]=u"Esneux"
        contour_name[1452]=u"Espierres-Helchin"
        contour_name[517]=u"Essen"
        contour_name[192]=u"Estaimpuis"
        contour_name[246]=u"Estinnes"
        contour_name[57]=u"Étalle"
        contour_name[9]=u"Etterbeek"
        contour_name[106]=u"Eupen"
        contour_name[263]=u"Evere"
        contour_name[471]=u"Evergem"
        contour_name[15]=u"Faimes"
        contour_name[32]=u"Farciennes"
        contour_name[138]=u"Fauvillers"
        contour_name[3024]=u"Federatie Wallonië-Brussel"
        contour_name[3022]=u"Fédération Wallonie-Bruxelles"
        contour_name[173]=u"Fernelmont"
        contour_name[226]=u"Ferrières"
        contour_name[197]=u"Fexhe-le-Haut-Clocher"
        contour_name[3018]=u"Flanders (community)"
        contour_name[3009]=u"Flanders (region)"
        contour_name[3017]=u"Flandre (communauté)"
        contour_name[3007]=u"Flandre (région)"
        contour_name[1901]=u"Flandre-Occidentale"
        contour_name[1902]=u"Flandre-Orientale"
        contour_name[218]=u"Flémalle"
        contour_name[3019]=u"Flemish Community"
        contour_name[3008]=u"Flemish Region"
        contour_name[229]=u"Fléron"
        contour_name[196]=u"Fleurus"
        contour_name[176]=u"Flobecq"
        contour_name[60]=u"Floreffe"
        contour_name[146]=u"Florennes"
        contour_name[2]=u"Florenville"
        contour_name[160]=u"Fontaine-lÉvêque"
        contour_name[208]=u"Forest"
        contour_name[58]=u"Fosses-la-Ville"
        contour_name[1290]=u"Fourons"
        contour_name[136]=u"Frameries"
        contour_name[3020]=u"Franse Gemeenschap"
        contour_name[234]=u"Frasnes-lez-Anvaing"
        contour_name[3023]=u"French Community"
        contour_name[48]=u"Froidchapelle"
        contour_name[1356]=u"Furnes"
        contour_name[546]=u"Galmaarden"
        contour_name[1546]=u"Gammerages"
        contour_name[1319]=u"Gand"
        contour_name[100]=u"Ganshoren"
        contour_name[477]=u"Gavere"
        contour_name[61]=u"Gedinne"
        contour_name[525]=u"Geel"
        contour_name[260]=u"Geer"
        contour_name[530]=u"Geetbets"
        contour_name[1095]=u"Geldenaken"
        contour_name[267]=u"Gembloux"
        contour_name[51]=u"Genappe"
        contour_name[1051]=u"Genepiën"
        contour_name[581]=u"Genk"
        contour_name[319]=u"Gent"
        contour_name[520]=u"Geraardsbergen"
        contour_name[3031]=u"German-speaking Community of Belgium"
        contour_name[145]=u"Gerpinnes"
        contour_name[180]=u"Gesves"
        contour_name[555]=u"Gingelom"
        contour_name[544]=u"Gistel"
        contour_name[580]=u"Glabbeek"
        contour_name[513]=u"Gooik"
        contour_name[275]=u"Gouvy"
        contour_name[177]=u"Grâce-Hollogne"
        contour_name[1520]=u"Grammont"
        contour_name[1090]=u"Graven"
        contour_name[90]=u"Grez-Doiceau"
        contour_name[439]=u"Grimbergen"
        contour_name[429]=u"Grobbendonk"
        contour_name[361]=u"Haacht"
        contour_name[552]=u"Haaltert"
        contour_name[98]=u"Habay"
        contour_name[905]=u"Hainaut"
        contour_name[1482]=u"Hal"
        contour_name[404]=u"Halen"
        contour_name[482]=u"Halle"
        contour_name[456]=u"Ham"
        contour_name[354]=u"Hamme"
        contour_name[81]=u"Hamoir"
        contour_name[99]=u"Hamois"
        contour_name[334]=u"Hamont-Achel"
        contour_name[66]=u"Ham-sur-Heure-Nalinnes"
        contour_name[1045]=u"Hannuit"
        contour_name[45]=u"Hannut"
        contour_name[326]=u"Harelbeke"
        contour_name[578]=u"Hasselt"
        contour_name[280]=u"Hastière"
        contour_name[150]=u"Havelange"
        contour_name[349]=u"Hechtel-Eksel"
        contour_name[407]=u"Heers"
        contour_name[292]=u"Heist-op-den-Berg"
        contour_name[204]=u"Hélécine"
        contour_name[521]=u"Hemiksem"
        contour_name[1905]=u"Henegouwen"
        contour_name[221]=u"Hensies"
        contour_name[250]=u"Herbeumont"
        contour_name[1509]=u"Herck-la-Ville"
        contour_name[395]=u"Herent"
        contour_name[309]=u"Herentals"
        contour_name[554]=u"Herenthout"
        contour_name[509]=u"Herk-de-Stad"
        contour_name[465]=u"Herne"
        contour_name[126]=u"Héron"
        contour_name[534]=u"Herselt"
        contour_name[12]=u"Herstal"
        contour_name[318]=u"Herstappe"
        contour_name[129]=u"Herve"
        contour_name[448]=u"Herzele"
        contour_name[430]=u"Heusden-Zolder"
        contour_name[589]=u"Heuvelland"
        contour_name[2006]=u"Hoboken"
        contour_name[410]=u"Hoegaarden"
        contour_name[1044]=u"Hoei"
        contour_name[492]=u"Hoeilaart"
        contour_name[585]=u"Hoeselt"
        contour_name[481]=u"Holsbeek"
        contour_name[203]=u"Honnelles"
        contour_name[359]=u"Hooglede"
        contour_name[454]=u"Hoogstraten"
        contour_name[486]=u"Horebeke"
        contour_name[91]=u"Hotton"
        contour_name[230]=u"Houffalize"
        contour_name[387]=u"Houthalen-Helchteren"
        contour_name[436]=u"Houthulst"
        contour_name[93]=u"Houyet"
        contour_name[541]=u"Hove"
        contour_name[293]=u"Huldenberg"
        contour_name[512]=u"Hulshout"
        contour_name[44]=u"Huy"
        contour_name[307]=u"Ichtegem"
        contour_name[553]=u"Ieper"
        contour_name[225]=u"Incourt"
        contour_name[406]=u"Ingelmunster"
        contour_name[1108]=u"Itter"
        contour_name[108]=u"Ittre"
        contour_name[23]=u"Ixelles"
        contour_name[350]=u"Izegem"
        contour_name[353]=u"Jabbeke"
        contour_name[235]=u"Jalhay"
        contour_name[113]=u"Jemeppe-sur-Sambre"
        contour_name[59]=u"Jette"
        contour_name[95]=u"Jodoigne"
        contour_name[27]=u"Juprelle"
        contour_name[1156]=u"Jurbeke"
        contour_name[156]=u"Jurbise"
        contour_name[472]=u"Kalmthout"
        contour_name[426]=u"Kampenhout"
        contour_name[391]=u"Kapellen"
        contour_name[299]=u"Kapelle-op-den-Bos"
        contour_name[413]=u"Kaprijke"
        contour_name[1112]=u"Kasteelbrakel"
        contour_name[337]=u"Kasterlee"
        contour_name[306]=u"Keerbergen"
        contour_name[1198]=u"Kelmis"
        contour_name[379]=u"Kinrooi"
        contour_name[340]=u"Kluisbergen"
        contour_name[526]=u"Knesselare"
        contour_name[291]=u"Knokke-Heist"
        contour_name[422]=u"Koekelare"
        contour_name[77]=u"Koekelberg"
        contour_name[288]=u"Koksijde"
        contour_name[1007]=u"Komen-Waasten"
        contour_name[376]=u"Kontich"
        contour_name[516]=u"Kortemark"
        contour_name[440]=u"Kortenaken"
        contour_name[384]=u"Kortenberg"
        contour_name[462]=u"Kortessem"
        contour_name[419]=u"Kortrijk"
        contour_name[367]=u"Kraainem"
        contour_name[463]=u"Kruibeke"
        contour_name[596]=u"Kruisem"
        contour_name[533]=u"Kruishoutem"
        contour_name[432]=u"Kuurne"
        contour_name[1584]=u"La Panne"
        contour_name[355]=u"Laakdal"
        contour_name[294]=u"Laarne"
        contour_name[232]=u"LaBruyère"
        contour_name[198]=u"LaCalamine"
        contour_name[271]=u"LaHulpe"
        contour_name[10]=u"LaLouvière"
        contour_name[315]=u"Lanaken"
        contour_name[400]=u"Landen"
        contour_name[402]=u"Langemark-Poelkapelle"
        contour_name[71]=u"LaRoche-en-Ardenne"
        contour_name[20]=u"Lasne"
        contour_name[1478]=u"Léau"
        contour_name[502]=u"Lebbeke"
        contour_name[434]=u"Lede"
        contour_name[408]=u"Ledegem"
        contour_name[13]=u"L'Église"
        contour_name[389]=u"Lendelede"
        contour_name[496]=u"Lennik"
        contour_name[114]=u"Lens"
        contour_name[495]=u"Leopoldsburg"
        contour_name[278]=u"LeRoeulx"
        contour_name[277]=u"LesBonsVillers"
        contour_name[1252]=u"Lessen"
        contour_name[252]=u"Lessines"
        contour_name[338]=u"Leuven"
        contour_name[162]=u"Leuze-en-Hainaut"
        contour_name[55]=u"Libin"
        contour_name[128]=u"Libramont-Chevigny"
        contour_name[519]=u"Lichtervelde"
        contour_name[545]=u"Liedekerke"
        contour_name[907]=u"Liège (province)"
        contour_name[92]=u"Liège (ville)"
        contour_name[325]=u"Lier"
        contour_name[588]=u"Lierde"
        contour_name[54]=u"Lierneux"
        contour_name[1325]=u"Lierre"
        contour_name[593]=u"Lievegem"
        contour_name[1085]=u"Lijsem"
        contour_name[332]=u"Lille"
        contour_name[1904]=u"Limbourg (province)"
        contour_name[17]=u"Limbourg (ville)"
        contour_name[904]=u"Limburg (provincie)"
        contour_name[1017]=u"Limburg (stad)"
        contour_name[85]=u"Lincent"
        contour_name[499]=u"Linkebeek"
        contour_name[562]=u"Lint"
        contour_name[302]=u"Linter"
        contour_name[124]=u"Lobbes"
        contour_name[303]=u"Lochristi"
        contour_name[488]=u"Lokeren"
        contour_name[358]=u"Lommel"
        contour_name[305]=u"Londerzeel"
        contour_name[64]=u"Lontzen"
        contour_name[1447]=u"Looz"
        contour_name[314]=u"Lo-Reninge"
        contour_name[1338]=u"Louvain"
        contour_name[313]=u"Lovendegem"
        contour_name[510]=u"Lubbeek"
        contour_name[1907]=u"Luik (provincie)"
        contour_name[1092]=u"Luik (stad)"
        contour_name[397]=u"Lummen"
        contour_name[909]=u"Luxembourg"
        contour_name[1909]=u"Luxemburg"
        contour_name[345]=u"Maarkedal"
        contour_name[342]=u"Maaseik"
        contour_name[417]=u"Maasmechelen"
        contour_name[501]=u"Machelen"
        contour_name[529]=u"Maldegem"
        contour_name[1469]=u"Malines"
        contour_name[282]=u"Malle"
        contour_name[125]=u"Malmedy"
        contour_name[33]=u"Manage"
        contour_name[111]=u"Manhay"
        contour_name[199]=u"Marche-en-Famenne"
        contour_name[144]=u"Marchin"
        contour_name[87]=u"Martelange"
        contour_name[469]=u"Mechelen"
        contour_name[487]=u"Meerhout"
        contour_name[377]=u"Meeuwen-Gruitrode"
        contour_name[298]=u"Meise"
        contour_name[181]=u"Meix-devant-Virton"
        contour_name[323]=u"Melle"
        contour_name[312]=u"Menen"
        contour_name[1312]=u"Menin"
        contour_name[207]=u"Merbes-le-Château"
        contour_name[418]=u"Merchtem"
        contour_name[333]=u"Merelbeke"
        contour_name[2007]=u"Merksem"
        contour_name[571]=u"Merksplas"
        contour_name[549]=u"Mesen"
        contour_name[266]=u"Messancy"
        contour_name[1549]=u"Messines"
        contour_name[174]=u"Mettet"
        contour_name[321]=u"Meulebeke"
        contour_name[569]=u"Middelkerke"
        contour_name[109]=u"Modave"
        contour_name[557]=u"Moerbeke"
        contour_name[1001]=u"Moeskroen"
        contour_name[348]=u"Mol"
        contour_name[231]=u"Molenbeek-Saint-Jean"
        contour_name[269]=u"Momignies"
        contour_name[264]=u"Mons"
        contour_name[1451]=u"Montaigu-Zichem"
        contour_name[40]=u"Mont-de-l'Enclus"
        contour_name[69]=u"Montigny-le-Tilleul"
        contour_name[35]=u"Mont-Saint-Guibert"
        contour_name[587]=u"Moorslede"
        contour_name[74]=u"Morlanwelz"
        contour_name[343]=u"Mortsel"
        contour_name[1]=u"Mouscron"
        contour_name[135]=u"Musson"
        contour_name[1908]=u"Namen (provincie)"
        contour_name[1157]=u"Namen (stad)"
        contour_name[908]=u"Namur (province)"
        contour_name[157]=u"Namur (ville)"
        contour_name[238]=u"Nandrin"
        contour_name[73]=u"Nassogne"
        contour_name[556]=u"Nazareth"
        contour_name[374]=u"Neerpelt"
        contour_name[28]=u"Neufchâteau"
        contour_name[254]=u"Neupré"
        contour_name[494]=u"Nevele"
        contour_name[573]=u"Niel"
        contour_name[1382]=u"Nieuport"
        contour_name[563]=u"Nieuwerkerken"
        contour_name[382]=u"Nieuwpoort"
        contour_name[371]=u"Nijlen"
        contour_name[1239]=u"Nijvel"
        contour_name[467]=u"Ninove"
        contour_name[239]=u"Nivelles"
        contour_name[1161]=u"Oerle"
        contour_name[164]=u"Ohey"
        contour_name[523]=u"Olen"
        contour_name[30]=u"Olne"
        contour_name[241]=u"Onhaye"
        contour_name[3026]=u"Oost-België (gemeenschap)"
        contour_name[902]=u"Oost-Vlaanderen"
        contour_name[411]=u"Oostende"
        contour_name[368]=u"Oosterzele"
        contour_name[363]=u"Oostkamp"
        contour_name[317]=u"Oostrozebeke"
        contour_name[409]=u"Opglabbeek"
        contour_name[394]=u"Opwijk"
        contour_name[1182]=u"Opzullik"
        contour_name[161]=u"Oreye"
        contour_name[132]=u"Orp-Jauche"
        contour_name[3030]=u"Ostbelgien (gemeinschaft)"
        contour_name[1411]=u"Ostende"
        contour_name[86]=u"Ottignies-Louvain-la-Neuve"
        contour_name[425]=u"Oudenaarde"
        contour_name[449]=u"Oudenburg"
        contour_name[1037]=u"Oudergem"
        contour_name[301]=u"Oud-Heverlee"
        contour_name[490]=u"Oud-Turnhout"
        contour_name[591]=u"Oudsbergen"
        contour_name[222]=u"Ouffet"
        contour_name[31]=u"Oupeye"
        contour_name[547]=u"Overijse"
        contour_name[586]=u"Overpelt"
        contour_name[14]=u"Paliseul"
        contour_name[16]=u"Pecq"
        contour_name[560]=u"Peer"
        contour_name[590]=u"Pelt"
        contour_name[443]=u"Pepingen"
        contour_name[42]=u"Pepinster"
        contour_name[110]=u"Péruwelz"
        contour_name[272]=u"Perwez"
        contour_name[1272]=u"Perwijs"
        contour_name[53]=u"Philippeville"
        contour_name[572]=u"Pittem"
        contour_name[80]=u"Plombières"
        contour_name[215]=u"Pont-à-Celles"
        contour_name[295]=u"Poperinge"
        contour_name[209]=u"Profondeville"
        contour_name[457]=u"Putte"
        contour_name[424]=u"Puurs"
        contour_name[592]=u"Puurs-Sint-Amands"
        contour_name[165]=u"Quaregnon"
        contour_name[21]=u"Quévy"
        contour_name[5]=u"Quiévrain"
        contour_name[148]=u"Raeren"
        contour_name[131]=u"Ramillies"
        contour_name[331]=u"Ranst"
        contour_name[362]=u"Ravels"
        contour_name[276]=u"Rebecq"
        contour_name[3001]=u"Région de Bruxelles-Capitale"
        contour_name[3006]=u"Région flamande"
        contour_name[3011]=u"Région wallonne"
        contour_name[149]=u"Remicourt"
        contour_name[1357]=u"Renaix"
        contour_name[72]=u"Rendeux"
        contour_name[383]=u"Retie"
        contour_name[1511]=u"Rhode-Saint-Genèse"
        contour_name[328]=u"Riemst"
        contour_name[505]=u"Rijkevorsel"
        contour_name[8]=u"Rixensart"
        contour_name[227]=u"Rochefort"
        contour_name[464]=u"Roeselare"
        contour_name[357]=u"Ronse"
        contour_name[401]=u"Roosdaal"
        contour_name[431]=u"Rotselaar"
        contour_name[1464]=u"Roulers"
        contour_name[47]=u"Rouvroy"
        contour_name[421]=u"Ruiselede"
        contour_name[11]=u"Rumes"
        contour_name[360]=u"Rumst"
        contour_name[1041]=u"'s Gravenbrakel"
        contour_name[184]=u"Sainte-Ode"
        contour_name[123]=u"Saint-Georges-sur-Meuse"
        contour_name[6]=u"Saint-Ghislain"
        contour_name[82]=u"Saint-Gilles"
        contour_name[134]=u"Saint-Hubert"
        contour_name[120]=u"Saint-Josse-ten-Noode"
        contour_name[158]=u"Saint-Léger"
        contour_name[49]=u"Saint-Nicolas"
        contour_name[1381]=u"Saint-Trond"
        contour_name[249]=u"Saint-Vith"
        contour_name[274]=u"Sambreville"
        contour_name[1249]=u"Sankt Vith"
        contour_name[1122]=u"Schaarbeek"
        contour_name[122]=u"Schaerbeek"
        contour_name[583]=u"Schelle"
        contour_name[451]=u"Scherpenheuvel-Zichem"
        contour_name[365]=u"Schilde"
        contour_name[352]=u"Schoten"
        contour_name[217]=u"Seneffe"
        contour_name[163]=u"Seraing"
        contour_name[182]=u"Silly"
        contour_name[1105]=u"Sint-Agatha-Berchem"
        contour_name[347]=u"Sint-Amands"
        contour_name[511]=u"Sint-Genesius-Rode"
        contour_name[1082]=u"Sint-Gillis"
        contour_name[369]=u"Sint-Gillis-Waas"
        contour_name[1231]=u"Sint-Jans-Molenbeek"
        contour_name[1120]=u"Sint-Joost-ten-Node"
        contour_name[283]=u"Sint-Katelijne-Waver"
        contour_name[1102]=u"Sint-Lambrechts-Woluwe"
        contour_name[322]=u"Sint-Laureins"
        contour_name[336]=u"Sint-Lievens-Houtem"
        contour_name[483]=u"Sint-Martens-Latem"
        contour_name[537]=u"Sint-Niklaas"
        contour_name[524]=u"Sint-Pieters-Leeuw"
        contour_name[1143]=u"Sint-Pieters-Woluwe"
        contour_name[381]=u"Sint-Truiden"
        contour_name[43]=u"Sivry-Rance"
        contour_name[116]=u"Soignies"
        contour_name[168]=u"Sombreffe"
        contour_name[151]=u"Somme-Leuze"
        contour_name[63]=u"Soumagne"
        contour_name[220]=u"Spa"
        contour_name[452]=u"Spiere-Helkijn"
        contour_name[75]=u"Sprimont"
        contour_name[455]=u"Stabroek"
        contour_name[427]=u"Staden"
        contour_name[206]=u"Stavelot"
        contour_name[344]=u"Steenokkerzeel"
        contour_name[412]=u"Stekene"
        contour_name[211]=u"Stoumont"
        contour_name[1460]=u"Tamise"
        contour_name[183]=u"Tellin"
        contour_name[460]=u"Temse"
        contour_name[133]=u"Tenneville"
        contour_name[1271]=u"Terhulpen"
        contour_name[1473]=u"Termonde"
        contour_name[335]=u"Ternat"
        contour_name[570]=u"Tervuren"
        contour_name[575]=u"Tessenderlo"
        contour_name[170]=u"Theux"
        contour_name[190]=u"Thimister-Clermont"
        contour_name[216]=u"Thuin"
        contour_name[403]=u"Tielt"
        contour_name[437]=u"Tielt-Winge"
        contour_name[287]=u"Tienen"
        contour_name[186]=u"Tinlot"
        contour_name[248]=u"Tintigny"
        contour_name[1287]=u"Tirlemont"
        contour_name[296]=u"Tongeren"
        contour_name[1296]=u"Tongres"
        contour_name[435]=u"Torhout"
        contour_name[68]=u"Tournai"
        contour_name[297]=u"Tremelo"
        contour_name[159]=u"Trois-Ponts"
        contour_name[79]=u"Trooz"
        contour_name[1036]=u"Tubeke"
        contour_name[36]=u"Tubize"
        contour_name[444]=u"Turnhout"
        contour_name[256]=u"Uccle"
        contour_name[1256]=u"Ukkel"
        contour_name[243]=u"Vaux-sur-Sûre"
        contour_name[210]=u"Verlaine"
        contour_name[273]=u"Verviers"
        contour_name[356]=u"Veurne"
        contour_name[242]=u"Vielsalm"
        contour_name[22]=u"Villers-la-Ville"
        contour_name[262]=u"Villers-le-Bouillet"
        contour_name[320]=u"Vilvoorde"
        contour_name[1320]=u"Vilvorde"
        contour_name[25]=u"Viroinval"
        contour_name[193]=u"Virton"
        contour_name[257]=u"Visé"
        contour_name[3004]=u"Vlaams Gewest"
        contour_name[903]=u"Vlaams-Brabant"
        contour_name[3014]=u"Vlaamse Gemeenschap"
        contour_name[3015]=u"Vlaanderen (gemeenschap)"
        contour_name[3005]=u"Vlaanderen (gewest)"
        contour_name[540]=u"Vleteren"
        contour_name[1176]=u"Vloesberg"
        contour_name[290]=u"Voeren"
        contour_name[388]=u"Vorselaar"
        contour_name[1208]=u"Vorst"
        contour_name[442]=u"Vosselaar"
        contour_name[188]=u"Vresse-sur-Semois"
        contour_name[3010]=u"Waals Gewest"
        contour_name[1906]=u"Waals-Brabant"
        contour_name[441]=u"Waarschoot"
        contour_name[493]=u"Waasmunster"
        contour_name[308]=u"Wachtebeke"
        contour_name[195]=u"Waimes"
        contour_name[89]=u"Walcourt"
        contour_name[56]=u"Walhain"
        contour_name[3013]=u"Wallonia (region)"
        contour_name[3012]=u"Wallonie (région)"
        contour_name[83]=u"Wanze"
        contour_name[438]=u"Waregem"
        contour_name[191]=u"Waremme"
        contour_name[118]=u"Wasseiges"
        contour_name[107]=u"Waterloo"
        contour_name[1214]=u"Watermaal-Bosvoorde"
        contour_name[214]=u"Watermael-Boitsfort"
        contour_name[1065]=u"Waver"
        contour_name[65]=u"Wavre"
        contour_name[1195]=u"Weismes"
        contour_name[24]=u"Welkenraedt"
        contour_name[285]=u"Wellen"
        contour_name[18]=u"Wellin"
        contour_name[535]=u"Wemmel"
        contour_name[366]=u"Wervik"
        contour_name[901]=u"West-Vlaanderen"
        contour_name[316]=u"Westerlo"
        contour_name[433]=u"Wetteren"
        contour_name[339]=u"Wevelgem"
        contour_name[390]=u"Wezembeek-Oppem"
        contour_name[1257]=u"Wezet"
        contour_name[506]=u"Wichelen"
        contour_name[503]=u"Wielsbeke"
        contour_name[567]=u"Wijnegem"
        contour_name[445]=u"Willebroek"
        contour_name[2008]=u"Wilrijk"
        contour_name[311]=u"Wingene"
        contour_name[102]=u"Woluwe-Saint-Lambert"
        contour_name[143]=u"Woluwe-Saint-Pierre"
        contour_name[479]=u"Wommelgem"
        contour_name[474]=u"Wortegem-Petegem"
        contour_name[515]=u"Wuustwezel"
        contour_name[1553]=u"Ypres"
        contour_name[70]=u"Yvoir"
        contour_name[468]=u"Zandhoven"
        contour_name[489]=u"Zaventem"
        contour_name[428]=u"Zedelgem"
        contour_name[385]=u"Zele"
        contour_name[538]=u"Zelzate"
        contour_name[551]=u"Zemst"
        contour_name[284]=u"Zingem"
        contour_name[1116]=u"Zinnik"
        contour_name[380]=u"Zoersel"
        contour_name[453]=u"Zomergem"
        contour_name[351]=u"Zonhoven"
        contour_name[327]=u"Zonnebeke"
        contour_name[289]=u"Zottegem"
        contour_name[478]=u"Zoutleeuw"
        contour_name[542]=u"Zuienkerke"
        contour_name[539]=u"Zulte"
        contour_name[558]=u"Zutendaal"
        contour_name[548]=u"Zwalm"
        contour_name[324]=u"Zwevegem"
        contour_name[480]=u"Zwijndrecht"
        contour_xmax={1: 76601, 2: 226282, 3: 225058, 4: 221265, 5: 105550, 6: 115296, 7: 55567, 8: 163987, 9: 153062, 10: 140143, 11: 78848, 12: 241094, 13: 246199, 14: 209848, 15: 214901, 16: 81518, 17: 264248, 18: 207969, 19: 206128, 20: 161143, 21: 127751, 22: 165731, 23: 152459, 24: 265367, 25: 175264, 26: 148328, 27: 236878, 28: 233443, 29: 171585, 30: 249347, 31: 243401, 32: 164989, 33: 143815, 34: 167652, 35: 171040, 36: 141374, 37: 158005, 38: 154807, 39: 242893, 40: 92057, 41: 141861, 42: 255344, 43: 145395, 44: 217731, 45: 206096, 46: 280261, 47: 234293, 48: 152329, 49: 233530, 50: 255480, 51: 162240, 52: 234085, 53: 175767, 54: 257819, 55: 219022, 56: 176707, 57: 246103, 58: 180608, 59: 148021, 60: 182759, 61: 195972, 62: 112641, 63: 249110, 64: 270436, 65: 169638, 66: 157688, 67: 249398, 68: 93935, 69: 153488, 70: 196710, 71: 248217, 72: 238741, 73: 228445, 74: 143898, 75: 248869, 76: 113268, 77: 147820, 78: 252419, 79: 249497, 80: 266580, 81: 239139, 82: 149268, 83: 213561, 84: 153057, 85: 198880, 86: 169756, 87: 249944, 88: 86333, 89: 162585, 90: 176929, 91: 230901, 92: 242352, 93: 203638, 94: 206522, 95: 190948, 96: 183133, 97: 261321, 98: 246838, 99: 211957, 100: 147004, 101: 259375, 102: 156551, 103: 139406, 104: 243741, 105: 146166, 106: 284786, 107: 155118, 108: 146851, 109: 219943, 110: 97550, 111: 248266, 112: 147502, 113: 175849, 114: 122406, 115: 198446, 116: 133123, 117: 178342, 118: 199059, 119: 106353, 120: 151092, 121: 240218, 122: 153117, 123: 222626, 124: 145405, 125: 274092, 126: 206972, 127: 147998, 128: 235017, 129: 255561, 130: 152578, 131: 190489, 132: 195811, 133: 237892, 134: 228221, 135: 248845, 136: 120183, 137: 106885, 138: 251717, 139: 203919, 140: 147046, 141: 258791, 142: 239925, 143: 157613, 144: 215032, 145: 166040, 146: 179906, 147: 202086, 148: 282068, 149: 222618, 150: 220798, 151: 223549, 152: 144677, 153: 114711, 154: 229354, 155: 193940, 156: 123608, 157: 193657, 158: 249293, 159: 266270, 160: 149125, 161: 222384, 162: 103584, 163: 234768, 164: 211704, 165: 115637, 166: 107481, 167: 160697, 168: 169584, 169: 242923, 170: 259999, 171: 155509, 172: 233649, 173: 198588, 174: 178384, 175: 241591, 176: 108197, 177: 230906, 178: 166954, 179: 187623, 180: 205204, 181: 234168, 182: 128641, 183: 217853, 184: 240360, 185: 225947, 186: 226396, 187: 230359, 188: 194742, 189: 140145, 190: 259552, 191: 216712, 192: 77262, 193: 242251, 194: 90931, 195: 282152, 196: 166467, 197: 225770, 198: 269592, 199: 228918, 200: 131972, 201: 251176, 202: 206451, 203: 112340, 204: 195992, 205: 159864, 206: 268208, 207: 142787, 208: 148916, 209: 189140, 210: 219361, 211: 260925, 212: 225366, 213: 117655, 214: 157154, 215: 156196, 216: 151872, 217: 147704, 218: 229308, 219: 163806, 220: 260952, 221: 108281, 222: 232959, 223: 209572, 224: 200918, 225: 184145, 226: 245311, 227: 215429, 228: 247609, 229: 245357, 230: 259179, 231: 148574, 232: 187566, 233: 211231, 234: 104929, 235: 270851, 236: 167147, 237: 219526, 238: 228582, 239: 152643, 240: 180770, 241: 187416, 242: 267515, 243: 246499, 244: 295152, 245: 112363, 246: 136973, 247: 275508, 248: 235725, 249: 288169, 250: 223991, 251: 238432, 252: 117850, 253: 287194, 254: 234073, 255: 90454, 256: 153124, 257: 245725, 258: 213709, 259: 221882, 260: 210656, 261: 209131, 262: 215758, 263: 154069, 264: 129838, 265: 257521, 266: 259200, 267: 181045, 268: 286544, 269: 146116, 270: 259802, 271: 160172, 272: 184182, 273: 260255, 274: 171494, 275: 268902, 276: 136727, 277: 160239, 278: 137049, 279: 117771, 280: 187914, 281: 141723, 282: 178461, 283: 166834, 284: 102030, 285: 220677, 286: 152800, 287: 195888, 288: 37168, 289: 114700, 290: 258879, 291: 81470, 292: 181483, 293: 170235, 294: 119807, 295: 39747, 296: 233542, 297: 178470, 298: 148935, 299: 151518, 300: 71004, 301: 176617, 302: 201089, 303: 118781, 304: 168665, 305: 147525, 306: 173915, 307: 59718, 308: 118785, 309: 185922, 310: 82293, 311: 78585, 312: 68997, 313: 100842, 314: 43726, 315: 245333, 316: 190719, 317: 80243, 318: 225378, 319: 113655, 320: 158319, 321: 78608, 322: 102424, 323: 112609, 324: 85779, 325: 169207, 326: 78181, 327: 58514, 328: 242996, 329: 141051, 330: 134643, 331: 169228, 332: 187580, 333: 109423, 334: 233243, 335: 138614, 336: 119715, 337: 196313, 338: 178265, 339: 69303, 340: 94908, 341: 197560, 342: 252623, 343: 158062, 344: 161636, 345: 103687, 346: 244480, 347: 143434, 348: 210915, 349: 224752, 350: 70904, 351: 227014, 352: 162853, 353: 65668, 354: 138110, 355: 201253, 356: 38425, 357: 101242, 358: 223199, 359: 64483, 360: 157148, 361: 172542, 362: 201170, 363: 75298, 364: 146968, 365: 168444, 366: 61085, 367: 158753, 368: 113635, 369: 135883, 370: 86259, 371: 174602, 372: 163733, 373: 159809, 374: 231060, 375: 144450, 376: 158247, 377: 240885, 378: 124879, 379: 254043, 380: 176156, 381: 214744, 382: 41891, 383: 205163, 384: 167290, 385: 130639, 386: 173240, 387: 230908, 388: 182640, 389: 72871, 390: 160469, 391: 160467, 392: 238469, 393: 55252, 394: 139925, 395: 173467, 396: 149101, 397: 212052, 398: 228070, 399: 62592, 400: 203134, 401: 134636, 402: 53049, 403: 85692, 404: 204140, 405: 109983, 406: 74676, 407: 222907, 408: 68354, 409: 238401, 410: 191295, 411: 54664, 412: 130765, 413: 100782, 414: 83004, 415: 164464, 416: 152634, 417: 248189, 418: 145293, 419: 78720, 420: 76038, 421: 85296, 422: 55086, 423: 205485, 424: 149450, 425: 102758, 426: 167577, 427: 60025, 428: 69304, 429: 179673, 430: 218978, 431: 180542, 432: 74857, 433: 118735, 434: 125798, 435: 65123, 436: 52046, 437: 190993, 438: 87227, 439: 154051, 440: 200876, 441: 99547, 442: 188045, 443: 138258, 444: 192985, 445: 153977, 446: 189826, 447: 223238, 448: 120463, 449: 58398, 450: 96884, 451: 195880, 452: 81927, 453: 97044, 454: 183545, 455: 153371, 456: 210313, 457: 172461, 458: 90937, 459: 174718, 460: 144193, 461: 250414, 462: 226144, 463: 147312, 464: 66292, 465: 132191, 466: 50657, 467: 129332, 468: 176109, 469: 162656, 470: 181769, 471: 110166, 472: 161593, 473: 137742, 474: 95089, 475: 145243, 476: 159023, 477: 106885, 478: 205227, 479: 163526, 480: 149196, 481: 185365, 482: 145986, 483: 99922, 484: 219210, 485: 212518, 486: 104028, 487: 203318, 488: 126546, 489: 161806, 490: 198060, 491: 130352, 492: 160072, 493: 134118, 494: 97049, 495: 215291, 496: 138946, 497: 66924, 498: 187374, 499: 149912, 500: 89836, 501: 157104, 502: 135975, 503: 84269, 504: 122132, 505: 181961, 506: 124551, 507: 186738, 508: 113252, 509: 210567, 510: 188170, 511: 153890, 512: 185067, 513: 134739, 514: 156641, 515: 174243, 516: 58904, 517: 162476, 518: 135570, 519: 66847, 520: 124276, 521: 149276, 522: 90430, 523: 189031, 524: 146101, 525: 199557, 526: 90947, 527: 147164, 528: 181110, 529: 92377, 530: 207631, 531: 111287, 532: 207030, 533: 95126, 534: 192084, 535: 147915, 536: 81370, 537: 139720, 538: 114180, 539: 90907, 540: 40398, 541: 159911, 542: 67990, 543: 127060, 544: 54275, 545: 132939, 546: 127648, 547: 167260, 548: 107661, 549: 47965, 550: 37868, 551: 161230, 552: 126996, 553: 51929, 554: 180913, 555: 211766, 556: 101505, 557: 124113, 558: 237575, 559: 203826, 560: 232479, 561: 218359, 562: 161110, 563: 212959, 564: 163253, 565: 146724, 566: 239417, 567: 162875, 568: 96838, 569: 48927, 570: 165350, 571: 189314, 572: 75796, 573: 149611, 574: 240244, 575: 207123, 576: 103816, 577: 190598, 578: 223529, 579: 170506, 580: 193985, 581: 236078, 582: 167146, 583: 150550, 584: 28482, 585: 230648, 586: 225077, 587: 63128, 588: 115686, 589: 50694, 900: 212519, 901: 90417, 902: 147312, 903: 207629, 904: 258872, 905: 167840, 906: 196365, 907: 295152, 908: 225453, 909: 268833, 2006: 150676, 2008: 154643, 2004: 159023, 2005: 156423, 2007: 156807, 2000: 155282, 2002: 149956, 2001: 155801, 2003: 156248,  594: 90947,  595: 97049,  596: 102030,  593: 100842,  591: 240885,  590: 231060,  592: 149450, 3000: 157998, 3001: 157998, 3002: 157998, 3003: 157998, 3004: 258880, 3005: 258880, 3006: 258880, 3007: 258880, 3008: 258880, 3009: 258880, 3010: 295168, 3011: 295168, 3012: 295168, 3013: 295168, 3014: 258880, 3015: 258880, 3016: 258880, 3017: 258880, 3018: 258880, 3019: 258880, 3020: 282169, 3021: 282169, 3022: 282169, 3023: 282169, 3024: 282169, 3025: 295168, 3026: 295168, 3027: 295168, 3028: 295168, 3029: 295168, 3030: 295168, 3031: 295168, 3032: 295168}
        contour_xmin={1: 65912, 2: 206122, 3: 220266, 4: 214559, 5: 100197, 6: 105140, 7: 42250, 8: 157659, 9: 150723, 10: 128791, 11: 72754, 12: 233830, 13: 225105, 14: 198440, 15: 208278, 16: 74698, 17: 258225, 18: 196031, 19: 193295, 20: 151842, 21: 113853, 22: 156021, 23: 148483, 24: 257221, 25: 161297, 26: 135530, 27: 228356, 28: 218005, 29: 164491, 30: 243799, 31: 236451, 32: 160538, 33: 138317, 34: 161484, 35: 165584, 36: 133206, 37: 151795, 38: 146139, 39: 236401, 40: 85415, 41: 125788, 42: 248006, 43: 132708, 44: 203950, 45: 193739, 46: 266977, 47: 227616, 48: 143806, 49: 230477, 50: 244294, 51: 150485, 52: 225865, 53: 157712, 54: 245010, 55: 204139, 56: 168332, 57: 233619, 58: 165305, 59: 144740, 60: 173195, 61: 180223, 62: 106648, 63: 243356, 64: 262073, 65: 161378, 66: 148422, 67: 240105, 68: 70469, 69: 147596, 70: 184531, 71: 227965, 72: 226589, 73: 212476, 74: 137806, 75: 236206, 76: 104235, 77: 145665, 78: 244143, 79: 240114, 80: 256906, 81: 230686, 82: 146996, 83: 204091, 84: 145160, 85: 194048, 86: 158723, 87: 244771, 88: 75725, 89: 144096, 90: 167757, 91: 221343, 92: 231638, 93: 184549, 94: 196660, 95: 178532, 96: 173192, 97: 244517, 98: 231625, 99: 196664, 100: 144631, 101: 254014, 102: 152200, 103: 126776, 104: 239644, 105: 143693, 106: 265367, 107: 149024, 108: 137846, 109: 211496, 110: 88103, 111: 235968, 112: 140731, 113: 167881, 114: 111609, 115: 184676, 116: 120497, 117: 168093, 118: 193224, 119: 96521, 120: 149054, 121: 219295, 122: 149190, 123: 217788, 124: 136872, 125: 263710, 126: 197184, 127: 141257, 128: 216300, 129: 246230, 130: 144193, 131: 182707, 132: 188338, 133: 223117, 134: 211712, 135: 240233, 136: 112250, 137: 96107, 138: 239615, 139: 190383, 140: 142511, 141: 246513, 142: 232816, 143: 152503, 144: 208806, 145: 156322, 146: 159683, 147: 187489, 148: 268089, 149: 214991, 150: 204124, 151: 210229, 152: 139988, 153: 110563, 154: 224344, 155: 179622, 156: 109679, 157: 175140, 158: 240128, 159: 248988, 160: 144406, 161: 216049, 162: 91925, 163: 227983, 164: 200263, 165: 111636, 166: 98373, 167: 149489, 168: 163371, 169: 231198, 170: 247200, 171: 137696, 172: 227138, 173: 188885, 174: 165179, 175: 226412, 176: 101818, 177: 219361, 178: 151221, 179: 175472, 180: 191952, 181: 222745, 182: 115206, 183: 206071, 184: 224909, 185: 218394, 186: 216683, 187: 217770, 188: 184491, 189: 132622, 190: 252944, 191: 209734, 192: 70216, 193: 231933, 194: 79177, 195: 270136, 196: 157778, 197: 219247, 198: 263939, 199: 209798, 200: 121202, 201: 239114, 202: 192119, 203: 99414, 204: 189296, 205: 148562, 206: 255390, 207: 133188, 208: 145319, 209: 176477, 210: 212430, 211: 242613, 212: 210586, 213: 111079, 214: 151662, 215: 145653, 216: 139882, 217: 137067, 218: 221601, 219: 158173, 220: 252735, 221: 99359, 222: 222088, 223: 200399, 224: 182213, 225: 175656, 226: 231727, 227: 199049, 228: 233756, 229: 240293, 230: 241719, 231: 143973, 232: 176637, 233: 206245, 234: 87765, 235: 256992, 236: 160155, 237: 213307, 238: 218517, 239: 141282, 240: 165274, 241: 176196, 242: 245675, 243: 230997, 244: 281283, 245: 103606, 246: 125700, 247: 260720, 248: 225562, 249: 264624, 250: 210944, 251: 230059, 252: 105945, 253: 275028, 254: 224714, 255: 81940, 256: 145989, 257: 240268, 258: 195158, 259: 206806, 260: 204527, 261: 193234, 262: 208131, 263: 151300, 264: 113508, 265: 240993, 266: 248297, 267: 168176, 268: 271055, 269: 133275, 270: 250921, 271: 153892, 272: 175801, 273: 252193, 274: 164495, 275: 251354, 276: 130381, 277: 150292, 278: 126629, 279: 99517, 280: 177422, 281: 127797, 282: 168507, 283: 156586, 284: 93377, 285: 213092, 286: 148948, 287: 184030, 288: 26301, 289: 106258, 290: 242765, 291: 70305, 292: 170361, 293: 163149, 294: 111749, 295: 25355, 296: 221970, 297: 169953, 298: 143103, 299: 146548, 300: 65389, 301: 168567, 302: 193935, 303: 109228, 304: 159404, 305: 139647, 306: 166130, 307: 52917, 308: 112252, 309: 178463, 310: 71619, 311: 65094, 312: 59198, 313: 95193, 314: 32546, 315: 234549, 316: 181035, 317: 73853, 318: 223907, 319: 94653, 320: 149419, 321: 69918, 322: 87638, 323: 107489, 324: 74997, 325: 159600, 326: 72519, 327: 49314, 328: 230663, 329: 134953, 330: 129279, 331: 161281, 332: 177409, 333: 101809, 334: 224633, 335: 131518, 336: 111654, 337: 184427, 338: 169120, 339: 60804, 340: 85825, 341: 188722, 342: 236876, 343: 154488, 344: 156268, 345: 94244, 346: 232437, 347: 137253, 348: 196595, 349: 212432, 350: 65913, 351: 215454, 352: 156040, 353: 57095, 354: 128294, 355: 189241, 356: 23572, 357: 91381, 358: 209098, 359: 55222, 360: 149346, 361: 165231, 362: 188913, 363: 64626, 364: 144348, 365: 161212, 366: 53442, 367: 155658, 368: 104959, 369: 128347, 370: 79195, 371: 165987, 372: 157774, 373: 157079, 374: 221967, 375: 135721, 376: 151939, 377: 226124, 378: 116527, 379: 240144, 380: 166679, 381: 202036, 382: 33240, 383: 195189, 384: 160292, 385: 122159, 386: 166549, 387: 217786, 388: 174968, 389: 66944, 390: 157159, 391: 151597, 392: 225413, 393: 50351, 394: 134132, 395: 166155, 396: 142101, 397: 201966, 398: 220086, 399: 53367, 400: 193386, 401: 126888, 402: 42769, 403: 74041, 404: 197287, 405: 97195, 406: 69961, 407: 211105, 408: 60310, 409: 230662, 410: 180445, 411: 43060, 412: 122211, 413: 94573, 414: 73361, 415: 156730, 416: 148032, 417: 236135, 418: 136839, 419: 67622, 420: 63639, 421: 77029, 422: 47117, 423: 193935, 424: 141593, 425: 91669, 426: 160139, 427: 50952, 428: 58215, 429: 172627, 430: 210014, 431: 171152, 432: 70583, 433: 111540, 434: 114792, 435: 57105, 436: 40240, 437: 183335, 438: 76189, 439: 146460, 440: 192247, 441: 93504, 442: 182671, 443: 129045, 444: 186247, 445: 146775, 446: 178458, 447: 212140, 448: 112642, 449: 49869, 450: 89889, 451: 187463, 452: 76203, 453: 89846, 454: 170708, 455: 147031, 456: 200881, 457: 163662, 458: 77336, 459: 161991, 460: 133163, 461: 238000, 462: 219247, 463: 140435, 464: 58119, 465: 121034, 466: 35998, 467: 118257, 468: 167727, 469: 150095, 470: 172735, 471: 98479, 472: 151034, 473: 123878, 474: 85418, 475: 133840, 476: 139400, 477: 97631, 478: 197490, 479: 157942, 480: 144509, 481: 174393, 482: 136109, 483: 95430, 484: 211482, 485: 200379, 486: 100918, 487: 194966, 488: 116952, 489: 153675, 490: 191356, 491: 126060, 492: 152576, 493: 125043, 494: 89023, 495: 208318, 496: 131702, 497: 61793, 498: 180096, 499: 146680, 500: 80627, 501: 153302, 502: 129106, 503: 75537, 504: 116098, 505: 174285, 506: 117880, 507: 177682, 508: 107040, 509: 202550, 510: 176690, 511: 146643, 512: 177902, 513: 126473, 514: 151983, 515: 159605, 516: 48910, 517: 150739, 518: 122834, 519: 60811, 520: 110146, 521: 146771, 522: 80953, 523: 182986, 524: 136238, 525: 186759, 526: 79913, 527: 136245, 528: 176964, 529: 79497, 530: 199025, 531: 102812, 532: 197599, 533: 86552, 534: 180188, 535: 143603, 536: 76488, 537: 123169, 538: 107764, 539: 82945, 540: 31938, 541: 156254, 542: 58810, 543: 119118, 544: 45368, 545: 128177, 546: 119118, 547: 155848, 548: 100678, 549: 44236, 550: 24934, 551: 150052, 552: 119614, 553: 37389, 554: 174178, 555: 201718, 556: 91658, 557: 117337, 558: 231550, 559: 196059, 560: 221452, 561: 202789, 562: 157253, 563: 204893, 564: 154982, 565: 134889, 566: 231400, 567: 157867, 568: 82879, 569: 36523, 570: 155550, 571: 180642, 572: 69497, 573: 145749, 574: 227511, 575: 192883, 576: 97683, 577: 181836, 578: 209297, 579: 162516, 580: 187785, 581: 221389, 582: 160102, 583: 145728, 584: 22041, 585: 224714, 586: 216531, 587: 55615, 588: 108743, 589: 33318, 900: 136245, 901: 21991, 902: 77331, 903: 116098, 904: 192882, 905: 42933, 906: 130217, 907: 193670, 908: 145365, 909: 193417, 2006: 147153, 2008: 148620, 2004: 155129, 2005: 152040, 2007: 153913, 2000: 145259, 2002: 139400, 2001: 152909, 2003: 154035,  594: 77336,  595: 82879,  596: 86552,  593: 89846,  591: 226124,  590: 216531,  592: 137253, 3000: 141192, 3001: 141192, 3002: 141192, 3003: 141192, 3004: 21991, 3005: 21991, 3006: 21991, 3007: 21991, 3008: 21991, 3009: 21991, 3010: 42244, 3011: 42244, 3012: 42244, 3013: 42244, 3014: 21991, 3015: 21991, 3016: 21991, 3017: 21991, 3018: 21991, 3019: 21991, 3020: 42244, 3021: 42244, 3022: 42244, 3023: 42244, 3024: 42244, 3025: 262064, 3026: 262064, 3027: 262064, 3028: 262064, 3029: 262064, 3030: 262064, 3031: 262064, 3032: 262064}
        contour_ymax={1: 162338, 2: 52629, 3: 158793, 4: 152010, 5: 123695, 6: 136868, 7: 167558, 8: 159826, 9: 170477, 10: 134949, 11: 140715, 12: 155388, 13: 66231, 14: 75947, 15: 152297, 16: 157428, 17: 150339, 18: 90447, 19: 81746, 20: 157069, 21: 122082, 22: 143450, 23: 170026, 24: 155532, 25: 89237, 26: 109329, 27: 160578, 28: 66364, 29: 146766, 30: 145272, 31: 160976, 32: 126667, 33: 134757, 34: 125329, 35: 150313, 36: 157640, 37: 168508, 38: 178089, 39: 145670, 40: 162704, 41: 150953, 42: 144595, 43: 100504, 44: 136853, 45: 156354, 46: 107247, 47: 29800, 48: 103593, 49: 149605, 50: 54861, 51: 149786, 52: 135250, 53: 102272, 54: 118003, 55: 81914, 56: 150539, 57: 45160, 58: 124198, 59: 175891, 60: 129077, 61: 82396, 62: 126981, 63: 151520, 64: 156064, 65: 161473, 66: 116786, 67: 156079, 68: 153562, 69: 121512, 70: 117160, 71: 103044, 72: 106638, 73: 99239, 74: 129309, 75: 139204, 76: 123420, 77: 173015, 78: 161352, 79: 143585, 80: 162457, 81: 128973, 82: 169973, 83: 141678, 84: 158192, 85: 160253, 86: 153999, 87: 61615, 88: 140078, 89: 113120, 90: 165432, 91: 112518, 92: 153705, 93: 104696, 94: 144451, 95: 162693, 96: 166391, 97: 47255, 98: 53321, 99: 119467, 100: 174641, 101: 148132, 102: 172519, 103: 115483, 104: 149686, 105: 173832, 106: 152693, 107: 158371, 108: 152098, 109: 135346, 110: 141292, 111: 118670, 112: 154431, 113: 133579, 114: 145270, 115: 110566, 116: 147057, 117: 157034, 118: 148631, 119: 134002, 120: 172232, 121: 124944, 122: 174517, 123: 147433, 124: 119779, 125: 135602, 126: 141204, 127: 171092, 128: 79895, 129: 155662, 130: 134798, 131: 154951, 132: 159213, 133: 93939, 134: 87626, 135: 33746, 136: 123812, 137: 141448, 138: 70937, 139: 78502, 140: 132923, 141: 34240, 142: 134191, 143: 170920, 144: 133352, 145: 118707, 146: 112471, 147: 123239, 148: 158415, 149: 155219, 150: 123283, 151: 120215, 152: 124135, 153: 125032, 154: 159309, 155: 148781, 156: 138415, 157: 135744, 158: 37991, 159: 121085, 160: 126255, 161: 160209, 162: 148554, 163: 147036, 164: 130118, 165: 127745, 166: 162791, 167: 103229, 168: 139915, 169: 167177, 170: 140787, 171: 90877, 172: 157522, 173: 145497, 174: 118845, 175: 115297, 176: 163693, 177: 150567, 178: 92041, 179: 116852, 180: 128194, 181: 37044, 182: 153968, 183: 89160, 184: 85785, 185: 143000, 186: 133278, 187: 53749, 188: 68950, 189: 142916, 190: 155180, 191: 157956, 192: 157381, 193: 37057, 194: 161308, 195: 141518, 196: 136859, 197: 154015, 198: 161719, 199: 107975, 200: 155875, 201: 135457, 202: 135879, 203: 119517, 204: 162331, 205: 131349, 206: 133001, 207: 117361, 208: 168916, 209: 122324, 210: 147789, 211: 129345, 212: 128339, 213: 147156, 214: 167168, 215: 139094, 216: 118480, 217: 143445, 218: 147060, 219: 125830, 220: 134564, 221: 128368, 222: 130769, 223: 149070, 224: 95051, 225: 159966, 226: 128451, 227: 103323, 228: 90283, 229: 149091, 230: 103672, 231: 173436, 232: 140381, 233: 157328, 234: 158500, 235: 143815, 236: 149745, 237: 142795, 238: 137547, 239: 147182, 240: 99946, 241: 111214, 242: 116342, 243: 78596, 244: 134091, 245: 144940, 246: 124454, 247: 150084, 248: 52931, 249: 117106, 250: 58224, 251: 141830, 252: 160252, 253: 136117, 254: 140714, 255: 142265, 256: 167311, 257: 167657, 258: 114598, 259: 69315, 260: 154496, 261: 63787, 262: 146910, 263: 175066, 264: 133742, 265: 90471, 266: 39706, 267: 144573, 268: 123146, 269: 83534, 270: 157409, 271: 160720, 272: 152229, 273: 147198, 274: 131345, 275: 107846, 276: 156272, 277: 139331, 278: 137373, 279: 154273, 280: 104118, 281: 126235, 282: 224168, 283: 197756, 284: 181377, 285: 173488, 286: 204555, 287: 172797, 288: 205632, 289: 178856, 290: 164585, 291: 229649, 292: 201975, 293: 169446, 294: 196307, 295: 182175, 296: 168611, 297: 190801, 298: 188240, 299: 191192, 300: 191322, 301: 171361, 302: 173323, 303: 204492, 304: 192982, 305: 192569, 306: 190482, 307: 206909, 308: 212675, 309: 211885, 310: 222539, 311: 199871, 312: 169841, 313: 203452, 314: 190856, 315: 182340, 316: 204337, 317: 184276, 318: 158851, 319: 208920, 320: 183226, 321: 185839, 322: 222089, 323: 191356, 324: 169136, 325: 206214, 326: 177983, 327: 180679, 328: 171052, 329: 192577, 330: 180275, 331: 214048, 332: 221135, 333: 190967, 334: 221745, 335: 175502, 336: 182850, 337: 219810, 338: 181581, 339: 173493, 340: 167086, 341: 184549, 342: 203090, 343: 208844, 344: 183253, 345: 169094, 346: 209081, 347: 196476, 348: 223978, 349: 208452, 350: 183349, 351: 189642, 352: 221602, 353: 215029, 354: 200190, 355: 200863, 356: 199878, 357: 163979, 358: 218879, 359: 190636, 360: 200992, 361: 187176, 362: 242185, 363: 209063, 364: 166960, 365: 220672, 366: 172318, 367: 172981, 368: 185421, 369: 220353, 370: 186151, 371: 207954, 372: 208956, 373: 210440, 374: 219037, 375: 175608, 376: 204421, 377: 204671, 378: 182921, 379: 209731, 380: 220476, 381: 174457, 382: 207313, 383: 221103, 384: 180525, 385: 199126, 386: 202825, 387: 199825, 388: 215774, 389: 177161, 390: 172409, 391: 228297, 392: 179730, 393: 217957, 394: 186565, 395: 181841, 396: 163512, 397: 192696, 398: 182809, 399: 223499, 400: 165123, 401: 172049, 402: 183951, 403: 194219, 404: 187882, 405: 219224, 406: 182495, 407: 164997, 408: 176485, 409: 195633, 410: 167116, 411: 216054, 412: 215602, 413: 215767, 414: 210623, 415: 200766, 416: 199568, 417: 190015, 418: 187597, 419: 174442, 420: 228798, 421: 199505, 422: 203610, 423: 193543, 424: 199086, 425: 177319, 426: 184496, 427: 188550, 428: 207047, 429: 211873, 430: 196260, 431: 186271, 432: 174968, 433: 191023, 434: 186389, 435: 200108, 436: 189684, 437: 183804, 438: 178328, 439: 186712, 440: 180467, 441: 207563, 442: 224265, 443: 164387, 444: 231889, 445: 197225, 446: 192080, 447: 171053, 448: 178756, 449: 213570, 450: 212434, 451: 193059, 452: 160199, 453: 206934, 454: 244027, 455: 227449, 456: 203737, 457: 197445, 458: 201813, 459: 230345, 460: 207297, 461: 197832, 462: 175261, 463: 209785, 464: 187781, 465: 160891, 466: 201711, 467: 173535, 468: 215469, 469: 196504, 470: 173998, 471: 210050, 472: 238256, 473: 195842, 474: 175481, 475: 181587, 476: 229770, 477: 183144, 478: 175152, 479: 212573, 480: 216844, 481: 183766, 482: 163081, 483: 191952, 484: 178176, 485: 211609, 486: 172644, 487: 205744, 488: 206144, 489: 176901, 490: 228394, 491: 177912, 492: 163563, 493: 204034, 494: 199288, 495: 204497, 496: 170335, 497: 224782, 498: 173668, 499: 163267, 500: 173254, 501: 179340, 502: 190188, 503: 182173, 504: 158161, 505: 231519, 506: 191652, 507: 226183, 508: 197062, 509: 184876, 510: 178042, 511: 162536, 512: 197701, 513: 167370, 514: 207025, 515: 235929, 516: 196444, 517: 241423, 518: 187233, 519: 196145, 520: 169719, 521: 205752, 522: 167487, 523: 209789, 524: 168575, 525: 214949, 526: 205972, 527: 201667, 528: 192165, 529: 218753, 530: 179302, 531: 170938, 532: 218045, 533: 182849, 534: 198050, 535: 179749, 536: 173464, 537: 210884, 538: 211748, 539: 186285, 540: 184187, 541: 205921, 542: 220862, 543: 196052, 544: 210661, 545: 175428, 546: 163564, 547: 166499, 548: 178163, 549: 162863, 550: 193925, 551: 188799, 552: 178513, 553: 182059, 554: 206140, 555: 162537, 556: 186708, 557: 212902, 558: 185949, 559: 231763, 560: 209394, 561: 199924, 562: 203599, 563: 178147, 564: 226804, 565: 227029, 566: 192662, 567: 214722, 568: 191412, 569: 211331, 570: 173058, 571: 233720, 572: 192485, 573: 200670, 574: 213220, 575: 197511, 576: 189580, 577: 238597, 578: 186122, 579: 175655, 580: 176935, 581: 190648, 582: 188142, 583: 202741, 584: 201832, 585: 175887, 586: 215733, 587: 180515, 588: 169889, 589: 169805, 900:244027, 901: 229719, 902: 227140, 903: 193541, 904: 221730, 905: 166894, 906: 165925, 907: 167363, 908: 148441, 909: 124601, 2006: 209592, 2008: 208263, 2004: 214323, 2005: 221880, 2007: 217710, 2000: 222647, 2002: 229770, 2001: 210833, 2003: 213049,  594: 205972,  595: 199288,  596: 182849,  593: 207563,  591: 204671,  590: 219037,  592: 199086, 3000: 178177, 3001: 178177, 3002: 178177, 3003: 178177, 3004: 244028, 3005: 244028, 3006: 244028, 3007: 244028, 3008: 244028, 3009: 244028, 3010: 167685, 3011: 167685, 3012: 167685, 3013: 167685, 3014: 244028, 3015: 244028, 3016: 244028, 3017: 244028, 3018: 244028, 3019: 244028, 3020: 167685, 3021: 167685, 3022: 167685, 3023: 167685, 3024: 167685, 3025: 161719, 3026: 161719, 3027: 161719, 3028: 161719, 3029: 161719, 3030: 161719, 3031: 161719, 3032: 161719}
        contour_ymin={1: 156098, 2: 33761, 3: 153289, 4: 146474, 5: 117878, 6: 125411, 7: 154546, 8: 153844, 9: 167999, 10: 124747, 11: 134050, 12: 150087, 13: 47605, 14: 57412, 15: 145417, 16: 149038, 17: 141787, 18: 78541, 19: 72467, 20: 148142, 21: 113009, 22: 134971, 23: 165577, 24: 147326, 25: 74935, 26: 94181, 27: 152655, 28: 52500, 29: 138866, 30: 140099, 31: 153104, 32: 122558, 33: 128295, 34: 117323, 35: 144053, 36: 149067, 37: 164369, 38: 165088, 39: 138446, 40: 155150, 41: 139367, 42: 137382, 43: 89901, 44: 128836, 45: 143405, 46: 92325, 47: 21192, 48: 85725, 49: 145331, 50: 43688, 51: 138191, 52: 128105, 53: 86668, 54: 105807, 55: 66659, 56: 142669, 57: 35115, 58: 116403, 59: 172687, 60: 120321, 61: 67445, 62: 120597, 63: 144086, 64: 150084, 65: 152480, 66: 108751, 67: 148305, 68: 138429, 69: 116072, 70: 107893, 71: 87269, 72: 95312, 73: 85761, 74: 123479, 75: 130333, 76: 115982, 77: 171815, 78: 153202, 79: 138263, 80: 153141, 81: 122485, 82: 167791, 83: 133386, 84: 146120, 85: 154418, 86: 148746, 87: 52057, 88: 131599, 89: 100615, 90: 154501, 91: 101140, 92: 139598, 93: 91431, 94: 138516, 95: 152018, 96: 158880, 97: 35391, 98: 42576, 99: 109192, 100: 172801, 101: 143953, 102: 169340, 103: 105099, 104: 145289, 105: 171715, 106: 138977, 107: 151146, 108: 144742, 109: 123364, 110: 131045, 111: 101753, 112: 149855, 113: 123378, 114: 136537, 115: 96705, 116: 132241, 117: 149114, 118: 142149, 119: 125903, 120: 170727, 121: 110411, 122: 170331, 123: 139344, 124: 112008, 125: 116812, 126: 132826, 127: 166295, 128: 63106, 129: 143623, 130: 124039, 131: 145059, 132: 147832, 133: 82340, 134: 74759, 135: 26121, 136: 114736, 137: 130254, 138: 57289, 139: 59223, 140: 123726, 141: 26128, 142: 128265, 143: 167558, 144: 124395, 145: 111523, 146: 98550, 147: 113770, 148: 144822, 149: 150999, 150: 109590, 151: 103538, 152: 118779, 153: 118832, 154: 150335, 155: 135165, 156: 130960, 157: 119753, 158: 31489, 159: 113199, 160: 117265, 161: 154714, 162: 137691, 163: 138003, 164: 121135, 165: 122398, 166: 152754, 167: 90082, 168: 130379, 169: 158446, 170: 125764, 171: 70028, 172: 149357, 173: 132826, 174: 105630, 175: 104699, 176: 157839, 177: 145296, 178: 69535, 179: 107745, 180: 118281, 181: 28582, 182: 142240, 183: 79775, 184: 72252, 185: 136223, 186: 126703, 187: 38362, 188: 52801, 189: 134918, 190: 147286, 191: 149821, 192: 149724, 193: 22322, 194: 149401, 195: 119483, 196: 125257, 197: 148117, 198: 154734, 199: 94446, 200: 146756, 201: 121311, 202: 126524, 203: 110448, 204: 157205, 205: 115776, 206: 115138, 207: 107787, 208: 165252, 209: 114801, 210: 140779, 211: 117016, 212: 117526, 213: 139959, 214: 162428, 215: 128615, 216: 106229, 217: 131731, 218: 139053, 219: 117475, 220: 125764, 221: 122557, 222: 122459, 223: 140350, 224: 78686, 225: 149340, 226: 117947, 227: 87142, 228: 78050, 229: 142982, 230: 84443, 231: 170420, 232: 130798, 233: 152906, 234: 146416, 235: 129583, 236: 142811, 237: 134407, 238: 131344, 239: 136949, 240: 86774, 241: 100563, 242: 101832, 243: 62394, 244: 112416, 245: 135256, 246: 113307, 247: 135695, 248: 34846, 249: 103668, 250: 50128, 251: 133148, 252: 151099, 253: 121966, 254: 134970, 255: 135628, 256: 161466, 257: 152009, 258: 99973, 259: 51453, 260: 148436, 261: 44481, 262: 138224, 263: 171302, 264: 118610, 265: 67311, 266: 29964, 267: 131823, 268: 109847, 269: 71472, 270: 152893, 271: 156132, 272: 142087, 273: 138654, 274: 121061, 275: 89904, 276: 146542, 277: 129455, 278: 128030, 279: 139280, 280: 93145, 281: 115388, 282: 214789, 283: 191616, 284: 174960, 285: 167235, 286: 199934, 287: 160339, 288: 198108, 289: 166765, 290: 156568, 291: 221269, 292: 187646, 293: 158964, 294: 189816, 295: 166157, 296: 157177, 297: 185491, 298: 178930, 299: 184259, 300: 182204, 301: 164533, 302: 163064, 303: 193462, 304: 186682, 305: 184849, 306: 186147, 307: 194711, 308: 203882, 309: 199309, 310: 209576, 311: 190209, 312: 161195, 313: 196264, 314: 178169, 315: 169964, 316: 194954, 317: 177658, 318: 156931, 319: 185681, 320: 176293, 321: 179300, 322: 212056, 323: 184713, 324: 159031, 325: 195873, 326: 168035, 327: 166451, 328: 162119, 329: 185790, 330: 174786, 331: 204270, 332: 210878, 333: 180574, 334: 211765, 335: 170054, 336: 177038, 337: 209537, 338: 168240, 339: 165532, 340: 161143, 341: 175992, 342: 190610, 343: 205674, 344: 175424, 345: 161880, 346: 199953, 347: 191301, 348: 205061, 349: 197993, 350: 176271, 351: 184078, 352: 213940, 353: 204576, 354: 191350, 355: 191810, 356: 187585, 357: 156983, 358: 205695, 359: 183781, 360: 195718, 361: 179393, 362: 227209, 363: 194673, 364: 163248, 365: 212221, 366: 162981, 367: 167536, 368: 176193, 369: 207305, 370: 179184, 371: 201434, 372: 202186, 373: 207851, 374: 208546, 375: 166922, 376: 198111, 377: 191660, 378: 173832, 379: 202045, 380: 212142, 381: 160183, 382: 198611, 383: 212248, 384: 171732, 385: 191394, 386: 196163, 387: 188460, 388: 208191, 389: 174055, 390: 168411, 391: 220311, 392: 167984, 393: 212482, 394: 180211, 395: 174269, 396: 155879, 397: 183141, 398: 174269, 399: 213011, 400: 155004, 401: 166820, 402: 174073, 403: 183912, 404: 177877, 405: 206637, 406: 176819, 407: 156439, 408: 171527, 409: 190476, 410: 159280, 411: 209310, 412: 206599, 413: 206687, 414: 199259, 415: 195829, 416: 196725, 417: 178677, 418: 177629, 419: 158339, 420: 206039, 421: 190900, 422: 193335, 423: 181600, 424: 190724, 425: 164701, 426: 177676, 427: 179327, 428: 197783, 429: 204455, 430: 185383, 431: 179847, 432: 170461, 433: 182450, 434: 182027, 435: 190041, 436: 181136, 437: 174573, 438: 170949, 439: 176733, 440: 170756, 441: 201246, 442: 219599, 443: 155017, 444: 217106, 445: 189574, 446: 182649, 447: 162595, 448: 168008, 449: 204706, 450: 206129, 451: 182697, 452: 155931, 453: 198120, 454: 229580, 455: 220816, 456: 196219, 457: 189701, 458: 189989, 459: 218426, 460: 199052, 461: 188058, 462: 166885, 463: 201498, 464: 175885, 465: 153049, 466: 186005, 467: 162356, 468: 207284, 469: 186758, 470: 164239, 471: 197685, 472: 226973, 473: 186160, 474: 166468, 475: 173678, 476: 203698, 477: 177089, 478: 163434, 479: 208524, 480: 208401, 481: 176373, 482: 153215, 483: 185990, 484: 171870, 485: 200960, 486: 165544, 487: 198436, 488: 195776, 489: 169333, 490: 218665, 491: 172737, 492: 158292, 493: 197910, 494: 189297, 495: 198770, 496: 163273, 497: 219232, 498: 164520, 499: 160639, 500: 165064, 501: 174270, 502: 184113, 503: 174947, 504: 153240, 505: 222605, 506: 184647, 507: 218225, 508: 187115, 509: 176122, 510: 171389, 511: 156060, 512: 190989, 513: 159462, 514: 203861, 515: 225322, 516: 186897, 517: 233980, 518: 176606, 519: 187502, 520: 157542, 521: 202138, 522: 159318, 523: 202986, 524: 159900, 525: 197838, 526: 200283, 527: 194249, 528: 185388, 529: 204429, 530: 172235, 531: 159824, 532: 212301, 533: 173627, 534: 189027, 535: 175561, 536: 167229, 537: 202206, 538: 208135, 539: 176689, 540: 175953, 541: 202282, 542: 212154, 543: 188270, 544: 200999, 545: 171064, 546: 156585, 547: 157428, 548: 169392, 549: 161253, 550: 178753, 551: 181806, 552: 172075, 553: 165752, 554: 200259, 555: 154164, 556: 180065, 557: 203064, 558: 176801, 559: 220436, 560: 194427, 561: 189878, 562: 200625, 563: 171556, 564: 217636, 565: 206278, 566: 185942, 567: 211781, 568: 182267, 569: 199411, 570: 164851, 571: 225320, 572: 184391, 573: 198397, 574: 202933, 575: 189714, 576: 182871, 577: 231591, 578: 173481, 579: 167568, 580: 169133, 581: 178696, 582: 183118, 583: 200293, 584: 194410, 585: 167599, 586: 206540, 587: 170383, 588: 162825, 589: 156372, 900: 186679, 901: 155929, 902: 156977, 903: 153058, 904: 154163, 905: 69534, 906: 135026, 907: 92893, 908: 52813, 909: 21189, 2006: 205062, 2008: 203698, 2004: 208276, 2005: 216722, 2007: 213342, 2000: 207274, 2002: 220350, 2001: 207420, 2003: 209363,  594: 189989,  595: 182267,  596: 173627,  593: 196264,  591: 190476,  590: 206540,  592: 190724,3000: 161463, 3001: 161463, 3002: 161463, 3003: 161463, 3004: 153057, 3005: 153057, 3006: 153057, 3007: 153057, 3008: 153057, 3009: 153057, 3010: 21153, 3011: 21153, 3012: 21153, 3013: 21153, 3014: 153057, 3015: 153057, 3016: 153057, 3017: 153057, 3018: 153057, 3019: 153057, 3020: 21153, 3021: 21153, 3022: 21153, 3023: 21153, 3024: 21153, 3025: 92430, 3026: 92430, 3027: 92430, 3028: 92430, 3029: 92430, 3030: 92430, 3031: 92430, 3032: 92430}
        global combovalues
        combovalues=[]
        combovaluesutf8=[]
        for key,value in contour_name.items():
            combovalues.append(value.encode('utf-8').strip())
        self.dlg.comboGemeentes.clear()
        for combovalue in combovalues:
            combovaluesutf8.append(combovalue.decode('utf-8'))
        self.dlg.comboGemeentes.addItems(combovaluesutf8)
        global selected_contour
        global s
        s = QSettings()
        self.iface = iface
        self.plugin_dir = os.path.dirname(__file__)
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'ZoomToBelgium_{}.qm'.format(locale))
        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)

            if qVersion() > '4.3.3':
                QCoreApplication.installTranslator(self.translator)
        self.actions = []
        self.menu = self.tr(u'&ZoomToBelgium')
        self.toolbar = self.iface.addToolBar(u'ZoomToBelgium')
        self.toolbar.setObjectName(u'ZoomToBelgium')
        self.dlg.button_box.accepted.connect(self.savesettings)

    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=False,
        status_tip=None,
        whats_this=None,
        parent=None):

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            self.toolbar.addAction(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)
        return action

    def add_action_toolbar(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=False,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        icon = QIcon(icon_path)
        actiontoolbar = QAction(icon, text, parent)
        actiontoolbar.triggered.connect(callback)
        actiontoolbar.setEnabled(enabled_flag)

        if status_tip is not None:
            actiontoolbar.setStatusTip(status_tip)

        if whats_this is not None:
            actiontoolbar.setWhatsThis(whats_this)

        if add_to_toolbar:
            self.toolbar.addAction(actiontoolbar)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                actiontoolbar)

        self.actions.append(actiontoolbar)
        return actiontoolbar

    def initGui(self):
        icon_path = ':/plugins/ZoomToBelgium/icon.png'
        settings_icon_path = ':/plugins/ZoomToBelgium/settings.png'
        self.add_action_toolbar(
            icon_path,
            text=self.tr(u'Zoom to the Selected Boundary'),
            callback=self.run,
            parent=self.iface.mainWindow())
        self.add_action(
            icon_path,
            text=self.tr(u'Zoom to the Selected Boundary'),
            callback=self.run,
            parent=self.iface.mainWindow())
        self.add_action(
            settings_icon_path,
            text=self.tr(u'Select Boundary'),
            callback=self.opensettings,
            parent=self.iface.mainWindow())

    def unload(self):
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&ZoomToBelgium'),
                action)
            self.iface.removeToolBarIcon(action)
        del self.toolbar

    def nomunicipalityselected(self):
        self.opensettings()

    def zoomtomunicipality(self, id):
        canvas = self.iface.mapCanvas()
        PROJECTsrs = canvas.mapSettings().destinationCrs()
        try:
            if not canvas.hasCrsTransformEnabled():
                canvas.setCrsTransformEnabled(True)
        except:
            pass
        my_crs = QgsCoordinateReferenceSystem(31370)
        canvas.setDestinationCrs(my_crs)

        selected_contour=s.value("zoomtobelgium/municipality", 518)
        selectedcontour_int=int(selected_contour[0])
        if(selectedcontour_int>1000 and selectedcontour_int<2000):
            selectedcontour_int=selectedcontour_int-1000
        if(selectedcontour_int<0):
            xmax_contour=max(contour_xmax.values())
            xmin_contour=min(contour_xmin.values())
            ymax_contour=max(contour_ymax.values())
            ymin_contour=min(contour_ymin.values())
        else:
            xmax_contour=contour_xmax[selectedcontour_int]
            xmin_contour=contour_xmin[selectedcontour_int]
            ymax_contour=contour_ymax[selectedcontour_int]
            ymin_contour=contour_ymin[selectedcontour_int]
        buffer_x=(abs(xmax_contour-xmin_contour))/50
        buffer_y=(abs(ymax_contour-ymin_contour))/50
        buffer=max(buffer_x,buffer_y)
        xmax_setting=xmax_contour+buffer
        xmin_setting=xmin_contour-buffer
        ymax_setting=ymax_contour+buffer
        ymin_setting=ymin_contour-buffer

        canvas.setExtent(QgsRectangle(xmin_setting,ymin_setting,xmax_setting,ymax_setting))

        canvas.setDestinationCrs(PROJECTsrs)
        canvas.refresh()

    def opensettings(self):
        selected_contour=[]
        selected_contourtemp=s.value("zoomtobelgium/municipality")

        if not selected_contourtemp:
            selected_contour.append(518)
        else:
            selected_contour.append(int(selected_contourtemp[0]))
        try:
            selected_contourindex=contour_name.keys().index(int(selected_contour[0]))
        except:
            selected_contourindex=list(contour_name).index(int(selected_contour[0]))
        self.dlg.comboGemeentes.setCurrentIndex(selected_contourindex)
        introsubtext=self.tr(u'Select Boundary')
        introtext=u'<html><head/><body><p><span style=" font-size:16pt;">'+introsubtext+'</span></p></body></html>'
        self.dlg.intro.setText(introtext.replace("&lt;","<").replace("&gt;",">").replace("&quot;",'"'))
        self.dlg.show()

    def savesettings(self):
        to_save_id=self.search_contour(contour_name,self.dlg.comboGemeentes.currentText().strip())
        s.setValue("zoomtobelgium/municipality", to_save_id)
        print(to_save_id)
        self.zoomtomunicipality(to_save_id)

    def search_contour(self,list,search_contour):
        try:
            return [id for id,municipality in list.iteritems() if municipality == search_contour]
        except:
            return [id for id,municipality in list.items() if municipality == search_contour]

    def run(self):
        selected_contour=s.value("zoomtobelgium/municipality", 0)
        if selected_contour=="" or selected_contour==0 or selected_contour is None:
            self.nomunicipalityselected()
        else:
            self.zoomtomunicipality(selected_contour)
