# YF Tools Plus for QGIS 3.30+

[![QGIS](https://img.shields.io/badge/QGIS-3.30+-green.svg)](https://qgis.org/)
[![License: GPL v2+](https://img.shields.io/badge/License-GPL%20v2+-blue.svg)](https://www.gnu.org/licenses/gpl-2.0)
[![Plugin Version](https://img.shields.io/badge/version-2.0-orange.svg)](https://github.com/yurifabian/YF_Tools_Plus/releases)

**YF Tools Plus** is a unified QGIS plugin for surveying and georeferencing tasks, combining the functionalities of YF_Tools and Export to Excel (One Click) into a single comprehensive tool.

---

## 🌍 English

### Features

**YF Tools Plus** provides four main tools organized in an intuitive tabbed interface:

#### 1. 🚀 Quick Export to Excel (One Click)
- Export attribute tables from any active vector layer to Excel (`.xlsx`) format
- One-click execution from the toolbar
- Automatic file opening for instant review
- No temporary files required

#### 2. 📊 Excel to CSV Conversion
- Convert Excel files (`.xlsx`, `.xls`) to CSV format compatible with QGIS
- UTF-8 encoding guaranteed to prevent character issues

#### 3. 🗺️ Polygon Creation from Coordinates
- Create polygons from coordinate lists in CSV files
- Automatic calculation of **Area** (in hectares) and **Perimeter** (in meters)
- Support for multiple coordinate reference systems (CRS)
- Customizable styling and automatic labeling

#### 4. ✂️ Advanced Polygon Segmentator
- Split polygons into individual segments and vertices
- **Detailed calculations:** Lengths, azimuths (relative to true north), internal and external angles
- **Smart ordering:** Reorganizes vertices starting from the northernmost point
- **Structured output:** Generates independent layers for lines (segments) and points (vertices) with complete attributes

### Installation

#### From QGIS Plugin Repository (Recommended)
1. Open QGIS
2. Go to `Plugins` → `Manage and Install Plugins...`
3. Search for "YF Tools Plus"
4. Click `Install Plugin`

#### Manual Installation
1. Download the latest release from [GitHub Releases](https://github.com/yurifabian/YF_Tools_Plus/releases)
2. Locate your QGIS plugins directory:
   - **Windows:** `C:\Users\<username>\AppData\Roaming\QGIS\QGIS3\profiles\default\python\plugins`
   - **Linux/macOS:** `~/.local/share/QGIS/QGIS3/profiles/default/python/plugins`
3. Extract the ZIP file into a folder named `YF_Tools_Plus`
4. Restart QGIS and enable the plugin from `Plugins` → `Manage and Install Plugins`

### Usage

#### Quick Export Button
- Select the vector layer you want to export
- Click the "Export to Excel" button in the toolbar
- The file will be automatically saved and opened

#### Main Tools Panel
Click the "YF Tools Plus" button to open the complete toolset with 4 tabs:

**Tab 1: Excel to CSV**
- Select an Excel file (`.xlsx` or `.xls`)
- Specify output CSV location
- Click "Convert Excel to CSV"

**Tab 2: Create Polygon**
- Select a CSV file with coordinates
- Configure X and Y coordinate fields (default: ESTE, NORTE)
- Set the coordinate reference system (default: EPSG:32719)
- Customize polygon style and labels
- Click "Create Polygon"

**Tab 3: Segmentator**
- Select an existing polygon layer
- Click "Segment Polygon"
- Two new layers will be created:
  - **Segments:** Lines with length and azimuth
  - **Vertices:** Points with coordinates, internal and external angles

**Tab 4: Export to Excel**
- Select a vector layer to export
- Optionally specify a custom save location
- Click "Export to Excel"
- Choose whether to open the file automatically

### Output Data Structure

| Layer | Generated Attributes |
|-------|---------------------|
| **Polygons** | ID, AREA (ha), PERIMETER (m) |
| **Segments** | ID, Length, Azimuth (0-360°) |
| **Vertices** | ID, Side (V-n to V-m), East, North, Distance, Azimuth, Internal Angle, External Angle |

### Requirements
- **QGIS 3.30** or higher
- **Python 3.9+** (included with QGIS)
- Libraries: `PyQt5`, `pandas`, `qgis.core`

---

## 🇪🇸 Español

### Características Principales

**YF Tools Plus** es un plugin de topografía que permite crear polígonos rápidamente desde Excel, acortando significativamente el tiempo de elaboración de mapas.

#### 1. 🚀 Exportación Rápida a Excel (Un Clic)
- Exporta la tabla de atributos de cualquier capa vectorial activa a formato Excel (`.xlsx`)
- Ejecución inmediata desde la barra de herramientas
- Apertura automática del archivo generado para revisión instantánea

#### 2. 📊 Conversión de Excel a CSV
- Transforma archivos Excel (`.xlsx`, `.xls`) a formato CSV compatible con QGIS
- Codificación UTF-8 garantizada para evitar problemas con caracteres especiales

#### 3. 🗺️ Generación de Polígonos desde Coordenadas
- Crea polígonos a partir de listados de coordenadas en archivos CSV
- Cálculo automático de **Área** (en hectáreas) y **Perímetro** (en metros)
- Soporte para múltiples sistemas de coordenadas (CRS)
- Configuración personalizable de estilos y etiquetado automático

#### 4. ✂️ Segmentador Avanzado de Polígonos
- Divide polígonos en segmentos y vértices individuales
- **Cálculos detallados:** Longitudes, azimuts (respecto al norte verdadero), ángulos internos y externos
- **Orden Inteligente:** Reorganiza los vértices comenzando desde el punto más al norte
- **Salida Estructurada:** Genera capas independientes de líneas (segmentos) y puntos (vértices) con atributos completos

### Instalación

#### Desde el Repositorio de Plugins de QGIS (Recomendado)
1. Abre QGIS
2. Ve a `Complementos` → `Administrar e instalar complementos...`
3. Busca "YF Tools Plus"
4. Haz clic en `Instalar complemento`

#### Instalación Manual
1. Descarga la última versión desde [GitHub Releases](https://github.com/yurifabian/YF_Tools_Plus/releases)
2. Localiza el directorio de plugins de QGIS:
   - **Windows:** `C:\Users\<usuario>\AppData\Roaming\QGIS\QGIS3\profiles\default\python\plugins`
   - **Linux/macOS:** `~/.local/share/QGIS/QGIS3/profiles\default\python\plugins`
3. Descomprime el archivo ZIP en una carpeta llamada `YF_Tools_Plus`
4. Reinicia QGIS y activa el plugin desde `Complementos` → `Administrar e instalar complementos`

### Uso

#### Botón de Exportación Rápida
- Selecciona la capa vectorial que deseas exportar
- Haz clic en el botón "Exportar a Excel" en la barra de herramientas
- El archivo se guardará automáticamente y se abrirá

#### Panel de Herramientas Principal
Haz clic en el botón "YF Tools Plus" para abrir el conjunto completo de herramientas con 4 pestañas:

**Pestaña 1: Excel a CSV**
- Selecciona un archivo Excel (`.xlsx` o `.xls`)
- Especifica dónde guardar el archivo CSV
- Haz clic en "Convertir Excel a CSV"

**Pestaña 2: Crear Polígono**
- Selecciona un archivo CSV con coordenadas
- Configura los campos de coordenadas X e Y (por defecto: ESTE, NORTE)
- Especifica el sistema de coordenadas (por defecto: EPSG:32719)
- Personaliza el estilo del polígono y las etiquetas
- Haz clic en "Crear Polígono"

**Pestaña 3: Segmentador**
- Selecciona una capa de polígono existente
- Haz clic en "Segmentar Polígono"
- Se crearán dos nuevas capas:
  - **Segmentos:** Líneas con longitud y azimut
  - **Vértices:** Puntos con coordenadas, ángulos internos y externos

**Pestaña 4: Exportar a Excel**
- Selecciona la capa vectorial que deseas exportar
- Opcionalmente, especifica una ubicación personalizada
- Haz clic en "Exportar a Excel"
- Elige si deseas abrir el archivo automáticamente

### Estructura de Datos de Salida

| Capa | Atributos Generados |
|------|---------------------|
| **Polígonos** | ID, ÁREA (ha), PERÍMETRO (m) |
| **Segmentos** | ID, Longitud, Azimut (0-360°) |
| **Vértices** | ID, Lado (V-n a V-m), Este, Norte, Distancia, Azimut, Ángulo Interno, Ángulo Externo |

### Requisitos
- **QGIS 3.30** o superior
- **Python 3.9+** (incluido en QGIS)
- Librerías: `PyQt5`, `pandas`, `qgis.core`

---

## 🛠️ Troubleshooting / Solución de Problemas

### Export button is disabled / El botón de exportación está deshabilitado
Make sure you have a vector layer selected in the layers panel.  
Asegúrate de tener una capa vectorial seleccionada en el panel de capas.

### Excel conversion error / Error al convertir Excel
Verify that the Excel file exists and is not corrupted.  
Verifica que el archivo Excel existe y no está corrupto.

### Polygon creation error / Error al crear polígono
- Verify that the CSV contains the specified columns / Verifica que el CSV contiene las columnas especificadas
- Ensure you have at least 3 valid points / Asegúrate de tener al menos 3 puntos válidos
- Check that coordinates are numeric / Verifica que las coordenadas son numéricas

### Segmentation error / Error al segmentar
- Make sure the layer is a polygon type / Asegúrate de que la capa es de tipo polígono
- Verify that the polygon has a valid geometry / Verifica que el polígono tiene una geometría válida
- Use the "Refresh" button if the layer doesn't appear / Usa el botón "Actualizar" si la capa no aparece

---

## 👤 Author / Autor

**Yuri Caller**
- 📧 Email: [yuricaller@gmail.com](mailto:yuricaller@gmail.com)
- 💻 GitHub: [@yurifabian](https://github.com/yurifabian)

---

## 📄 License / Licencia

This project is licensed under the **GNU General Public License v2.0 or later (GPL-2.0-or-later)**.  
Este proyecto está bajo la **Licencia Pública General GNU v2.0 o posterior (GPL-2.0-or-later)**.

See the [LICENSE](LICENSE) file for details.  
Consulta el archivo [LICENSE](LICENSE) para más detalles.

---

## 🤝 Contributing / Contribuciones

Found a bug or have a suggestion? / ¿Encontraste un bug o tienes una sugerencia?

- Report issues at: https://github.com/yurifabian/YF_Tools_Plus/issues
- Contribute with pull requests / Contribuye con pull requests

---

## 📚 Changelog / Historial de Versiones

### v2.0 (2026-01-15)
- ✅ Fusion of YF_Tools and Export to Excel / Fusión de YF_Tools y Export to Excel
- ✅ Unified interface with tabs / Interfaz unificada con pestañas
- ✅ Quick export to Excel with one click / Exportación rápida a Excel con un clic
- ✅ Internal and external angle calculation in segmentator / Cálculo de ángulos internos y externos
- ✅ Improved layer management / Mejoras en la gestión de capas
- ✅ Persistent configuration saving / Guardado de configuración persistente

---

⭐ **If you find this plugin useful, give it a star on GitHub!**  
⭐ **¡Si te resulta útil este plugin, dale una estrella en GitHub!**