# Changelog

All notable changes to the GoToXY QGIS Plugin will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [1.1.0] - 2025-08-20

### Added
- Toggle labels functionality with dedicated button
- Coordinate history tracking (last 10 locations)
- Professional new icon with crosshair and grid design
- Enhanced point styling with red markers and white outlines
- Layer-based CRS selection
- Improved dialog sizing (500x550 pixels)
- Dynamic field compatibility for existing layers
- Robust error handling for different QGIS versions

### Changed
- Limited CRS support to EPSG:4326 and EPSG:3857 only
- Completely redesigned user interface with grouped sections
- Improved button layout with grid organization
- Enhanced coordinate input validation
- Better user feedback messages
- Updated metadata format for QGIS repository compliance

### Fixed
- Metadata syntax errors causing "broken plugin" status
- Attribute mismatch errors when adding to existing layers
- Label placement enum compatibility across QGIS versions
- Dialog size issues hiding interface elements
- Qt import compatibility issues

### Technical
- Added try-catch blocks for enum compatibility
- Implemented dynamic attribute building
- Enhanced field checking for layer compatibility
- Improved code organization and documentation

## [1.0.0] - 2025-08-04

### Added
- Initial release of GoToXY plugin
- Basic coordinate navigation functionality
- Point marker creation
- Support for multiple CRS (EPSG:28191, EPSG:4326, EPSG:2039)
- Simple user interface
- Basic error handling

### Features
- Navigate to X,Y coordinates
- Add point markers at specified locations
- CRS selection dropdown
- Project CRS integration
- Basic coordinate transformation

## [Unreleased]

### Planned
- Coordinate format validation (DMS, UTM, etc.)
- Batch coordinate processing
- Export coordinate history
- Custom point symbols
- Coordinate precision settings
- Multi-language support
- Integration with GPS devices

---

## Version History Summary

| Version | Date | Key Features |
|---------|------|--------------|
| 1.1.0 | 2025-08-20 | Toggle labels, history, new UI, bug fixes |
| 1.0.0 | 2025-08-04 | Initial release with basic functionality |

## Migration Notes

### From 1.0.0 to 1.1.0
- Existing "GoToXY Points" layers will be automatically updated with label field
- CRS list reduced from 3 to 2 options (removed EPSG:28191 and EPSG:2039)
- Dialog size increased - may appear in different position
- No data loss or compatibility issues expected

## Known Issues

### Resolved in 1.1.0
- ✅ Plugin showing as "broken" in plugin manager
- ✅ Attribute mismatch errors with existing layers
- ✅ Label placement enum errors
- ✅ Dialog size too small for all elements
- ✅ Missing toggle labels functionality

### Current Issues
- None known at this time

## Support Information

For issues related to specific versions:
- **Version 1.1.0+**: Report on [GitHub Issues](https://github.com/rawan-na/gotoxy-qgis-plugin/issues)
- **Version 1.0.0**: Upgrade to latest version recommended

## Development Notes

### Version 1.1.0 Development
- Complete UI redesign using Qt Designer
- Enhanced error handling with fallback mechanisms
- Improved code documentation and structure
- Comprehensive testing across QGIS versions
- Professional icon design and branding

