# -*- coding: utf-8 -*-
"""
/***************************************************************************
 walidatorPlikowGML
                                 A QGIS plugin
 Walidator plików GML baz BDOT10k, PRNG, GESUT, EGiB, BDOT500
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2022-12-23
        git sha              : $Format:%H$
        copyright            : (C) 2022 by Marcin Lebiecki - Główny Urząd Geodezji i Kartografii
        email                : marcin.lebiecki@gugik.gov.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
import lxml
import os, subprocess
import zipfile
import pathlib
import pandas as pd
import re
import xml.etree.ElementTree as et
from lxml.etree import parse, XMLSchema
from lxml import etree # TODO
import matplotlib.pyplot
import time
import xlwt
import osgeo
from osgeo import ogr,osr
from osgeo import gdal
from qgis.PyQt.QtCore import *
from qgis.core import *
from qgis.core import QgsVectorFileWriter, QgsVectorLayer # TODO
from qgis.gui import *
from qgis.utils import *
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication
from qgis.PyQt.QtGui import *
from qgis.PyQt.QtWidgets import QAction
from qgis.PyQt.QtWidgets import QFileDialog, QProgressBar, QMessageBox
from .resources import *
from .walidatorPlikowGML_dialog import walidatorPlikowGMLDialog
from osgeo_utils.samples import ogr2ogr
from .utils import *


class walidatorPlikowGML:

    def __init__(self, iface):
        self.iface = iface
        self.plugin_dir = os.path.dirname(__file__)
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(self.plugin_dir,'i18n','walidatorPlikowGML_{}.qm'.format(locale))
        
        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)
            
        self.actions = []
        self.menu = self.tr(u'&Walidator plików GML')
        self.first_start = None
        
        os.environ['QT_AUTO_SCREEN_SCALE_FACTOR'] = '1'
        
        global mainPath, config, dlg
        
        mainPath = pathlib.Path(QgsApplication.qgisSettingsDirPath())/pathlib.Path("python/plugins/Walidator_plikow_gml/")
        
        config = configparser.ConfigParser()
        config.read(str(mainPath)+'/Walidator_plikow_gml.ini')


    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        return QCoreApplication.translate('walidatorPlikowGML', message)


    def add_action(self,icon_path,text,callback,enabled_flag=True,add_to_menu=True,add_to_toolbar=True,status_tip=None,whats_this=None,parent=None):
        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)
        if status_tip is not None:
            action.setStatusTip(status_tip)
            
        if whats_this is not None:
            action.setWhatsThis(whats_this)
            
        if add_to_toolbar:
            self.iface.addToolBarIcon(action)
            
        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)
        self.actions.append(action)
        return action


    def initGui(self):
        icon_path = ':/plugins/walidatorPlikowGML/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'walidatorPlikowGML'),
            callback=self.run,
            parent=self.iface.mainWindow())

        self.first_start = True


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&Walidator plików GML'),
                action)
            self.iface.removeToolBarIcon(action)


    def run(self):
        global xsdPaths, szablonKontroliPaths
        walidowanaBaza = ['EGIB','GESUT','BDOT500','RCN','PRNG','BDOT10k','BDOO']
        formatRaportu = ['xls','txt']
        xsdPaths = {'BDOO':"/XSD/BDOT10kBDOO/BDOT10k_BDOO.xsd",
                    'BDOT10k':"/XSD/BDOT10kBDOO/BDOT10k_BDOO.xsd",
                    'PRNG':"/XSD/PRNG/NG_PRNG.xsd",
                    'BDOT500':"/XSD/BDOT500/BDOT500_1.3tech.xsd",
                    'GESUT':"/XSD/GESUT/GESUT_1.3tech.xsd",
                    'EGIB':"/XSD/EGIB/EGIB_1.8.xsd",
                    'RCN':"/XSD/RCN/RCN_1.4.xsd"
                   }
        
        szablonKontroliPaths = {'BDOO':"/SzablonyKontroli/BDOO/SK_BDOO_1.0.0.xml",
                                'BDOT10k':"/SzablonyKontroli/BDOT10k/SK_BDOT10k_1.0.0.xml",
                                'PRNG':"/SzablonyKontroli/PRNG/SK_PRNG_1.0.0.xml",
                                'BDOT500':"/SzablonyKontroli/BDOT500/SK_BDOT500_1.0.0.xml",
                                'GESUT':"/SzablonyKontroli/GESUT/SK_GESUT_1.0.0.xml",
                                'EGIB':"/SzablonyKontroli/EGIB/SK_EGIB_1.0.0.xml",
                                'RCN':"/SzablonyKontroli/RCN/SK_RCN_1.0.0.xml"
                               }
        
        self.dlg = walidatorPlikowGMLDialog()
        
        self.dlg.comboBox.addItems(walidowanaBaza)
        self.dlg.comboBox_2.addItems(formatRaportu)
        self.dlg.pushButton_1.clicked.connect(self.zaznaczWszystkieKontrole)
        self.dlg.pushButton_2.clicked.connect(self.odznaczWszystkieKontrole)
        self.walidacjaIKontrolaAtrybutow()


    # wskazanie pliku i zlecenie walidacji
    def walidacjaIKontrolaAtrybutow(self):
        global pliki, sciezkaGML, files, plik, path, plikRaportu, walidacjaZWynikiemPozytywnym, xmlschema, formatPlikuRaportu, dataFrame
        global walidowanePliki_df, wiersze_df, opisyBledow_df, komunikatyBledow_df, szablonKontroliPath, mainGroup
        global kontrolowanePliki_df, klasy_df, lokalneId_df, komunikatyBledowKontroli_df, plikiZparsowane, czyGrupaDodana
        global liczbaKontroliDoWykonania, progress, liczbaKontroliWykonanych
        
        sciezkaGML_ini = config['UstawieniaOgolne']['sciezkagml']
        plik = QFileDialog.getOpenFileNames(self.dlg,"Wskaż plik z danymi do walidacji",sciezkaGML_ini,"Plik GML (*.gml);;Plik XML (*.xml);;Plik skompresowany (*.zip)")
        
        try:
            sciezkaGML = str(pathlib.Path(plik[0][0]).parent)
            nazwa_pliku = pathlib.Path(plik[0][0]).name[:-4]
            if sciezkaGML != sciezkaGML_ini:
                config.set('UstawieniaOgolne', 'sciezkagml', sciezkaGML)
                with open(str(mainPath)+'/Walidator_plikow_gml.ini', 'w') as configfile:
                    config.write(configfile)
        except Exception as inst:
            if inst.args[0] == 13:
                self.iface.messageBar().pushMessage("Uwaga!", inst.args[1], level=Qgis.Critical)
            else:
                pass
            return
        
        if plik[1] == 'Plik skompresowany (*.zip)':
            try:
                plikZIP = zipfile.ZipFile(plik[0][0],'r') 
            except:
                self.iface.messageBar().pushMessage("Uwaga!", "Niepoprawny plik zip.", level=Qgis.Critical)
                return
            
            files = plikZIP.namelist()
            
            if len(files): # jeżeli jest kilka plików to łączy ich nazwy do wyszukania frazy
                nazwaPlikuLubPlikow = ''.join(files)
        else:
            files = plik[0]
            nazwaPlikuLubPlikow = pathlib.Path(files[0]).name
        
        if re.search('OT_|BDOT10',str(nazwaPlikuLubPlikow).upper()) != None:
            self.dlg.comboBox.setCurrentIndex(self.dlg.comboBox.findText('BDOT10k'))
        elif re.search('BDOT500',str(nazwaPlikuLubPlikow).upper()) != None:
            self.dlg.comboBox.setCurrentIndex(self.dlg.comboBox.findText('BDOT500'))
        elif re.search('GESUT',str(nazwaPlikuLubPlikow).upper()) != None:
            self.dlg.comboBox.setCurrentIndex(self.dlg.comboBox.findText('GESUT'))
        else:
            self.dlg.comboBox.setCurrentIndex(self.dlg.comboBox.findText('EGIB'))
        
        self.dlg.comboBox.currentIndexChanged.connect(self.wczytanieSzablonuKontroli)
        self.wczytanieSzablonuKontroli()
        
        self.dlg.show()
        result = self.dlg.exec_()
        formatPlikuRaportu = None
        
        if result:
            self.iface.messageBar().pushMessage("Walidacja pliku " + str(pathlib.Path(plik[0][0]).name) + " rozpoczęta ...", level=Qgis.Info)
            QCoreApplication.processEvents()
            
            timestr = time.strftime("%Y-%m-%d_%H.%M")
            
            if self.dlg.comboBox_2.currentText() == 'txt':
                path = sciezkaGML + "/RaportBledow_" + str(nazwa_pliku) + "_" + timestr + ".txt"
                formatPlikuRaportu = "txt"
            else:
                path = sciezkaGML + "/RaportBledow_" + str(nazwa_pliku) + "_" + timestr + ".xls"
                formatPlikuRaportu = "xls"
            try:
                if os.path.isfile(path):
                    os.remove(path)
            except:
                self.iface.messageBar().pushMessage("Uwaga!", "Plik raportu jest otwarty. Proszę o zamknięcie pliku.", level=Qgis.Critical)
                return
        else:
            if formatPlikuRaportu == 'txt':
                plikRaportu.close() 
            return
        
        try:
            if formatPlikuRaportu == 'txt':
                plikRaportu = open(path,"a", encoding='utf-8')
        except:
            self.iface.messageBar().pushMessage("Uwaga!", "Brak uprawnień do zapisu raportu.", level=Qgis.Critical)
            return
        
        pliki = []
        plikiZparsowane = []
        walidowanePliki_df = []
        wiersze_df = []
        opisyBledow_df = []
        komunikatyBledow_df = []
        
        kontrolowanePliki_df = []
        klasy_df = []
        lokalneId_df = []
        komunikatyBledowKontroli_df = []
        
        i = 0
        walidacjaZWynikiemPozytywnym = True
        kontrolaZWynikiemPozytywnym = True
        namespace = self.dlg.comboBox.currentText()
        mainGroup = os.path.splitext(os.path.basename(plik[0][0]))[0]
        
        try:
            xsdPath = parse(str(mainPath) + xsdPaths[namespace])
            szablonKontroliPath = parse(str(mainPath) + szablonKontroliPaths[namespace])
        except:
            self.iface.messageBar().pushMessage("Uwaga!", "Brak dostępu do pliku XSD.", level=Qgis.Critical)
            return
        
        try:
            xmlschema = XMLSchema(xsdPath)
        except:
            self.iface.messageBar().pushMessage("Uwaga!", "Brak dostępu do internetu.", level=Qgis.Critical)
            return
        
        for file in files:
            if plik[1] == 'Plik skompresowany (*.zip)':
                try:
                    plikGML = plikZIP.extract(file)
                except:
                   self.iface.messageBar().pushMessage("Uwaga!", "Problem z rozpakowaniem pliku zip.", level=Qgis.Critical)
                   return 
            else:
                plikGML = file
            if plikGML[-3:] in ['xml','gml','XML','GML']:
                pliki.append(plikGML)
                task = QgsTask.fromFunction(str(i), self.walidacja, on_finished=self.wynikiWalidacji, flags=QgsTask.CanCancel)
                QgsApplication.taskManager().addTask(task)
                while QgsApplication.taskManager().countActiveTasks() > 0:
                    QCoreApplication.processEvents()
                while task.status() not in [QgsTask.Complete, QgsTask.Terminated]:
                    QCoreApplication.processEvents()
                i += 1
        
        czyGrupaDodana = False
        if not walidacjaZWynikiemPozytywnym:
            msgBox = QMessageBox()
            msgBox.setText("W pliku gml występują błędy zgodności ze schematem aplikacyjnym i dlatego dalsze kontrole atrybutowe i geometryczne mogą się nie wykonać poprawnie - czy chcesz  kontynuować?")
            msgBox.setStandardButtons(QMessageBox.Yes | QMessageBox.No)
            odp = msgBox.exec() 
        else:
            odp = 0
        
        if odp == 16384 or odp == 0:
            
            liczbaKontroliDoWykonania = 0
            liczbaKontroliWykonanych = 0
            
            # sprawdzenie liczby kontroli do wykonania
            for i in range(modelKontroli.rowCount()):
                parent = modelKontroli.item(i)
                if parent.checkState() in (1,2):
                    for j in range(parent.rowCount()):
                        if parent.child(j).checkState() == 2:
                            liczbaKontroliDoWykonania += 1
            
            QCoreApplication.processEvents()
            progressMessageBar = iface.messageBar().createMessage("Postęp wykonania kontroli atrybutów")
            progress = QProgressBar()
            progress.setMaximum(liczbaKontroliDoWykonania)
            progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
            progressMessageBar.layout().addWidget(progress)
            iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)
            
            for plikZparsowany in plikiZparsowane:
                self.kontrolaAtrybutow(plikZparsowany)
                
        if formatPlikuRaportu == 'txt':
            if len(kontrolowanePliki_df) > 0:
                plikRaportu.write('------------------------------------------------ KONTROLE ATRYBUTÓW ------------------------------------------------\n')
            for i in range(len(kontrolowanePliki_df)):
                opisBledu = 'KONTROLOWANY PLIK: ' + kontrolowanePliki_df[i] + ', KLASA: ' + klasy_df[i] + ', LOKALNYID: ' + lokalneId_df[i] + ', KOMUNIKAT BŁĘDU: ' + komunikatyBledowKontroli_df[i] + '\n'
                plikRaportu.write(opisBledu)
        else:
            bledyWalidacji = {'WALIDOWANY PLIK': walidowanePliki_df, 'WIERSZ': wiersze_df, 'OPIS BŁĘDU': opisyBledow_df, 'KOMUNIKAT BŁĘDU': komunikatyBledow_df}
            bledyKontroli = {'KONTROLOWANY PLIK':kontrolowanePliki_df, 'KLASA':klasy_df, 'LOKALNYID':lokalneId_df, 'KOMUNIKAT BŁĘDU':komunikatyBledowKontroli_df}
            if len(bledyWalidacji["WIERSZ"]) == 0:
                bledyWalidacji["WIERSZ"] = 0
            dataFrameWalidacja= pd.DataFrame(bledyWalidacji)
            dataFrameKontrola= pd.DataFrame(bledyKontroli)
            try:
                strony = xlwt.Workbook()
                arkuszWalidacji = strony.add_sheet('Raport z walidacji')
                arkuszKontroli = strony.add_sheet('Raport z kontroli atrybutów')
                styl1 = xlwt.easyxf('align: wrap on;  borders: left thin, right thin, top thin, bottom thin')
                styl2 = xlwt.easyxf("align: horz center, vert center; font: bold on; align: wrap on; borders: left thin, right thin, top thin, bottom thin")
                arkuszWalidacji.write(0,0,"WALIDOWANY PLIK", styl2) 
                arkuszWalidacji.write(0,1,"WIERSZ", styl2)
                arkuszWalidacji.write(0,2,"OPIS BŁĘDU", styl2)
                arkuszWalidacji.write(0,3,"KOMUNIKAT BŁĘDU", styl2)
                arkuszWalidacji.col(0).width = 12500
                arkuszWalidacji.col(1).width = 2000
                arkuszWalidacji.col(2).width = 22500
                arkuszWalidacji.col(3).width = 22500
                
                arkuszKontroli.write(0,0,"KONTROLOWANY PLIK", styl2) 
                arkuszKontroli.write(0,1,"KLASA", styl2)
                arkuszKontroli.write(0,2,"LOKALNYID", styl2)
                arkuszKontroli.write(0,3,"KOMUNIKAT BŁĘDU", styl2)
                arkuszKontroli.col(0).width = 12000
                arkuszKontroli.col(1).width = 8000
                arkuszKontroli.col(2).width = 12500
                arkuszKontroli.col(3).width = 20000
                for i, row in enumerate(dataFrameWalidacja.values):
                    for j, val in enumerate(row):
                        arkuszWalidacji.write(i + 1, j, str(val), styl1) 
                for i, row in enumerate(dataFrameKontrola.values):
                    kontrolaZWynikiemPozytywnym = False
                    for j, val in enumerate(row):
                        arkuszKontroli.write(i + 1, j, str(val), styl1)
                strony.save(path)
            except:
                self.iface.messageBar().pushMessage("Uwaga!", "Brak uprawnień do zapisu raportu.", level=Qgis.Critical)
                return
        
        if walidacjaZWynikiemPozytywnym and kontrolaZWynikiemPozytywnym:
            self.iface.messageBar().pushMessage("Walidacja pliku " + str(pathlib.Path(plik[0][0]).name) + " zakończona z wynikiem pozytywnym.", Qgis.Success, 0)
        else:
            if walidacjaZWynikiemPozytywnym == False and kontrolaZWynikiemPozytywnym == False:
                msg = "Walidacja i kontrola atrybutów zakończona z wynikiem negatywnym: "
            elif walidacjaZWynikiemPozytywnym == False:
                msg = "Walidacja pliku zakończona z wynikiem negatywnym: "
            else:
                msg = "Kontrola atrybutów zakończona z wynikiem negatywnym: "
            widget = iface.messageBar().createMessage(msg, str(pathlib.Path(plik[0][0]).name))
            
            button = QPushButton(widget)
            button.setText("Raport z walidacji")
            button.pressed.connect(self.otwarcieRaportuZWalidacji)
            widget.layout().addWidget(button)
            self.iface.messageBar().pushWidget(widget, Qgis.Warning)
        
        if formatPlikuRaportu == 'txt':
            plikRaportu.close()
        else:
            pass


    # walidacja pliku GML z conajmniej jednym obiektem
    def walidacja(self, task):
        global walidacjaZWynikiemPozytywnym, plikiZparsowane
        plikGML = pliki[int(task.description())]
        try:
            walidowanyPlik = lxml.etree.parse(plikGML)
            plikiZparsowane.append(plikGML) # przechowujemy pliki, które są na tyle dobre by wykonać ew. kontrole atrybutowe
            
            ns = {'bt': 'urn:gugik:specyfikacje:gmlas:modelPodstawowy:1.0'}
            try:
                if walidowanyPlik.xpath('//*[namespace-uri()="%s"]' % ns['bt'], namespaces=ns):
                    raise OSError("Plik nie jest zgodny z obowiązującym schematem aplikacyjnym GML - z plikiem XSD. Plik wykorzystuje przestrzeń nazw Modelu Podstawowego, która była wykorzystywana w schematach aplikacyjnych przed 2021 rokiem.")
            except:
                pass
            
            root = walidowanyPlik.getroot()
            
            if root != None:
                wynikWalidacji = xmlschema.validate(walidowanyPlik)
                if not wynikWalidacji:
                    walidacjaZWynikiemPozytywnym = False
                    return {'taskID':task.description(), 'plikGML':plikGML, 'error':xmlschema.error_log}
        except lxml.etree.XMLSyntaxError as error:
            walidacjaZWynikiemPozytywnym = False
            return {'taskID':task.description(), 'plikGML':plikGML, 'error':error}
        except OSError as error:
            walidacjaZWynikiemPozytywnym = False
            return {'taskID':task.description(), 'plikGML':plikGML, 'error':error}


    # zapisanie logów błędów walidacji do pliku; komunikat z przyciskiem pobrania raportu
    def wynikiWalidacji(self, exception=None, value=None):
        global walidowanePliki_df, wiersze_df, opisyBledow_df, komunikatyBledow_df
        
        frazy = {"The value":"Wartość",
                 "failed to load external entity":"nie udało się załadować",
                 "Error reading file":"Błąd odczytu pliku",
                 "is not an element of the set":"nie znajduje się na liście",
                 "This element is not expected":"Ten element jest nieoczekiwany",
                 "Expected is one of":"Oczekiwana jest jedna wartość z ", 
                 "Expected is":"Oczekiwany jest ",
                 "is not a valid value of the atomic type":"jest nieprawidłową wartością typu podstawowego",
                 "is not a valid value of the list type \'{http://www.opengis.net/gml/3.2}doubleList\'":" jest nieprawidłową wartością typu listowego \'{http://www.opengis.net/gml/3.2}doubleList\'",
                 "Opening and ending tag mismatch":"Błędny otwierający lub zamykający znacznik",
                 "line":"linia",
                 "and":"i",
                 "Start tag expected":"Oczekiwany tag początkowy",
                 "huge text node":"ogromny węzeł tekstowy",
                 "Point":"Punkt",
                 "column":"kolumna",
                 "is not a valid value of the union type":"jest nieprawdłową wartością typu unia",
                 "is less than the minimum value allowed":"jest mniejsza niż minimalna dozwolona wartość",
                 "Missing child element(s)":"Brakuje elementów dziecka/dzieci",
                 "EndTag":"Znacznik zamykający",
                 "must be greater than":"musi być większa niż",
                 "is not accepted by the pattern":"nie jest zgodna z paternem",
                 "is greater than the maximum value allowed":"jest większa niż maksymalna dozwolona liczba",
                 "not found": "nie został znaleziony",
                 "is not a valid value of the local atomic type":"nie jest poprawną wartością lokalnego typu podstawowego"
                 }
        if value != None:
            if  isinstance(value['error'], lxml.etree.XMLSyntaxError):
                opisBledu = str(value['error'])
                for key in frazy:
                    opisBledu = opisBledu.replace(key,frazy[key])
                msg = 'Błąd w składni pliku XML: ' + str(value['plikGML']) + '\n' + \
                      '- komunikat błędu: ' + opisBledu + '\n\n'
                if formatPlikuRaportu == 'txt':
                    plikRaportu.write(msg)
                else:
                    walidowanePliki_df.append(str(value['plikGML']))
                    wiersze_df.append("-")
                    opisyBledow_df.append("Błąd w składni pliku XML")
                    komunikatyBledow_df.append(opisBledu)
            elif isinstance(value['error'], lxml.etree._ListErrorLog):
                for i in range(len(value['error'])):
                    opisBledu = value['error'][i].message
                    for key in frazy:
                        opisBledu = opisBledu.replace(key,frazy[key]) # tłumaczenie
                    msg = 'Walidacja pliku: ' + str(value['plikGML']) + ' z wynikiem negatywnym.\n' + \
                          '- ' + config['KodyWalidacji'][value['error'][i].type_name] + '\n' + \
                          '- wiersz: ' + str(value['error'][i].line) + '\n' + \
                          '- komunikat błędu: ' + opisBledu + '\n\n'
                    if formatPlikuRaportu == 'txt':
                        plikRaportu.write(msg)
                    else:
                        walidowanePliki_df.append(str(value['plikGML']))
                        wiersze_df.append(str(value['error'][i].line))
                        opisyBledow_df.append(config['KodyWalidacji'][value['error'][i].type_name])
                        komunikatyBledow_df.append(opisBledu)
            elif isinstance(value['error'], OSError):
                opisBledu = str(value['error'])
                for key in frazy:
                    opisBledu = opisBledu.replace(key,frazy[key]) # tłumaczenie
                if formatPlikuRaportu == 'txt':
                    plikRaportu.write(opisBledu)
                else:
                    walidowanePliki_df.append(str(value['plikGML']))
                    wiersze_df.append("-")
                    opisyBledow_df.append("-")
                    komunikatyBledow_df.append(opisBledu)


    # otwarcie pliku raportu
    def otwarcieRaportuZWalidacji(self):
        if os.path.isfile(path):
            try:
                os.startfile(path, 'open') # Windows
            except:
                subprocess.call(('open', path)) # macOS


    # import plików GML do QGIS
    def importGML(self, zparsowanyPlik):
        global group
        gdal.SetConfigOption('GML_ATTRIBUTES_TO_OGR_FIELDS', 'YES')
        root = QgsProject.instance().layerTreeRoot()
        typyGeometrii = { 0: 'Geometry',
                          1: 'Point',
                          2: 'LineString',
                          3: 'Polygon',
                          4: 'MultiPoint',
                          5: 'MultiLineString',
                          6: 'MultiPolygon',
                          9: 'CompoundCurve',
                          10: 'CurvePolygon',
                          11: 'MultiCurve',
                          12: 'MultiSurface',
                          13: 'Curve',
                          100: 'No Geometry'}
        
        warstwy = [x.GetName() for x in ogr.Open(zparsowanyPlik)]
        data_source = ogr.Open(zparsowanyPlik)
        
        typGeometriiWarstw = [x.GetGeomType() for x in ogr.Open(zparsowanyPlik)]
        
        localGroup = os.path.splitext(os.path.basename(zparsowanyPlik))[0]
        if plik[1] == 'Plik skompresowany (*.zip)':
            group = groupaGlowna.addGroup(localGroup)
        else:
            group = QgsProject.instance().layerTreeRoot().addGroup(localGroup)
        group.setExpanded(False)
        
        for warstwa, feature_geom in zip(warstwy, typGeometriiWarstw):
            if feature_geom == 100: # brak geometrii
                qgis_layer = QgsVectorLayer(zparsowanyPlik + "|layername=" + warstwa, str(pathlib.Path(zparsowanyPlik).name)[:-4] + '_' + warstwa, 'ogr')
                QgsProject.instance().addMapLayer(qgis_layer, False)
                group.addLayer(qgis_layer)
                qgis_layer = None
            elif feature_geom == 0: # GeometryPropertyType
                
                tablica_typow_geometrii = [1,2,3]
                if warstwa in ['EGB_ObrebEwidencyjny','EGB_Budynek','EGB_JednostkaEwidencyjna', # EGiB
                               'OT_Ogrodzenia','OT_BudynekNiewykazanyWEGIB', # BDOT500
                               'NG_NazwaGeograficznaSwiata','NG_NazwaGeograficznaRP' # PRNG
                              ]:
                    tablica_typow_geometrii = [4,5,6]
                    
                for typGeometryPropertyType in tablica_typow_geometrii:
                    qgis_layer = QgsVectorLayer(zparsowanyPlik + "|layername=" + warstwa + "|geometrytype=" + typyGeometrii[typGeometryPropertyType], str(pathlib.Path(zparsowanyPlik).name)[:-4] + '_' + warstwa, 'ogr')
                    if qgis_layer.featureCount() > 0:
                        QgsProject.instance().addMapLayer(qgis_layer, False)
                        group.addLayer(qgis_layer)
                        qgis_layer = None
            else:
                qgis_layer = QgsVectorLayer(zparsowanyPlik + "|layername=" + warstwa + "|geometrytype=" + typyGeometrii[feature_geom], str(pathlib.Path(zparsowanyPlik).name)[:-4] + '_' + warstwa, 'ogr')
                if qgis_layer.featureCount() > 0:
                    QgsProject.instance().addMapLayer(qgis_layer, False)
                    group.addLayer(qgis_layer)
                    qgis_layer = None


    # wczytanie szablonu kontroli
    def wczytanieSzablonuKontroli(self):
        global modelKontroli
        
        szablonKontroliPath = str(mainPath) + szablonKontroliPaths.get(self.dlg.comboBox.currentText())
        tree = et.parse(szablonKontroliPath)
        root = tree.getroot()
        wersjaSzablonuKontroli = root.get('version')
        self.dlg.label_17.setText('Wersja szablonu: ' + str(wersjaSzablonuKontroli))
        modelKontroli = QStandardItemModel()
        modelKontroli.setHorizontalHeaderLabels(['Lista kontroli'])
        self.dlg.treeView.setModel(modelKontroli)
        self.dlg.treeView.setUniformRowHeights(True)

        i = 0
        for grupaKontroli in root:
            parent = QStandardItem(grupaKontroli.get('name')) 
            modelKontroli.appendRow(parent)
            parent.setCheckable(True)
            parent.setCheckState(0)
            for kontrola in grupaKontroli:
                child = QStandardItem(kontrola.get('name'))
                child.setData(kontrola.get('id'), 1)
                child.setData(kontrola.get('name'), 2)
                child.setData(kontrola.get('class'), 3)
                child.setData(kontrola.get('errorPhrase'), 4)
                for k in kontrola:
                    child.setData(k.get('typ'), 5)
                    child.setData(k.get('sql'), 6)
                child.setData(kontrola.get('class2'), 7)
                child.setData(kontrola.get('joinFieldName'), 8)
                child.setData(kontrola.get('targetFieldName'), 9)
                child.setData(kontrola.get('joinFieldNamesSubset'), 11)
                child.setCheckable(True)
                child.setCheckState(0)
                parent.appendRow([child])
            self.dlg.treeView.setFirstColumnSpanned(i, self.dlg.treeView.rootIndex(), True)
            i += 1
        modelKontroli.itemChanged.connect(self.zmianaStatusuKontroli)


    def zaznaczWszystkieKontrole(self):
        for i in range(modelKontroli.rowCount()):
            item = modelKontroli.item(i)
            if item.checkState() in (0,1):
                item.setCheckState(2)
    
    
    def odznaczWszystkieKontrole(self):
        for i in range(modelKontroli.rowCount()):
            item = modelKontroli.item(i)
            if item.checkState() in (1,2):
                item.setCheckState(0)


    def zmianaStatusuKontroli(self, item):
        statusParent = item.checkState() 
        if item.rowCount() > 0:
            for j in range(item.rowCount()):
                statusChild = item.child(j).checkState()
                if statusParent == 2:
                    item.child(j).setCheckState(2)
                if statusParent == 0:
                    item.child(j).setCheckState(0)
        else:
            suma = 0
            for j in range(item.parent().rowCount()):
                suma += item.parent().child(j).checkState()
            if suma == 0:
                item.parent().setCheckState(0)
            elif suma == item.parent().rowCount() * 2:
                item.parent().setCheckState(2)
            else:
                item.parent().setCheckState(1)


    # kontrola atrybutów
    def kontrolaAtrybutow(self, zparsowanyPlik):
        global liczbaKontroliWykonanych, liczbaKontroliDoWykonania, czyGrupaDodana, groupaGlowna, progress
        
        # jeżeli są kontrole do wykonania to wykonanie importu plików GML do QGIS
        if liczbaKontroliDoWykonania > 0:
            if czyGrupaDodana == False and plik[1] == 'Plik skompresowany (*.zip)':
                root = QgsProject.instance().layerTreeRoot()
                czyGrupaDodana = True
                groupaGlowna = root.addGroup(mainGroup)
                groupaGlowna.setExpanded(False)
            
            QCoreApplication.processEvents()
            QgsMessageLog.logMessage("Import pliku " + str(pathlib.Path(zparsowanyPlik).name) + " do QGIS ...", level=Qgis.Info)
            QCoreApplication.processEvents()
            self.importGML(zparsowanyPlik)
        else:
            return
        
        geometryType = {0:'Point',1:'Line',2:'Polygon'}
        
        for i in range(modelKontroli.rowCount()):
            parent = modelKontroli.item(i)
            if parent.checkState() in (1,2):
                for j in range(parent.rowCount()):
                    if parent.child(j).checkState() == 2 and parent.child(j).data(1) != '' and parent.child(j).data(2) != '' and \
                        parent.child(j).data(3) != '' and  parent.child(j).data(4) != '' and \
                        parent.child(j).data(5) in ('QgsExpression','QgsExpressionWithJoin','pythonFunction') and parent.child(j).data(6) != '':
                        errorPhrase = parent.child(j).data(4)
                        sqltxt = parent.child(j).data(6)
                        sqltxt = sqltxt.replace("&gt;",">")
                        sqltxt = sqltxt.replace("&lt;","<")
                        klasa = parent.child(j).data(3)
                        teryt = str(pathlib.Path(zparsowanyPlik).name)[:-15][-4:]
                        nazwaWarstwyJ1 = str(pathlib.Path(zparsowanyPlik).name)[:-4] + '_' + klasa
                        try:
                            for warstwaWsqltext in re.findall(r"layer:='(.*?)'", sqltxt):
                                sqltxt = sqltxt.replace("layer:='" + warstwaWsqltext,"layer:='" + str(pathlib.Path(zparsowanyPlik).name)[:-13] + warstwaWsqltext + '_' + warstwaWsqltext)
                        except:
                            pass
                        try:
                            layerL1 = None
                            layerL1 = QgsProject().instance().mapLayersByName(nazwaWarstwyJ1)[0]
                        except:
                            pass
                        if parent.child(j).data(5) in ('QgsExpression','QgsExpressionWithJoin','pythonFunction') and layerL1 != None:
                               request = QgsFeatureRequest(QgsExpression(sqltxt))
                               
                               # join dwóch warstw
                               if parent.child(j).data(7) != None and parent.child(j).data(8) != None and parent.child(j).data(9) != None and parent.child(j).data(11) != None:
                                   klasa2 = parent.child(j).data(7)
                                   warstwa_w_memory_nazwa = str(pathlib.Path(zparsowanyPlik).name)[:-4] + '_' + klasa + "_" + klasa2
                                   
                                   #czy jest warstwa złączonych warstw
                                   if len(QgsProject().instance().mapLayersByName(warstwa_w_memory_nazwa)) == 0:
                                       nazwaWarstwyJ2 = str(pathlib.Path(zparsowanyPlik).name)[:-4] + '_' + klasa2
                                       layerL2 = QgsProject().instance().mapLayersByName(nazwaWarstwyJ2)[0]
                                       joinFieldName = parent.child(j).data(8)
                                       targetFieldName = parent.child(j).data(9)
                                       joinFieldNamesSubset = parent.child(j).data(11).split(",")
                                       noweAtrybuty = {}
                                       
                                       definicje_pol = layerL1.fields()
                                       
                                       for nowyAtrybut in joinFieldNamesSubset:
                                           pole_lista = QgsField(klasa2 + '_' + nowyAtrybut, 11)
                                           definicje_pol.append(pole_lista)
                                           
                                       warstwa_w_memory = QgsVectorLayer(geometryType[layerL1.geometryType()] + "?crs=" + layerL1.crs().authid(), warstwa_w_memory_nazwa, "memory")
                                       warstwa_w_memory.dataProvider().addAttributes(definicje_pol)
                                       warstwa_w_memory.updateFields()
                                       QgsProject.instance().addMapLayer(warstwa_w_memory, False)
                                       group.addLayer(warstwa_w_memory)
                                       warstwa_w_memory.startEditing()
                                       
                                       for feature1 in layerL1.getFeatures():
                                           nowyRekord = QgsFeature(definicje_pol)
                                           nowyRekord.setGeometry(feature1.geometry())
                                           
                                           # dodaje wartoci atrybutów klasy
                                           for attr in feature1.fields():
                                               fieldIdx = warstwa_w_memory.fields().indexFromName(attr.name())
                                               nowyRekord.setAttribute(fieldIdx, QVariant(feature1[attr.name()]))
                                        
                                           # join
                                           for nowyAtrybut in joinFieldNamesSubset:
                                               noweAtrybuty[nowyAtrybut] = []
                                           for x in feature1[joinFieldName]:
                                               for feature2 in layerL2.getFeatures():
                                                   if x == feature2[targetFieldName]:
                                                       for nowyAtrybut in joinFieldNamesSubset:
                                                           noweAtrybuty[nowyAtrybut].append(feature2[nowyAtrybut])
                                                           
                                           for nowyAtrybut in joinFieldNamesSubset:
                                               fieldIdx = warstwa_w_memory.fields().indexFromName(klasa2 + '_' + nowyAtrybut)
                                               nowyRekord.setAttribute(fieldIdx, QVariant(noweAtrybuty[nowyAtrybut]))
                                               
                                           warstwa_w_memory.addFeature(nowyRekord)
                                           warstwa_w_memory.updateFeature(nowyRekord)
                                           
                                       warstwa_w_memory.commitChanges()
                                       
                                   # zmiana nazwy klasy
                                   klasa = klasa + "_" + klasa2
                               try:
                                   nazwaWarstwy = str(pathlib.Path(zparsowanyPlik).name)[:-4] + '_' + klasa
                                   for i in range(len(QgsProject().instance().mapLayersByName(nazwaWarstwy))):
                                       layer = QgsProject().instance().mapLayersByName(nazwaWarstwy)[i]
                                       
                                       if parent.child(j).data(5) in ('QgsExpression','QgsExpressionWithJoin'):
                                           requestFeatures = layer.getFeatures(request)
                                       else:
                                           layerTMP = QgsProject().instance().mapLayersByName(nazwaWarstwyJ1)
                                           if sqltxt.count('(teryt)') > 0:
                                               requestFeatures = globals().get(sqltxt.replace('(teryt)',''))(layerTMP[0], teryt)
                                           else:
                                               requestFeatures = globals().get(sqltxt)(layerTMP[0])
                                           
                                       selected_features = []  # lista z wybranymi obiektami
                                       for feature in requestFeatures:
                                           kontrolowanePliki_df.append(str(pathlib.Path(zparsowanyPlik).name))
                                           klasy_df.append(klasa)
                                           lokalneId_df.append(feature['lokalnyId'])
                                           komunikatyBledowKontroli_df.append(errorPhrase)
                               except Exception as e:
                                   print(f'Błąd : {e}')
                               liczbaKontroliWykonanych += 1
                               progress.setValue(liczbaKontroliWykonanych)
                               QCoreApplication.processEvents()