# -*- coding: utf-8 -*-
"""
/***************************************************************************
 viperDialog
                                 A QGIS plugin
 Snake clone using vector layers and QGIS canvas
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2024-05-11
        git sha              : $Format:%H$
        copyright            : (C) 2024 by Viper MiniQ
        email                : viperminiq@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os

from qgis.PyQt import uic
from qgis.PyQt.QtWidgets import QMessageBox, QDockWidget

from qgis.PyQt.QtCore import Qt
from qgis.PyQt.QtGui import QColor

from qgis.core import (
    QgsApplication,
    QgsVectorLayer, 
    QgsFeature, 
    QgsGeometry, 
    QgsPointXY, 
    QgsProject
)

from . import viper_game

from qgis.utils import iface


KEY_SHORTCUTS = {
        '': '',
        'A': 'A',
        'B': 'B',
        'C': 'C',
        'D': 'D',
        'E': 'E',
        'F': 'F',
        'G': 'G',
        'H': 'H',
        'I': 'I',
        'J': 'J',
        'K': 'K',
        'L': 'L',
        'M': 'M',
        'N': 'N',
        'O': 'O',
        'P': 'P',
        'Q': 'Q',
        'R': 'R',
        'S': 'S',
        'T': 'T',
        'U': 'U',
        'V': 'V',
        'W': 'W',
        'X': 'X',
        'Y': 'Y',
        'Z': 'Z',
        '0': '0',
        '1': '1',
        '2': '2',
        '3': '3',
        '4': '4',
        '5': '5',
        '6': '6',
        '7': '7',
        '8': '8',
        '9': '9',
        'Arrow Up': Qt.Key_Up,
        'Arrow Down': Qt.Key_Down,
        'Arrow Left': Qt.Key_Left,
        'Arrow Right': Qt.Key_Right,
    }


game = None


# This loads your .ui file so that PyQt can populate your plugin with the elements from Qt Designer
FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'viper_dialog_base.ui'))


class viperDialog(QDockWidget, FORM_CLASS):
    def __init__(self, parent=None):
        """Constructor."""
        super(viperDialog, self).__init__(parent)
        # Set up the user interface from Designer through FORM_CLASS.
        # After self.setupUi() you can access any designer object by doing
        # self.<objectname>, and you can use autoconnect slots - see
        # http://qt-project.org/doc/qt-4.8/designer-using-a-ui-file.html
        # #widgets-and-dialogs-with-auto-connect
        self.setupUi(self)
        
        self.pushButtonPause.setStyleSheet("background-color: yellow")
        self.pushButtonStart.setStyleSheet("background-color: green")
        
        self.comboBoxMoveUp.addItems(KEY_SHORTCUTS.keys())
        self.comboBoxMoveDown.addItems(KEY_SHORTCUTS.keys())
        self.comboBoxMoveLeft.addItems(KEY_SHORTCUTS.keys())
        self.comboBoxMoveRight.addItems(KEY_SHORTCUTS.keys())
        self.comboBoxPause.addItems(KEY_SHORTCUTS.keys())
        
        self.comboBoxMoveLeft.setCurrentText('Arrow Left')
        self.comboBoxMoveRight.setCurrentText('Arrow Right')
        self.comboBoxMoveUp.setCurrentText('Arrow Up')
        self.comboBoxMoveDown.setCurrentText('Arrow Down')
        self.comboBoxPause.setCurrentText('P')
        
        self.pushButtonStart.clicked.connect(self.start_game)

    def get_selected_layer_polygon_geometry(self):
        geometry = None
        
        active_layer = iface.activeLayer()
        
        if isinstance(active_layer, QgsVectorLayer):
            selected_features = active_layer.selectedFeatures()
            if selected_features:
                first_feature = selected_features[0]
                if first_feature.hasGeometry():
                    geometry = first_feature.geometry()
                    if geometry.isGeosValid():
                        geometry = selected_features[0].geometry()
        
        return geometry
    
    def get_selected_layer_crs_authid(self):
        crs_authid = None
        
        active_layer = iface.activeLayer()
        
        if isinstance(active_layer, QgsVectorLayer):
            crs_authid = active_layer.crs().authid()
        
        return crs_authid
    
    def create_new_play_area_feature(self):
        area_width = self.doubleSpinBoxPlayAreaWidth.value()
        area_height = self.doubleSpinBoxPlayAreaHeight.value()
        
        play_area_feature = QgsFeature()
        play_area_feature.setGeometry(QgsGeometry.fromPolygonXY([[
            QgsPointXY(0, 0), 
            QgsPointXY(area_width, 0), 
            QgsPointXY(area_width, area_height), 
            QgsPointXY(0, area_height)
        ]]))
        
        return play_area_feature
    
    def create_new_play_area_layer(self, epsg: str, qgsfeature: QgsFeature):
        area_layer = QgsVectorLayer(
            f"Polygon?crs={epsg}",
            "Area",
            "memory"
        )
        area_layer.dataProvider().addFeatures([qgsfeature])
        
        return area_layer
        
    def create_new_snake_layer(self, epsg: str):
        return QgsVectorLayer(f"Polygon?crs={epsg}", "Snake", "memory")
    
    def create_new_food_layer(self, epsg: str):
        return QgsVectorLayer(f"Polygon?crs={epsg}", "Food", "memory")
    
    def set_layer_solid_color(self, layer: QgsVectorLayer, r: int, b: int, g: int):
        layer.renderer().symbol().setColor(QColor(r, b, g))
        
    def refresh_button_shortcuts(self):
        self.pushButtonMoveDown.setShortcut(KEY_SHORTCUTS[self.comboBoxMoveDown.currentText()])
        self.pushButtonMoveUp.setShortcut(KEY_SHORTCUTS[self.comboBoxMoveUp.currentText()])
        self.pushButtonMoveLeft.setShortcut(KEY_SHORTCUTS[self.comboBoxMoveLeft.currentText()])
        self.pushButtonMoveRight.setShortcut(KEY_SHORTCUTS[self.comboBoxMoveRight.currentText()])
        self.pushButtonPause.setShortcut(KEY_SHORTCUTS[self.comboBoxPause.currentText()])
        
    def check_correct_button_shortcuts(self):
        shortcuts = [
            KEY_SHORTCUTS[self.comboBoxMoveDown.currentText()],
            KEY_SHORTCUTS[self.comboBoxMoveUp.currentText()],
            KEY_SHORTCUTS[self.comboBoxMoveLeft.currentText()],
            KEY_SHORTCUTS[self.comboBoxMoveRight.currentText()],
            KEY_SHORTCUTS[self.comboBoxPause.currentText()]
        ]
        
        if '' in shortcuts:
            return False
        
        if len(set(shortcuts)) != len(shortcuts):
            return False
        
        return True
    
    def show_incorrect_shortcut_error(self):
        error_dialog = QMessageBox()
        error_dialog.setText(str("Button shortcuts must not be empty or duplicated!"))
        error_dialog.setWindowTitle('Viper: Shortcuts error')
        error_dialog.setStandardButtons(QMessageBox.Ok)
        error_dialog.exec()
        
    def start_game(self):
        global game
        
        if game is not None:
            try:
                if game.isActive():
                    return
            except RuntimeError:  # if the game object was deleted, just continue
                pass
        
        if not self.check_correct_button_shortcuts():
            self.show_incorrect_shortcut_error()
            return
        
        self.refresh_button_shortcuts()
        
        play_area_feature = None
        epsg = "EPSG:3857"
        
        if self.checkBoxUseExistingLayer.isChecked():
            play_area_geometry = self.get_selected_layer_polygon_geometry()
            
            play_area_feature = QgsFeature()
            play_area_feature.setGeometry(play_area_geometry)
            
            epsg = self.get_selected_layer_crs_authid() if play_area_geometry is not None else 3857
        
        play_area_layer = self.create_new_play_area_layer(
            epsg, 
            self.create_new_play_area_feature() if play_area_feature is None else play_area_feature
        )
        snake_layer = self.create_new_snake_layer(epsg)
        food_layer = self.create_new_food_layer(epsg)
        
        self.set_layer_solid_color(play_area_layer, 255, 255, 255)
        self.set_layer_solid_color(snake_layer, 1, 150, 32)
        self.set_layer_solid_color(food_layer, 200, 0, 0)
        
        root = QgsProject.instance().layerTreeRoot()
        game_group = root.insertGroup(0, "Viper")
        
        QgsProject.instance().addMapLayer(snake_layer, False)
        QgsProject.instance().addMapLayer(food_layer, False)
        QgsProject.instance().addMapLayer(play_area_layer, False)
        
        game_group.insertLayer(0, snake_layer)
        game_group.insertLayer(1, food_layer)
        game_group.insertLayer(2, play_area_layer)
        
        iface.setActiveLayer(play_area_layer)
        iface.zoomToActiveLayer()
        
        game = viper_game.ViperMain(
            btn_up=self.pushButtonMoveUp,
            btn_down=self.pushButtonMoveDown,
            btn_left=self.pushButtonMoveLeft,
            btn_right=self.pushButtonMoveRight,
            btn_pause=self.pushButtonPause,
            refresh_rate=self.doubleSpinBoxRefreshRate.value(),
            time_limit=self.doubleSpinBoxTimeLimit.value(),
            snake_width=self.doubleSpinBoxSnakeWidth.value(),
            play_area_layer=play_area_layer,
            snake_layer=snake_layer,
            food_layer=food_layer,
            prepare_food=self.checkBoxPrepareFood.isChecked(),
        )
        
        QgsApplication.taskManager().addTask(game)
    