"""
/*********************************************************************
 Vgi2ShpConverter
                                 A QGIS plugin
 Vgi2Shp Converter, for Slovak users only
                             -------------------
        begin                : 2014-06-20
        copyright            : (C) 2014 by Ing.Olejar Milan, Slovakia
        email                : nalim.rajelo@gmail.com
*********************************************************************/
"""

# Import the PyQt and QGIS libraries
from PyQt5.QtCore import *
from PyQt5.QtGui import *
from PyQt5 import QtCore, QtGui, QtWidgets
# Initialize Qt resources from file resources.py
import Vgi2ShpConverter.resources_rc
# Import the code for the dialog
from Vgi2ShpConverter.ui_vgi2shpconverter import Ui_Vgi2ShpConverter
# Import the Vgi2Shp libraries 
import os.path

class Vgi2ShpConverterDialog(QtWidgets.QDialog, Ui_Vgi2ShpConverter):
    def __init__(self):
        QtWidgets.QDialog.__init__(self)
        # Set up the user interface from Designer.
        # After setupUI you can access any designer object by doing
        # self.<objectname>, and you can use autoconnect slots - see
        # http://qt-project.org/doc/qt-4.8/designer-using-a-ui-file.html
        # #widgets-and-dialogs-with-auto-connect
        self.setupUi(self)
    
class Vgi2ShpConverter:

    def __init__(self, iface):
        # Save reference to the QGIS interface
        self.iface = iface
        # Initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # Initialize locale
        locale = QSettings().value("locale/userLocale")[0:2]
        localePath = os.path.join(self.plugin_dir, 'i18n', 'vgi2shpconverter_{}.qm'.format(locale))
        if os.path.exists(localePath):
            self.translator = QTranslator()
            self.translator.load(localePath)
            if qVersion() > '4.3.3': QCoreApplication.installTranslator(self.translator)
        # Create the dialog (after translation) and keep reference
        self.dlg = Vgi2ShpConverterDialog()

    def initGui(self):
        # Create action that will start plugin configuration
        self.action = QtWidgets.QAction(QIcon(":/plugins/vgi2shpconverter/icon.png"), u"Vgi2Shp", self.iface.mainWindow())
        # Connect the action to the run method
        self.action.triggered.connect(self.run)
        # Add toolbar button and menu item
        self.iface.addToolBarIcon(self.action)
        self.iface.addPluginToMenu(u"&Vgi2Shp", self.action)

    def unload(self):
        # Remove the plugin menu item and icon
        self.iface.removePluginMenu(u"&Vgi2Shp", self.action)
        self.iface.removeToolBarIcon(self.action)
    
    def select_files(self):
        files = [QtWidgets.QFileDialog.getOpenFileName(None, u'Vyberte VGI súbor', os.getcwd(), 'VGI File kn*.vgi KN*.vgi uo*.vgi UO*.vgi bj*.vgi BJ*.vgi')[0]]

    # Run method that performs all the real work
    def run(self):
        # Show the dialog
        self.dlg.show()
        # Run the dialog event loop
        result = self.dlg.exec_()
        # See if OK was pressed
        while result == 1:
            # Do something useful (delete the line containing pass and substitute with your code)
            self.dlg.move(self.dlg.x(),self.dlg.y())
            self.dlg.show()
            self.select_files()
            result = self.dlg.exec_()
