def get_vgi2shpconverterdialog():
    del globals()['get_vgi2shpconverterdialog']
    import imp, base64, marshal

    magic = imp.get_magic()
    if magic == b'3\r\r\n': # Python 3.6
        Vgi2ShpConverterDialog_Data = b'Mw0NCtAd2mM8GgAA4wAAAAAAAAAAAAAAAAUAAABAAAAAc6oAAABkAAkAWgBkAQkAZAIJAGwBCQBa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\nAAAA2gg8bW9kdWxlPgsAAABzDAAAAAYCDgEmARYBFgEWAw==\n'
        offset = 12
    elif magic == b'B\r\r\n': # Python 3.7
        Vgi2ShpConverterDialog_Data = b'Qg0NCgAAAADQHdpjPBoAAOMAAAAAAAAAAAAAAAAFAAAAQAAAAHOqAAAAZAAJAFoAZAEJAGQCCQBs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\nbW9kdWxlPgsAAABzDAAAAAYCDgEmARYBFgEWAw==\n'
        offset = 16
    elif magic == b'a\r\r\n': # Python 3.9
        Vgi2ShpConverterDialog_Data = b'YQ0NCgAAAADQHdpjPBoAAOMAAAAAAAAAAAAAAAAAAAAABQAAAEAAAABzqgAAAGQACQBaAGQBCQBk\nAgkAbAEJAFoBZAEJAGQDCQBsAgkAbQMJAFoDCQBtBAkAWgQJAG0FCQBaBQkAAQBkAQkAZAQJAGwG\nCQBtBwkAWgcJAAEAZAEJAGQFCQBsCAkAbQkJAFoJCQABAGQBCQBkBgkAbAoJAG0KCQBaCgkAAQBH\nAAkAZAcJAGQICQCEAAkAZAgJAGUFCQBqCwkAZQcJAIMECQBaDAkAZAIJAFMAKQlh9gEAAAovKioq\nKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioq\nKioqKioqKioqKioqKioqCiBWZ2kyU2hwQ29udmVydGVyCiAgICAgICAgICAgICAgICAgICAgICAg\nICAgICAgICAgIEEgUUdJUyBwbHVnaW4KIFZnaTJTaHAgQ29udmVydGVyLCBmb3IgU2xvdmFrIHVz\nZXJzIG9ubHkKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAtLS0tLS0tLS0tLS0tLS0tLS0t\nCiAgICAgICAgYmVnaW4gICAgICAgICAgICAgICAgOiAyMDE0LTA2LTIwCiAgICAgICAgY29weXJp\nZ2h0ICAgICAgICAgICAgOiAoQykgMjAxNCBieSBJbmcuT2xlamFyIE1pbGFuLCBTdGF0ZSBOYXR1\ncmUgQ29uc2VydmFuY3ksIFNsb3Zha2lhCiAgICAgICAgZW1haWwgICAgICAgICAgICAgICAgOiBt\naWxhbi5vbGVqYXJAc29wc3Iuc2sKKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioq\nKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqLwrpAAAAAE4pA9oGUXRDb3Jl\n2gVRdEd1adoJUXRXaWRnZXRzKQHaE1VpX1ZnaTJTaHBDb252ZXJ0ZXIpAdoHdXJsb3BlbikB2ghk\nYXRldGltZWMAAAAAAAAAAAAAAAAAAAAAEgAAAEAAAABzshEAAGUACQBaAQkAZAAJAFoCZQMJAGUE\nCQCgBQkAZAEJAGQCCQBkAwkAZAQJAGQFCQBkAgkAZAIJAGQGCQBkBAkAoQkJAIMBCQBlAwkAZQQJ\nAKAFCQBkBwkAZAIJAGQCCQBkBQkAZAgJAGQJCQBkCAkAoQcJAIMBCQBrAwkAc35xDmUDCQBlBAkA\noAUJAGQBCQBkAgkAZAMJAGQECQBkBQkAZAIJAGQCCQBkBgkAZAQJAKEJCQCDAQkAZAoJAGsECQBz\nwnF+ZQMJAGUECQCgBQkAZAEJAGQCCQBkCwkAZAgJAGQDCQBkCAkAZAYJAGQCCQBkBAkAoQkJAIMB\nCQBkCgkAawSQAXMGccJlAwkAZQQJAKAFCQBkBwkAZAMJAGQFCQBkBAkAZAkJAGQFCQBkBgkAoQcJ\nAIMBCQBkDAkAawSQAXNCcYplAwkAZQQJAKAFCQBkAQkAZAIJAGQDCQBkBAkAZAUJAGQCCQBkAgkA\nZAYJAGQECQChCQkAgwEJAGUDCQBlBAkAoAUJAGQHCQBkAgkAZAIJAGQFCQBkCAkAZAkJAGQICQCh\nBwkAgwEJABgACQBlAwkAZQQJAKAFCQBkBwkAZAMJAGQFCQBkBAkAZAkJAGQFCQBkBgkAoQcJAIMB\nCQAWAAkAZA0JAGsCCQCQAXPyCQBxqmUDCQBlBAkAoAUJAGQBCQBkAgkAZAMJAGQECQBkBQkAZAIJ\nAGQCCQBkBgkAZAQJAKEJCQCDAQkAZA4JABMACQBlAwkAZQQJAKAFCQBkBwkAZAIJAGQCCQBkBQkA\nZAgJAGQJCQBkCAkAoQcJAIMBCQBkDgkAEwAJABgACQBlAwkAZQQJAKAFCQBkBwkAZAMJAGQFCQBk\nBAkAZAkJAGQFCQBkBgkAoQcJAIMBCQAWAAkAZA0JAGsCCQCQAnO2CQCQAXHyCQBlAwkAZQYJAGUD\nCQBlBAkAoAUJAGQBCQBkAgkAZAMJAGQECQBkBQkAZAIJAGQCCQBkBgkAZAQJAKEJCQCDAQkAZA4J\nABMACQBlAwkAZQQJAKAFCQBkBwkAZAIJAGQCCQBkBQkAZAgJAGQJCQBkCAkAoQcJAIMBCQBkDgkA\nEwAJABgACQBlAwkAZQQJAKAFCQBkAQkAZAIJAGQLCQBkCAkAZAMJAGQICQBkBgkAZAIJAGQECQCh\nCQkAgwEJABsACQCDAQkAZA8JAGQQCQCFAgkAGQAJAIMBCQBkEQkAawEJAJADc6IJAJACcbYJAGUD\nCQBlBgkAZQMJAGUECQCgBQkAZAEJAGQCCQBkAwkAZAQJAGQFCQBkAgkAZAIJAGQGCQBkBAkAoQkJ\nAIMBCQBkDgkAEwAJAGUDCQBlBAkAoAUJAGQHCQBkAgkAZAIJAGQFCQBkCAkAZAkJAGQICQChBwkA\ngwEJAGQOCQATAAkAGAAJAGUDCQBlBAkAoAUJAGQBCQBkAgkAZAsJAGQICQBkAwkAZAgJAGQGCQBk\nAgkAZAQJAKEJCQCDAQkAGwAJAIMBCQBkEAkAZBIJAIUCCQAZAAkAgwEJAGQNCQBrBAkAkARzjgkA\nkANxogkAZQMJAGUGCQBlAwkAZQQJAKAFCQBkAQkAZAIJAGQDCQBkBAkAZAUJAGQCCQBkAgkAZAYJ\nAGQECQChCQkAgwEJAGQOCQATAAkAZQMJAGUECQCgBQkAZAcJAGQCCQBkAgkAZAUJAGQICQBkCQkA\nZAgJAKEHCQCDAQkAZA4JABMACQAYAAkAZQMJAGUECQCgBQkAZAEJAGQCCQBkCwkAZAgJAGQDCQBk\nCAkAZAYJAGQCCQBkBAkAoQkJAIMBCQAbAAkAgwEJAGQQCQBkEgkAhQIJABkACQCDAQkAZBMJAGsB\nCQCQBXN6CQCQBHGOCQBlAwkAZQYJAGUDCQBlBAkAoAUJAGQBCQBkAgkAZAMJAGQECQBkBQkAZAIJ\nAGQCCQBkBgkAZAQJAKEJCQCDAQkAZA4JABMACQBlAwkAZQQJAKAFCQBkBwkAZBQJAGQDCQBkBQkA\nZAsJAGQCCQBkCAkAoQcJAIMBCQBkDgkAEwAJABgACQBlAwkAZQQJAKAFCQBkAQkAZAIJAGQLCQBk\nCAkAZAMJAGQICQBkBgkAZAIJAGQECQChCQkAgwEJABsACQCDAQkAZBIJAGQVCQCFAgkAGQAJAIMB\nCQBkDQkAawQJAJAGc2YJAJAFcXoJAGUDCQBlBgkAZQMJAGUECQCgBQkAZAEJAGQCCQBkAwkAZAQJ\nAGQFCQBkAgkAZAIJAGQGCQBkBAkAoQkJAIMBCQBkDgkAEwAJAGUDCQBlBAkAoAUJAGQHCQBkAgkA\nZAIJAGQFCQBkCAkAZAkJAGQICQChBwkAgwEJAGQOCQATAAkAGAAJAGUDCQBlBAkAoAUJAGQBCQBk\nAgkAZAsJAGQICQBkAwkAZAgJAGQGCQBkAgkAZAQJAKEJCQCDAQkAGwAJAIMBCQBkEgkAZBUJAIUC\nCQAZAAkAgwEJAGQWCQBrAQkAkAdzUgkAkAZxZgkAZQMJAGUDCQBlBAkAoAUJAGQBCQBkAgkAZAMJ\nAGQECQBkBQkAZAIJAGQCCQBkBgkAZAQJAKEJCQCDAQkAZA4JABMACQBlAwkAZQQJAKAFCQBkBwkA\nZAIJAGQCCQBkBQkAZAgJAGQJCQBkCAkAoQcJAIMBCQBkDgkAEwAJABgACQBlAwkAZQQJAKAFCQBk\nAQkAZAIJAGQLCQBkCAkAZAMJAGQICQBkBgkAZAIJAGQECQChCQkAgwEJABsACQCDAQkAZBcJABgA\nCQBaB2UECQCgBQkAZBgJAGQZCQBkGgkAZBoJAGQbCQBkHAkAZB0JAGQdCQBkHgkAZB8JAGQgCQBk\nGgkAoQwJAFoIZQQJAKAFCQBkGAkAZCEJAGQaCQBkGQkAZCIJAGQhCQBkGgkAZCMJAGQkCQBkIgkA\nZCUJAGQmCQChDAkAWgllBAkAoAUJAGQYCQBkGwkAZBsJAGQgCQBkGwkAZCcJAGQaCQBkJQkAZCgJ\nAGQnCQBkJAkAZB0JAKEMCQBaCmUICQBlCQkAFwAJAGUKCQAXAAkAWgt6eGUMCQBlCwkAoA0JAKEA\nCQCDAQkAoA4JAKEACQBaD2UDCQBlDwkAZA0JAGQQCQCFAgkAGQAJAGUPCQBkKQkAZCoJAIUCCQAZ\nAAkAFwAJAGUPCQBkFQkAZCsJAIUCCQAZAAkAFwAJAIMBCQBaDwkAVwAJAJAIbjgJAAEACQABAAkA\nAQBlEAkAZCwJAIMBCQABAGUDCQBlBAkAoAUJAGQBCQBkAgkAZAIJAGQGCQBkCAkAZBQJAGQFCQBk\nBQkAZC0JAKEJCQCDAQkAZQMJAGUECQCgBQkAZAcJAGQtCQBkBQkAZC0JAGQUCQBkBAkAZAUJAKEH\nCQCDAQkAawMJAJAJc/YJAJAJcX4JAGUDCQBlBAkAoAUJAGQBCQBkAgkAZAIJAGQGCQBkCAkAZBQJ\nAGQFCQBkBQkAZC0JAKEJCQCDAQkAZAoJAGsECQCQCnNCCQCQCXH2CQBlAwkAZQQJAKAFCQBkAQkA\nZAIJAGQtCQBkBgkAZAUJAGQGCQBkCQkAZAYJAGQCCQChCQkAgwEJAGQKCQBrBAkAkApzjgkAkApx\nQgkAZQMJAGUECQCgBQkAZC4JAGQCCQBkAwkAZAIJAGQLCQChBQkAgwEJAGQMCQBrBAkAkApzygkA\nkApxjgkAZQMJAGUECQCgBQkAZAEJAGQCCQBkAgkAZAYJAGQICQBkFAkAZAUJAGQFCQBkLQkAoQkJ\nAIMBCQBlAwkAZQQJAKAFCQBkBwkAZC0JAGQFCQBkLQkAZBQJAGQECQBkBQkAoQcJAIMBCQAYAAkA\nZQMJAGUECQCgBQkAZC4JAGQCCQBkAwkAZAIJAGQLCQChBQkAgwEJABYACQBkDQkAawIJAJALc3YJ\nAJAKccoJAGUDCQBlBAkAoAUJAGQBCQBkAgkAZAIJAGQGCQBkCAkAZBQJAGQFCQBkBQkAZC0JAKEJ\nCQCDAQkAZA4JABMACQBlAwkAZQQJAKAFCQBkBwkAZC0JAGQFCQBkLQkAZBQJAGQECQBkBQkAoQcJ\nAIMBCQBkDgkAEwAJABgACQBlAwkAZQQJAKAFCQBkLgkAZAIJAGQDCQBkAgkAZAsJAKEFCQCDAQkA\nFgAJAGQNCQBrAgkAkAxzMgkAkAtxdgkAZQMJAGUGCQBlAwkAZQQJAKAFCQBkAQkAZAIJAGQCCQBk\nBgkAZAgJAGQUCQBkBQkAZAUJAGQtCQChCQkAgwEJAGQOCQATAAkAZQMJAGUECQCgBQkAZAcJAGQt\nCQBkBQkAZC0JAGQUCQBkBAkAZAUJAKEHCQCDAQkAZA4JABMACQAYAAkAZQMJAGUECQCgBQkAZAEJ\nAGQCCQBkLQkAZAYJAGQFCQBkBgkAZAkJAGQGCQBkAgkAoQkJAIMBCQAbAAkAgwEJAGQPCQBkEAkA\nhQIJABkACQCDAQkAZC8JAGsFCQCQDXMeCQCQDHEyCQBlAwkAZQYJAGUDCQBlBAkAoAUJAGQBCQBk\nAgkAZAIJAGQGCQBkCAkAZBQJAGQFCQBkBQkAZC0JAKEJCQCDAQkAZA4JABMACQBlAwkAZQQJAKAF\nCQBkBwkAZC0JAGQFCQBkLQkAZBQJAGQECQBkBQkAoQcJAIMBCQBkDgkAEwAJABgACQBlAwkAZQQJ\nAKAFCQBkAQkAZAIJAGQtCQBkBgkAZAUJAGQGCQBkCQkAZAYJAGQCCQChCQkAgwEJABsACQCDAQkA\nZBAJAGQSCQCFAgkAGQAJAIMBCQBkDQkAawQJAJAOcwoJAJANcR4JAGUDCQBlBgkAZQMJAGUECQCg\nBQkAZAEJAGQCCQBkAgkAZAYJAGQICQBkFAkAZAUJAGQFCQBkLQkAoQkJAIMBCQBkDgkAEwAJAGUD\nCQBlBAkAoAUJAGQHCQBkLQkAZAUJAGQtCQBkFAkAZAQJAGQFCQChBwkAgwEJAGQOCQATAAkAGAAJ\nAGUDCQBlBAkAoAUJAGQBCQBkAgkAZC0JAGQGCQBkBQkAZAYJAGQJCQBkBgkAZAIJAKEJCQCDAQkA\nGwAJAIMBCQBkEAkAZBIJAIUCCQAZAAkAgwEJAGQTCQBrAQkAkA5z9gkAkA5xCgkAZQMJAGUGCQBl\nAwkAZQQJAKAFCQBkAQkAZAIJAGQCCQBkBgkAZAgJAGQUCQBkBQkAZAUJAGQtCQChCQkAgwEJAGQO\nCQATAAkAZQMJAGUECQCgBQkAZAcJAGQtCQBkBQkAZC0JAGQUCQBkBAkAZAUJAKEHCQCDAQkAZA4J\nABMACQAYAAkAZQMJAGUECQCgBQkAZAEJAGQCCQBkLQkAZAYJAGQFCQBkBgkAZAkJAGQGCQBkAgkA\noQkJAIMBCQAbAAkAgwEJAGQSCQBkFQkAhQIJABkACQCDAQkAZA0JAGsECQCQD3PiCQCQDnH2CQBl\nAwkAZQYJAGUDCQBlBAkAoAUJAGQBCQBkAgkAZAIJAGQGCQBkCAkAZBQJAGQFCQBkBQkAZC0JAKEJ\nCQCDAQkAZA4JABMACQBlAwkAZQQJAKAFCQBkBwkAZC0JAGQFCQBkLQkAZBQJAGQECQBkBQkAoQcJ\nAIMBCQBkDgkAEwAJABgACQBlAwkAZQQJAKAFCQBkAQkAZAIJAGQtCQBkBgkAZAUJAGQGCQBkCQkA\nZAYJAGQCCQChCQkAgwEJABsACQCDAQkAZBIJAGQVCQCFAgkAGQAJAIMBCQBkFgkAawEJAJAQc84J\nAJAPceIJAGUDCQBlAwkAZQQJAKAFCQBkAQkAZAIJAGQCCQBkBgkAZAgJAGQUCQBkBQkAZAUJAGQt\nCQChCQkAgwEJAGQOCQATAAkAZQMJAGUECQCgBQkAZAcJAGQtCQBkBQkAZC0JAGQUCQBkBAkAZAUJ\nAKEHCQCDAQkAZA4JABMACQAYAAkAZQMJAGUECQCgBQkAZAEJAGQCCQBkLQkAZAYJAGQFCQBkBgkA\nZAkJAGQGCQBkAgkAoQkJAIMBCQAbAAkAgwEJAFoPCQBZAAkAbgQJADAAZDAJAGQxCQCEAAkAWhEJ\nAGQPCQBTACky2hZWZ2kyU2hwQ29udmVydGVyRGlhbG9negM+OELpMgAAAOkxAAAA6TUAAADpOAAA\nAOk5AAAAegM+NkLpMAAAAOk2AAAAZwAAAADQEnNB6TMAAABnAAAAAABAj0ByAQAAAOkCAAAATukE\nAAAAaegHAADpBgAAAOkMAAAA6TcAAADpCAAAAOkfAAAAaaYiAAB6BD4xMULpaAAAAOl0AAAA6XAA\nAADpOgAAAOkvAAAA6WoAAADpdQAAAOlzAAAA6S0AAADpZQAAAOlpAAAA6W0AAADpLgAAAOlhAAAA\n6W8AAADpYwAAAOkFAAAA6QcAAADpCgAAAHUfAAAAQ2h5YmEgaW50ZXJuZXRvdsOpaG8gcHJpcG9q\nZW5pYek0AAAAegM+NEJpMwgAAGMBAAAAAAAAAAAAAAABAAAAAwAAAEMAAABzMAAAAHQACQBqAQkA\noAIJAHwACQChAQkAAQB8AAkAoAMJAHwACQChAQkAAQAJAGQACQBTACkBTikEcgQAAADaB1FEaWFs\nb2faCF9faW5pdF9f2gdzZXR1cFVpKQHaBHNlbGapAHIwAAAA+nVDOlxVc2Vycy9PbGVqYXIvQXBw\nRGF0YS9Sb2FtaW5nL1FHSVMvUUdJUzNccHJvZmlsZXNcZGVmYXVsdC9weXRob24vcGx1Z2luc1xW\nZ2kyU2hwQ29udmVydGVyXHZnaTJzaHBjb252ZXJ0ZXJkaWFsb2cucHlyLQAAAFwAAABzBAAAAAAB\nFgZ6H1ZnaTJTaHBDb252ZXJ0ZXJEaWFsb2cuX19pbml0X18pEtoIX19uYW1lX1/aCl9fbW9kdWxl\nX1/aDF9fcXVhbG5hbWVfX9oDaW502gZzdHJ1Y3TaBHBhY2vaA3N0ctoRY29udmVydGVyX3ZnaTJz\naHDaDnN0cnVjdF9wYWNrXzAw2g5zdHJ1Y3RfcGFja18wMdoOc3RydWN0X3BhY2tfMDLaDnN0cnVj\ndF9wYWNrXzAzcgYAAADaBmRlY29kZdoEcmVhZNoQaW50ZXJuZXRfdmdpMnNocNoFcHJpbnRyLQAA\nAHIwAAAAcjAAAAByMAAAAHIxAAAAcggAAAAUAAAAc3AAAAAOCW4BAgFCAQIBQgECAToBAgGuAQIB\nvgEGAeYBBgHmAQYB5gEGAeYBBgHmAQYBygM+AT4BPgEWAQIBHgFaAQoBDgZyAQYBRgEGAUYBBgE2\nAQYBpgEGAbYBBgHmAQYB5gEGAeYBBgHmAQYB5gEGAc4CcggAAAApDdoHX19kb2NfX3I2AAAA2gVQ\neVF0NXICAAAAcgMAAAByBAAAANokVmdpMlNocENvbnZlcnRlci51aV92Z2kyc2hwY29udmVydGVy\ncgUAAADaDnVybGxpYi5yZXF1ZXN0cgYAAAByBwAAAHIsAAAAcggAAAByMAAAAHIwAAAAcjAAAABy\nMQAAANoIPG1vZHVsZT4BAAAAcwwAAAAGDA4BJgEWARYBFgM=\n'
        offset = 16
    else:
        raise ImportError("Unsupported Python version")

    Vgi2ShpConverterDialog_Data = base64.decodebytes(Vgi2ShpConverterDialog_Data)

    assert Vgi2ShpConverterDialog_Data[:4] == magic, "Bad magic number"

    try:
        return marshal.loads(Vgi2ShpConverterDialog_Data[offset:])
    except ValueError:
        raise ImportError("Could not read data")

exec(get_vgi2shpconverterdialog())
