"""
/*********************************************************************
 Vgi2ShpConverter
                                 A QGIS plugin
 Vgi2Shp Converter, for Slovak users only
                             -------------------
        begin                : 2014-06-20
        copyright            : (C) 2014 by Ing.Olejar Milan, Slovakia
        email                : nalim.rajelo@gmail.com
*********************************************************************/
"""

# Import the PyQt and QGIS libraries
from PyQt5.QtCore import *
from PyQt5.QtGui import *
from PyQt5 import QtGui, QtWidgets
from qgis.core import *
# Initialize Qt resources from file resources.py
import Vgi2ShpConverter.resources_rc
# Import the code for the dialog
from Vgi2ShpConverter.vgi2shpconverterdialog import Vgi2ShpConverterDialog
# Import the Vgi2Shp libraries 
import os.path, struct, itertools, operator, re
from time import localtime
from math import sin, cos, pi, sqrt, asin, degrees
# Start Look Up
global look_up
    
class Vgi2ShpConverter:

    def __init__(self, iface):
        # Save reference to the QGIS interface
        self.iface = iface
        # Initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # Initialize locale
        locale = QSettings().value("locale/userLocale")[0:2]
        localePath = os.path.join(self.plugin_dir, 'i18n', 'vgi2shpconverter_{}.qm'.format(locale))
        if os.path.exists(localePath):
            self.translator = QTranslator()
            self.translator.load(localePath)
            if qVersion() > '4.3.3': QCoreApplication.installTranslator(self.translator)
        # Create the dialog (after translation) and keep reference
        self.dlg = Vgi2ShpConverterDialog()

    def initGui(self):
        # Create action that will start plugin configuration
        self.action = QtWidgets.QAction(QIcon(":/plugins/vgi2shpconverter/icon.png"), u"Vgi2Shp", self.iface.mainWindow())
        # Connect the action to the run method
        self.action.triggered.connect(self.run)
        # Add toolbar button and menu item
        self.iface.addToolBarIcon(self.action)
        self.iface.addPluginToMenu(u"&Vgi2Shp", self.action)

    def unload(self):
        # Remove the plugin menu item and icon
        self.iface.removePluginMenu(u"&Vgi2Shp", self.action)
        self.iface.removeToolBarIcon(self.action)
    
    def select_files(self):
        if operator.le(Vgi2ShpConverterDialog.internet_vgi2shp,Vgi2ShpConverterDialog.converter_vgi2shp): files = QtWidgets.QFileDialog.getOpenFileNames(None, u'Vyberte VGI súbor', os.getcwd(), 'VGI File kn*.vgi KN*.vgi uo*.vgi UO*.vgi bj*.vgi BJ*.vgi')[0]
        else: files = [QtWidgets.QFileDialog.getOpenFileName(None, u'Vyberte VGI súbor', os.getcwd(), 'VGI File kn*.vgi KN*.vgi uo*.vgi UO*.vgi bj*.vgi BJ*.vgi')[0]]

    # Rrun method that performs all the real work
    def run(self):
        # Show the dialog
        self.dlg.show()
        # Run the dialog event loop
        result = self.dlg.exec_()
        # See if OK was pressed
        while result == 1:
            # Do something useful (delete the line containing pass and substitute with your code)
            self.dlg.move(self.dlg.x(),self.dlg.y())
            self.dlg.show()
            self.select_files()
            result = self.dlg.exec_()
