def get_ui_vgi2shpconverter():
    del globals()['get_ui_vgi2shpconverter']
    import imp, base64, marshal

    magic = imp.get_magic()
    if magic == b'3\r\r\n': # Python 3.6
        Ui_Vgi2ShpConverter_Data = b'Mw0NCi+vQ15DDQAA4wAAAAAAAAAAAAAAABQAAABAAAAAcw4BAABkAAkAZAEJAGwACQBtAQkAWgEJ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\n2gg8bW9kdWxlPggAAABzGAAAACYBDgICARYBGgEaAwIBDgEWAhoBGgMeKw==\n'
        offset = 12
    elif magic == b'B\r\r\n': # Python 3.7
        Ui_Vgi2ShpConverter_Data = b'Qg0NCgAAAAAvr0NeQw0AAOMAAAAAAAAAAAAAAAAIAAAAQAAAAHMOAQAAZAAJAGQBCQBsAAkAbQEJ\nAFoBCQBtAgkAWgIJAG0DCQBaAwkAAQBkAAkAZAIJAGwECQBaBHkWZQEJAGoFCQBqBgkAWgcJAFcA\nCQBuNAQACQBlCAkAawoJAHJ+CQABAAkAAQAJAAEAZAMJAGQECQCEAAkAWgcJAFkACQBuBAkAWAB5\nJGUDCQBqCQkAagoJAFoLZAUJAGQGCQCEAAkAWgwJAFcACQBuNAQACQBlCAkAawoJAHLYCQABAAkA\nAQAJAAEAZAcJAGQGCQCEAAkAWgwJAFkACQBuBAkAWABHAAkAZAgJAGQJCQCEAAkAZAkJAGUNCQCD\nAwkAWg5kAAkAZAIJAGwPCQBaEAkAZAIJAFMAKQrpAAAAACkD2gZRdENvcmXaBVF0R3Vp2glRdFdp\nZGdldHNOYwEAAAAAAAAAAQAAAAEAAABDAAAAcwYAAAB8AAkAUwApAU6pACkB2gFzcgUAAAByBQAA\nAPpyQzovVXNlcnMvT2xlamFyL0FwcERhdGEvUm9hbWluZy9RR0lTL1FHSVMzXHByb2ZpbGVzXGRl\nZmF1bHQvcHl0aG9uL3BsdWdpbnNcVmdpMlNocENvbnZlcnRlclx1aV92Z2kyc2hwY29udmVydGVy\nLnB52glfZnJvbVV0ZjgOAAAAcwIAAAAAAXIIAAAAYwMAAAAAAAAAAwAAAAYAAABDAAAAcyIAAAB0\nAAkAagEJAKACCQB8AAkAfAEJAHwCCQB0AwkAoQQJAFMAKQFOKQRyBAAAANoMUUFwcGxpY2F0aW9u\n2gl0cmFuc2xhdGXaCV9lbmNvZGluZykD2gdjb250ZXh02gR0ZXh02ghkaXNhbWJpZ3IFAAAAcgUA\nAAByBwAAANoKX3RyYW5zbGF0ZRMAAABzAgAAAAABcg8AAABjAwAAAAAAAAADAAAABQAAAEMAAABz\nHgAAAHQACQBqAQkAoAIJAHwACQB8AQkAfAIJAKEDCQBTACkBTikDcgQAAAByCQAAAHIKAAAAKQNy\nDAAAAHINAAAAcg4AAAByBQAAAHIFAAAAcgcAAAByDwAAABYAAABzAgAAAAABYwAAAAAAAAAAAAAA\nAAIAAABAAAAAczIAAABlAAkAWgEJAGQACQBaAmQBCQBkAgkAhAAJAFoDZAMJAGQECQCEAAkAWgQJ\nAGQFCQBTACkG2hNVaV9WZ2kyU2hwQ29udmVydGVyYwIAAAAAAAAAAwAAAAgAAABDAAAAcxwDAAB8\nAQkAoAAJAHQBCQBkAQkAgwEJAKEBCQABAHwBCQCgAgkAZAIJAGQDCQChAgkAAQB0AwkAoAQJAHwB\nCQChAQkAfAAJAF8FfAAJAGoFCQCgBgkAdAcJAKAICQBkBAkAZAUJAGQGCQBkBwkAoQQJAKEBCQAB\nAHwACQBqBQkAoAAJAHQBCQBkCAkAgwEJAKEBCQABAHQDCQCgCQkAfAEJAKEBCQB8AAkAXwp8AAkA\nagoJAKAGCQB0BwkAoAgJAGQECQBkCQkAZAYJAGQKCQChBAkAoQEJAAEAfAAJAGoKCQCgCwkAdAEJ\nAGQLCQCDAQkAoQEJAAEAfAAJAGoKCQCgDAkAdA0JAKAOCQB0AQkAZAwJAIMBCQChAQkAoQEJAAEA\nfAAJAGoKCQCgAAkAdAEJAGQNCQCDAQkAoQEJAAEAdAMJAKAJCQB8AQkAoQEJAHwACQBfD3wACQBq\nDwkAoAYJAHQHCQCgCAkAZA4JAGQPCQBkDwkAZBAJAKEECQChAQkAAQB0DQkAoBAJAKEACQB9AnwC\nCQCgEQkAZBEJAKEBCQABAHwCCQCgEgkAZBIJAKEBCQABAHwCCQCgEwkAZBMJAKEBCQABAHwACQBq\nDwkAoBQJAHwCCQChAQkAAQB8AAkAag8JAKAACQB0AQkAZBQJAIMBCQChAQkAAQB0AwkAoAkJAHwB\nCQChAQkAfAAJAF8VfAAJAGoVCQCgBgkAdAcJAKAICQBkFQkAZA8JAGQWCQBkEAkAoQQJAKEBCQAB\nAHQNCQCgEAkAoQAJAH0CfAIJAKARCQBkEQkAoQEJAAEAfAAJAGoVCQCgFAkAfAIJAKEBCQABAHwA\nCQBqFQkAoBYJAHQHCQBqFwkAahgJAHQHCQBqFwkAahkJAEIACQB0BwkAahcJAGoaCQBCAAkAoQEJ\nAAEAfAAJAGoVCQCgAAkAdAEJAGQXCQCDAQkAoQEJAAEAfAAJAKAbCQB8AQkAoQEJAAEAfAAJAGoF\nCQBqHAkAoB0JAHwBCQBqHgkAoQEJAAEAdAcJAGofCQCgIAkAfAEJAKEBCQABAAkAZAAJAFMAKRhO\n2hBWZ2kyU2hwQ29udmVydGVy6fsAAADp3QAAAOkBAAAA6cMAAADp+AAAAOkZAAAA2gpwdXNoQnV0\ndG9ucgEAAADpuAAAANoAeik6L3BsdWdpbnMvdmdpMnNocGNvbnZlcnRlci92Z2kyc2hwXzk2LmJt\ncNoHbGFiZWxfMekFAAAA6bkAAADpCQAAAOkHAAAAVOlLAAAA2gdsYWJlbF8y6cEAAADpMgAAANoH\nbGFiZWxfMykh2g1zZXRPYmplY3ROYW1lcggAAADaBnJlc2l6ZXIEAAAA2gtRUHVzaEJ1dHRvbnIY\nAAAA2gtzZXRHZW9tZXRyeXICAAAA2gVRUmVjdNoGUUxhYmVschsAAADaB3NldFRleHTaCXNldFBp\neG1hcHIDAAAA2gdRUGl4bWFwciEAAADaBVFGb2502gxzZXRQb2ludFNpemXaB3NldEJvbGTaCXNl\ndFdlaWdodNoHc2V0Rm9udHIkAAAA2gxzZXRBbGlnbm1lbnTaAlF02gpBbGlnblJpZ2h02g1BbGln\nblRyYWlsaW5n2gxBbGlnblZDZW50ZXLaDXJldHJhbnNsYXRlVWnaB3ByZXNzZWTaB2Nvbm5lY3Ta\nBmFjY2VwdNoLUU1ldGFPYmplY3TaEmNvbm5lY3RTbG90c0J5TmFtZSkD2gRzZWxmchEAAADaBGZv\nbnRyBQAAAHIFAAAAcgcAAADaB3NldHVwVWkaAAAAczgAAAAAARoBFgEWAS4BHgEWAS4BHgEqAR4B\nFgIuAQ4BEgESARIBFgEeARYBLgEOARIBFgE+AR4CEgIeAXobVWlfVmdpMlNocENvbnZlcnRlci5z\nZXR1cFVpYwIAAAAAAAAAAgAAAAgAAABDAAAAc1gBAAB8AQkAoAAJAHQBCQBkAQkAZAIJAGQACQCD\nAwkAoQEJAAEAfAAJAGoCCQCgAwkAdAEJAGQBCQBkAwkAZAAJAIMDCQChAQkAAQB0BAkAoAUJAHwB\nCQBqBgkAfAEJAGoHCQChApABcip8AAkAaggJAKADCQB0AQkAZAEJAGQECQBkAAkAgwMJAKEBCQAB\nAHwACQBqCQkAoAMJAHQBCQBkAQkAdAoJAHwBCQBqBwkAgwEJAGQFCQBkAAkAhQIJABkACQBkBgkA\nFwAJAHQKCQB8AQkAagcJAIMBCQBkBwkAZAUJAIUCCQAZAAkAFwAJAGQGCQAXAAkAdAoJAHwBCQBq\nBwkAgwEJAGQACQBkBwkAhQIJABkACQAXAAkAZAAJAIMDCQChAQkAAQAJAG4ofAAJAGoICQCgAwkA\ndAEJAGQBCQBkCAkAZAAJAIMDCQChAQkAAQAJAGQACQBTACkJTnIRAAAA2gdWZ2kyU2hwdSwAAABQ\ncmV2b2Qgc8O6Ym9yb3YgVkdJIGZvcm3DoXR1IGRvIFNIUCBmb3Jtw6F0dXUUAAAATGljZW5jaWEg\ncGxhdG7DoSBkbzrpBgAAANoBLukEAAAAdSsAAAAgICAgICAgICAgICAgICAgICAgICAgIC1OZXBs\nYXRuw6EgbGljZW5jaWEtKQvaDnNldFdpbmRvd1RpdGxlcg8AAAByGAAAAHIrAAAA2ghvcGVyYXRv\nctoCbGXaEGludGVybmV0X3ZnaTJzaHDaEWNvbnZlcnRlcl92Z2kyc2hwciEAAAByJAAAANoDc3Ry\nKQJyPgAAAHIRAAAAcgUAAAByBQAAAHIHAAAAcjgAAAA7AAAAcwwAAAAAASIBJgEeASYBngJ6IVVp\nX1ZnaTJTaHBDb252ZXJ0ZXIucmV0cmFuc2xhdGVVaU4pBdoIX19uYW1lX1/aCl9fbW9kdWxlX1/a\nDF9fcXVhbG5hbWVfX3JAAAAAcjgAAAByBQAAAHIFAAAAcgUAAAByBwAAAHIQAAAAGQAAAHMEAAAA\nDgEOIXIQAAAAKRHaBVB5UXQ1cgIAAAByAwAAAHIEAAAAckYAAABaB1FTdHJpbmdaCGZyb21VdGY4\ncggAAADaDkF0dHJpYnV0ZUVycm9ycgkAAABaC1VuaWNvZGVVVEY4cgsAAAByDwAAANoGb2JqZWN0\nchAAAADaHVZnaTJTaHBDb252ZXJ0ZXIucmVzb3VyY2VzX3JjchEAAAByBQAAAHIFAAAAcgUAAABy\nBwAAANoIPG1vZHVsZT4IAAAAcxgAAAAmAQ4CAgEWARoBGgMCAQ4BFgIaARoDHis=\n'
        offset = 16
    elif magic == b'a\r\r\n': # Python 3.9
        Ui_Vgi2ShpConverter_Data = b'YQ0NCgAAAAAwr0NeQw0AAOMAAAAAAAAAAAAAAAAAAAAACAAAAEAAAABzBgEAAGQACQBkAQkAbAAJ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\nHis=\n'
        offset = 16
    else:
        raise ImportError("Unsupported Python version")

    Ui_Vgi2ShpConverter_Data = base64.decodebytes(Ui_Vgi2ShpConverter_Data)

    assert Ui_Vgi2ShpConverter_Data[:4] == magic, "Bad magic number"

    try:
        return marshal.loads(Ui_Vgi2ShpConverter_Data[offset:])
    except ValueError:
        raise ImportError("Could not read data")

exec(get_ui_vgi2shpconverter())
