# -*- coding: utf-8 -*-
"""
/***************************************************************************
 VerticalHorizon
                                 A QGIS plugin
 This plugin automatically detect horizontal and vertical lines on linestring vector data
                              -------------------
        begin                : 2015-02-13
        git sha              : $Format:%H$
        copyright            : (C) 2015 by Éric Mermet (ÉHESS)
        email                : eric.mermet@ehess.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from PyQt4.QtCore import QSettings, QTranslator, qVersion, QCoreApplication
from PyQt4.QtGui import QAction, QIcon

from PyQt4 import *
from PyQt4.QtCore import *
from PyQt4.QtGui import *
from glob import glob
from qgis.gui import *
from qgis.core import *
from qgis.utils import*

# Initialize Qt resources from file resources.py
import resources_rc
# Import the code for the dialog
from VerticalHorizon_dialog import VerticalHorizonDialog
import os.path


class VerticalHorizon:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'VerticalHorizon_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)

            if qVersion() > '4.3.3':
                QCoreApplication.installTranslator(self.translator)

        # Create the dialog (after translation) and keep reference
        self.dlg = VerticalHorizonDialog()

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&Vertige horizontal')
        # TODO: We are going to let the user set this up in a future iteration
        self.toolbar = self.iface.addToolBar(u'VerticalHorizon')
        self.toolbar.setObjectName(u'VerticalHorizon')

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('VerticalHorizon', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            self.toolbar.addAction(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/VerticalHorizon/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'Detect vertical an horizontal lines'),
            callback=self.run,
            parent=self.iface.mainWindow())


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&Vertige horizontal'),
                action)
            self.iface.removeToolBarIcon(action)


    def run(self):
        """Run method that performs all the real work"""
        # show the dialog
        self.dlg.show()
        self.dlg.cbLayer.clear()

        layers = QgsMapLayerRegistry.instance().mapLayers().values()
        for layer in layers:
            if layer.type() == QgsMapLayer.VectorLayer:
                self.dlg.cbLayer.addItem(layer.name(), layer)

        # Run the dialog event loop
        result = self.dlg.exec_()
        # See if OK was pressed
        if result:
            # Do something useful here - delete the line containing pass and
            # substitute with your code.

            # Get selected layer
            indexCbLayer = self.dlg.cbLayer.currentIndex()
            layer = self.dlg.cbLayer.itemData(indexCbLayer)

            #Get triggers
            horizontal_trigger = float(self.dlg.txt_horizontal_trigger.toPlainText())
            vertical_trigger = float(self.dlg.txt_vertical_trigger.toPlainText())
            diagonal_trigger = float(self.dlg.txt_diagonal_trigger.toPlainText())

            #Get fields
            #indexAttribute = self.dlg.cbSkeletiseAttribute.currentIndex()
            #field = self.dlg.cbSkeletiseAttribute.itemData(indexAttribute)

            newAttributeSK = 'hori_verti'

            #Add new field for skeleton attribute
            caps = layer.dataProvider().capabilities()
            if caps & QgsVectorDataProvider.AddAttributes:
                res = layer.dataProvider().addAttributes([QgsField(newAttributeSK, QVariant.String)])

            #Update modified layer
            layer.updateFields()

            #Iterate over features and apply skeletisation
            iter = layer.getFeatures()
            cpt = 0

            idxNewAttribute = layer.fieldNameIndex(newAttributeSK)

            # Enter editing mode
            layer.startEditing()

            cpt_feature = 0
            for feature in iter:

                #print("_________________")

                #print str(feature.geometry().boundingBox().width()) + " " + str(feature.geometry().boundingBox().height())

                if( feature.geometry() ):

                    width = feature.geometry().boundingBox().width()
                    height = feature.geometry().boundingBox().height()

                    if( width == 0):
                        layer.changeAttributeValue(feature.id(), idxNewAttribute, "v")
                        continue
                    if( height == 0):
                        layer.changeAttributeValue(feature.id(), idxNewAttribute, "h")
                        continue

                    ratio_vertical = float(width / height)
                    ratio_horizontal = float(1/ratio_vertical)

                    #print "ratio_vertical : " + str(ratio_vertical)
                    #print "ratio_horizontal : " + str(ratio_horizontal)

                    if( ratio_horizontal <= horizontal_trigger ):
                        #print "horizontal"
                        layer.changeAttributeValue(feature.id(), idxNewAttribute, "h")
                    else:
                        if( ratio_vertical <=  vertical_trigger ):
                            #print "vertical"
                            layer.changeAttributeValue(feature.id(), idxNewAttribute, "v")
                        else:
                            if( (ratio_vertical >= diagonal_trigger) | (ratio_horizontal >= diagonal_trigger) ):
                                #print "diagonal"
                                layer.changeAttributeValue(feature.id(), idxNewAttribute, "d")
                            else:
                                #print "undefined"
                                layer.changeAttributeValue(feature.id(), idxNewAttribute, "u")

                    cpt_feature = cpt_feature + 1
                    if cpt_feature % 100 == 0:
                        print str(cpt_feature) #+ ' / ' + len(layer.getFeatures(

            # Commit changes
            layer.commitChanges()

            pass