# -*- coding: utf-8 -*-
"""
/***************************************************************************
 VectorRubberDockWidget
                                 A QGIS plugin
 This plugin allows removing features from multiple vector layers at once.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2026-01-24
        git sha              : $Format:%H$
        copyright            : (C) 2026 by Natalia Budzińska
        email                : nataliabudzinska348@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os
from qgis.PyQt import QtGui, QtWidgets, uic
from qgis.PyQt.QtCore import pyqtSignal
from qgis.gui import QgsMapToolExtent
from qgis.core import *
import qgis.utils
from qgis.utils import iface
from qgis.PyQt.QtWidgets import QListWidgetItem, QAction, QAbstractItemView
from qgis.PyQt.QtCore import Qt
from qgis.PyQt.QtWidgets import QMessageBox

FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'vector_rubber_dockwidget_base.ui'))

class VectorRubberDockWidget(QtWidgets.QDockWidget, FORM_CLASS):

    closingPlugin = pyqtSignal()

    def __init__(self, parent=None):
        super(VectorRubberDockWidget, self).__init__(parent)
        self.setupUi(self)

        self.rectangle = None
        self.layers_checked = []
        self.tool = None
        self.modified_layers_history = []

        self.fill_listWidget_with_layers()

        self.pb_select.clicked.connect(self.select_layers)
        self.pb_uncheck.clicked.connect(self.uncheck_layers)

        self.pb_confirm_layers.clicked.connect(lambda : self.enable_widget(self.pb_undo))
        self.pb_confirm_layers.clicked.connect(self.start_map_tool)

        self.pb_confirm_layers.clicked.connect(lambda : self.enable_widget(self.pb_save))
        self.pb_undo.clicked.connect(self.undo_last_operation)

        self.pb_save.clicked.connect(self.save_changes_and_finish)

    def save_changes_and_finish(self):
        layers = self.layers_checked
        for layer_id in layers:
            layer = QgsProject.instance().mapLayer(layer_id)
            if layer:
                layer.commitChanges()
        if self.tool:
            iface.mapCanvas().unsetMapTool(self.tool)

        self.modified_layers_history.clear()
        self.pb_undo.setEnabled(False)
        self.pb_save.setEnabled(False)
        
    def start_map_tool(self):
        self.rectangle = None
        canvas = iface.mapCanvas()
        self.tool = QgsMapToolExtent(canvas)
        self.tool.extentChanged.connect(self.select_feats_and_delete)
        canvas.setMapTool(self.tool)
        
    def select_feats_and_delete(self, rect):
        self.rectangle = rect
        canvas = iface.mapCanvas()
        mupp = canvas.mapSettings().mapUnitsPerPixel()
        if rect.width() < (5 * mupp) and rect.height() < (5 * mupp):
            QMessageBox.information(
                self,
                "Vector Rubber",
                "Single click detected.\n\n"
                "To delete features, please click and drag to draw a rectangle over the area."
            )
            return

        canvas_crs = canvas.mapSettings().destinationCrs()
        list_layers_ids_to_modify = []
        for x in range(self.list_layers.count()):
            item = self.list_layers.item(x)
            if item.checkState() == Qt.Checked:
                list_layers_ids_to_modify.append(item.data(Qt.UserRole))

        self.layers_checked = list_layers_ids_to_modify
        current_step_layers = []
        total_deleted_count = 0

        for layer_id in list_layers_ids_to_modify:
            layer = QgsProject.instance().mapLayer(layer_id)

            if not layer:
                continue

            ct = QgsCoordinateTransform(canvas_crs, layer.crs(), QgsProject.instance())
            try:
                layer_rect = ct.transform(self.rectangle)
            except:
                continue
            
            req = QgsFeatureRequest().setFilterRect(layer_rect)
            req.setFlags(QgsFeatureRequest.NoGeometry)
            
            ids_to_delete = [f.id() for f in layer.getFeatures(req)]
            
            if not ids_to_delete:
                continue

            if not layer.isEditable():
                layer.startEditing()

            current_step_layers.append(layer)

            layer.beginEditCommand("Vector Rubber Delete")
            layer.deleteFeatures(ids_to_delete)
            layer.endEditCommand()
            total_deleted_count += len(ids_to_delete)

        if current_step_layers:
            self.modified_layers_history.append(current_step_layers)
            self.enable_widget(self.pb_undo)

            iface.messageBar().pushMessage("Vector Rubber", f"Deleted {total_deleted_count} features.", level=3)
        else:
            iface.messageBar().pushMessage("Vector Rubber", "No features found in the selected area.", level=3)

    def undo_last_operation(self):
        if self.modified_layers_history:
            last_step_layers = self.modified_layers_history.pop()
            for layer in last_step_layers:
                layer.undoStack().undo()
                layer.triggerRepaint()

    def enable_widget(self, widget):
        widget.setEnabled(True)

    def fill_listWidget_with_layers(self):
        self.list_layers.clear()

        for layer in QgsProject.instance().mapLayers().values():
            if isinstance(layer, QgsVectorLayer):

                item = QListWidgetItem(layer.name())
                item.setData(Qt.UserRole, layer.id())
                item.setFlags(item.flags() | Qt.ItemIsUserCheckable)
                item.setCheckState(Qt.Unchecked)
                self.list_layers.addItem(item)
        self.list_layers.setSelectionMode(QAbstractItemView.ExtendedSelection)

    def select_layers(self):
        for x in range(self.list_layers.count()):
            item = self.list_layers.item(x)
            item.setCheckState(Qt.Checked)
            
    def uncheck_layers(self):
        for x in range(self.list_layers.count()):
            item = self.list_layers.item(x)
            item.setCheckState(Qt.Unchecked) 

    def closeEvent(self, event):
        if self.tool:
            iface.mapCanvas().unsetMapTool(self.tool)
        self.closingPlugin.emit()
        event.accept()
