# -*- coding: utf-8 -*-
"""
/***************************************************************************
 UnzipFile
                                 A QGIS plugin
 UnzipFile
                              -------------------
        begin                : 2014-04-11
        copyright            : (C) 2014 by Sathish
        email                : sathishkum1991@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
# Import the PyQt and QGIS libraries
from PyQt4.QtCore import *
from PyQt4.QtGui import *
from qgis.core import *
# Initialize Qt resources from file resources.py
import resources_rc
# Import the code for the dialog
from unzipfiledialog import UnzipFileDialog
import os.path
import zipfile


class UnzipFile:

    def __init__(self, iface):
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value("locale/userLocale")[0:2]
        localePath = os.path.join(self.plugin_dir, 'i18n', 'unzipfile_{}.qm'.format(locale))

        if os.path.exists(localePath):
            self.translator = QTranslator()
            self.translator.load(localePath)

            if qVersion() > '4.3.3':
                QCoreApplication.installTranslator(self.translator)

        # Create the dialog (after translation) and keep reference
        self.dlg = UnzipFileDialog()

    def initGui(self):
        # Create action that will start plugin configuration
        self.action = QAction(
            QIcon(":/plugins/unzipfile/icon.png"),
            u"UnzipFile", self.iface.mainWindow())
        # connect the action to the run method
        self.action.triggered.connect(self.run)

        # Add toolbar button and menu item
        self.iface.addToolBarIcon(self.action)
        self.iface.addPluginToMenu(u"&UnzipFile", self.action)

    def unload(self):
        # Remove the plugin menu item and icon
        self.iface.removePluginMenu(u"&UnzipFile", self.action)
        self.iface.removeToolBarIcon(self.action)

    # run method that performs all the real work
    def run(self):
        self.UnzipFile()
        FolderName = "C:\UnzippedFolder"
        if not os.listdir(FolderName):
          QMessageBox.information( self.iface.mainWindow(),"Info","Folder already exists.")
          return
        else :
            DestMsg ="FILES WILL BE FOUND IN THE FOLLOWING DIRECTORY : " +FolderName
            QMessageBox.information( self.iface.mainWindow(),"Info",DestMsg)



    def UnzipFile(self):
        global OutputPathRestore

        ZippedFolderName = "UnzippedFolder"
        filename = QFileDialog.getOpenFileNames(None,"Open Zipped Files","C:\\",'*.zip' )
        filename1= str(filename)
        fileName2=filename1.strip('[u')
        fileName2=fileName2.replace("'","")
        fileName2=fileName2.strip(']')
        OutputPathRestore =str(fileName2)
        #print "The Selected Zipped Folder is : "+OutputPathRestore
        FolderName = "C:\UnzippedFolder"
        if os.path.exists(FolderName):
            return
        else :
            zfile = zipfile.ZipFile(OutputPathRestore)
            for name in zfile.namelist():
              (dirname, filename) = os.path.split(name)
              dirname1 = FolderName +'/'+dirname

              if not os.path.exists(dirname1):
                os.makedirs(dirname1)

              zfile.extract(name, FolderName)


